/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.MMAPISoundManagerImp;
import ca.jamdat.flight.SoundPlayer;
import ca.jamdat.flight.SpecConstants;

public class SoundManager {
    public MMAPISoundManagerImp mImplementor;
    public SoundPlayer[] mChannels = null;
    public short mMasterVolume = (short)255;
    public short mScaledMasterVolume;
    public boolean mIsMuted;
    public boolean mIsPauseSoundsOnInterrupt;

    public SoundManager() {
        this.mImplementor = new MMAPISoundManagerImp();
        this.mScaledMasterVolume = this.CalculateScaledMasterVolume();
        FrameworkGlobals.GetInstance().soundManager = this;
        this.mChannels = SoundPlayer.InstArraySoundPlayer(1);
    }

    public static SoundManager Get() {
        if (FrameworkGlobals.GetInstance().soundManager == null) {
            FrameworkGlobals.GetInstance().soundManager = new SoundManager();
        }
        return FrameworkGlobals.GetInstance().soundManager;
    }

    public void destruct() {
        this.mChannels = null;
    }

    public SoundPlayer GetChannelSoundPlayer(int n2) {
        return this.mChannels[n2];
    }

    public void SetMuted(boolean bl) {
        this.mImplementor.SetMuted(bl);
    }

    public boolean IsMuted() {
        return this.mImplementor.IsMuted();
    }

    public void SetPauseSoundsOnInterrupt() {
        this.mIsPauseSoundsOnInterrupt = true;
    }

    public boolean IsPauseSoundsOnInterrupt() {
        return this.mIsPauseSoundsOnInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PauseAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            for (int i2 = 0; i2 < 1; ++i2) {
                this.mChannels[i2].Pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ResumeAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            for (int i2 = 0; i2 < 1; ++i2) {
                if (!this.mChannels[i2].IsPaused()) continue;
                this.mChannels[i2].Play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StopAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            for (int i2 = 0; i2 < 1; ++i2) {
                this.mChannels[i2].Stop();
            }
        }
    }

    public void SetMasterVolume(short s2) {
        if (s2 > 255) {
            s2 = (short)255;
        }
        if (s2 < 0) {
            s2 = 0;
        }
        this.mMasterVolume = s2;
        this.mScaledMasterVolume = this.CalculateScaledMasterVolume();
        for (int i2 = 0; i2 < 1; ++i2) {
            this.mChannels[i2].SetNativeVolume();
        }
        FrameworkGlobals.GetInstance().application.OnMasterVolumeChange(s2);
    }

    public short GetMasterVolume() {
        return this.mMasterVolume;
    }

    public short GetScaledMasterVolume() {
        return this.mScaledMasterVolume;
    }

    public static void IncMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume + 51));
    }

    public static void DecMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume - 51));
    }

    public static int CalculateNativePlayerVolume(short s2, int n2) {
        return n2 * s2 * FrameworkGlobals.GetInstance().soundManager.GetScaledMasterVolume() >> 16;
    }

    public short CalculateScaledMasterVolume() {
        if (SpecConstants.GetMasterVolumeScaleFactor() > 0) {
            return (short)(this.mMasterVolume << (short)SpecConstants.GetMasterVolumeScaleFactor());
        }
        if (SpecConstants.GetMasterVolumeScaleFactor() < 0) {
            return (short)(this.mMasterVolume >> (short)(-SpecConstants.GetMasterVolumeScaleFactor()));
        }
        return this.mMasterVolume;
    }

    public static int CalculateNativePlayerVolume(short s2) {
        return SoundManager.CalculateNativePlayerVolume(s2, 100);
    }

    public static SoundManager[] InstArraySoundManager(int n2) {
        SoundManager[] soundManagerArray = new SoundManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            soundManagerArray[i2] = new SoundManager();
        }
        return soundManagerArray;
    }

    public static SoundManager[][] InstArraySoundManager(int n2, int n3) {
        SoundManager[][] soundManagerArray = new SoundManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            soundManagerArray[i2] = new SoundManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                soundManagerArray[i2][i3] = new SoundManager();
            }
        }
        return soundManagerArray;
    }

    public static SoundManager[][][] InstArraySoundManager(int n2, int n3, int n4) {
        SoundManager[][][] soundManagerArray = new SoundManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            soundManagerArray[i2] = new SoundManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                soundManagerArray[i2][i3] = new SoundManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    soundManagerArray[i2][i3][i4] = new SoundManager();
                }
            }
        }
        return soundManagerArray;
    }
}

