/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Stream;

public class MemoryStream
extends Stream {
    public static final short MemoryStreamStaticAllocation = 0;
    public static final short MemoryStreamDynamicAllocation = 1;
    public byte[] mData;
    public int mDynSize;
    public int mPosition;
    public short mType;
    public byte[] mTmpArray = new byte[4];

    public MemoryStream() {
        this.mData = null;
        this.mDynSize = 0;
        this.mPosition = 0;
        this.mType = 0;
    }

    public MemoryStream(byte[] byArray) {
        this.SetMemoryStream(byArray);
    }

    public void destruct() {
        if (this.mType != 1) {
            this.mData = null;
        }
    }

    public void SetMemoryStream(byte[] byArray) {
        this.mType = 0;
        this.mData = byArray;
        this.mDynSize = 0;
        this.mPosition = 0;
    }

    public void SetType(short s2) {
        this.mType = s2;
    }

    public byte[] GetDataPointer() {
        return this.mData;
    }

    public void Skip(int n2) {
        this.mPosition += n2;
    }

    public int Read(byte[] byArray, int n2) {
        Memory.Copy(byArray, 0, this.mData, this.mPosition, n2);
        this.Skip(n2);
        return 0;
    }

    public int Write(byte[] byArray, int n2) {
        Memory.Copy(this.mData, this.mPosition, byArray, 0, n2);
        this.Skip(n2);
        return 0;
    }

    public int GetPosition() {
        return this.mPosition;
    }

    public void SetPosition(int n2) {
        this.mPosition = n2;
    }

    public byte ReadByte() {
        return this.mData[this.mPosition++];
    }

    public short ReadShort() {
        short s2 = (short)(((this.mData[this.mPosition] & 0xFF) << 8) + (this.mData[this.mPosition + 1] & 0xFF));
        this.mPosition += 2;
        return s2;
    }

    public int ReadLong() {
        byte[] byArray = this.mData;
        int n2 = this.mPosition;
        int n3 = (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
        this.mPosition += 4;
        return n3;
    }

    public FlString ReadString() {
        short s2 = this.ReadShort();
        byte[] byArray = new byte[s2 + 1];
        if (s2 != 0) {
            this.Read(byArray, s2 * 1);
        }
        byArray[s2] = 0;
        FlString flString = new FlString(byArray);
        byArray = null;
        return flString;
    }

    public void WriteByte(byte by) {
        this.mTmpArray[0] = by;
        this.Write(this.mTmpArray, 1);
    }

    public void WriteShort(short s2) {
        this.mTmpArray[0] = (byte)(0xFF & s2 >> 8);
        this.mTmpArray[1] = (byte)(0xFF & s2);
        this.Write(this.mTmpArray, 2);
    }

    public void WriteLong(int n2) {
        byte[] byArray = this.mTmpArray;
        byArray[0] = (byte)(0xFF & n2 >> 24);
        byArray[1] = (byte)(0xFF & n2 >> 16);
        byArray[2] = (byte)(0xFF & n2 >> 8);
        byArray[3] = (byte)(0xFF & n2);
        this.Write(byArray, 4);
    }

    public void WriteString(FlString flString) {
        flString.Write(this);
    }

    public void WriteText(FlString flString) {
        flString.Write(this, false);
    }

    public static MemoryStream[] InstArrayMemoryStream(int n2) {
        MemoryStream[] memoryStreamArray = new MemoryStream[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            memoryStreamArray[i2] = new MemoryStream();
        }
        return memoryStreamArray;
    }

    public static MemoryStream[][] InstArrayMemoryStream(int n2, int n3) {
        MemoryStream[][] memoryStreamArray = new MemoryStream[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            memoryStreamArray[i2] = new MemoryStream[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                memoryStreamArray[i2][i3] = new MemoryStream();
            }
        }
        return memoryStreamArray;
    }

    public static MemoryStream[][][] InstArrayMemoryStream(int n2, int n3, int n4) {
        MemoryStream[][][] memoryStreamArray = new MemoryStream[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            memoryStreamArray[i2] = new MemoryStream[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                memoryStreamArray[i2][i3] = new MemoryStream[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    memoryStreamArray[i2][i3][i4] = new MemoryStream();
                }
            }
        }
        return memoryStreamArray;
    }
}

