/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

public class BlVector {
    public Object[] mObjects = null;
    public int mCapacity;
    public int mSize;
    public int mIncrement;

    public BlVector() {
        this.mCapacity = 5;
        this.mIncrement = 1;
        this.mObjects = this.AllocateArray(this.mCapacity);
    }

    public BlVector(int n2, int n3) {
        this.mCapacity = n2;
        this.mIncrement = n3;
        if (this.mCapacity > 0 && this.mIncrement >= 0) {
            this.mObjects = this.AllocateArray(n2);
        }
    }

    public void destruct() {
        this.mObjects = null;
    }

    public int GetCapacity() {
        return this.mCapacity;
    }

    public int GetSize() {
        return this.mSize;
    }

    public boolean IsEmpty() {
        return this.mSize == 0;
    }

    public boolean IsFull() {
        return this.mIncrement == 0 && this.mSize == this.mCapacity;
    }

    public Object GetAt(int n2) {
        if (n2 >= 0 && n2 < this.mSize) {
            return this.mObjects[n2];
        }
        return null;
    }

    public Object SetAt(int n2, Object object) {
        Object object2 = null;
        if (n2 >= 0 && n2 < this.mSize) {
            object2 = this.mObjects[n2];
            this.mObjects[n2] = object;
        }
        return object2;
    }

    public void InsertAt(int n2, Object object) {
        if (n2 >= 0 && n2 <= this.mSize) {
            if (this.mSize == this.mCapacity && this.mIncrement > 0) {
                this.IncreaseCapacity();
            }
            if (!this.IsFull()) {
                if (!this.IsEmpty()) {
                    for (int i2 = this.mSize; i2 > n2; --i2) {
                        this.mObjects[i2] = this.mObjects[i2 - 1];
                    }
                }
                this.mObjects[n2] = object;
                ++this.mSize;
            }
        }
    }

    public void Append(Object object) {
        this.InsertAt(this.mSize, object);
    }

    public void Append(BlVector blVector) {
        int n2 = blVector.GetSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Append(blVector.GetAt(i2));
        }
    }

    public Object RemoveAt(int n2) {
        Object object = null;
        if (n2 >= 0 && n2 < this.mSize) {
            object = this.mObjects[n2];
            for (int i2 = n2; i2 < this.mSize - 1; ++i2) {
                this.mObjects[i2] = this.mObjects[i2 + 1];
            }
            --this.mSize;
            this.mObjects[this.mSize] = null;
        }
        return object;
    }

    public void Remove(Object object) {
        int n2 = this.Find(object, 0);
        if (n2 >= 0) {
            this.RemoveAt(n2);
        }
    }

    public void RemoveRange(int n2, int n3) {
        if (n2 >= 0 && n2 < this.mSize) {
            while (n3 > 0 && !this.IsEmpty()) {
                this.RemoveAt(n2);
                --n3;
            }
        }
    }

    public void RemoveAll(Object object) {
        int n2 = this.Find(object, 0);
        while (n2 >= 0) {
            this.RemoveAt(n2);
            n2 = this.Find(object, n2);
        }
    }

    public void Clear() {
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            this.mObjects[i2] = null;
        }
        this.mSize = 0;
    }

    public int Find(Object object) {
        return this.Find(object, 0);
    }

    public int Find(Object object, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i2 = n2; i2 < this.mSize; ++i2) {
            if (this.mObjects[i2] != object) continue;
            return i2;
        }
        return -1;
    }

    public int ToArray(Object[] objectArray, int n2) {
        int n3 = 0;
        if (objectArray != null) {
            for (int i2 = 0; i2 < n2 && i2 < this.mSize; ++i2) {
                objectArray[i2] = this.mObjects[i2];
                ++n3;
            }
        }
        return n3;
    }

    public BlVector(BlVector blVector) {
    }

    public Object[] AllocateArray(int n2) {
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = null;
        }
        return objectArray;
    }

    public void IncreaseCapacity() {
        int n2 = this.mCapacity + this.mIncrement;
        Object[] objectArray = this.mObjects;
        this.mObjects = this.AllocateArray(n2);
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            this.mObjects[i2] = objectArray[i2];
        }
        this.mCapacity = n2;
        objectArray = null;
    }

    public static BlVector[] InstArrayBlVector(int n2) {
        BlVector[] blVectorArray = new BlVector[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blVectorArray[i2] = new BlVector();
        }
        return blVectorArray;
    }

    public static BlVector[][] InstArrayBlVector(int n2, int n3) {
        BlVector[][] blVectorArray = new BlVector[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blVectorArray[i2] = new BlVector[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                blVectorArray[i2][i3] = new BlVector();
            }
        }
        return blVectorArray;
    }

    public static BlVector[][][] InstArrayBlVector(int n2, int n3, int n4) {
        BlVector[][][] blVectorArray = new BlVector[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blVectorArray[i2] = new BlVector[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                blVectorArray[i2][i3] = new BlVector[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    blVectorArray[i2][i3][i4] = new BlVector();
                }
            }
        }
        return blVectorArray;
    }
}

