/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlConstants;
import ca.jamdat.flight.BlMath;
import ca.jamdat.flight.BlStringBuffer;
import ca.jamdat.flight.BlStringBufferAscii;
import ca.jamdat.flight.BlStringBufferUtf16;

public class BlString {
    public static String ENC_ASCII = "ASCII";
    public static String ENC_UTF8 = "UTF-8";
    public static String ENC_UTF16BE = "UTF-16BE";
    public static String ENC_UTF32BE = "UTF-32BE";
    public static String ENC_ISO_8859_1 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    public static String ENC_ISO_8859_2 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0104\u02d8\u0141\u00a4\u013d\u015a\u00a7\u00a8\u0160\u015e\u0164\u0179\u00ad\u017d\u017b\u00b0\u0105\u02db\u0142\u00b4\u013e\u015b\u02c7\u00b8\u0161\u015f\u0165\u017a\u02dd\u017e\u017c\u0154\u00c1\u00c2\u0102\u00c4\u0139\u0106\u00c7\u010c\u00c9\u0118\u00cb\u011a\u00cd\u00ce\u010e\u0110\u0143\u0147\u00d3\u00d4\u0150\u00d6\u00d7\u0158\u016e\u00da\u0170\u00dc\u00dd\u0162\u00df\u0155\u00e1\u00e2\u0103\u00e4\u013a\u0107\u00e7\u010d\u00e9\u0119\u00eb\u011b\u00ed\u00ee\u010f\u0111\u0144\u0148\u00f3\u00f4\u0151\u00f6\u00f7\u0159\u016f\u00fa\u0171\u00fc\u00fd\u0163\u02d9";
    public static String ENC_ISO_8859_3 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0126\u02d8\u00a3\u00a4\ufffd\u0124\u00a7\u00a8\u0130\u015e\u011e\u0134\u00ad\ufffd\u017b\u00b0\u0127\u00b2\u00b3\u00b4\u00b5\u0125\u00b7\u00b8\u0131\u015f\u011f\u0135\u00bd\ufffd\u017c\u00c0\u00c1\u00c2\ufffd\u00c4\u010a\u0108\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\ufffd\u00d1\u00d2\u00d3\u00d4\u0120\u00d6\u00d7\u011c\u00d9\u00da\u00db\u00dc\u016c\u015c\u00df\u00e0\u00e1\u00e2\ufffd\u00e4\u010b\u0109\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\ufffd\u00f1\u00f2\u00f3\u00f4\u0121\u00f6\u00f7\u011d\u00f9\u00fa\u00fb\u00fc\u016d\u015d\u02d9";
    public static String ENC_ISO_8859_4 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0104\u0138\u0156\u00a4\u0128\u013b\u00a7\u00a8\u0160\u0112\u0122\u0166\u00ad\u017d\u00af\u00b0\u0105\u02db\u0157\u00b4\u0129\u013c\u02c7\u00b8\u0161\u0113\u0123\u0167\u014a\u017e\u014b\u0100\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u012e\u010c\u00c9\u0118\u00cb\u0116\u00cd\u00ce\u012a\u0110\u0145\u014c\u0136\u00d4\u00d5\u00d6\u00d7\u00d8\u0172\u00da\u00db\u00dc\u0168\u016a\u00df\u0101\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u012f\u010d\u00e9\u0119\u00eb\u0117\u00ed\u00ee\u012b\u0111\u0146\u014d\u0137\u00f4\u00f5\u00f6\u00f7\u00f8\u0173\u00fa\u00fb\u00fc\u0169\u016b\u02d9";
    public static String ENC_ISO_8859_5 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u00ad\u040e\u040f\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u2116\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u00a7\u045e\u045f";
    public static String ENC_ISO_8859_6 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\ufffd\ufffd\ufffd\u00a4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u060c\u00ad\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u061b\ufffd\ufffd\ufffd\u061f\ufffd\u0621\u0622\u0623\u0624\u0625\u0626\u0627\u0628\u0629\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0639\u063a\ufffd\ufffd\ufffd\ufffd\ufffd\u0640\u0641\u0642\u0643\u0644\u0645\u0646\u0647\u0648\u0649\u064a\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
    public static String ENC_ISO_8859_7 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u2018\u2019\u00a3\u20ac\u20af\u00a6\u00a7\u00a8\u00a9\u037a\u00ab\u00ac\u00ad\ufffd\u2015\u00b0\u00b1\u00b2\u00b3\u0384\u0385\u0386\u00b7\u0388\u0389\u038a\u00bb\u038c\u00bd\u038e\u038f\u0390\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\ufffd\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9\u03aa\u03ab\u03ac\u03ad\u03ae\u03af\u03b0\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ca\u03cb\u03cc\u03cd\u03ce\ufffd";
    public static String ENC_ISO_8859_8 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\ufffd\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00d7\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00f7\u00bb\u00bc\u00bd\u00be\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u2017\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05da\u05db\u05dc\u05dd\u05de\u05df\u05e0\u05e1\u05e2\u05e3\u05e4\u05e5\u05e6\u05e7\u05e8\u05e9\u05ea\ufffd\ufffd\u200e\u200f\ufffd";
    public static String ENC_ISO_8859_9 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u011e\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u0130\u015e\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u011f\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u0131\u015f\u00ff";
    public static String ENC_ISO_8859_10 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0104\u0112\u0122\u012a\u0128\u0136\u00a7\u013b\u0110\u0160\u0166\u017d\u00ad\u016a\u014a\u00b0\u0105\u0113\u0123\u012b\u0129\u0137\u00b7\u013c\u0111\u0161\u0167\u017e\u2015\u016b\u014b\u0100\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u012e\u010c\u00c9\u0118\u00cb\u0116\u00cd\u00ce\u00cf\u00d0\u0145\u014c\u00d3\u00d4\u00d5\u00d6\u0168\u00d8\u0172\u00da\u00db\u00dc\u00dd\u00de\u00df\u0101\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u012f\u010d\u00e9\u0119\u00eb\u0117\u00ed\u00ee\u00ef\u00f0\u0146\u014d\u00f3\u00f4\u00f5\u00f6\u0169\u00f8\u0173\u00fa\u00fb\u00fc\u00fd\u00fe\u0138";
    public static String ENC_ISO_8859_11 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0e01\u0e02\u0e03\u0e04\u0e05\u0e06\u0e07\u0e08\u0e09\u0e0a\u0e0b\u0e0c\u0e0d\u0e0e\u0e0f\u0e10\u0e11\u0e12\u0e13\u0e14\u0e15\u0e16\u0e17\u0e18\u0e19\u0e1a\u0e1b\u0e1c\u0e1d\u0e1e\u0e1f\u0e20\u0e21\u0e22\u0e23\u0e24\u0e25\u0e26\u0e27\u0e28\u0e29\u0e2a\u0e2b\u0e2c\u0e2d\u0e2e\u0e2f\u0e30\u0e31\u0e32\u0e33\u0e34\u0e35\u0e36\u0e37\u0e38\u0e39\u0e3a\ufffd\ufffd\ufffd\ufffd\u0e3f\u0e40\u0e41\u0e42\u0e43\u0e44\u0e45\u0e46\u0e47\u0e48\u0e49\u0e4a\u0e4b\u0e4c\u0e4d\u0e4e\u0e4f\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59\u0e5a\u0e5b\ufffd\ufffd\ufffd\ufffd";
    public static String ENC_ISO_8859_13 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u201d\u00a2\u00a3\u00a4\u201e\u00a6\u00a7\u00d8\u00a9\u0156\u00ab\u00ac\u00ad\u00ae\u00c6\u00b0\u00b1\u00b2\u00b3\u201c\u00b5\u00b6\u00b7\u00f8\u00b9\u0157\u00bb\u00bc\u00bd\u00be\u00e6\u0104\u012e\u0100\u0106\u00c4\u00c5\u0118\u0112\u010c\u00c9\u0179\u0116\u0122\u0136\u012a\u013b\u0160\u0143\u0145\u00d3\u014c\u00d5\u00d6\u00d7\u0172\u0141\u015a\u016a\u00dc\u017b\u017d\u00df\u0105\u012f\u0101\u0107\u00e4\u00e5\u0119\u0113\u010d\u00e9\u017a\u0117\u0123\u0137\u012b\u013c\u0161\u0144\u0146\u00f3\u014d\u00f5\u00f6\u00f7\u0173\u0142\u015b\u016b\u00fc\u017c\u017e\u2019";
    public static String ENC_ISO_8859_14 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u1e02\u1e03\u00a3\u010a\u010b\u1e0a\u00a7\u1e80\u00a9\u1e82\u1e0b\u1ef2\u00ad\u00ae\u0178\u1e1e\u1e1f\u0120\u0121\u1e40\u1e41\u00b6\u1e56\u1e81\u1e57\u1e83\u1e60\u1ef3\u1e84\u1e85\u1e61\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u0174\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u1e6a\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u0176\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u0175\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u1e6b\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u0177\u00ff";
    public static String ENC_ISO_8859_15 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u20ac\u00a5\u0160\u00a7\u0161\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u017d\u00b5\u00b6\u00b7\u017e\u00b9\u00ba\u00bb\u0152\u0153\u0178\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    public static String ENC_ISO_8859_16 = "\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u0104\u0105\u0141\u20ac\u201e\u0160\u00a7\u0161\u00a9\u0218\u00ab\u0179\u00ad\u017a\u017b\u00b0\u00b1\u010c\u0142\u017d\u201d\u00b6\u00b7\u017e\u010d\u0219\u00bb\u0152\u0153\u0178\u017c\u00c0\u00c1\u00c2\u0102\u00c4\u0106\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u0110\u0143\u00d2\u00d3\u00d4\u0150\u00d6\u015a\u0170\u00d9\u00da\u00db\u00dc\u0118\u021a\u00df\u00e0\u00e1\u00e2\u0103\u00e4\u0107\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u0111\u0144\u00f2\u00f3\u00f4\u0151\u00f6\u015b\u0171\u00f9\u00fa\u00fb\u00fc\u0119\u021b\u00ff";
    public BlStringBuffer mBuffer;

    public BlString() {
    }

    public BlString(BlString blString) {
        this.Assign(blString);
    }

    public BlString(String string) {
        this.Assign(string);
    }

    public BlString(char c2) {
        this.Assign(c2);
    }

    public BlString(char[] cArray, int n2, int n3) {
        this.Assign(cArray, n2, n3);
    }

    public BlString(int n2) {
        this.Assign(n2);
    }

    public BlString(long l2) {
        this.Assign(l2);
    }

    public BlString(boolean bl) {
        this.Assign(bl);
    }

    public BlString(byte[] byArray, int n2, int n3, String string) {
        if (string == ENC_ASCII) {
            this.mBuffer = new BlStringBufferAscii(byArray, n2, n3, 0);
        } else if (string == ENC_UTF16BE) {
            this.mBuffer = new BlStringBufferUtf16(byArray, n2, n3);
        } else if (string == ENC_UTF32BE || string == ENC_UTF8) {
            // empty if block
        }
    }

    public void destruct() {
        if (this.mBuffer != null) {
            this.mBuffer.RemoveRef();
        }
    }

    public BlString Assign(BlString blString) {
        if (blString != this) {
            this.SetLength(0);
            this.Append(blString);
        }
        return this;
    }

    public BlString Assign(String string) {
        this.SetLength(0);
        if (string != null) {
            this.Append(string);
        }
        return this;
    }

    public BlString Assign(char c2) {
        this.SetLength(0);
        this.Append(c2);
        return this;
    }

    public BlString Assign(char[] cArray, int n2, int n3) {
        this.SetLength(0);
        this.Append(cArray, n2, n3);
        return this;
    }

    public BlString Assign(int n2) {
        this.SetLength(0);
        this.Append(n2);
        return this;
    }

    public BlString Assign(long l2) {
        this.SetLength(0);
        this.Append(l2);
        return this;
    }

    public BlString Assign(boolean bl) {
        this.SetLength(0);
        this.Append(bl);
        return this;
    }

    public BlString Append(BlString blString) {
        int n2 = blString.GetLength();
        if (n2 > 0) {
            return this.Append(blString, 0, n2);
        }
        return this;
    }

    public BlString Append(BlString blString, int n2, int n3) {
        this.EnsureCapacity(this.GetLength() + n3);
        this.Append(blString.mBuffer, n2, n3, this.mBuffer);
        return this;
    }

    public BlString Append(String string) {
        if (string != null) {
            int n2 = BlString.GetLength(string);
            this.EnsureCapacity(this.GetLength() + n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.mBuffer.AppendChar(string.charAt(i2));
            }
        }
        return this;
    }

    public BlString Append(char c2) {
        this.EnsureCapacity(this.GetLength() + 1);
        this.mBuffer.AppendChar(c2);
        return this;
    }

    public BlString Append(char[] cArray, int n2, int n3) {
        this.EnsureCapacity(this.GetLength() + n3);
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.mBuffer.AppendChar(cArray[i2]);
        }
        return this;
    }

    public BlString Append(int n2) {
        return this.Append((long)n2);
    }

    public BlString Append(long l2) {
        if (l2 == Long.MIN_VALUE) {
            return this.Append("-9223372036854775808");
        }
        int n2 = this.GetLength() + 20;
        this.EnsureCapacity(n2);
        int n3 = this.mBuffer.GetLength();
        this.mBuffer.SetLength(n2);
        boolean bl = false;
        if (l2 < 0L) {
            l2 = -l2;
            bl = true;
        }
        int n4 = n2;
        int n5 = 0;
        do {
            this.mBuffer.SetCharAt(--n4, (char)(48L + l2 % 10L));
            ++n5;
        } while ((l2 /= 10L) != 0L);
        if (bl) {
            this.mBuffer.SetCharAt(--n4, '-');
            ++n5;
        }
        int n6 = n2 - n5;
        int n7 = n3;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.mBuffer.SetCharAt(i2 + n7, this.mBuffer.GetCharAt(n6 + i2));
        }
        this.mBuffer.SetLength(n3 + n5);
        return this;
    }

    public BlString Append(boolean bl) {
        if (bl) {
            return this.Append("True");
        }
        return this.Append("False");
    }

    public boolean Equals(BlString blString) {
        if (this == blString || this.mBuffer == blString.mBuffer) {
            return true;
        }
        if (this.mBuffer == null && (blString.mBuffer == null || blString.GetLength() == 0)) {
            return true;
        }
        if (blString.mBuffer == null && this.GetLength() == 0) {
            return true;
        }
        if (this.GetLength() != blString.GetLength()) {
            return false;
        }
        int n2 = this.GetLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.mBuffer.GetCharAt(i2) == blString.mBuffer.GetCharAt(i2)) continue;
            return false;
        }
        return true;
    }

    public int Compare(BlString blString) {
        int n2 = 0;
        if (!this.Equals(blString)) {
            int n3 = this.GetLength();
            int n4 = blString.GetLength();
            int n5 = n3;
            if (n3 < n4) {
                n2 = -1;
            } else {
                n2 = 1;
                n5 = n4;
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                char c2;
                char c3 = this.GetCharAt(i2);
                if (c3 < (c2 = blString.GetCharAt(i2))) {
                    return -1;
                }
                if (c3 <= c2) continue;
                return 1;
            }
        }
        return n2;
    }

    public int GetLength() {
        if (this.mBuffer == null) {
            return 0;
        }
        return this.mBuffer.GetLength();
    }

    public void SetLength(int n2) {
        if (this.mBuffer == null && n2 > 0) {
            this.mBuffer = new BlStringBufferUtf16(n2);
            this.mBuffer.SetLength(n2);
        } else if (this.mBuffer != null && n2 <= 0) {
            if (!this.mBuffer.IsMutable() || this.mBuffer.IsShared()) {
                this.mBuffer.RemoveRef();
                this.mBuffer = null;
            } else {
                this.mBuffer.SetLength(0);
            }
        } else if (this.mBuffer != null && n2 >= 0) {
            this.mBuffer.SetLength(n2);
        }
    }

    public char GetCharAt(int n2) {
        return this.mBuffer.GetCharAt(n2);
    }

    public void SetCharAt(int n2, char c2) {
        this.EnsureCapacity(this.GetLength());
        this.mBuffer.SetCharAt(n2, c2);
    }

    public int Find(char c2) {
        return this.Find(c2, 0);
    }

    public int Find(char c2, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = -1;
        int n4 = this.GetLength();
        for (int i2 = n2; i2 < n4; ++i2) {
            if (this.mBuffer.GetCharAt(i2) != c2) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public int Find(BlString blString) {
        return this.Find(blString, 0);
    }

    public int Find(BlString blString, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = blString.GetLength();
        int n4 = this.GetLength();
        if (n2 < n4 && n3 > 0) {
            int n5 = n4 - n3;
            block0: for (int i2 = n2; i2 <= n5; ++i2) {
                char c2;
                char c3 = this.GetCharAt(i2);
                if (c3 != (c2 = blString.GetCharAt(0))) continue;
                int n6 = i2;
                int n7 = 1;
                while (n7 != n3) {
                    if (this.GetCharAt(n6 + n7) != blString.GetCharAt(n7)) continue block0;
                    ++n7;
                }
                return n6;
            }
        }
        return -1;
    }

    public boolean BeginsWith(BlString blString) {
        int n2 = blString.GetLength();
        int n3 = this.GetLength();
        if (n2 > 0 && n2 < n3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (blString.GetCharAt(i2) == this.GetCharAt(i2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean EndsWith(BlString blString) {
        int n2 = blString.GetLength();
        int n3 = this.GetLength();
        if (n2 > 0 && n2 < n3) {
            int n4 = 0;
            for (int i2 = n3 - n2; i2 < n3; ++i2) {
                if (blString.GetCharAt(n4++) == this.GetCharAt(i2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public BlString Substring(int n2, BlString blString) {
        return this.Substring(n2, this.GetLength(), blString);
    }

    public BlString Substring(int n2, int n3, BlString blString) {
        int n4;
        blString.SetLength(0);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 + n3 > (n4 = this.GetLength())) {
            n3 = n4 - n2;
        }
        blString.EnsureCapacity(n3);
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            blString.Append(this.GetCharAt(i2));
        }
        return blString;
    }

    public BlString Replace(char c2, char c3, int n2, BlString blString) {
        blString.Assign(this);
        if (n2 > 0) {
            int n3 = 0;
            int n4 = this.Find(c2, 0);
            while (n3 < n2 && n4 >= 0) {
                blString.SetCharAt(n4, c3);
                if (++n3 >= n2) continue;
                int n5 = n4 + 1;
                if (n5 < blString.GetLength()) {
                    n4 = blString.Find(c2, n5);
                    continue;
                }
                n4 = -1;
            }
        }
        return blString;
    }

    public BlString Replace(char c2, char c3, int n2) {
        return this.Replace(c2, c3, n2, this);
    }

    public BlString ReplaceAll(char c2, char c3, BlString blString) {
        return this.Replace(c2, c3, BlConstants.MAX_INT_32, blString);
    }

    public BlString ReplaceAll(char c2, char c3) {
        return this.Replace(c2, c3, BlConstants.MAX_INT_32, this);
    }

    public BlString Replace(BlString blString, BlString blString2, int n2, BlString blString3) {
        blString3.Assign(this);
        if (n2 > 0) {
            int n3 = this.GetLength();
            n2 = BlMath.Min(n2, n3);
            int n4 = this.Find(blString, 0);
            if (n4 >= 0) {
                int n5 = blString2.GetLength();
                int n6 = blString.GetLength();
                while (n2 > 0 && n4 >= 0) {
                    int n7;
                    blString3.EnsureCapacity(blString3.GetLength() + 2 * n5);
                    int n8 = blString3.GetLength() - n4 - n6;
                    if (n5 <= n6) {
                        for (n7 = 0; n7 < n5; ++n7) {
                            blString3.SetCharAt(n4 + n7, blString2.GetCharAt(n7));
                        }
                        for (n7 = 0; n7 < n8; ++n7) {
                            blString3.SetCharAt(n4 + n5 + n7, blString3.GetCharAt(n4 + n6 + n7));
                        }
                        blString3.SetLength(n4 + n5 + n8);
                    } else {
                        blString3.SetLength(n4 + n5 + n8);
                        for (n7 = 1; n7 <= n8; ++n7) {
                            blString3.SetCharAt(n4 + n5 + n8 - n7, blString3.GetCharAt(n4 + n6 + n8 - n7));
                        }
                        for (n7 = 0; n7 < n5; ++n7) {
                            blString3.SetCharAt(n4 + n7, blString2.GetCharAt(n7));
                        }
                    }
                    if (--n2 <= 0) continue;
                    n7 = n4 + n5;
                    if (n7 < blString3.GetLength()) {
                        n4 = blString3.Find(blString, n7);
                        continue;
                    }
                    n4 = -1;
                }
            }
        }
        return blString3;
    }

    public BlString Replace(BlString blString, BlString blString2, int n2) {
        return this.Replace(blString, blString2, n2, this);
    }

    public BlString ReplaceAll(BlString blString, BlString blString2, BlString blString3) {
        return this.Replace(blString, blString2, BlConstants.MAX_INT_32, blString3);
    }

    public BlString ReplaceAll(BlString blString, BlString blString2) {
        return this.Replace(blString, blString2, BlConstants.MAX_INT_32, this);
    }

    public BlString LeftStrip(BlString blString, BlString blString2) {
        blString2.Assign(this);
        int n2 = this.GetLength();
        if (n2 > 0) {
            boolean bl;
            blString2.EnsureCapacity(n2);
            boolean bl2 = bl = blString.Find(blString2.GetCharAt(0), 0) != -1;
            while (bl && n2 > 0) {
                for (int i2 = 1; i2 < n2; ++i2) {
                    blString2.SetCharAt(i2 - 1, blString2.GetCharAt(i2));
                }
                blString2.SetLength(--n2);
                if (n2 <= 0) continue;
                bl = blString.Find(blString2.GetCharAt(0), 0) != -1;
            }
        }
        return blString2;
    }

    public BlString LeftStrip(BlString blString) {
        return this.LeftStrip(blString, this);
    }

    public BlString RightStrip(BlString blString, BlString blString2) {
        blString2.Assign(this);
        int n2 = this.GetLength();
        if (n2 > 0) {
            boolean bl;
            blString2.EnsureCapacity(n2);
            boolean bl2 = bl = blString.Find(blString2.GetCharAt(n2 - 1), 0) != -1;
            while (bl && n2 > 0) {
                blString2.SetLength(--n2);
                if (n2 <= 0) continue;
                bl = blString.Find(blString2.GetCharAt(n2 - 1), 0) != -1;
            }
        }
        return blString2;
    }

    public BlString RightStrip(BlString blString) {
        return this.RightStrip(blString, this);
    }

    public BlString Strip(BlString blString, BlString blString2) {
        return this.LeftStrip(blString, blString2).RightStrip(blString);
    }

    public BlString Strip(BlString blString) {
        return this.LeftStrip(blString).RightStrip(blString);
    }

    public BlString Trim(BlString blString) {
        blString.Assign(this);
        int n2 = this.GetLength();
        if (n2 > 0) {
            blString.EnsureCapacity(n2);
            char c2 = blString.GetCharAt(n2 - 1);
            while (c2 <= ' ' && n2 > 0) {
                blString.SetLength(--n2);
                if (n2 <= 0) continue;
                c2 = blString.GetCharAt(blString.GetLength() - 1);
            }
            if (n2 > 0) {
                while (blString.GetCharAt(0) <= ' ' && n2 > 0) {
                    for (int i2 = 1; i2 < n2; ++i2) {
                        blString.SetCharAt(i2 - 1, blString.GetCharAt(i2));
                    }
                    blString.SetLength(--n2);
                }
            }
        }
        return blString;
    }

    public BlString Trim() {
        return this.Trim(this);
    }

    public boolean IsDecimal() {
        int n2 = this.GetLength();
        char c2 = '-';
        char c3 = '0';
        char c4 = '9';
        if (this.mBuffer == null) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c5 = this.mBuffer.GetCharAt(i2);
            if (c5 >= c3 && c5 <= c4 || c5 == c2 && i2 == 0) continue;
            return false;
        }
        return true;
    }

    public int ToInt32() {
        int n2 = 0;
        int n3 = this.GetLength() - 1;
        int n4 = 1;
        if (this.GetCharAt(0) == '-') {
            ++n2;
            n4 = -1;
        }
        int n5 = 0;
        int n6 = 1;
        for (int i2 = n3; i2 >= n2; --i2) {
            int n7 = this.GetCharAt(i2) - 48;
            n5 += n7 * n6;
            n6 *= 10;
        }
        return n5 * n4;
    }

    public long ToInt64() {
        int n2 = 0;
        int n3 = this.GetLength() - 1;
        int n4 = 1;
        if (this.GetCharAt(0) == '-') {
            ++n2;
            n4 = -1;
        }
        long l2 = 0L;
        long l3 = 1L;
        for (int i2 = n3; i2 >= n2; --i2) {
            long l4 = this.GetCharAt(i2) - 48;
            l2 += l4 * l3;
            l3 *= 10L;
        }
        return l2 * (long)n4;
    }

    public String ToAscii() {
        int n2 = this.GetLength();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.GetCharAt(i2);
            if (c2 > '\u007f') {
                c2 = ' ';
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public String ToUtf16() {
        int n2 = this.GetLength();
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.GetCharAt(i2));
        }
        return stringBuffer.toString();
    }

    public int GetBytes(byte[] byArray, int n2, int n3, String string) {
        int n4 = 0;
        n4 = string == ENC_ASCII ? this.ToAscii(byArray, n2, n3) : (string == ENC_UTF8 ? this.ToUtf8(byArray, n2, n3) : (string == ENC_UTF16BE ? this.ToUtf16BE(byArray, n2, n3) : (string == ENC_UTF32BE ? this.ToUtf32BE(byArray, n2, n3) : this.ToIso8859(byArray, n2, n3, string))));
        return n4;
    }

    public void EnsureCapacity(int n2) {
        if (n2 > 0) {
            if (this.mBuffer == null) {
                this.mBuffer = new BlStringBufferUtf16(n2);
            } else if (!this.mBuffer.IsMutable() || this.mBuffer.IsShared() || this.mBuffer.GetEncoding() != ENC_UTF16BE) {
                BlStringBuffer blStringBuffer = this.mBuffer;
                BlStringBufferUtf16 blStringBufferUtf16 = new BlStringBufferUtf16(BlMath.Max(n2, blStringBuffer.GetLength()));
                this.Append(blStringBuffer, 0, blStringBuffer.GetLength(), blStringBufferUtf16);
                blStringBuffer.RemoveRef();
                this.mBuffer = blStringBufferUtf16;
            } else {
                this.mBuffer.EnsureCapacity(n2);
            }
        }
    }

    public BlString(double d2) {
        this.Append(d2);
    }

    public BlString Assign(double d2) {
        this.SetLength(0);
        this.Append(d2);
        return this;
    }

    public BlString Append(double d2) {
        double d3 = d2;
        if (BlMath.IsNaN(d2)) {
            this.Append("NaN");
            return this;
        }
        int n2 = 0;
        while (BlMath.Ceil(d2) != d2) {
            d2 = d3 * (double)BlMath.Pow(10, ++n2);
        }
        int n3 = this.GetLength() + 39;
        this.EnsureCapacity(n3);
        int n4 = this.mBuffer.GetLength();
        this.mBuffer.SetLength(n3);
        boolean bl = false;
        if (d2 < 0.0) {
            d2 = -d2;
            bl = true;
        }
        int n5 = n3;
        int n6 = 0;
        int n7 = (int)d2;
        do {
            this.mBuffer.SetCharAt(--n5, (char)(48 + n7 % 10));
            n7 /= 10;
            if (--n2 == 0) {
                this.mBuffer.SetCharAt(--n5, '.');
                ++n6;
            }
            ++n6;
        } while (n7 > 0);
        if (bl) {
            this.mBuffer.SetCharAt(--n5, '-');
            ++n6;
        }
        int n8 = n3 - n6;
        int n9 = n4;
        for (int i2 = 0; i2 < n6; ++i2) {
            this.mBuffer.SetCharAt(i2 + n9, this.mBuffer.GetCharAt(n8 + i2));
        }
        this.mBuffer.SetLength(n4 + n6);
        return this;
    }

    public BlString(float f2) {
        this.Append(f2);
    }

    public BlString Assign(float f2) {
        this.SetLength(0);
        this.Append(f2);
        return this;
    }

    public BlString Append(float f2) {
        return this.Append((double)f2);
    }

    public void Append(BlStringBuffer blStringBuffer, int n2, int n3, BlStringBuffer blStringBuffer2) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            blStringBuffer2.AppendChar(blStringBuffer.GetCharAt(i2));
        }
    }

    public static int GetLength(String string) {
        return string.length();
    }

    public int ToAscii(byte[] byArray, int n2, int n3) {
        int n4 = this.GetLength();
        int n5 = BlMath.Min(n4, n3 - n2);
        int n6 = n2;
        for (int i2 = 0; i2 < n5; ++i2) {
            byArray[n6++] = (byte)this.GetCharAt(i2);
        }
        return n5;
    }

    public int ToIso8859(byte[] byArray, int n2, int n3, String string) {
        int n4 = this.GetLength();
        int n5 = BlMath.Min(n4, n3 - n2);
        int n6 = n2;
        for (int i2 = 0; i2 < n5; ++i2) {
            char c2 = this.GetCharAt(i2);
            byArray[n6++] = c2 > '\u007f' ? (byte)string.charAt(c2 - 128) : (byte)c2;
        }
        return n5;
    }

    public int ToUtf8(byte[] byArray, int n2, int n3) {
        int n4 = 128;
        int n5 = 191;
        int n6 = 0;
        int n7 = n2;
        int n8 = this.GetLength();
        for (int i2 = 0; i2 < n8; ++i2) {
            int n9;
            int n10;
            if ((n10 = this.GetCharAt(i2++)) < 128) {
                n6 = 1;
                n9 = 0;
            } else if (n10 < 2048) {
                n6 = 2;
                n9 = 192;
            } else {
                n6 = 3;
                n9 = 224;
                n10 = 65533;
            }
            if ((n7 += n6) > n3) {
                n7 -= n6;
                break;
            }
            switch (n6) {
                case 4: {
                    byArray[--n7] = (byte)((n10 | n4) & n5);
                    n10 = (char)(n10 >> 6);
                }
                case 3: {
                    byArray[--n7] = (byte)((n10 | n4) & n5);
                    n10 = (char)(n10 >> 6);
                }
                case 2: {
                    byArray[--n7] = (byte)((n10 | n4) & n5);
                    n10 = (char)(n10 >> 6);
                }
                case 1: {
                    byArray[--n7] = (byte)(n10 | n9);
                }
            }
            n7 += n6;
        }
        return n7 - n2;
    }

    public int ToUtf16BE(byte[] byArray, int n2, int n3) {
        int n4 = this.GetLength();
        int n5 = BlMath.Min(n4 * 2, n3 - n2);
        n5 -= n5 % 2;
        int n6 = n2;
        for (int i2 = 0; i2 < n5; ++i2) {
            char c2 = this.GetCharAt(i2);
            byArray[n6++] = (byte)(c2 >> 8);
            byArray[n6++] = (byte)c2;
        }
        return n5;
    }

    public int ToUtf32BE(byte[] byArray, int n2, int n3) {
        int n4 = this.GetLength();
        int n5 = BlMath.Min(n4 * 4, n3 - n2);
        n5 -= n5 % 4;
        int n6 = n2;
        for (int i2 = 0; i2 < n5 / 4; ++i2) {
            char c2 = this.GetCharAt(i2);
            byArray[n6++] = 0;
            byArray[n6++] = 0;
            byArray[n6++] = (byte)(c2 >> 8);
            byArray[n6++] = (byte)c2;
        }
        return n5;
    }

    public BlString Replace(BlString blString, BlString blString2) {
        return this.Replace(blString, blString2, 1);
    }

    public static BlString[] InstArrayBlString(int n2) {
        BlString[] blStringArray = new BlString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blStringArray[i2] = new BlString();
        }
        return blStringArray;
    }

    public static BlString[][] InstArrayBlString(int n2, int n3) {
        BlString[][] blStringArray = new BlString[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blStringArray[i2] = new BlString[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                blStringArray[i2][i3] = new BlString();
            }
        }
        return blStringArray;
    }

    public static BlString[][][] InstArrayBlString(int n2, int n3, int n4) {
        BlString[][][] blStringArray = new BlString[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blStringArray[i2] = new BlString[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                blStringArray[i2][i3] = new BlString[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    blStringArray[i2][i3][i4] = new BlString();
                }
            }
        }
        return blStringArray;
    }
}

