/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlMath;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;

public class TexasRules {
    public int mHandCounter;
    public int mCurrentBlindIdx = 0;
    public boolean mBlindsJustGotIncremented;
    public GameSettings mGameSettings = GameApp.Get().GetGameSettings();
    public int mChipsDistributedSoFarThisRound;
    public int mNbOfTimesStacksRefilledThisRound;

    public void destruct() {
    }

    public void Initialize(int n2) {
        this.mHandCounter = n2;
        this.mCurrentBlindIdx = this.mGameSettings.GetBlind();
    }

    public int GetInitialStack() {
        int n2 = -1;
        n2 = this.mGameSettings.IsCurrentModeTournament() ? this.DetermineInitialTournamentStack() : (this.mGameSettings.IsPractice() ? 1000 : (this.mGameSettings.IsCurrentModeHeadsUp() ? GameSettings.GetBuyInCostStatic(this.mGameSettings.GetLocation(), 0) : (this.mGameSettings.IsCurrentModeProGame() ? 1000 : GameSettings.GetBuyInCostStatic(this.mGameSettings.GetLocation(), 1))));
        return n2;
    }

    public int GetSmallBlindValue() {
        int n2 = this.mGameSettings.IsCurrentModeTournament() ? 7 : 4;
        int n3 = this.mGameSettings.IsCurrentModeTournament() ? 5 : 3;
        return this.mGameSettings.GetSmallBlindCost(this.mGameSettings.GetLocation(), this.mCurrentBlindIdx < n2 ? this.mCurrentBlindIdx : n3);
    }

    public int GetBigBlindValue() {
        int n2 = this.mGameSettings.IsCurrentModeTournament() ? 7 : 4;
        int n3 = this.mGameSettings.IsCurrentModeTournament() ? 5 : 3;
        return this.mGameSettings.GetBigBlindCost(this.mGameSettings.GetLocation(), this.mCurrentBlindIdx < n2 ? this.mCurrentBlindIdx : n3);
    }

    public int GetMinimumBet(int n2) {
        int n3 = this.GetBigBlindValue();
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public int GetHandCounter() {
        return this.mHandCounter;
    }

    public void OnHandCompleted() {
        ++this.mHandCounter;
        GameSettings gameSettings = this.mGameSettings;
        int n2 = GameSettings.GetBlindIncreasePeriod(gameSettings.GetCurrentGameMode());
        int n3 = GameSettings.GetBlindIncreaseCount(gameSettings.GetCurrentGameMode());
        if (this.mHandCounter % n2 == 0 && this.mCurrentBlindIdx < n3 && !this.IsBlindCapped()) {
            ++this.mCurrentBlindIdx;
            this.mBlindsJustGotIncremented = true;
            gameSettings.SetBlind(this.mCurrentBlindIdx);
        } else {
            this.mBlindsJustGotIncremented = false;
        }
    }

    public boolean BlindsJustGotIncremented() {
        return this.mBlindsJustGotIncremented;
    }

    public int DetermineInitialTournamentStack() {
        int n2 = -1;
        int n3 = this.mGameSettings.GetTournamentRound();
        if (n3 == 1) {
            n2 = 1000;
        } else {
            int n4 = 5000;
            int n5 = 1000;
            if (n3 == 3) {
                n4 = 10000;
                n5 = 2000;
            }
            if (this.mNbOfTimesStacksRefilledThisRound == 2) {
                n2 = n4 - this.mChipsDistributedSoFarThisRound;
                this.mChipsDistributedSoFarThisRound = 0;
                this.mNbOfTimesStacksRefilledThisRound = 0;
            } else {
                int n6 = n4 - this.mChipsDistributedSoFarThisRound - (3 - this.mNbOfTimesStacksRefilledThisRound) * n5;
                int n7 = n6 / 500;
                int n8 = FlMath.Random(0, n7);
                n2 = n5 + n8 * 500;
                this.mChipsDistributedSoFarThisRound += n2;
                ++this.mNbOfTimesStacksRefilledThisRound;
            }
        }
        return n2;
    }

    public boolean IsBlindCapped() {
        boolean bl = false;
        if (this.mGameSettings.IsCurrentModeTournament()) {
            bl = this.mCurrentBlindIdx >= this.mGameSettings.GetTournamentRoundBlindCap();
        }
        return bl;
    }

    public void Initialize() {
        this.Initialize(0);
    }

    public static TexasRules[] InstArrayTexasRules(int n2) {
        TexasRules[] texasRulesArray = new TexasRules[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasRulesArray[i2] = new TexasRules();
        }
        return texasRulesArray;
    }

    public static TexasRules[][] InstArrayTexasRules(int n2, int n3) {
        TexasRules[][] texasRulesArray = new TexasRules[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasRulesArray[i2] = new TexasRules[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                texasRulesArray[i2][i3] = new TexasRules();
            }
        }
        return texasRulesArray;
    }

    public static TexasRules[][][] InstArrayTexasRules(int n2, int n3, int n4) {
        TexasRules[][][] texasRulesArray = new TexasRules[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasRulesArray[i2] = new TexasRules[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                texasRulesArray[i2][i3] = new TexasRules[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    texasRulesArray[i2][i3][i4] = new TexasRules();
                }
            }
        }
        return texasRulesArray;
    }
}

