/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayer;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class StateNoShowdown
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kStartPayingPotWinnerAnim = 0;
    public static final byte kLeavingNoShowdown = 1;
    public byte mStateStage = (byte)-1;
    public boolean mAIWon;
    public PokerPlayer mWinningPlayer;

    public StateNoShowdown(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 6;
    }

    public void OnEntry() {
        this.mPokerGame.SetSkipToEnd(false);
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        if (this.mStateStage == -1) {
            PtrArray_PokerPlayer ptrArray_PokerPlayer = new PtrArray_PokerPlayer();
            texasPokerTable.GetPotWinners(ptrArray_PokerPlayer, 0);
            this.mWinningPlayer = ptrArray_PokerPlayer.GetAt(0);
            byte by = texasPokerTable.GetSeatOfPlayer(this.mWinningPlayer);
            if (by != PokerTable.GetSeatOfHumanPlayer()) {
                playerViewportManager.ToggleInfoScreen(by, true, this.mWinningPlayer.GetChip(), true);
                this.mAIWon = true;
            }
            texasPokerTable.PayPotWinners(ptrArray_PokerPlayer, texasPokerTable.GetPotsNbr() - 1);
            ptrArray_PokerPlayer.Clear();
            int n2 = this.mAIWon ? 250 : 0;
            this.SetStage((byte)0, n2);
        }
    }

    public void OnExit() {
        this.mGameScene.GetPlayerViewportManager().ToggleInfoScreensOutIfNeeded();
        this.SetStage((byte)-1);
    }

    public void OnSkip() {
        while (this.mStateStage != 1) {
            this.ManageState();
        }
        super.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        PokerTable pokerTable = this.mTexasManager.GetPokerTable();
        this.mStateStage = fileSegmentStream.ReadByte();
        this.mAIWon = fileSegmentStream.ReadBoolean();
        this.mWinningPlayer = pokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        PokerTable pokerTable = this.mTexasManager.GetPokerTable();
        fileSegmentStream.WriteByte(this.mStateStage);
        fileSegmentStream.WriteBoolean(this.mAIWon);
        fileSegmentStream.WriteByte(pokerTable.GetSeatOfPlayer(this.mWinningPlayer));
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void ManageState() {
        switch (this.mStateStage) {
            case 0: {
                TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
                PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
                byte by = texasPokerTable.GetSeatOfPlayer(this.mWinningPlayer);
                playerViewportManager.WonPot(by, this.mWinningPlayer);
                int n2 = this.mAIWon ? 500 : 0;
                this.mGameScene.GetPotManager().SetPot(0);
                this.SetStage((byte)1, n2);
                break;
            }
            case 1: {
                this.SetNextState((byte)9);
            }
        }
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

