/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.AIPlayerViewport;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PokerPlayerHuman;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.TexasGameManager;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class StateBetting
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kDetermineBettingPlayer = 0;
    public static final byte kDetermineAIDecision = 1;
    public static final byte kWaitingForAIDecision = 2;
    public static final byte kShowPlayerActionPopup = 3;
    public static final byte kWaitingForUserInput = 4;
    public static final byte kPlayerDecisionDone = 5;
    public static final byte kShowingShowdownPopup = 6;
    public static final byte kProcessCardsFlip = 7;
    public static final byte kWaitingForAdvisorPopup = 8;
    public static final byte kWaitingForStatsPopup = 9;
    public static final byte kWaitingForInfoScreen = 10;
    public static final byte kLeavingStateBetting = 11;
    public byte mStateStage = (byte)-1;
    public PokerPlayer mActivePlayer;
    public boolean mIsBettingRoundFinished;
    public boolean mIsBigDecision;
    public boolean mIsMediumDecision;
    public boolean mAreMetricsReadyForComputingRound;

    public StateBetting(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 4;
    }

    public int GetAcceptSoftkeyCaption() {
        int n2 = 8;
        switch (this.mStateStage) {
            case 10: {
                n2 = 5;
                break;
            }
            default: {
                n2 = super.GetAcceptSoftkeyCaption();
            }
        }
        return n2;
    }

    public int GetDeclineSoftkeyCaption() {
        int n2 = 8;
        switch (this.mStateStage) {
            case 10: {
                n2 = 3;
                break;
            }
            default: {
                n2 = super.GetDeclineSoftkeyCaption();
            }
        }
        return n2;
    }

    public boolean IsWaitingForUserInput() {
        return this.mStateStage == 4;
    }

    public void OnEntry() {
        if (this.mStateStage == -1) {
            if (this.mTexasManager.IsBetRoundNeeded()) {
                this.SetStage((byte)0);
            } else {
                this.SetStage((byte)11);
            }
        } else if (this.IsCurrentStageSkippable()) {
            this.mPokerGame.SetIsInSkipMode(true);
            this.OnSkip();
        }
        this.mGameScene.UpdateSoftKey();
        super.OnEntry();
    }

    public void OnExit() {
        this.mGameScene.GetPlayerViewportManager().SetAllPlayersState((byte)6);
        this.SetStage((byte)-1);
        this.mIsBettingRoundFinished = false;
    }

    public boolean OnKeyUp(int n2) {
        boolean bl = false;
        if (this.mStateStage != 4 && this.mStateStage != 3) {
            bl = super.OnKeyUp(n2);
        }
        return bl;
    }

    public void OnSkip() {
        if (this.mStateStage != 4) {
            this.HidePopup();
        }
        if (this.mPokerGame.GetTexasPokerTable().GetHumanPlayer().IsPlayerInTheHand() || GameApp.Get().GetCheatContainer().GetCheat(13).IsActivated()) {
            if (this.mStateStage == 1) {
                this.ManageState();
            }
            while (this.IsCurrentStageSkippable()) {
                this.ManageStateSkipping();
            }
            if (this.mStateStage == 11) {
                this.DetermineNextState();
            }
        } else {
            while (this.mStateStage != 11) {
                this.ManageStateSkipping();
            }
            this.DetermineNextState();
        }
        super.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public boolean IsCurrentStageSkippable() {
        return this.mStateStage != 11 && this.mStateStage != 4 && this.mStateStage != 3;
    }

    public void OnHidePlayerActionPopUp() {
        if (this.mTexasManager.GetActivePlayer().GetDecision().GetPlayerAction() != -1) {
            this.SetStage((byte)5);
        }
    }

    public void OnHideAIDialoguePopUp() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        PokerPlayerAI pokerPlayerAI = (PokerPlayerAI)this.mTexasManager.GetActivePlayer();
        byte by = this.mPokerGame.GetTexasPokerTable().GetSeatOfPlayer(pokerPlayerAI);
        playerViewportManager.ToggleInfoScreen(by, false);
    }

    public void OnHideAdvisor() {
    }

    public void SetCardsOut() {
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        byte by = texasPokerTable.GetSeatOfPlayer(this.mActivePlayer);
        this.mGameScene.GetPlayerViewportManager().SetCardsOutAt(by);
    }

    public boolean IsStageShowPlayerActionPopup() {
        return this.mStateStage == 3;
    }

    public void SetWaitingForInfoScreenStage() {
        this.SetStage((byte)10, 500);
    }

    public void SetWaitingForStatsPopupStage() {
        this.SetStage((byte)9);
    }

    public void SetWaitingForAdvisorPopupStage() {
        this.SetStage((byte)8);
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mStateStage = fileSegmentStream.ReadByte();
        this.mIsBigDecision = fileSegmentStream.ReadBoolean();
        this.mIsMediumDecision = fileSegmentStream.ReadBoolean();
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mStateStage);
        fileSegmentStream.WriteBoolean(this.mIsBigDecision);
        fileSegmentStream.WriteBoolean(this.mIsMediumDecision);
    }

    public void ManageStateSkipping() {
        this.ManageState();
        if (!(this.mStateStage != 1 && this.mStateStage != 0 || this.mAreMetricsReadyForComputingRound)) {
            this.mPokerGame.GetAIAlgorithm().OnTime(0, 0);
        }
    }

    public void ManageState() {
        if (!this.mIsBettingRoundFinished) {
            this.ManageBettingRound();
            if (this.mIsBettingRoundFinished) {
                this.DetermineNextState();
            }
        }
    }

    public void ManageBettingRound() {
        PokerPlayer pokerPlayer = this.mActivePlayer = this.mTexasManager.GetActivePlayer();
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        switch (this.mStateStage) {
            case 0: {
                this.mGameScene.UpdateSoftKey();
                if (this.mTexasManager.IsBetRoundFinished()) {
                    if (this.mTexasManager.IsEveryoneInTheHandAllInExceptMaxOne()) {
                        this.SetStage((byte)6);
                        break;
                    }
                    this.SetStage((byte)11);
                    break;
                }
                if (pokerPlayer.IsPlayerHuman() || GameApp.Get().GetCheatContainer().GetCheat(13).IsActivated()) {
                    byte by = this.mTexasManager.GetTexasHandStep();
                    if (by == 3 || ((PokerPlayerHuman)pokerPlayer).AreMetricsReadyForComputingRound(TexasGameManager.GetHandStepAsComputingRound(by))) {
                        this.mAreMetricsReadyForComputingRound = true;
                        ((PokerPlayerHuman)pokerPlayer).TakeDecision(this.mTexasManager);
                        this.SetStage((byte)3);
                        break;
                    }
                    this.mAreMetricsReadyForComputingRound = false;
                    break;
                }
                this.SetStage((byte)1);
                break;
            }
            case 3: {
                if (playerViewportManager.IsThereInfoScreenShown()) break;
                PlayerDecision playerDecision = new PlayerDecision();
                pokerPlayer.SetDecision(playerDecision);
                this.SetStage((byte)4);
                this.HandlePopup((byte)10);
                break;
            }
            case 1: {
                PokerPlayerAI pokerPlayerAI = (PokerPlayerAI)pokerPlayer;
                if (this.mTexasManager.GetTexasHandStep() == 3 || pokerPlayerAI.AreMetricsReadyForComputingRound(TexasGameManager.GetHandStepAsComputingRound(this.mTexasManager.GetTexasHandStep()))) {
                    this.mAreMetricsReadyForComputingRound = true;
                    pokerPlayerAI.TakeDecision(this.mTexasManager);
                    this.mIsBigDecision = this.mPokerGame.IsBigDecision(pokerPlayerAI);
                    this.mIsMediumDecision = this.mPokerGame.IsMediumDecision(pokerPlayerAI);
                    if (this.mIsBigDecision || this.mIsMediumDecision) {
                        if (!this.mPokerGame.IsInSkipMode()) {
                            playerViewportManager.ToggleInfoScreen(texasPokerTable.GetSeatOfPlayer(pokerPlayerAI), true);
                        }
                        this.SetStage((byte)2, 1000);
                        break;
                    }
                    this.SetStage((byte)2);
                    break;
                }
                this.mAreMetricsReadyForComputingRound = false;
                break;
            }
            case 2: {
                if (this.mPokerGame.IsInSkipMode()) {
                    byte by = texasPokerTable.GetSeatOfPlayer(pokerPlayer);
                    if (((AIPlayerViewport)playerViewportManager.GetPlayerViewportSeatedAt(by)).IsInfoScreenShown()) {
                        playerViewportManager.ToggleInfoScreen(by, false);
                    }
                } else if (this.mIsBigDecision) {
                    this.HandlePopup((byte)7);
                } else if (this.mIsMediumDecision) {
                    this.HandlePopup((byte)8);
                }
                this.SetStage((byte)5);
                break;
            }
            case 5: {
                this.mTexasManager.ExecuteActivePlayerDecision();
                this.UpdateBetRoundAction(pokerPlayer);
                int n2 = -1;
                if (!pokerPlayer.IsPlayerHuman()) {
                    n2 = 1000;
                }
                if (pokerPlayer.GetState() == 2) {
                    this.SetCardsOut();
                    this.SetStage((byte)0, n2);
                    break;
                }
                this.SetStage((byte)0, n2);
                break;
            }
            case 6: {
                this.HandlePopup((byte)19);
                this.SetStage((byte)7);
                break;
            }
            case 7: {
                if (!this.mPokerGame.ProcessCardsFlip()) break;
                this.SetStage((byte)11);
                break;
            }
            case 8: {
                this.HandlePopup((byte)6);
                this.SetStage((byte)3);
                break;
            }
            case 9: {
                this.HandlePopup((byte)15);
                this.SetStage((byte)3);
                break;
            }
            case 10: {
                if (!this.mPokerGame.IsInSkipMode()) {
                    playerViewportManager.ToggleInfoScreens(true);
                    this.mGameScene.UpdateSoftKey();
                }
                this.SetStage((byte)3);
                break;
            }
            case 11: {
                this.mIsBettingRoundFinished = true;
                break;
            }
        }
    }

    public void DetermineNextState() {
        boolean bl = false;
        if (this.mTexasManager.GetTexasHandStep() == 10) {
            bl = true;
            this.SetNextState((byte)7);
        } else if (this.mTexasManager.GetTexasHandStep() == 11) {
            bl = true;
            this.SetNextState((byte)6);
        } else {
            this.SetNextState((byte)5);
        }
        if (bl) {
            this.mPokerGame.ResetDataForAIAlgorithm();
        }
    }

    public void UpdateBetRoundAction(PokerPlayer pokerPlayer) {
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        byte by = texasPokerTable.GetSeatOfPlayer(pokerPlayer);
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        PlayerDecision playerDecision = pokerPlayer.GetDecision();
        byte by2 = pokerPlayer.GetDecision().GetPlayerAction();
        this.UpdateHumanPlayerStackUI();
        if (by2 == 3 || by2 == 4 || by2 == 5) {
            playerViewportManager.HideAIPlayersDecision();
        }
        playerViewportManager.SetPlayerAction(by, pokerPlayer.GetState(), playerDecision);
        this.mGameScene.GetPotManager().SetPot(texasPokerTable.GetPot());
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

