/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.HV;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayer;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayerAI;

public abstract class PokerGameManager {
    public boolean mBetRoundIsFinish;
    public PokerTable mPokerTable;
    public int mChipToCall;
    public PokerPlayer mActivePlayer;
    public PokerPlayer mLastActivePlayer;
    public PokerPlayer mCloseHandPlayer;
    public PokerPlayer[] mLastPlayerToBetOrRaise = null;
    public PokerPlayer mPotentialSidePotPlayer;
    public PokerPlayer mCannotReRaisePlayer;
    public int mChipToCallLastTrueRaise;
    public PokerPlayer mDealerButtonPlayer;
    public int mCurrentWinningHV;
    public PtrArray_PokerPlayer mEliminatedPlayerArray = new PtrArray_PokerPlayer();
    public int mMinChipToRaiseTo;

    public void destruct() {
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        this.mBetRoundIsFinish = fileSegmentStream.ReadBoolean();
        this.mChipToCall = fileSegmentStream.ReadLong();
        this.mActivePlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        this.mLastActivePlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        this.mCloseHandPlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        this.mCannotReRaisePlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        this.mDealerButtonPlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        this.mChipToCallLastTrueRaise = fileSegmentStream.ReadLong();
        this.mCurrentWinningHV = fileSegmentStream.ReadLong();
        this.mMinChipToRaiseTo = fileSegmentStream.ReadLong();
        int n2 = fileSegmentStream.ReadByte();
        this.mEliminatedPlayerArray.Clear();
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            this.mEliminatedPlayerArray.Insert(this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte()));
        }
        int n4 = this.mPokerTable.GetNbOfStartingPlayers();
        for (n3 = n2; n3 < n4; ++n3) {
            fileSegmentStream.ReadByte();
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.mLastPlayerToBetOrRaise[n3] = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
        }
        this.mPotentialSidePotPlayer = this.mPokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte());
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteBoolean(this.mBetRoundIsFinish);
        fileSegmentStream.WriteLong(this.mChipToCall);
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mActivePlayer));
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mLastActivePlayer));
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mCloseHandPlayer));
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mCannotReRaisePlayer));
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mDealerButtonPlayer));
        fileSegmentStream.WriteLong(this.mChipToCallLastTrueRaise);
        fileSegmentStream.WriteLong(this.mCurrentWinningHV);
        fileSegmentStream.WriteLong(this.mMinChipToRaiseTo);
        int n2 = this.mEliminatedPlayerArray.End();
        fileSegmentStream.WriteByte((byte)n2);
        int n3 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mEliminatedPlayerArray.GetAt(n3)));
        }
        int n4 = this.mPokerTable.GetNbOfStartingPlayers();
        for (n3 = n2; n3 < n4; ++n3) {
            fileSegmentStream.WriteByte((byte)0);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mLastPlayerToBetOrRaise[n3]));
        }
        fileSegmentStream.WriteByte(this.mPokerTable.GetSeatOfPlayer(this.mPotentialSidePotPlayer));
    }

    public void InitializeGame() {
        this.mLastPlayerToBetOrRaise = new PokerPlayer[this.mPokerTable.GetNbOfStartingPlayers()];
    }

    public void InitializeHand() {
        int n2 = this.mPokerTable.GetNbOfStartingPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mLastPlayerToBetOrRaise[i2] = null;
        }
        this.mPotentialSidePotPlayer = null;
    }

    public abstract void FinalizeHand();

    public abstract void InitializeBetRound();

    public boolean IsBetRoundNeeded() {
        boolean bl = false;
        if (this.mPokerTable.GetNumberPlayersInState((byte)1) > 1) {
            bl = true;
        } else {
            int n2 = this.mPokerTable.GetNbOfStartingPlayers();
            for (int n3 = 0; n3 < n2; n3 = (int)((short)(n3 + 1))) {
                int n4;
                byte by = (byte)n3;
                if (this.mPokerTable.GetPlayerSeatedAt(by).GetState() != 1) continue;
                int n5 = this.mPokerTable.GetPotContributionFrom(by);
                if (n5 >= (n4 = this.mPokerTable.GetMaxPotContribution())) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean IsGameFinished() {
        int n2 = 0;
        int n3 = this.mPokerTable.GetNbOfStartingPlayers();
        for (int n4 = 0; n4 < n3; n4 = (int)((short)(n4 + 1))) {
            byte by = (byte)n4;
            if (this.mPokerTable.GetPlayerSeatedAt(by).IsPlayerOutOfTheGame() || ++n2 <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean IsThereOnlyOnePlayerNotFolded() {
        int n2 = this.mPokerTable.GetNumberPlayersInState((byte)0);
        int n3 = this.mPokerTable.GetNumberPlayersInState((byte)2);
        int n4 = this.mPokerTable.GetNbOfStartingPlayers() - n2 - n3;
        return n4 == 1;
    }

    public boolean IsBetRoundFinished() {
        return this.mBetRoundIsFinish;
    }

    public abstract void ExecuteActivePlayerDecision();

    public abstract void DealCardsToAllPlayers();

    public abstract void DetermineActivePlayerPossibleActions();

    public PokerTable GetPokerTable() {
        return this.mPokerTable;
    }

    public boolean IsActivePlayerHuman() {
        return this.mActivePlayer.IsPlayerHuman();
    }

    public PokerPlayer GetActivePlayer() {
        return this.mActivePlayer;
    }

    public PokerPlayer GetLastActivePlayer() {
        return this.mLastActivePlayer;
    }

    public int GetNbOfPlayersInTheHand() {
        return this.mPokerTable.GetNbOfPlayersInTheHand();
    }

    public int GetInTournamentPlayerCount() {
        return this.mPokerTable.GetNbOfStartingPlayers() - this.mPokerTable.GetNumberPlayersInState((byte)0);
    }

    public PokerPlayer GetLeftActivePlayer() {
        PokerPlayer pokerPlayer = this.mPokerTable.GetLeftPlayer(this.mActivePlayer);
        while (pokerPlayer.GetState() != 1 && (pokerPlayer = this.mPokerTable.GetLeftPlayer(pokerPlayer)) != this.mActivePlayer) {
        }
        return pokerPlayer;
    }

    public PokerPlayer GetRightActivePlayer() {
        PokerPlayer pokerPlayer = this.mPokerTable.GetRightPlayer(this.mActivePlayer);
        while (pokerPlayer.GetState() != 1 && (pokerPlayer = this.mPokerTable.GetRightPlayer(pokerPlayer)) != this.mActivePlayer) {
        }
        return pokerPlayer;
    }

    public PokerPlayer GetDealerPlayer() {
        return this.mDealerButtonPlayer;
    }

    public PokerPlayer GetNextPlayerToShow() {
        PokerPlayer pokerPlayer = this.GetLastPlayerToBetOrRaiseForCurrentPot();
        if (pokerPlayer == null) {
            pokerPlayer = this.mPokerTable.GetLeftPlayer(this.mDealerButtonPlayer);
        }
        PtrArray_PokerPlayer ptrArray_PokerPlayer = new PtrArray_PokerPlayer();
        this.mPokerTable.GetPlayersInPot(ptrArray_PokerPlayer, this.mPokerTable.GetPotsNbr() - 1);
        boolean bl = false;
        int n2 = this.mPokerTable.GetNbOfStartingPlayers();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ptrArray_PokerPlayer.Find(pokerPlayer) >= 0 && pokerPlayer.GetState() != 3 && pokerPlayer.GetState() != 5) {
                bl = true;
                break;
            }
            pokerPlayer = this.mPokerTable.GetLeftPlayer(pokerPlayer);
        }
        if (!bl) {
            pokerPlayer = null;
        }
        ptrArray_PokerPlayer.Clear();
        return pokerPlayer;
    }

    public PokerPlayer GetLastPlayerToBetOrRaiseForCurrentPot() {
        return this.mLastPlayerToBetOrRaise[this.mPokerTable.GetCurrentPotIdx()];
    }

    public void SetLastPlayerToBetOrRaiseForCurrentPot(PokerPlayer pokerPlayer) {
        this.mLastPlayerToBetOrRaise[this.mPokerTable.GetCurrentPotIdx()] = pokerPlayer;
    }

    public abstract boolean UpdateNextActivePlayer();

    public abstract void ResolveNewEvent();

    public PokerPlayer UpdateNextPlayerToShow() {
        PokerPlayer pokerPlayer = this.GetNextPlayerToShow();
        if (pokerPlayer != null) {
            if (HV.Compare(this.mCurrentWinningHV, pokerPlayer.GetHandValue()) > 0) {
                pokerPlayer.SetState((byte)3);
            } else {
                pokerPlayer.SetState((byte)5);
                this.mCurrentWinningHV = pokerPlayer.GetHandValue();
            }
        }
        return pokerPlayer;
    }

    public boolean WasABetOrRaise() {
        return this.GetLastPlayerToBetOrRaiseForCurrentPot() != null;
    }

    public PokerPlayer GetCloseHandPlayer() {
        return this.mCloseHandPlayer;
    }

    public byte GetLeftToDealerPlayerSeatWhoReceiveCard(int n2) {
        PokerPlayer pokerPlayer = this.mDealerButtonPlayer;
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            pokerPlayer = this.mPokerTable.GetLeftPlayer(pokerPlayer);
            while (pokerPlayer.GetState() != 1 && pokerPlayer.GetState() != 4) {
                pokerPlayer = this.mPokerTable.GetLeftPlayer(pokerPlayer);
            }
        }
        return this.mPokerTable.GetSeatOfPlayer(pokerPlayer);
    }

    public int GetLeftPlayerToDealerIndex(PtrArray_PokerPlayerAI ptrArray_PokerPlayerAI) {
        int n2 = -1;
        PokerPlayer pokerPlayer = this.mDealerButtonPlayer;
        for (int i2 = 0; i2 < 2; ++i2) {
            pokerPlayer = this.mPokerTable.GetLeftPlayer(pokerPlayer);
            while (pokerPlayer.GetState() == 0) {
                pokerPlayer = this.mPokerTable.GetLeftPlayer(pokerPlayer);
            }
        }
        PokerPlayerAI pokerPlayerAI = (PokerPlayerAI)pokerPlayer;
        n2 = ptrArray_PokerPlayerAI.Find(pokerPlayerAI);
        return n2;
    }

    public int GetWinningHandValue() {
        return this.mCurrentWinningHV;
    }

    public boolean IsEveryoneInTheHandAllInExceptMaxOne() {
        int n2 = this.mPokerTable.GetNumberPlayersInState((byte)4);
        int n3 = this.GetNbOfPlayersInTheHand();
        return n2 >= 1 && n3 - n2 <= 1;
    }

    public void ReleaseResources() {
        this.mLastPlayerToBetOrRaise = null;
        this.mEliminatedPlayerArray.Clear();
    }

    public void SetActivePlayer(PokerPlayer pokerPlayer) {
        this.mLastActivePlayer = this.mActivePlayer;
        this.mActivePlayer = pokerPlayer;
    }
}

