/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.Popup;
import ca.jamdat.texasholdem09.Softkey;

public class LocationInfoPopup
extends Popup {
    public Scroller mScroller;
    public int mLocationId;
    public boolean mIsTournament;
    public int mLocationInfoTextNb;
    public Package mLocationInfoPackage;
    public Viewport mScrollingViewport;

    public LocationInfoPopup(BaseScene baseScene, Softkey softkey, Softkey softkey2, int n2, boolean bl) {
        super(baseScene, softkey, softkey2, (byte)3);
        this.mLocationId = n2;
        this.mIsTournament = bl;
    }

    public void destruct() {
    }

    public void Load() {
        super.Load();
        if (this.mContentMetaPackage == null) {
            this.mContentMetaPackage = GameLibrary.GetPackage(1310760);
        }
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        return this.mScroller.OnDefaultMsg(component, n2, n3);
    }

    public void InitializeSpecificPopup() {
        this.mLocationInfoPackage = this.mContentMetaPackage.GetPackage();
        this.mScrollingViewport = (Viewport)this.mScroller.GetChild(0);
        this.mLocationInfoTextNb = 0;
        if (this.mIsTournament) {
            this.mScroller.SetMaxNumElements(13);
        } else {
            this.mScroller.SetMaxNumElements(4);
        }
        if (this.mIsTournament) {
            this.DisplayTournamentLocationInfo();
        }
        this.DisplayBasicLocationInfo();
        this.InitializeScroller();
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mScroller = Scroller.Cast(this.mContentMetaPackage.GetPackage().GetEntryPoint(6), null);
    }

    public void TakeFocus() {
        this.mScrollingViewport.TakeFocus();
    }

    public void Show() {
        super.Show();
        this.mScroller.UpdateScroller();
    }

    public FlString GetSelectSoftKeyString() {
        if (GameApp.Get().GetCareerState().IsLocationAvailable(this.mLocationId)) {
            return super.GetSelectSoftKeyString();
        }
        MetaPackage metaPackage = GameLibrary.GetPackage(1572912);
        FlString flString = null;
        flString = FlString.Cast(metaPackage.GetPackage().GetEntryPoint(2), null);
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public FlString GetClearSoftKeyString() {
        if (GameApp.Get().GetCareerState().IsLocationAvailable(this.mLocationId)) {
            return super.GetClearSoftKeyString();
        }
        MetaPackage metaPackage = GameLibrary.GetPackage(1572912);
        FlString flString = null;
        flString = FlString.Cast(metaPackage.GetPackage().GetEntryPoint(1), null);
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public int GetSelectSoftKeyCommand() {
        if (GameApp.Get().GetCareerState().IsLocationAvailable(this.mLocationId)) {
            return super.GetSelectSoftKeyCommand();
        }
        return 24;
    }

    public int GetClearSoftKeyCommand() {
        if (GameApp.Get().GetCareerState().IsLocationAvailable(this.mLocationId)) {
            return super.GetClearSoftKeyCommand();
        }
        return 0;
    }

    public void InitializeScroller() {
        int n2;
        int n3;
        int n4 = this.mScrollingViewport.GetRectHeight();
        Viewport viewport = (Viewport)this.mScroller.GetChild(1);
        short s2 = viewport.GetRectHeight();
        int n5 = this.mIsTournament ? 13 : 4;
        if (n5 > (n3 = n4 / (n2 = 29))) {
            n4 = n2 * n3;
            viewport.SetTopLeft(viewport.GetRectLeft(), (short)(this.mScroller.GetRectHeight() - s2));
        } else {
            Viewport viewport2 = this.mScroller.GetViewport();
            Viewport viewport3 = viewport2.GetViewport();
            n4 = n2 * n5;
            viewport.SetTopLeft(viewport.GetRectLeft(), (short)(n4 - s2));
            this.mScroller.SetSize(this.mScroller.GetRectWidth(), (short)n4);
            viewport2.SetSize(this.mScroller.GetRectWidth(), (short)(n4 + this.mScroller.GetRectTop()));
            viewport2.SetTopLeft((short)((viewport3.GetRectWidth() - viewport2.GetRectWidth()) / 2), (short)((viewport3.GetRectHeight() - viewport2.GetRectHeight()) / 2));
        }
        this.mScrollingViewport.SetSize(this.mScrollingViewport.GetRectWidth(), (short)n4);
        this.mScroller.SetScrollingPosition((short)(n2 * (this.mIsTournament ? 0 : 9)));
    }

    public void DisplayBasicLocationInfo() {
        FlString flString = null;
        FlString flString2 = null;
        flString2 = GameSettings.GetLocationName(this.mLocationId);
        this.SetText(7, flString2);
        this.AddItemToScroller(19);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetBuyInCostStatic(this.mLocationId, 1)));
        this.SetText(8, flString);
        this.AddItemToScroller(20);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetSmallBlindCostStatic(this.mLocationId, 0, 1)));
        flString.AddAssign(StringUtils.CreateString(" / "));
        flString.AddAssign(new FlString(GameSettings.GetBigBlindCostStatic(this.mLocationId, 0, 1)));
        this.SetText(9, flString);
        this.AddItemToScroller(21);
        FlString flString3 = null;
        flString3 = FlString.Cast(this.mLocationInfoPackage.GetEntryPoint(32), null);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(10));
        flString.AddAssign(StringUtils.CreateString(" "));
        flString.AddAssign(flString3);
        this.SetText(10, flString);
        this.AddItemToScroller(22);
    }

    public void DisplayTournamentLocationInfo() {
        FlString flString = null;
        this.AddItemToScroller(23);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetBuyInCostStatic(this.mLocationId, 2)));
        this.SetText(11, flString);
        this.AddItemToScroller(24);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetSmallBlindCostStatic(this.mLocationId, 0, 2)));
        flString.AddAssign(StringUtils.CreateString(" / "));
        flString.AddAssign(new FlString(GameSettings.GetBigBlindCostStatic(this.mLocationId, 0, 2)));
        this.SetText(12, flString);
        this.AddItemToScroller(25);
        FlString flString2 = null;
        flString2 = FlString.Cast(this.mLocationInfoPackage.GetEntryPoint(32), null);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(5));
        flString.AddAssign(StringUtils.CreateString(" "));
        flString.AddAssign(flString2);
        this.SetText(13, flString);
        this.AddItemToScroller(26);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetTournamentPrize(this.mLocationId, 0)));
        this.SetText(14, flString);
        this.AddItemToScroller(27);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetTournamentPrize(this.mLocationId, 1)));
        this.SetText(15, flString);
        this.AddItemToScroller(28);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetTournamentPrize(this.mLocationId, 2)));
        this.SetText(16, flString);
        this.AddItemToScroller(29);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetTournamentPrize(this.mLocationId, 3)));
        this.SetText(17, flString);
        this.AddItemToScroller(30);
        flString = StringUtils.CreateStringPtr("");
        flString.AddAssign(new FlString(GameSettings.GetTournamentPrize(this.mLocationId, 4)));
        this.SetText(18, flString);
        this.AddItemToScroller(31);
    }

    public void SetText(int n2, FlString flString) {
        Text text = null;
        text = Text.Cast(this.mLocationInfoPackage.GetEntryPoint(n2), null);
        text.SetCaption(flString);
    }

    public void AddItemToScroller(int n2) {
        Viewport viewport = null;
        viewport = Viewport.Cast(this.mLocationInfoPackage.GetEntryPoint(n2), null);
        viewport.SetViewport(this.mScrollingViewport);
        ++this.mLocationInfoTextNb;
        this.mScroller.SetNumElements(this.mLocationInfoTextNb);
        this.mScroller.SetElementAt(this.mLocationInfoTextNb - 1, viewport);
    }
}

