/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.CardViewport;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class CommunityCardManager {
    public static final byte firstCardFlop = 0;
    public static final byte secondCardFlop = 1;
    public static final byte thirdCardFlop = 2;
    public static final byte turnCard = 3;
    public static final byte riverCard = 4;
    public static final byte commCardCount = 5;
    public static final byte preFlop = 0;
    public static final byte flop = 2;
    public static final byte turn = 3;
    public static final byte river = 4;
    public CardViewport[] mSharedCards = new CardViewport[5];
    public Viewport mSharedCardViewport;

    public CommunityCardManager() {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.mSharedCards[i2] = null;
        }
    }

    public void destruct() {
    }

    public void Load() {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        this.mSharedCardViewport = Viewport.Cast(package_.GetEntryPoint(124), null);
        if (this.mSharedCards[0] == null) {
            for (int i2 = 0; i2 < 5; ++i2) {
                this.mSharedCards[i2] = new CardViewport(package_, 64 + i2 * 4);
            }
        }
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void Unload() {
        for (int i2 = 0; i2 < 5; ++i2) {
            if (this.mSharedCards[i2] == null) continue;
            this.mSharedCards[i2] = null;
        }
        this.mSharedCards = null;
    }

    public void SetSharedCardsBitmap(FlBitmapMap flBitmapMap, FlBitmapMap flBitmapMap2, FlBitmapMap flBitmapMap3) {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.SetSharedCardBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3, i2);
        }
    }

    public void SetSharedCardBitmap(FlBitmapMap flBitmapMap, FlBitmapMap flBitmapMap2, FlBitmapMap flBitmapMap3, int n2) {
        this.mSharedCards[n2].SetBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3);
    }

    public void SetSharedCard(byte by, byte by2) {
        this.mSharedCards[by].SetCard(by2);
    }

    public void ShowCommunityCards(byte by) {
        switch (by) {
            case 0: {
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.mSharedCards[i2].ShowFaceUpCard(false);
                }
                break;
            }
            case 2: {
                for (int i3 = 0; i3 <= 2; ++i3) {
                    this.mSharedCards[i3].ShowFaceUpCard(true);
                }
                this.mSharedCards[3].ShowFaceUpCard(false);
                this.mSharedCards[4].ShowFaceUpCard(false);
                break;
            }
            case 3: {
                this.mSharedCards[3].ShowFaceUpCard(true);
                this.mSharedCards[4].ShowFaceUpCard(false);
                break;
            }
            case 4: {
                this.mSharedCards[4].ShowFaceUpCard(true);
                break;
            }
        }
    }

    public void Refresh() {
        this.ShowCommunityCards((byte)0);
        TexasPokerTable texasPokerTable = TexasPokerTable.Get();
        byte[] byArray = texasPokerTable.GetCommunityCards();
        int n2 = texasPokerTable.GetCommunityCardsCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.SetSharedCard((byte)i2, byArray[i2]);
            this.mSharedCards[i2].ShowFaceUpCard(true);
        }
    }

    public void SetSharedCardViewportVisibility(boolean bl) {
        this.mSharedCardViewport.SetVisible(bl);
    }

    public static CommunityCardManager[] InstArrayCommunityCardManager(int n2) {
        CommunityCardManager[] communityCardManagerArray = new CommunityCardManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            communityCardManagerArray[i2] = new CommunityCardManager();
        }
        return communityCardManagerArray;
    }

    public static CommunityCardManager[][] InstArrayCommunityCardManager(int n2, int n3) {
        CommunityCardManager[][] communityCardManagerArray = new CommunityCardManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            communityCardManagerArray[i2] = new CommunityCardManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                communityCardManagerArray[i2][i3] = new CommunityCardManager();
            }
        }
        return communityCardManagerArray;
    }

    public static CommunityCardManager[][][] InstArrayCommunityCardManager(int n2, int n3, int n4) {
        CommunityCardManager[][][] communityCardManagerArray = new CommunityCardManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            communityCardManagerArray[i2] = new CommunityCardManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                communityCardManagerArray[i2][i3] = new CommunityCardManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    communityCardManagerArray[i2][i3][i4] = new CommunityCardManager();
                }
            }
        }
        return communityCardManagerArray;
    }
}

