/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Controller;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.PtrArray_TimeControlled;
import ca.jamdat.flight.TimeControlled;

public class TimeSystem
extends TimeControlled {
    public static final byte typeNumber = 85;
    public static final byte typeID = 85;
    public static final boolean supportsDynamicSerialization = true;
    public F32 mTimeFlowSpeed = new F32(F32.One(16));
    public int mTotalTime;
    public PtrArray_TimeControlled mTimeControlleds;
    public boolean mPaused;
    public boolean mDirty;
    public F32 mDeltaError = new F32(F32.Zero(16));

    public static TimeSystem Cast(Object object, TimeSystem timeSystem) {
        return (TimeSystem)object;
    }

    public byte GetTypeID() {
        return 85;
    }

    public static Class AsClass() {
        return null;
    }

    public TimeSystem() {
        this.mTimeControlleds = new PtrArray_TimeControlled();
    }

    public void destruct() {
    }

    public void OnTime(int n2, int n3) {
        if (!this.IsPaused()) {
            if (!this.mTimeFlowSpeed.Equals(F32.One(16))) {
                F32 f32 = new F32(F32.FromInt(n3, 16).Mul(this.mTimeFlowSpeed, 16).Add(this.mDeltaError));
                n3 = f32.ToInt(16);
                this.mDeltaError = f32.Sub(F32.FromInt(n3, 16));
            }
            this.mTotalTime += n3;
            this.SendOnTime(this.mTotalTime, n3);
        }
        this.CleanUpTimeTable();
    }

    public void Start() {
        this.mPaused = false;
    }

    public void StartRecursively() {
        this.Start();
        for (int i2 = this.mTimeControlleds.Start(); i2 < this.mTimeControlleds.End(); ++i2) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i2);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).StartRecursively();
        }
    }

    public void Stop() {
        this.mTotalTime = 0;
        this.mPaused = true;
    }

    public void StopRecursively() {
        this.Stop();
        for (int i2 = this.mTimeControlleds.Start(); i2 < this.mTimeControlleds.End(); ++i2) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i2);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).StopRecursively();
        }
    }

    public void Pause() {
        this.mPaused = true;
    }

    public void AdvanceBy(int n2) {
        this.mTotalTime += n2;
        this.SendOnTime(this.mTotalTime, n2);
    }

    public void Init(int n2) {
        this.SetTotalTimeRecursively(n2);
        this.OnTime(0, n2);
    }

    public void Register(TimeControlled timeControlled) {
        if (!this.IsRegistered(timeControlled)) {
            this.mTimeControlleds.Insert(timeControlled);
        }
    }

    public void UnRegister(TimeControlled timeControlled) {
        int n2 = this.mTimeControlleds.Find(timeControlled);
        if (n2 >= 0) {
            this.mTimeControlleds.SetAt(null, n2);
            this.mDirty = true;
        }
    }

    public void UnRegisterAll() {
        PtrArray_TimeControlled ptrArray_TimeControlled = this.mTimeControlleds;
        for (int i2 = 0; i2 < ptrArray_TimeControlled.End(); ++i2) {
            if (ptrArray_TimeControlled.GetAt(i2) == null) continue;
            this.UnRegister(ptrArray_TimeControlled.GetAt(i2));
        }
    }

    public boolean IsRegistered(TimeControlled timeControlled) {
        return this.mTimeControlleds.Find(timeControlled) >= 0;
    }

    public F32 GetTimeFlowSpeed() {
        return this.mTimeFlowSpeed.IncreasePrecision(0);
    }

    public void SetTimeFlowSpeed(F32 f32) {
        this.mTimeFlowSpeed = f32.DecreasePrecision(0);
    }

    public int GetTotalTime() {
        return this.mTotalTime;
    }

    public void SetTotalTime(int n2) {
        this.mTotalTime = n2;
    }

    public void SetTotalTimeRecursively(int n2) {
        this.SetTotalTime(n2);
        for (int i2 = this.mTimeControlleds.Start(); i2 < this.mTimeControlleds.End(); ++i2) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i2);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).SetTotalTimeRecursively(n2);
        }
    }

    public boolean IsPaused() {
        return this.mPaused || this.mTimeFlowSpeed.Equals(F32.Zero(16));
    }

    public void OnSerialize(Package package_) {
        this.mTotalTime = package_.SerializeIntrinsic(this.mTotalTime);
        this.mPaused = package_.SerializeIntrinsic(this.mPaused);
        this.mTimeFlowSpeed = package_.SerializeIntrinsic(this.mTimeFlowSpeed);
        this.mTimeControlleds.OnSerialize(package_);
        this.mDirty = false;
    }

    public void RefreshAllControllersIncluded() {
        for (int i2 = this.mTimeControlleds.Start(); i2 < this.mTimeControlleds.End(); ++i2) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i2);
            if (timeControlled == null) continue;
            if (timeControlled instanceof Controller) {
                ((Controller)timeControlled).Refresh();
                continue;
            }
            if (!(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).RefreshAllControllersIncluded();
        }
    }

    public int GetNbChildren() {
        return this.mTimeControlleds.End();
    }

    public TimeControlled GetChild(int n2) {
        return this.mTimeControlleds.GetAt(n2);
    }

    public void CleanUpTimeTable() {
        if (this.mDirty) {
            int n2;
            PtrArray_TimeControlled ptrArray_TimeControlled = this.mTimeControlleds;
            while ((n2 = ptrArray_TimeControlled.Find(null)) != -1) {
                ptrArray_TimeControlled.SetAt(ptrArray_TimeControlled.GetAt(ptrArray_TimeControlled.End() - 1), n2);
                ptrArray_TimeControlled.RemoveAt(ptrArray_TimeControlled.End() - 1);
            }
            this.mDirty = false;
        }
    }

    public void SendOnTime(int n2, int n3) {
        int n4 = this.mTimeControlleds.End();
        for (int i2 = 0; i2 < this.mTimeControlleds.End(); ++i2) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i2);
            if (timeControlled == null) continue;
            if (i2 >= n4) {
                n3 = 0;
            }
            timeControlled.OnTime(n2, n3);
        }
    }

    public void Init() {
        this.Init(0);
    }

    public static TimeSystem[] InstArrayTimeSystem(int n2) {
        TimeSystem[] timeSystemArray = new TimeSystem[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeSystemArray[i2] = new TimeSystem();
        }
        return timeSystemArray;
    }

    public static TimeSystem[][] InstArrayTimeSystem(int n2, int n3) {
        TimeSystem[][] timeSystemArray = new TimeSystem[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeSystemArray[i2] = new TimeSystem[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                timeSystemArray[i2][i3] = new TimeSystem();
            }
        }
        return timeSystemArray;
    }

    public static TimeSystem[][][] InstArrayTimeSystem(int n2, int n3, int n4) {
        TimeSystem[][][] timeSystemArray = new TimeSystem[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            timeSystemArray[i2] = new TimeSystem[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                timeSystemArray[i2][i3] = new TimeSystem[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    timeSystemArray[i2][i3][i4] = new TimeSystem();
                }
            }
        }
        return timeSystemArray;
    }
}

