/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;

public class Selector
extends Scroller {
    public static final byte typeNumber = 96;
    public static final byte typeID = 96;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte FlagSkipDisabled = 1;
    public static final byte FlagLooping = 2;
    public static final byte FlagTakeFocus = 4;
    public int mCurrentSelectionIndex = -1;
    public int mLastUpdatedSelectionIndex;
    public byte mFlags;

    public static Selector Cast(Object object, Selector selector) {
        return (Selector)object;
    }

    public byte GetTypeID() {
        return 96;
    }

    public static Class AsClass() {
        return null;
    }

    public Selector() {
        this.mLastUpdatedSelectionIndex = -1;
        this.mFlags = 1;
        this.mIsVertical = false;
    }

    public Selector(int n2) {
        super(n2);
        this.mFlags = 1;
        this.mIsVertical = false;
    }

    public boolean OnDefaultMsg(Component component, int n2, int n3) {
        if (-124 == n2) {
            for (int i2 = 0; i2 < this.GetNumElements(); ++i2) {
                Selection selection = this.GetSelectionAt(i2);
                if (!selection.IsSelfOrAncestorOf(component)) continue;
                this.SetSingleSelection(i2, this.GetTakeFocusOnSync());
                this.SendMsg(this, -111, n3);
                break;
            }
        }
        return super.OnDefaultMsg(component, n2, n3);
    }

    public void SetSelectionAt(int n2, Selection selection) {
        super.SetElementAt(n2, selection);
        if (this.mCurrentSelectionIndex == n2) {
            ((Selection)this.mElements[this.mCurrentSelectionIndex]).SetSelectedState(true);
        }
    }

    public Selection GetSelectionAt(int n2) {
        return (Selection)super.GetElementAt(n2);
    }

    public int GetSingleSelection() {
        return this.mCurrentSelectionIndex;
    }

    public void SetSingleSelection(int n2, boolean bl, boolean bl2) {
        this.SetSingleSelection(n2, bl, bl2, true);
    }

    public void SetNumSelections(int n2) {
        this.SetNumElements(n2);
    }

    public int GetNumSelections() {
        return this.mNumElements;
    }

    public void SetLooping(boolean bl) {
        this.mFlags = bl ? (byte)(this.mFlags | 2) : (byte)(this.mFlags & 0xFFFFFFFD);
    }

    public boolean GetLooping() {
        return (this.mFlags & 2) != 0;
    }

    public void SetSkipDisabledSelection(boolean bl) {
        this.mFlags = bl ? (byte)(this.mFlags | 1) : (byte)(this.mFlags & 0xFFFFFFFE);
    }

    public boolean GetSkipDisabledSelection() {
        return (this.mFlags & 1) != 0;
    }

    public void SetTakeFocusOnSync(boolean bl) {
        this.mFlags = bl ? (byte)(this.mFlags | 4) : (byte)(this.mFlags & 0xFFFFFFFB);
    }

    public boolean GetTakeFocusOnSync() {
        return (this.mFlags & 4) != 0;
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        int n2 = 0;
        if (package_.IsReading()) {
            n2 = package_.SerializeIntrinsic(n2);
        } else {
            this.mCurrentSelectionIndex = package_.SerializeIntrinsic(this.mCurrentSelectionIndex);
        }
        this.mFlags = package_.SerializeIntrinsic(this.mFlags);
        if (package_.IsReading() && n2 >= 0) {
            this.SetSingleSelection(n2);
        }
    }

    public Component ForwardFocus() {
        if (this.GetSingleSelection() == -1) {
            return this;
        }
        return this.GetElementAt(this.GetSingleSelection()).ForwardFocus();
    }

    public void UpdateArrowsEnabledState() {
        if (this.mNextArrow != null) {
            if (!this.GetLooping()) {
                int n2 = this.mCurrentSelectionIndex;
                int n3 = this.mNumElements - 1;
                int n4 = -1;
                int n5 = -1;
                for (int i2 = 0; i2 < this.mNumElements; ++i2) {
                    if (n5 == -1 && ((Selection)this.mElements[i2]).GetEnabledState()) {
                        n5 = i2;
                    }
                    if (n4 == -1 && ((Selection)this.mElements[n3 - i2]).GetEnabledState()) {
                        n4 = n3 - i2;
                    }
                    if ((n5 | n4) != -1) break;
                }
                this.mNextArrow.SetEnabledState(n2 < n4);
                this.mPreviousArrow.SetEnabledState(n2 > n5);
            } else {
                this.mNextArrow.SetEnabledState(true);
                this.mPreviousArrow.SetEnabledState(true);
            }
        }
    }

    public void OnScrollEvent(int n2, boolean bl) {
        int n3;
        int n4 = n3 = this.mCurrentSelectionIndex;
        int n5 = this.mNumElements;
        boolean bl2 = this.GetLooping();
        boolean bl3 = this.GetSkipDisabledSelection();
        do {
            int n6 = n4 += n2;
            if (n4 < 0) {
                n4 = n5 - 1;
            }
            if (n4 >= n5) {
                n4 = 0;
            }
            if (bl2) {
                if (n4 != n3) continue;
                break;
            }
            if (n4 == n6) continue;
            n4 = n6 - n2;
            if (!bl3 || ((Selection)this.mElements[n4]).GetEnabledState()) break;
            n4 = this.mCurrentSelectionIndex;
            break;
        } while (bl3 && !((Selection)this.mElements[n4]).GetEnabledState());
        if (bl) {
            if (this.mLastUpdatedSelectionIndex != this.mCurrentSelectionIndex) {
                this.mCurrentSelectionIndex = this.mLastUpdatedSelectionIndex;
            }
            this.SetSingleSelection(n4, true, true, false);
        } else {
            this.mCurrentSelectionIndex = n4;
        }
    }

    public boolean IsAppropriateHotkey(int n2, int n3) {
        boolean bl = this.GetSkipDisabledSelection();
        for (int i2 = 0; i2 < this.mNumElements; ++i2) {
            Selection selection = (Selection)this.mElements[i2];
            if (!selection.GetEnabledState() && bl || n3 != selection.GetHotKey()) continue;
            this.SetSingleSelection(i2, true, true, true);
            selection.SetPushedState(n2 != -121);
            return true;
        }
        return false;
    }

    public void SetSingleSelection(int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3 = this.mCurrentSelectionIndex;
        this.mCurrentSelectionIndex = n2;
        if (n3 >= 0 && n3 != n2 && n3 < this.mNumElements) {
            ((Selection)this.mElements[n3]).SetSelectedState(false);
        }
        Selection selection = (Selection)this.mElements[n2];
        this.mScrollerViewport.ChangeOffsetToShow(selection, false);
        selection.SetSelectedState(true, bl2, bl3);
        this.UpdateArrowsEnabledState();
        if (bl) {
            selection.TakeFocus();
        }
        this.mLastUpdatedSelectionIndex = this.mCurrentSelectionIndex;
    }

    public void SetSingleSelection(int n2) {
        this.SetSingleSelection(n2, false);
    }

    public void SetSingleSelection(int n2, boolean bl) {
        this.SetSingleSelection(n2, bl, false);
    }

    public void OnScrollEvent(int n2) {
        this.OnScrollEvent(n2, true);
    }

    public static Selector[] InstArraySelector(int n2) {
        Selector[] selectorArray = new Selector[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            selectorArray[i2] = new Selector();
        }
        return selectorArray;
    }

    public static Selector[][] InstArraySelector(int n2, int n3) {
        Selector[][] selectorArray = new Selector[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            selectorArray[i2] = new Selector[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                selectorArray[i2][i3] = new Selector();
            }
        }
        return selectorArray;
    }

    public static Selector[][][] InstArraySelector(int n2, int n3, int n4) {
        Selector[][][] selectorArray = new Selector[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            selectorArray[i2] = new Selector[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                selectorArray[i2][i3] = new Selector[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    selectorArray[i2][i3][i4] = new Selector();
                }
            }
        }
        return selectorArray;
    }
}

