/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlDisplayManager;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.FlPixelFormat;
import ca.jamdat.flight.FlVideoMode;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Graphics3D;

public class MIDPDisplayContextImp
extends FlDisplayContext {
    private Graphics mGraphics;
    Graphics3D myGraphics3D = Graphics3D.getInstance();

    public MIDPDisplayContextImp(FlVideoMode flVideoMode) {
        super(flVideoMode);
    }

    public MIDPDisplayContextImp(FlBitmap flBitmap) {
        super(new FlVideoMode(flBitmap.GetWidth(), flBitmap.GetHeight(), FlPixelFormat.GetColorBitsPerPixel(flBitmap.GetPixelFormat())));
        this.SetGraphics(flBitmap.getImage().getGraphics());
    }

    public void NativeDrawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.drawArc(n2, n3, --n4, --n5, n6, n7);
    }

    public void NativeDrawLine(int n2, int n3, int n4, int n5) {
        this.mGraphics.drawLine(n2, n3, n4, n5);
    }

    public void NativeDrawPixel(int n2, int n3) {
        this.NativeFillRect(n2, n3, 1, 1);
    }

    public void NativeDrawRect(int n2, int n3, int n4, int n5) {
        this.mGraphics.drawRect(n2, n3, --n4, --n5);
    }

    public void NativeDrawRGB(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.mGraphics.drawRGB(nArray, n2, n7, n3, n4, n5, n6, bl);
    }

    public void NativeDrawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.drawRoundRect(n2, n3, --n4, --n5, n6, n7);
    }

    public void NativeFillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.fillArc(n2, n3, n4, n5, n6, n7);
    }

    public void NativeFillRect(int n2, int n3, int n4, int n5) {
        this.mGraphics.fillRect(n2, n3, n4, n5);
    }

    public void NativeFillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.fillRoundRect(n2, n3, n4, n5, n6, n7);
    }

    public void NativeFillTriangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mGraphics.fillTriangle(n2, n3, n4, n5, n6, n7);
    }

    public int NativeGetClipHeight() {
        return this.mGraphics.getClipHeight();
    }

    public int NativeGetClipWidth() {
        return this.mGraphics.getClipWidth();
    }

    public int NativeGetClipX() {
        return this.mGraphics.getClipX();
    }

    public int NativeGetClipY() {
        return this.mGraphics.getClipY();
    }

    public void NativeSetClip(int n2, int n3, int n4, int n5) {
        this.mGraphics.setClip(n2, n3, n4, n5);
    }

    public int NativeGetAlpha() {
        return 255;
    }

    public int NativeGetARGB() {
        return this.mGraphics.getColor();
    }

    public int NativeGetRGB() {
        return this.mGraphics.getColor();
    }

    public void NativeSetAlpha(int n2) {
    }

    public void NativeSetARGB(int n2) {
        this.NativeSetRGB(n2 & 0xFFFFFF);
    }

    public void NativeSetRGB(int n2) {
        this.mGraphics.setColor(n2);
    }

    public void NativeSetARGB(int n2, int n3, int n4, int n5) {
        this.NativeSetAlpha(n2);
        this.NativeSetRGB(n3, n4, n5);
    }

    public void NativeSetRGB(int n2, int n3, int n4) {
        this.mGraphics.setColor(n2, n3, n4);
    }

    public void NativeSetFont(Object object) {
        this.mGraphics.setFont((Font)object);
    }

    public void NativeDrawString(String string, int n2, int n3, int n4) {
        this.mGraphics.drawString(string, n2, n3, n4);
    }

    public void NativeDrawString(String string, int n2, int n3, byte by, byte by2) {
        this.NativeDrawString(string, n2, n3, this.TranslateAnchors(by, by2));
    }

    public int NativeGetTranslatedX() {
        return this.mGraphics.getTranslateX();
    }

    public int NativeGetTranslatedY() {
        return this.mGraphics.getTranslateY();
    }

    public void NativeTranslate(int n2, int n3) {
        this.mGraphics.translate(n2, n3);
    }

    public void Bind3D() {
        try {
            this.myGraphics3D.bindTarget((Object)this.mGraphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Bind3D(Object object) {
        try {
            ((Graphics3D)object).bindTarget((Object)this.mGraphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Release3D() {
        try {
            this.myGraphics3D.releaseTarget();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void NativeDrawRegion(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.mGraphics.drawRegion(image, n2, n3, n4, n5, FlDrawPropertyUtil.TransformToMIDPTransform(n6), n7, n8, n9);
    }

    public void SetGraphics(Graphics graphics) {
        this.mGraphics = graphics;
    }

    private void SetClip(int n2, int n3, int n4, int n5) {
        this.NativeSetClip(n2, n3, n4, n5);
    }

    public void Clear(FlColor flColor) {
        int n2 = this.NativeGetARGB();
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        this.NativeSetARGB(255, flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue());
        this.NativeFillRect(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        this.NativeSetARGB(n2);
    }

    public void ClearFullscreen(FlColor flColor) {
        short s2 = FlDisplayManager.GetVideoModeRect().GetLeft();
        short s3 = FlDisplayManager.GetVideoModeRect().GetTop();
        short s4 = FlDisplayManager.GetVideoModeRect().GetWidth();
        short s5 = FlDisplayManager.GetVideoModeRect().GetHeight();
        int n2 = this.NativeGetARGB();
        this.SetClip(s2, s3, s4, s5);
        this.NativeSetARGB(255, flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue());
        this.NativeFillRect(s2, s3, s4, s5);
        this.NativeSetARGB(n2);
    }

    public void ResetClip() {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
    }

    public void DrawAbsoluteBitmapBypassClipping(FlBitmap flBitmap, int n2, int n3) {
        Image image = flBitmap.getImage();
        this.mGraphics.drawImage(image, n2, n3, 20);
    }

    public void DrawAbsoluteBitmapSection(FlBitmap flBitmap, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.SetClip(n2, n3, n6, n7);
        this.NativeSetAlpha(FlDrawPropertyUtil.GetAlpha(n8));
        Image image = flBitmap.getImage();
        this.NativeDrawRegion(image, n4, n5, n6, n7, FlDrawPropertyUtil.GetTransform(n8), n2, n3, 20);
    }

    public void DrawAbsoluteBitmapSection(FlBitmap flBitmap, int n2, int n3, int n4, int n5, int n6, int n7, byte by, short s2) {
        int n8 = FlDrawPropertyUtil.ApplyTransform(255, FlDrawPropertyUtil.BmpTransformToTransform(by));
        this.DrawAbsoluteBitmapSection(flBitmap, n2, n3, n4, n5, n6, n7, n8);
    }

    public void DrawAbsoluteBitmapSection(FlBitmap flBitmap, int n2, int n3, int n4, int n5, int n6, int n7, byte by) {
        int n8 = FlDrawPropertyUtil.ApplyTransform(255, FlDrawPropertyUtil.BmpTransformToTransform(by));
        this.DrawAbsoluteBitmapSection(flBitmap, n2, n3, n4, n5, n6, n7, n8);
    }

    public void DrawRGB(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        this.NativeDrawRGB(nArray, n2, n3 += this.mCumulativeOffsetX, n4 += this.mCumulativeOffsetY, n5, n6, n7, bl);
    }

    public void DrawArc(short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, FlColor flColor, int n2) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s2 = (short)(s2 + this.mCumulativeOffsetX);
        s3 = (short)(s3 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n2), flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue());
        if (bl) {
            this.NativeFillArc(s2, s3, s4, s5, s6, s7);
        } else {
            this.NativeDrawArc(s2, s3, s4, s5, s6, s7);
        }
    }

    public void DrawLine(short s2, short s3, short s4, short s5, FlColor flColor, int n2) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s2 = (short)(s2 + this.mCumulativeOffsetX);
        s3 = (short)(s3 + this.mCumulativeOffsetY);
        s4 = (short)(s4 + this.mCumulativeOffsetX);
        s5 = (short)(s5 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n2), flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue());
        this.NativeDrawLine(s2, s3, s4, s5);
    }

    public void DrawPixel(short s2, short s3, FlColor flColor, int n2) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s2 = (short)(s2 + this.mCumulativeOffsetX);
        s3 = (short)(s3 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n2), flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue());
        this.NativeDrawPixel(s2, s3);
    }

    public void DrawRectangle(short s2, short s3, short s4, short s5, boolean bl, int n2, int n3, int n4, int n5) {
        s2 = (short)(s2 + this.mCumulativeOffsetX);
        s3 = (short)(s3 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n5), n2, n3, n4);
        if (!bl) {
            if (this.mClipRect_top <= s3) {
                this.FillRectangle(s2, s3, s4, (short)1);
            }
            if (this.mClipRect_left <= s2) {
                this.FillRectangle(s2, s3, (short)1, s5);
            }
            if (this.mClipRect_top + this.mClipRect_height >= s3 + s5) {
                this.FillRectangle(s2, (short)(s3 + s5 - 1), s4, (short)1);
            }
            if (this.mClipRect_left + this.mClipRect_width >= s2 + s4) {
                this.FillRectangle((short)(s2 + s4 - 1), s3, (short)1, s5);
            }
        } else {
            this.FillRectangle(s2, s3, s4, s5);
        }
    }

    public void DrawRoundRectangle(short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, FlColor flColor, int n2) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s2 = (short)(s2 + this.mCumulativeOffsetX);
        s3 = (short)(s3 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n2), flColor.GetRed(), flColor.GetGreen(), flColor.GetBlue());
        if (bl) {
            this.NativeFillRoundRect(s2, s3, s4, s5, s6, s7);
        } else {
            this.NativeDrawRoundRect(s2, s3, s4, s5, s6, s7);
        }
    }

    public void DrawTriangle(short s2, short s3, short s4, short s5, short s6, short s7, boolean bl, FlColor flColor, int n2) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        super.GenericDrawTriangle(s2, s3, s4, s5, s6, s7, bl, flColor, n2);
    }

    private void FillRectangle(short s2, short s3, short s4, short s5) {
        int n2 = this.mClipRect_left + this.mClipRect_width;
        int n3 = s2 + s4;
        int n4 = this.mClipRect_top + this.mClipRect_height;
        int n5 = s3 + s5;
        if (this.mClipRect_left > s2) {
            s2 = this.mClipRect_left;
        }
        if (this.mClipRect_top > s3) {
            s3 = this.mClipRect_top;
        }
        if (n2 < n3) {
            n3 = n2;
        }
        if (n4 < n5) {
            n5 = n4;
        }
        s4 = (short)(n3 - s2);
        s5 = (short)(n5 - s3);
        this.SetClip(s2, s3, s4, s5);
        this.NativeFillRect(s2, s3, s4, s5);
    }

    public byte GetDisplayAPI() {
        return 7;
    }

    private int TranslateAnchors(int n2, int n3) {
        int n4 = 0;
        switch (n2) {
            case 0: {
                n4 |= 4;
                break;
            }
            case 1: {
                n4 |= 1;
                break;
            }
            case 2: {
                n4 |= 8;
            }
        }
        switch (n3) {
            case 0: {
                n4 |= 0x10;
                break;
            }
            case 1: {
                n4 |= 0x20;
                break;
            }
            case 2: {
                n4 |= 0x40;
                break;
            }
            case 3: {
                n4 |= 2;
            }
        }
        return n4;
    }
}

