/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlBufferChunkInfo;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Memory;

public class FlByteBuffer {
    public int mCapacity;
    public int mLimit;
    public int mPosition;
    public int mMark;
    public FlBufferChunkInfo mStartChunk;
    public FlBufferChunkInfo mPositionChunk;

    public static FlByteBuffer Allocate(int n2) {
        return new FlByteBuffer(n2);
    }

    public void destruct() {
        FlBufferChunkInfo flBufferChunkInfo = this.mStartChunk;
        while (flBufferChunkInfo != null) {
            FlBufferChunkInfo flBufferChunkInfo2 = flBufferChunkInfo;
            flBufferChunkInfo = flBufferChunkInfo2.mNextPtr;
            flBufferChunkInfo2.mData = null;
            flBufferChunkInfo2 = null;
        }
    }

    public int GetCapacity() {
        return this.mCapacity;
    }

    public int GetLimit() {
        return this.mLimit;
    }

    public void SetLimit(int n2) {
        if (this.mPosition > n2) {
            this.mPositionChunk = this.FindChunk(n2, this.mPositionChunk);
            this.mPosition = n2;
        }
        if (this.mMark != -1 && this.mMark > n2) {
            this.mMark = -1;
        }
        this.mLimit = n2;
    }

    public int GetPosition() {
        return this.mPosition;
    }

    public void SetPosition(int n2) {
        if (this.mMark != -1 && this.mMark > n2) {
            this.mMark = -1;
        }
        this.mPositionChunk = this.FindChunk(n2, this.mPositionChunk);
        this.mPosition = n2;
    }

    public boolean HasRemaining() {
        return this.GetRemaining() > 0;
    }

    public int GetRemaining() {
        return this.mLimit - this.mPosition;
    }

    public void Mark() {
        this.mMark = this.mPosition;
    }

    public void Reset() {
        this.mPositionChunk = this.FindChunk(this.mMark, this.mPositionChunk);
        this.mPosition = this.mMark;
    }

    public void Clear() {
        this.mPosition = 0;
        this.mPositionChunk = this.mStartChunk;
        this.mLimit = this.mCapacity;
        this.mMark = -1;
    }

    public void Flip() {
        this.mLimit = this.mPosition;
        this.mPosition = 0;
        this.mPositionChunk = this.mStartChunk;
        this.mMark = -1;
    }

    public void Rewind() {
        this.mPosition = 0;
        this.mPositionChunk = this.mStartChunk;
        this.mMark = -1;
    }

    public void Put(byte by) {
        this.mPositionChunk.mData[this.mPosition - this.mPositionChunk.mStartOffset] = by;
        ++this.mPosition;
        this.mPositionChunk = this.FindChunk(this.mPosition, this.mPositionChunk);
    }

    public void Put(byte by, int n2) {
        FlBufferChunkInfo flBufferChunkInfo = this.FindChunk(n2, this.mStartChunk);
        flBufferChunkInfo.mData[n2 - flBufferChunkInfo.mStartOffset] = by;
    }

    public void Put(byte[] byArray, int n2, int n3) {
        this.BulkCopy(byArray, n2, n3, -1, true);
    }

    public void Put(byte[] byArray, int n2, int n3, int n4) {
        this.BulkCopy(byArray, n2, n3, n4, true);
    }

    public byte Get() {
        byte by = this.mPositionChunk.mData[this.mPosition - this.mPositionChunk.mStartOffset];
        ++this.mPosition;
        this.mPositionChunk = this.FindChunk(this.mPosition, this.mPositionChunk);
        return by;
    }

    public byte Get(int n2) {
        FlBufferChunkInfo flBufferChunkInfo = this.FindChunk(n2, this.mStartChunk);
        byte by = flBufferChunkInfo.mData[n2 - flBufferChunkInfo.mStartOffset];
        return by;
    }

    public void Get(byte[] byArray, int n2, int n3) {
        this.BulkCopy(byArray, n2, n3, -1, false);
    }

    public void Get(byte[] byArray, int n2, int n3, int n4) {
        this.BulkCopy(byArray, n2, n3, n4, false);
    }

    public void Compact() {
        for (int i2 = 0; i2 < this.GetRemaining(); ++i2) {
            this.Put(this.Get(this.mPosition + i2), i2);
        }
        this.mPosition = this.GetRemaining();
        this.mPositionChunk = this.FindChunk(this.mPosition, this.mPositionChunk);
        this.mLimit = this.mCapacity;
        this.mMark = -1;
    }

    public FlByteBuffer(int n2) {
        int n3 = 0;
        int n4 = n2;
        FlBufferChunkInfo flBufferChunkInfo = null;
        FlBufferChunkInfo flBufferChunkInfo2 = null;
        while (n3 < n2) {
            flBufferChunkInfo2 = this.AllocChunk(n4, n3);
            n3 += flBufferChunkInfo2.mSize;
            if (flBufferChunkInfo == null) {
                this.mStartChunk = flBufferChunkInfo2;
            } else {
                flBufferChunkInfo.mNextPtr = flBufferChunkInfo2;
                flBufferChunkInfo2.mPrevPtr = flBufferChunkInfo;
            }
            n4 = FlMath.Minimum(flBufferChunkInfo2.mSize, n2 - n3);
            flBufferChunkInfo = flBufferChunkInfo2;
        }
        this.mPosition = 0;
        this.mLimit = n2;
        this.mCapacity = n2;
        this.mMark = -1;
        this.mPositionChunk = this.mStartChunk;
    }

    public FlBufferChunkInfo AllocChunk(int n2, int n3) {
        byte[] byArray = new byte[n2];
        while (byArray == null) {
            byArray = new byte[n2 >>= 1];
        }
        FlBufferChunkInfo flBufferChunkInfo = new FlBufferChunkInfo();
        flBufferChunkInfo.mStartOffset = n3;
        flBufferChunkInfo.mSize = n2;
        flBufferChunkInfo.mData = byArray;
        flBufferChunkInfo.mNextPtr = null;
        flBufferChunkInfo.mPrevPtr = null;
        return flBufferChunkInfo;
    }

    public FlBufferChunkInfo FindChunk(int n2, FlBufferChunkInfo flBufferChunkInfo) {
        if (n2 == this.mLimit) {
            --n2;
        }
        if (n2 < flBufferChunkInfo.mStartOffset) {
            return this.FindChunk(n2, flBufferChunkInfo.mPrevPtr);
        }
        if (n2 >= flBufferChunkInfo.mStartOffset + flBufferChunkInfo.mSize) {
            return this.FindChunk(n2, flBufferChunkInfo.mNextPtr);
        }
        return flBufferChunkInfo;
    }

    public void BulkCopy(byte[] byArray, int n2, int n3, int n4, boolean bl) {
        int n5;
        FlBufferChunkInfo flBufferChunkInfo;
        int n6 = n4 == -1 ? this.mPosition : n4;
        FlBufferChunkInfo flBufferChunkInfo2 = flBufferChunkInfo = n4 == -1 ? this.mPositionChunk : this.FindChunk(n4, this.mStartChunk);
        for (int i2 = 0; i2 < n3; i2 += n5) {
            int n7 = n6 - flBufferChunkInfo.mStartOffset;
            int n8 = flBufferChunkInfo.mSize - n7;
            n5 = FlMath.Minimum(n8, n3 - i2);
            if (bl) {
                Memory.Copy(flBufferChunkInfo.mData, n7, byArray, n2 + i2, n5);
            } else {
                Memory.Copy(byArray, n2 + i2, flBufferChunkInfo.mData, n7, n5);
            }
            flBufferChunkInfo = this.FindChunk(n6 += n5, flBufferChunkInfo);
        }
        if (n4 == -1) {
            this.mPosition = n6;
            this.mPositionChunk = flBufferChunkInfo;
        }
    }
}

