/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tree {
    public static final int TREE = 0;
    public static final int CROSS = 1;
    public static final int GOBLIN = 2;
    public static final int DEATH = 3;
    public static Image[] treeIm;
    public static Image[] crossIm;
    public static Image[] goblinIm;
    public static Image[] unit_dying;
    public static int number;
    public static int[] X;
    public static int[] Y;
    public static int[] kind;
    public static long[] next_cadr_time;
    public static int[] cur_cadr;

    public static void load() {
        try {
            int i;
            treeIm = new Image[4];
            Tree.treeIm[0] = Image.createImage((String)"/h_tree.png");
            Tree.treeIm[1] = Image.createImage((String)"/o_tree.png");
            Tree.treeIm[2] = Image.createImage((String)"/e_tree.png");
            Tree.treeIm[3] = Image.createImage((String)"/u_tree.png");
            crossIm = new Image[3];
            Tree.crossIm[0] = Image.createImage((String)"/h_mogila.png");
            Tree.crossIm[1] = Image.createImage((String)"/o_mogila.png");
            Tree.crossIm[2] = Image.createImage((String)"/e_mogila.png");
            goblinIm = new Image[4];
            for (i = 0; i < 4; ++i) {
                Tree.goblinIm[i] = Image.createImage((String)("/goblin_" + (i + 1) + ".png"));
            }
            unit_dying = new Image[8];
            for (i = 0; i < 8; ++i) {
                Tree.unit_dying[i] = Image.createImage((String)("/death_" + (i + 1) + ".png"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        number = 0;
        for (int i = 0; i < MapsInitObj.gold_tree_goblin[Game.LEV].length; ++i) {
            for (int j = 0; j < MapsInitObj.gold_tree_goblin[Game.LEV][i].length; ++j) {
                if (MapsInitObj.gold_tree_goblin[Game.LEV][i][j] != 2 && MapsInitObj.gold_tree_goblin[Game.LEV][i][j] != 3 || MapsInit.race[Game.LEV][i][j] == 100) continue;
                boolean can = true;
                for (int k = 0; k < Capital.number; ++k) {
                    if (Capital.X[k] != j || Capital.Y[k] != i) continue;
                    can = false;
                }
                if (!can) continue;
                if (MapsInitObj.gold_tree_goblin[Game.LEV][i][j] == 2) {
                    Tree.create(j, i, 0);
                    continue;
                }
                Tree.create(j, i, 2);
            }
        }
    }

    public static void create(int x, int y, int who) {
        TurnCounter.createTree();
        Tree.X[++Tree.number - 1] = x;
        Tree.Y[Tree.number - 1] = y;
        Tree.kind[Tree.number - 1] = who;
        Tree.cur_cadr[Tree.number - 1] = 0;
        Tree.next_cadr_time[Tree.number - 1] = System.currentTimeMillis();
        Map.obj_type[y][x] = 5;
        Map.obj_number[y][x] = number - 1;
    }

    public static void create(int num, int x, int y, int who) {
        for (int i = ++number - 1; i > num; --i) {
            Tree.X[i] = X[i - 1];
            Tree.Y[i] = Y[i - 1];
            Tree.kind[i] = kind[i - 1];
            Tree.cur_cadr[i] = cur_cadr[i - 1];
            Tree.next_cadr_time[i] = next_cadr_time[i - 1];
            Map.obj_number[Tree.Y[i]][Tree.X[i]] = i;
        }
        Tree.X[num] = x;
        Tree.Y[num] = y;
        Tree.kind[num] = who;
        Tree.cur_cadr[num] = 0;
        Tree.next_cadr_time[num] = System.currentTimeMillis();
        Map.obj_type[y][x] = 5;
        Map.obj_number[y][x] = num;
    }

    public static void destroy(int num) {
        TurnCounter.destroyTree(num);
        Map.obj_type[Tree.Y[num]][Tree.X[num]] = 0;
        for (int i = num; i < number - 1; ++i) {
            Tree.X[i] = X[i + 1];
            Tree.Y[i] = Y[i + 1];
            Tree.kind[i] = kind[i + 1];
            Tree.cur_cadr[i] = cur_cadr[i + 1];
            Tree.next_cadr_time[i] = next_cadr_time[i + 1];
            int[] nArray = Map.obj_number[Y[i]];
            int n = X[i];
            nArray[n] = nArray[n] - 1;
        }
        --number;
    }

    public static void grow() {
        int old_number = number;
        for (int i = 0; i < old_number; ++i) {
            if (kind[i] == 1 || kind[i] == 3 || Gold.rand(10) <= 7) continue;
            try {
                Tree.growOne(i);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void growOne(int num) {
        int[] place_x = new int[6];
        int[] place_y = new int[6];
        int num_of_places = 0;
        int[] places = new int[6];
        place_x[0] = X[num];
        place_y[0] = Y[num] - 1;
        place_x[1] = X[num];
        place_y[1] = Y[num] + 1;
        place_x[2] = X[num] - 1;
        place_y[2] = Y[num];
        place_x[3] = X[num] + 1;
        place_y[3] = Y[num];
        place_y[4] = Y[num] - 1;
        place_y[5] = Y[num] + 1;
        if (Y[num] % 2 == 0) {
            place_x[4] = X[num] - 1;
            place_x[5] = X[num] - 1;
        } else {
            place_x[4] = X[num] + 1;
            place_x[5] = X[num] + 1;
        }
        for (int i = 0; i < 6; ++i) {
            if (place_x[i] < 0 || place_x[i] >= Map.race[0].length || place_y[i] < 0 || place_y[i] >= Map.race.length || Map.race[place_y[i]][place_x[i]] == 100 || Map.obj_type[place_y[i]][place_x[i]] != 0) continue;
            places[num_of_places] = i;
            ++num_of_places;
        }
        int chose = Gold.rand(num_of_places);
        Tree.create(place_x[places[chose]], place_y[places[chose]], kind[num]);
    }

    public static void drawOne(Graphics g, int num) {
        if (X[num] > Map.activeHexX + Map.local_map_width / 2 || X[num] < Map.activeHexX - Map.local_map_width / 2 || Y[num] > Map.activeHexY + Map.local_map_height / 2 || Y[num] < Map.activeHexY - Map.local_map_height / 2) {
            return;
        }
        int x = Game.W / 2 + 2 * Map.hex_half_widht_local * (X[num] - Map.activeHexX);
        int y = Game.H / 2 + 3 * Map.hex_half_height_local * (Y[num] - Map.activeHexY);
        if ((Y[num] - Map.activeHexY) % 2 == 1 || (Map.activeHexY - Y[num]) % 2 == 1) {
            x = Y[num] % 2 == 0 ? (x -= Map.hex_half_widht_local) : (x += Map.hex_half_widht_local);
        }
        if (kind[num] == 1) {
            g.drawImage(crossIm[Map.race[Y[num]][X[num]]], x, y + 15, 1 | 0x20);
        } else if (kind[num] == 0) {
            if (Map.race[Y[num]][X[num]] < 4) {
                g.drawImage(treeIm[Map.race[Y[num]][X[num]]], x, y + 10, 1 | 0x20);
            } else if (Map.race[Y[num]][X[num]] == 4) {
                g.drawImage(treeIm[0], x, y + 10, 1 | 0x20);
            }
        } else if (kind[num] == 2) {
            int dis_y = 0;
            dis_y = Game.W >= 230 ? 25 : (Game.W >= 176 ? 5 : 0);
            try {
                g.drawImage(goblinIm[cur_cadr[num]], x, y + dis_y, 1 | 0x20);
            }
            catch (Exception e) {
                Tree.cur_cadr[num] = 0;
                g.drawImage(goblinIm[cur_cadr[num]], x, y + dis_y, 1 | 0x20);
            }
            if (System.currentTimeMillis() > next_cadr_time[num]) {
                Tree.cur_cadr[num] = (cur_cadr[num] + 1) % goblinIm.length;
                Tree.next_cadr_time[num] = System.currentTimeMillis() + (long)Data.TIME_GOLD_ANIM + (long)Gold.rand(Data.TIME_GOLD_ANIM / 10);
            }
        } else if (kind[num] == 3) {
            if (System.currentTimeMillis() > next_cadr_time[num] + (long)(4 * Data.TIME_GOLD_ANIM)) {
                Tree.kind[num] = 1;
                return;
            }
            try {
                g.drawImage(unit_dying[cur_cadr[num]], x, y - 20, 1 | 2);
            }
            catch (Exception e) {
                Tree.kind[num] = 1;
            }
            if (System.currentTimeMillis() > next_cadr_time[num]) {
                Tree.cur_cadr[num] = cur_cadr[num] + 1;
                Tree.next_cadr_time[num] = System.currentTimeMillis() + (long)(Data.TIME_GOLD_ANIM / 3) + (long)Gold.rand(Data.TIME_GOLD_ANIM / 10);
            }
        }
    }

    public static void draw(Graphics g) {
        for (int i = 0; i < number; ++i) {
            Tree.drawOne(g, i);
        }
    }

    static {
        number = 0;
        X = new int[500];
        Y = new int[500];
        kind = new int[500];
        next_cadr_time = new long[500];
        cur_cadr = new int[500];
    }
}

