/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicArcanoid
extends GameLogic {
    private static final byte RACKET_MAX_SIZE = 3;
    private static final int LIFE_MAX = 3;
    private static final byte SCORE_INC = 10;
    private static final byte LEVEL_LINE_MIN = 4;
    private static final byte LEVEL_LINE_W = 3;
    private byte bRacketSize = (byte)3;
    private byte bRacketBottom;
    private final short[] sBallPos = new short[2];
    private byte bRacketLeft;
    private byte bRacketRight;
    private byte bRacketBorderRight;
    private byte bBallBorderBottom;
    private byte bStepV;
    private byte bStepH;
    private boolean shift = false;

    public GameLogicArcanoid() {
        super(3, 3);
    }

    public final void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bRacketSize);
        GUtillIo.writeByte(this.bRacketBottom);
        GUtillIo.writeByte(this.bRacketLeft);
        GUtillIo.writeByte(this.bRacketRight);
        GUtillIo.writeByte(this.bRacketBorderRight);
        GUtillIo.writeByte(this.bBallBorderBottom);
        GUtillIo.writeByte(this.bStepH);
        GUtillIo.writeByte(this.bStepV);
        GUtillIo.writeArray(this.sBallPos);
    }

    public final void load() throws Exception {
        super.load();
        this.bRacketSize = GUtillIo.readByte();
        this.bRacketBottom = GUtillIo.readByte();
        this.bRacketLeft = GUtillIo.readByte();
        this.bRacketRight = GUtillIo.readByte();
        this.bRacketBorderRight = GUtillIo.readByte();
        this.bBallBorderBottom = GUtillIo.readByte();
        this.bStepH = GUtillIo.readByte();
        this.bStepV = GUtillIo.readByte();
        GUtillIo.read(this.sBallPos);
        int rowBottom = (this.bRacketBottom + 1) * 10;
        for (int i = 0; i < 10; ++i) {
            GameField.set(rowBottom + i, (byte)1);
        }
    }

    public final void updateLevel(int level) {
        this.clear();
        int levelId = level - 1;
        this.bRacketSize = (byte)(3 - levelId * 3 / 30);
        this.bRacketBottom = (byte)(19 - levelId / 2 - levelId % 2);
        this.bRacketBorderRight = (byte)(10 - this.bRacketSize);
        this.bBallBorderBottom = (byte)(this.bRacketBottom - 1);
        this.placePlayer();
        int width2 = 5;
        int lineCount = 4 + levelId / 4;
        int lineWidth = 3 + levelId % 2;
        int cur = 0;
        for (int i = 0; i < lineCount; ++i) {
            cur = 0;
            int first = (i + 2) * 10;
            while (cur < lineWidth) {
                int rand = GUtillMath.rnd(5);
                int index = first + 5 - 1 - rand;
                if (GameField.get(index) != 0) continue;
                GameField.set(index, (byte)1);
                GameField.set(first + 5 + rand, (byte)1);
                ++cur;
            }
        }
    }

    public final void updateState() {
        if (this.active && this.canUpdate()) {
            this.shift = false;
            GameField.set(this.sBallPos, (byte)0);
            if (this.sBallPos[0] == 0) {
                this.bStepH = 1;
            } else if (this.sBallPos[0] == 9) {
                this.bStepH = 0;
            }
            boolean decr = false;
            if (this.sBallPos[1] == 0) {
                this.changeStepV();
            } else if (this.bStepV == 3) {
                if (this.sBallPos[1] == this.bBallBorderBottom) {
                    if (this.sBallPos[0] == this.bRacketLeft + 1 || this.sBallPos[0] == this.bRacketLeft || this.sBallPos[0] == this.bRacketRight) {
                        this.changeStepV();
                    } else if (this.bStepH == 1 && this.sBallPos[0] == this.bRacketLeft - 1) {
                        this.changeStepV();
                        this.changeStepH();
                    } else if (this.bStepH == 0 && this.sBallPos[0] == this.bRacketRight + 1) {
                        this.changeStepV();
                        this.changeStepH();
                    }
                } else if (this.sBallPos[1] > this.bBallBorderBottom) {
                    this.lifeDecr();
                    GameField.set(this.sBallPos, (byte)1);
                    decr = true;
                }
            }
            if (!this.gameover && !decr) {
                do {
                    short[] next = new short[2];
                    int score_was = this.score;
                    next[1] = (short)(this.sBallPos[1] + (this.bStepV == 2 ? -1 : 1));
                    next[0] = this.sBallPos[0];
                    boolean tb = false;
                    boolean lr = false;
                    boolean diag = false;
                    if (GameField.get(next) == 1) {
                        GameField.set(next, (byte)0);
                        this.score += 10;
                        tb = true;
                    }
                    next[0] = (short)(next[0] + (this.bStepH == 0 ? -1 : 1));
                    if (next[0] != 10 && next[0] != -1) {
                        if (GameField.get(next) == 1) {
                            GameField.set(next, (byte)0);
                            this.score += 10;
                            diag = true;
                        }
                        next[1] = this.sBallPos[1];
                        if (GameField.get(next) == 1) {
                            GameField.set(next, (byte)0);
                            this.score += 10;
                            GameField.set(this.sBallPos, (byte)0);
                            lr = true;
                        }
                    }
                    if (score_was != this.score) {
                        if (diag && !lr && !tb) {
                            this.changeStepH();
                            this.changeStepV();
                        } else {
                            if (lr) {
                                this.changeStepH();
                            }
                            if (tb) {
                                this.changeStepV();
                            }
                        }
                    }
                    if (this.sBallPos[0] == 0) {
                        this.bStepH = 1;
                        continue;
                    }
                    if (this.sBallPos[0] != 9) continue;
                    this.bStepH = 0;
                } while (GameField.get(this.sBallPos[0] + (this.bStepH == 0 ? -1 : 1), this.sBallPos[1] + (this.bStepV == 2 ? -1 : 1)) == 1);
                this.updateBall();
                GameField.set(this.sBallPos, (byte)1);
            }
            int size = 200;
            int lineCount = 4 + (EGame.iLevel - 1) / 4;
            int first = 10;
            int last = first + (lineCount + 2) * 10;
            int full = 0;
            for (int i = first; i < last && (GameField.get(i) != 1 || ++full <= 1); ++i) {
            }
            if (full == 1 && this.sBallPos[1] <= lineCount + 2 && this.sBallPos[1] >= 1) {
                this.gameup = true;
                this.updateLevel(EGame.iLevel);
            }
        }
    }

    public final boolean updateEvent() {
        if (this.canUpdate()) {
            this.updatePlayer();
        }
        return false;
    }

    private final void updatePlayer() {
        if (E.kStates[7] && !this.active) {
            GameField.set(this.sBallPos, (byte)0);
            this.active = true;
        }
        if (this.active) {
            if (E.kStates[6]) {
                if (this.bRacketLeft > 0) {
                    if (!this.shift && this.sBallPos[1] == this.bBallBorderBottom && this.sBallPos[0] >= this.bRacketLeft && this.sBallPos[0] <= this.bRacketRight && this.sBallPos[0] != 0) {
                        GameField.set(this.sBallPos, (byte)0);
                        this.sBallPos[0] = (short)(this.sBallPos[0] - 1);
                        GameField.set(this.sBallPos, (byte)1);
                        this.shift = true;
                        this.changeStepV();
                    }
                    this.bRacketLeft = (byte)(this.bRacketLeft - 1);
                    this.updateFigure();
                }
            } else if (E.kStates[8] && this.bRacketLeft < this.bRacketBorderRight) {
                if (!this.shift && this.sBallPos[1] == this.bBallBorderBottom && this.sBallPos[0] >= this.bRacketLeft && this.sBallPos[0] <= this.bRacketRight && this.sBallPos[0] != 9) {
                    GameField.set(this.sBallPos, (byte)0);
                    this.sBallPos[0] = (short)(this.sBallPos[0] + 1);
                    GameField.set(this.sBallPos, (byte)1);
                    this.shift = true;
                    this.changeStepV();
                }
                this.bRacketLeft = (byte)(this.bRacketLeft + 1);
                this.updateFigure();
            }
        }
    }

    private final void updateFigure() {
        this.bRacketRight = (byte)(this.bRacketLeft + this.bRacketSize - 1);
        int bottomIndex = this.bRacketBottom * 10 + this.bRacketLeft;
        for (int i = 0; i < this.bRacketSize; ++i) {
            this.figure_pos[i] = bottomIndex + i;
        }
        if (!this.active) {
            GameField.set(this.sBallPos, (byte)0);
            this.sBallPos[1] = this.bBallBorderBottom;
            System.out.println(this.sBallPos[1]);
            this.sBallPos[0] = (short)(this.bRacketLeft + this.bRacketSize / 2);
            GameField.set(this.sBallPos, (byte)2);
        }
    }

    private final void changeStepH() {
        this.bStepH = this.bStepH == 0 ? (byte)1 : 0;
    }

    private final void changeStepV() {
        this.bStepV = (byte)(this.bStepV == 2 ? 3 : 2);
    }

    private final void updateBall() {
        this.sBallPos[1] = (short)(this.sBallPos[1] + (this.bStepV == 3 ? 1 : -1));
        this.sBallPos[0] = (short)(this.sBallPos[0] + (this.bStepH == 1 ? 1 : -1));
    }

    protected void placePlayer() {
        this.active = false;
        this.bRacketLeft = (byte)((10 - this.bRacketSize) / 2);
        this.updateFigure();
        this.bStepV = (byte)2;
        this.bStepH = GUtillMath.rnd(2) == 1 ? (byte)1 : 0;
        GUtillArray.fill(this.figure_elem, (byte)1);
        int rowBottom = (this.bRacketBottom + 1) * 10;
        for (int i = 0; i < 10; ++i) {
            GameField.set(rowBottom + i, (byte)1);
        }
    }
}

