/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class SoundPool
implements PlayerListener {
    public static int SndEx = 0;
    public static final int TYPE_MIDI = 0;
    public static final int TYPE_AMR = 1;
    public static final int TYPE_WAV = 2;
    private static final int TYPE_COUNT = 3;
    private static final String[] PARAM = new String[]{"audio/midi", "audio/amr", "audio/x-wav"};
    private static final String[] EXTENSION = new String[]{".mid", ".amr", ".wav"};
    private static Player[] PPlayer;
    private static boolean[] aArrRepeat;
    private static int iCount;
    private static int iLast;
    private static int iPlayId;
    private static int iStopId;
    private static int iPausedId;
    private static boolean sndPause;

    public SoundPool(String[] fileName, int[] loopCount) {
        iPlayId = -1;
        iStopId = -1;
        iPausedId = -1;
        sndPause = false;
        iCount = fileName.length;
        PPlayer = new Player[iCount];
        aArrRepeat = new boolean[iCount];
        StringBuffer sndName = new StringBuffer();
        int length = 0;
        for (int i = 0; i < iCount; ++i) {
            sndName.append(fileName[i]);
            length = sndName.length();
            for (int j = 0; j < 3; ++j) {
                sndName.append(EXTENSION[j]);
                if (GUtillIo.fileExist(sndName.toString())) {
                    try {
                        GUtillIo.initRead(sndName.toString());
                        SoundPool.aArrRepeat[i] = loopCount[i] > 1;
                        SoundPool.PPlayer[i] = Manager.createPlayer((InputStream)GUtillIo.getInputStream(), (String)PARAM[j]);
                        PPlayer[i].addPlayerListener((PlayerListener)this);
                        PPlayer[i].realize();
                        PPlayer[i].prefetch();
                        VolumeControl sndVolume = (VolumeControl)PPlayer[i].getControl("VolumeControl");
                        sndVolume.setLevel(60);
                        GUtillIo.closeRead();
                    }
                    catch (Exception e) {
                        SndEx = 1;
                        e.printStackTrace();
                    }
                }
                sndName.setLength(length);
            }
            sndName.setLength(0);
        }
        System.gc();
        iLast = -1;
    }

    public final void setSoundVol(int level1) {
        int levelSound = 10 * level1;
        for (int i = 0; i < iCount; ++i) {
            VolumeControl sndVolume = (VolumeControl)PPlayer[i].getControl("VolumeControl");
            sndVolume.setLevel(levelSound);
        }
    }

    public final void destroy() {
        sndPause = false;
        this.stopLast();
        for (int i = 0; i < iCount; ++i) {
            try {
                PPlayer[i].stop();
                PPlayer[i].close();
                SoundPool.PPlayer[i] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.gc();
    }

    public final void play(int index) {
        if (iLast != index) {
            if (iLast != -1) {
                this.stop(iLast);
            }
            iPlayId = index;
            this.play();
        }
    }

    private final void play() {
        if (iPlayId != -1) {
            try {
                PPlayer[iPlayId].setMediaTime(0L);
            }
            catch (Exception e) {
                SndEx = 2;
            }
            try {
                PPlayer[iPlayId].start();
            }
            catch (Exception e) {
                SndEx = 3;
            }
            iLast = iPlayId;
            iPlayId = -1;
        }
    }

    public final void stop(int index) {
        iStopId = index;
        this.stop();
    }

    public final void stopLast() {
        this.stop(iLast);
    }

    private final void stop() {
        if (iStopId != -1) {
            try {
                PPlayer[iStopId].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            iStopId = -1;
            iLast = -1;
        }
    }

    public final void pause() {
        sndPause = true;
        if (iLast != -1 && aArrRepeat[iLast]) {
            iPausedId = iLast;
        }
        this.stopLast();
        this.stop();
        iPlayId = -1;
    }

    public final void resume() {
        sndPause = false;
        if (iPausedId != -1) {
            this.play(iPausedId);
            iPausedId = -1;
        }
    }

    public final void playerUpdate(Player player, String event, Object object) {
        if (event.equals("endOfMedia")) {
            for (int i = 0; i < iCount; ++i) {
                if (player != PPlayer[i] || !aArrRepeat[i] || sndPause) continue;
                this.play(i);
            }
        }
    }

    static {
        sndPause = false;
    }
}

