/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Ball {
    public static final int BONUS_PROBABILITY = 21;
    public static final int BONUS_ANY_PROBABILITY = 10;
    public static final int BONUS_NONE = 0;
    public static final int BONUS_GLYPH = 1;
    public static final int BONUS_BOMB = 2;
    public static final int BONUS_STAR = 3;
    public static final int BONUS_DIM = 4;
    public static final int BONUS_ANY = 5;
    public static final int COLOR_RED = 1;
    public static final int COLOR_YELLOW = 2;
    public static final int COLOR_PURPLE = 3;
    public static final int COLOR_GREEN = 4;
    public static final int COLOR_BLUE = 5;
    public int position;
    public short color;
    public short bonus;
    public short flyAngle;
    public short flyPos;
    public static short[] availColors = new short[5];
    public boolean refresh;
    public int anim_start;
    public static short numPoints;
    public static short[][] positions;

    public void setRefresh() {
        if (this.position >= 0) {
            this.refresh = true;
            this.anim_start = ChM.iAnimationIndex;
        }
    }

    public static void loadPositions(DataInputStream dataInputStream) {
        try {
            numPoints = dataInputStream.readShort();
            positions = new short[numPoints][2];
            for (int i = 0; i < numPoints; ++i) {
                Ball.positions[i][0] = dataInputStream.readShort();
                Ball.positions[i][1] = dataInputStream.readShort();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public Ball(DataInputStream dataInputStream) {
        this.position = dataInputStream.readInt();
        this.color = dataInputStream.readShort();
        this.bonus = dataInputStream.readShort();
        this.flyAngle = dataInputStream.readShort();
        this.flyPos = dataInputStream.readShort();
        this.refresh = dataInputStream.readBoolean();
        this.anim_start = dataInputStream.readInt();
    }

    public Ball(boolean bl) {
        if (bl) {
            this.color = (short)(Game.rnd(5) + 1);
            this.position = 0;
            if (Game.rnd(100) < 21) {
                this.bonus = (short)(Game.rnd(4) + 1);
                return;
            }
            this.bonus = 0;
            return;
        }
        this.color = Game.ballsLeft > 0 || Game.ballsLeft <= 0 && availColors.length == 0 ? (short)(Game.rnd(5) + 1) : availColors[Game.rnd(availColors.length)];
        this.flyPos = 0;
        if (Game.rnd(100) < 10) {
            this.bonus = (short)5;
            return;
        }
        this.bonus = 0;
    }

    public void drawBall(Graphics graphics, short[] sArray) {
        this.drawBall(graphics, sArray[0], sArray[1]);
    }

    public void drawBall(Graphics graphics) {
        if (this.position >= 0 && this.position < numPoints) {
            this.drawBall(graphics, positions[this.position][0], positions[this.position][1]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBall(Graphics graphics, int n, int n2) {
        if (this.refresh) return;
        if (this.bonus == 0) {
            int n3 = 19;
            switch (this.color) {
                case 5: {
                    n3 = 4;
                    break;
                }
                case 4: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    n3 = 0;
                    break;
                }
                case 2: {
                    n3 = 1;
                    break;
                }
            }
            if (Game.isStopped) {
                ChM.renderAnimImage(graphics, n3, n, n2, 0, 50, false, Game.b);
                return;
            }
            if (Game.isSlowed) {
                ChM.renderAnimImage(graphics, n3, n, n2, 0, 3, false, Game.b);
                return;
            }
            ChM.renderAnimImage(graphics, n3, n, n2, 0, false, Game.b);
            return;
        }
        int n4 = 15;
        switch (this.bonus) {
            case 1: {
                n4 = 47;
                break;
            }
            case 2: {
                n4 = 48;
                break;
            }
            case 3: {
                n4 = 49;
                break;
            }
            case 4: {
                n4 = 50;
                break;
            }
            case 5: {
                n4 = 51;
                break;
            }
        }
        ChM.renderSubImage(graphics, n4, n, n2, 3, Game.b, false);
    }

    public boolean drawExpl(Graphics graphics) {
        int n = 0;
        if (this.position < 0) {
            return false;
        }
        if (this.bonus != 0) {
            n = 10;
        } else {
            switch (this.color) {
                case 5: {
                    n = 9;
                    break;
                }
                case 4: {
                    n = 8;
                    break;
                }
                case 3: {
                    n = 7;
                    break;
                }
                case 1: {
                    n = 5;
                    break;
                }
                case 2: {
                    n = 6;
                }
            }
        }
        if (!ChM.isAnimationFinished(n, this.anim_start)) {
            ChM.renderAnimImage(graphics, n, positions[this.position][0], positions[this.position][1], this.anim_start, false, Game.b);
            return true;
        }
        return false;
    }

    public int compare(Ball ball) {
        if (ball.bonus != 0) {
            return 0;
        }
        if (this.color == ball.color) {
            return 1;
        }
        return -1;
    }
}

