/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.midlet.MIDlet;

class MainCanvas
extends Canvas
implements Runnable {
    public static final int INT_NULL = -9999;
    static MainCanvas canvas;
    public String[] scoreStr;
    public static boolean POW;
    public int[] splashesX;
    public int[] splashesY;
    public int[] splashesDuration;
    public int[] splashesColor;
    public int[] objectX;
    public int[] objectY;
    public int[] objectW;
    public int[] objectH;
    public int[] objectSpeed;
    public int[] objectSpeedY;
    public int[] objectType;
    public int[] objectFrame;
    public int[] objectSpeedBuffer;
    public int MAX_OBJECTS = 10;
    public int[] partX;
    public int[] partY;
    public int[] partW;
    public int[] partH;
    public int[] partSpeed;
    public int[] partSpeedY;
    public int[] partType;
    public int[] partFrame;
    public int[] partSpeedBuffer;
    public int MAX_PARTS = 30;
    public int MAX_LEVELS = 20;
    public int[] levelScore = new int[this.MAX_LEVELS];
    public int level = 0;
    public int score = 0;
    public int recordScore = -9999;
    public int playerLife = 4;
    public int MAX_LIFE = 3;
    public boolean touchDevice = false;
    public boolean arcade = false;
    public int logoDelay = 50;
    public static Font fontSN;
    public boolean music = false;
    public Image landscape = null;
    public BmpFont scoreFont;
    public BmpFont instFont;
    public BmpFont menuFont;
    public CFont cfont = new CFont();
    public Texts texts = new Texts();
    public State state;
    public String source = "";
    public boolean showNotify = false;
    public boolean hideNotify = false;
    public Image imgScoreFont;
    public Image imgInstFont;
    public Image imgMenuFont;
    public static short[] KFontChar;
    public static byte[] KFontCharWidth;
    public static short[] KFontCharXPos;
    public static int controlLength;
    public int OBJ_CIBULA = 0;
    public int OBJ_HUBA = 1;
    public int OBJ_OLIVA = 2;
    public int OBJ_PARADAJKA = 3;
    public int OBJ_SALAMA = 4;
    public int OBJ_SYR = 5;
    public int TYPE_COUNT = 7;
    public int[] levelTask = new int[this.TYPE_COUNT - 1];
    public int[] levelProgress = new int[this.TYPE_COUNT - 1];
    public int OBJECT_FRAMES = 7;
    public Image imgCombo;
    public Sprite sprComboValue;
    public Sprite sprLife;
    public Sprite sprSplash;
    public Sprite[] sprParticles = new Sprite[3];
    public Sprite[] sprGameObjectPart = new Sprite[this.TYPE_COUNT * 2];
    public Sprite[] sprGameObject = new Sprite[this.TYPE_COUNT];
    public String[] objectFile = new String[]{"anim_cibula", "anim_huba", "anim_oliva", "anim_paradajka", "anim_salama", "anim_syr", "anim_poison"};
    public int objectMaxW = 0;
    public int objectMaxH = 0;
    public int startX;
    public int startY;
    public Image imgBackground;
    public Image imgSplash;
    public Image imgLogo;
    public Image imgMenuTop;
    public Image imgMenuBottom;
    public Image imgMenuLeft;
    public Image imgMenuRight;
    public Image imgGameLogo;
    public Sprite sprStars;
    public int menuSelected = 1;
    public int gameMenuSelected = 0;
    public int selectedOffset = 0;
    public int selectedInc = 1;
    public Image imgButton;
    public Sprite sprIcon;
    public int BTN_RESET = 0;
    public int BTN_YES = 1;
    public int BTN_NO = 2;
    public int BTN_SOUND = 3;
    public int BTN_NOSOUND = 4;
    public int BTN_MENU = 5;
    public int BTN_QUIT = 6;
    public int BTN_UP = 7;
    public int BTN_DOWN = 8;
    public int BTN_BACK = 9;
    public int BTN_PAUSE = 10;
    public int BTN_PLAY = 11;
    public int BTN_LOCK = 12;
    public Image imgBoard;
    public Sprite sprTable;
    public Sprite sprSipky;
    public int keySliceH = 0;
    public int levelY;
    public int levelX;
    public int levelSpacing;
    public int mode = 2;
    public int winCounter = 0;
    public boolean wrongSize = false;
    Thread mainThread;
    public static long lastRun;
    public static long runLen;
    boolean playerLeft;
    boolean playerRight;
    boolean playerUp;
    boolean playerDown;
    static final Random randGenerator;
    public int startSpeed;
    public int bufferRatio;
    public int SPACING;
    public int DDA_SHIFT = 1;
    public int SHAKE_BOUNCE = 0;
    public int generatingH = 0;
    public int objectXVel = 2;
    public int generateCounter = 0;
    public int xSpeedBase = 2;
    public int updateCounter = 0;
    public int speedUpdate = 1;
    public int gameMenuFrame = 0;
    public int shakeScore = 0;
    public int shakeLives = 0;
    public int shakeX = 0;
    public int shakeY = 0;
    public int levelSelectedX = 0;
    public int levelSelectedY = 0;
    public Vector vecInstructions = new Vector();
    public int instMoveY = 0;
    public int instY = 0;
    public int instH = 0;
    public int instClipY = 0;
    public int instClipH = 0;
    public int instTextH = 0;
    public int levelTaskH;
    public int levelTaskY = 0;
    public int levelTaskItemsH;
    public static int tableMove;
    public static int moveTableAcc;
    public static int tableAccDec;
    public static boolean instructionReleased;
    public int moveTableY = 0;
    public int runCounter = 0;
    public int newX = -9999;
    public int newY = -9999;
    public int oldX = -9999;
    public int oldY = -9999;
    public int sliceCounter = 0;
    public int SLICE_PARTS = 500;
    public int[] slicePartX = new int[this.SLICE_PARTS];
    public int[] slicePartY = new int[this.SLICE_PARTS];
    public int[] slicePartRand = new int[this.SLICE_PARTS];
    public boolean xUp = false;
    public boolean yUp = false;
    public boolean xChange = false;
    public boolean yChange = false;
    public int comboCounter = 0;
    public int comboValue = 0;
    public int comboDelay = 0;
    public String keyText;
    static int gameKey;
    static int keyStates;
    static int lastKeyStates;
    static boolean keyDown;
    static int actualKeyCode;
    static long startTimer;
    static long endTimer;
    static boolean key_fn1;
    static boolean key_fn2;
    static boolean key_fire;
    static boolean key_left;
    static boolean key_right;
    static boolean key_up;
    static boolean key_down;
    static boolean key_num0;
    static boolean key_num1;
    static boolean key_num2;
    static boolean key_num3;
    static boolean key_num4;
    static boolean key_num5;
    static boolean key_num6;
    static boolean key_num7;
    static boolean key_num8;
    static boolean key_num9;
    public static final int iLeftKey = -6;
    public static final int iRightKey = -7;

    public MainCanvas() {
        super.setFullScreenMode(true);
        canvas = this;
        this.mainThread = new Thread(this);
        this.mainThread.start();
        System.gc();
        this.getResolution();
        this.setPort();
        this.loadLogo();
        this.loadFonts();
        this.loadTable();
        this.loadIcons();
        this.loadBackground();
        this.initObjects();
        this.initLevels();
        this.scoreStr = new String[]{this.texts.getHashedString("ENTER_NAME")};
        this.state = new State();
        if (State.canLoadGame("B")) {
            MainCanvas.trace("loading game");
            this.state.loadGame("B");
        } else {
            this.state.saveGame("B");
        }
    }

    protected void showNotify() {
        this.setPort();
        if (!this.showNotify) {
            this.playMusic();
            this.showNotify = true;
            this.hideNotify = false;
        }
    }

    protected void hideNotify() {
        if (!this.hideNotify) {
            if (this.music) {
                X.soundManager.Stop();
            }
            if (this.mode == 1) {
                this.modeGameMenu();
            }
            this.showNotify = false;
            this.hideNotify = true;
        }
    }

    public void loadFonts() {
        int i;
        try {
            this.imgScoreFont = Image.createImage((String)(this.source + "/numbers.png"));
            this.imgMenuFont = Image.createImage((String)(this.source + "/font.png"));
            this.imgInstFont = Image.createImage((String)(this.source + "/font_instructions.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loading font");
        }
        short[] fntChar = null;
        byte[] fntW = null;
        int spacing = 1;
        if (this.imgScoreFont.getWidth() == 106) {
            fntChar = Fnt.fntNumbers240;
            fntW = Fnt.fntNumbersW240;
        } else if (this.imgScoreFont.getWidth() == 191) {
            fntChar = Fnt.fntNumbers480;
            fntW = Fnt.fntNumbersW480;
        } else if (this.imgScoreFont.getWidth() == 79) {
            fntChar = Fnt.fntNumbers176;
            fntW = Fnt.fntNumbersW176;
        } else if (this.imgScoreFont.getWidth() == 148) {
            fntChar = Fnt.fntNumbers360;
            fntW = Fnt.fntNumbersW360;
        }
        KFontCharXPos = new short[fntW.length];
        for (i = 0; i < fntW.length; ++i) {
            MainCanvas.KFontCharXPos[i] = (short)controlLength;
            controlLength += fntW[i];
        }
        this.scoreFont = new BmpFont(this.imgScoreFont, fntChar, KFontCharXPos, fntW, spacing, false);
        fntChar = null;
        fntW = null;
        KFontChar = null;
        KFontCharWidth = null;
        KFontCharXPos = null;
        controlLength = 0;
        spacing = 2;
        if (this.imgMenuFont.getWidth() == 925) {
            fntChar = Fnt.KFontChar240;
            fntW = Fnt.KFontCharXPos240;
        } else if (this.imgMenuFont.getWidth() == 1735) {
            fntChar = Fnt.KFontChar480;
            fntW = Fnt.KFontCharXPos480;
        } else if (this.imgMenuFont.getWidth() == 831) {
            fntChar = Fnt.KFontChar176;
            fntW = Fnt.KFontCharXPos176;
            spacing = 0;
        } else if (this.imgMenuFont.getWidth() == 550) {
            fntChar = Fnt.KFontChar128;
            fntW = Fnt.KFontCharXPos128;
            spacing = 1;
        } else if (this.imgMenuFont.getWidth() == 1331) {
            fntChar = Fnt.KFontChar360;
            fntW = Fnt.KFontCharXPos360;
        }
        KFontCharXPos = new short[fntW.length];
        for (i = 0; i < fntW.length; ++i) {
            MainCanvas.KFontCharXPos[i] = (short)controlLength;
            controlLength += fntW[i];
        }
        this.menuFont = new BmpFont(this.imgMenuFont, fntChar, KFontCharXPos, fntW, spacing, false);
        fntChar = null;
        fntW = null;
        KFontChar = null;
        KFontCharWidth = null;
        KFontCharXPos = null;
        controlLength = 0;
        spacing = 0;
        if (this.imgInstFont.getWidth() == 831) {
            fntChar = Fnt.KFontCharInst240;
            fntW = Fnt.KFontCharXPosInst240;
        } else if (this.imgInstFont.getWidth() == 1481) {
            fntChar = Fnt.KFontCharInst480;
            fntW = Fnt.KFontCharXPosInst480;
        } else if (this.imgInstFont.getWidth() == 304) {
            fntChar = Fnt.KFontCharInst176;
            fntW = Fnt.KFontCharXPosInst176;
            spacing = 1;
        } else if (this.imgInstFont.getWidth() == 239) {
            fntChar = Fnt.KFontCharInst128;
            fntW = Fnt.KFontCharXPosInst128;
            spacing = 1;
        } else if (this.imgInstFont.getWidth() == 1162) {
            fntChar = Fnt.KFontCharInst360;
            fntW = Fnt.KFontCharXPosInst360;
            spacing = 1;
        }
        KFontCharXPos = new short[fntW.length];
        for (i = 0; i < fntW.length; ++i) {
            MainCanvas.KFontCharXPos[i] = (short)controlLength;
            controlLength += fntW[i];
        }
        this.instFont = new BmpFont(this.imgInstFont, fntChar, KFontCharXPos, fntW, spacing, false);
    }

    public void loadGameObjects() {
        Image tmpImg = null;
        String tmpStr = null;
        try {
            for (int i = 0; i < this.TYPE_COUNT; ++i) {
                tmpStr = this.source + "/" + this.objectFile[i] + ".png";
                tmpImg = Image.createImage((String)tmpStr);
                this.sprGameObject[i] = new Sprite(tmpImg, tmpImg.getWidth() / this.OBJECT_FRAMES, tmpImg.getHeight());
                tmpImg = null;
                System.gc();
                if (this.sprGameObject[i].getWidth() > this.objectMaxW) {
                    this.objectMaxW = this.sprGameObject[i].getWidth();
                }
                if (this.sprGameObject[i].getHeight() > this.objectMaxH) {
                    this.objectMaxH = this.sprGameObject[i].getHeight();
                }
                if (i >= this.TYPE_COUNT - 1) continue;
                tmpStr = this.source + "/" + this.objectFile[i] + "1.png";
                tmpImg = Image.createImage((String)tmpStr);
                this.sprGameObjectPart[i * 2] = new Sprite(tmpImg, tmpImg.getWidth() / this.OBJECT_FRAMES, tmpImg.getHeight());
                tmpImg = null;
                System.gc();
                tmpStr = this.source + "/" + this.objectFile[i] + "2.png";
                tmpImg = Image.createImage((String)tmpStr);
                this.sprGameObjectPart[i * 2 + 1] = new Sprite(tmpImg, tmpImg.getWidth() / this.OBJECT_FRAMES, tmpImg.getHeight());
                tmpImg = null;
                System.gc();
            }
            tmpImg = Image.createImage((String)(this.source + "/lives.png"));
            this.sprLife = new Sprite(tmpImg, tmpImg.getWidth() / 2, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/splash_color.png"));
            this.sprSplash = new Sprite(tmpImg, tmpImg.getWidth() / 3, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/partikle.png"));
            this.sprParticles[0] = new Sprite(tmpImg, tmpImg.getWidth() / 13, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/partikle1.png"));
            this.sprParticles[1] = new Sprite(tmpImg, tmpImg.getWidth() / 13, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/partikle2.png"));
            this.sprParticles[2] = new Sprite(tmpImg, tmpImg.getWidth() / 13, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/3456X.png"));
            this.sprComboValue = new Sprite(tmpImg, tmpImg.getWidth() / 5, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            this.imgCombo = Image.createImage((String)(this.source + "/combo.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadGameObjects() ->" + tmpStr + " :" + e);
        }
    }

    public void releaseGameObjects() {
        for (int i = 0; i < this.TYPE_COUNT; ++i) {
            this.sprGameObject[i] = null;
            this.sprGameObjectPart[i * 2] = null;
            this.sprGameObjectPart[i * 2 + 1] = null;
        }
        this.sprLife = null;
        this.sprSplash = null;
        this.sprParticles[0] = null;
        this.sprParticles[1] = null;
        this.sprParticles[2] = null;
        this.imgCombo = null;
        this.sprComboValue = null;
        System.gc();
    }

    public void dda(int destX, int destY, int shift) {
        int deltaX = destX - this.startX;
        int deltaY = destY - this.startY;
        int count = 0;
        int xAdd = 0;
        int yAdd = 0;
        count = Math.abs(deltaX) > Math.abs(deltaY) ? Math.abs(deltaX) : Math.abs(deltaY);
        if (this.startX != destX && this.startY != destY) {
            xAdd = (deltaX << shift << shift) / (count << shift);
            yAdd = (deltaY << shift << shift) / (count << shift);
        }
        this.startX += xAdd;
        this.startY += yAdd;
        if (Math.abs(deltaX) < Math.abs(xAdd) && Math.abs(deltaY) < Math.abs(yAdd)) {
            this.startX = destX;
            this.startY = destY;
        }
    }

    public void loadBackground() {
        try {
            this.imgBackground = Image.createImage((String)(this.source + "/bg.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadBackground" + e);
        }
    }

    public void releaseBackground() {
        this.imgBackground = null;
        System.gc();
    }

    public void loadSplash() {
        try {
            this.imgSplash = Image.createImage((String)(this.source + "/s.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadSplash" + e);
        }
    }

    public void releaseSplash() {
        this.imgSplash = null;
        System.gc();
    }

    public void loadLogo() {
        try {
            this.imgLogo = Image.createImage((String)(this.source + "/l.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadLogo" + e);
        }
    }

    public void releaseLogo() {
        this.imgLogo = null;
        System.gc();
    }

    public void loadMenu() {
        try {
            this.imgMenuTop = Image.createImage((String)(this.source + "/menu_part3.png"));
            this.imgMenuBottom = Image.createImage((String)(this.source + "/menu_part4.png"));
            this.imgMenuLeft = Image.createImage((String)(this.source + "/menu_part1.png"));
            this.imgMenuRight = Image.createImage((String)(this.source + "/menu_part2.png"));
            this.imgGameLogo = Image.createImage((String)(this.source + "/head_line.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadMenu" + e);
        }
    }

    public void releaseMenu() {
        this.imgMenuTop = null;
        this.imgMenuBottom = null;
        this.imgMenuLeft = null;
        this.imgMenuRight = null;
        this.imgGameLogo = null;
        System.gc();
    }

    public void loadIcons() {
        try {
            this.imgButton = Image.createImage((String)(this.source + "/buton.png"));
            Image tmpImg = Image.createImage((String)(this.source + "/icons.png"));
            this.sprIcon = new Sprite(tmpImg, tmpImg.getWidth() / 13, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/stars.png"));
            this.sprStars = new Sprite(tmpImg, tmpImg.getWidth() / 2, tmpImg.getHeight());
            tmpImg = null;
            System.gc();
            this.imgBoard = Image.createImage((String)(this.source + "/board.png"));
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadIcons" + e);
        }
    }

    public void releaseIcons() {
        this.sprIcon = null;
        System.gc();
    }

    public void loadTable() {
        try {
            Image tmpImg = Image.createImage((String)(this.source + "/dcSkin.png"));
            this.sprTable = new Sprite(tmpImg, tmpImg.getWidth(), tmpImg.getHeight() / 3);
            tmpImg = null;
            System.gc();
            tmpImg = Image.createImage((String)(this.source + "/sipky.png"));
            this.sprSipky = new Sprite(tmpImg, tmpImg.getWidth(), tmpImg.getHeight() / 2);
            tmpImg = null;
            System.gc();
            this.keySliceH = Defines.HEIGHT >> 2;
        }
        catch (Exception e) {
            MainCanvas.trace("Error loadTable" + e);
        }
    }

    public void releasetable() {
        this.sprTable = null;
        System.gc();
    }

    public void initLevels() {
        for (int i = 0; i < this.MAX_LEVELS; ++i) {
            this.levelScore[i] = -9999;
        }
        this.levelScore[0] = 0;
        this.recordScore = -9999;
        this.levelSpacing = Defines.HEIGHT == 128 ? 1 : (Defines.HEIGHT == 208 ? 2 : (Defines.HEIGHT == 260 ? 2 : (Defines.WIDTH > Defines.HEIGHT ? (Defines.HEIGHT - this.imgButton.getWidth() * 5) / 6 : (Defines.WIDTH - this.imgButton.getWidth() * 4) / 5)));
        this.levelY = Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() * 6 - this.levelSpacing * 4 >> 1;
        this.levelX = Defines.WIDTH - this.imgButton.getWidth() * 4 - this.levelSpacing * 4 >> 1;
    }

    public void initObjects() {
        int i;
        this.splashesX = new int[this.MAX_OBJECTS];
        this.splashesY = new int[this.MAX_OBJECTS];
        this.splashesDuration = new int[this.MAX_OBJECTS];
        this.splashesColor = new int[this.MAX_OBJECTS];
        this.objectX = new int[this.MAX_OBJECTS];
        this.objectY = new int[this.MAX_OBJECTS];
        this.objectW = new int[this.MAX_OBJECTS];
        this.objectH = new int[this.MAX_OBJECTS];
        this.objectSpeed = new int[this.MAX_OBJECTS];
        this.objectSpeedY = new int[this.MAX_OBJECTS];
        this.objectFrame = new int[this.MAX_OBJECTS];
        this.objectType = new int[this.MAX_OBJECTS];
        this.objectSpeedBuffer = new int[this.MAX_OBJECTS];
        for (i = 0; i < this.MAX_OBJECTS; ++i) {
            this.splashesX[i] = -9999;
            this.splashesY[i] = -9999;
            this.splashesDuration[i] = -9999;
            this.splashesColor[i] = -9999;
            this.objectX[i] = -9999;
            this.objectY[i] = -9999;
            this.objectW[i] = -9999;
            this.objectH[i] = -9999;
            this.objectSpeed[i] = -9999;
            this.objectSpeedY[i] = -9999;
            this.objectFrame[i] = -9999;
            this.objectType[i] = -9999;
            this.objectSpeedBuffer[i] = -9999;
        }
        this.partX = new int[this.MAX_PARTS];
        this.partY = new int[this.MAX_PARTS];
        this.partW = new int[this.MAX_PARTS];
        this.partH = new int[this.MAX_PARTS];
        this.partSpeed = new int[this.MAX_PARTS];
        this.partSpeedY = new int[this.MAX_PARTS];
        this.partFrame = new int[this.MAX_PARTS];
        this.partType = new int[this.MAX_PARTS];
        this.partSpeedBuffer = new int[this.MAX_PARTS];
        for (i = 0; i < this.MAX_PARTS; ++i) {
            this.partX[i] = -9999;
            this.partY[i] = -9999;
            this.partW[i] = -9999;
            this.partH[i] = -9999;
            this.partSpeed[i] = -9999;
            this.partSpeedY[i] = -9999;
            this.partFrame[i] = -9999;
            this.partType[i] = -9999;
            this.partSpeedBuffer[i] = -9999;
        }
        this.resetSlice();
    }

    public void setLevel(int lvl) {
        for (int i = 0; i < this.TYPE_COUNT - 1; ++i) {
            this.levelTask[i] = 0;
        }
        switch (lvl) {
            case 0: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 0;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 0;
                break;
            }
            case 1: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 1;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 1;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 0;
                break;
            }
            case 2: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 1;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 2;
                this.levelTask[this.OBJ_SYR] = 0;
                break;
            }
            case 3: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 2;
                this.levelTask[this.OBJ_SALAMA] = 1;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 1;
                this.levelTask[this.OBJ_SYR] = 0;
                break;
            }
            case 4: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 0;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 1;
                this.levelTask[this.OBJ_HUBA] = 1;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 5: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 1;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 2;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 6: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 2;
                this.levelTask[this.OBJ_SALAMA] = 2;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 7: {
                this.levelTask[this.OBJ_PARADAJKA] = 3;
                this.levelTask[this.OBJ_OLIVA] = 0;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 2;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 8: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 2;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 2;
                this.levelTask[this.OBJ_HUBA] = 1;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 9: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 1;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 3;
                this.levelTask[this.OBJ_HUBA] = 1;
                this.levelTask[this.OBJ_SYR] = 3;
                break;
            }
            case 10: {
                this.levelTask[this.OBJ_PARADAJKA] = 0;
                this.levelTask[this.OBJ_OLIVA] = 2;
                this.levelTask[this.OBJ_SALAMA] = 2;
                this.levelTask[this.OBJ_CIBULA] = 3;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 11: {
                this.levelTask[this.OBJ_PARADAJKA] = 3;
                this.levelTask[this.OBJ_OLIVA] = 0;
                this.levelTask[this.OBJ_SALAMA] = 2;
                this.levelTask[this.OBJ_CIBULA] = 3;
                this.levelTask[this.OBJ_HUBA] = 1;
                this.levelTask[this.OBJ_SYR] = 0;
                break;
            }
            case 12: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 1;
                this.levelTask[this.OBJ_SALAMA] = 3;
                this.levelTask[this.OBJ_CIBULA] = 2;
                this.levelTask[this.OBJ_HUBA] = 0;
                this.levelTask[this.OBJ_SYR] = 2;
                break;
            }
            case 13: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 3;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 2;
                this.levelTask[this.OBJ_HUBA] = 2;
                this.levelTask[this.OBJ_SYR] = 0;
                break;
            }
            case 14: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 3;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 3;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 15: {
                this.levelTask[this.OBJ_PARADAJKA] = 3;
                this.levelTask[this.OBJ_OLIVA] = 0;
                this.levelTask[this.OBJ_SALAMA] = 1;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 4;
                this.levelTask[this.OBJ_SYR] = 2;
                break;
            }
            case 16: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 2;
                this.levelTask[this.OBJ_SALAMA] = 2;
                this.levelTask[this.OBJ_CIBULA] = 3;
                this.levelTask[this.OBJ_HUBA] = 1;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 17: {
                this.levelTask[this.OBJ_PARADAJKA] = 1;
                this.levelTask[this.OBJ_OLIVA] = 4;
                this.levelTask[this.OBJ_SALAMA] = 0;
                this.levelTask[this.OBJ_CIBULA] = 2;
                this.levelTask[this.OBJ_HUBA] = 3;
                this.levelTask[this.OBJ_SYR] = 1;
                break;
            }
            case 18: {
                this.levelTask[this.OBJ_PARADAJKA] = 3;
                this.levelTask[this.OBJ_OLIVA] = 2;
                this.levelTask[this.OBJ_SALAMA] = 3;
                this.levelTask[this.OBJ_CIBULA] = 0;
                this.levelTask[this.OBJ_HUBA] = 2;
                this.levelTask[this.OBJ_SYR] = 4;
                break;
            }
            case 19: {
                this.levelTask[this.OBJ_PARADAJKA] = 4;
                this.levelTask[this.OBJ_OLIVA] = 3;
                this.levelTask[this.OBJ_SALAMA] = 2;
                this.levelTask[this.OBJ_CIBULA] = 3;
                this.levelTask[this.OBJ_HUBA] = 2;
                this.levelTask[this.OBJ_SYR] = 4;
            }
        }
    }

    public static void trace(String s) {
    }

    public void paintBck(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        g.drawImage(this.imgBackground, 0, 0, 0);
    }

    public void paintGameMenu(Graphics g) {
        int menuY = Defines.HEIGHT - this.imgButton.getHeight() * 3 - (this.SPACING << 1) >> 1;
        int itemH = this.imgButton.getHeight() + this.SPACING;
        this.paintGame(g);
        int offset = 0;
        offset = this.gameMenuSelected == 0 ? this.selectedOffset : 0;
        this.paintCenterButton(this.BTN_PLAY, menuY - offset, g);
        offset = this.gameMenuSelected == 1 ? this.selectedOffset : 0;
        if (this.music) {
            this.paintCenterButton(this.BTN_SOUND, menuY + itemH - offset, g);
        } else {
            this.paintCenterButton(this.BTN_NOSOUND, menuY + itemH - offset, g);
        }
        offset = this.gameMenuSelected == 2 ? this.selectedOffset : 0;
        this.paintCenterButton(this.BTN_MENU, menuY + (itemH << 1) - offset, g);
    }

    public void paintTable(int y, int height, Graphics g) {
        g.setClip(0, y + this.sprTable.getHeight(), Defines.WIDTH, height - (this.sprTable.getHeight() << 1));
        for (int i = 0; i < height / this.sprTable.getHeight() + 1; ++i) {
            this.sprTable.setFrame(1);
            this.sprTable.setPosition(0, y + (i + 1) * this.sprTable.getHeight());
            this.sprTable.paint(g);
        }
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        this.sprTable.setFrame(0);
        this.sprTable.setPosition(0, y);
        this.sprTable.paint(g);
        this.sprTable.setFrame(2);
        this.sprTable.setPosition(0, y + height - this.sprTable.getHeight());
        this.sprTable.paint(g);
    }

    public void paintMenuItems(Graphics g) {
        if (Defines.HEIGHT > 128 && Defines.HEIGHT != 260) {
            g.drawImage(this.imgGameLogo, Defines.WIDTH >> 1, (Defines.HEIGHT >> 1) - this.imgMenuTop.getHeight(), 3);
        }
        int offset = 0;
        offset = this.menuSelected == 0 ? this.selectedOffset : 0;
        g.drawImage(this.imgMenuTop, Defines.WIDTH >> 1, (Defines.HEIGHT >> 1) - offset, 33);
        offset = this.menuSelected == 1 ? this.selectedOffset : 0;
        g.drawImage(this.imgMenuBottom, Defines.WIDTH >> 1, (Defines.HEIGHT >> 1) + offset, 17);
        offset = this.menuSelected == 2 ? this.selectedOffset : 0;
        g.drawImage(this.imgMenuLeft, (Defines.WIDTH >> 1) - offset, Defines.HEIGHT >> 1, 10);
        offset = this.menuSelected == 3 ? this.selectedOffset : 0;
        g.drawImage(this.imgMenuRight, (Defines.WIDTH >> 1) + offset, Defines.HEIGHT >> 1, 6);
    }

    public void paintMenu(Graphics g) {
        this.paintBck(g);
        this.paintMenuItems(g);
        int soundBtn = this.BTN_SOUND;
        if (!this.music) {
            soundBtn = this.BTN_NOSOUND;
        }
        this.paintLeftButton(soundBtn, g);
        this.paintRightButton(this.BTN_QUIT, g);
    }

    public void paintLeftButton(int icon, Graphics g) {
        g.drawImage(this.imgButton, this.SPACING, Defines.HEIGHT - this.SPACING - this.imgButton.getHeight(), 0);
        this.sprIcon.setFrame(icon);
        this.sprIcon.setPosition(this.SPACING + (this.imgButton.getWidth() - this.sprIcon.getWidth() >> 1), Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() + (this.imgButton.getHeight() - this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void paintCenterButton(int icon, int y, Graphics g) {
        g.drawImage(this.imgButton, Defines.WIDTH - this.imgButton.getWidth() >> 1, y, 0);
        this.sprIcon.setFrame(icon);
        this.sprIcon.setPosition(Defines.WIDTH - this.sprIcon.getWidth() >> 1, y + (this.imgButton.getHeight() - this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void paintRightButton(int icon, Graphics g) {
        g.drawImage(this.imgButton, Defines.WIDTH - this.SPACING - this.imgButton.getWidth(), Defines.HEIGHT - this.SPACING - this.imgButton.getHeight(), 0);
        this.sprIcon.setFrame(icon);
        this.sprIcon.setPosition(Defines.WIDTH - this.SPACING - this.imgButton.getWidth() + (this.imgButton.getWidth() - this.sprIcon.getWidth() >> 1), Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() + (this.imgButton.getHeight() - this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void addSplash(int objId) {
        int ID = -9999;
        for (int i = 0; i < this.MAX_OBJECTS; ++i) {
            if (this.splashesX[i] != -9999) continue;
            ID = i;
            i = this.MAX_OBJECTS;
        }
        if (ID != -9999) {
            this.splashesX[ID] = this.objectX[objId];
            this.splashesY[ID] = this.objectY[objId];
            this.splashesDuration[ID] = 20;
            if (this.objectType[objId] == 3 || this.objectType[objId] == 4) {
                this.splashesColor[ID] = 0;
            } else if (this.objectType[objId] == 0 || this.objectType[objId] == 1 || this.objectType[objId] == 5) {
                this.splashesColor[ID] = 1;
            } else if (this.objectType[objId] == 2 || this.objectType[objId] == 6) {
                this.splashesColor[ID] = 2;
            }
        }
    }

    public void addParts(int objId) {
        int ID = -9999;
        int ID2 = -9999;
        for (int i = 0; i < this.MAX_PARTS; ++i) {
            if (this.partX[i] == -9999 && ID == -9999) {
                ID = i;
                continue;
            }
            if (this.partX[i] != -9999 || ID2 != -9999) continue;
            ID2 = i;
            i = this.MAX_PARTS;
        }
        if (ID != -9999) {
            this.partFrame[ID] = 0;
            this.partX[ID] = this.objectX[objId];
            this.partY[ID] = this.objectY[objId];
            this.partType[ID] = this.objectType[objId] * 2;
            this.partSpeed[ID] = 1;
            this.partSpeedBuffer[ID] = this.objectSpeedBuffer[objId];
            this.partSpeedY[ID] = this.objectSpeedY[objId] < 8 ? 8 : this.objectSpeedY[objId];
            this.partW[ID] = this.sprGameObjectPart[this.partType[ID]].getWidth();
            this.partH[ID] = this.sprGameObjectPart[this.partType[ID]].getHeight();
        }
        if (ID2 != -9999) {
            this.partFrame[ID2] = 0;
            this.partX[ID2] = this.objectX[objId];
            this.partY[ID2] = this.objectY[objId];
            this.partType[ID2] = this.objectType[objId] * 2 + 1;
            this.partSpeed[ID2] = -1;
            this.partSpeedBuffer[ID2] = this.objectSpeedBuffer[objId];
            this.partSpeedY[ID2] = this.objectSpeedY[objId] < 8 ? 8 : this.objectSpeedY[objId];
            this.partW[ID2] = this.sprGameObjectPart[this.partType[ID2]].getWidth();
            this.partH[ID2] = this.sprGameObjectPart[this.partType[ID2]].getHeight();
        }
    }

    public void collison(int collisionX, int collisionY) {
        for (int i = 0; i < this.MAX_OBJECTS; ++i) {
            if (this.objectX[i] == -9999) continue;
            int dX = Math.abs(collisionX - this.objectX[i]);
            int dY = Math.abs(collisionY - this.objectY[i]);
            if (dX >= this.objectW[i] >> 1 || dY >= this.objectH[i] >> 1) continue;
            MainCanvas.vibrate(100);
            if (this.objectType[i] == 6) {
                this.removeLife();
            } else {
                this.addParts(i);
                ++this.comboCounter;
                ++this.score;
                if (this.comboCounter == 6) {
                    this.resetSlice();
                }
            }
            this.addSplash(i);
            MainCanvas.generateParticles(30, this.objectX[i], this.objectY[i], this.objectSpeed[i], this.objectSpeedY[i], this.objectType[i]);
            if (this.objectType[i] != 6) {
                if (this.arcade && this.levelTask[this.objectType[i]] < 1) {
                    this.removeLife();
                } else if (this.arcade && this.levelTask[this.objectType[i]] > 0) {
                    int n = this.objectType[i];
                    this.levelTask[n] = this.levelTask[n] - 1;
                }
            }
            this.removeObject(i);
            if (!this.arcade) continue;
            this.checkWin();
        }
    }

    public void checkWin() {
        boolean win = true;
        for (int i = 0; i < this.TYPE_COUNT - 1; ++i) {
            if (this.levelTask[i] <= 0) continue;
            win = false;
        }
        if (win) {
            if (this.levelScore[this.level] < this.playerLife) {
                this.levelScore[this.level] = this.playerLife;
            }
            MainCanvas.trace("score " + this.levelScore[this.level]);
            if (this.level < 19 && this.levelScore[this.level + 1] == -9999) {
                this.levelScore[this.level + 1] = 0;
            }
            this.levelScore[this.level] = this.playerLife - 1;
            this.winCounter = 10;
            this.state.saveGame("B");
            this.mode = 9;
            this.resetShake();
        }
    }

    public void paintSplashes(Graphics g) {
        for (int i = 0; i < this.MAX_OBJECTS; ++i) {
            if (this.splashesX[i] == -9999) continue;
            this.sprSplash.setFrame(this.splashesColor[i]);
            this.sprSplash.setPosition(this.splashesX[i] - (this.sprSplash.getWidth() >> 1), this.splashesY[i] - (this.sprSplash.getHeight() >> 1));
            this.sprSplash.paint(g);
        }
    }

    public void paintGameObject(Graphics g) {
        int i;
        for (i = 0; i < this.MAX_OBJECTS; ++i) {
            if (this.objectX[i] == -9999) continue;
            this.sprGameObject[this.objectType[i]].setFrame(this.objectFrame[i]);
            this.sprGameObject[this.objectType[i]].setPosition(this.objectX[i] - (this.objectW[i] >> 1), this.objectY[i] - (this.objectH[i] >> 1));
            this.sprGameObject[this.objectType[i]].paint(g);
        }
        for (i = 0; i < this.MAX_PARTS; ++i) {
            if (this.partX[i] == -9999) continue;
            this.sprGameObjectPart[this.partType[i]].setFrame(this.partFrame[i]);
            this.sprGameObjectPart[this.partType[i]].setPosition(this.partX[i] - (this.partW[i] >> 1), this.partY[i] - (this.partH[i] >> 1));
            this.sprGameObjectPart[this.partType[i]].paint(g);
        }
    }

    public void paintLives(Graphics g) {
        int shakeLiveX = 0;
        int shakeLiveY = 0;
        if (this.shakeLives > 0) {
            shakeLiveX = this.shakeX;
            shakeLiveY = this.shakeY;
        }
        for (int i = 0; i < this.MAX_LIFE; ++i) {
            if (this.playerLife <= i) {
                this.sprLife.setFrame(1);
            } else {
                this.sprLife.setFrame(0);
            }
            this.sprLife.setPosition(this.SPACING + this.sprLife.getWidth() * i + shakeLiveX, Defines.HEIGHT - this.SPACING - this.sprLife.getHeight() + shakeLiveY);
            this.sprLife.paint(g);
        }
    }

    public void paintScore(Graphics g) {
        if (!this.arcade) {
            int shakeScoreX = 0;
            int shakeScoreY = 0;
            if (this.shakeScore > 0) {
                shakeScoreX = this.shakeX;
                shakeScoreY = this.shakeY;
            }
            this.scoreFont.DrawText(g, this.SPACING + shakeScoreX, this.SPACING + shakeScoreY, this.score + "");
        }
    }

    public void paintSlice(Graphics g) {
        g.setColor(0xFFFFFF);
        for (int i = 0; i < this.SLICE_PARTS; ++i) {
            if (this.slicePartX[i] != -9999 && this.slicePartX[i + 1] != -9999) {
                g.drawLine(this.slicePartX[i], this.slicePartY[i], this.slicePartX[i + 1], this.slicePartY[i + 1]);
                g.drawLine(this.slicePartX[i] + 2, this.slicePartY[i] + 1, this.slicePartX[i + 1] + 1, this.slicePartY[i + 1] + 2);
                continue;
            }
            i = this.SLICE_PARTS;
        }
    }

    public void paintCombo(Graphics g) {
        if (this.comboDelay > 0) {
            int comboY = (Defines.HEIGHT >> 1) - this.imgCombo.getHeight();
            g.drawImage(this.imgCombo, Defines.WIDTH - this.imgCombo.getWidth() >> 1, comboY, 0);
            this.sprComboValue.setFrame(this.comboValue - 3);
            this.sprComboValue.setPosition((Defines.WIDTH >> 1) - this.sprComboValue.getWidth(), Defines.HEIGHT >> 1);
            this.sprComboValue.paint(g);
            this.sprComboValue.setFrame(4);
            this.sprComboValue.setPosition(Defines.WIDTH >> 1, Defines.HEIGHT >> 1);
            this.sprComboValue.paint(g);
        }
    }

    public void keySlice(int y1, int y2) {
        if (!this.touchDevice) {
            this.resetSlice();
            this.startX = 0;
            this.startY = y1 * this.keySliceH;
            this.newX = Defines.WIDTH;
            this.newY = y2 * this.keySliceH + 1;
            this.slicePartX[0] = this.newX;
            this.slicePartY[0] = this.newY;
            this.slice();
        }
    }

    public void paintKeySlice(Graphics g) {
        if (!this.touchDevice) {
            for (int i = 1; i < 4; ++i) {
                this.sprSipky.setFrame(0);
                this.sprSipky.setPosition(0, i * this.keySliceH - (this.sprSipky.getHeight() >> 1));
                this.sprSipky.paint(g);
                this.sprSipky.setFrame(1);
                this.sprSipky.setPosition(Defines.WIDTH - this.sprSipky.getWidth(), i * this.keySliceH - (this.sprSipky.getHeight() >> 1));
                this.sprSipky.paint(g);
            }
        }
    }

    public void paintWin(Graphics g) {
        this.paintBck(g);
        this.paintSplashes(g);
        this.paintGameObject(g);
        Particles.paintParticles(g);
        this.paintLives(g);
        this.paintScore(g);
        this.paintSlice(g);
        this.paintKeySlice(g);
        if (this.winCounter == 0) {
            int tableH = this.instFont.getHeight() * 5 + this.sprTable.getHeight() * 2;
            int tableY = Defines.HEIGHT - tableH >> 1;
            this.paintTable(Defines.HEIGHT - tableH >> 1, tableH, g);
            this.instFont.DrawText(g, Defines.WIDTH - this.instFont.GetTextWidth(this.texts.getHashedString("LEVEL")) >> 1, tableY + this.sprTable.getHeight(), this.texts.getHashedString("LEVEL"));
            this.instFont.DrawText(g, Defines.WIDTH - this.instFont.GetTextWidth(this.texts.getHashedString("COMPLETED")) >> 1, tableY + this.sprTable.getHeight() + (this.instFont.getHeight() * 3 >> 1), this.texts.getHashedString("COMPLETED"));
            int starX = Defines.WIDTH - this.sprStars.getWidth() * 5 >> 1;
            for (int i = 0; i < 3; ++i) {
                if (this.levelScore[this.level] >= i) {
                    this.sprStars.setFrame(0);
                } else {
                    this.sprStars.setFrame(1);
                }
                this.sprStars.setPosition(starX + i * (this.sprStars.getWidth() << 1), tableY + this.sprTable.getHeight() + this.instFont.getHeight() * 3);
                this.sprStars.paint(g);
            }
            this.paintRightButton(this.BTN_YES, g);
        }
    }

    public void paintGameOver(Graphics g) {
        this.paintBck(g);
        this.paintSplashes(g);
        this.paintGameObject(g);
        Particles.paintParticles(g);
        this.paintLives(g);
        this.paintScore(g);
        this.paintSlice(g);
        this.paintKeySlice(g);
        if (this.winCounter == 0) {
            int tableH = this.instFont.getHeight() + this.sprTable.getHeight() * 2;
            int tableY = Defines.HEIGHT - tableH >> 1;
            this.paintTable(Defines.HEIGHT - tableH >> 1, tableH, g);
            this.instFont.DrawText(g, Defines.WIDTH - this.instFont.GetTextWidth(this.texts.getHashedString("GAME_OVER")) >> 1, tableY + this.sprTable.getHeight(), this.texts.getHashedString("GAME_OVER"));
            this.paintRightButton(this.BTN_YES, g);
        }
    }

    public void paintGame(Graphics g) {
        this.paintBck(g);
        this.paintSplashes(g);
        this.paintGameObject(g);
        Particles.paintParticles(g);
        this.paintLives(g);
        this.paintScore(g);
        this.paintSlice(g);
        this.paintCombo(g);
        this.paintKeySlice(g);
    }

    public void paintInstructions(Graphics g) {
        this.paintBck(g);
        this.paintTable(this.instY, this.instH, g);
        g.setClip(0, this.instClipY, Defines.WIDTH, this.instClipH);
        this.cfont.drawLineSeparatedText(this.vecInstructions, 0, this.SPACING, this.instClipY + tableMove, Defines.WIDTH - (this.SPACING << 1), this.instTextH, g);
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        this.paintLeftButton(this.BTN_BACK, g);
    }

    public void paintGameCompleted(Graphics g) {
        this.paintBck(g);
        this.paintTable(this.instY, this.instH, g);
        g.setClip(0, this.instClipY, Defines.WIDTH, this.instClipH);
        this.cfont.drawLineSeparatedText(this.vecInstructions, 0, this.SPACING, this.instClipY + tableMove, Defines.WIDTH - (this.SPACING << 1), 1000, g);
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
        this.paintRightButton(this.BTN_YES, g);
    }

    public void paintLogo(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        g.drawImage(this.imgLogo, Defines.WIDTH - this.imgLogo.getWidth() >> 1, Defines.HEIGHT - this.imgLogo.getHeight() >> 1, 0);
    }

    public void paintsplash(Graphics g) {
        g.drawImage(this.imgSplash, Defines.WIDTH - this.imgSplash.getWidth() >> 1, Defines.HEIGHT - this.imgSplash.getHeight() >> 1, 0);
    }

    public void paintBoardDialog(int y, String str, Graphics g) {
        g.drawImage(this.imgBoard, Defines.WIDTH - this.imgBoard.getWidth() >> 1, y, 0);
        this.menuFont.DrawText(g, Defines.WIDTH - this.menuFont.GetTextWidth(str) >> 1, y + (this.imgBoard.getHeight() - this.menuFont.getHeight() >> 1), str);
    }

    public void paintIcon(int x, int y, int icon, Graphics g) {
        g.drawImage(this.imgButton, x, y, 0);
        this.sprIcon.setFrame(icon);
        this.sprIcon.setPosition(x + (this.imgButton.getWidth() - this.sprIcon.getWidth() >> 1), y + (this.imgButton.getHeight() - this.sprIcon.getHeight() >> 1));
        this.sprIcon.paint(g);
    }

    public void paintLevelIcon(int x, int y, int lvl, Graphics g) {
        int ySpacing = (this.imgButton.getHeight() - this.menuFont.getHeight() - this.sprStars.getHeight()) / 3;
        g.drawImage(this.imgButton, x, y, 0);
        this.menuFont.DrawText(g, x + (this.imgButton.getWidth() - this.menuFont.GetTextWidth("" + lvl) >> 1), y + ySpacing, "" + lvl);
        int starX = this.imgButton.getWidth() - this.sprStars.getWidth() * 3 >> 1;
        for (int i = 0; i < 3; ++i) {
            if (this.levelScore[lvl - 1] >= i) {
                this.sprStars.setFrame(0);
            } else {
                this.sprStars.setFrame(1);
            }
            this.sprStars.setPosition(x + starX + i * this.sprStars.getWidth(), y + ySpacing + this.menuFont.getHeight());
            this.sprStars.paint(g);
        }
    }

    public void paintLevelIcons(Graphics g) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                int levelID = i * 4 + j;
                if (levelID == this.levelSelectedY * 4 + this.levelSelectedX) {
                    if (this.levelScore[levelID] != -9999) {
                        this.paintLevelIcon(this.levelSpacing + j * (this.imgButton.getWidth() + this.levelSpacing) + this.shakeX + this.levelX, this.levelY + i * (this.imgButton.getHeight() + this.levelSpacing) + this.shakeY, levelID + 1, g);
                        continue;
                    }
                    this.paintIcon(this.levelSpacing + j * (this.imgButton.getWidth() + this.levelSpacing) + this.shakeY + this.levelX, this.levelY + i * (this.imgButton.getHeight() + this.levelSpacing) + this.shakeY, this.BTN_LOCK, g);
                    continue;
                }
                if (this.levelScore[levelID] != -9999) {
                    this.paintLevelIcon(this.levelSpacing + j * (this.imgButton.getWidth() + this.levelSpacing) + this.levelX, this.levelY + i * (this.imgButton.getHeight() + this.levelSpacing), levelID + 1, g);
                    continue;
                }
                this.paintIcon(this.levelSpacing + j * (this.imgButton.getWidth() + this.levelSpacing) + this.levelX, this.levelY + i * (this.imgButton.getHeight() + this.levelSpacing), this.BTN_LOCK, g);
            }
        }
    }

    public void paintLevelSelect(Graphics g) {
        this.paintBck(g);
        this.paintLevelIcons(g);
        this.paintLeftButton(this.BTN_BACK, g);
    }

    public void paintTaskItems(Graphics g) {
        this.paintBoardDialog(this.SPACING, "LEVEL " + (this.level + 1), g);
        int yOffset = (this.SPACING << 1) + this.imgBoard.getHeight() + this.sprTable.getHeight();
        int itemY = 0;
        this.paintTable(yOffset - this.sprTable.getHeight(), this.levelTaskH + (this.sprTable.getHeight() << 1), g);
        g.setClip(0, yOffset, Defines.WIDTH, this.levelTaskH);
        for (int i = 0; i < this.TYPE_COUNT - 1; ++i) {
            if (this.levelTask[i] <= 0) continue;
            int btnX = (Defines.WIDTH >> 1) - this.imgButton.getWidth() - this.SPACING;
            int btnY = itemY * (this.objectMaxH + this.SPACING) + (this.objectMaxH - this.imgButton.getHeight() >> 1) + yOffset + this.levelTaskY;
            g.drawImage(this.imgButton, btnX, btnY, 0);
            String str = this.levelTask[i] + "X";
            this.menuFont.DrawText(g, btnX + (this.imgButton.getWidth() - this.menuFont.GetTextWidth(str) >> 1), btnY + (this.imgButton.getHeight() - this.menuFont.getHeight() >> 1), str);
            this.sprGameObject[i].setFrame(0);
            this.sprGameObject[i].setPosition((Defines.WIDTH >> 1) + this.SPACING + (this.objectMaxW - this.sprGameObject[i].getWidth() >> 1), btnY + (this.objectMaxH - this.sprGameObject[i].getHeight() >> 1));
            this.sprGameObject[i].paint(g);
            ++itemY;
        }
        g.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
    }

    public void paintLevelTask(Graphics g) {
        this.paintBck(g);
        this.paintTaskItems(g);
        this.paintLeftButton(this.BTN_BACK, g);
        this.paintRightButton(this.BTN_PLAY, g);
    }

    public void paintSounds(Graphics g) {
        this.paintBck(g);
        this.paintsplash(g);
        this.paintBoardDialog(Defines.HEIGHT - this.imgBoard.getHeight() >> 1, this.texts.getHashedString("ENABLE_SOUNDS"), g);
        this.paintLeftButton(this.BTN_NOSOUND, g);
        this.paintRightButton(this.BTN_SOUND, g);
    }

    public void paintLoading(Graphics g) {
        g.drawImage(this.imgBoard, Defines.WIDTH - this.imgBoard.getWidth() >> 1, Defines.HEIGHT - this.imgBoard.getHeight() >> 1, 0);
        this.menuFont.DrawText(g, Defines.WIDTH - this.menuFont.GetTextWidth(this.texts.getHashedString("LOADING")) >> 1, Defines.HEIGHT - this.menuFont.getHeight() >> 1, this.texts.getHashedString("LOADING"));
    }

    public void paint(Graphics g) {
        this.getResolution();
        if (Defines.WIDTH - 3 > Defines.HEIGHT) {
            if (!this.wrongSize) {
                this.hideNotify();
            }
            this.wrongSize = true;
        } else {
            if (this.wrongSize) {
                this.showNotify();
            }
            this.wrongSize = false;
        }
        if (!this.wrongSize) {
            switch (this.mode) {
                case 2: {
                    this.paintLogo(g);
                    break;
                }
                case 3: {
                    this.paintBck(g);
                    this.paintsplash(g);
                    break;
                }
                case 0: {
                    this.paintMenu(g);
                    break;
                }
                case 1: {
                    this.paintGame(g);
                    this.paintRightButton(this.BTN_PAUSE, g);
                    break;
                }
                case 4: {
                    this.paintInstructions(g);
                    break;
                }
                case 5: {
                    this.paintGameMenu(g);
                    break;
                }
                case 6: {
                    this.paintLevelSelect(g);
                    break;
                }
                case 7: {
                    this.paintLevelTask(g);
                    break;
                }
                case 8: {
                    this.paintSounds(g);
                    break;
                }
                case 9: {
                    this.paintWin(g);
                    break;
                }
                case 10: {
                    this.paintGameOver(g);
                    break;
                }
                case 11: {
                    this.paintLoading(g);
                    break;
                }
                case 12: {
                    this.paintGameCompleted(g);
                }
            }
        } else {
            this.paintWarningLAndscape(g);
        }
    }

    public void getResolution() {
        Defines.WIDTH = this.getWidth();
        Defines.HEIGHT = this.getHeight();
    }

    public void paintWarningLAndscape(Graphics g) {
        if (this.landscape == null) {
            try {
                this.landscape = Image.createImage((String)(this.source + "/warning_landscape.png"));
            }
            catch (IOException e) {
                MainCanvas.trace("Exception :" + e);
            }
        }
        g.setColor(0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.landscape, this.getWidth() - this.landscape.getWidth() >> 1, this.getHeight() - this.landscape.getHeight() >> 1, 0);
    }

    public void updateKeysForRun() {
        this.playerLeft = (keyStates & 4) != 0;
        this.playerRight = (keyStates & 0x20) != 0;
        this.playerUp = (keyStates & 2) != 0;
        this.playerDown = (keyStates & 0x40) != 0;
    }

    static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    static final int getRandomUInt(int max) {
        return Math.abs(randGenerator.nextInt() % max);
    }

    public void setPort() {
        this.SHAKE_BOUNCE = (Defines.HEIGHT << 1) / 100;
        if (Defines.WIDTH == 240) {
            this.objectXVel = 2;
            this.startSpeed = 50;
            this.bufferRatio = 4;
            this.SPACING = 5;
            this.DDA_SHIFT = 2;
            this.generatingH = 320;
        } else if (Defines.WIDTH == 480 && Defines.HEIGHT > 600) {
            this.xSpeedBase = 4;
            this.objectXVel = 2;
            this.startSpeed = 80;
            this.bufferRatio = 2;
            this.SPACING = 5;
            this.DDA_SHIFT = 2;
            this.generatingH = 800;
            this.speedUpdate = 2;
        } else if (Defines.WIDTH == 208) {
            this.objectXVel = 2;
            this.startSpeed = 42;
            this.bufferRatio = 4;
            this.SPACING = 5;
            this.DDA_SHIFT = 2;
            this.generatingH = 208;
        } else if (Defines.WIDTH == 220) {
            this.objectXVel = 2;
            this.startSpeed = 38;
            this.bufferRatio = 4;
            this.SPACING = 5;
            this.DDA_SHIFT = 2;
            this.generatingH = 176;
            this.SHAKE_BOUNCE = 8;
        } else if (Defines.WIDTH == 480 && Defines.HEIGHT < 600) {
            this.objectXVel = 4;
            this.startSpeed = 53;
            this.bufferRatio = 4;
            this.SPACING = 5;
            this.DDA_SHIFT = 2;
            this.generatingH = 360;
        } else if (Defines.WIDTH == 176) {
            this.objectXVel = 1;
            this.startSpeed = 45;
            this.bufferRatio = 5;
            this.SPACING = 2;
            this.DDA_SHIFT = 2;
            this.generatingH = 220;
            this.SHAKE_BOUNCE = 8;
        } else if (Defines.WIDTH == 128) {
            this.objectXVel = 1;
            this.startSpeed = 43;
            this.bufferRatio = 6;
            this.SPACING = 2;
            this.DDA_SHIFT = 2;
            this.generatingH = 160;
            this.SHAKE_BOUNCE = 5;
        } else if (Defines.WIDTH == 360) {
            this.objectXVel = 3;
            this.startSpeed = 48;
            this.bufferRatio = 2;
            this.SPACING = 2;
            this.DDA_SHIFT = 2;
            this.generatingH = 640;
            this.SHAKE_BOUNCE = 5;
        } else if (Defines.WIDTH == 320 && Defines.HEIGHT < 480) {
            this.objectXVel = 2;
            this.startSpeed = 50;
            this.bufferRatio = 4;
            this.SPACING = 5;
            this.DDA_SHIFT = 2;
            this.generatingH = 320;
        } else {
            this.generatingH = Defines.HEIGHT;
        }
    }

    public void generateObject() {
        if (this.generateCounter == 0) {
            int rand = MainCanvas.getRandomUInt(this.arcade ? 40 : 20);
            if (rand == 0) {
                int id = -9999;
                for (int i = 0; i < this.MAX_OBJECTS; ++i) {
                    if (this.objectX[i] != -9999) continue;
                    id = i;
                    i = this.MAX_OBJECTS;
                }
                if (id != -9999) {
                    this.generateCounter = 10;
                    this.objectType[id] = MainCanvas.getRandomUInt(this.TYPE_COUNT);
                    this.objectFrame[id] = 0;
                    this.objectW[id] = this.sprGameObject[this.objectType[id]].getWidth();
                    this.objectH[id] = this.sprGameObject[this.objectType[id]].getHeight();
                    int side = MainCanvas.getRandomUInt(2);
                    if (side == 0) {
                        this.objectX[id] = Defines.WIDTH + this.objectW[id];
                        this.objectSpeed[id] = -(this.xSpeedBase + MainCanvas.getRandomUInt(this.objectXVel));
                    } else {
                        this.objectX[id] = -this.objectW[id];
                        this.objectSpeed[id] = this.xSpeedBase + MainCanvas.getRandomUInt(this.objectXVel);
                    }
                    this.objectSpeedY[id] = -this.startSpeed;
                    this.objectSpeedBuffer[id] = 0;
                    this.objectY[id] = this.generatingH + this.objectH[id];
                }
            }
        } else {
            --this.generateCounter;
        }
    }

    public void resetShake() {
        this.shakeX = 0;
        this.shakeY = 0;
        this.shakeLives = 0;
        this.shakeScore = 0;
    }

    public void removeLife() {
        --this.playerLife;
        this.shakeLives = 10;
        if (this.playerLife == 0) {
            if (this.recordScore < this.score) {
                this.recordScore = this.score;
            }
            this.winCounter = 10;
            if (!this.arcade) {
                this.state.saveGame("B");
            }
            this.mode = 10;
            this.resetShake();
        }
    }

    public void updateObjects() {
        int i;
        for (i = 0; i < this.MAX_OBJECTS; ++i) {
            if (this.splashesDuration[i] > 0) {
                int n = i;
                this.splashesDuration[n] = this.splashesDuration[n] - 1;
            } else {
                this.splashesX[i] = -9999;
            }
            if (this.objectX[i] == -9999) continue;
            if (this.runCounter % 3 == 0) {
                int n = i;
                this.objectFrame[n] = this.objectFrame[n] + 1;
                if (this.objectFrame[i] == this.OBJECT_FRAMES) {
                    this.objectFrame[i] = 0;
                }
            }
            int n = i;
            this.objectSpeedBuffer[n] = this.objectSpeedBuffer[n] + this.objectSpeedY[i];
            int n2 = i;
            this.objectY[n2] = this.objectY[n2] + this.objectSpeedBuffer[i] / this.bufferRatio;
            this.objectSpeedBuffer[i] = this.objectSpeedBuffer[i] % this.bufferRatio;
            int n3 = i;
            this.objectSpeedY[n3] = this.objectSpeedY[n3] + this.speedUpdate;
            int n4 = i;
            this.objectX[n4] = this.objectX[n4] + this.objectSpeed[i];
            if (this.objectY[i] - this.objectH[i] <= Defines.HEIGHT || this.objectSpeedY[i] <= 0) continue;
            if (this.objectType[i] != 6 && (this.arcade && this.levelTask[this.objectType[i]] > 0 || !this.arcade)) {
                this.removeLife();
            }
            this.removeObject(i);
        }
        for (i = 0; i < this.MAX_PARTS; ++i) {
            if (this.partX[i] == -9999) continue;
            if (this.runCounter % 3 == 0) {
                int n = i;
                this.partFrame[n] = this.partFrame[n] + 1;
                if (this.partFrame[i] == this.OBJECT_FRAMES) {
                    this.partFrame[i] = 0;
                }
            }
            int n = i;
            this.partSpeedBuffer[n] = this.partSpeedBuffer[n] + this.partSpeedY[i];
            int n5 = i;
            this.partY[n5] = this.partY[n5] + this.partSpeedBuffer[i] / (this.bufferRatio - 1);
            this.partSpeedBuffer[i] = this.partSpeedBuffer[i] % (this.bufferRatio - 1);
            int n6 = i;
            this.partSpeedY[n6] = this.partSpeedY[n6] + 1;
            int n7 = i;
            this.partX[n7] = this.partX[n7] + this.partSpeed[i];
            if (this.partY[i] - this.partH[i] <= Defines.HEIGHT || this.partSpeedY[i] <= 0) continue;
            this.removePart(i);
        }
    }

    public void runGameMenu() {
        if (!this.touchDevice) {
            if (this.runCounter % 2 == 0) {
                if (this.selectedOffset <= this.SPACING && this.selectedOffset >= 0) {
                    this.selectedOffset += this.selectedInc;
                } else {
                    this.selectedInc *= -1;
                    this.selectedOffset += this.selectedInc;
                }
            }
        } else {
            this.selectedOffset = 0;
        }
    }

    static void vibrate(int delay) {
    }

    static void generateParticles(int count, int x, int y, int velX, int velY, int type) {
        for (int i = 0; i < count; ++i) {
            int velocityX = velX + MainCanvas.getRandomInt(7);
            int velocityY = MainCanvas.getRandomInt(7);
            int accX = 0;
            int accY = 1;
            int partColor = 0;
            if (type == 2 || type == 6) {
                partColor = 1;
            } else if (type == 0 || type == 1 || type == 5) {
                partColor = 2;
            }
            Particles.createParticle(x + MainCanvas.getRandomInt(5), y + MainCanvas.getRandomInt(5), Defines.HEIGHT, velocityX, velocityY, accX, accY, 6 + MainCanvas.getRandomUInt(10), partColor, 15 + MainCanvas.getRandomUInt(15), 0, MainCanvas.getRandomUInt(13));
        }
    }

    public void removeObject(int object) {
        this.objectX[object] = -9999;
        this.objectY[object] = -9999;
        this.objectSpeed[object] = -9999;
        this.objectSpeedY[object] = -9999;
        this.objectW[object] = -9999;
        this.objectH[object] = -9999;
    }

    public void removePart(int object) {
        this.partX[object] = -9999;
        this.partY[object] = -9999;
        this.partSpeed[object] = -9999;
        this.partSpeedY[object] = -9999;
        this.partW[object] = -9999;
        this.partH[object] = -9999;
    }

    public void updateCombo() {
        if (this.comboDelay > 0) {
            --this.comboDelay;
        }
    }

    public void updateEffects() {
        if (this.shakeScore > 0 || this.shakeLives > 0 || this.mode == 6 && !this.touchDevice) {
            if (this.mode == 6) {
                this.shakeX = MainCanvas.getRandomInt(this.SHAKE_BOUNCE >> 1);
                this.shakeY = MainCanvas.getRandomInt(this.SHAKE_BOUNCE >> 1);
            } else {
                this.shakeX = MainCanvas.getRandomInt(this.SHAKE_BOUNCE);
                this.shakeY = MainCanvas.getRandomInt(this.SHAKE_BOUNCE);
            }
            if (this.shakeScore > 0) {
                --this.shakeScore;
            } else {
                --this.shakeLives;
            }
        }
    }

    public void runLevelSelect() {
        this.updateEffects();
    }

    public void runGame() {
        this.generateObject();
        this.updateObjects();
        Particles.updateParticles();
        this.updateCombo();
        this.updateEffects();
        this.updateslice();
    }

    public void runLogo() {
        if (this.runCounter >= this.logoDelay) {
            this.mode = 11;
            this.serviceRepaints();
            this.releaseLogo();
            this.loadSplash();
            this.mode = 3;
        }
    }

    public void runSplash() {
        if (this.runCounter >= this.logoDelay << 1) {
            this.mode = 8;
        }
    }

    public void playMusic() {
        if (this.music) {
            X.soundManager.Stop();
            if (this.mode == 1 || this.mode == 5 || this.mode == 10 || this.mode == 9) {
                X.soundManager.Play(1, -1);
            } else if (this.mode != 2 || this.mode != 3 || this.mode != 8) {
                X.soundManager.Play(0, -1);
            }
        }
    }

    public void changeMusic() {
        if (this.music) {
            X.soundManager.Stop();
            this.music = false;
        } else {
            this.music = true;
            this.playMusic();
        }
    }

    public void selectMenu(int selected) {
        this.menuSelected = selected;
        this.selectedInc = 1;
        this.selectedOffset = 0;
    }

    public void modeInstructions() {
        tableMove = 0;
        String strInst = this.touchDevice ? this.texts.getHashedString("INST_TXT") + " \n \n " + this.texts.getHashedString("TOUCH_CONTROLS") : this.texts.getHashedString("INST_TXT") + " \n \n " + this.texts.getHashedString("KEY_CONTROLS");
        this.cfont.reset();
        this.cfont.setFont(fontSN);
        this.cfont.bCentering = false;
        this.vecInstructions = this.cfont.preprocessText(strInst, Defines.WIDTH - (this.SPACING << 1));
        this.instY = this.SPACING;
        this.instH = Defines.HEIGHT - this.imgButton.getHeight() - this.SPACING * 3;
        this.instClipY = this.instY + this.sprTable.getHeight();
        this.instClipH = this.instH - (this.sprTable.getHeight() << 1);
        this.instTextH = this.vecInstructions.size() * (this.instFont.getHeight() + this.cfont.iLineSpacing);
        this.mode = 4;
    }

    public void modeGameCompleted() {
        tableMove = 0;
        String strInst = this.texts.getHashedString("GAME_COMPLETED");
        this.cfont.reset();
        this.cfont.setFont(fontSN);
        this.cfont.bCentering = true;
        this.vecInstructions = this.cfont.preprocessText(strInst, Defines.WIDTH - (this.SPACING << 1));
        this.instY = this.SPACING;
        this.instH = Defines.HEIGHT - this.imgButton.getHeight() - this.SPACING * 3;
        this.instClipY = this.instY + this.sprTable.getHeight();
        this.instClipH = this.instH - (this.sprTable.getHeight() << 1);
        this.instTextH = this.vecInstructions.size() * (this.instFont.getHeight() + this.cfont.iLineSpacing);
        this.mode = 12;
    }

    public void modeMainMenu() {
        this.releaseGameObjects();
        if (this.imgMenuTop == null) {
            this.loadMenu();
        }
        this.menuSelected = 1;
        this.selectedInc = 1;
        this.selectedOffset = 0;
        this.mode = 0;
    }

    public void modeGameMenu() {
        this.gameMenuSelected = 0;
        this.mode = 5;
    }

    public void startArcadeLevel() {
        this.keySliceH = Defines.HEIGHT >> 2;
        this.mode = 1;
        this.playMusic();
    }

    public void enterMainMenuItem(int selected) {
        switch (selected) {
            case 0: {
                X.singleton.startScoreCanvas(true);
                break;
            }
            case 1: {
                this.modeInstructions();
                break;
            }
            case 2: {
                this.mode = 11;
                this.serviceRepaints();
                this.releaseMenu();
                this.loadGameObjects();
                this.arcade = false;
                this.score = 0;
                this.resetGame();
                this.keySliceH = Defines.HEIGHT >> 2;
                this.mode = 1;
                this.playMusic();
                break;
            }
            case 3: {
                if (State.canLoadGame("B")) {
                    MainCanvas.trace("loading game");
                    this.state.loadGame("B");
                }
                this.mode = 11;
                this.serviceRepaints();
                this.releaseMenu();
                this.loadGameObjects();
                this.levelSpacing = Defines.HEIGHT == 128 ? 1 : (Defines.HEIGHT == 208 ? 2 : (Defines.HEIGHT == 260 ? 2 : (Defines.WIDTH > Defines.HEIGHT ? (Defines.HEIGHT - this.imgButton.getWidth() * 5) / 6 : (Defines.WIDTH - this.imgButton.getWidth() * 4) / 5)));
                this.levelY = Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() * 6 - this.levelSpacing * 4 >> 1;
                this.levelX = Defines.WIDTH - this.imgButton.getWidth() * 4 - this.levelSpacing * 4 >> 1;
                this.mode = 6;
            }
        }
    }

    public void enterLevel(int lvl) {
        this.arcade = true;
        this.resetGame();
        this.levelTaskY = 0;
        if (this.levelScore[lvl] != -9999) {
            this.setLevel(lvl);
            this.mode = 7;
        }
        this.levelTaskH = Defines.HEIGHT - (this.SPACING << 2) - this.imgButton.getHeight() - this.imgBoard.getHeight() - (this.sprTable.getHeight() << 1);
        this.levelTaskItemsH = 0;
        for (int i = 0; i < this.TYPE_COUNT - 1; ++i) {
            if (this.levelTask[i] <= 0) continue;
            this.levelTaskItemsH += this.objectMaxH + this.SPACING;
        }
    }

    public void enterGameMenuItem(int selected) {
        switch (selected) {
            case 0: {
                this.mode = 1;
                break;
            }
            case 1: {
                this.changeMusic();
                break;
            }
            case 2: {
                this.mode = 11;
                this.serviceRepaints();
                this.modeMainMenu();
                this.playMusic();
                break;
            }
        }
    }

    public void runMenu() {
        if (!this.touchDevice) {
            if (this.runCounter % 2 == 0) {
                if (this.selectedOffset <= this.SPACING && this.selectedOffset >= 0) {
                    this.selectedOffset += this.selectedInc;
                } else {
                    this.selectedInc *= -1;
                    this.selectedOffset += this.selectedInc;
                }
            }
        } else {
            this.selectedOffset = 0;
        }
    }

    public void runLevelTask() {
        if (this.levelTaskItemsH > this.levelTaskH) {
            if (this.playerUp) {
                this.levelTaskY += 3;
            }
            if (this.playerDown) {
                this.levelTaskY -= 3;
            }
            if (this.levelTaskY > 0) {
                this.levelTaskY = 0;
            }
            if (this.levelTaskY < -(this.levelTaskItemsH - this.levelTaskH)) {
                this.levelTaskY = -(this.levelTaskItemsH - this.levelTaskH);
            }
        } else {
            this.levelTaskY = 0;
        }
    }

    public void runInstruction() {
        if (this.playerUp) {
            tableMove += 3;
        }
        if (this.playerDown) {
            tableMove -= 3;
        }
        if (tableMove > 0) {
            tableMove = 0;
        }
        if (Math.abs(tableMove) + this.instClipH > this.instTextH) {
            tableMove = -this.instTextH + this.instClipH;
        }
    }

    public void runWin() {
        if (this.winCounter > 0) {
            --this.winCounter;
        }
    }

    public void run() {
        while (this.mainThread == Thread.currentThread()) {
            long startRun = System.currentTimeMillis();
            if (Display.getDisplay((MIDlet)X.singleton).getCurrent() != this || startRun - lastRun < 35L) continue;
            this.updateKeysForRun();
            ++this.runCounter;
            if (this.runCounter > 9999) {
                this.runCounter = 0;
            }
            switch (this.mode) {
                case 1: {
                    this.runGame();
                    break;
                }
                case 2: {
                    this.runLogo();
                    break;
                }
                case 3: {
                    this.runSplash();
                    break;
                }
                case 0: {
                    this.runMenu();
                    break;
                }
                case 5: {
                    this.runGameMenu();
                    break;
                }
                case 4: {
                    this.runInstruction();
                    break;
                }
                case 7: {
                    this.runLevelTask();
                    break;
                }
                case 6: {
                    this.runLevelSelect();
                    break;
                }
                case 9: {
                    this.runWin();
                    break;
                }
                case 10: {
                    this.runWin();
                }
            }
            this.repaint();
            lastRun = System.currentTimeMillis();
            runLen = lastRun - startRun;
        }
    }

    protected void pointerReleased(int x, int y) {
        switch (this.mode) {
            case 4: {
                instructionReleased = true;
                if (tableMove > 0) {
                    tableMove = 0;
                    moveTableAcc = 0;
                }
                if (tableMove >= -(this.instTextH - this.instH)) break;
                tableMove = -(this.instTextH - this.instH);
                moveTableAcc = 0;
                break;
            }
            case 7: {
                if (this.levelTaskY > 0) {
                    this.levelTaskY = 0;
                }
                if (this.levelTaskY >= -(this.levelTaskItemsH - this.levelTaskH)) break;
                this.levelTaskY = -(this.levelTaskItemsH - this.levelTaskH);
                break;
            }
            case 1: {
                this.resetSlice();
            }
        }
    }

    public void fnKeyTouch(int x, int y) {
        if (y > Defines.HEIGHT - this.SPACING - this.imgButton.getHeight()) {
            if (x < this.SPACING + this.imgButton.getWidth()) {
                this.keyPressed_Game(-6);
            } else if (x > Defines.WIDTH - this.SPACING - this.imgButton.getWidth()) {
                this.keyPressed_Game(-7);
            }
        }
    }

    public void menuTouch(int x, int y) {
        int deltaX = 0;
        int deltaY = 0;
        int delta = 0;
        int select = -9999;
        int menuX = (Defines.WIDTH >> 1) - (this.imgMenuLeft.getWidth() >> 1);
        int menuY = (Defines.HEIGHT >> 1) - (this.imgMenuTop.getHeight() >> 1);
        int menuW = this.imgMenuLeft.getWidth();
        int menuH = this.imgMenuTop.getHeight();
        if (x > (Defines.WIDTH >> 1) - this.imgMenuLeft.getWidth() && x < (Defines.WIDTH >> 1) + this.imgMenuLeft.getWidth() && y > (Defines.HEIGHT >> 1) - this.imgMenuTop.getHeight() && y < (Defines.HEIGHT >> 1) + this.imgMenuTop.getHeight()) {
            deltaX = Math.abs(menuX - x);
            deltaY = Math.abs(menuY + (this.imgMenuLeft.getHeight() >> 1) - y);
            delta = deltaX + deltaY;
            select = 2;
            deltaX = Math.abs(menuX + (this.imgMenuTop.getWidth() >> 1) - x);
            deltaY = Math.abs(menuY - y);
            if (deltaY + deltaX < delta) {
                delta = deltaY + deltaX;
                select = 0;
            }
            deltaX = Math.abs(menuX + menuW - x);
            deltaY = Math.abs(menuY + (this.imgMenuRight.getHeight() >> 1) - y);
            if (deltaY + deltaX < delta) {
                delta = deltaY + deltaX;
                select = 3;
            }
            deltaX = Math.abs(menuX + (this.imgMenuBottom.getWidth() >> 1) - x);
            deltaY = Math.abs(menuY + menuH - y);
            if (deltaY + deltaX < delta) {
                delta = deltaY + deltaX;
                select = 1;
            }
            this.menuSelected = select;
            this.keyPressed_Game(53);
        }
    }

    public void levelSelectTouch(int x, int y) {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                int levelID = i * 4 + j;
                if (x < this.levelSpacing + j * (this.imgButton.getWidth() + this.levelSpacing) + this.levelX || x >= this.levelSpacing + j * (this.imgButton.getWidth() + this.levelSpacing) + this.imgButton.getWidth() + this.levelX || y < this.levelY + i * (this.imgButton.getHeight() + this.levelSpacing) || y >= this.levelY + i * (this.imgButton.getHeight() + this.levelSpacing) + this.imgButton.getHeight()) continue;
                this.levelSelectedX = j;
                this.levelSelectedY = i;
                this.keyPressed_Game(53);
            }
        }
    }

    public void gameMenuTouch(int x, int y) {
        int menuY = Defines.HEIGHT - this.imgButton.getHeight() * 3 - (this.SPACING << 1) >> 1;
        int itemH = this.imgButton.getHeight() + this.SPACING;
        if (x > Defines.WIDTH - this.imgButton.getWidth() >> 1 && x < Defines.WIDTH + this.imgButton.getWidth() >> 1 && y > menuY && y < menuY + 3 * itemH) {
            this.gameMenuSelected = (y - menuY) / this.imgButton.getHeight();
            this.keyPressed_Game(53);
        }
    }

    protected void pointerPressed(int x, int y) {
        this.touchDevice = true;
        MainCanvas.invalidateKeys();
        switch (this.mode) {
            case 1: {
                this.fnKeyTouch(x, y);
                this.resetSlice();
                this.newX = x;
                this.newY = y;
                break;
            }
            case 5: {
                this.gameMenuTouch(x, y);
                break;
            }
            case 0: {
                this.menuTouch(x, y);
                this.fnKeyTouch(x, y);
                break;
            }
            case 8: {
                this.fnKeyTouch(x, y);
                break;
            }
            case 6: {
                this.levelSelectTouch(x, y);
                this.fnKeyTouch(x, y);
                break;
            }
            case 4: {
                this.moveTableY = y;
                instructionReleased = false;
                this.fnKeyTouch(x, y);
                break;
            }
            case 7: {
                this.moveTableY = y;
                this.fnKeyTouch(x, y);
                break;
            }
            case 9: {
                this.fnKeyTouch(x, y);
                break;
            }
            case 10: {
                this.fnKeyTouch(x, y);
                break;
            }
            case 12: {
                this.fnKeyTouch(x, y);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        switch (this.mode) {
            case 1: {
                this.oldX = this.newX;
                this.oldY = this.newY;
                this.newX = x;
                this.newY = y;
                this.startX = this.oldX;
                this.startY = this.oldY;
                this.slice();
                break;
            }
            case 4: {
                tableMove += y - this.moveTableY;
                this.moveTableY = y;
                instructionReleased = false;
                break;
            }
            case 7: {
                if (this.levelTaskItemsH <= this.levelTaskH) break;
                this.levelTaskY += y - this.moveTableY;
                this.moveTableY = y;
            }
        }
    }

    public void slice() {
        for (int i = 0; i < this.SLICE_PARTS; ++i) {
            if (i == this.SLICE_PARTS - 1) {
                this.resetSlice();
                continue;
            }
            if (this.slicePartX[i] != -9999) continue;
            this.slicePartX[i] = this.startX;
            this.slicePartY[i] = this.startY;
            if (i == 1) {
                this.xUp = this.slicePartX[0] < this.slicePartX[1];
                this.yUp = this.slicePartY[0] < this.slicePartY[1];
            } else if (i > 1) {
                if (this.slicePartX[i - 1] < this.slicePartX[i] && !this.xUp) {
                    this.xChange = true;
                } else if (this.slicePartX[i - 1] > this.slicePartX[i] && this.xUp) {
                    this.xChange = true;
                }
                if (this.slicePartY[i - 1] < this.slicePartY[i] && !this.yUp) {
                    this.yChange = true;
                } else if (this.slicePartY[i - 1] > this.slicePartY[i] && this.yUp) {
                    this.yChange = true;
                }
            }
            i = this.SLICE_PARTS;
        }
        while (this.startX != this.newX && this.startY != this.newY) {
            this.dda(this.newX, this.newY, this.DDA_SHIFT);
            this.collison(this.startX, this.startY);
        }
        if (this.yChange && this.xChange) {
            this.resetSlice();
        }
        this.sliceCounter = 4;
    }

    public void updateslice() {
        if (this.sliceCounter > 0) {
            --this.sliceCounter;
            if (this.sliceCounter == 0) {
                this.resetSlice();
            }
        }
    }

    public void resetSlice() {
        if (this.comboCounter > 2) {
            this.comboValue = this.comboCounter;
            this.comboDelay = 50;
            this.score += this.comboCounter;
            this.shakeScore = 10;
        }
        this.comboCounter = 0;
        this.xUp = false;
        this.yUp = false;
        this.xChange = false;
        this.yChange = false;
        for (int i = 0; i < this.SLICE_PARTS; ++i) {
            this.slicePartX[i] = -9999;
            this.slicePartY[i] = -9999;
            this.slicePartRand[i] = MainCanvas.getRandomInt(5);
        }
    }

    public void resetGame() {
        int i;
        Particles.resetParticles();
        for (i = 0; i < this.MAX_OBJECTS; ++i) {
            this.splashesX[i] = -9999;
            this.splashesY[i] = -9999;
            this.splashesDuration[i] = 0;
            this.removeObject(i);
        }
        for (i = 0; i < this.MAX_PARTS; ++i) {
            this.removePart(i);
        }
        this.playerLife = 3;
        this.resetSlice();
        this.resetShake();
    }

    static final void updateKeys(int keyCode) {
        key_fn1 = keyDown && -6 == keyCode;
        key_fn2 = keyDown && -7 == keyCode;
        key_fire = keyDown && (keyCode == 53 || gameKey == 8);
        key_left = keyDown && (keyCode == 52 || gameKey == 2);
        key_right = keyDown && (keyCode == 54 || gameKey == 5);
        key_down = keyDown && (keyCode == 56 || gameKey == 6);
        key_num0 = keyDown && keyCode == 48;
        key_num1 = keyDown && keyCode == 49;
        key_num2 = keyDown && keyCode == 50;
        key_num3 = keyDown && keyCode == 51;
        key_num4 = keyDown && keyCode == 52;
        key_num5 = keyDown && keyCode == 53;
        key_num6 = keyDown && keyCode == 54;
        key_num7 = keyDown && keyCode == 55;
        key_num8 = keyDown && keyCode == 56;
        key_num9 = keyDown && keyCode == 57;
    }

    protected void keyPressed(int keyCode) {
        keyDown = true;
        actualKeyCode = keyCode;
        gameKey = 9999;
        if (actualKeyCode != -6 && actualKeyCode != -7) {
            gameKey = this.getGameAction(actualKeyCode);
        }
        this.keyPressed_Game(keyCode);
    }

    void keyPressed_Game(int keyCode) {
        MainCanvas.updateKeys(keyCode);
        if (keyCode == 57) {
            keyStates = keyStates | 0x40 | 0x20;
            keyStates &= 0xFFFFFFF9;
            switch (this.mode) {
                case 1: {
                    this.keySlice(3, 3);
                }
            }
        } else if (keyCode == 51) {
            keyStates = keyStates | 2 | 0x20;
            keyStates &= 0xFFFFFFBB;
            switch (this.mode) {
                case 1: {
                    this.keySlice(1, 1);
                }
            }
        } else if (keyCode == 55) {
            keyStates = keyStates | 0x40 | 4;
            keyStates &= 0xFFFFFFDD;
            switch (this.mode) {
                case 1: {
                    this.keySlice(3, 3);
                }
            }
        } else if (keyCode == 49) {
            keyStates = keyStates | 2 | 4;
            keyStates &= 0xFFFFFF9F;
            switch (this.mode) {
                case 1: {
                    this.keySlice(1, 1);
                }
            }
        } else if (keyCode == 56 || gameKey == 6) {
            keyStates |= 0x40;
            switch (this.mode) {
                case 1: {
                    this.keySlice(3, 3);
                    break;
                }
                case 0: {
                    this.selectMenu(1);
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    break;
                }
                case 5: {
                    if (this.gameMenuSelected < 2) {
                        ++this.gameMenuSelected;
                        break;
                    }
                    this.gameMenuSelected = 0;
                    break;
                }
                case 6: {
                    if (this.levelSelectedY < 4) {
                        ++this.levelSelectedY;
                        break;
                    }
                    this.levelSelectedY = 0;
                }
            }
        } else if (keyCode == 50 || gameKey == 1) {
            keyStates |= 2;
            switch (this.mode) {
                case 1: {
                    this.keySlice(1, 1);
                    break;
                }
                case 0: {
                    this.selectMenu(0);
                    break;
                }
                case 4: {
                    break;
                }
                case 7: {
                    break;
                }
                case 5: {
                    if (this.gameMenuSelected > 0) {
                        --this.gameMenuSelected;
                        break;
                    }
                    this.gameMenuSelected = 2;
                    break;
                }
                case 6: {
                    if (this.levelSelectedY > 0) {
                        --this.levelSelectedY;
                        break;
                    }
                    this.levelSelectedY = 4;
                }
            }
        } else if (keyCode == 52 || gameKey == 2) {
            keyStates |= 4;
            keyStates &= 0xFFFFFFDF;
            switch (this.mode) {
                case 1: {
                    this.keySlice(2, 2);
                    break;
                }
                case 0: {
                    this.selectMenu(2);
                    break;
                }
                case 6: {
                    if (this.levelSelectedX > 0) {
                        --this.levelSelectedX;
                        break;
                    }
                    this.levelSelectedX = 3;
                }
            }
        } else if (keyCode == 54 || gameKey == 5) {
            keyStates |= 0x20;
            keyStates &= 0xFFFFFFFB;
            switch (this.mode) {
                case 1: {
                    this.keySlice(2, 2);
                    break;
                }
                case 0: {
                    this.selectMenu(3);
                    break;
                }
                case 6: {
                    if (this.levelSelectedX < 3) {
                        ++this.levelSelectedX;
                        break;
                    }
                    this.levelSelectedX = 0;
                }
            }
        } else if (keyCode == 53 || gameKey == 8) {
            keyStates += 256;
            switch (this.mode) {
                case 1: {
                    this.keySlice(2, 2);
                    break;
                }
                case 0: {
                    this.enterMainMenuItem(this.menuSelected);
                    break;
                }
                case 5: {
                    this.enterGameMenuItem(this.gameMenuSelected);
                    break;
                }
                case 6: {
                    this.level = this.levelSelectedY * 4 + this.levelSelectedX;
                    this.enterLevel(this.level);
                }
            }
        } else if (keyCode == -6) {
            switch (this.mode) {
                case 0: {
                    this.changeMusic();
                    break;
                }
                case 4: {
                    this.modeMainMenu();
                    break;
                }
                case 6: {
                    this.modeMainMenu();
                    break;
                }
                case 7: {
                    this.levelY = Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() * 6 - this.levelSpacing * 4 >> 1;
                    this.mode = 6;
                    break;
                }
                case 8: {
                    this.releaseSplash();
                    this.modeMainMenu();
                }
            }
            keyStates |= 0x200;
        } else if (keyCode == -7) {
            keyStates |= 0x400;
            switch (this.mode) {
                case 0: {
                    X.quitApp();
                    break;
                }
                case 1: {
                    this.modeGameMenu();
                    break;
                }
                case 7: {
                    this.mode = 11;
                    this.serviceRepaints();
                    this.loadGameObjects();
                    this.startArcadeLevel();
                    break;
                }
                case 9: {
                    if (this.level < 19) {
                        this.levelY = Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() * 6 - this.levelSpacing * 4 >> 1;
                        this.mode = 6;
                        this.playMusic();
                        break;
                    }
                    this.modeGameCompleted();
                    break;
                }
                case 12: {
                    this.levelY = Defines.HEIGHT - this.SPACING - this.imgButton.getHeight() * 6 - this.levelSpacing * 4 >> 1;
                    this.mode = 6;
                    this.playMusic();
                    break;
                }
                case 10: {
                    this.mode = 11;
                    this.serviceRepaints();
                    if (this.arcade) {
                        this.mode = 6;
                    } else {
                        this.mode = 11;
                        this.serviceRepaints();
                        this.releaseGameObjects();
                        X.singleton.startScoreCanvas(false);
                        X.scoreCanvas.activeTable = 0;
                        if (X.scoreCanvas.isScoreForTable(this.recordScore)) {
                            X.scoreCanvas.prepareForGetNewName(this.recordScore);
                            X.singleton.startScoreCanvas(true);
                        } else {
                            this.modeMainMenu();
                        }
                    }
                    this.playMusic();
                    break;
                }
                case 8: {
                    this.changeMusic();
                    this.releaseSplash();
                    this.modeMainMenu();
                }
            }
        }
    }

    static final void invalidateKeys() {
        actualKeyCode = 9999;
        gameKey = 9999;
        MainCanvas.updateKeys(9999);
    }

    void keyReleasedHandled() {
        MainCanvas.invalidateKeys();
        this.repaint();
    }

    protected void keyReleased(int keyCode) {
        try {
            gameKey = 9999;
            lastKeyStates = keyStates;
            if (-6 != keyCode && -7 != keyCode) {
                gameKey = this.getGameAction(keyCode);
            }
            if (keyCode == 57) {
                keyStates &= 0xFFFFFF9F;
                keyDown = false;
            } else if (keyCode == 51) {
                keyStates &= 0xFFFFFFDD;
                keyDown = false;
            } else if (keyCode == 55) {
                keyStates &= 0xFFFFFFBB;
                keyDown = false;
            } else if (keyCode == 49) {
                keyStates &= 0xFFFFFFF9;
                keyDown = false;
            } else if (keyCode == 56 || gameKey == 6) {
                keyStates &= 0xFFFFFFBF;
                keyDown = false;
            } else if (keyCode == 50 || gameKey == 1) {
                keyStates &= 0xFFFFFFFD;
                keyDown = false;
            } else if (keyCode == 52 || gameKey == 2) {
                keyStates &= 0xFFFFFFFB;
                keyDown = false;
            } else if (keyCode == 54 || gameKey == 5) {
                keyStates &= 0xFFFFFFDF;
                keyDown = false;
            } else if (keyCode == 48) {
                keyDown = false;
            } else if (keyCode == 53 || gameKey == 8) {
                keyStates &= 0xFFFFFEFF;
                keyDown = false;
            } else {
                keyDown = keyCode == 35 ? false : (keyCode == 42 ? false : (keyCode == -6 ? false : (keyCode == -7 ? false : false)));
            }
            MainCanvas.updateKeys(keyCode);
        }
        catch (Exception e) {
            MainCanvas.trace("keys released error: " + e);
        }
    }

    static {
        POW = false;
        fontSN = Font.getFont((int)0, (int)0, (int)8);
        randGenerator = new Random();
        tableMove = 0;
        moveTableAcc = 0;
        tableAccDec = 2;
        instructionReleased = true;
        gameKey = 9999;
        keyStates = 0;
        lastKeyStates = 0;
        keyDown = false;
        actualKeyCode = 0;
    }
}

