/*
 * Decompiled with CFR 0.152.
 */
package kamesh.games.floristry;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import kamesh.games.floristry.Floristry320;

public class FloristryCanvas320
extends GameCanvas
implements Runnable {
    private int seed;
    public static final int MAIN_MENU = 0;
    public static final int PAUSE_MENU = 1;
    public static final int START_MENU = 2;
    public static final int OPTIONS_MENU = 3;
    public static final int SOUNDS_MENU = 4;
    public static final int VIBRATION_MENU = 5;
    public static final int LANGUAGE_MENU = 6;
    public static final int CONFIRMATION_MENU = 7;
    private int menuType;
    private boolean paused;
    private boolean vibrations;
    private boolean confirmNewGameStart;
    public int lastGameState = -1;
    public static final int SPLASH_STATE = 0;
    public static final int MAINMENU_STATE = 1;
    public static final int ABOUT_STATE = 2;
    public static final int HELP_STATE = 3;
    public static final int NEXT_LEVEL_STATE = 4;
    public static final int HIGHSCORES_STATE = 5;
    public static final int UI_STATE = 6;
    public static final int OPENING_CURTAIN_STATE = 7;
    public static final int CLOSING_CURTAIN_STATE = 8;
    public static final int PLAYING_STATE = 9;
    public static final int SWAPING_STATE = 10;
    public static final int UNDOING_STATE = 11;
    public static final int TRAVERSING_STATE = 12;
    public static final int BLOOMING_STATE = 14;
    private Floristry320 midlet;
    public int menuIndex;
    private String[] menuItems;
    private String[][] mmenuItems = new String[][]{{"\u958b\u59cb", "\u9078\u64c7", "\u5206\u6578", "\u5e6b\u52a9", "\u9000\u51fa"}, {"\u5f00\u59cb", "\u9009\u62e9", "\u5206\u6570", "\u5206\u6570", "\u5e2e\u52a9", "\u5e2e\u52a9", "\u9000\u51fa"}, {"START", "OPTIONS", "HIGHSCORES", "HELP", "ABOUT", "EXIT"}};
    private String[][] ppmenuItems = new String[][]{{"\u7e7c\u7e8c", "\u65b0\u904a\u6232", "\u56de\u4e0a\u9801"}, {"\u7ee7\u7eed", "\u65b0\u6e38\u620f", "\u56de"}, {"CONTINUE", "NEW GAME", "BACK"}};
    private String[][] omenuItems = new String[][]{{"\u8072\u97f3", "\u632f\u52d5", "\u56de\u4e0a\u9801"}, {"\u58f0\u97f3", "\u632f\u52a8", "\u56de"}, {"SOUNDS", "VIBRATIONS", "BACK"}};
    private String[][] soundsItems = new String[][]{{"\u95dc", "\u4f4e", "\u4e2d", "\u9ad8", "\u56de\u4e0a\u9801"}, {"\u5173", "\u4f4e", "\u4e2d", "\u9ad8", "\u56de"}, {"OFF", "LOW", "MEDIUM", "HIGH", "BACK"}};
    private String[][] vibrationItems = new String[][]{{"*", "\u958b", "\u95dc", "\u56de\u4e0a\u9801"}, {"*", "\u5f00", "\u5173", "\u56de"}, {"*", "ON", "OFF", "BACK"}};
    private String[][] languageItems = new String[][]{{"\u7e41\u9ad4\u4e2d\u6587", "\u7c21\u9ad4\u4e2d\u6587", "\u82f1\u6587", "\u56de\u4e0a\u9801"}, {"\u7e41\u4f53\u4e2d\u6587", "\u7b80\u4f53\u4e2d\u6587", "\u82f1\u6587", "\u56de"}, {"TRADITIONAL", "SIMPLIFIED", "ENGLISH"}};
    private String[][] confirmationItems = new String[][]{{"*", "\u5426", "\u662f"}, {"*", "\u5426", "\u662f"}, {"*", "NO", "YES"}};
    private String[][] pauseMenuItems = new String[][]{{"*", "\u91cd\u65b0\u958b\u59cb", "SETTINGS", "\u4e3b\u76ee\u9304"}, {"*", "\u91cd\u65b0\u5f00\u59cb", "SETTINGS", "\u4e3b\u76ee\u5f55"}, {"*", "RESUME", "SETTINGS", "MAIN MENU"}};
    private long minusTime = -1L;
    private int barValue = 0;
    private int totalScore = 0;
    private int currentLevel = 1;
    private int gameState;
    private Image noticeBoard = null;
    private TiledLayer layer;
    private TiledLayer backLayer;
    private Image backImage;
    private Sprite player;
    private Sprite selectorLeft;
    private Sprite selectorRight;
    private Sprite fontSprite;
    private Sprite menuVine;
    private Sprite mainMenu;
    private Sprite smallFontSprite;
    private Image hud = null;
    private Sprite vine = null;
    private static final int FRAME_SIZE = 30;
    private static final int screenWidth = 320;
    private static final int screenHeight = 240;
    private int offsetX = 70;
    private int offsetY = 40;
    private static final int BIGFONTSIZE = 15;
    private static final int MEDFONTSIZE = 10;
    private static final int MOVESPEED = 5;
    private static final int WIDTH = 6;
    private static int types_OF_CELLS = 4;
    private int currentColumn;
    private int currentRow;
    private int selectedColumn;
    private int selectedRow;
    private int selectedIndex;
    private int currentIndex;
    private boolean selectionFlag;
    private Graphics g;
    private boolean playing;
    private int[] playerFrameSequence = new int[]{39, 47, 55, 47};
    private int moveVal;
    private int score = 0;
    private int traverseIndex = 0;
    private int languageType = 2;
    private Font SMALLFONT;
    private Font SMALLULINEFONT;
    private Font BIGFONT;
    boolean usePartnerLogo = false;
    private Sprite shuffle = null;
    int tempY;
    private static final int FT_SMALL = 0;
    private static final int FT_BIG = 1;
    private int fWidth;
    private int fHeight;
    private int[][] arrangedCols = new int[][]{{-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}};
    private int[][] arrangedRows = new int[][]{{-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1}};
    private int unfoldingIndex;
    private int changeSelection;
    private static int MAX_LENGTH = 6;
    private boolean takeInput;
    private char[] uName = new char[]{' ', ' ', ' ', ' ', ' ', ' '};
    private int nameIndex;
    private int repeatIndex;
    private int lastKey = -1;
    private long keyDelay;
    private static long WAIT_TIME = 0L;
    private RecordStore rs;
    private final int RECORD_SIZE;
    private byte[] rec = new byte[6];
    private boolean stopSound;
    private int soundVolume = 33;
    private int arrangedSoundIndex;
    public static final int BACKGROUNDSOUND = 0;
    public static final int ERRORSOUND = 2;
    public static final int MOVESOUND = 3;
    public static final int ARRANGEDSOUND = 4;
    private Player[] musicPlayer;

    public FloristryCanvas320(Floristry320 midlet) {
        super(false);
        this.RECORD_SIZE = 6;
        this.setFullScreenMode(true);
        this.seed = (int)System.currentTimeMillis();
        this.g = this.getGraphics();
        this.midlet = midlet;
        this.g.setColor(0);
        this.g.fillRect(0, 0, 320, 240);
        this.SMALLFONT = Font.getFont((int)0, (int)1, (int)8);
        this.SMALLULINEFONT = Font.getFont((int)0, (int)5, (int)8);
        this.BIGFONT = Font.getFont((int)0, (int)1, (int)16);
        this.menuItems = this.mmenuItems[this.languageType];
        try {
            Image image = Image.createImage((String)"/flo.png");
            this.player = new Sprite(image, 30, 30);
            this.player.setFrameSequence(this.playerFrameSequence);
            this.backLayer = new TiledLayer(6, 6, image, 30, 30);
            this.backLayer.setPosition(this.offsetX, this.offsetY);
            this.backLayer.fillCells(0, 0, 6, 6, 39);
            this.selectorLeft = new Sprite(image, 30, 30);
            this.selectorLeft.setFrame(this.nextInt(types_OF_CELLS));
            this.selectorRight = new Sprite(image, 30, 30);
            this.selectorRight.setFrame(this.nextInt(types_OF_CELLS));
            this.layer = new TiledLayer(6, 6, image, 30, 30);
            this.layer.setPosition(this.offsetX, this.offsetY);
            image = null;
            this.fontSprite = new Sprite(Image.createImage((String)"/fbig.png"), 15, 15);
            this.smallFontSprite = new Sprite(Image.createImage((String)"/fsmall.png"), 10, 10);
            this.menuVine = new Sprite(Image.createImage((String)"/pf.png"), 25, 35);
            this.backImage = Image.createImage((String)"/m.png");
            this.shuffle = new Sprite(Image.createImage((String)"/shuffle.png"), 320, 20);
        }
        catch (Exception e) {
            System.out.println("cant create player... " + e);
        }
        this.readRMS();
        this.fillHighScoresData();
        this.initMedia();
    }

    public void run() {
        Image curtain = null;
        try {
            this.hud = Image.createImage((String)"/b.png");
            curtain = this.usePartnerLogo ? Image.createImage((String)"/partnerLogo.png") : Image.createImage((String)"/lg.png");
            this.vine = new Sprite(Image.createImage((String)"/vine.png"), 320, 20);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int timeStep = 50;
        int temp = 20;
        int tempBarValue = 0;
        String[] names = null;
        int[] scores = new int[5];
        this.getHighScores(scores);
        while (this.playing) {
            long start = System.currentTimeMillis();
            switch (this.gameState) {
                case 0: {
                    int i;
                    int j;
                    ++this.traverseIndex;
                    if (this.traverseIndex < 40) {
                        this.g.drawImage(curtain, 160, 120, 3);
                        for (j = temp; j > 0; --j) {
                            for (i = 0; i < 12; ++i) {
                                this.g.drawImage(this.hud, 160, 20 * i, 17);
                            }
                        }
                        --temp;
                        break;
                    }
                    if (this.traverseIndex >= 40 && this.traverseIndex <= 70) {
                        for (i = 0; i < 12; ++i) {
                            this.g.drawImage(this.hud, 160, 20 * i, 17);
                        }
                        break;
                    }
                    try {
                        this.hud = Image.createImage((String)"/hud.png");
                        curtain = Image.createImage((String)"/ctn.png");
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    i = 0;
                    this.traverseIndex = 0;
                    temp = 0;
                    this.menuItems = this.mmenuItems[this.languageType];
                    this.menuType = 0;
                    this.g.setClip(0, 0, 320, 240);
                    this.gameState = 1;
                    this.changeSelection = 0;
                    break;
                }
                case 3: {
                    this.tempY = -20;
                    int x = this.player.getX();
                    int xx = 160 - temp * 320;
                    if (x < xx) {
                        x += (xx - x) / 5 + 1;
                    } else if (x > xx) {
                        x -= (x - xx) / 5 + 1;
                    }
                    this.player.setPosition(x, 100);
                    this.g.drawImage(this.backImage, 0, 0, 20);
                    if (x == xx) {
                        this.g.setColor(153, 193, 204);
                        if (temp != 0) {
                            this.g.fillTriangle(15, 190, 22, 183, 22, 197);
                        }
                        if (temp != 6) {
                            this.g.fillTriangle(305, 190, 298, 183, 298, 197);
                        }
                        if (this.languageType == 0) {
                            this.displaySmallText("\u5b8c\u6210", 0, 230);
                        } else if (this.languageType == 1) {
                            this.displaySmallText("\u5b8c\u6210", 0, 230);
                        } else {
                            this.displaySmallText("DONE", 0, 230);
                        }
                    }
                    this.g.setColor(0);
                    this.g.setFont(this.SMALLFONT);
                    this.g.drawString("Help: " + (temp + 1) + "/7", 160, 90 + this.tempY, 17);
                    if (temp == 0 || temp == 1) {
                        this.g.drawString("Survival is the art", x, 120 + this.tempY, 17);
                        this.g.drawString("of flower arrangement.", x, 135 + this.tempY, 17);
                        this.g.drawString("In this game the user", x, 150 + this.tempY, 17);
                        this.g.drawString("has to arrange flowers", x, 165 + this.tempY, 17);
                        this.g.drawString("in  triplets or more of", x, 180 + this.tempY, 17);
                        this.g.drawString("the same kind of ", x, 195 + this.tempY, 17);
                        this.g.drawString("flowers by swapping", x, 210 + this.tempY, 17);
                    }
                    if (temp == 0 || temp == 1 || temp == 2) {
                        this.g.drawString("two neighboring flowers", x + 320, 120 + this.tempY, 17);
                        this.g.drawString("in the grid. If the swap", x + 320, 135 + this.tempY, 17);
                        this.g.drawString("does not result in a", x + 320, 150 + this.tempY, 17);
                        this.g.drawString("triplet, the flowers", x + 320, 165 + this.tempY, 17);
                        this.g.drawString("roll back to their", x + 320, 180 + this.tempY, 17);
                        this.g.drawString("original place.", x + 320, 195 + this.tempY, 17);
                    }
                    if (temp == 1 || temp == 2 || temp == 3) {
                        this.g.drawString("Objective:", x + 640, 120 + this.tempY, 17);
                        this.g.drawString("When a group of 3 or", x + 640, 135 + this.tempY, 17);
                        this.g.drawString("more same kind of", x + 640, 150 + this.tempY, 17);
                        this.g.drawString("flowers fall in a", x + 640, 165 + this.tempY, 17);
                        this.g.drawString("line, the player gets", x + 640, 180 + this.tempY, 17);
                        this.g.drawString("points and a vine", x + 640, 195 + this.tempY, 17);
                        this.g.drawString("can be noticed wrapping", x + 640, 210 + this.tempY, 17);
                    }
                    if (temp == 2 || temp == 3 || temp == 4) {
                        this.g.drawString("Objective:", x + 960, 120 + this.tempY, 17);
                        this.g.drawString("forward around a branch.", x + 960, 135 + this.tempY, 17);
                        this.g.drawString("The objective is to", x + 960, 150 + this.tempY, 17);
                        this.g.drawString("ensure that the vine", x + 960, 165 + this.tempY, 17);
                        this.g.drawString("keeps on wrapping forward", x + 960, 180 + this.tempY, 17);
                        this.g.drawString("till it reaches the", x + 960, 195 + this.tempY, 17);
                        this.g.drawString("rightmost corner of the", x + 960, 210 + this.tempY, 17);
                    }
                    if (temp == 3 || temp == 4 || temp == 5) {
                        this.g.drawString("branch and progress", x + 1280, 120 + this.tempY, 17);
                        this.g.drawString("to the next level.", x + 1280, 135 + this.tempY, 17);
                        this.g.drawString("Beware, that the vine", x + 1280, 150 + this.tempY, 17);
                        this.g.drawString("recedes back on the", x + 1280, 165 + this.tempY, 17);
                        this.g.drawString("branch over time if", x + 1280, 180 + this.tempY, 17);
                        this.g.drawString("no points are being", x + 1280, 195 + this.tempY, 17);
                        this.g.drawString("scored. If the vine", x + 1280, 210 + this.tempY, 17);
                    }
                    if (temp == 4 || temp == 5 || temp == 6) {
                        this.g.drawString("recedes back to the", x + 1600, 120 + this.tempY, 17);
                        this.g.drawString("start of branch on the", x + 1600, 135 + this.tempY, 17);
                        this.g.drawString("left edge, the game ends.", x + 1600, 150 + this.tempY, 17);
                        this.g.drawString("NB: The user can press", x + 1600, 165 + this.tempY, 17);
                        this.g.drawString("LSK to shuffle the", x + 1600, 180 + this.tempY, 17);
                        this.g.drawString("flowers in the grid but", x + 1600, 195 + this.tempY, 17);
                        this.g.drawString("at an expense of 500 points.", x + 1600, 210 + this.tempY, 17);
                    }
                    if (temp == 5 || temp == 6 || temp == 7) {
                        this.g.drawString("CONTROLS:", x + 1920, 120 + this.tempY, 17);
                        this.g.drawString("Move Left: 4", x + 1920, 135 + this.tempY, 17);
                        this.g.drawString("Move Right: 6", x + 1920, 150 + this.tempY, 17);
                        this.g.drawString("Move Up: 2", x + 1920, 165 + this.tempY, 17);
                        this.g.drawString("Move Down: 8", x + 1920, 180 + this.tempY, 17);
                        this.g.drawString("Toggle Selection: 5", x + 1920, 195 + this.tempY, 17);
                        this.g.drawString("Pause: RSK", x + 1920, 210 + this.tempY, 17);
                        this.g.drawString("Shuffle: LSK", x + 1920, 225 + this.tempY, 17);
                    }
                    if (this.changeSelection == -6) {
                        this.g.setClip(0, 0, 320, 240);
                        this.gameState = 1;
                        temp = 0;
                    } else if (this.changeSelection == 1 && temp < 6) {
                        temp += this.changeSelection;
                    } else if (this.changeSelection == -1 && temp > 0) {
                        temp += this.changeSelection;
                    }
                    this.changeSelection = 0;
                    break;
                }
                case 2: {
                    int xx;
                    int x;
                    this.tempY = -25;
                    if (temp < 0 || temp > 2) {
                        temp = 0;
                    }
                    if ((x = this.player.getX()) < (xx = 160 - temp * 320)) {
                        x += (xx - x) / 5 + 1;
                    } else if (x > xx) {
                        x -= (x - xx) / 5 + 1;
                    }
                    this.g.drawImage(this.backImage, 0, 0, 20);
                    this.player.setPosition(x, 100);
                    if (x == xx) {
                        this.g.setColor(153, 193, 204);
                        if (temp != 0) {
                            this.g.fillTriangle(22, 190, 30, 183, 30, 197);
                        }
                        if (temp != 2) {
                            this.g.fillTriangle(298, 190, 290, 183, 290, 197);
                        }
                        this.displaySmallText("DONE", 0, 230);
                    }
                    this.g.setColor(0);
                    this.g.setFont(this.SMALLFONT);
                    this.g.drawString("SURVIVAL VERSION 1.0", x, 105 + this.tempY, 17);
                    this.g.drawString("\u00a9 2012 ALL RIGHTS RESERVED", x, 120 + this.tempY, 17);
                    if (temp > 0) {
                        this.g.drawString("CREDITS", 160, 90 + this.tempY, 17);
                    }
                    this.g.setFont(this.SMALLULINEFONT);
                    this.g.drawString("PUBLISHED BY", x, 150 + this.tempY, 17);
                    this.g.drawString("DEVELOPED BY", x, 210 + this.tempY, 17);
                    this.g.drawString("GAME DESIGN", x + 320, 120 + this.tempY, 17);
                    this.g.drawString("PROGRAMMER", x + 320, 180 + this.tempY, 17);
                    this.g.drawString("ARTIST", x + 640, 120 + this.tempY, 17);
                    this.g.drawString("PRODUCER", x + 640, 165 + this.tempY, 17);
                    this.g.drawString("TESTER", x + 640, 210 + this.tempY, 17);
                    this.g.setFont(this.BIGFONT);
                    this.g.drawString("RZ2 GAMES", x, 165 + this.tempY, 17);
                    this.g.drawString("RZ2 GAMES", x, 225 + this.tempY, 17);
                    this.g.drawString("KAMESHWAR", x + 320, 135 + this.tempY, 17);
                    this.g.drawString("BHAWANI PRATAP", x + 320, 195 + this.tempY, 17);
                    this.g.drawString("MAYANK SHARMA", x + 640, 135 + this.tempY, 17);
                    this.g.drawString("ANDREA ANTAO", x + 640, 180 + this.tempY, 17);
                    this.g.drawString("HIMANSHU MANWANI", x + 640, 225 + this.tempY, 17);
                    if (this.changeSelection == -6) {
                        this.g.setClip(0, 0, 320, 240);
                        this.gameState = 1;
                        temp = 0;
                    } else if (this.changeSelection == 1 && temp < 2) {
                        temp += this.changeSelection;
                    } else if (this.changeSelection == -1 && temp > 0) {
                        temp += this.changeSelection;
                    }
                    this.changeSelection = 0;
                    break;
                }
                case 6: {
                    this.setFontAttributes(0);
                    int y = this.selectorLeft.getY();
                    int yy = 240;
                    if (y < yy) {
                        y += (yy - y) / 5 + 1;
                    } else if (y > yy) {
                        y -= (y - yy) / 5 + 1;
                    }
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    this.selectorLeft.setPosition(0, y);
                    this.g.drawImage(curtain, 0, y - 240, 0);
                    if (this.languageType == 0) {
                        this.g.drawString("\u904a\u6232\u7d50\u675f", 160, y - 200, 0x10 | 1);
                    } else if (this.languageType == 1) {
                        this.g.drawString("\u6e38\u620f\u7ed3\u675f", 160, y - 200, 0x10 | 1);
                    } else {
                        this.g.drawString("GAME OVER", 160, y - 160, 0x10 | 1);
                    }
                    this.g.drawImage(this.hud, 0, 0, 0);
                    this.vine.setPosition(0, 220);
                    this.vine.setFrame(1);
                    this.vine.paint(this.g);
                    if (y != yy) break;
                    if (this.languageType == 0) {
                        this.unfoldingText("\u8f38\u5165\u4f60\u7684\u540d\u5b57", 200);
                    } else if (this.languageType == 1) {
                        this.unfoldingText("\u8f93\u5165\u4f60\u7684\u540d\u5b57", 200);
                    } else {
                        this.unfoldingText("ENTER YOUR NAME", 140);
                    }
                    if (this.nameIndex < MAX_LENGTH - 1 && this.uName[this.nameIndex] != ' ' && this.keyDelay < System.currentTimeMillis()) {
                        ++this.nameIndex;
                        this.repeatIndex = 0;
                    }
                    if (this.nameIndex > 0) {
                        if (this.languageType == 0) {
                            this.displaySmallText("\u7e7c\u7e8c", 320 - this.fWidth * 2 - 30, 240 - this.fHeight);
                            this.displaySmallText("\u6e05\u9664", 30, 240 - this.fHeight);
                        } else if (this.languageType == 1) {
                            this.displaySmallText("\u7ee7\u7eed", 320 - this.fWidth * 2 - 30, 240 - this.fHeight);
                            this.displaySmallText("\u6e05\u9664", 30, 240 - this.fHeight);
                        } else {
                            this.displaySmallText("CONTINUE", 320 - this.fWidth * 8 - 20, 230);
                            this.displaySmallText("CLEAR", 50, 230);
                        }
                    }
                    this.g.setColor(0);
                    this.g.setFont(this.BIGFONT);
                    this.g.drawString(new String(this.uName), 115, 175, 0);
                    if (this.takeInput) break;
                    this.updateHighScores();
                    this.takeInput = false;
                    names = null;
                    this.noticeBoard = null;
                    this.gameState = 5;
                    this.changeSelection = 0;
                    break;
                }
                case 5: {
                    int i;
                    if (names == null) {
                        names = this.getHighScores(scores);
                        break;
                    }
                    this.g.drawImage(this.backImage, 0, 0, 20);
                    if (this.languageType == 0) {
                        this.g.drawString("\u5206\u6578", 160, 80, 17);
                    } else if (this.languageType == 1) {
                        this.g.drawString("\u5206\u6570", 160, 80, 17);
                    } else {
                        this.g.drawString("HIGHSCORES", 160, 80, 17);
                    }
                    this.g.setColor(0);
                    this.setFontAttributes(0);
                    for (i = 0; i < 5; ++i) {
                        if (scores[i] <= 0) continue;
                        this.g.drawString(names[i], 100, 110 + i * this.fHeight + 3, 20);
                        this.g.drawString("" + scores[i], 220, 110 + i * this.fHeight + 3, 24);
                    }
                    if (this.languageType == 0) {
                        this.displaySmallText("\u5b8c\u6210", 30, 240 - this.fHeight - 8);
                    } else if (this.languageType == 1) {
                        this.displaySmallText("\u5b8c\u6210", 30, 240 - this.fHeight - 8);
                    } else {
                        this.displaySmallText("DONE", 0, 230);
                    }
                    if (this.changeSelection == -6) {
                        this.menuIndex = 0;
                        this.paused = false;
                        this.menuItems = this.mmenuItems[this.languageType];
                        this.menuType = 0;
                        this.g.setClip(0, 0, 320, 240);
                        this.gameState = 1;
                        names = null;
                        this.changeSelection = 0;
                        this.noticeBoard = null;
                        this.getKeyStates();
                        break;
                    }
                    this.changeSelection = 0;
                    this.getKeyStates();
                    break;
                }
                case 4: {
                    int i;
                    int j;
                    this.writeRMS(true);
                    this.g.setColor(6438920);
                    this.g.fillRect(0, this.offsetY, 320, 240);
                    this.currentColumn = 0;
                    this.currentRow = 0;
                    this.minusTime = -1L;
                    if (this.vibrations) {
                        this.midlet.vibra(1000);
                    }
                    ++this.currentLevel;
                    this.totalScore += this.score;
                    this.score = 0;
                    this.barValue = 0;
                    types_OF_CELLS = this.currentLevel >= 0 && this.currentLevel < 20 ? 6 : (this.currentLevel >= 20 && this.currentLevel < 40 ? 7 : 8);
                    this.createBoard(24);
                    for (i = 0; i < 6; ++i) {
                        for (j = 0; j < 3; ++j) {
                            this.arrangedCols[i][j] = -1;
                            this.arrangedRows[i][j] = -1;
                        }
                    }
                    this.g.setClip(0, 0, 320, 240);
                    this.shuffle.setPosition(0, 220);
                    this.vine.setPosition(0, 220);
                    this.vine.setFrame(1);
                    this.vine.paint(this.g);
                    this.gameState = 7;
                    this.traverseIndex = 0;
                    this.selectorLeft.setPosition(0, 320);
                    this.g.setColor(6438920);
                    this.g.fillRect(0, this.offsetY, 320, 240);
                    break;
                }
                case 7: {
                    int i;
                    int j;
                    this.g.setColor(6438920);
                    this.g.fillRect(0, this.offsetY, 320, 240);
                    int y = this.selectorLeft.getY();
                    int yy = this.offsetY;
                    if (y < yy) {
                        y += (yy - y) / 5 + 1;
                    } else if (y > yy) {
                        y -= (y - yy) / 5 + 1;
                    }
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    this.selectorLeft.setPosition(0, y);
                    this.g.drawImage(curtain, 0, y - 240, 0);
                    this.g.drawImage(this.hud, 0, 0, 0);
                    if (y != yy) break;
                    if (this.traverseIndex >= 0 && this.traverseIndex <= 42) {
                        for (int k = 5; k >= 0; --k) {
                            i = this.nextInt(6);
                            temp = this.layer.getCell(i, j = this.nextInt(6));
                            if (temp <= 6) continue;
                            this.layer.setCell(i, j, temp - 6);
                        }
                    } else {
                        for (i = 5; i >= 0; --i) {
                            for (j = 5; j >= 0; --j) {
                                temp = this.layer.getCell(i, j) % 6;
                                if (temp == 0) {
                                    temp = 6;
                                }
                                this.layer.setCell(i, j, temp);
                            }
                        }
                        this.getKeyStates();
                        this.vine.setPosition(0, 220);
                        this.vine.setFrame(1);
                        this.vine.paint(this.g);
                        if (this.languageType == 0) {
                            this.displayString("SHUFFLE", 50, 305, false);
                            this.displayString("\u7b49\u7d1a " + this.currentLevel, 130, 305, false);
                            this.displayString("\u66ab\u505c", 200, 305, false);
                        } else if (this.languageType == 1) {
                            this.displayString("SHUFFLE", 50, 305, false);
                            this.displayString("\u7b49\u7ea7 " + this.currentLevel, 130, 305, false);
                            this.displayString("\u6682\u505c", 200, 305, false);
                        } else {
                            this.displayString("SHUFFLE", 60, 223, false);
                            this.displayString("LEVEL " + this.currentLevel, 150, 223, false);
                            this.displayString("PAUSE", 280, 223, false);
                        }
                        this.g.setColor(6438920);
                        this.g.fillRect(0, this.offsetY, 320, 240);
                        this.g.fillRect(this.offsetX, this.offsetY, 180, 180);
                        this.layer.paint(this.g);
                        try {
                            this.musicPlayer[0].stop();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                        this.gameState = 9;
                        tempBarValue = 20;
                        this.barValue = 20;
                        this.traverseIndex = 0;
                    }
                    ++this.traverseIndex;
                    break;
                }
                case 8: {
                    int yy;
                    int y;
                    if (this.soundVolume > 0 && !this.paused && !this.stopSound && this.musicPlayer[0].getState() != 400) {
                        try {
                            this.musicPlayer[0].start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((y = this.selectorLeft.getY()) < (yy = 240)) {
                        y += (yy - y) / 5 + 1;
                    } else if (y > yy) {
                        y -= (y - yy) / 5 + 1;
                    }
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    this.selectorLeft.setPosition(0, y);
                    this.g.drawImage(curtain, 0, y - 240, 0);
                    this.g.drawImage(this.hud, 0, 0, 0);
                    this.vine.setPosition(0, 220);
                    this.vine.setFrame(1);
                    this.vine.paint(this.g);
                    if (this.languageType == 0) {
                        this.displayString("\u7b49\u7d1a\u5b8c\u6210", 160, y - 200, false);
                        this.displaySmallText("SCORED IN THIS LEVEL", 160, y - 120);
                        this.displayString(this.score + " \u5206\u6578", 160, y - 100, false);
                        this.displaySmallText("\u7e3d\u5206", 160, y - 80);
                        this.displayString(this.totalScore + this.score + " \u5206\u6578", 160, y - 60, false);
                    } else if (this.languageType == 1) {
                        this.displayString("\u7b49\u7ea7\u5b8c\u6210", 160, y - 200, false);
                        this.displaySmallText("SCORED IN THIS LEVEL", 160, y - 120);
                        this.displayString(this.score + " \u5206\u6570", 160, y - 100, false);
                        this.displaySmallText("\u603b\u5206", 160, y - 80);
                        this.displayString(this.totalScore + this.score + " \u5206\u6570", 160, y - 60, false);
                    } else {
                        this.displayString("LEVEL CLEARED", 160, y - 160, false);
                        this.displaySmallText("SCORED IN THIS LEVEL", 106, y - 120);
                        this.displayString(this.score + " POINTS", 160, y - 100, false);
                        this.displaySmallText("    TOTAL SCORE     ", 106, y - 70);
                        this.displayString(this.totalScore + this.score + " POINTS", 160, y - 50, false);
                    }
                    if (y != yy || this.getKeyStates() == 0) break;
                    this.gameState = 4;
                    break;
                }
                case 9: {
                    int xx;
                    if (this.barValue > 310) {
                        this.g.setClip(0, 0, 320, 240);
                        this.gameState = 8;
                        this.selectorLeft.setPosition(0, this.offsetY);
                        this.getKeyStates();
                        break;
                    }
                    int x = this.player.getX();
                    if (x < (xx = this.offsetX + this.currentColumn * 30)) {
                        x += (xx - x) / 5 + 1;
                    } else if (x > xx) {
                        x -= (x - xx) / 5 + 1;
                    }
                    int y = this.player.getY();
                    int yy = this.offsetY + this.currentRow * 30;
                    if (y < yy) {
                        y += (yy - y) / 5 + 1;
                    } else if (y > yy) {
                        y -= (y - yy) / 5 + 1;
                    }
                    this.player.setPosition(x, y);
                    this.g.setColor(6438920);
                    this.g.fillRect(0, this.offsetY, 320, 240);
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    this.player.paint(this.g);
                    this.shuffle.setPosition(0, 220);
                    this.shuffle.paint(this.g);
                    this.displayString("" + this.currentLevel, 175, 223, false);
                    break;
                }
                case 1: {
                    temp = 0;
                    if (this.soundVolume > 0 && !this.paused && !this.stopSound && this.musicPlayer[0].getState() != 400) {
                        try {
                            this.musicPlayer[0].start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.g.drawImage(this.backImage, 0, 0, 20);
                    if (this.menuType == 3) {
                        if (this.languageType == 0) {
                            this.unfoldingText("\u9078\u64c7", 90);
                        } else if (this.languageType == 1) {
                            this.unfoldingText("\u9009\u62e9", 90);
                        } else {
                            this.unfoldingText("OPTIONS", 90);
                        }
                    } else if (this.menuType == 5) {
                        if (this.languageType == 0) {
                            this.unfoldingText("\u632f\u52d5", 110);
                        } else if (this.languageType == 1) {
                            this.unfoldingText("\u632f\u52a8", 110);
                        } else {
                            this.unfoldingText("VIBRATION", 110);
                        }
                    } else if (this.menuType == 4) {
                        if (this.languageType == 0) {
                            this.unfoldingText("\u97f3\u91cf", 90);
                        } else if (this.languageType == 1) {
                            this.unfoldingText("\u97f3\u91cf", 90);
                        } else {
                            this.unfoldingText("SOUND VOLUME", 90);
                        }
                    } else if (this.menuType == 6) {
                        if (this.languageType == 0) {
                            this.unfoldingText("\u8a9e\u8a00", 90);
                        } else if (this.languageType == 1) {
                            this.unfoldingText("\u8a9e\u8a00", 90);
                        } else {
                            this.unfoldingText("LANGUAGE", 90);
                        }
                    } else if (this.menuType == 7) {
                        if (this.confirmNewGameStart) {
                            if (this.languageType == 0) {
                                this.unfoldingText("YOUR SAVED GAME", 80);
                                this.unfoldingText("WILL BE LOST", 105);
                            } else if (this.languageType == 1) {
                                this.unfoldingText("YOUR SAVED GAME", 80);
                                this.unfoldingText("WILL BE LOST", 105);
                            } else {
                                this.unfoldingText("YOUR SAVED GAME", 75);
                                this.unfoldingText("WILL BE LOST", 90);
                            }
                        } else if (this.paused) {
                            if (this.languageType == 0) {
                                this.unfoldingText("\u4f60\u5c07\u6703\u5931\u53bb\u73fe\u5728\u7684\u9032\u5ea6", 90);
                                this.unfoldingText("\u78ba\u5b9a", 105);
                            } else if (this.languageType == 1) {
                                this.unfoldingText("\u4f60\u5c06\u4f1a\u5931\u53bb\u73b0\u5728\u7684\u8fdb\u5ea6", 90);
                                this.unfoldingText("\u5728\u7684\u8fdb\u5ea6", 105);
                            } else {
                                this.unfoldingText("YOU WILL LOSE", 70);
                                this.unfoldingText("CURRENT PROGRESS", 85);
                            }
                        }
                        if (this.languageType == 0) {
                            this.unfoldingText("\u78ba\u5b9a?", 130);
                        } else if (this.languageType == 1) {
                            this.unfoldingText("\u786e\u5b9a?", 130);
                        } else {
                            this.unfoldingText("ARE YOU SURE?", 100);
                        }
                    } else if (this.paused) {
                        if (this.languageType == 0) {
                            this.unfoldingText("\u904a\u6232\u66ab\u505c", 120);
                        } else if (this.languageType == 1) {
                            this.unfoldingText("\u6e38\u620f\u6682\u505c", 120);
                        } else {
                            this.unfoldingText("GAME PAUSED", 90);
                        }
                    }
                    ++this.traverseIndex;
                    this.animateMainMenu();
                    break;
                }
                case 12: {
                    int i;
                    int j;
                    if (this.traverseIndex < 5) {
                        this.traverseGrid();
                        ++this.traverseIndex;
                    } else {
                        this.traverseIndex = 0;
                        for (i = 0; i < 6; ++i) {
                            for (j = 0; j < 6; ++j) {
                                if (this.layer.getCell(i, j) <= 8) continue;
                                this.layer.setCell(i, j, this.nextInt(types_OF_CELLS) + 1 + 24);
                            }
                        }
                        this.gameState = 14;
                    }
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    this.layer.paint(this.g);
                    break;
                }
                case 14: {
                    int i;
                    int j;
                    if (this.traverseIndex < 4) {
                        ++this.traverseIndex;
                        this.backLayer.paint(this.g);
                        this.layer.paint(this.g);
                        for (i = 0; i < 6; ++i) {
                            for (j = 0; j < 6; ++j) {
                                if (this.layer.getCell(i, j) <= 6) continue;
                                this.layer.setCell(i, j, this.layer.getCell(i, j) - 6);
                            }
                        }
                        break;
                    }
                    for (i = 0; i < 6; ++i) {
                        for (j = 0; j < 3; ++j) {
                            this.arrangedCols[i][j] = -1;
                            this.arrangedRows[i][j] = -1;
                        }
                    }
                    this.traverseIndex = 0;
                    if (this.setArranged(false)) {
                        this.traverseGrid();
                        this.selectionFlag = false;
                        this.moveVal = 0;
                        this.gameState = 12;
                        break;
                    }
                    this.g.setColor(6438920);
                    this.g.fillRect(this.offsetX, this.offsetY, 180, 180);
                    this.layer.paint(this.g);
                    this.gameState = 9;
                    break;
                }
                case 10: {
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    if (this.currentColumn < this.selectedColumn) {
                        this.selectorLeft.setFrame(this.selectedIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30 - this.moveVal, this.offsetY + this.selectedRow * 30);
                        this.selectorRight.setFrame(this.currentIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30 + this.moveVal, this.offsetY + this.currentRow * 30);
                    } else if (this.currentColumn > this.selectedColumn) {
                        this.selectorLeft.setFrame(this.selectedIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30 + this.moveVal, this.offsetY + this.selectedRow * 30);
                        this.selectorRight.setFrame(this.currentIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30 - this.moveVal, this.offsetY + this.currentRow * 30);
                    } else if (this.currentRow < this.selectedRow) {
                        this.selectorLeft.setFrame(this.selectedIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30, this.offsetY + this.selectedRow * 30 - this.moveVal);
                        this.selectorRight.setFrame(this.currentIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30, this.offsetY + this.currentRow * 30 + this.moveVal);
                    } else if (this.currentRow > this.selectedRow) {
                        this.selectorLeft.setFrame(this.selectedIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30, this.offsetY + this.selectedRow * 30 + this.moveVal);
                        this.selectorRight.setFrame(this.currentIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30, this.offsetY + this.currentRow * 30 - this.moveVal);
                    }
                    this.selectorLeft.paint(this.g);
                    this.selectorRight.paint(this.g);
                    this.moveVal += 5;
                    if (this.moveVal < 30) break;
                    this.layer.setCell(this.currentColumn, this.currentRow, this.selectedIndex + 1);
                    this.layer.setCell(this.selectedColumn, this.selectedRow, this.currentIndex + 1);
                    if (this.setArranged(false)) {
                        this.traverseGrid();
                        this.selectionFlag = false;
                        this.moveVal = 0;
                        this.g.setClip(0, 0, 320, 240);
                        this.gameState = 12;
                        if (this.soundVolume <= 0) break;
                        try {
                            this.arrangedSoundIndex = this.nextInt(4);
                            this.musicPlayer[4 + this.arrangedSoundIndex].start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    if (this.soundVolume > 0) {
                        try {
                            this.musicPlayer[2].start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.moveVal = 0;
                    this.gameState = 11;
                    this.layer.setCell(this.currentColumn, this.currentRow, 0);
                    this.layer.setCell(this.selectedColumn, this.selectedRow, 0);
                    break;
                }
                case 11: {
                    this.backLayer.paint(this.g);
                    this.layer.paint(this.g);
                    if (this.currentColumn < this.selectedColumn) {
                        this.selectorLeft.setFrame(this.currentIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30 - this.moveVal, this.offsetY + this.selectedRow * 30);
                        this.selectorRight.setFrame(this.selectedIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30 + this.moveVal, this.offsetY + this.currentRow * 30);
                    } else if (this.currentColumn > this.selectedColumn) {
                        this.selectorLeft.setFrame(this.currentIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30 + this.moveVal, this.offsetY + this.selectedRow * 30);
                        this.selectorRight.setFrame(this.selectedIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30 - this.moveVal, this.offsetY + this.currentRow * 30);
                    } else if (this.currentRow < this.selectedRow) {
                        this.selectorLeft.setFrame(this.currentIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30, this.offsetY + this.selectedRow * 30 - this.moveVal);
                        this.selectorRight.setFrame(this.selectedIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30, this.offsetY + this.currentRow * 30 + this.moveVal);
                    } else if (this.currentRow > this.selectedRow) {
                        this.selectorLeft.setFrame(this.currentIndex);
                        this.selectorLeft.setPosition(this.offsetX + this.selectedColumn * 30, this.offsetY + this.selectedRow * 30 + this.moveVal);
                        this.selectorRight.setFrame(this.selectedIndex);
                        this.selectorRight.setPosition(this.offsetX + this.currentColumn * 30, this.offsetY + this.currentRow * 30 - this.moveVal);
                    }
                    this.selectorLeft.paint(this.g);
                    this.selectorRight.paint(this.g);
                    this.moveVal += 5;
                    if (this.moveVal < 30) break;
                    this.layer.setCell(this.currentColumn, this.currentRow, this.currentIndex + 1);
                    this.layer.setCell(this.selectedColumn, this.selectedRow, this.selectedIndex + 1);
                    this.selectionFlag = false;
                    this.moveVal = 0;
                    this.gameState = 9;
                    break;
                }
                default: {
                    if (this.getKeyStates() == 0) break;
                    this.g.setClip(0, 0, 320, 240);
                    this.gameState = 1;
                }
            }
            if (this.gameState >= 9 && this.minusTime != -1L && this.minusTime < System.currentTimeMillis()) {
                this.minusTime = System.currentTimeMillis() + 1500L;
                this.barValue = this.currentLevel < 200 ? (this.barValue -= this.currentLevel / 10 + 1) : (this.barValue -= this.currentLevel / 20 + 1);
            }
            if (this.gameState >= 9) {
                this.g.drawImage(this.hud, 0, 0, 0);
                if (tempBarValue < this.barValue) {
                    tempBarValue += (this.barValue - tempBarValue) / 5 + 1;
                } else if (tempBarValue > this.barValue) {
                    this.flushGraphics(0, 14, 320, 20);
                    tempBarValue -= (tempBarValue - this.barValue) / 5 + 1;
                }
                if (tempBarValue <= 0) {
                    this.currentLevel = 0;
                    this.writeRMS(true);
                    this.ppmenuItems[this.languageType][0] = this.languageType == 0 ? "*\u7e7c\u7e8c" : (this.languageType == 1 ? "*\u7ee7\u7eed" : "*CONTINUE");
                    this.totalScore += this.score;
                    this.noticeBoard = null;
                    this.g.setClip(0, 0, 320, 240);
                    this.gameState = 6;
                    this.takeInput = true;
                    this.selectorLeft.setPosition(0, this.offsetY);
                }
                this.vine.setPosition(0, 20);
                this.vine.setFrame(0);
                this.g.setClip(0, 20, tempBarValue, 20);
                this.vine.paint(this.g);
                if (this.languageType == 0) {
                    this.displayString("\u5206\u6578  " + (this.totalScore + this.score), 105, 7, false);
                } else if (this.languageType == 1) {
                    this.displayString("\u5206\u6570  " + (this.totalScore + this.score), 105, 7, false);
                } else {
                    this.displayString("SCORE  " + (this.totalScore + this.score), 155, 5, false);
                }
                this.g.setClip(0, 0, 320, 240);
            }
            this.flushGraphics();
            long end = System.currentTimeMillis();
            int duration = (int)(end - start);
            if (duration >= timeStep) continue;
            try {
                Thread.sleep(timeStep);
            }
            catch (InterruptedException ie) {
                this.stop();
            }
        }
    }

    protected void start() {
        this.playing = true;
        Thread t = new Thread(this);
        t.start();
    }

    public void stop() {
        this.playing = false;
    }

    public void input() {
        int states = this.getKeyStates();
        this.changeSelection = 0;
        if (this.selectionFlag) {
            this.player.nextFrame();
            if ((states & 2) != 0) {
                if (this.currentRow != 0) {
                    --this.currentRow;
                }
                this.swap();
            } else if ((states & 0x40) != 0) {
                if (this.currentRow != 5) {
                    ++this.currentRow;
                }
                this.swap();
            } else if ((states & 4) != 0) {
                if (this.currentColumn != 0) {
                    --this.currentColumn;
                }
                this.swap();
            } else if ((states & 0x20) != 0) {
                if (this.currentColumn != 5) {
                    ++this.currentColumn;
                }
                this.swap();
            } else if ((states & 0x100) != 0) {
                this.selectionFlag = false;
            }
        } else if ((states & 0x100) != 0) {
            this.selectedColumn = this.currentColumn;
            this.selectedRow = this.currentRow;
            this.selectionFlag = true;
        } else if ((states & 2) != 0) {
            this.currentRow = this.currentRow == 0 ? 5 : --this.currentRow;
        } else if ((states & 0x40) != 0) {
            this.currentRow = this.currentRow == 5 ? 0 : ++this.currentRow;
        } else if ((states & 4) != 0) {
            this.currentColumn = this.currentColumn == 0 ? 5 : --this.currentColumn;
        } else if ((states & 0x20) != 0) {
            this.currentColumn = this.currentColumn == 5 ? 0 : ++this.currentColumn;
        }
    }

    public void swap() {
        if (this.soundVolume > 0 && this.musicPlayer[4 + this.arrangedSoundIndex].getState() != 400) {
            try {
                this.musicPlayer[3].start();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
        this.currentIndex = this.layer.getCell(this.currentColumn, this.currentRow) - 1;
        this.selectedIndex = this.layer.getCell(this.selectedColumn, this.selectedRow) - 1;
        this.selectionFlag = false;
        if (this.currentIndex == this.selectedIndex) {
            return;
        }
        this.gameState = 10;
        this.layer.setCell(this.currentColumn, this.currentRow, 0);
        this.layer.setCell(this.selectedColumn, this.selectedRow, 0);
    }

    public void createBoard(int bloomVal) {
        int j;
        int i;
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                this.layer.setCell(i, j, this.nextInt(types_OF_CELLS) + 1);
            }
        }
        while (this.setArranged(true)) {
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                this.layer.setCell(i, j, this.layer.getCell(i, j) + bloomVal);
            }
        }
    }

    public boolean setArranged(boolean changeSet) {
        int i;
        int j;
        boolean arranged = false;
        boolean len = false;
        int start = 0;
        int k = 0;
        int temp = 0;
        block8: for (j = 0; j < 6; ++j) {
            k = 0;
            for (i = 0; i < 4; ++i) {
                temp = this.layer.getCell(j, i);
                if (temp != this.layer.getCell(j, i + 1) || temp != this.layer.getCell(j, i + 2)) continue;
                if (changeSet) {
                    i += 2;
                    try {
                        this.layer.setCell(j, i, temp + 1);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.layer.setCell(j, i, temp - 1);
                    }
                } else {
                    start = i;
                    i += 2;
                    try {
                        while (this.layer.getCell(j, i) == this.layer.getCell(j, i + 1)) {
                            ++i;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("caught " + e + " with i:" + i);
                    }
                    arranged = true;
                    this.arrangedCols[j][k] = start;
                    this.arrangedCols[j][++k] = i;
                    this.arrangedCols[j][++k] = temp;
                    System.out.println("got it: col :" + j + " start " + start + " end:" + i);
                    if (i - start > 2 && this.vibrations) {
                        this.midlet.vibra(1000);
                    }
                }
                if (i > 4) continue block8;
            }
        }
        block11: for (j = 0; j < 6; ++j) {
            k = 0;
            for (i = 0; i < 4; ++i) {
                temp = this.layer.getCell(i, j);
                if (temp != this.layer.getCell(i + 1, j) || temp != this.layer.getCell(i + 2, j)) continue;
                if (changeSet) {
                    i += 2;
                    try {
                        this.layer.setCell(i, j, temp + 1);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.layer.setCell(i, j, temp - 1);
                    }
                } else {
                    start = i;
                    i += 2;
                    try {
                        while (this.layer.getCell(i, j) == this.layer.getCell(i + 1, j)) {
                            ++i;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        System.out.println("caught " + e + " with j:" + i);
                    }
                    arranged = true;
                    this.arrangedRows[j][k] = start;
                    this.arrangedRows[j][++k] = i;
                    this.arrangedRows[j][++k] = temp;
                    System.out.println("got it: row :" + j + " start " + start + " end:" + i);
                    if (i - start > 2 && this.vibrations) {
                        this.midlet.vibra(1000);
                    }
                }
                if (i > 4) continue block11;
            }
        }
        return arranged;
    }

    public void traverseGrid() {
        int i;
        int k = 0;
        for (i = 0; i < 6; ++i) {
            if (this.arrangedCols[i][0] != -1) {
                if (this.traverseIndex == 4) {
                    this.arrangedCols[i][2] = this.arrangedCols[i][1] - this.arrangedCols[i][0] - 1;
                    this.score += this.arrangedCols[i][2] * 10 * (2 + this.arrangedCols[i][2]);
                    this.barValue += this.score >> 3;
                    this.minusTime = System.currentTimeMillis() + 1500L;
                }
                for (k = this.arrangedCols[i][0]; k <= this.arrangedCols[i][1]; ++k) {
                    this.layer.setCell(i, k, this.arrangedCols[i][2] + 8 * this.traverseIndex);
                }
            }
            if (this.arrangedCols[i][3] == -1) continue;
            if (this.traverseIndex == 4) {
                this.arrangedCols[i][5] = this.arrangedCols[i][4] - this.arrangedCols[i][3] - 1;
                this.score += this.arrangedCols[i][5] * 10 * (2 + this.arrangedCols[i][5]);
                this.barValue += this.score >> 3;
                this.minusTime = System.currentTimeMillis() + 1500L;
            }
            for (k = this.arrangedCols[i][3]; k <= this.arrangedCols[i][4]; ++k) {
                this.layer.setCell(i, k, this.arrangedCols[i][5] + 8 * this.traverseIndex);
            }
        }
        for (i = 0; i < 6; ++i) {
            if (this.arrangedRows[i][0] != -1) {
                if (this.traverseIndex == 4) {
                    this.arrangedRows[i][2] = this.arrangedRows[i][1] - this.arrangedRows[i][0] - 1;
                    this.score += this.arrangedRows[i][2] * 10 * (2 + this.arrangedRows[i][2]);
                    this.barValue += this.score >> 3;
                    this.minusTime = System.currentTimeMillis() + 1500L;
                }
                for (k = this.arrangedRows[i][0]; k <= this.arrangedRows[i][1]; ++k) {
                    this.layer.setCell(k, i, this.arrangedRows[i][2] + 8 * this.traverseIndex);
                }
            }
            if (this.arrangedRows[i][3] == -1) continue;
            if (this.traverseIndex == 4) {
                this.arrangedRows[i][5] = this.arrangedRows[i][4] - this.arrangedRows[i][3] - 1;
                this.score += this.arrangedRows[i][5] * 10 * (2 + this.arrangedRows[i][5]);
                this.barValue += this.score >> 3;
                this.minusTime = System.currentTimeMillis() + 1500L;
            }
            for (k = this.arrangedRows[i][3]; k <= this.arrangedRows[i][4]; ++k) {
                this.layer.setCell(k, i, this.arrangedRows[i][5] + 8 * this.traverseIndex);
            }
        }
    }

    public void animateMainMenu() {
        if (this.changeSelection == -5) {
            this.stopSound = false;
            this.changeSelection = 0;
            this.traverseIndex = 0;
            this.unfoldingIndex = 0;
            block2 : switch (this.menuType) {
                case 7: {
                    switch (this.menuIndex) {
                        case 1: {
                            if (this.confirmNewGameStart) {
                                this.menuIndex = 0;
                                this.menuItems = this.ppmenuItems[this.languageType];
                                this.menuType = 2;
                                this.confirmNewGameStart = false;
                                break block2;
                            }
                            if (this.paused) {
                                this.menuIndex = 0;
                                this.menuItems = this.pauseMenuItems[this.languageType];
                                this.menuType = 1;
                                break block2;
                            }
                            this.menuIndex = 0;
                            this.menuItems = this.mmenuItems[this.languageType];
                            this.menuType = 0;
                            break block2;
                        }
                        case 2: {
                            if (this.confirmNewGameStart) {
                                this.totalScore = 0;
                                this.score = 0;
                                this.currentLevel = 0;
                                this.gameState = 4;
                                this.confirmNewGameStart = false;
                                break block2;
                            }
                            if (this.paused) {
                                this.paused = false;
                                this.stopSound = false;
                                this.menuItems = this.mmenuItems[this.languageType];
                                this.menuType = 0;
                                this.noticeBoard = null;
                                break block2;
                            }
                            try {
                                this.musicPlayer[0].stop();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                            this.playing = false;
                            this.midlet.destroyApp(true);
                            this.midlet.notifyDestroyed();
                            break block2;
                        }
                    }
                    break;
                }
                case 0: {
                    this.paused = false;
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuItems = this.ppmenuItems[this.languageType];
                            this.menuType = 2;
                            break block2;
                        }
                        case 1: {
                            this.menuItems = this.omenuItems[this.languageType];
                            this.menuType = 3;
                            break block2;
                        }
                        case 2: {
                            this.gameState = 5;
                            break block2;
                        }
                        case 3: {
                            this.gameState = 3;
                            break block2;
                        }
                        case 4: {
                            this.gameState = 2;
                            break block2;
                        }
                    }
                    this.menuIndex = 0;
                    this.menuItems = this.confirmationItems[this.languageType];
                    this.menuType = 7;
                    break;
                }
                case 2: {
                    switch (this.menuIndex) {
                        case 1: {
                            if (this.ppmenuItems[this.languageType][0].charAt(0) == '*') {
                                this.currentLevel = 0;
                                this.score = 0;
                                this.totalScore = 0;
                                this.gameState = 4;
                                break block2;
                            }
                            this.confirmNewGameStart = true;
                            this.menuIndex = 0;
                            this.menuItems = this.confirmationItems[this.languageType];
                            this.menuType = 7;
                            break block2;
                        }
                        case 0: {
                            this.readRMS();
                            --this.currentLevel;
                            this.gameState = 4;
                            break block2;
                        }
                    }
                    this.menuItems = this.mmenuItems[this.languageType];
                    this.menuType = 0;
                    break;
                }
                case 3: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.menuIndex = this.soundVolume / 33;
                            this.menuItems = this.soundsItems[this.languageType];
                            this.menuType = 4;
                            break block2;
                        }
                        case 1: {
                            this.menuIndex = this.vibrations ? 0 : 1;
                            this.menuItems = this.vibrationItems[this.languageType];
                            this.menuType = 5;
                            break block2;
                        }
                    }
                    if (this.paused) {
                        this.menuItems = this.pauseMenuItems[this.languageType];
                        this.menuType = 1;
                        break;
                    }
                    this.menuItems = this.mmenuItems[this.languageType];
                    this.menuType = 0;
                    break;
                }
                case 4: {
                    switch (this.menuIndex) {
                        case 0: {
                            this.soundVolume = 0;
                            try {
                                this.musicPlayer[0].stop();
                            }
                            catch (MediaException ex) {
                                ex.printStackTrace();
                            }
                            this.writeRMS(false);
                            break;
                        }
                        case 1: {
                            this.soundVolume = 33;
                            this.writeRMS(false);
                            break;
                        }
                        case 2: {
                            this.soundVolume = 66;
                            this.writeRMS(false);
                            break;
                        }
                        case 3: {
                            this.soundVolume = 100;
                            this.writeRMS(false);
                        }
                    }
                    this.menuItems = this.omenuItems[this.languageType];
                    this.menuType = 3;
                    break;
                }
                case 5: {
                    switch (this.menuIndex) {
                        case 1: {
                            this.vibrations = true;
                            this.midlet.vibra(1000);
                            this.writeRMS(false);
                            break;
                        }
                        case 2: {
                            this.vibrations = false;
                            this.writeRMS(false);
                            break;
                        }
                    }
                    this.menuItems = this.omenuItems[this.languageType];
                    this.menuType = 3;
                    break;
                }
                case 6: {
                    this.languageType = this.menuIndex;
                    this.menuItems = this.omenuItems[this.languageType];
                    this.menuType = 3;
                    break;
                }
                case 1: {
                    switch (this.menuIndex) {
                        case 1: {
                            this.paused = false;
                            this.gameState = this.lastGameState;
                            this.g.setColor(6438920);
                            this.g.fillRect(0, this.offsetY, 320, 240);
                            this.vine.setPosition(0, 220);
                            this.vine.setFrame(1);
                            this.vine.paint(this.g);
                            this.g.drawImage(this.hud, 0, 0, 0);
                            if (this.languageType == 0) {
                                this.displayString("SHUFFLE", 50, 305, false);
                                this.displayString("\u7b49\u7d1a " + this.currentLevel, 130, 305, false);
                                this.displayString("\u66ab\u505c", 200, 305, false);
                            } else if (this.languageType == 1) {
                                this.displayString("SHUFFLE", 50, 305, false);
                                this.displayString("\u5206\u6570 " + this.currentLevel, 130, 305, false);
                                this.displayString("\u6682\u505c", 200, 305, false);
                            } else {
                                this.displayString("SHUFFLE", 40, 300, false);
                                this.displayString("LEVEL " + this.currentLevel, 130, 300, false);
                                this.displayString("PAUSE", 210, 300, false);
                            }
                            this.flushGraphics();
                            this.getKeyStates();
                            break block2;
                        }
                        case 3: {
                            this.menuIndex = 0;
                            this.menuItems = this.confirmationItems[this.languageType];
                            this.menuType = 7;
                            break block2;
                        }
                        case 2: {
                            this.menuItems = this.omenuItems[this.languageType];
                            this.menuType = 3;
                        }
                    }
                }
            }
            if (this.menuType != 4 && this.menuType != 5 && this.menuType != 6) {
                this.menuIndex = 0;
            }
        }
        if (this.changeSelection == -1 || this.changeSelection == 1) {
            this.stopSound = false;
            this.traverseIndex = 0;
            do {
                this.menuIndex += this.changeSelection;
                if (this.menuIndex == -1) {
                    this.menuIndex = this.menuItems.length - 1;
                    continue;
                }
                if (this.menuIndex != this.menuItems.length) continue;
                this.menuIndex = 0;
            } while (this.menuItems[this.menuIndex].charAt(0) == '*');
        } else if (this.menuItems[this.menuIndex].charAt(0) == '*' && this.menuIndex == 0) {
            this.menuIndex = 1;
        }
        for (int i = 0; i < this.menuItems.length; ++i) {
            if (this.menuItems[i].charAt(0) == '*') continue;
            if (this.menuItems == this.mmenuItems[this.languageType]) {
                this.displayString(this.menuItems[i], 160, 20 * i + 85, i == this.menuIndex);
                continue;
            }
            this.displayString(this.menuItems[i], 160, 20 * i + 105, i == this.menuIndex);
        }
        this.changeSelection = 0;
        if (this.traverseIndex / 2 < 3) {
            this.menuVine.setFrame(this.traverseIndex / 2);
        } else {
            this.menuVine.setFrame(3);
        }
        if (this.menuItems == this.mmenuItems[this.languageType]) {
            this.menuVine.setPosition(90, 20 * this.menuIndex + 75);
        } else {
            this.menuVine.setPosition(90, 20 * this.menuIndex + 95);
        }
        this.menuVine.paint(this.g);
    }

    public void keyPressed(int keyCode) {
        if (this.gameState >= 7) {
            if (keyCode == -7) {
                if (!this.paused) {
                    this.lastGameState = this.gameState;
                    this.menuItems = this.pauseMenuItems[this.languageType];
                    this.menuType = 1;
                    this.menuIndex = 0;
                    this.changeSelection = 0;
                    this.g.setClip(0, 0, 320, 240);
                    this.gameState = 1;
                    this.paused = true;
                }
            } else if (keyCode == -6 && this.gameState == 9) {
                this.createBoard(0);
                this.g.setClip(0, 0, 320, 240);
                this.g.setColor(6438920);
                this.g.fillRect(this.offsetX, this.offsetY, 180, 180);
                this.layer.paint(this.g);
                this.player.paint(this.g);
                this.selectorLeft.setPosition(0, this.offsetY + 180);
                this.score -= 250;
                if (this.score < 0) {
                    this.totalScore += this.score;
                    this.score = 0;
                    if (this.totalScore < 0) {
                        this.totalScore = 0;
                    }
                }
                this.g.drawImage(this.hud, 0, 0, 0);
                this.displayString("" + (this.totalScore + this.score), 85, 3, false);
            }
        }
        if (this.gameState == 1) {
            if (keyCode == -1 || keyCode == 50) {
                this.changeSelection = -1;
            } else if (keyCode == -2 || keyCode == 56) {
                this.changeSelection = 1;
            } else if (keyCode == -5 || keyCode == 53) {
                this.changeSelection = -5;
            }
        } else if (this.gameState == 2 || this.gameState == 3 || this.gameState == 5 || this.gameState == 4) {
            this.changeSelection = keyCode == -3 || keyCode == 52 ? -1 : (keyCode == -4 || keyCode == 54 ? 1 : (keyCode == -5 || keyCode == 53 ? -5 : keyCode));
        } else if (this.gameState == 9) {
            this.changeSelection = this.getKeyStates();
            this.input();
        }
    }

    private void unfoldingText64(String str, int y) {
        this.g.drawString(str, 160, y, 0x10 | 1);
    }

    private void unfoldingText(String str, int y) {
        this.g.drawString(str, 160, y, 0x10 | 1);
    }

    private void displaySmallText64(String str, int x, int y) {
        this.g.drawString(str, x, y, 0x10 | 1);
    }

    private void displaySmallText(String str, int x, int y) {
        this.g.setColor(0);
        this.g.setFont(this.SMALLFONT);
        this.g.drawString(str, x + 2, y - 5, 0x10 | 4);
    }

    private void displayString(String str, int x, int y, boolean selected) {
        this.g.setColor(0);
        this.g.setFont(this.SMALLFONT);
        this.g.setClip(0, 0, 320, 240);
        this.g.drawString(str, x, y, 0x10 | 1);
    }

    private void setFontAttributes(int font_type) {
        if (font_type == 0) {
            this.g.setFont(this.SMALLFONT);
            this.fHeight = this.SMALLFONT.getHeight();
            this.fWidth = this.languageType == 0 ? this.SMALLFONT.charWidth('\u5956') : (this.languageType == 1 ? this.SMALLFONT.charWidth('\u5956') : this.SMALLFONT.charWidth('B'));
        } else if (font_type == 1) {
            this.g.setFont(this.BIGFONT);
            this.fHeight = this.BIGFONT.getHeight();
            this.fWidth = this.languageType == 0 ? this.BIGFONT.charWidth('\u5956') : (this.languageType == 1 ? this.BIGFONT.charWidth('\u5956') : this.BIGFONT.charWidth('B'));
        }
    }

    public void keyReleased(int keyCode) {
        if (this.takeInput) {
            if (keyCode >= 97 && keyCode <= 122 || keyCode >= 65 && keyCode <= 90) {
                if (this.lastKey == keyCode && this.uName[this.nameIndex] != ' ') {
                    ++this.repeatIndex;
                    this.keyDelay = System.currentTimeMillis() + WAIT_TIME;
                    this.lastKey = keyCode;
                    switch (keyCode) {
                        default: {
                            if (this.repeatIndex < 3) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                break;
                            }
                            if (this.repeatIndex == 3) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = (char)keyCode;
                            break;
                        }
                        case 55: {
                            if (this.repeatIndex < 4) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                break;
                            }
                            if (this.repeatIndex == 4) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = (char)keyCode;
                            break;
                        }
                        case 56: {
                            if (this.repeatIndex < 3) {
                                this.uName[this.nameIndex] = (char)(84 + this.repeatIndex);
                                break;
                            }
                            if (this.repeatIndex == 3) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = 84;
                            break;
                        }
                        case 57: {
                            if (this.repeatIndex < 4) {
                                this.uName[this.nameIndex] = (char)(87 + this.repeatIndex);
                                break;
                            }
                            if (this.repeatIndex == 4) {
                                this.uName[this.nameIndex] = (char)keyCode;
                                break;
                            }
                            this.repeatIndex = 0;
                            this.uName[this.nameIndex] = 87;
                            break;
                        }
                    }
                } else if (this.nameIndex < MAX_LENGTH) {
                    if (this.uName[this.nameIndex] != ' ' && this.nameIndex < MAX_LENGTH - 1) {
                        ++this.nameIndex;
                    }
                    this.repeatIndex = 0;
                    this.keyDelay = System.currentTimeMillis() + WAIT_TIME;
                    this.lastKey = keyCode;
                    switch (keyCode) {
                        default: {
                            this.uName[this.nameIndex] = (char)keyCode;
                            break;
                        }
                        case 49: {
                            this.uName[this.nameIndex] = 45;
                            break;
                        }
                        case 56: {
                            this.uName[this.nameIndex] = 84;
                            break;
                        }
                        case 57: {
                            this.uName[this.nameIndex] = 87;
                            break;
                        }
                    }
                }
            } else if ((keyCode == -8 || keyCode == -6) && this.nameIndex > 0) {
                if (this.uName[this.nameIndex] != ' ') {
                    this.uName[this.nameIndex] = 32;
                    this.keyDelay = System.currentTimeMillis();
                } else if (this.nameIndex > 0) {
                    --this.nameIndex;
                    this.uName[this.nameIndex] = 32;
                    this.keyDelay = System.currentTimeMillis();
                }
            } else if (keyCode == -4) {
                this.keyDelay = System.currentTimeMillis();
                this.repeatIndex = 0;
                this.lastKey = 0;
            } else if ((keyCode == -5 || keyCode == -7) && this.nameIndex >= 1) {
                this.takeInput = false;
            }
        }
    }

    public void writeRMS(boolean completeGame) {
        if (completeGame) {
            this.rec[0] = (byte)this.currentLevel;
            this.rec[1] = (byte)(this.currentLevel >>> 8);
            this.rec[2] = (byte)this.totalScore;
            this.rec[3] = (byte)(this.totalScore >>> 8);
            this.rec[4] = (byte)(this.totalScore >>> 16);
        }
        this.rec[5] = 0;
        this.rec[5] = (byte)(this.soundVolume / 33);
        if (this.vibrations) {
            this.rec[5] = (byte)(this.rec[5] | 4);
        }
        try {
            this.rs = RecordStore.openRecordStore((String)"SurvivalDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.setRecord(1, this.rec, 0, 6);
            } else {
                this.rs.addRecord(this.rec, 0, 6);
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write into rs : " + e);
        }
    }

    public void readRMS() {
        try {
            this.rs = RecordStore.openRecordStore((String)"SurvivalDB", (boolean)true);
            this.rec = this.rs.getRecord(1);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open recordStore" + e);
            this.ppmenuItems[this.languageType][0] = this.languageType == 0 ? "*\u7e7c\u7e8c" : (this.languageType == 1 ? "*\u7ee7\u7eed" : "*CONTINUE");
        }
        this.soundVolume = (this.rec[5] & 3) * 33;
        this.vibrations = (this.rec[5] & 4) != 0;
        this.currentLevel = this.rec[1] << 8 & 0xFF00 | this.rec[0] & 0xFF;
        this.ppmenuItems[this.languageType][0] = this.currentLevel <= 0 ? (this.languageType == 0 ? "*\u7e7c\u7e8c" : (this.languageType == 1 ? "*\u7ee7\u7eed" : "*CONTINUE")) : (this.languageType == 0 ? "\u7e7c\u7e8c" : (this.languageType == 1 ? "\u7ee7\u7eed" : "CONTINUE"));
        this.totalScore = this.rec[4] << 16 & 0xFF0000 | this.rec[3] << 8 & 0xFF00 | this.rec[2] & 0xFF;
    }

    public void fillHighScoresData() {
        try {
            this.rs = RecordStore.openRecordStore((String)"FloScoresDB", (boolean)true);
            if (this.rs.getNumRecords() > 0) {
                this.rs.closeRecordStore();
                return;
            }
            byte[] b = new byte[14];
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.addRecord(b, 0, 14);
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant write into rs : " + e);
        }
    }

    public String[] getHighScores(int[] scores) {
        byte[] records = new byte[14];
        String[] names = new String[5];
        try {
            this.rs = RecordStore.openRecordStore((String)"FloScoresDB", (boolean)true);
            records = this.rs.getRecord(1);
            names[0] = new String(records, 0, 6);
            scores[0] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(2);
            names[1] = new String(records, 0, 6);
            scores[1] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(3);
            names[2] = new String(records, 0, 6);
            scores[2] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(4);
            names[3] = new String(records, 0, 6);
            scores[3] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            records = this.rs.getRecord(5);
            names[4] = new String(records, 0, 6);
            scores[4] = records[6] & 0xFF | records[7] << 8 & 0xFF00 | records[8] << 16 & 0xFF0000;
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open scores recordStore " + e);
            this.mmenuItems[this.languageType][2] = this.languageType == 0 ? "*\u5206\u6578" : (this.languageType == 1 ? "*\u5206\u6570" : "*HIGHSCORES");
        }
        return names;
    }

    public void updateHighScores() {
        if (this.totalScore <= 0) {
            return;
        }
        int pos = -1;
        int[] highScores = new int[5];
        byte[][] records = new byte[14][5];
        try {
            int i;
            this.rs = RecordStore.openRecordStore((String)"FloScoresDB", (boolean)true);
            records[0] = this.rs.getRecord(1);
            highScores[0] = records[0][6] & 0xFF | records[0][7] << 8 & 0xFF00 | records[0][8] << 16 & 0xFF0000;
            records[1] = this.rs.getRecord(2);
            highScores[1] = records[1][6] & 0xFF | records[1][7] << 8 & 0xFF00 | records[1][8] << 16 & 0xFF0000;
            records[2] = this.rs.getRecord(3);
            highScores[2] = records[2][6] & 0xFF | records[2][7] << 8 & 0xFF00 | records[2][8] << 16 & 0xFF0000;
            records[3] = this.rs.getRecord(4);
            highScores[3] = records[3][6] & 0xFF | records[3][7] << 8 & 0xFF00 | records[3][8] << 16 & 0xFF0000;
            records[4] = this.rs.getRecord(5);
            highScores[4] = records[4][6] & 0xFF | records[4][7] << 8 & 0xFF00 | records[4][8] << 16 & 0xFF0000;
            for (i = 4; i >= 0; --i) {
                if (this.totalScore <= highScores[i]) continue;
                pos = i;
            }
            if (pos != -1) {
                i = 4;
                while (i > pos - 1) {
                    System.arraycopy(records[i - 1], 0, records[i], 0, 14);
                    if (--i != 0) continue;
                }
                records[pos][0] = (byte)this.uName[0];
                records[pos][1] = (byte)this.uName[1];
                records[pos][2] = (byte)this.uName[2];
                records[pos][3] = (byte)this.uName[3];
                records[pos][4] = (byte)this.uName[4];
                records[pos][5] = (byte)this.uName[5];
                records[pos][6] = (byte)this.totalScore;
                records[pos][7] = (byte)(this.totalScore >>> 8);
                records[pos][8] = (byte)(this.totalScore >>> 16);
                for (i = pos; i < 5; ++i) {
                    this.rs.setRecord(i + 1, records[i], 0, 14);
                }
                this.mmenuItems[this.languageType][2] = this.languageType == 0 ? "\u5206\u6578" : (this.languageType == 1 ? "\u5206\u6570" : "HIGHSCORES");
            }
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            System.out.println("cant open scores recordStore for updation" + e);
            this.mmenuItems[this.languageType][2] = this.languageType == 0 ? "*\u5206\u6578" : (this.languageType == 1 ? "*\u5206\u6570" : "*HIGHSCORES");
        }
    }

    private void initMedia() {
        if (this.musicPlayer == null) {
            String[] musicFiles = new String[]{"/tts.mid", "/err.mid", "/mv.mid", "/scr.mid", "/scr2.mid", "/scr3.mid", "/scr4.mid", "/scr5.mid"};
            this.musicPlayer = new Player[8];
            for (int i = 0; i < this.musicPlayer.length; ++i) {
                try {
                    InputStream is = this.getClass().getResourceAsStream(musicFiles[i]);
                    this.musicPlayer[i] = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                    this.musicPlayer[i].realize();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("exception raised in initMedia " + e + " with message " + e.getMessage());
                }
            }
            this.musicPlayer[0].setLoopCount(-1);
        }
        if (this.soundVolume > 0) {
            VolumeControl vc = (VolumeControl)this.musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[0].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[1].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[2].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[3].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[4].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[5].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[6].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
            vc = (VolumeControl)this.musicPlayer[7].getControl("VolumeControl");
            vc.setLevel(this.soundVolume);
        } else {
            try {
                this.musicPlayer[0].stop();
                this.musicPlayer[1].stop();
                this.musicPlayer[2].stop();
                this.musicPlayer[3].stop();
                this.musicPlayer[4].stop();
                this.musicPlayer[5].stop();
                this.musicPlayer[6].stop();
                this.musicPlayer[7].stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    public int nextInt() {
        this.seed = this.seed * -554899859 + 11 & 0xFFFFFF;
        return this.seed >>> 8;
    }

    public int nextInt(int n) {
        this.seed = this.seed * -554899859 + 11 & 0xFFFFFF;
        return (this.seed >>> 8) % n;
    }

    public int nextSignedInt(int n) {
        this.seed = this.seed * -554899859 + 11 & 0xFFFFFF;
        return (this.seed >>> 8) % (n * 2) - n;
    }

    public void hideNotify() {
        if (this.gameState >= 7 && !this.paused) {
            this.lastGameState = this.gameState;
            this.menuItems = this.pauseMenuItems[this.languageType];
            this.menuType = 1;
            this.menuIndex = 0;
            this.changeSelection = 0;
            this.g.setClip(0, 0, 320, 240);
            this.gameState = 1;
            this.paused = true;
            this.writeRMS(true);
            this.stopSound = true;
        }
    }
}

