/*
 * Decompiled with CFR 0.152.
 */
public class SimpleStack {
    private int elementCount;
    private int capacityIncrement;
    private Object[] stack;

    public SimpleStack() {
        this(10);
    }

    public SimpleStack(int n) {
        this(n, 0);
    }

    public SimpleStack(int n, int n2) {
        this.stack = new Object[n];
        this.elementCount = 0;
        this.capacityIncrement = n2;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean empty() {
        return this.elementCount == 0;
    }

    public void push(Object object) {
        this.ensureCapacity(this.elementCount + 1);
        this.stack[this.elementCount++] = object;
    }

    public Object pop() {
        --this.elementCount;
        Object object = this.stack[this.elementCount];
        this.stack[this.elementCount] = null;
        return object;
    }

    private void ensureCapacity(int n) {
        int n2 = this.stack.length;
        if (n > n2) {
            int n3;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            Object[] objectArray = Utils.arrayCopyOf(this.stack, n3);
            this.clearStack();
            this.stack = objectArray;
        }
    }

    public void removeAllElements() {
        this.clearStack();
        this.elementCount = 0;
        this.stack = null;
    }

    private void clearStack() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.stack[i] = null;
        }
    }
}

