/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Sensor
extends GameObject {
    public static final int SENSOR_TYPE_NEAREST_AIR_VEHICLE_IN_CONIC_RANGE = 1;
    public static final int SENSOR_TYPE_OBSTACLE_DETECTOR = 2;
    public static final int SENSOR_TYPE_TURNING_DETECTOR = 3;
    protected int type;
    protected Vehicle owner;
    protected boolean enabled;
    protected int capturableObjectId;
    protected boolean capturableObjectInRange;
    protected int nearestObjectId;
    protected int nearestObjectDistance;
    protected int nearestObjectX;
    protected int nearestObjectY;
    protected boolean auxObstacleDetected;
    protected boolean obstacleDetected;
    protected int turnValueFP;
    protected int turnValueTempFP;

    public Sensor() {
        super(-1);
    }

    public void init(int n, Vehicle vehicle) {
        super.init(7, vehicle.getPositionXFP(), vehicle.getPositionYFP(), 120, null);
        this.type = n;
        this.owner = vehicle;
        this.enabled = true;
        this.setPositionFP(this.owner.getPositionXFP(), this.owner.getPositionYFP());
        this.resetSensor(n);
    }

    public void deinit() {
    }

    private void resetSensor(int n) {
        switch (n) {
            case 1: {
                this.nearestObjectId = -1;
                break;
            }
            case 2: {
                this.obstacleDetected = false;
                this.auxObstacleDetected = false;
                break;
            }
            case 3: {
                this.turnValueFP = 0;
                this.turnValueTempFP = 0;
            }
        }
    }

    public void update(int n) {
        super.update(n);
        this.setPositionFP(this.owner.getPositionXFP(), this.owner.getPositionYFP());
        if (!this.isEnabled()) {
            return;
        }
        switch (this.type) {
            case 1: {
                this.nearestObjectId = -1;
                break;
            }
            case 2: {
                this.obstacleDetected = this.auxObstacleDetected;
                this.auxObstacleDetected = false;
                break;
            }
            case 3: {
                this.turnValueFP = this.turnValueTempFP;
                this.turnValueTempFP = 0;
            }
        }
    }

    public void notifyAfterCollisionWithTile(int n, int n2, int n3) {
        if (!this.isEnabled()) {
            return;
        }
        switch (this.type) {
            case 2: {
                if (n3 == 0 || n3 == -1) break;
                this.auxObstacleDetected = true;
                break;
            }
            case 3: {
                int n4 = n * 1024;
                int n5 = n2 * 1024;
                this.turnValueTempFP += this.computeTurnValueFP(n4, n5, 1024, 1024);
                break;
            }
        }
    }

    public void notifyAfterCollision(GameObject gameObject) {
        if (!this.isEnabled()) {
            return;
        }
        super.notifyAfterCollision(gameObject);
        if (gameObject == this.owner) {
            return;
        }
        switch (this.type) {
            case 1: {
                Vehicle vehicle;
                if (!gameObject.isVehicle() || !(vehicle = (Vehicle)gameObject).isAirVehicle() || vehicle.isDead() || gameObject.getPositionYFP() >= this.getPositionYFP() + this.getCollisionBoxFP()[1] + this.getCollisionBoxFP()[3] || (gameObject.getPositionXFP() > this.getPositionXFP() || gameObject.getPositionYFP() >= gameObject.getPositionXFP() + (this.getPositionYFP() - this.getPositionXFP())) && (this.getPositionXFP() >= gameObject.getPositionXFP() || gameObject.getPositionYFP() >= -gameObject.getPositionXFP() + (this.getPositionYFP() + this.getPositionXFP()))) break;
                this.checkNearestObject(gameObject);
                break;
            }
            case 2: {
                this.auxObstacleDetected = true;
                break;
            }
            case 3: {
                this.turnValueTempFP += this.computeTurnValueFP(gameObject.getLeftFP(), gameObject.getTopFP(), gameObject.getWidthFP(), gameObject.getHeightFP());
            }
        }
    }

    protected int computeTurnValueFP(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl;
        int n7 = n + n3 / 2;
        int n8 = n2 + n4 / 2;
        int n9 = 0;
        boolean bl2 = bl = n8 < this.owner.getTopFP();
        if (bl) {
            n6 = Math.abs(n7 - this.getPositionXFP());
            n5 = Math.abs(this.getPositionYFP() - n8);
            n9 = n7 < this.getPositionXFP() ? -(n6 + n5) : n6 + n5;
        } else {
            n6 = Math.abs(n7 - this.getPositionXFP());
            n9 = n7 < this.getPositionXFP() ? -n6 : n6;
        }
        n6 = n9 == 0 ? -10240 : ((n5 = n9 >> 5) != 0 ? 1024 / n5 << 5 : -10240);
        return n6;
    }

    public void updateDrawPosition(int n, int n2) {
        super.updateDrawPosition(n, n2);
        if (this.nearestObjectId != -1) {
            GameObject gameObject = GameObjectManager.getGameObject(this.nearestObjectId);
            this.nearestObjectX = n + Map.mapTilesFPToPixels(gameObject.getPositionXFP()) - ResourceManager.map.getCameraX();
            this.nearestObjectY = n2 + Map.mapTilesFPToPixels(gameObject.getPositionYFP()) - ResourceManager.map.getCameraY();
        }
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.type) {
            case 1: {
                if (this.nearestObjectId == -1) break;
                graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                graphics.setColor(65280);
                graphics.drawRect(this.nearestObjectX - 10, this.nearestObjectY - 10, 20, 20);
                graphics.drawRect(this.nearestObjectX - 5, this.nearestObjectY - 5, 10, 10);
            }
        }
    }

    private void checkNearestObject(GameObject gameObject) {
        if (this.nearestObjectId != -1) {
            int n = this.distanceTo(gameObject);
            if (n < this.nearestObjectDistance) {
                this.nearestObjectId = gameObject.getuId();
                this.nearestObjectDistance = n;
            }
        } else {
            this.nearestObjectId = gameObject.getuId();
            this.nearestObjectDistance = this.distanceTo(gameObject);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.excludeFromCollisionCheckHint = true;
            this.excludeFromVisibilityCheckHint = true;
        } else {
            this.excludeFromCollisionCheckHint = false;
            this.excludeFromVisibilityCheckHint = false;
            this.resetSensor(this.type);
        }
    }

    public int getNearestObjectId() {
        return this.nearestObjectId;
    }

    public int getCapturableObjectId() {
        return this.capturableObjectId;
    }

    public boolean IsObstacleDetected() {
        return this.obstacleDetected;
    }

    public int getTurnValueFP() {
        return this.turnValueFP;
    }
}

