/*
 * Decompiled with CFR 0.152.
 */
public final class ResourceManager {
    public static Map map;
    private static int[] tileSetsImagesId;
    private static int[] commandLoadingQueue;
    private static int[] idLoadingQueue;
    private static boolean isProcessing;
    private static boolean passToNextCommand;
    public static int loadingQueueIndex;
    private static int loadingQueueItems;
    private static int loadingProgress;
    private static final int LOADING_QUEUE_SIZE = 256;
    public static final int COMMAND_NA = -1;
    public static final int COMMAND_LOAD_MAP = 0;
    public static final int COMMAND_LOAD_TILESET = 1;
    public static final int COMMAND_LOAD_IMAGE = 2;
    public static final int COMMAND_LOAD_SPRITE = 3;
    public static final int COMMAND_LOAD_MENU = 4;
    public static final int COMMAND_LOAD_SOUND = 5;
    public static final int COMMAND_LOAD_RMS = 6;
    public static final int COMMAND_LOAD_SIMPLE_SPRITE = 7;
    public static final int COMMAND_LOAD_SFX = 10;
    public static final int COMMAND_LOAD_PALETTE = 11;
    public static final int COMMAND_SET_TILESET = 17;
    public static final int COMMAND_INIT_GAME = 18;
    public static final int COMMAND_INIT_CUTSCENE = 19;
    public static final int COMMAND_INIT_SOUND = 20;
    public static final int COMMAND_LOAD_RESOURCE_BLOCK = 21;
    public static final int COMMAND_UNLOAD_RESOURCE_BLOCK = 22;
    public static final int COMMAND_LOAD_TASKS = 23;
    public static final int COMMAND_SET_TILESET_PALETTE = 24;
    public static final int COMMAND_MAP_INIT = 25;
    public static final int COMMAND_REVERSE = 0x40000000;
    private static int palette;
    private static int tilesetPalette;
    public static int[] simpleSpritesImages;
    public static int[] simpleSpritesFramesCount;
    public static int[][] simpleSpritesBounds;
    public static int[] simpleSpritesImageDimmensions;
    public static final int[][] MESSAGE_STRUCTURE;

    public static SimpleSprite createSprite(int n, SimpleSprite simpleSprite) {
        int n2 = n - 124;
        SimpleSprite simpleSprite2 = simpleSprite != null ? simpleSprite : new SimpleSprite();
        simpleSprite2.init(n2);
        return simpleSprite2;
    }

    public static void loadSprite(int n) {
        int n2 = n - 124;
        if (simpleSpritesImages[n2] == -1) {
            int[] nArray = NineCanvas.instance.getResourceIntArray(n);
            ResourceManager.simpleSpritesImages[n2] = NineCanvas.instance.loadImageID(nArray[0], -1, 17, false);
            ResourceManager.simpleSpritesFramesCount[n2] = nArray[1];
            ResourceManager.simpleSpritesImageDimmensions[n2 * 2] = NineCanvas.instance.getImageDimension(simpleSpritesImages[n2], 0, 0, 0) / simpleSpritesFramesCount[n2];
            ResourceManager.simpleSpritesImageDimmensions[n2 * 2 + 1] = NineCanvas.instance.getImageDimension(simpleSpritesImages[n2], 0, 0, 1);
            if (nArray.length > 2) {
                ResourceManager.simpleSpritesBounds[n2] = new int[nArray.length - 2];
                for (int i = 0; i < simpleSpritesBounds[n2].length; ++i) {
                    ResourceManager.simpleSpritesBounds[n2][i] = nArray[i + 2];
                }
            }
        }
    }

    public static void unloadSprite(int n) {
        int n2 = n - 124;
        if (simpleSpritesImages[n2] > -1) {
            NineCanvas.instance.unloadImageID(simpleSpritesImages[n2]);
        }
        ResourceManager.simpleSpritesFramesCount[n2] = -1;
        ResourceManager.simpleSpritesBounds[n2] = null;
        ResourceManager.simpleSpritesImages[n2] = -1;
    }

    public static void initLoader() {
        simpleSpritesImages = new int[56];
        simpleSpritesBounds = new int[56][];
        simpleSpritesFramesCount = new int[56];
        simpleSpritesImageDimmensions = new int[112];
        Utils.arrayFill(simpleSpritesImages, -1);
        commandLoadingQueue = new int[256];
        idLoadingQueue = new int[256];
        tileSetsImagesId = new int[18];
        Utils.arrayFill(tileSetsImagesId, -1);
        ResourceManager.resetQueue();
    }

    public static boolean startLoading() {
        if (isProcessing || commandLoadingQueue[0] == -1) {
            return false;
        }
        isProcessing = true;
        loadingQueueItems = loadingQueueIndex;
        loadingQueueIndex = 0;
        loadingProgress = 0;
        return true;
    }

    public static boolean resetQueue() {
        if (isProcessing) {
            return false;
        }
        for (int i = 0; i < commandLoadingQueue.length; ++i) {
            ResourceManager.commandLoadingQueue[i] = -1;
        }
        loadingQueueIndex = 0;
        loadingQueueItems = 0;
        passToNextCommand = false;
        return true;
    }

    public static boolean addToQueue(int n, int n2) {
        if (isProcessing) {
            return false;
        }
        ResourceManager.commandLoadingQueue[ResourceManager.loadingQueueIndex] = n;
        ResourceManager.idLoadingQueue[ResourceManager.loadingQueueIndex] = n2;
        ++loadingQueueIndex;
        return true;
    }

    public static boolean copyToQueue(short[] sArray) {
        return ResourceManager.copyToQueue(sArray, false);
    }

    public static boolean copyToQueue(short[] sArray, boolean bl) {
        if (isProcessing) {
            return false;
        }
        for (int i = 0; i < sArray.length; i += 2) {
            ResourceManager.commandLoadingQueue[ResourceManager.loadingQueueIndex] = bl ? sArray[i] | 0x40000000 : sArray[i];
            ResourceManager.idLoadingQueue[ResourceManager.loadingQueueIndex] = sArray[i + 1];
            ++loadingQueueIndex;
        }
        return true;
    }

    public static int tickLoading() {
        if (isProcessing) {
            if (loadingQueueIndex == loadingQueueItems || passToNextCommand && loadingQueueIndex + 1 == loadingQueueItems) {
                isProcessing = false;
                loadingProgress = 100;
                ResourceManager.resetQueue();
                System.gc();
                return loadingProgress;
            }
            if (passToNextCommand) {
                ++loadingQueueIndex;
                passToNextCommand = false;
            }
            int n = 100 / loadingQueueItems;
            loadingProgress = loadingQueueIndex * 100 / loadingQueueItems + ResourceManager.performOperation() * n / 100;
        } else {
            loadingProgress = 100;
        }
        return loadingProgress;
    }

    private static int performOperation() {
        int n = 0;
        n = (commandLoadingQueue[loadingQueueIndex] & 0x40000000) != 0 ? ResourceManager.performUnload(commandLoadingQueue[loadingQueueIndex] & 0xBFFFFFFF) : ResourceManager.performLoad(commandLoadingQueue[loadingQueueIndex]);
        if (n == 100) {
            passToNextCommand = true;
        }
        return n;
    }

    private static int performLoad(int n) {
        switch (n) {
            case 7: {
                if (idLoadingQueue[loadingQueueIndex] <= -1) break;
                ResourceManager.loadSprite(idLoadingQueue[loadingQueueIndex]);
                break;
            }
            case 11: {
                palette = idLoadingQueue[loadingQueueIndex];
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                int[][][] nArray = Game.LEVEL_TASKS_CONFIGURATION[idLoadingQueue[loadingQueueIndex]];
                GameTaskManager.init(nArray.length);
                GameTaskManager gameTaskManager = GameTaskManager.getInstance();
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; ++i) {
                        int[][] nArray2 = nArray[i];
                        for (int j = 0; j < nArray2.length; ++j) {
                            int[] nArray3 = nArray2[j];
                            GameTask gameTask = new GameTask(nArray3);
                            gameTaskManager.addGameTask(gameTask, i);
                        }
                    }
                }
                gameTaskManager.initializeTasks();
                break;
            }
            case 0: {
                if (map == null) {
                    map = new Map();
                    Game.setGameMap(map, idLoadingQueue[loadingQueueIndex] - 197);
                    map.initLoading(idLoadingQueue[loadingQueueIndex]);
                }
                System.gc();
                return map.tickLoading();
            }
            case 25: {
                break;
            }
            case 1: {
                int n2 = idLoadingQueue[loadingQueueIndex];
                if (tileSetsImagesId[n2 - 211] != -1) break;
                ResourceManager.tileSetsImagesId[n2 - 211] = NineCanvas.instance.loadImageID(n2, tilesetPalette, 1, false);
                tilesetPalette = -1;
                break;
            }
            case 2: {
                if (loadingQueueIndex == -1 || idLoadingQueue[loadingQueueIndex] == -1) break;
                NineCanvas.instance.loadImageID(idLoadingQueue[loadingQueueIndex]);
                break;
            }
            case 4: {
                Menu.menuInit();
                break;
            }
            case 5: {
                NineCanvas.instance.loadSound(idLoadingQueue[loadingQueueIndex], 0, 1);
                break;
            }
            case 17: {
                int n3 = idLoadingQueue[loadingQueueIndex];
                map.setTilesetImageId(ResourceManager.getTileSetImageId(n3));
                break;
            }
            case 24: {
                tilesetPalette = idLoadingQueue[loadingQueueIndex];
                break;
            }
            case 18: {
                Game.init();
                break;
            }
            case 20: {
                NineCanvas.instance.playSound();
                break;
            }
            case 6: {
                ResourceManager.loadRMS();
            }
        }
        System.gc();
        return 100;
    }

    private static int performUnload(int n) {
        switch (n) {
            case 7: {
                if (idLoadingQueue[loadingQueueIndex] <= -1) break;
                ResourceManager.unloadSprite(idLoadingQueue[loadingQueueIndex]);
                break;
            }
            case 0: {
                map.deinit();
                GameObjectManager.deinit();
                Game.setGameMap(null, -1);
                map = null;
                break;
            }
            case 1: {
                int n2 = idLoadingQueue[loadingQueueIndex];
                int n3 = tileSetsImagesId[n2 - 211];
                NineCanvas.instance.unloadImageID(n3);
                ResourceManager.tileSetsImagesId[n2 - 211] = -1;
                break;
            }
            case 23: {
                GameTaskManager.deinit();
                break;
            }
            case 2: {
                if (idLoadingQueue[loadingQueueIndex] == -1) break;
                NineCanvas.instance.unloadImageID(NineCanvas.instance.loadImageID(idLoadingQueue[loadingQueueIndex]));
                break;
            }
            case 5: {
                NineCanvas.instance.unloadSound(idLoadingQueue[loadingQueueIndex]);
            }
        }
        System.gc();
        return 100;
    }

    public static boolean isLoaded() {
        return !isProcessing;
    }

    public static int getLoadingProgress() {
        return loadingProgress;
    }

    public static Map getMap(int n) {
        return map;
    }

    public static int getTileSetImageId(int n) {
        return tileSetsImagesId[n - 211];
    }

    public static boolean loadRMS() {
        block5: for (int i = 0; i < 3; ++i) {
            byte[] byArray = null;
            if (i != 2 || i == 2 && !Menu.clearScores) {
                byArray = NineCanvas.instance.getRecordStoreData(i);
                if (byArray == null) {
                    if (!ResourceManager.initRMS()) {
                        NineCanvas.instance.setCurrentState(12);
                    }
                    return false;
                }
            } else {
                NineCanvas.instance.setRecordStoreData(ResourceManager.setDefaultScores(), 2);
            }
            switch (i) {
                case 0: {
                    NineCanvas.isVibrationActive = byArray[0] == 1;
                    continue block5;
                }
                case 1: {
                    NineCanvas.unlockedLevel = byArray[0];
                    NineCanvas.currentLevel = byArray[1];
                    NineCanvas.isInStoryMode = byArray[2] == 1 && NineCanvas.currentLevel > 1;
                    NineCanvas.storyModePoints = (byArray[3] & 0xFF) << 16 | (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
                    continue block5;
                }
                case 2: {
                    if (!Menu.clearScores) {
                        int n;
                        int n2 = 0;
                        for (n = 0; n < Consts.RMS_HIGHSCORES_NAME_SIZE; ++n) {
                            NineCanvas.highscoreNames[n] = (char)byArray[n];
                            ++n2;
                        }
                        for (n = 0; n < 3; ++n) {
                            NineCanvas.highscorePoints[n] = (byArray[n2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF;
                            n2 += 3;
                        }
                        for (n = 3; n < Consts.RMS_HIGHSCORES_SLOTS; ++n) {
                            NineCanvas.highscorePoints[n] = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
                            n2 += 2;
                        }
                        continue block5;
                    }
                    Menu.clearScores = false;
                }
            }
        }
        return true;
    }

    public static void saveRMS(int n) {
        switch (n) {
            case 0: {
                byte[] byArray = new byte[]{(byte)(NineCanvas.isVibrationActive ? 1 : 0)};
                NineCanvas.instance.setRecordStoreData(byArray, 0);
                break;
            }
            case 1: {
                byte[] byArray = new byte[6];
                byArray[0] = NineCanvas.unlockedLevel;
                byArray[1] = NineCanvas.currentLevel;
                byArray[2] = (byte)(NineCanvas.isInStoryMode ? 1 : 0);
                if (NineCanvas.isInStoryMode) {
                    byArray[3] = (byte)(NineCanvas.storyModePoints >> 16);
                    byArray[4] = (byte)(NineCanvas.storyModePoints >> 8);
                    byArray[5] = (byte)NineCanvas.storyModePoints;
                } else {
                    byArray[3] = 0;
                    byArray[4] = 0;
                    byArray[5] = 0;
                }
                NineCanvas.instance.setRecordStoreData(byArray, 1);
                break;
            }
            case 2: {
                int n2;
                int n3 = 0;
                byte[] byArray = new byte[Consts.RMS_HIGHSCORES_NAME_SIZE + Consts.RMS_HIGHSCORES_POINTS_SIZE];
                for (n2 = 0; n2 < Consts.RMS_HIGHSCORES_NAME_SIZE; ++n2) {
                    byArray[n3] = (byte)NineCanvas.highscoreNames[n2];
                    ++n3;
                }
                for (n2 = 0; n2 < 3; ++n2) {
                    byArray[n3] = (byte)(NineCanvas.highscorePoints[n2] >> 16);
                    byArray[n3 + 1] = (byte)(NineCanvas.highscorePoints[n2] >> 8);
                    byArray[n3 + 2] = (byte)NineCanvas.highscorePoints[n2];
                    n3 += 3;
                }
                for (n2 = 3; n2 < NineCanvas.highscorePoints.length; ++n2) {
                    byArray[n3] = (byte)(NineCanvas.highscorePoints[n2] >> 8);
                    byArray[n3 + 1] = (byte)NineCanvas.highscorePoints[n2];
                    n3 += 2;
                }
                if (Menu.clearScores) {
                    NineCanvas.instance.setRecordStoreData(ResourceManager.setDefaultScores(), 2);
                    Menu.clearScores = false;
                    break;
                }
                NineCanvas.instance.setRecordStoreData(byArray, 2);
            }
        }
    }

    private static boolean initRMS() {
        NineCanvas.isVibrationActive = false;
        NineCanvas.unlockedLevel = (byte)14;
        NineCanvas.currentLevel = 1;
        NineCanvas.storyModePoints = 0;
        NineCanvas.isInStoryMode = false;
        byte[] byArray = new byte[]{0};
        boolean bl = NineCanvas.instance.setRecordStoreData(byArray, 0);
        byArray = new byte[]{NineCanvas.unlockedLevel, NineCanvas.currentLevel, 0, 0, 0, 0};
        bl &= NineCanvas.instance.setRecordStoreData(byArray, 1);
        byArray = ResourceManager.setDefaultScores();
        return bl &= NineCanvas.instance.setRecordStoreData(byArray, 2);
    }

    private static byte[] setDefaultScores() {
        int n;
        int n2;
        byte[] byArray = new byte[Consts.RMS_HIGHSCORES_NAME_SIZE + Consts.RMS_HIGHSCORES_POINTS_SIZE];
        int n3 = 0;
        char[] cArray = NineCanvas.instance.getResourceCharArray(296);
        for (n2 = 0; n2 < Consts.RMS_HIGHSCORES_NAME_SIZE; ++n2) {
            NineCanvas.highscoreNames[n2] = cArray[n2];
        }
        for (n2 = 0; n2 < Consts.RMS_HIGHSCORES_NAME_SIZE; ++n2) {
            byArray[n3] = (byte)NineCanvas.highscoreNames[n2];
            ++n3;
        }
        int[] nArray = NineCanvas.instance.getResourceIntArray(297);
        for (n = 0; n < Consts.RMS_HIGHSCORES_SLOTS; ++n) {
            NineCanvas.highscorePoints[n] = nArray[n];
        }
        n3 = Consts.RMS_HIGHSCORES_NAME_SIZE;
        for (n = 0; n < 3; ++n) {
            byArray[n3] = (byte)(nArray[n] >> 16);
            byArray[n3 + 1] = (byte)(nArray[n] >> 8);
            byArray[n3 + 2] = (byte)nArray[n];
            n3 += 3;
        }
        for (n = 3; n < NineCanvas.highscorePoints.length; ++n) {
            byArray[n3] = (byte)(nArray[n] >> 8);
            byArray[n3 + 1] = (byte)nArray[n];
            n3 += 2;
        }
        return byArray;
    }

    public static short[] getResourcesDefinition(int n) {
        return ResourceManager.getResourcesDefinition(n, -1);
    }

    public static short[] getResourcesDefinition(int n, int n2) {
        NineCanvas.instance.loadResourceBlock(11);
        short[] sArray = null;
        switch (n) {
            case 5: {
                sArray = NineCanvas.instance.getResourceShortArray(280);
                break;
            }
            case 6: {
                sArray = n2 == -1 ? NineCanvas.instance.getResourceShortArray(281) : NineCanvas.instance.getResourceShortArray(282 + n2);
            }
        }
        NineCanvas.instance.unloadResourceBlock(11);
        return sArray;
    }

    static {
        palette = -1;
        tilesetPalette = -1;
        MESSAGE_STRUCTURE = new int[][]{{-1, 72}, {-1, 69}, {-1, 74}, {-1, 265}};
    }
}

