/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public final class GameObjectManager {
    public static final int MAX_CREATED_OBJECTS = 200;
    public static final int MAX_ACTIVE_OBJECTS = 200;
    public static final int MAX_VISIBLE_OBJECTS = 100;
    private static int ACTIVATION_AREA_MARGIN_TOP_FP;
    private static int ACTIVATION_AREA_MARGIN_BOTTOM_FP;
    private static int ACTIVATION_AREA_MARGIN_LEFT_FP;
    private static int ACTIVATION_AREA_MARGIN_RIGHT_FP;
    private static int TILE_COLLISION_FRICTION_FP;
    private static int TILE_COLLISION_BOUNCE_FP;
    private static GameObject[] gameObjects;
    private static int newId;
    private static int[] freeObjectsIDs;
    private static int numFreeObjectsIDs;
    private static SimpleStack[] reusableGameObjectsStacks;
    private static GameObject[] activeGameObjects;
    private static int activeGameObjectsCount;
    private static GameObject[] visibleGameObjects;
    private static int visibleGameObjectsCount;
    private static Vehicle gameHero;
    private static Vehicle gameTarget;
    public static int[] auxilaryPoint;
    public static int[] auxilaryRect;
    private static final int NUM_VEHICLE_POINTS_TO_CHECK = 5;
    private static final int VEHICLE_POINT_TO_CHECK_SIZE = 3;
    public static int[] auxiliaryVehiclePointsToCheck;
    public static boolean debugDrawObjectAllocation;
    public static int debugObjectsAllocated;
    public static final int DEBUG_CELLS_COUNT = 9;
    public static final int DEBUG_CELL_LEFT_TOP = 0;
    public static final int DEBUG_CELL_TOP = 1;
    public static final int DEBUG_CELL_RIGHT_TOP = 2;
    public static final int DEBUG_CELL_LEFT = 3;
    public static final int DEBUG_CELL_CENTER = 4;
    public static final int DEBUG_CELL_RIGHT = 5;
    public static final int DEBUG_CELL_LEFT_BOTTOM = 6;
    public static final int DEBUG_CELL_BOTTOM = 7;
    public static final int DEBUG_CELL_RIGHT_BOTTOM = 8;
    public static int[] debugActiveObjectsCount;
    public static int[] debugVisibleObjectsCount;
    static final int REACTION_MOVE_RIGHT = 1;
    static final int REACTION_MOVE_LEFT = 2;
    static final int REACTION_MOVE_BACKWARD = 3;
    static final int REACTION_MOVE_FORWARD = 4;
    static final int REACTION_STOP = 5;

    public static void initFields() {
        TILE_COLLISION_FRICTION_FP = Utils.createFractionFP(95, 100);
        TILE_COLLISION_BOUNCE_FP = Utils.createFractionFP(1, 3);
        activeGameObjects = new GameObject[200];
        visibleGameObjects = new GameObject[100];
        auxilaryPoint = new int[2];
        auxilaryRect = new int[4];
        auxiliaryVehiclePointsToCheck = new int[15];
    }

    public static void init(int n) {
        ACTIVATION_AREA_MARGIN_TOP_FP = BRCanvasMaths.Fmul(Utils.createFractionFP(Consts.MAP_ACTIVATION_AREA_MARGIN_TOP_PERCENT, 100), ResourceManager.map.getViewportHeightFP());
        ACTIVATION_AREA_MARGIN_BOTTOM_FP = BRCanvasMaths.Fmul(Utils.createFractionFP(Consts.MAP_ACTIVATION_AREA_MARGIN_BOTTOM_PERCENT, 100), ResourceManager.map.getViewportHeightFP());
        ACTIVATION_AREA_MARGIN_LEFT_FP = BRCanvasMaths.Fmul(Utils.createFractionFP(Consts.MAP_ACTIVATION_AREA_MARGIN_LEFT_PERCENT, 100), ResourceManager.map.getViewportWidthFP());
        ACTIVATION_AREA_MARGIN_RIGHT_FP = BRCanvasMaths.Fmul(Utils.createFractionFP(Consts.MAP_ACTIVATION_AREA_MARGIN_RIGHT_PERCENT, 100), ResourceManager.map.getViewportWidthFP());
        gameHero = null;
        newId = 0;
        numFreeObjectsIDs = 0;
        gameObjects = new GameObject[n + 200];
        freeObjectsIDs = new int[n + 200];
        activeGameObjects = new GameObject[200];
        visibleGameObjects = new GameObject[100];
        reusableGameObjectsStacks = new SimpleStack[9];
        for (int i = 0; i < 9; ++i) {
            GameObjectManager.reusableGameObjectsStacks[i] = new SimpleStack();
        }
    }

    public static void deinit() {
        activeGameObjects = null;
        gameObjects = null;
        visibleGameObjects = null;
        freeObjectsIDs = null;
        visibleGameObjectsCount = 0;
        activeGameObjectsCount = 0;
        numFreeObjectsIDs = 0;
        newId = 0;
        gameHero = null;
        freeObjectsIDs = null;
        reusableGameObjectsStacks = null;
    }

    public static void update(int n) {
        int n2;
        GameObject gameObject;
        GameObjectManager.auxilaryRect[0] = ResourceManager.map.getCameraXFP() - ACTIVATION_AREA_MARGIN_LEFT_FP;
        GameObjectManager.auxilaryRect[1] = ResourceManager.map.getCameraYFP() - ACTIVATION_AREA_MARGIN_TOP_FP;
        GameObjectManager.auxilaryRect[2] = ResourceManager.map.getViewportWidthFP() + ACTIVATION_AREA_MARGIN_LEFT_FP + ACTIVATION_AREA_MARGIN_RIGHT_FP;
        GameObjectManager.auxilaryRect[3] = ResourceManager.map.getViewportHeightFP() + ACTIVATION_AREA_MARGIN_TOP_FP + ACTIVATION_AREA_MARGIN_BOTTOM_FP;
        activeGameObjectsCount = 0;
        int n3 = gameObjects.length;
        while (--n3 >= 0) {
            gameObject = gameObjects[n3];
            if (gameObject == null) continue;
            if (gameObject.canBeRemoved) {
                GameObjectManager.removeGameObject(gameObject.uId);
                continue;
            }
            int n4 = gameObject.positionFP[0] + gameObject.boundsFP[0];
            int n5 = gameObject.positionFP[1] + gameObject.boundsFP[1];
            if (n4 < auxilaryRect[0] + auxilaryRect[2] && n5 < auxilaryRect[1] + auxilaryRect[3] && n4 + gameObject.boundsFP[2] > auxilaryRect[0] && n5 + gameObject.boundsFP[3] > auxilaryRect[1]) {
                if (!gameObject.active) {
                    gameObject.activate();
                }
                GameObjectManager.activeGameObjects[GameObjectManager.activeGameObjectsCount++] = gameObject;
                continue;
            }
            if (gameObject.active) {
                gameObject.deactivate();
            }
            if (gameObject.isMarkedForRemoval() || gameObject.role == 7 || gameObject.positionFP[1] + gameObject.collisionBoxFP[1] <= auxilaryRect[1] + auxilaryRect[3]) continue;
            gameObject.markForRemoval();
        }
        n3 = activeGameObjectsCount;
        while (--n3 >= 0) {
            gameObject = activeGameObjects[n3];
            gameObject.update(n);
        }
        n3 = 0;
        for (n2 = 0; n2 < activeGameObjectsCount; ++n2) {
            GameObject gameObject2 = activeGameObjects[n2];
            if (gameObject2.excludeFromCollisionCheckHint || Game.MAP_OBJECTS_COLLISION_WITH_TILESET_CONFIGURATION[gameObject2.role] != 1) continue;
            if (gameObject2.role == 7) {
                GameObjectManager.checkSensorTileCollision(gameObject2);
                continue;
            }
            GameObjectManager.checkTileCollision(gameObject2);
            GameObjectManager.checkMapCollision(gameObject2);
            if (!gameObject2.isVehicle() || !((Vehicle)gameObject2).collidedWithTile) continue;
            GameObject gameObject3 = activeGameObjects[n3];
            GameObjectManager.activeGameObjects[n3] = gameObject2;
            GameObjectManager.activeGameObjects[n2] = gameObject3;
            ++n3;
        }
        for (n2 = 0; n2 < activeGameObjectsCount; ++n2) {
            GameObject gameObject4 = activeGameObjects[n2];
            if (gameObject4.excludeFromCollisionCheckHint) continue;
            int n6 = gameObject4.getRole();
            for (int i = n2 + 1; i < activeGameObjectsCount; ++i) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                Vehicle vehicle;
                GameObject gameObject5;
                int n18;
                GameObject gameObject6 = activeGameObjects[i];
                if (gameObject6.excludeFromCollisionCheckHint || Game.MAP_OBJECTS_COLLISION_CONFIGURATION[n6][n18 = gameObject6.getRole()] != 1 || !Utils.rectsCollide(gameObject4.getLeftFP(), gameObject4.getTopFP(), gameObject4.getWidthFP(), gameObject4.getHeightFP(), gameObject6.getLeftFP(), gameObject6.getTopFP(), gameObject6.getWidthFP(), gameObject6.getHeightFP()) || !GameObjectManager.shouldHandleCollision(gameObject4, gameObject6)) continue;
                if (gameObject4.isVehicle() && gameObject6.isVehicle()) {
                    int n19;
                    int n20;
                    gameObject5 = (Vehicle)gameObject4;
                    vehicle = (Vehicle)gameObject6;
                    if (vehicle.collidedWithTile) {
                        gameObject5 = (Vehicle)gameObject6;
                        vehicle = (Vehicle)gameObject4;
                    }
                    if (((Vehicle)gameObject5).isInAir() || vehicle.isInAir()) continue;
                    int n21 = (vehicle.getWidthFP() + gameObject5.getWidthFP()) / 2;
                    int n22 = Math.abs(gameObject5.getCenterXFP() - vehicle.getCenterXFP());
                    n17 = n21 - n22;
                    n16 = (vehicle.getHeightFP() + gameObject5.getHeightFP()) / 2;
                    n15 = Math.abs(gameObject5.getCenterYFP() - vehicle.getCenterYFP());
                    n14 = n16 - n15;
                    Vehicle vehicle2 = (Vehicle)gameObject4;
                    Vehicle vehicle3 = (Vehicle)gameObject6;
                    if (n17 < n14) {
                        n20 = vehicle2.velocityFP[0];
                        n13 = vehicle3.velocityFP[0];
                        if (vehicle.isOnTheRightTo(gameObject5)) {
                            vehicle.setCenterXFP(vehicle.getCenterXFP() + n17);
                            gameObject4.notifyAfterCollision(gameObject6);
                            gameObject6.notifyAfterCollision(gameObject4);
                        } else {
                            vehicle.setCenterXFP(vehicle.getCenterXFP() - n17);
                            gameObject4.notifyAfterCollision(gameObject6);
                            gameObject6.notifyAfterCollision(gameObject4);
                        }
                        n12 = vehicle2.collidedWithTile ? 768000000 : vehicle2.getMassFP();
                        n11 = vehicle3.collidedWithTile ? 768000000 : vehicle3.getMassFP();
                        n10 = n20;
                        n9 = n13;
                        n8 = vehicle2.getState() == 6 || vehicle3.getState() == 6 ? 0 : 512;
                        n7 = BRCanvasMaths.Fmul(n8 + 1024, BRCanvasMaths.Fmul(n11, n9));
                        n7 += BRCanvasMaths.Fmul(n10, n12 - BRCanvasMaths.Fmul(n8, n11));
                        n7 = BRCanvasMaths.Fdiv(n7, n12 + n11);
                        n19 = BRCanvasMaths.Fmul(n8 + 1024, BRCanvasMaths.Fmul(n12, n10));
                        n19 += BRCanvasMaths.Fmul(n9, n11 - BRCanvasMaths.Fmul(n8, n12));
                        n19 = BRCanvasMaths.Fdiv(n19, n12 + n11);
                        vehicle2.velocityFP[0] = n7;
                        vehicle3.velocityFP[0] = n19;
                        continue;
                    }
                    n20 = vehicle2.velocityFP[1];
                    n13 = vehicle3.velocityFP[1];
                    if (vehicle.isAtTheBottomTo(gameObject5)) {
                        vehicle.setCenterYFP(vehicle.getCenterYFP() + n14);
                        gameObject4.notifyAfterCollision(gameObject6);
                        gameObject6.notifyAfterCollision(gameObject4);
                    } else {
                        vehicle.setCenterYFP(vehicle.getCenterYFP() - n14);
                        gameObject4.notifyAfterCollision(gameObject6);
                        gameObject6.notifyAfterCollision(gameObject4);
                    }
                    n12 = vehicle2.collidedWithTile ? 768000000 : vehicle2.getMassFP();
                    n11 = vehicle3.collidedWithTile ? 768000000 : vehicle3.getMassFP();
                    n10 = n20;
                    n9 = n13;
                    n8 = vehicle2.getState() == 6 || vehicle3.getState() == 6 ? 0 : 512;
                    n7 = BRCanvasMaths.Fmul(n8 + 1024, BRCanvasMaths.Fmul(n11, n9));
                    n7 += BRCanvasMaths.Fmul(n10, n12 - BRCanvasMaths.Fmul(n8, n11));
                    n7 = BRCanvasMaths.Fdiv(n7, n12 + n11);
                    n19 = BRCanvasMaths.Fmul(n8 + 1024, BRCanvasMaths.Fmul(n12, n10));
                    n19 += BRCanvasMaths.Fmul(n9, n11 - BRCanvasMaths.Fmul(n8, n12));
                    n19 = BRCanvasMaths.Fdiv(n19, n12 + n11);
                    vehicle2.velocityFP[1] = n7;
                    vehicle3.velocityFP[1] = n19;
                    continue;
                }
                if (gameObject4.isVehicle() && gameObject6.getRole() == 19 || gameObject6.isVehicle() && gameObject4.getRole() == 19) {
                    if (gameObject4.getRole() == 19) {
                        gameObject5 = gameObject4;
                        vehicle = (Vehicle)gameObject6;
                    } else {
                        gameObject5 = gameObject6;
                        vehicle = (Vehicle)gameObject4;
                    }
                    if (vehicle.isInAir()) continue;
                    GameObject gameObject7 = gameObject5;
                    Vehicle vehicle4 = vehicle;
                    n17 = (vehicle4.getWidthFP() + gameObject7.getWidthFP()) / 2;
                    n16 = Math.abs(gameObject7.getCenterXFP() - vehicle4.getCenterXFP());
                    n15 = n17 - n16;
                    n14 = (vehicle4.getHeightFP() + gameObject7.getHeightFP()) / 2;
                    int n23 = Math.abs(gameObject7.getCenterYFP() - vehicle4.getCenterYFP());
                    int n24 = n14 - n23;
                    Vehicle vehicle5 = vehicle;
                    if (n15 < n24) {
                        n13 = vehicle5.velocityFP[0];
                        if (vehicle4.isOnTheRightTo(gameObject7)) {
                            vehicle4.setCenterXFP(vehicle4.getCenterXFP() + n15);
                            gameObject4.notifyAfterCollision(gameObject6);
                            gameObject6.notifyAfterCollision(gameObject4);
                        } else {
                            vehicle4.setCenterXFP(vehicle4.getCenterXFP() - n15);
                            gameObject4.notifyAfterCollision(gameObject6);
                            gameObject6.notifyAfterCollision(gameObject4);
                        }
                        n12 = 1024000000;
                        n11 = vehicle5.getMassFP();
                        n10 = 0;
                        n9 = n13;
                        n8 = 1024;
                        n7 = BRCanvasMaths.Fmul(n8 + 1024, BRCanvasMaths.Fmul(n12, n10));
                        n7 += BRCanvasMaths.Fmul(n9, n11 - BRCanvasMaths.Fmul(n8, n12));
                        vehicle5.velocityFP[0] = n7 = BRCanvasMaths.Fdiv(n7, n12 + n11);
                        continue;
                    }
                    n13 = vehicle5.velocityFP[1];
                    if (vehicle4.isAtTheBottomTo(gameObject7)) {
                        vehicle4.setCenterYFP(vehicle4.getCenterYFP() + n24);
                        gameObject4.notifyAfterCollision(gameObject6);
                        gameObject6.notifyAfterCollision(gameObject4);
                    } else {
                        vehicle4.setCenterYFP(vehicle4.getCenterYFP() - n24);
                        gameObject4.notifyAfterCollision(gameObject6);
                        gameObject6.notifyAfterCollision(gameObject4);
                    }
                    n12 = 1024000000;
                    n11 = vehicle5.getMassFP();
                    n10 = 0;
                    n9 = n13;
                    n8 = 1024;
                    n7 = BRCanvasMaths.Fmul(n8 + 1024, BRCanvasMaths.Fmul(n12, n10));
                    n7 += BRCanvasMaths.Fmul(n9, n11 - BRCanvasMaths.Fmul(n8, n12));
                    vehicle5.velocityFP[1] = n7 = BRCanvasMaths.Fdiv(n7, n12 + n11);
                    continue;
                }
                gameObject4.notifyAfterCollision(gameObject6);
                gameObject6.notifyAfterCollision(gameObject4);
            }
        }
        visibleGameObjectsCount = 0;
        n2 = activeGameObjectsCount;
        while (--n2 >= 0) {
            GameObject gameObject8 = activeGameObjects[n2];
            if (gameObject8.excludeFromVisibilityCheckHint || !Utils.rectsCollide(gameObject8.getBoundsLeftFP(), gameObject8.getBoundsTopFP(), gameObject8.getBoundsWidthFP(), gameObject8.getBoundsHeightFP(), ResourceManager.map.getCameraXFP(), ResourceManager.map.getCameraYFP(), ResourceManager.map.getViewportWidthFP(), ResourceManager.map.getViewportHeightFP())) continue;
            gameObject8.updateDrawPosition(ResourceManager.map.getViewportX(), ResourceManager.map.getViewportY());
            GameObjectManager.visibleGameObjects[GameObjectManager.visibleGameObjectsCount++] = gameObject8;
        }
        GameObjectManager.sortObjects(visibleGameObjects, 0, visibleGameObjectsCount - 1);
    }

    private static void sortObjects(GameObject[] gameObjectArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        GameObject gameObject = gameObjectArray[(n + n2) / 2];
        while (true) {
            if (GameObjectManager.gameObjectLessThan(gameObjectArray[n3], gameObject)) {
                ++n3;
                continue;
            }
            while (GameObjectManager.gameObjectGreaterThan(gameObjectArray[n4], gameObject)) {
                --n4;
            }
            if (n3 <= n4) {
                GameObject gameObject2 = gameObjectArray[n3];
                gameObjectArray[n3] = gameObjectArray[n4];
                gameObjectArray[n4] = gameObject2;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            GameObjectManager.sortObjects(gameObjectArray, n, n4);
        }
        if (n3 < n2) {
            GameObjectManager.sortObjects(gameObjectArray, n3, n2);
        }
    }

    private static boolean gameObjectGreaterThan(GameObject gameObject, GameObject gameObject2) {
        return gameObject.drawingLayer > gameObject2.drawingLayer || gameObject.drawingLayer == gameObject2.drawingLayer && gameObject.getBoundsTopFP() > gameObject2.getBoundsTopFP();
    }

    private static boolean gameObjectLessThan(GameObject gameObject, GameObject gameObject2) {
        return gameObject.drawingLayer < gameObject2.drawingLayer || gameObject.drawingLayer == gameObject2.drawingLayer && gameObject.getBoundsTopFP() < gameObject2.getBoundsTopFP();
    }

    private static boolean shouldHandleCollision(GameObject gameObject, GameObject gameObject2) {
        boolean bl = true;
        int n = gameObject.getRole();
        int n2 = gameObject2.getRole();
        if (n == 1 || n == 14 || n2 == 1 || n2 == 14) {
            GameObject gameObject3;
            Bullet bullet;
            if (n == 1 || n == 14) {
                bullet = (Bullet)gameObject;
                gameObject3 = gameObject2;
            } else {
                bullet = (Bullet)gameObject2;
                gameObject3 = gameObject;
            }
            int n3 = bullet.getOwnerRole();
            boolean bl2 = n3 == 2;
            boolean bl3 = gameObject3.getRole() == 2;
            boolean bl4 = true;
            boolean bl5 = true;
            if (n3 == 2 || n3 == 3 || n3 == 4 || n3 == 9) {
                boolean bl6 = bl4 = bullet.getOwnerVehicleType() != 2;
            }
            if (gameObject3.isVehicle()) {
                Vehicle vehicle = (Vehicle)gameObject3;
                bl5 = vehicle.vehicleType != 2;
            }
            int n4 = -1;
            if (bl2 && !bl3) {
                n4 = 0;
            } else if (!bl2 && bl3) {
                n4 = 1;
            } else if (!bl2 && !bl3) {
                n4 = 2;
            }
            int n5 = -1;
            if (bl4 && bl5) {
                n5 = 0;
            } else if (bl4 && !bl5) {
                n5 = 1;
            } else if (!bl4 && !bl5) {
                n5 = 2;
            } else if (!bl4 && bl5) {
                n5 = 3;
            }
            if (n4 != -1 && n5 != -1) {
                int n6 = n4 * 40 + bullet.getWeapon() * 4 + n5;
                bl = Game.BULLETS_VEHICLE_COLLISION_CONFIGURATION[n6] == 1;
            }
        } else if (gameObject.isVehicle() && gameObject2.isVehicle()) {
            Vehicle vehicle = (Vehicle)gameObject;
            Vehicle vehicle2 = (Vehicle)gameObject2;
            bl = vehicle.vehicleType != 2 && vehicle2.vehicleType != 2 ? true : vehicle.vehicleType == 2 && vehicle2.vehicleType == 2;
        } else if (gameObject.isVehicle() && n2 == 10) {
            Vehicle vehicle = (Vehicle)gameObject;
            if (vehicle.vehicleType == 2) {
                bl = false;
            }
        } else if (n == 10 && gameObject2.isVehicle()) {
            Vehicle vehicle = (Vehicle)gameObject2;
            if (vehicle.vehicleType == 2) {
                bl = false;
            }
        } else if (gameObject.isVehicle() && n2 == 15) {
            bl = ((Vehicle)gameObject).vehicleType != 2;
        } else if (gameObject2.isVehicle() && n == 15) {
            bl = ((Vehicle)gameObject2).vehicleType != 2;
        } else if (gameObject.isVehicle() && n2 == 7 && ((Sensor)gameObject2).type != 1) {
            Vehicle vehicle = (Vehicle)gameObject;
            Sensor sensor = (Sensor)gameObject2;
            if (vehicle.vehicleType != 2 && sensor.owner.vehicleType == 2) {
                bl = false;
            } else if (vehicle.vehicleType == 2 && sensor.owner.vehicleType != 2) {
                bl = false;
            }
        } else if (n == 7 && gameObject2.isVehicle() && ((Sensor)gameObject).type != 1) {
            Vehicle vehicle = (Vehicle)gameObject2;
            Sensor sensor = (Sensor)gameObject;
            if (vehicle.vehicleType != 2 && sensor.owner.vehicleType == 2) {
                bl = false;
            } else if (vehicle.vehicleType == 2 && sensor.owner.vehicleType != 2) {
                bl = false;
            }
        }
        return bl;
    }

    public static void render(Graphics graphics) {
        for (int i = 0; i < visibleGameObjectsCount; ++i) {
            visibleGameObjects[i].render(graphics, ResourceManager.map.getViewportX(), ResourceManager.map.getViewportY(), ResourceManager.map.getViewportWidth(), ResourceManager.map.getViewportHeight());
        }
    }

    private static void debugDrawGameObjectStats(Graphics graphics, String string, int[] nArray, int n) {
        int n2 = graphics.getFont().getHeight();
        int n3 = graphics.getFont().charWidth('0') * 2;
        int n4 = graphics.getFont().getBaselinePosition();
        int n5 = n2 * 4;
        int n6 = n3 * 3;
        int n7 = 0;
        if ((n & 1) != 0) {
            n7 += (NineCanvas.SCREEN_WIDTH - n6) / 2;
        } else if ((n & 8) != 0) {
            n7 += NineCanvas.SCREEN_WIDTH - n6;
        }
        int n8 = 0;
        if ((n & 2) != 0) {
            n8 += (NineCanvas.SCREEN_HEIGHT - n5) / 2;
        } else if ((n & 0x20) != 0) {
            n8 += NineCanvas.SCREEN_HEIGHT - n5;
        }
        graphics.setColor(0);
        graphics.fillRect(n7, n8, n6, n5);
        graphics.setColor(43520);
        graphics.fillRect(n7 + n3, n8 + 2 * n2, n3, n2);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(string, n7 + n6 / 2, n8 + n4, 65);
        n8 += n2;
        for (int i = 0; i < nArray.length; ++i) {
            int n9 = Utils.clamp(nArray[i], 0, 255);
            int n10 = n7 + i % 3 * n3 + n3 / 2;
            int n11 = n8 + i / 3 * n2 + n4;
            graphics.setColor(0xFFFFFF);
            graphics.drawString("" + n9, n10, n11, 65);
        }
    }

    public static GameObject[] getVisibleGameObjects() {
        return visibleGameObjects;
    }

    public static void checkMapCollision(GameObject gameObject) {
        if (!gameObject.isVehicle()) {
            return;
        }
        Vehicle vehicle = (Vehicle)gameObject;
        int[] nArray = gameObject.getCollisionBoxFP();
        int n = vehicle.getPositionXFP() + nArray[0];
        int n2 = n + nArray[2];
        if (n < ResourceManager.map.getConstraintLeftFP()) {
            vehicle.setPositionXFP(vehicle.getPositionXFP() + (ResourceManager.map.getConstraintLeftFP() - n));
            vehicle.driveStraightImmediate();
        } else if (n2 > ResourceManager.map.getConstraintRightFP()) {
            vehicle.setPositionXFP(vehicle.getPositionXFP() - (n2 - ResourceManager.map.getConstraintRightFP()));
            vehicle.driveStraightImmediate();
        }
    }

    public static void checkSensorTileCollision(GameObject gameObject) {
        int n = Math.max(gameObject.getLeftFP(), ResourceManager.map.getConstraintLeftFP());
        int n2 = Math.min(gameObject.getRightFP(), ResourceManager.map.getConstraintRightFP());
        int n3 = Math.max(gameObject.getTopFP(), ResourceManager.map.getConstraintTopFP());
        int n4 = Math.min(gameObject.getBottomFP(), ResourceManager.map.getConstraintBottomFP());
        int n5 = BRCanvasMaths.FToi(n);
        int n6 = BRCanvasMaths.FToi(n2);
        int n7 = BRCanvasMaths.FToi(n3);
        int n8 = BRCanvasMaths.FToi(n4);
        for (int i = n7; i <= n8; ++i) {
            for (int j = n5; j <= n6; ++j) {
                int n9 = ResourceManager.map.getTileParameter(j, i);
                if (n9 == 0) continue;
                gameObject.notifyAfterCollisionWithTile(j, i, n9);
            }
        }
    }

    private static boolean checkPoint(Vehicle vehicle, int n, int n2, int n3) {
        int n4;
        int n5 = Utils.floori(Map.mapTilesFPToPixels(n), 14);
        int n6 = ResourceManager.map.getTileParameter(n5, n4 = Utils.floori(Map.mapTilesFPToPixels(n2), 14));
        if (n6 == 0) {
            return false;
        }
        int n7 = BRCanvasMaths.iToF(BRCanvasMaths.FToi(n));
        int n8 = BRCanvasMaths.iToF(BRCanvasMaths.FToi(n2 - 1024));
        int n9 = 1024;
        int n10 = 1024;
        int n11 = n;
        int n12 = n2;
        boolean bl = true;
        switch (n6) {
            case 2: {
                n12 = n8 + n10 + 1;
                break;
            }
            case 8: {
                if (n3 == 2) {
                    bl = false;
                    break;
                }
                n11 = n7 + n9 + 1;
                break;
            }
            case 4: {
                if (n3 == 1) {
                    bl = false;
                    break;
                }
                n11 = n7 - 1;
                break;
            }
            case 3: {
                int n13;
                int n14;
                int n15 = 0;
                if (n3 == 1) {
                    bl = false;
                    break;
                }
                if (n3 == 3) {
                    n15 = -vehicle.getWidthFP() / 2 + 1;
                }
                if ((n14 = n + (n13 = n8 - n7) - n2) > 0) {
                    n11 = n - (n - (n2 - n13)) / 2 + n15;
                    n12 = n11 + n13;
                    vehicle.velocityFP[0] = vehicle.velocityMaxFP[0] * 2 / 3;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                int n16;
                int n17;
                int n18 = 0;
                if (n3 == 2) {
                    bl = false;
                    break;
                }
                if (n3 == 3) {
                    n18 = vehicle.getWidthFP() / 2 + 1;
                }
                if ((n17 = -n + (n16 = n8 + n7 + n9) - n2) > 0) {
                    n11 = n + (n16 - n2 - n) / 2 + n18;
                    n12 = -n11 + n16;
                    vehicle.velocityFP[0] = vehicle.velocityMinFP[0] * 2 / 3;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                if (n3 == 3) {
                    n12 = n8 + n10 + 1;
                    n11 = n < n7 + n9 / 2 ? n7 - 1 : n7 + n9 + 1;
                    break;
                }
                if (n3 == 2) {
                    n11 = n7 - 1;
                    vehicle.velocityFP[0] = vehicle.velocityMaxFP[0] * 2 / 3;
                    break;
                }
                if (n3 != 1) break;
                n11 = n7 + n9 + 1;
                vehicle.velocityFP[0] = vehicle.velocityMinFP[0] * 2 / 3;
            }
        }
        if (bl) {
            vehicle.setPositionXFP(vehicle.getPositionXFP() + (n11 - n));
            vehicle.setPositionYFP(vehicle.getPositionYFP() + (n12 - n2));
            vehicle.velocityFP[0] = -BRCanvasMaths.Fmul(TILE_COLLISION_BOUNCE_FP, vehicle.velocityFP[0]);
            vehicle.velocityFP[1] = BRCanvasMaths.Fmul(TILE_COLLISION_FRICTION_FP, vehicle.velocityFP[1]);
            if (n3 == 3) {
                vehicle.stopImmediate();
            }
            vehicle.notifyAfterCollisionWithTile(n5, n4, n6);
        }
        return bl;
    }

    public static void checkTileCollision(GameObject gameObject) {
        if (gameObject.isVehicle()) {
            Vehicle vehicle = (Vehicle)gameObject;
            if (vehicle.isInAir() || vehicle.vehicleType == 2) {
                return;
            }
            GameObjectManager.createVehiclePointsToCheckArray(vehicle);
            for (int i = 0; i < 5; ++i) {
                int n = auxiliaryVehiclePointsToCheck[i * 3 + 0];
                int n2 = auxiliaryVehiclePointsToCheck[i * 3 + 1];
                int n3 = auxiliaryVehiclePointsToCheck[i * 3 + 2];
                boolean bl = GameObjectManager.checkPoint(vehicle, n, n2, n3);
                if (!bl) continue;
                if (n3 != 3) break;
                GameObjectManager.createVehiclePointsToCheckArray(vehicle);
            }
        }
    }

    private static void createVehiclePointsToCheckArray(Vehicle vehicle) {
        int n = 0;
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getCenterXFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getTopFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = 3;
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getLeftFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getTopFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = 1;
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getRightFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getTopFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = 2;
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getLeftFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getCenterYFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = 1;
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getRightFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = vehicle.getCenterYFP();
        GameObjectManager.auxiliaryVehiclePointsToCheck[n++] = 2;
    }

    public static int addGameObject(GameObject gameObject) {
        int n = -1;
        if (gameObject == null) {
            return n;
        }
        if (numFreeObjectsIDs > 0) {
            n = freeObjectsIDs[numFreeObjectsIDs - 1];
            --numFreeObjectsIDs;
        } else if (newId + 1 < gameObjects.length) {
            n = newId++;
        } else {
            return -1;
        }
        gameObject.setuId(n);
        GameObjectManager.gameObjects[n] = gameObject;
        gameObject.wasAddedToGameWorld();
        return n;
    }

    public static void removeGameObject(int n) {
        if (n == -1) {
            return;
        }
        GameObject gameObject = gameObjects[n];
        GameObjectManager.gameObjects[n] = null;
        GameObjectManager.freeObjectsIDs[GameObjectManager.numFreeObjectsIDs++] = n;
        if (gameObject.reusableType != -1) {
            GameObjectManager.pushReusableGameObject(gameObject.reusableType, gameObject);
        }
        gameObject.wasRemovedFromGameWorld();
    }

    public static void removeGameObject(GameObject gameObject) {
        GameObjectManager.removeGameObject(gameObject.getuId());
    }

    public static GameObject popReusableGameObject(int n) {
        if (reusableGameObjectsStacks[n].empty()) {
            return null;
        }
        return (GameObject)reusableGameObjectsStacks[n].pop();
    }

    public static void pushReusableGameObject(int n, GameObject gameObject) {
        reusableGameObjectsStacks[n].push(gameObject);
    }

    public static GameObject getGameObject(int n) {
        return gameObjects[n];
    }

    public static Vehicle getGameHero() {
        return gameHero;
    }

    public static void setGameHero(Vehicle vehicle) {
        gameHero = vehicle;
        GameObjectManager.setGameTarget(vehicle);
    }

    public static void setGameTarget(Vehicle vehicle) {
        gameTarget = vehicle;
    }

    public static Vehicle getGameTarget() {
        return gameTarget;
    }

    static {
        numFreeObjectsIDs = 0;
    }
}

