/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Bullet
extends GameObject {
    protected int weapon;
    protected int ownerId;
    protected int ownerRole;
    protected int ownerSkillDamage;
    protected int ownerVehicleType;
    protected int shootingDirection;
    protected GameObject target;
    protected int[] velocityFP = new int[2];
    private int laserShootingTime;
    private int laserCollisionXFP;
    private int laserCollisionDrawX;
    private boolean laserDrawHit;
    private static final int BOMB_SHADOW_OFFSET = 1024;
    private static final int BOMB_STATE_FALLING = 0;
    private static final int BOMB_STATE_EXPLODING = 1;
    protected int bombState;
    protected int bombSootingTime;
    protected int bombShadowYOffset;

    public Bullet(int n) {
        super(n);
    }

    public void init(int n, int n2, int n3, int n4, int n5, GameObject gameObject, Vehicle vehicle) {
        super.init(n4 < 6 ? 1 : 14, n, n2, n3, null);
        this.weapon = n4;
        this.ownerId = vehicle.getuId();
        this.ownerRole = vehicle.getRole();
        this.ownerVehicleType = vehicle.vehicleType;
        this.ownerSkillDamage = vehicle.skills[10];
        this.shootingDirection = n5;
        this.target = gameObject;
        this.velocityFP[0] = BRCanvasMaths.Fmul(Utils.unpackFirst(n5) * 1024, Game.EQUIPMENT_CONFIGURATION[n4][6]);
        this.velocityFP[1] = BRCanvasMaths.Fmul(Utils.unpackSecond(n5) * 1024, Game.EQUIPMENT_CONFIGURATION[n4][6]);
        if (n5 == -65536 || n5 == 65536) {
            this.velocityFP[1] = this.velocityFP[1] - vehicle.velocityFP[1];
        }
        switch (n4) {
            case 0: 
            case 1: {
                int n6 = NineCanvas.instance.getImageDimension(Game.weaponGun, 0, 0, 4);
                int n7 = NineCanvas.instance.getImageDimension(Game.weaponGun, 0, 0, 5);
                this.setCollisionBox(-n6 / 2, -n7 / 2, n6, n7);
                this.setBounds(-n6 / 2, -n7 / 2, n6, n7);
                break;
            }
            case 4: {
                this.laserShootingTime = 0;
                this.laserCollisionXFP = 0;
                int n8 = NineCanvas.SCREEN_WIDTH * 4;
                if (this.shootingDirection == -65536) {
                    this.setCollisionBox(-n8, -Consts.LASER_BEAM_HEIGHT / 2, n8, Consts.LASER_BEAM_HEIGHT);
                    this.setBoundsFP(-n8, -Consts.LASER_BEAM_HEIGHT / 2, n8, Consts.LASER_BEAM_HEIGHT);
                    break;
                }
                if (this.shootingDirection != 65536) break;
                this.setCollisionBox(0, -Consts.LASER_BEAM_HEIGHT / 2, n8, Consts.LASER_BEAM_HEIGHT);
                this.setBoundsFP(0, -Consts.LASER_BEAM_HEIGHT / 2, n8, Consts.LASER_BEAM_HEIGHT);
                break;
            }
            case 5: {
                this.bombState = 0;
                this.excludeFromCollisionCheckHint = true;
                this.bombSootingTime = 0;
                this.bombShadowYOffset = 0;
                int n9 = NineCanvas.instance.getImageDimension(Game.weaponBomb, 0, 0, 0);
                int n10 = NineCanvas.instance.getImageDimension(Game.weaponBomb, 0, 0, 1);
                this.setCollisionBox(-n9 * 2, -n10, n9 * 4, n10 * 2);
                this.setBounds(-n9 / 2, -n10 / 2, n9, n10);
                break;
            }
            case 7: {
                GameObject.auxiliaryRect = Game.weaponSmoke.getBounds(GameObject.auxiliaryRect, 0);
                int n11 = GameObject.auxiliaryRect[2] * 2;
                int n12 = GameObject.auxiliaryRect[3] * 2;
                int n13 = -n11 / 2;
                int n14 = -n12 / 2;
                this.setCollisionBox(n13, n14, n11, n12);
                this.setBounds(n13, n14, n11, n12);
                break;
            }
        }
    }

    public void deinit() {
    }

    public void update(int n) {
        super.update(n);
        int n2 = BRCanvasMaths.Fdiv(n * 1024, 1024000);
        this.setPositionXFP(this.getPositionXFP() + BRCanvasMaths.Fmul(this.velocityFP[0], n2));
        this.setPositionYFP(this.getPositionYFP() + BRCanvasMaths.Fmul(this.velocityFP[1], n2));
        switch (this.weapon) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.target == null || this.getBottomFP() <= this.target.getTopFP()) break;
                int n3 = this.target.isOnTheLeftTo(this) ? -1 : 1;
                int n4 = n3 * -this.velocityFP[1];
                this.velocityFP[0] = this.velocityFP[0] + BRCanvasMaths.Fmul(n4, n2);
                this.velocityFP[0] = Utils.clamp(this.velocityFP[0], this.velocityFP[1], -this.velocityFP[1]);
                break;
            }
            case 4: {
                this.laserShootingTime += n;
                Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(this.ownerId);
                if (vehicle == null || vehicle.isDead()) {
                    this.markForRemoval();
                    break;
                }
                this.setPositionXFP(vehicle.getPositionXFP() + vehicle.getLaserAnchorXFP(this.shootingDirection));
                this.setPositionYFP(vehicle.getPositionYFP() + vehicle.getLaserAnchorYFP(this.shootingDirection));
                int n5 = Game.EQUIPMENT_CONFIGURATION[this.weapon][3];
                if (this.laserShootingTime > n5 || vehicle.isDead()) {
                    this.markForRemoval();
                }
                this.laserDrawHit = false;
                this.laserCollisionXFP = this.shootingDirection == -65536 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                break;
            }
            case 5: {
                switch (this.bombState) {
                    case 0: {
                        this.bombSootingTime += n;
                        this.bombShadowYOffset = Map.mapTilesFPToPixels(1024) * (700 - this.bombSootingTime) / 700;
                        if (this.bombSootingTime <= 700) break;
                        this.bombSootingTime = 700;
                        this.bombState = 1;
                        this.excludeFromCollisionCheckHint = false;
                        break;
                    }
                    case 1: {
                        this.explode(this.weapon, this.getPositionXFP(), this.getPositionYFP(), 49);
                        this.markForRemoval();
                    }
                }
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(this.ownerId);
                if (vehicle == null || vehicle.isDead()) {
                    this.markForRemoval();
                    break;
                }
                this.setPositionYFP(vehicle.getPositionYFP());
                this.setPositionXFP(vehicle.getPositionXFP());
                if (vehicle.isInvincible()) break;
                this.markForRemoval();
                break;
            }
        }
    }

    public void updateDrawPosition(int n, int n2) {
        super.updateDrawPosition(n, n2);
        switch (this.weapon) {
            case 4: {
                if (!this.laserDrawHit) break;
                this.laserCollisionDrawX = n + Map.mapTilesFPToPixels(this.laserCollisionXFP) - ResourceManager.map.getCameraX();
            }
        }
    }

    public void notifyAfterCollision(GameObject gameObject) {
        super.notifyAfterCollision(gameObject);
        if (gameObject.getuId() == this.ownerId) {
            return;
        }
        switch (this.weapon) {
            case 0: 
            case 1: {
                this.markForRemoval();
                this.explode(this.weapon, this.getPositionXFP(), this.getPositionYFP(), gameObject.drawingLayer + 6);
                break;
            }
            case 2: {
                this.markForRemoval();
                this.explode(this.weapon, gameObject.getPositionXFP(), gameObject.getPositionYFP(), gameObject.drawingLayer + 6);
                break;
            }
            case 3: {
                this.markForRemoval();
                this.explode(this.weapon, gameObject.getCenterXFP(), gameObject.getCenterYFP(), gameObject.drawingLayer + 6);
                break;
            }
            case 4: {
                if (this.shootingDirection == -65536) {
                    int n = gameObject.getPositionXFP() + gameObject.getCollisionBoxFP()[0] + gameObject.getCollisionBoxFP()[2];
                    this.laserCollisionXFP = Math.max(n, this.laserCollisionXFP);
                } else {
                    int n = gameObject.getPositionXFP() + gameObject.getCollisionBoxFP()[0];
                    this.laserCollisionXFP = Math.min(n, this.laserCollisionXFP);
                }
                this.laserDrawHit = true;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (!gameObject.isVehicle()) break;
                this.markForRemoval();
                this.explode(this.weapon, gameObject.getCenterXFP(), gameObject.getCenterYFP(), gameObject.drawingLayer - 6);
                break;
            }
        }
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        switch (this.weapon) {
            case 0: 
            case 1: {
                NineCanvas.instance.drawImageIDNoTransform(graphics, Game.weaponGun, 0, this.drawX, this.drawY, 3);
                break;
            }
            case 4: {
                int n5;
                int n6 = Consts.LASER_BEAM_HEIGHT;
                int n7 = n6 / 3;
                int n8 = n7 * 2;
                int n9 = n6;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                switch (this.laserShootingTime / 56 % 3) {
                    case 0: {
                        n10 = 0xFF6600;
                        n11 = 0xCC3300;
                        n12 = 0xAA0000;
                        break;
                    }
                    case 1: {
                        n10 = 0xAA0000;
                        n11 = 0xFF6600;
                        n12 = 0xCC3300;
                        break;
                    }
                    case 2: {
                        n10 = 0xCC3300;
                        n11 = 0xAA0000;
                        n12 = 0xFF6600;
                    }
                }
                if (this.shootingDirection == -65536) {
                    n5 = 0;
                    graphics.setColor(n12);
                    graphics.fillRect(n5, this.drawY - n9 / 2, this.drawX - n5, n9);
                    graphics.setColor(n11);
                    graphics.fillRect(n5, this.drawY - n8 / 2, this.drawX - n5, n8);
                    graphics.setColor(n10);
                    graphics.fillRect(n5, this.drawY - n7 / 2, this.drawX - n5, n7);
                } else if (this.shootingDirection == 65536) {
                    n5 = NineCanvas.SCREEN_WIDTH - this.drawX;
                    graphics.setColor(n12);
                    graphics.fillRect(this.drawX, this.drawY - n9 / 2, n5, n9);
                    graphics.setColor(n11);
                    graphics.fillRect(this.drawX, this.drawY - n8 / 2, n5, n8);
                    graphics.setColor(n10);
                    graphics.fillRect(this.drawX, this.drawY - n7 / 2, n5, n7);
                }
                n5 = Consts.LASER_HIT_LENGTH1;
                int n13 = Consts.LASER_HIT_LENGTH2;
                if (!this.laserDrawHit) break;
                graphics.setColor(n12);
                graphics.drawLine(this.laserCollisionDrawX, this.drawY - n5 / 2, this.laserCollisionDrawX, this.drawY + n5 / 2);
                graphics.setColor(n11);
                graphics.drawLine(this.laserCollisionDrawX - n5 / 2, this.drawY, this.laserCollisionDrawX + n5 / 2, this.drawY);
                graphics.setColor(n10);
                graphics.drawLine(this.laserCollisionDrawX - n13 / 2, this.drawY - n13 / 2, this.laserCollisionDrawX + n13 / 2, this.drawY + n13 / 2);
                graphics.drawLine(this.laserCollisionDrawX - n13 / 2, this.drawY + n13 / 2, this.laserCollisionDrawX + n13 / 2, this.drawY - n13 / 2);
                break;
            }
            case 8: {
                NineCanvas.instance.drawImageIDNoTransform(graphics, Game.weaponSpikes, 0, this.drawX, this.drawY, 3);
                break;
            }
            case 2: {
                NineCanvas.instance.drawImageIDNoTransform(graphics, Game.weaponRocket, 0, this.drawX, this.drawY, 3);
                break;
            }
            case 3: {
                NineCanvas.instance.drawImageIDNoTransform(graphics, Game.weaponAirRocket, 0, this.drawX, this.drawY, 3);
                break;
            }
            case 5: {
                graphics.setColor(0);
                graphics.fillRect(this.drawX - Consts.BOMB_SHADOW_SIZE / 2, this.drawY + Map.mapTilesFPToPixels(this.getBoundsHeightFP()) / 2 + this.bombShadowYOffset - Consts.BOMB_SHADOW_SIZE / 2, Consts.BOMB_SHADOW_SIZE, Consts.BOMB_SHADOW_SIZE);
                NineCanvas.instance.drawImageIDNoTransform(graphics, Game.weaponBomb, 0, this.drawX, this.drawY, 3);
                break;
            }
            case 7: {
                int n14 = Map.mapTilesFPToPixels(this.getWidthFP()) / 4;
                int n15 = Map.mapTilesFPToPixels(this.getHeightFP()) / 4;
                if (Game.weaponSmoke.wasAnimationPlayedOnce()) break;
                Game.weaponSmoke.render(graphics, this.drawX, this.drawY - n15, 3, n, n2, n3, n4);
                Game.weaponSmoke.render(graphics, this.drawX - n14, this.drawY + n15, 3, n, n2, n3, n4);
                Game.weaponSmoke.render(graphics, this.drawX + n14, this.drawY + n15, 3, n, n2, n3, n4);
                break;
            }
        }
        super.draw(graphics, n, n2, n3, n4);
    }

    public void deactivate() {
        super.deactivate();
        this.markForRemoval();
    }

    private void explode(int n, int n2, int n3, int n4) {
        Explosion explosion = (Explosion)GameObjectManager.popReusableGameObject(3);
        if (explosion == null) {
            explosion = new Explosion(3);
        }
        explosion.init(n2, n3, n4, -1, Game.EQUIPMENT_CONFIGURATION[n][9], this);
        GameObjectManager.addGameObject(explosion);
    }

    public int getWeapon() {
        return this.weapon;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public int getOwnerRole() {
        return this.ownerRole;
    }

    public int getOwnerVehicleType() {
        return this.ownerVehicleType;
    }

    public int getOwnerSkillDamage() {
        return this.ownerSkillDamage;
    }
}

