/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class BRCanvasText
extends BRCanvasImage {
    public static final int TEXTFLAG_CONTAINS_HYPHENATION_GUIDELINES = 4;
    public static final int BR_TEXT_GUIDELINE_TYPE_MASK = -16777216;
    public static Font[] system_fonts = new Font[2];
    public static int[] system_font_colours = new int[2];
    public static int[] bitmap_font_image_ids = new int[2];
    public static short[][] bitmap_font_info = new short[2][];
    public static int set_font = -1;
    public static byte[][] enc_strings;

    public void loadLanguage(int n) {
        enc_strings = null;
        byte[] byArray = this.loadFileFromJar(BRCanvasResHandler.getLanguageIDString(n), -1);
        if (byArray != null) {
            int n2 = BRCanvasResHandler.readShortFromByteArray(byArray, 0);
            enc_strings = new byte[n2][];
            int n3 = 2;
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n3];
                if (by != 0) {
                    short s = (by & 4) != 0 ? BRCanvasResHandler.readShortFromByteArray(byArray, n3 + 3) : (short)0;
                    int n4 = by & 3;
                    short s2 = BRCanvasResHandler.readShortFromByteArray(byArray, n3 + 1);
                    int n5 = 3 + s2 * n4 + (s != 0 ? 2 + s * (s2 > 255 ? 3 : 2) : 0);
                    BRCanvasText.enc_strings[i] = new byte[n5];
                    System.arraycopy(byArray, n3, enc_strings[i], 0, n5);
                    n3 += n5;
                    continue;
                }
                ++n3;
            }
        }
    }

    public String getStringFromENCString(byte[] byArray) {
        int n = BRCanvasResHandler.readShortFromByteArray(byArray, 1);
        int n2 = (byArray[0] & 4) != 0 ? 5 : 3;
        char[] cArray = new char[n];
        if ((byArray[0] & 3) == 1) {
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)(byArray[n2 + i] & 0xFF);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                cArray[i] = (char)BRCanvasResHandler.readShortFromByteArray(byArray, n2 + (i << 1));
            }
        }
        return new String(cArray);
    }

    public byte[] getENCStringFromString(String string) {
        int n = string.length();
        byte[] byArray = new byte[3 + (n << 1)];
        byArray[0] = 2;
        byArray[1] = (byte)(n >> 8);
        byArray[2] = (byte)n;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byArray[3 + (i << 1)] = (byte)(c >> 8);
            byArray[4 + (i << 1)] = (byte)c;
        }
        return byArray;
    }

    public byte[] getENCString(int n) {
        return enc_strings[n];
    }

    public String getString(int n) {
        byte[] byArray = this.getENCString(n);
        if (byArray != null) {
            return this.getStringFromENCString(byArray);
        }
        return null;
    }

    public String[] splitENCString(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null) {
            return null;
        }
        String[] stringArray = null;
        int n4 = BRCanvasResHandler.readShortFromByteArray(byArray, 1);
        int n5 = (byArray[0] & 4) != 0 ? BRCanvasResHandler.readShortFromByteArray(byArray, 3) : 0;
        int n6 = n5 != 0 ? 5 : 3;
        int n7 = byArray[0] & 3;
        char[] cArray = new char[n4 + 1];
        int[] nArray = new int[n4 + 1];
        if (n7 == 1) {
            for (n3 = 0; n3 < n4; ++n3) {
                cArray[n3] = (char)(byArray[n6 + n3] & 0xFF);
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                cArray[n3] = (char)BRCanvasResHandler.readShortFromByteArray(byArray, n6 + (n3 << 1));
            }
        }
        cArray[n4] = 10;
        int n8 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = this.getCharWidth(n, cArray[n3]);
            n8 += nArray[n3];
        }
        if (n8 <= n2) {
            boolean bl = false;
            for (n3 = 0; n3 < n4; ++n3) {
                if (cArray[n3] != '\n') continue;
                bl = true;
            }
            if (!bl) {
                stringArray = new String[]{BRCanvasText.replaceHardSpaces(new String(cArray, 0, n4))};
                return stringArray;
            }
        }
        int[] nArray2 = null;
        if (n5 != 0) {
            nArray2 = new int[n5];
            if (n4 < 256) {
                for (n3 = 0; n3 < n5; ++n3) {
                    nArray2[n3] = byArray[n6 + n4 * n7 + (n3 << 1)] & 0xFF;
                    int n9 = n3;
                    nArray2[n9] = nArray2[n9] | (byArray[n6 + n4 * n7 + (n3 << 1) + 1] & 0xFF) << 24;
                }
            } else {
                for (n3 = 0; n3 < n5; ++n3) {
                    nArray2[n3] = BRCanvasResHandler.readShortFromByteArray(byArray, n6 + n4 * n7 + (n3 << 1) + n3);
                    int n10 = n3;
                    nArray2[n10] = nArray2[n10] | (byArray[n6 + n4 * n7 + (n3 << 1) + n3 + 2] & 0xFF) << 24;
                }
            }
        }
        int n11 = this.getCharWidth(n, ' ');
        int n12 = this.getCharWidth(n, '-');
        for (int i = 0; i < 2; ++i) {
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            for (n3 = 0; n3 <= n4; ++n3) {
                boolean bl;
                char c = cArray[n3];
                boolean bl2 = bl = n18 < n5 && n3 == (nArray2[n18] & 0xFFFFFF);
                n19 = bl ? ((nArray2[n18] & 0xFF000000) != 0 ? 0 : n12) : 0;
                if (c != ' ' && c != '\n' && !bl) {
                    n15 = c == '\u00ac' || c == '\u00a0' ? (n15 += n11) : (n15 += nArray[n3]);
                    if (!bl) {
                        ++n16;
                    }
                } else {
                    if (n17 + n15 + n19 > n2) {
                        int n20 = n3 - n16;
                        if (n17 != 0) {
                            if (i == 1) {
                                stringArray[n13] = new String(cArray, n14, n20 - n14 - (cArray[n20 - 1] == ' ' ? 1 : 0));
                                if (n5 != 0 && n18 != 0 && (nArray2[n18 - 1] & 0xFFFFFF) == n20 && (nArray2[n18 - 1] & 0xFF000000) == 0) {
                                    int n21 = n13;
                                    stringArray[n21] = stringArray[n21] + "-";
                                }
                            }
                            ++n13;
                        }
                        n14 = n20;
                        n17 = 0;
                    }
                    if (c == ' ') {
                        n17 += n11;
                    }
                    n17 += n15;
                    if (bl) {
                        n16 = 1;
                        n15 = nArray[n3];
                    } else {
                        n16 = 0;
                        n15 = 0;
                    }
                    if (c == '\n') {
                        if (i == 1) {
                            stringArray[n13] = new String(cArray, n14, n3 - n14);
                        }
                        ++n13;
                        n14 = n3 + 1;
                        n17 = 0;
                    }
                }
                if (!bl) continue;
                ++n18;
            }
            if (i != 0) continue;
            stringArray = new String[n13];
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            stringArray[n3] = BRCanvasText.replaceHardSpaces(stringArray[n3]);
        }
        return stringArray;
    }

    public String[] splitString(String string, int n, int n2) {
        return this.splitENCString(this.getENCStringFromString(string), n, n2);
    }

    public static String replaceHardSpaces(String string) {
        while (string.indexOf(172) != -1) {
            string = BRCanvasText.insertStringIntoString(string, "\u00ac", " ");
        }
        while (string.indexOf(160) != -1) {
            string = BRCanvasText.insertStringIntoString(string, "\u00a0", " ");
        }
        return string;
    }

    public static String insertStringIntoString(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string4 = string.substring(0, n) + string3;
        if (n != string.length() - string2.length()) {
            string4 = string4 + string.substring(n + string2.length());
        }
        return string4;
    }

    public byte[] insertENCStringIntoENCString(byte[] byArray, String string, byte[] byArray2) {
        int n;
        int n2;
        int n3 = BRCanvasResHandler.readShortFromByteArray(byArray, 1);
        short s = (byArray[0] & 4) != 0 ? BRCanvasResHandler.readShortFromByteArray(byArray, 3) : (short)0;
        int n4 = s != 0 ? 5 : 3;
        int n5 = byArray[0] & 3;
        char[] cArray = new char[n3];
        if (n5 == 1) {
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n2] = (char)(byArray[n4 + n2] & 0xFF);
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n2] = (char)BRCanvasResHandler.readShortFromByteArray(byArray, n4 + (n2 << 1));
            }
        }
        int[] nArray = null;
        if (s != 0) {
            nArray = new int[s];
            if (n3 < 256) {
                for (n2 = 0; n2 < s; ++n2) {
                    nArray[n2] = byArray[n4 + n5 * n3 + (n2 << 1)] & 0xFF;
                    int n6 = n2;
                    nArray[n6] = nArray[n6] | (byArray[n4 + n5 * n3 + (n2 << 1) + 1] & 0xFF) << 24;
                }
            } else {
                for (n2 = 0; n2 < s; ++n2) {
                    nArray[n2] = BRCanvasResHandler.readShortFromByteArray(byArray, n4 + n5 * n3 + ((n2 << 1) + n2));
                    int n7 = n2;
                    nArray[n7] = nArray[n7] | (byArray[n4 + n5 * n3 + ((n2 << 1) + n2 + 2)] & 0xFF) << 24;
                }
            }
        }
        int n8 = BRCanvasResHandler.readShortFromByteArray(byArray2, 1);
        short s2 = (byArray2[0] & 4) != 0 ? BRCanvasResHandler.readShortFromByteArray(byArray2, 3) : (short)0;
        int n9 = s2 != 0 ? 5 : 3;
        int n10 = byArray2[0] & 3;
        char[] cArray2 = new char[n8];
        if (n10 == 1) {
            for (n2 = 0; n2 < n8; ++n2) {
                cArray2[n2] = (char)(byArray2[n9 + n2] & 0xFF);
            }
        } else {
            for (n2 = 0; n2 < n8; ++n2) {
                cArray2[n2] = (char)BRCanvasResHandler.readShortFromByteArray(byArray2, n9 + (n2 << 1));
            }
        }
        int[] nArray2 = null;
        if (s2 != 0) {
            nArray2 = new int[s2];
            if (n8 < 256) {
                for (n2 = 0; n2 < s2; ++n2) {
                    nArray2[n2] = byArray2[n9 + n10 * n8 + (n2 << 1)] & 0xFF;
                    int n11 = n2;
                    nArray2[n11] = nArray2[n11] | (byArray2[n9 + n10 * n8 + (n2 << 1) + 1] & 0xFF) << 24;
                }
            } else {
                for (n2 = 0; n2 < s2; ++n2) {
                    nArray2[n2] = BRCanvasResHandler.readShortFromByteArray(byArray2, n9 + n10 * n8 + ((n2 << 1) + n2));
                    int n12 = n2;
                    nArray2[n12] = nArray2[n12] | (byArray2[n9 + n10 * n8 + ((n2 << 1) + n2 + 2)] & 0xFF) << 24;
                }
            }
        }
        char[] cArray3 = string.toCharArray();
        int n13 = cArray3.length;
        int n14 = -1;
        for (n2 = 0; n2 < n3 - n13 + 1; ++n2) {
            for (n = 0; n < n13 && cArray[n2 + n] == cArray3[n]; ++n) {
            }
            if (n != n13) continue;
            n14 = n2;
        }
        if (n14 != -1) {
            char c;
            int n15 = n3 - n13 + n8;
            int n16 = s + s2;
            byte[] byArray3 = new byte[3 + (n16 == 0 ? 0 : 2) + (n15 << 1) + (n16 << (n15 < 256 ? 0 : 1)) + n16];
            byArray3[0] = (byte)(2 | (n16 == 0 ? 0 : 4));
            byArray3[1] = (byte)(n15 >> 8);
            byArray3[2] = (byte)n15;
            int n17 = 3;
            if (n16 != 0) {
                byArray3[n17++] = (byte)(n16 >> 8);
                byArray3[n17++] = (byte)n16;
            }
            for (n2 = 0; n2 < n14; ++n2) {
                c = cArray[n2];
                byArray3[n17++] = (byte)(c >> 8);
                byArray3[n17++] = (byte)c;
            }
            for (n2 = 0; n2 < n8; ++n2) {
                c = cArray2[n2];
                byArray3[n17++] = (byte)(c >> 8);
                byArray3[n17++] = (byte)c;
            }
            for (n2 = n14 + n13; n2 < n3; ++n2) {
                c = cArray[n2];
                byArray3[n17++] = (byte)(c >> 8);
                byArray3[n17++] = (byte)c;
            }
            if (n16 != 0) {
                boolean bl = false;
                for (n2 = 0; n2 <= s; ++n2) {
                    int n18;
                    if (!(bl || n2 != s && n14 > (nArray[n2] & 0xFFFFFF))) {
                        for (n = 0; n < s2; ++n) {
                            n18 = (nArray2[n] & 0xFFFFFF) + n14 | nArray2[n] & 0xFF000000;
                            if (n15 < 256) {
                                byArray3[n17++] = (byte)n18;
                                byArray3[n17++] = (byte)(n18 >> 24);
                                continue;
                            }
                            byArray3[n17++] = (byte)(n18 >> 8);
                            byArray3[n17++] = (byte)n18;
                            byArray3[n17++] = (byte)(n18 >> 24);
                        }
                        bl = true;
                    }
                    if (n2 == s) continue;
                    n18 = nArray[n2] & 0xFFFFFF;
                    if (bl) {
                        n18 += n8 - n13;
                    }
                    n18 |= nArray[n2] & 0xFF000000;
                    if (n15 < 256) {
                        byArray3[n17++] = (byte)n18;
                        byArray3[n17++] = (byte)(n18 >> 24);
                        continue;
                    }
                    byArray3[n17++] = (byte)(n18 >> 8);
                    byArray3[n17++] = (byte)n18;
                    byArray3[n17++] = (byte)(n18 >> 24);
                }
            }
            return byArray3;
        }
        return byArray;
    }

    public byte[] insertStringIntoENCString(byte[] byArray, String string, String string2) {
        return this.insertENCStringIntoENCString(byArray, string, this.getENCStringFromString(string2));
    }

    public String insertENCStringIntoString(String string, String string2, byte[] byArray) {
        return BRCanvasText.insertStringIntoString(string, string2, this.getStringFromENCString(byArray));
    }

    public int loadSystemFont(int n, int n2, int n3, int n4) {
        int n5;
        for (n5 = 0; n5 < 2; ++n5) {
            if (system_fonts[n5] == null || system_fonts[n5].getFace() != n || system_fonts[n5].getStyle() != n2 || system_fonts[n5].getSize() != n3 || system_font_colours[n5] != n4) continue;
            return n5;
        }
        for (n5 = 0; n5 < 2; ++n5) {
            if (system_fonts[n5] != null || bitmap_font_info[n5] != null) continue;
            BRCanvasText.system_fonts[n5] = Font.getFont((int)n, (int)n2, (int)n3);
            BRCanvasText.system_font_colours[n5] = n4;
            return n5;
        }
        return -1;
    }

    public int loadBitmapFont(int n, int n2) {
        int n3;
        int n4 = this.loadImageID(n + 1, n2, 1, true);
        for (n3 = 0; n3 < 2; ++n3) {
            if (bitmap_font_info[n3] == null || bitmap_font_image_ids[n3] != n4) continue;
            return n3;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            if (system_fonts[n3] != null || bitmap_font_info[n3] != null) continue;
            BRCanvasText.bitmap_font_info[n3] = this.getResourceShortArray(n);
            BRCanvasText.bitmap_font_image_ids[n3] = n4;
            return n3;
        }
        this.unloadImageID(n4);
        return -1;
    }

    public void unloadFont(int n) {
        BRCanvasText.system_fonts[n] = null;
        if (bitmap_font_info[n] != null) {
            this.unloadImageID(bitmap_font_image_ids[n]);
            BRCanvasText.bitmap_font_info[n] = null;
        }
    }

    public int getBitmapFontCharacterIndex(int n, char c) {
        if (bitmap_font_info[n] != null) {
            int n2 = bitmap_font_info[n][0];
            for (int i = 0; i < n2; ++i) {
                if (bitmap_font_info[n][i + 2] != c) continue;
                return i;
            }
        }
        return -1;
    }

    public int getFontHeight(int n) {
        if (system_fonts[n] == null) {
            return this.getImageDimension(bitmap_font_image_ids[n], 0, 0, 5);
        }
        return system_fonts[n].getHeight() + 0;
    }

    public int getMaxStringWidths(int n, String[] stringArray) {
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = this.getStringWidth(n, stringArray[i]);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int getStringWidth(int n, String string) {
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n2 += this.getCharWidth(n, string.charAt(i));
        }
        return n2;
    }

    public int getCharsWidth(int n, char[] cArray) {
        int n2 = 0;
        int n3 = cArray.length;
        for (int i = 0; i < n3; ++i) {
            n2 += this.getCharWidth(n, cArray[i]);
        }
        return n2;
    }

    public int getCharWidth(int n, char c) {
        if (system_fonts[n] == null) {
            if (c == ' ') {
                return (bitmap_font_info[n][1] & 0xFF) + (byte)(bitmap_font_info[n][1] >> 8);
            }
            int n2 = this.getBitmapFontCharacterIndex(n, c);
            if (n2 == -1) {
                return 0;
            }
            return this.getImageDimension(bitmap_font_image_ids[n], n2, 0, 6) + (byte)(bitmap_font_info[n][1] >> 8);
        }
        return system_fonts[n].charWidth(c);
    }

    public void setFont(Graphics graphics, int n) {
        if (system_fonts[n] != null) {
            graphics.setFont(system_fonts[n]);
        }
        set_font = n;
    }

    public void drawCharsOrString(Graphics graphics, String string, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n4 < -(BRCanvasDimensions.PARAM_BR_BASE_SCREEN_HEIGHT >> 2) || n4 > 5 * BRCanvasDimensions.PARAM_BR_BASE_SCREEN_HEIGHT >> 2) {
            return;
        }
        if ((n5 & 0x22) != 0) {
            n7 = this.getFontHeight(set_font);
            if ((n5 & 2) != 0) {
                n4 -= n7 >> 1;
            } else if ((n5 & 0x20) != 0) {
                n4 -= n7;
            }
            n5 &= 0xFFFFFFDD;
            n5 |= 0x10;
        }
        if (system_fonts[set_font] == null) {
            char c;
            int n8;
            n7 = n6 == -1 ? this.getCharWidth(set_font, ' ') : n6;
            int n9 = bitmap_font_image_ids[set_font];
            int n10 = this.getImageDimension(n9, 0, 0, 4);
            if ((n5 & 9) != 0) {
                if (n6 == -1) {
                    n8 = 0;
                    for (c = '\u0000'; c < n2; ++c) {
                        n8 += this.getCharWidth(set_font, string != null ? string.charAt(n + c) : cArray[n + c]);
                    }
                } else {
                    n8 = n2 * n6;
                }
                if ((n5 & 1) != 0) {
                    n3 -= n8 >> 1;
                } else if ((n5 & 8) != 0) {
                    n3 -= n8;
                }
            }
            for (n8 = 0; n8 < n2; ++n8) {
                c = string != null ? string.charAt(n + n8) : cArray[n + n8];
                if (c == ' ') {
                    n3 += n7;
                    continue;
                }
                int n11 = this.getBitmapFontCharacterIndex(set_font, c);
                if (n11 == -1) continue;
                this.drawImageIDNoTransform(graphics, n9, n11, n3 - this.getImageDimension(n9, n11, 0, 8) % n10, n4, 20);
                if (n6 == -1) {
                    n3 += this.getCharWidth(set_font, c);
                    continue;
                }
                n3 += n6;
            }
        } else {
            graphics.setColor(system_font_colours[set_font]);
            n3 += 0;
            n4 += 0;
            if (n6 != -1) {
                if ((n5 & 9) != 0) {
                    n7 = n2 * n6;
                    if ((n5 & 1) != 0) {
                        n3 -= n7 >> 1;
                    } else if ((n5 & 8) != 0) {
                        n3 -= n7;
                    }
                }
                n7 = 0;
                while (n7 < n2) {
                    graphics.drawChar(string != null ? string.charAt(n + n7) : cArray[n + n7], n3, n4, 20);
                    ++n7;
                    n3 += n6;
                }
            } else if (string != null) {
                graphics.drawString(string, n3, n4, n5);
            } else {
                graphics.drawChars(cArray, n, n2, n3, n4, n5);
            }
        }
    }

    public void drawCharsExtended(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawCharsOrString(graphics, null, cArray, n, n2, n3, n4, n5, n6);
    }

    public void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        this.drawCharsExtended(graphics, cArray, 0, cArray.length, n, n2, n3, n4);
    }

    public void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        this.drawCharsOrString(graphics, string, null, 0, string.length(), n, n2, n3, n4);
    }

    public void drawSplitString(Graphics graphics, String[] stringArray, int n, int n2, int n3, int n4) {
        int n5 = stringArray.length;
        if ((n3 & 2) != 0) {
            n2 -= n4 * n5 >> 1;
        }
        if ((n3 & 0x20) != 0) {
            n2 -= n4 * n5;
        }
        n3 = n3 & 0xD | 0x10;
        for (int i = 0; i < n5; ++i) {
            this.drawString(graphics, stringArray[i], n, n2 + n4 * i, n3, -1);
        }
    }
}

