/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public abstract class BRCanvasSound
extends BRCanvasText
implements PlayerListener {
    public static long last_backlight_on_time;
    public static long vibration_end_time;
    public int volume_to_set = 50;
    public int[] audio_file_headers = new int[]{589381965, -1, 1297377380, -1, 1380533830, -1, 0x63616666, -1, 1332176723, -1, 1447118704, -1, 0x4D4D4D44, -1};
    public String[] audio_file_formats = new String[]{"audio/amr", "audio/midi", "audio/x-wav", "audio/x-caf", "application/ogg", "audio/x-vag", "application/vnd.smaf", "audio/mpeg"};
    public byte[][] sound_data = new byte[3][];
    public InputStream[] sound_stream = null;
    public int[] sound_data_resid = new int[3];
    public Player[] players = new Player[3];
    public int[] audio_loop_count = new int[3];
    public int[] sound_channel_priorities = new int[3];

    public void keepTheLightOn(long l) {
    }

    public void vibrate(int n) {
        BRMidlet.display.vibrate(n);
        vibration_end_time = n > 0 ? System.currentTimeMillis() + (long)n : 0L;
    }

    public int loadSound(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = this.alreadyLoadedChannel(n);
        if (n2 != -1) {
            return n2;
        }
        for (int i = 0; i < 3; ++i) {
            if (this.sound_data[i] != null || this.players[i] != null) continue;
            this.sound_data[i] = this.getResourceByteArray(n);
            if (this.sound_data[i] == null) continue;
            this.sound_data_resid[i] = n;
            this.createPlayerAndPrefetch(i);
            return i;
        }
        return -1;
    }

    public void unloadSound(int n) {
        for (int i = 0; i < 3; ++i) {
            if (this.sound_data[i] == null || this.sound_data_resid[i] != n) continue;
            this.cleanUpPlayerFromChannel(i);
            this.sound_data[i] = null;
        }
    }

    public void setVolume(int n) {
        this.volume_to_set = n * 100 / 100;
    }

    public void playSound(int n, int n2, int n3) {
        this.playResumeSound(n, n2, n3, false);
    }

    public void stopSound(int n) {
        for (int i = 0; i < 3; ++i) {
            if (this.players[i] == null || this.sound_data_resid[i] != n) continue;
            this.stopSoundChannel(i);
        }
    }

    public void stopAllSounds() {
        for (int i = 0; i < 3; ++i) {
            this.stopSoundChannel(i);
        }
    }

    public boolean resumeSound(int n) {
        return this.playResumeSound(n, -1, -1, true);
    }

    public void pauseSound(int n) {
        this.stopSound(n);
    }

    public void beep() {
        try {
            Player player = Manager.createPlayer((String)"device://tone");
            player.realize();
            ToneControl toneControl = (ToneControl)player.getControl("ToneControl");
            toneControl.setSequence(new byte[]{-2, 1, -3, 30, 60, 8});
            player.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int alreadyLoadedChannel(int n) {
        for (int i = 0; i < 3; ++i) {
            if (this.sound_data_resid[i] != n || this.sound_data[i] == null && this.players[i] == null) continue;
            return i;
        }
        return -1;
    }

    public boolean playResumeSound(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (n < 0) {
            return false;
        }
        if (bl) {
            n5 = this.alreadyLoadedChannel(n);
            if (n5 == -1) {
                return false;
            }
            n2 = this.sound_channel_priorities[n5];
        }
        n5 = n2 + 1;
        int n6 = -1;
        int n7 = 0;
        for (n4 = 0; n4 < 3; ++n4) {
            if (this.players[n4] == null || this.players[n4].getState() != 400) continue;
            ++n7;
            if (n5 <= this.sound_channel_priorities[n4]) continue;
            n6 = n4;
            n5 = this.sound_channel_priorities[n4];
        }
        n4 = this.loadSound(n);
        if (n4 != -1) {
            if (n7 >= 1) {
                if (n6 != -1) {
                    this.stopSoundChannel(n6);
                } else {
                    return false;
                }
            }
            this.createPlayerAndPrefetch(n4);
            this.sound_channel_priorities[n4] = n2;
            if (!bl) {
                this.audio_loop_count[n4] = n3 == 0 ? -1 : n3;
            }
            try {
                if (this.players[n4].getState() == 400 && this.players[n4] != null) {
                    this.players[n4].stop();
                }
                if (this.players[n4] != null) {
                    this.players[n4].setLoopCount(this.audio_loop_count[n4]);
                }
                if (this.players[n4] != null) {
                    try {
                        VolumeControl volumeControl = (VolumeControl)this.players[n4].getControl("VolumeControl");
                        if (volumeControl != null) {
                            this.volume_to_set = NineCanvas.setVolumeLevel > 0 ? NineCanvas.setVolumeLevel : this.volume_to_set;
                            volumeControl.setLevel(this.volume_to_set);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.players[n4] != null) {
                    try {
                        if (!bl) {
                            this.players[n4].setMediaTime(0L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.players[n4] != null) {
                    this.players[n4].start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void stopSoundChannel(int n) {
        if (this.players[n] != null) {
            try {
                this.audio_loop_count[n] = 0;
                this.players[n].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (NineCanvas.cleanPlayerIfStopSound) {
                this.cleanUpPlayerFromChannel(n);
            }
        }
    }

    public void cleanUpPlayerFromChannel(int n) {
        if (this.players[n] != null) {
            if (NineCanvas.soundDeletePlayers) {
                // empty if block
            }
            this.players[n].deallocate();
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        for (int i = 0; i < 3; ++i) {
            if (this.players[i] != player) continue;
        }
    }

    public static boolean isPrefetchedOrStarted(int n) {
        return n == 300 || n == 400;
    }

    public void createPlayerAndPrefetch(int n) {
        int n2;
        if (this.players[n] != null) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        int n3 = 0;
        if (this.sound_data[n] == null) {
            return;
        }
        n3 = (this.sound_data[n][0] & 0xFF) << 24 | (this.sound_data[n][1] & 0xFF) << 16 | (this.sound_data[n][2] & 0xFF) << 8 | this.sound_data[n][3];
        int n4 = -1;
        for (n2 = 0; n2 < this.audio_file_headers.length; n2 += 2) {
            if ((n3 & this.audio_file_headers[n2 + 1]) != this.audio_file_headers[n2]) continue;
            n4 = n2 >> 1;
        }
        if (n4 == -1) {
            n4 = this.audio_file_formats.length - 1;
        }
        byteArrayInputStream = new ByteArrayInputStream(this.sound_data[n]);
        try {
            this.players[n] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)this.audio_file_formats[n4]);
            this.players[n].addPlayerListener((PlayerListener)this);
            if (!BRCanvasSound.isPrefetchedOrStarted(this.players[n].getState())) {
                int n5;
                n2 = Integer.MAX_VALUE;
                int n6 = -1;
                int n7 = 0;
                for (n5 = 0; n5 < 3; ++n5) {
                    if (this.players[n5] == null || !BRCanvasSound.isPrefetchedOrStarted(this.players[n5].getState())) continue;
                    ++n7;
                    if (n2 <= this.sound_channel_priorities[n5]) continue;
                    n6 = n5;
                    n2 = this.sound_channel_priorities[n5];
                }
                n5 = 1;
                if (n7 >= 1 || n7 >= 1) {
                    if (n6 != -1) {
                        this.stopSoundChannel(n6);
                        this.cleanUpPlayerFromChannel(n6);
                    } else {
                        n5 = 0;
                    }
                }
                if (n5 != 0) {
                    this.players[n].prefetch();
                } else {
                    this.cleanUpPlayerFromChannel(n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

