/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Vehicle
extends GameObject {
    public static final int TILE_COLLISION_FIX_TIME_MS = 1000;
    public static final int TILE_COLLISION_MAX_DISTANCE_X = 1024;
    public static final int TILE_COLLISION_MAX_DISTANCE_Y = 4096;
    private static final int CRASH_TIMER_MS = 2000;
    private static final int TIMER_ANIMATION_MS = 200;
    private static final int TIMER_COLLISION_DAMAGE = 1000;
    protected int vehicleType;
    protected int[] skills;
    protected int scorePointsAfterKill;
    public static final int ANIMATION_NONE = -1;
    public static final int ANIMATION_DRIVING_STRAIGHT = 0;
    public static final int ANIMATION_TURNING_LEFT = 1;
    public static final int ANIMATION_TURNING_LEFT_BACK = 1;
    public static final int ANIMATION_TURNING_RIGHT = -1;
    public static final int ANIMATION_TURNING_RIGHT_BACK = -1;
    public static final int ANIMATION_CRASH = 3;
    public static final int ANIMATION_JUMP_START = 2;
    public static final int ANIMATION_JUMP_MIDDLE = 2;
    public static final int ANIMATION_JUMP_END = 2;
    public static final int ANIMATION_DESTROYED = 3;
    public static final int VEHICLE_ANIMATIONS_COUNT = 10;
    public static final int SMOKE_ANIMATIONS_COUNT = 3;
    private SimpleSprite sprite = new SimpleSprite();
    private SimpleSprite spriteBoost = new SimpleSprite();
    private int currentAnimation;
    private int spriteId;
    private int[] palette;
    private int currentSmokeAnimation;
    private boolean canPlaySignalRightAnimation;
    protected int[] velocityDefFP;
    protected int[] accelerationBaseFP = new int[2];
    protected int[] decelerationBaseFP = new int[2];
    protected int[] vehicleVelocityDefFP;
    protected int[] vehicleVelocityMinFP;
    protected int[] vehicleVelocityMaxFP;
    protected int[] vehicleAccelerationFP;
    protected int[] vehicleDecelerationFP;
    protected int[] vehicleVelocityBoostFP;
    protected int[] velocityDesiredFP;
    protected int[] velocityMinFP;
    protected int[] velocityMaxFP;
    protected int[] velocityBoostFP;
    protected int[] velocityFP;
    protected int[] accelerationFP;
    protected int massFP;
    protected int objectCollisionFixTimeElapsedMS;
    public static final int STATE_NONE = -1;
    public static final int STATE_DRIVING = 0;
    public static final int STATE_JUMP_START = 1;
    public static final int STATE_JUMP_MIDDLE = 2;
    public static final int STATE_JUMP_END = 3;
    public static final int STATE_CRASH = 4;
    public static final int STATE_DEAD = 5;
    public static final int STATE_HANDLING_TILE_COLLISION = 6;
    public static final int STATE_LOSE_CONTROL = 8;
    public static final int STATE_STOP = 9;
    protected int state;
    protected boolean mLeft;
    protected boolean mRight;
    protected boolean mUp;
    protected boolean mUpPrev;
    protected boolean mDown;
    protected boolean mFire;
    protected boolean mGadget;
    protected boolean invincible;
    protected int invincibilityTimer;
    private int crashTimer;
    private int crashedById;
    private int crashedByRole;
    protected int positionAfterJumpYFP;
    private int loseControlScriptId;
    private int loseControlDirection;
    private int loseControlTimer;
    private int loseControlNextState;
    private int collisionDamageTimer;
    private int timerAnimation;
    protected AI ai;
    public static final int DAMAGE_REASON_BULLET_HIT = 0;
    public static final int DAMAGE_REASON_COLLISION_WITH_TILE = 1;
    public static final int DAMAGE_REASON_COLLISION_WITH_BREAKABLE = 2;
    public static final int DAMAGE_REASON_COLLISION_DAMAGE = 3;
    protected int maxHealthPoints;
    private int health;
    protected int vehicleHealth;
    protected boolean drawHealthBar;
    public static final int WEAPONS_SLOTS_COUNT = 2;
    public static final int WEAPON_SLOT_PRIMARY = 0;
    public static final int WEAPON_SLOT_GADGET = 1;
    public static final int WEAPON_STATE_IDLE = 0;
    public static final int WEAPON_STATE_SHOOTING = 1;
    public static final int WEAPON_STATE_AUTOFIRE = 2;
    public static final int WEAPON_STATE_NO_AMMO = 3;
    public static final int WEAPON_STATE_SHOWING_GUNS = 4;
    public static final int WEAPON_STATE_HIDING_GUNS = 5;
    public static final int MSG_WEAPON_FIRE = 1;
    public static final int MSG_WEAPON_CEASE_FIRE = 2;
    public static final int MSG_WEAPON_STOP_AUTOFIRE = 3;
    public static final int WEAPON_SIZE = 9;
    public static final int WEAPON_IDX_ID = 0;
    public static final int WEAPON_IDX_STATE = 1;
    public static final int WEAPON_IDX_STATE_CHANGE = 2;
    public static final int WEAPON_IDX_NEW_STATE = 3;
    public static final int WEAPON_IDX_NEW_STATE_MSG_ENTER_PARAM = 4;
    public static final int WEAPON_IDX_AMMO = 5;
    public static final int WEAPON_IDX_COOLDOWN_TIMER = 6;
    public static final int WEAPON_IDX_FIRE_TIMER = 7;
    public static final int WEAPON_IDX_AUTOFIRE_ROUNDS_SHOT = 8;
    public static final int WEAPON_COMMAND_FIRE = 1;
    public static final int WEAPON_COMMAND_AUTOFIRE_OFF = 2;
    protected int[] defaultWeapons;
    protected int[] weapons;
    protected int bombsToDrop;
    protected int airstrikeTimer;
    protected Sensor nearestAirVehicleSensor;
    public static final int GUN_SIZE = 4;
    public static final int GUN_IDX_STATE = 0;
    public static final int GUN_IDX_STATE_CHANGE = 1;
    public static final int GUN_IDX_NEW_STATE = 2;
    public static final int GUN_IDX_NEW_STATE_ENTER_MSG_PARAM = 3;
    public static final int GUN_FLAG_SHOW_GUN = 1;
    public static final int GUN_ANIMATIONS_COUNT = 3;
    public static final int GUN_STATE_HIDDEN = -1;
    public static final int GUN_STATE_SHOWING = 0;
    public static final int GUN_STATE_READY = 1;
    public static final int GUN_STATE_HIDING = 2;
    public static final int MSG_PARAM_NONE = -1;
    public static final int MSG_STATE_ENTER = -2;
    public static final int MSG_STATE_EXIT = -1;
    public static final int MSG_STATE_UPDATE = 0;
    public static final int MSG_GUN_SHOW = 1;
    public static final int MSG_GUN_HIDE = 2;
    protected int[] guns;
    protected int boostFP;
    protected int boostMinFP;
    protected static int boostMaxFP;
    protected static int boostDrainPerSecondFP;
    protected static int boostRegeneratePerSecondFP;
    protected boolean drawBoost;
    protected boolean canUseBoost;
    protected int cameraBoostOffsetYFP;
    protected int cameraMaxOffsetYFP;
    protected int cameraDefOffsetYFP;
    protected int cameraMinOffsetYFP;
    protected int tileCollisionAnimationDrawX;
    protected int tileCollisionAnimationDrawY;
    protected boolean collidedWithTile;
    protected int collisionDurability;
    protected int collisionDamage;
    public static final int SENSORS_COUNT = 2;
    public static final int SENSOR_FRONT_FAR = 0;
    public static final int SENSOR_FRONT_NEAR = 1;
    protected Sensor[] collisionSensors;
    public static final int MISSION_MARKER_NONE = -1;
    public static final int MISSION_MARKER_BOND = 3;
    public static final int MISSION_MARKER_DONT_DESTROY = 1;
    public static final int MISSION_MARKER_DESTROY = 0;
    public static final int MISSION_MARKER_GOAL = 2;
    protected boolean missionMarkerFlag;
    private int missionMarker;
    private static final int MARKS_MAX_COUNT = 50;
    private static final int MARKS_X_OFFSET = 5;
    private static final int MARKS_WIDTH = 3;
    private static final int MARKS_COLOR = 0x434343;
    private Vector marksX;
    private Vector marksY;
    private static final int WAVE_COUNTER_PAUSE = 1;
    private int waveCounter = 1;
    private Vector waterWaves;
    public static final int AUX_PARAMETERS_ARRAY_SIZE = 3;
    private int[] auxParametersArray;
    protected int collidedTileX;
    protected int collidedTileY;
    private static final int[][] ROTOR_POINTS;
    private int currentRotorFrame;
    private static final int ROTOR_OFFSET_Y = -10;
    private int stealthFrame;
    private static final int[][] STEALTH_VERTICES;

    public static void initFields() {
        boostMaxFP = 102400;
        boostDrainPerSecondFP = 35840;
        boostRegeneratePerSecondFP = 10240;
    }

    public Vehicle(int n) {
        super(n);
        this.velocityDefFP = new int[2];
        this.vehicleAccelerationFP = new int[2];
        this.vehicleDecelerationFP = new int[2];
        this.vehicleVelocityDefFP = new int[2];
        this.vehicleVelocityMinFP = new int[2];
        this.vehicleVelocityMaxFP = new int[2];
        this.vehicleVelocityBoostFP = new int[2];
        this.velocityFP = new int[2];
        this.velocityDesiredFP = new int[2];
        this.velocityMinFP = new int[2];
        this.velocityMaxFP = new int[2];
        this.velocityBoostFP = new int[2];
        this.accelerationFP = new int[2];
        this.ai = new AI();
        this.defaultWeapons = new int[2];
        this.weapons = new int[18];
        this.nearestAirVehicleSensor = new Sensor();
        this.collisionSensors = new Sensor[2];
        for (int i = 0; i < this.collisionSensors.length; ++i) {
            this.collisionSensors[i] = new Sensor();
        }
        this.auxParametersArray = new int[3];
    }

    public void init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, boolean bl2, boolean bl3, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int[] nArray, int n22, int n23, int n24) {
        super.init(n, n2, n3, n4, null);
        this.crashTimer = 0;
        this.vehicleType = n22;
        this.skills = nArray;
        this.scorePointsAfterKill = n10;
        this.missionMarkerFlag = bl2;
        this.spriteId = n5;
        this.currentAnimation = 0;
        this.palette = n6 == -1 ? null : Game.PALETTES_DEFINITIONS[n6];
        this.sprite = ResourceManager.createSprite(n5, this.sprite);
        if (this.getRole() == 2) {
            this.spriteBoost = ResourceManager.createSprite(128, this.spriteBoost);
        }
        if (n22 == 2) {
            // empty if block
        }
        GameObject.auxiliaryRect = this.sprite.getBounds(GameObject.auxiliaryRect, 0);
        this.setCollisionBox(GameObject.auxiliaryRect[0], GameObject.auxiliaryRect[1], GameObject.auxiliaryRect[2], GameObject.auxiliaryRect[3]);
        this.setBounds(GameObject.auxiliaryRect[0], GameObject.auxiliaryRect[1], GameObject.auxiliaryRect[2], GameObject.auxiliaryRect[3]);
        this.velocityDefFP[0] = 0;
        this.velocityDefFP[1] = 0;
        this.accelerationBaseFP[0] = 0;
        this.accelerationBaseFP[1] = 0;
        this.decelerationBaseFP[0] = 0;
        this.decelerationBaseFP[1] = 0;
        this.vehicleVelocityDefFP[0] = 0;
        this.vehicleVelocityDefFP[1] = n11;
        this.vehicleVelocityMinFP[0] = -n15;
        this.vehicleVelocityMinFP[1] = n12;
        this.vehicleVelocityMaxFP[0] = n15;
        this.vehicleVelocityMaxFP[1] = n13;
        this.vehicleAccelerationFP[0] = n18;
        this.vehicleAccelerationFP[1] = n16;
        this.vehicleDecelerationFP[0] = n19;
        this.vehicleDecelerationFP[1] = n17;
        this.vehicleVelocityBoostFP[0] = 0;
        this.vehicleVelocityBoostFP[1] = n14;
        this.velocityDesiredFP[0] = 0;
        this.velocityDesiredFP[1] = 0;
        this.velocityMinFP[0] = 0;
        this.velocityMinFP[1] = 0;
        this.velocityMaxFP[0] = 0;
        this.velocityMaxFP[1] = 0;
        this.velocityBoostFP[0] = 0;
        this.velocityBoostFP[1] = 0;
        this.velocityFP[0] = 0;
        this.velocityFP[1] = 0;
        this.accelerationFP[0] = 0;
        this.accelerationFP[1] = 0;
        this.massFP = n20;
        this.objectCollisionFixTimeElapsedMS = 0;
        this.state = -1;
        this.mLeft = false;
        this.mRight = false;
        this.mUp = false;
        this.mDown = false;
        this.mFire = false;
        this.mGadget = false;
        this.invincible = false;
        this.invincibilityTimer = 0;
        this.crashTimer = 0;
        this.positionAfterJumpYFP = 0;
        this.ai.init(this, n21);
        this.maxHealthPoints = n7;
        this.setHealth(n7);
        this.vehicleHealth = n7;
        this.drawHealthBar = bl3;
        this.initNearestAirVehicleSensor();
        this.defaultWeapons[0] = n8;
        this.switchToDefaultWeapon(0);
        this.bombsToDrop = 0;
        this.defaultWeapons[1] = n9;
        this.switchToDefaultWeapon(1);
        this.boostFP = boostMaxFP;
        this.boostMinFP = BRCanvasMaths.Fdiv(boostMaxFP, 9216);
        switch (n) {
            case 2: {
                boostDrainPerSecondFP = 35840;
                boostRegeneratePerSecondFP = 10240;
                break;
            }
            case 3: {
                boostDrainPerSecondFP = 25600;
                boostRegeneratePerSecondFP = 5120;
            }
        }
        this.cameraBoostOffsetYFP = -3 * ResourceManager.map.getViewportHeightFP() / 100;
        this.cameraMaxOffsetYFP = 6 * ResourceManager.map.getViewportHeightFP() / 100;
        this.cameraDefOffsetYFP = 12 * ResourceManager.map.getViewportHeightFP() / 100;
        this.cameraMinOffsetYFP = 25 * ResourceManager.map.getViewportHeightFP() / 100;
        this.tileCollisionAnimationDrawX = 0;
        this.tileCollisionAnimationDrawY = 0;
        this.collidedWithTile = false;
        this.collisionDurability = n23;
        this.collisionDamage = n24;
        this.initCollisionSensors();
        this.missionMarker = -1;
        this.applySkills();
        this.velocityFP[1] = 0;
        this.velocityFP[0] = 0;
        this.velocityDesiredFP[0] = this.velocityDefFP[0];
        this.velocityDesiredFP[1] = this.velocityDefFP[1];
        this.stateSwitchTo(0, null);
    }

    public void deinit() {
    }

    public void update(int n) {
        super.update(n);
        int n2 = BRCanvasMaths.Fmul(BRCanvasMaths.iToF(n), 1);
        this.updateMarks();
        this.mUpPrev = this.mUp;
        this.crashTimer -= n;
        this.collisionDamageTimer -= n;
        this.timerAnimation -= n;
        this.ai.update(n);
        this.stateUpdate(this.state, n);
        if (this.isInvincible()) {
            if (this.invincibilityTimer > 5000) {
                this.setInvincible(false);
            } else {
                this.invincibilityTimer += n;
            }
        }
        this.updateBoost(n2);
        this.updateHelicopterRotor();
        this.updateVelocity(n2);
        this.updateAnimations();
        this.updateWeapons(n);
        this.updateGuns(n);
    }

    public void notifyAfterCollisionWithTile(int n, int n2, int n3) {
        super.notifyAfterCollisionWithTile(n, n2, n3);
        if (this.vehicleType == 2) {
            return;
        }
        block0 : switch (this.state) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 8: {
                break;
            }
            default: {
                if (!this.collidedWithTile) {
                    this.tileCollisionAnimationDrawX = this.drawX;
                    this.tileCollisionAnimationDrawY = this.drawY;
                    this.collidedWithTile = true;
                }
                switch (n3) {
                    case 2: {
                        if (this.crashTimer > 0) {
                            this.loseHealth(40, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(this.crashedById, this.crashedByRole));
                        } else {
                            this.loseHealth(40, false, 5, this.getuId(), -1);
                        }
                        if (this.isDead()) {
                            this.stateSwitchTo(4, null);
                            break block0;
                        }
                        this.stateSwitchTo(6, null);
                        break block0;
                    }
                    case 1: {
                        if (this.crashTimer > 0) {
                            this.loseHealth(2, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(this.crashedById, this.crashedByRole));
                        } else {
                            this.loseHealth(2, false, 5, this.getuId(), -1);
                        }
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 3: {
                        if (this.crashTimer > 0) {
                            this.loseHealth(2, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(this.crashedById, this.crashedByRole));
                        } else {
                            this.loseHealth(2, false, 5, this.getuId(), -1);
                        }
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 8: {
                        if (this.crashTimer > 0) {
                            this.loseHealth(0, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(this.crashedById, this.crashedByRole));
                        } else {
                            this.loseHealth(0, false, 5, this.getuId(), -1);
                        }
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 4: {
                        if (this.crashTimer > 0) {
                            this.loseHealth(0, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(this.crashedById, this.crashedByRole));
                        } else {
                            this.loseHealth(0, false, 5, this.getuId(), -1);
                        }
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                    }
                }
            }
        }
    }

    public void notifyAfterCollision(GameObject gameObject) {
        int n = gameObject.getRole();
        block0 : switch (this.state) {
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                switch (n) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 9: {
                        boolean bl;
                        this.ai.notifyAfterCollission((Vehicle)gameObject);
                        if (this.isInAir() || this.vehicleType == 2) break block0;
                        if (n == 2 && this.getRole() == 3 && this.spriteId != 143) {
                            this.crashTimer = 4500;
                            this.crashedById = gameObject.getuId();
                            this.crashedByRole = gameObject.getRole();
                        }
                        Vehicle vehicle = (Vehicle)gameObject;
                        if (!this.isOnTheLeftSideOf(gameObject) && !this.isOnTheRightSideOf(gameObject)) break block0;
                        boolean bl2 = bl = vehicle.isAtLeastTurningSpeedLevel(341) && (vehicle.isOnTheRightTo(this) && vehicle.isTurningLeft() || vehicle.isOnTheLeftTo(this) && vehicle.isTurningRight());
                        if (!bl) break block0;
                        boolean bl3 = this.isAtLeastTurningSpeedLevel(341) && (vehicle.isOnTheRightTo(this) && this.isTurningRight() || vehicle.isOnTheLeftTo(this) && this.isTurningLeft());
                        this.applyCollisionDamage(vehicle.getCollisionDamage(), bl3, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(vehicle.getuId(), vehicle.getRole()));
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 6: {
                        Pickup pickup = (Pickup)gameObject;
                        this.grabPickup(pickup.getPickupType());
                        break block0;
                    }
                    case 10: {
                        int n2;
                        if (this.isInAir()) break block0;
                        Breakable breakable = (Breakable)gameObject;
                        int n3 = breakable.getDamagePoints() * 1024;
                        int n4 = BRCanvasMaths.FToi(n3 = BRCanvasMaths.Fmul(n3, this.skills[11]));
                        int n5 = n2 = n4 > 0 ? n4 : -(this.maxHealthPoints * n4 / 100);
                        if (this.crashTimer > 0) {
                            this.loseHealth(n2, true, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(this.crashedById, this.crashedByRole));
                        } else {
                            this.loseHealth(n2, true, 5, this.getuId(), -1);
                        }
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 15: {
                        if (this.isInAir()) break block0;
                        this.velocityFP[1] = this.velocityDesiredFP[1] = this.velocityMinFP[1];
                        break block0;
                    }
                    case 8: {
                        if (this.isInAir()) break block0;
                        this.stateSwitchTo(1, null);
                        break block0;
                    }
                    case 17: {
                        if (this.isInAir()) break block0;
                        if (this.vehicleType == 1) {
                            this.stateSwitchTo(1, null);
                            break block0;
                        }
                        gameObject.excludeFromVisibilityCheckHint = true;
                        Explosion explosion = (Explosion)GameObjectManager.popReusableGameObject(3);
                        if (explosion == null) {
                            explosion = new Explosion(3);
                        }
                        explosion.init(gameObject.getPositionXFP(), gameObject.getPositionYFP(), this.drawingLayer + 6, -1, -1, gameObject);
                        this.loseHealth(60, true, 5, this.getuId(), -1);
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 1: {
                        Bullet bullet = (Bullet)gameObject;
                        if (this.state == 3 || this.state == 5 || bullet.getOwnerId() == this.getuId()) break block0;
                        int n6 = bullet.getWeapon();
                        int n7 = Game.EQUIPMENT_CONFIGURATION[n6][5] * 1024;
                        int n8 = bullet.getOwnerSkillDamage();
                        int n9 = BRCanvasMaths.FToi(BRCanvasMaths.Fmul(n8, n7));
                        this.loseHealth(n9, true, 10, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(bullet.getOwnerId(), bullet.getOwnerRole()));
                        if (!this.isDead()) break block0;
                        this.stateSwitchTo(4, null);
                        break block0;
                    }
                    case 14: {
                        Bullet bullet = (Bullet)gameObject;
                        if (bullet.getOwnerId() == this.getuId()) break block0;
                        switch (bullet.getWeapon()) {
                            case 6: {
                                break;
                            }
                            case 7: 
                            case 8: {
                                if (bullet.getWeapon() == 8) {
                                    this.applyCollisionDamage(12, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(bullet.getOwnerId(), bullet.getOwnerRole()));
                                } else {
                                    this.applyCollisionDamage(3, false, 13, Utils.packInts(this.getuId(), this.getRole()), Utils.packInts(bullet.getOwnerId(), bullet.getOwnerRole()));
                                }
                                if (!this.isDead()) break;
                                this.stateSwitchTo(4, null);
                            }
                        }
                        break block0;
                    }
                }
            }
        }
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        switch (this.state) {
            case 4: 
            case 5: 
            case 9: {
                this.drawVehicle(graphics, n, n2, n3, n4);
                break;
            }
            default: {
                if (this.spriteId == 134) {
                    this.drawVehicle(graphics, n, n2, n3, n4);
                    this.drawBoost(graphics, n, n2, n3, n4);
                } else {
                    this.drawBoost(graphics, n, n2, n3, n4);
                    this.drawVehicle(graphics, n, n2, n3, n4);
                }
                this.drawGuns(graphics);
                this.drawSmoke(graphics);
                this.drawSignalsAnimation(graphics);
                this.drawHelicopterRotor(graphics);
                this.drawTileCollisionAnimation(graphics);
                this.drawMissionMarker(graphics, n, n2, n3, n4);
                this.drawHealthBar(graphics);
                this.drawStealth(graphics);
            }
        }
        super.draw(graphics, n, n2, n3, n4);
    }

    public void wasAddedToGameWorld() {
        super.wasAddedToGameWorld();
        if (this.role == 2) {
            GameObjectManager.addGameObject(this.nearestAirVehicleSensor);
        }
        if (this.role != 2) {
            for (int i = 0; i < 2; ++i) {
                GameObjectManager.addGameObject(this.collisionSensors[i]);
            }
        }
    }

    public void wasRemovedFromGameWorld() {
        super.wasRemovedFromGameWorld();
        if (this.role != 2) {
            for (int i = 0; i < 2; ++i) {
                GameObjectManager.removeGameObject(this.collisionSensors[i]);
            }
        }
        if (this.role == 2) {
            GameObjectManager.removeGameObject(this.nearestAirVehicleSensor);
        }
    }

    public void deactivate() {
        super.deactivate();
        this.markForRemoval();
        if (!this.isDead()) {
            int n = ResourceManager.map.getCameraYFP() + ResourceManager.map.getViewportHeightFP() / 2;
            if (this.getPositionYFP() < n) {
                Game.sendEvent(8, this.getuId(), -1);
            } else if (this.getPositionYFP() > n) {
                Game.sendEvent(6, this.getuId(), -1);
            }
        }
    }

    protected void playAnimation(int n) {
        this.playAnimation(n, 0);
    }

    protected void playAnimation(int n, int n2) {
        if (this.spriteId == 137 || this.spriteId == 138) {
            n = 0;
        }
        if (this.timerAnimation > 0) {
            return;
        }
        if (this.currentAnimation != n) {
            this.currentAnimation = n;
            this.sprite.setCurrentFrame(Math.abs(n));
            this.timerAnimation = 200;
        }
    }

    protected void switchAnimation(int n) {
        if (this.timerAnimation > 0) {
            return;
        }
        if (this.currentAnimation != n) {
            if (this.spriteId == 137 || this.spriteId == 138) {
                n = 0;
            }
            this.sprite.setCurrentFrame(Math.abs(n));
            this.currentAnimation = n;
            this.timerAnimation = 200;
        }
    }

    protected void updateAnimations() {
        switch (this.state) {
            case 0: 
            case 6: {
                this.updateDrivingAnimation();
                break;
            }
            case 8: {
                break;
            }
            case 1: {
                this.playAnimation(2);
                break;
            }
            case 2: {
                this.playAnimation(2);
                break;
            }
            case 3: {
                this.playAnimation(2);
                break;
            }
            case 4: {
                this.playAnimation(3);
                break;
            }
            case 9: {
                this.playAnimation(3);
            }
        }
    }

    protected void updateDrivingAnimation() {
        if (this.velocityDesiredFP[0] < 0) {
            this.playAnimation(1);
        } else if (this.velocityDesiredFP[0] > 0) {
            this.playAnimation(-1);
        } else {
            this.playAnimation(0);
        }
    }

    private void updateHelicopterRotor() {
        if (this.vehicleType != 2 || this.getState() != 3) {
            // empty if block
        }
    }

    private void drawVehicle(Graphics graphics, int n, int n2, int n3, int n4) {
        this.sprite.render(this.currentAnimation < 0 ? 4 : 0, graphics, this.drawX, this.drawY, 3, n, n2, n3, n4);
    }

    private void drawHelicopterRotor(Graphics graphics) {
        if (this.vehicleType == 2) {
            int[] nArray = ROTOR_POINTS[this.currentRotorFrame];
            graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
            graphics.setColor(0x888888);
            for (int i = 0; i < nArray.length; i += 2) {
                graphics.drawLine(this.drawX, this.drawY + -10, this.drawX + nArray[i], this.drawY + nArray[i + 1] + -10);
            }
            ++this.currentRotorFrame;
            if (this.currentRotorFrame >= ROTOR_POINTS.length) {
                this.currentRotorFrame = 0;
            }
        }
    }

    private void drawTileCollisionAnimation(Graphics graphics) {
    }

    public void turnLeft() {
        this.velocityDesiredFP[0] = this.velocityMinFP[0];
    }

    public void turnRight() {
        this.velocityDesiredFP[0] = this.velocityMaxFP[0];
    }

    public void turnLeftImmediate() {
        this.turnLeft();
        if (this.velocityFP[0] > 0) {
            this.velocityFP[0] = 0;
        }
    }

    public void turnRightImmediate() {
        this.turnRight();
        if (this.velocityFP[0] < 0) {
            this.velocityFP[0] = 0;
        }
    }

    public boolean isTurningLeft() {
        return this.velocityFP[0] < 0;
    }

    public boolean isTurningRight() {
        return this.velocityFP[0] > 0;
    }

    public boolean isDrivingForward() {
        return this.velocityFP[1] > 0;
    }

    public boolean isDrivingBackward() {
        return this.velocityFP[1] < 0;
    }

    public void driveStraight() {
        this.velocityDesiredFP[0] = 0;
    }

    public void driveStraightImmediate() {
        this.accelerationFP[0] = 0;
        this.velocityDesiredFP[0] = 0;
        this.velocityFP[0] = 0;
    }

    public void accelerate() {
        this.velocityDesiredFP[1] = this.canUseBoost ? this.velocityBoostFP[1] : this.velocityMaxFP[1];
    }

    public void accelerateImmediate() {
        this.velocityDesiredFP[1] = this.canUseBoost ? this.velocityBoostFP[1] : this.velocityMaxFP[1];
        this.velocityFP[1] = this.velocityDesiredFP[1];
    }

    public void decelerateImmediate() {
        this.velocityFP[1] = this.velocityDesiredFP[1] = this.velocityMinFP[1];
    }

    public void decelerate() {
        this.velocityDesiredFP[1] = this.velocityMinFP[1];
    }

    public void stopImmediate() {
        this.accelerationFP[1] = 0;
        this.velocityFP[1] = 0;
        this.velocityDesiredFP[1] = 0;
    }

    public void stop() {
        this.velocityDesiredFP[1] = 0;
    }

    public void drawDefault() {
        this.velocityDesiredFP[1] = this.velocityDefFP[1];
    }

    public int[] getVelocity() {
        return this.velocityFP;
    }

    public int[] getMinVelocity() {
        return this.velocityMinFP;
    }

    public int[] getMaxVelocity() {
        return this.velocityMaxFP;
    }

    public int getMassFP() {
        return this.massFP;
    }

    public boolean isAtLeastTurningSpeedLevel(int n) {
        return Math.abs(this.velocityFP[0]) > BRCanvasMaths.Fmul(Math.abs(this.velocityMaxFP[0]), n);
    }

    protected void updateVelocity(int n) {
        switch (this.state) {
            case 4: 
            case 5: {
                break;
            }
            default: {
                for (int i = 0; i < 2; ++i) {
                    if (this.velocityFP[i] < this.velocityDesiredFP[i]) {
                        this.accelerationFP[i] = i == 0 && this.velocityDesiredFP[i] < 0 ? -this.decelerationBaseFP[i] : this.accelerationBaseFP[i];
                        int n2 = i;
                        this.velocityFP[n2] = this.velocityFP[n2] + BRCanvasMaths.Fmul(this.accelerationFP[i], n);
                        if (this.velocityFP[i] <= this.velocityDesiredFP[i]) continue;
                        this.velocityFP[i] = this.velocityDesiredFP[i];
                        continue;
                    }
                    if (this.velocityFP[i] <= this.velocityDesiredFP[i]) continue;
                    this.accelerationFP[i] = i == 0 && this.velocityDesiredFP[i] <= 0 ? -this.accelerationBaseFP[i] : this.decelerationBaseFP[i];
                    int n3 = i;
                    this.velocityFP[n3] = this.velocityFP[n3] + BRCanvasMaths.Fmul(this.accelerationFP[i], n);
                    if (this.velocityFP[i] >= this.velocityDesiredFP[i]) continue;
                    this.velocityFP[i] = this.velocityDesiredFP[i];
                }
                this.velocityFP[0] = Utils.clamp(this.velocityFP[0], this.velocityMinFP[0], this.velocityMaxFP[0]);
                this.setPositionXFP(this.getPositionXFP() + BRCanvasMaths.Fmul(this.velocityFP[0], n));
                this.setPositionYFP(this.getPositionYFP() - BRCanvasMaths.Fmul(this.velocityFP[1], n));
            }
        }
    }

    public void stateSwitchTo(int n, int[] nArray) {
        this.state = n;
        this.stateInitialize(this.state, nArray);
    }

    protected void stateInitialize(int n, int[] nArray) {
        switch (n) {
            case 1: {
                this.accelerationFP[0] = 0;
                this.velocityDesiredFP[0] = 0;
                this.velocityFP[0] = 0;
                this.driveStraight();
                if (this.velocityDesiredFP[1] < this.velocityMinFP[1]) {
                    this.velocityDesiredFP[1] = this.velocityMinFP[1];
                }
                int n2 = BRCanvasMaths.Fdiv(this.velocityFP[1] - this.velocityMinFP[1], this.velocityMaxFP[1]);
                int n3 = BRCanvasMaths.Fmul(n2, 2048);
                this.positionAfterJumpYFP = this.getPositionYFP() - (4096 + n3);
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                this.excludeFromCollisionCheckHint = true;
                if (this.role == 2) {
                    this.crashTimer = 2000;
                }
                this.resetAutofire(0);
                this.resetAutofire(1);
                Explosion explosion = (Explosion)GameObjectManager.popReusableGameObject(3);
                if (explosion == null) {
                    explosion = new Explosion(3);
                }
                explosion.init(this.getPositionXFP(), this.getPositionYFP(), this.drawingLayer + 6, -1, -1, this);
                GameObjectManager.addGameObject(explosion);
                this.drawingLayer = 40;
                this.driveStraightImmediate();
                this.stopImmediate();
                if (this.role != 3 && this.role != 4 && this.role != 9) break;
                this.markForRemoval();
                break;
            }
            case 9: {
                if (this.role == 2) {
                    this.crashTimer = 2000;
                }
                this.driveStraightImmediate();
                this.stopImmediate();
                if (this.role != 3 && this.role != 4 && this.role != 9) break;
                this.markForRemoval();
                Explosion explosion = (Explosion)GameObjectManager.popReusableGameObject(3);
                if (explosion == null) {
                    explosion = new Explosion(3);
                }
                explosion.init(this.getPositionXFP(), this.getPositionYFP(), this.drawingLayer + 6, -1, -1, this);
                GameObjectManager.addGameObject(explosion);
                break;
            }
            case 6: {
                this.decelerateImmediate();
                this.driveStraightImmediate();
                this.objectCollisionFixTimeElapsedMS = 0;
                break;
            }
            case 5: {
                if (this.role == 2) break;
                this.markForRemoval();
            }
        }
    }

    protected void stateUpdate(int n, int n2) {
        switch (n) {
            case 0: {
                if (this.mFire) {
                    this.fireWeapon();
                } else {
                    this.stopFiringWeapon();
                }
                if (this.mGadget) {
                    this.activateGadget();
                } else {
                    this.stopActivatingGadget();
                }
                if (this.mUp) {
                    this.accelerate();
                } else if (this.mDown) {
                    this.decelerate();
                } else {
                    this.drawDefault();
                }
                if (this.mLeft) {
                    this.turnLeft();
                    break;
                }
                if (this.mRight) {
                    this.turnRight();
                    break;
                }
                this.driveStraight();
                break;
            }
            case 4: {
                if (this.crashTimer >= 0) break;
                this.stateSwitchTo(5, null);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.driveStraight();
                this.stop();
                if (this.role != 2 || this.crashTimer >= 0) break;
                this.stateSwitchTo(5, null);
                break;
            }
            case 1: {
                this.stateSwitchTo(2, null);
                break;
            }
            case 2: {
                if (this.getPositionYFP() >= this.positionAfterJumpYFP) break;
                int n3 = 0;
                if (NineCanvas.currentQuickStoryLevel == 3 && this.role == 2 && (n3 = ResourceManager.map.mapYInTilesFromGlobalCoordinatesToTileMapCoordinates(this.getPositionYFP() / 1024)) < 12) {
                    this.excludeFromCollisionCheckHint = true;
                    if (n3 >= 7) break;
                    this.waveCounter = Integer.MAX_VALUE;
                    this.stateSwitchTo(0, null);
                    Game.handleEvent(2, 6, -1);
                    break;
                }
                this.setPositionYFP(this.positionAfterJumpYFP);
                this.stateSwitchTo(3, null);
                break;
            }
            case 3: {
                this.stateSwitchTo(0, null);
                break;
            }
            case 6: {
                if (this.isDead()) {
                    this.stateSwitchTo(4, null);
                    return;
                }
                this.velocityFP[1] = -2048;
                this.velocityDesiredFP[1] = -2048;
                this.driveStraightImmediate();
                this.objectCollisionFixTimeElapsedMS += n2;
                if (this.objectCollisionFixTimeElapsedMS < 1000) break;
                this.stateSwitchTo(0, null);
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean isInAir() {
        return this.state == 1 || this.state == 2 || this.state == 3;
    }

    public void setInput(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.mUp = bl;
        this.mDown = bl2;
        this.mLeft = bl3;
        this.mRight = bl4;
        this.mFire = bl5;
        this.mGadget = bl6;
    }

    private void initCollisionSensors() {
        int n = Utils.createFractionFP(1, 2);
        int n2 = Utils.createFractionFP(1, 2);
        this.collisionSensors[0].init(3, this);
        this.collisionSensors[0].setCollisionBoxFP(this.getCollisionBoxFP()[0] - 3072, this.getCollisionBoxFP()[1] - 3072, this.getCollisionBoxFP()[2] + 6144, 3072 + this.getCollisionBoxFP()[3] + n2);
        this.collisionSensors[0].setBoundsFP(this.getCollisionBoxFP()[0] - 3072, this.getCollisionBoxFP()[1] - 3072, this.getCollisionBoxFP()[2] + 6144, 3072 + this.getCollisionBoxFP()[3]);
        this.collisionSensors[1].init(2, this);
        this.collisionSensors[1].setCollisionBoxFP(this.getCollisionBoxFP()[0] - n, this.getCollisionBoxFP()[1] - 3072, this.getCollisionBoxFP()[2] + 2 * n, 3072 + this.getCollisionBoxFP()[3]);
        this.collisionSensors[1].setBoundsFP(this.getCollisionBoxFP()[0] - n, this.getCollisionBoxFP()[1] - 3072, this.getCollisionBoxFP()[2] + 2 * n, 3072 + this.getCollisionBoxFP()[3]);
    }

    public Sensor getSensor(int n) {
        return this.collisionSensors[n];
    }

    private void updateDestructionLevel() {
    }

    private void drawSmoke(Graphics graphics) {
    }

    public AI getAI() {
        return this.ai;
    }

    public void setAI(AI aI) {
        this.ai = aI;
    }

    public void loseHealth(int n, boolean bl, int n2, int n3, int n4) {
        if (this.isInvincible()) {
            return;
        }
        this.setHealth(this.getHealth() - n, bl);
        if (this.isDead()) {
            this.setHealth(0, bl);
            if (n2 != -1) {
                Game.sendEvent(n2, n3, n4);
            }
        }
    }

    public int getHealthPoints() {
        int n = this.getHealth();
        if (n > this.maxHealthPoints) {
            n = this.maxHealthPoints;
        }
        return n;
    }

    public int getArmorPoints() {
        int n = 0;
        if (this.hasArmor()) {
            n = this.getHealth() - this.maxHealthPoints;
        }
        return n;
    }

    public int getMaxArmorPoints() {
        return this.maxHealthPoints;
    }

    public boolean hasArmor() {
        return this.getHealth() > this.maxHealthPoints;
    }

    public int getMaxHealthPoints() {
        return this.maxHealthPoints;
    }

    protected void setHealth(int n, boolean bl) {
        this.health = n;
        if (bl) {
            this.updateDestructionLevel();
        }
    }

    protected void setHealth(int n) {
        this.setHealth(n, true);
    }

    protected int getHealth() {
        return this.health;
    }

    private void applyCollisionDamage(int n, boolean bl, int n2, int n3, int n4) {
        if (this.collisionDamageTimer <= 0) {
            int n5 = n * Utils.ceili(this.maxHealthPoints, this.collisionDurability);
            if (bl) {
                n5 /= 2;
            }
            this.loseHealth(n5, false, n2, n3, n4);
            this.collisionDamageTimer = 1000;
        }
    }

    public boolean isDead() {
        return this.getHealth() <= 0;
    }

    public int getCollisionDamage() {
        return this.collisionDamage;
    }

    public void grabPickup(int n) {
        if (Game.EQUIPMENT_CONFIGURATION[n][0] == 0) {
            this.pickWeapon(0, n, Game.EQUIPMENT_CONFIGURATION[n][4]);
            Game.hudWeaponGrabbed(n);
        } else if (Game.EQUIPMENT_CONFIGURATION[n][0] == 1) {
            this.pickWeapon(1, n, Game.EQUIPMENT_CONFIGURATION[n][4]);
            Game.hudGadgetGrabbed(n);
        } else {
            switch (n) {
                case 10: {
                    this.boostFP = boostMaxFP;
                    break;
                }
                case 11: {
                    this.setHealth(this.getHealth() + this.maxHealthPoints);
                    if (this.getHealth() <= this.getHealthPoints() + this.getMaxArmorPoints()) break;
                    this.setHealth(this.getHealthPoints() + this.getMaxArmorPoints());
                }
            }
        }
    }

    protected void pickWeapon(int n, int n2, int n3) {
        int n4 = n * 9;
        int n5 = this.weapons[n4 + 0];
        int n6 = this.defaultWeapons[n];
        if (n2 == n6) {
            if (n2 != n5) {
                this.switchToDefaultWeapon(n);
            }
        } else if (n2 == n5) {
            int n7 = n4 + 5;
            this.weapons[n7] = this.weapons[n7] + n3;
            this.weapons[n4 + 5] = Math.min(this.weapons[n4 + 5], Game.EQUIPMENT_CONFIGURATION[n5][1]);
        } else {
            this.switchToWeapon(n, n2);
            this.weapons[n4 + 5] = n3;
        }
    }

    public void fireWeapon() {
        this.processWeapon(0, 1, -1);
    }

    private void stopFiringWeapon() {
        this.processWeapon(0, 2, -1);
    }

    public void activateGadget() {
        this.processWeapon(1, 1, -1);
    }

    private void stopActivatingGadget() {
        this.processWeapon(1, 2, -1);
    }

    private void resetAutofire(int n) {
        this.processWeapon(n, 3, -1);
    }

    protected void switchToDefaultWeapon(int n) {
        this.switchToWeapon(n, this.defaultWeapons[n]);
        this.weapons[n * 9 + 5] = -1;
    }

    protected void switchToWeapon(int n, int n2) {
        int n3 = n * 9;
        this.unloadWeapon(this.weapons[n3 + 0]);
        this.weapons[n3 + 0] = n2;
        this.weapons[n3 + 5] = 0;
        this.weapons[n3 + 6] = 0;
        this.weapons[n3 + 7] = 0;
        this.weapons[n3 + 1] = 0;
        this.weapons[n3 + 2] = 0;
        this.processWeapon(n, -2, -1);
        this.loadWeapon(n2);
    }

    private void updateWeapons(int n) {
        for (int i = 0; i < 2; ++i) {
            this.processWeapon(i, 0, n);
            if (this.weapons[i * 9 + 1] != 3) continue;
            this.switchToDefaultWeapon(i);
        }
    }

    private void processWeapon(int n, int n2, int n3) {
        int n4 = n * 9;
        this.processWeaponState(n, this.weapons[n4 + 1], n2, n3);
        if (this.weapons[n4 + 2] == 1) {
            this.processWeaponState(n, this.weapons[n4 + 1], -1, -1);
            this.weapons[n4 + 1] = this.weapons[n4 + 3];
            this.weapons[n4 + 2] = 0;
            this.processWeaponState(n, this.weapons[n4 + 1], -2, this.weapons[n4 + 4]);
        }
    }

    private void processWeaponState(int n, int n2, int n3, int n4) {
        int n5 = n * 9;
        block0 : switch (this.weapons[n5 + 1]) {
            case 0: {
                switch (n3) {
                    case -2: {
                        break;
                    }
                    case 0: {
                        int n6 = n4;
                        if (this.weapons[n5 + 7] <= 0) {
                            if (this.isWeaponMagEmpty(n)) {
                                this.setWeaponState(n, 3, -1);
                            } else if (this.weapons[n5 + 6] > 0) {
                                int n7 = n5 + 6;
                                this.weapons[n7] = this.weapons[n7] - n6;
                            }
                        } else {
                            int n8 = n5 + 7;
                            this.weapons[n8] = this.weapons[n8] - n6;
                        }
                        this.updateWeapon(this.weapons[n5 + 0], n6);
                        break;
                    }
                    case 1: {
                        if (!this.isWeaponCool(n)) break;
                        this.setWeaponState(n, 1, -1);
                        break;
                    }
                }
                break;
            }
            case 1: {
                switch (n3) {
                    case -2: {
                        break block0;
                    }
                    case 0: {
                        int n9 = n4;
                        if (this.weapons[n5 + 7] <= 0) {
                            if (this.isWeaponMagEmpty(n)) {
                                this.setWeaponState(n, 3, -1);
                            } else if (this.weapons[n5 + 6] <= 0) {
                                this.shootFromWeapon(n);
                                int n10 = this.weapons[n5 + 0];
                                this.weapons[n5 + 7] = Game.EQUIPMENT_CONFIGURATION[n10][3];
                                this.weapons[n5 + 6] = Game.EQUIPMENT_CONFIGURATION[n10][2] * (this.getRole() == 2 ? 1 : 4);
                            } else {
                                int n11 = n5 + 6;
                                this.weapons[n11] = this.weapons[n11] - n9;
                            }
                        } else {
                            int n12 = n5 + 7;
                            this.weapons[n12] = this.weapons[n12] - n9;
                        }
                        this.updateWeapon(this.weapons[n5 + 0], n9);
                        break block0;
                    }
                    case 2: {
                        int n13 = this.weapons[n5 + 0];
                        if (this.role == 2 && Game.EQUIPMENT_CONFIGURATION[n13][11] == 1) {
                            this.setWeaponState(n, 2, -1);
                            break block0;
                        }
                        this.setWeaponState(n, 0, -1);
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (n3) {
                    case -2: {
                        this.weapons[n5 + 8] = 0;
                        break block0;
                    }
                    case 0: {
                        int n14 = n4;
                        if (this.weapons[n5 + 7] <= 0) {
                            if (this.isWeaponMagEmpty(n)) {
                                this.setWeaponState(n, 3, -1);
                            } else if (this.weapons[n5 + 8] >= Game.EQUIPMENT_CONFIGURATION[this.weapons[n5 + 0]][12]) {
                                if (this.role == 2) {
                                    this.setWeaponState(n, 0, -1);
                                } else {
                                    this.setWeaponState(n, 5, -1);
                                }
                            }
                            if (this.weapons[n5 + 6] <= 0) {
                                this.shootFromWeapon(n);
                                int n15 = n5 + 8;
                                this.weapons[n15] = this.weapons[n15] + 1;
                                int n16 = this.weapons[n5 + 0];
                                this.weapons[n5 + 7] = Game.EQUIPMENT_CONFIGURATION[n16][3];
                                this.weapons[n5 + 6] = Game.EQUIPMENT_CONFIGURATION[n16][2] * (this.getRole() == 2 ? 1 : 4);
                            } else {
                                int n17 = n5 + 6;
                                this.weapons[n17] = this.weapons[n17] - n14;
                            }
                        } else {
                            int n18 = n5 + 7;
                            this.weapons[n18] = this.weapons[n18] - n14;
                        }
                        this.updateWeapon(this.weapons[n5 + 0], n14);
                        break block0;
                    }
                    case 1: {
                        this.setWeaponState(n, 1, -1);
                        break block0;
                    }
                    case 3: {
                        this.setWeaponState(n, 0, -1);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case -2: {
                        break block0;
                    }
                    case 0: {
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void setWeaponState(int n, int n2, int n3) {
        int n4 = n * 9;
        this.weapons[n4 + 2] = 1;
        this.weapons[n4 + 3] = n2;
        this.weapons[n4 + 4] = n3;
    }

    private void shootFromWeapon(int n) {
        int n2 = n * 9;
        int n3 = this.weapons[n2 + 0];
        this.shootFromWeaponGuns(n3);
        if (this.weapons[n2 + 5] != -1) {
            int n4 = n2 + 5;
            this.weapons[n4] = this.weapons[n4] - 1;
        }
    }

    private boolean isWeaponMagEmpty(int n) {
        return this.weapons[n * 9 + 5] != -1 && this.weapons[n * 9 + 5] <= 0;
    }

    private void loadWeapon(int n) {
        switch (n) {
            case 3: {
                this.nearestAirVehicleSensor.setEnabled(true);
            }
        }
    }

    private void unloadWeapon(int n) {
        switch (n) {
            case 3: {
                this.nearestAirVehicleSensor.setEnabled(false);
            }
        }
    }

    private void updateWeapon(int n, int n2) {
        switch (n) {
            case 3: {
                this.updateNearestAirVehicleSensor();
                break;
            }
            case 5: {
                if (this.bombsToDrop <= 0) break;
                this.airstrikeTimer -= n2;
                if (this.airstrikeTimer >= 0) break;
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n3 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.shootFromGun(n, n3);
                }
                --this.bombsToDrop;
                this.airstrikeTimer = 250;
            }
        }
    }

    private boolean isWeaponCool(int n) {
        return this.weapons[n * 9 + 6] <= 0;
    }

    private void hideWeaponGuns(int n) {
        switch (n) {
            case 1: {
                int n2 = this.role == 2 || this.vehicleType == 1 ? 0 : (GameObjectManager.getGameTarget().getPositionXFP() < this.getPositionXFP() ? 1 : 2);
                int n3 = 14 + n2 * 2;
                int n4 = n3 + 2;
                for (int i = n3; i < n4; ++i) {
                    int n5 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.hideGun(n5);
                }
                break;
            }
            default: {
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n6 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.hideGun(n6);
                }
            }
        }
    }

    private void showWeaponGuns(int n) {
        switch (n) {
            case 1: {
                int n2 = this.role == 2 || this.vehicleType == 1 ? 0 : (GameObjectManager.getGameTarget().getPositionXFP() < this.getPositionXFP() ? 1 : 2);
                int n3 = 14 + n2 * 2;
                int n4 = n3 + 2;
                for (int i = n3; i < n4; ++i) {
                    int n5 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.showGun(n5);
                }
                break;
            }
            default: {
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n6 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.showGun(n6);
                }
            }
        }
    }

    private boolean weaponGunsReady(int n) {
        boolean bl = true;
        block0 : switch (n) {
            case 1: {
                int n2 = this.role == 2 || this.vehicleType == 1 ? 0 : (GameObjectManager.getGameTarget().getPositionXFP() < this.getPositionXFP() ? 1 : 2);
                int n3 = 14 + n2 * 2;
                int n4 = n3 + 2;
                for (int i = n3; i < n4; ++i) {
                    int n5 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    if (this.isGunReady(n5)) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            default: {
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n6 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    if (this.isGunReady(n6)) continue;
                    bl = false;
                    break block0;
                }
            }
        }
        return bl;
    }

    private boolean weaponGunsHidden(int n) {
        boolean bl = true;
        block0 : switch (n) {
            case 1: {
                int n2 = this.role == 2 || this.vehicleType == 1 ? 0 : (GameObjectManager.getGameTarget().getPositionXFP() < this.getPositionXFP() ? 1 : 2);
                int n3 = 14 + n2 * 2;
                int n4 = n3 + 2;
                for (int i = n3; i < n4; ++i) {
                    int n5 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    if (this.isGunHidden(n5)) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            default: {
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n6 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    if (this.isGunHidden(n6)) continue;
                    bl = false;
                    break block0;
                }
            }
        }
        return bl;
    }

    private void shootFromWeaponGuns(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n2 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.shootFromGun(n, n2);
                }
                break;
            }
            case 1: {
                if (this.role == 2 || this.vehicleType == 1) {
                    int n3 = 0;
                    int n4 = 14 + n3 * 2;
                    int n5 = n4 + 2;
                    for (int i = n4; i < n5; ++i) {
                        int n6 = Game.EQUIPMENT_CONFIGURATION[n][i];
                        this.shootFromGun(n, n6);
                    }
                } else {
                    int n7 = GameObjectManager.getGameTarget().getPositionXFP() < this.getPositionXFP() ? 1 : 2;
                    int n8 = 14 + n7 * 2;
                    int n9 = n8 + 2;
                    for (int i = n8; i < n9; ++i) {
                        int n10 = Game.EQUIPMENT_CONFIGURATION[n][i];
                        this.shootFromGun(n, n10);
                    }
                }
                break;
            }
            case 5: {
                this.bombsToDrop = 4;
                this.airstrikeTimer = -1;
                break;
            }
            case 9: {
                this.setInvincible(true);
                for (int i = 14; i < Game.EQUIPMENT_CONFIGURATION[n].length; ++i) {
                    int n11 = Game.EQUIPMENT_CONFIGURATION[n][i];
                    this.shootFromGun(n, n11);
                }
                break;
            }
        }
    }

    public int getLaserAnchorXFP(int n) {
        return n == -65536 ? this.getGunMarkerXFP(7) : this.getGunMarkerXFP(8);
    }

    public int getLaserAnchorYFP(int n) {
        return 0;
    }

    private void shootFromGun(int n, int n2) {
        Bullet bullet;
        int n3;
        if (this.isDead()) {
            return;
        }
        int n4 = Game.EQUIPMENT_CONFIGURATION[n][7];
        int n5 = Game.GUNS[n2][1];
        int n6 = Game.GUNS[n2][0];
        int n7 = this.getPositionXFP() + this.getGunMarkerXFP(n6);
        int n8 = this.getPositionYFP() + this.getGunMarkerYFP(n6);
        GameObject gameObject = null;
        if (this.nearestAirVehicleSensor.isEnabled() && (n3 = this.nearestAirVehicleSensor.getNearestObjectId()) != -1) {
            gameObject = GameObjectManager.getGameObject(n3);
        }
        if ((bullet = (Bullet)GameObjectManager.popReusableGameObject(2)) == null) {
            bullet = new Bullet(2);
        }
        bullet.init(n7, n8, this.drawingLayer + n4, n, n5, gameObject, this);
        GameObjectManager.addGameObject(bullet);
    }

    private int getGunMarkerXFP(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 -= this.getWidthFP() / 4;
                break;
            }
            case 2: {
                n2 += this.getWidthFP() / 4;
                break;
            }
            case 3: {
                n2 -= this.getWidthFP() / 4;
                break;
            }
            case 4: {
                n2 -= this.getWidthFP() / 4;
                break;
            }
            case 5: {
                n2 += this.getWidthFP() / 4;
                break;
            }
            case 6: {
                n2 += this.getWidthFP() / 4;
                break;
            }
            case 7: {
                n2 -= this.getWidthFP() / 2;
                break;
            }
            case 8: {
                n2 += this.getWidthFP() / 2;
                break;
            }
        }
        return n2;
    }

    private int getGunMarkerYFP(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                n2 -= this.getHeightFP() / 4;
                break;
            }
            case 4: {
                n2 += this.getHeightFP() / 4;
                break;
            }
            case 5: {
                n2 -= this.getHeightFP() / 4;
                break;
            }
            case 6: {
                n2 += this.getHeightFP() / 4;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                n2 += this.getWidthFP() / 4;
            }
        }
        if (this.spriteId == 134) {
            n2 -= this.getHeightFP() / 2;
        }
        return n2;
    }

    private void updateGuns(int n) {
    }

    private void drawGuns(Graphics graphics) {
    }

    private void showGun(int n) {
        this.processGun(n, 1, -1);
    }

    private void hideGun(int n) {
        this.processGun(n, 2, -1);
    }

    private boolean isGunReady(int n) {
        return true;
    }

    private boolean isGunHidden(int n) {
        return false;
    }

    private void processGun(int n, int n2, int n3) {
    }

    private void processGunState(int n, int n2, int n3, int n4) {
    }

    private void setGunState(int n, int n2, int n3) {
        this.guns[n * 4 + 1] = 1;
        this.guns[n * 4 + 2] = n2;
        this.guns[n * 4 + 3] = n3;
    }

    private void initNearestAirVehicleSensor() {
        this.nearestAirVehicleSensor.init(1, this);
        this.updateNearestAirVehicleSensor();
        if (this.getWeapon() == 3) {
            this.nearestAirVehicleSensor.setEnabled(true);
        } else {
            this.nearestAirVehicleSensor.setEnabled(false);
        }
    }

    private void updateNearestAirVehicleSensor() {
        if (this.nearestAirVehicleSensor.isEnabled()) {
            int n = ResourceManager.map.getViewportWidthFP();
            int n2 = Math.abs(ResourceManager.map.getCameraYFP() - (this.getPositionYFP() + this.getCollisionBoxFP()[1]));
            int n3 = -(n / 2);
            int n4 = ResourceManager.map.getCameraYFP() - this.getPositionYFP();
            this.nearestAirVehicleSensor.setCollisionBoxFP(n3, n4, n, n2);
            this.nearestAirVehicleSensor.setBoundsFP(n3, n4, n, n2);
        }
    }

    public int getWeapon() {
        return this.weapons[0];
    }

    public int getWeaponAmmo() {
        return this.weapons[5];
    }

    public int getGadget() {
        return this.weapons[9];
    }

    public int getGadgetAmmo() {
        return this.weapons[14];
    }

    public void setInvincible(boolean bl) {
        this.invincible = bl;
        this.invincibilityTimer = 0;
    }

    public boolean isInvincible() {
        return this.invincible;
    }

    protected void updateBoost(int n) {
        if (this.mUp && this.canUseBoost) {
            this.boostFP -= BRCanvasMaths.Fmul(n, boostDrainPerSecondFP);
            this.drawBoost = this.role == 2;
        } else {
            this.boostFP += BRCanvasMaths.Fmul(n, boostRegeneratePerSecondFP);
            this.drawBoost = false;
        }
        this.boostFP = Utils.clamp(this.boostFP, 0, boostMaxFP);
        if (!this.mUpPrev && this.mUp && this.boostFP > this.boostMinFP) {
            this.canUseBoost = true;
        }
        if (this.boostFP == 0 || this.state == 4 || this.state == 5) {
            this.canUseBoost = false;
            this.drawBoost = false;
        }
        if (this.drawBoost) {
            this.spriteBoost.update();
        }
    }

    private void drawStealth(Graphics graphics) {
        if (this.isInvincible()) {
            graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
            graphics.setColor(0xFFFF00);
            int[] nArray = STEALTH_VERTICES[this.stealthFrame];
            for (int i = 2; i < nArray.length; i += 2) {
                graphics.drawLine(nArray[i] + this.drawX, nArray[i + 1] + this.drawY, nArray[i - 2] + this.drawX, nArray[i - 1] + this.drawY);
            }
            graphics.drawLine(nArray[0] + this.drawX, nArray[1] + this.drawY, nArray[10] + this.drawX, nArray[11] + this.drawY);
            if (this.invincibilityTimer / 224 % 2 == 0) {
                ++this.stealthFrame;
                if (this.stealthFrame >= STEALTH_VERTICES.length) {
                    this.stealthFrame = 0;
                }
            }
        }
    }

    private void drawBoost(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.drawBoost && (!this.isInvincible() || this.invincibilityTimer / 224 % 2 != 0)) {
            int n5 = this.spriteId == 139 || this.spriteId == 141 ? 4 : 3;
            int n6 = 0;
            n6 = this.spriteId == 134 ? (this.sprite.getBoundsWidth(0) - this.spriteBoost.getFrameWidth()) / 2 : 0;
            this.spriteBoost.render(graphics, this.drawX - n6, this.drawY + this.sprite.getFrameHeight() / n5, 17, n, n2, n3, n4);
        }
    }

    public boolean canUseBoost() {
        return this.canUseBoost;
    }

    public int getBoostFP() {
        return this.boostFP;
    }

    public int getBoostMaxFP() {
        return boostMaxFP;
    }

    private void updateMarks() {
    }

    public void drawMarks(Graphics graphics) {
    }

    private void setBestCoordinatesToRespawn() {
    }

    public void respawn() {
        this.setBestCoordinatesToRespawn();
        this.stateSwitchTo(0, null);
        this.setHealth(this.maxHealthPoints);
        int n = this.uId;
        Map.initBondVehicle(Map.bondVehicleId, this.getPositionXFP(), this.getPositionYFP(), this);
        this.uId = n;
        this.shootFromWeaponGuns(9);
    }

    public void tryToSetDestroyMissionMarker() {
        if (this.missionMarkerFlag && Game.insertMarkedEnemy(this.spriteId)) {
            this.missionMarker = 0;
        }
    }

    private void drawMissionMarker(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.missionMarker != -1) {
            Game.hudMark.render(graphics, this.drawX, this.drawY, 3, n, n2, n3, n4);
        }
    }

    private void drawHealthBar(Graphics graphics) {
        if (this.drawHealthBar) {
            int n = Utils.ceili(this.getHealth() * 10, this.getMaxHealthPoints());
            int n2 = 41;
            int n3 = 5;
            int n4 = this.drawX - n2 / 2;
            int n5 = this.drawY - n3 / 2;
            graphics.setColor(0);
            graphics.fillRect(n4, n5, n2, n3);
            ++n4;
            ++n5;
            for (int i = 0; i < 10; ++i) {
                int n6 = i < n ? 0xFF0000 : 0x550000;
                graphics.setColor(n6);
                graphics.fillRect(n4, n5, 3, 3);
                n4 += 4;
            }
        }
    }

    private void drawSignalsAnimation(Graphics graphics) {
    }

    public void setSignalLeft(boolean bl) {
    }

    public void setSignalRight(boolean bl) {
    }

    protected void applySkills() {
        this.velocityDefFP[0] = BRCanvasMaths.Fmul(this.vehicleVelocityDefFP[0], this.skills[0]);
        this.velocityDefFP[1] = BRCanvasMaths.Fmul(this.vehicleVelocityDefFP[1], this.skills[0]);
        this.accelerationBaseFP[0] = BRCanvasMaths.Fmul(this.vehicleAccelerationFP[0], this.skills[7]);
        this.accelerationBaseFP[1] = BRCanvasMaths.Fmul(this.vehicleAccelerationFP[1], this.skills[5]);
        this.decelerationBaseFP[0] = BRCanvasMaths.Fmul(this.vehicleDecelerationFP[0], this.skills[8]);
        this.decelerationBaseFP[1] = BRCanvasMaths.Fmul(this.vehicleDecelerationFP[1], this.skills[6]);
        this.velocityMinFP[0] = BRCanvasMaths.Fmul(this.vehicleVelocityMinFP[0], this.skills[4]);
        this.velocityMinFP[1] = BRCanvasMaths.Fmul(this.vehicleVelocityMinFP[1], this.skills[1]);
        this.velocityMaxFP[0] = BRCanvasMaths.Fmul(this.vehicleVelocityMaxFP[0], this.skills[4]);
        this.velocityMaxFP[1] = BRCanvasMaths.Fmul(this.vehicleVelocityMaxFP[1], this.skills[2]);
        this.velocityBoostFP[0] = BRCanvasMaths.Fmul(this.vehicleVelocityBoostFP[0], this.skills[3]);
        this.velocityBoostFP[1] = BRCanvasMaths.Fmul(this.vehicleVelocityBoostFP[1], this.skills[3]);
        int n = Utils.createFractionFP(this.getHealth(), this.maxHealthPoints);
        this.maxHealthPoints = BRCanvasMaths.Fmul(this.vehicleHealth * 1024, this.skills[9]);
        this.setHealth(BRCanvasMaths.Fmul(n, this.maxHealthPoints));
        this.maxHealthPoints = BRCanvasMaths.FToi(this.maxHealthPoints);
        this.setHealth(Math.min(BRCanvasMaths.FToi(this.getHealth()) + 1, this.maxHealthPoints));
    }

    public int getCameraPositionYFP() {
        switch (this.state) {
            case 4: {
                return this.getPositionYFP();
            }
        }
        if (this.velocityDesiredFP[1] == this.velocityMinFP[1]) {
            return this.getPositionYFP() - this.cameraMinOffsetYFP;
        }
        if (this.velocityDesiredFP[1] == this.velocityDefFP[1]) {
            return this.getPositionYFP() - this.cameraDefOffsetYFP;
        }
        if (this.velocityDesiredFP[1] == this.velocityMaxFP[1]) {
            return this.getPositionYFP() - this.cameraMaxOffsetYFP;
        }
        return this.getPositionYFP() - this.cameraBoostOffsetYFP;
    }

    public boolean isAirVehicle() {
        return this.vehicleType == 2;
    }

    public boolean isLandVehicle() {
        return this.vehicleType != 2;
    }

    public int getAnimationsetId() {
        return this.spriteId;
    }

    static {
        ROTOR_POINTS = new int[][]{{-30, -14, 30, 14, 0, 30}, {-17, -22, 36, 0, -17, -22}, {0, -29, -33, 17, 33, 17}, {-34, 0, 17, -22, 17, 22}};
        STEALTH_VERTICES = new int[][]{{0, 12, 10, 6, 10, -5, 0, -12, -10, -6, -10, 6}, {0, 16, 13, 8, 13, -7, 0, -16, -13, -8, -13, 8}, {0, 20, 17, 10, 17, -9, 0, -20, -17, -10, -17, 10}};
    }
}

