/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.microedition.lcdui.Graphics;

public class Debug {
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_ALL = -1;
    public static final int DRAW_COLLISION_BOXES = 2;
    public static final int DRAW_HERO_VECTORS = 4;
    public static final int DRAW_FPS = 8;
    public static final int DRAW_MESSAGES = 16;
    public static final int DRAW_BENCHMARKS = 32;
    public static final int DRAW_TOUCH_REGIONS = 64;
    public static final int DRAW_KEY_CODES = 128;
    public static final int DRAW_VIBRATION = 256;
    public static final int DEBUG_USED_MEMORY = 512;
    public static final int DRAW_TILESET_BOXES = 1024;
    public static final int DRAW_TILE_COLLISION_PART = 2048;
    public static final int DRAW_TILE_COLLISION_PART_TRANSPARENT = 4096;
    public static final int DEBUG_LOG_MESSAGES = 8192;
    public static final int DEBUG_DISABLE_CUTSCENES = 16384;
    public static final int DEBUG_DRAW_USED_GRAPHICS = 32768;
    public static final int DEBUG_BACK_BUFFER = 65536;
    public static final int DEBUG_SENSORS = 131072;
    public static final int DEBUG_ADDING_RESOURCES = 262144;
    public static final int DEBUG_CUTSCENES = 524288;
    public static final int DEBUG_OBJECT_ALLOCATION = 0x100000;
    public static final int DEBUG_GAME_OBJECT_MANAGER = 0x200000;
    public static final int debugLevel = 0;
    private static final int BENCHMARKS_SAMPLING_TIME = 1000;
    private static long benchmarkStartTime;
    private static int benchmarkCurrentLoopsCount;
    private static int benchmarkLoopsCount;
    private static int benchmarkCurrentRenderCount;
    private static int benchmarkRenderCount;
    private static Hashtable benchmarks;
    private static Stack activeBenchmarks;
    private static String[] debugMessages;

    public static void initFields() {
        benchmarks = new Hashtable();
        activeBenchmarks = new Stack();
        debugMessages = new String[30];
    }

    public static void startBenchmark(String string) {
    }

    public static void stopBenchmark() {
    }

    public static void updateBenchmarks() {
    }

    private static int drawBenchmarks(Graphics graphics, int n) {
        graphics.setColor(0xFFFFFF);
        int n2 = benchmarkLoopsCount * 1000 / 1000;
        int n3 = benchmarkRenderCount * 1000 / 1000;
        graphics.setColor(0xFFFFFF);
        graphics.drawString("U: " + n2 + " R: " + n3 + " T: " + 1000, 0, n, 20);
        if (n2 < 18) {
            graphics.setColor(0xFF00FF);
            graphics.drawString("VERY SLOW!", NineCanvas.SCREEN_WIDTH, n, 24);
        } else if (n3 < n2) {
            graphics.setColor(0xFF00FF);
            graphics.drawString("SLOW!", NineCanvas.SCREEN_WIDTH, n, 24);
        }
        n += graphics.getFont().getHeight() + 1;
        graphics.setColor(0xFFFFFF);
        Enumeration enumeration = benchmarks.elements();
        while (enumeration.hasMoreElements()) {
            Benchmark benchmark = (Benchmark)enumeration.nextElement();
            graphics.drawString(benchmark.summary(), 0, n, 20);
            graphics.drawString(benchmark.statistics(), 0, n += graphics.getFont().getHeight() + 1, 20);
            n += graphics.getFont().getHeight() + 1;
        }
        ++benchmarkCurrentRenderCount;
        return n;
    }

    public static void render(Graphics graphics) {
    }

    public static void setDebugMessage(int n, String string) {
        Debug.debugMessages[n] = string;
    }

    public static void log(String string, String string2) {
    }
}

