/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Breakable
extends GameObject {
    private int healthPoints;
    private int damagePoints;
    protected int pixtoolParam1;
    protected int pixtoolParam2;
    protected int pixtoolType;
    protected int breakingAnimationsetId;
    protected int breakingAnimationId;

    protected Breakable(int n) {
        super(n);
    }

    public void init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int n9, int n10, int n11) {
        super.init(n, n2, n3, n4, nArray);
        this.healthPoints = n9;
        this.damagePoints = n8;
        this.pixtoolType = n5;
        this.pixtoolParam1 = n6;
        this.pixtoolParam2 = n7;
        this.breakingAnimationsetId = n10;
        this.breakingAnimationId = n11;
        GameObject.auxiliaryRect = Game.spriteBreakables.getBounds(GameObject.auxiliaryRect, n7);
        this.setCollisionBox(GameObject.auxiliaryRect[0], GameObject.auxiliaryRect[1], GameObject.auxiliaryRect[2], GameObject.auxiliaryRect[3]);
        this.setBounds(GameObject.auxiliaryRect[0], GameObject.auxiliaryRect[1], GameObject.auxiliaryRect[2], GameObject.auxiliaryRect[3]);
    }

    public void deinit() {
    }

    public void notifyAfterCollision(GameObject gameObject) {
        if (gameObject.isVehicle()) {
            Vehicle vehicle = (Vehicle)gameObject;
            if (!vehicle.isInAir()) {
                this.loseHealth(this.healthPoints);
                if (this.healthPoints <= 0) {
                    this.markForRemoval();
                    this.explode();
                }
            }
        } else if (gameObject.getRole() == 1) {
            Bullet bullet = (Bullet)gameObject;
            int n = bullet.getWeapon();
            int n2 = Game.EQUIPMENT_CONFIGURATION[n][5] * 1024;
            int n3 = bullet.getOwnerSkillDamage();
            int n4 = BRCanvasMaths.FToi(BRCanvasMaths.Fmul(n3, n2));
            this.loseHealth(n4);
            if (this.healthPoints <= 0) {
                this.markForRemoval();
                this.explode();
            }
        }
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        Game.spriteBreakables.render(graphics, this.drawX, this.drawY, 20, this.pixtoolParam2, n, n2, n3, n4);
        super.draw(graphics, n, n2, n3, n4);
    }

    public void loseHealth(int n) {
        this.healthPoints -= n;
    }

    private void explode() {
        Explosion explosion = (Explosion)GameObjectManager.popReusableGameObject(3);
        if (explosion == null) {
            explosion = new Explosion(3);
        }
        explosion.init(this.getCenterXFP(), this.getCenterYFP(), this.drawingLayer + 6, this.breakingAnimationsetId, this.breakingAnimationId, this);
        GameObjectManager.addGameObject(explosion);
    }

    public int getHealthPoints() {
        return this.healthPoints;
    }

    public int getDamagePoints() {
        return this.damagePoints;
    }
}

