/*
 * Decompiled with CFR 0.152.
 */
class Benchmark {
    private String name;
    private long startTime;
    private int currentFrameDuration;
    private int currentFrameInvocations;
    private int currentSamplingTimeOverallDuration;
    private int currentSamplingTimeOverallInvocations;
    private int currentSamplingTimeMaxDuration;
    private int currentSamplingTimeMaxInvocations;
    private int overallDuration;
    private int overallInvocations;
    private int maxDurationPerFrame;
    private int maxInvocationsPerFrame;
    private int averageDurationPerFrame;
    private int averageInvocationsPerFrame;

    public Benchmark(String string) {
        this.name = string;
    }

    public void start(long l) {
        this.startTime = l;
    }

    public void stop(long l) {
        long l2 = l - this.startTime;
        this.currentFrameDuration = (int)((long)this.currentFrameDuration + l2);
        ++this.currentFrameInvocations;
    }

    public void updatePerFrame() {
        this.currentSamplingTimeMaxDuration = Math.max(this.currentSamplingTimeMaxDuration, this.currentFrameDuration);
        this.currentSamplingTimeMaxInvocations = Math.max(this.currentSamplingTimeMaxInvocations, this.currentFrameInvocations);
        this.currentSamplingTimeOverallDuration += this.currentFrameDuration;
        this.currentSamplingTimeOverallInvocations += this.currentFrameInvocations;
        this.currentFrameDuration = 0;
        this.currentFrameInvocations = 0;
    }

    public void updatePerSamplingTime(int n) {
        this.overallDuration = this.currentSamplingTimeOverallDuration;
        this.overallInvocations = this.currentSamplingTimeOverallInvocations;
        this.maxDurationPerFrame = Math.max(this.maxDurationPerFrame, this.currentSamplingTimeMaxDuration);
        this.maxInvocationsPerFrame = Math.max(this.maxInvocationsPerFrame, this.currentSamplingTimeMaxInvocations);
        this.averageDurationPerFrame = this.currentSamplingTimeOverallInvocations == 0 ? 0 : this.currentSamplingTimeOverallDuration / this.currentSamplingTimeOverallInvocations;
        this.averageInvocationsPerFrame = n == 0 ? 0 : this.currentSamplingTimeOverallInvocations / n;
        this.currentSamplingTimeOverallDuration = 0;
        this.currentSamplingTimeOverallInvocations = 0;
        this.currentSamplingTimeMaxDuration = 0;
        this.currentSamplingTimeMaxInvocations = 0;
    }

    public void resetMax() {
        this.maxDurationPerFrame = 0;
        this.maxInvocationsPerFrame = 0;
    }

    public String summary() {
        return this.name + ": " + this.overallInvocations + "x/" + this.overallDuration + "ms";
    }

    public String statistics() {
        return "  avg " + this.averageDurationPerFrame + "(" + this.maxDurationPerFrame + ")ms " + this.averageInvocationsPerFrame + "(" + this.maxInvocationsPerFrame + ")x";
    }
}

