/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    private byte[] mapGraphicBackgroundData;
    public short[] collisionData;
    private int tilesetImageId = -1;
    private int tilesetColumns;
    private int mapWidthInTiles;
    private int mapHeightInTiles;
    public int[] decorationsData;
    public int[] decorationsDataTilemapSegmentsInfo;
    public static final int DECORATION_DATA_SIZE = 5;
    public static final int DECORATION_DATA_IDX_X_IN_TILES = 0;
    public static final int DECORATION_DATA_IDX_Y_IN_TILES = 1;
    public static final int DECORATION_DATA_IDX_ID = 2;
    public static final int DECORATION_DATA_IDX_WIDTH = 3;
    public static final int DECORATION_DATA_IDX_HEIGHT = 4;
    public int maxDecorationWidthInTiles;
    public int maxDecorationHeightInTiles;
    public static final int GAME_OBJECT_DATA_SIZE = 3;
    public static final int GAME_OBJECT_DATA_IDX_OBJECT_TYPE = 0;
    public static final int GAME_OBJECT_DATA_IDX_TILE_X = 1;
    public static final int GAME_OBJECT_DATA_IDX_TILE_Y = 2;
    private short[][] gameObjectsData;
    private int[] gameObjectsDataTilemapSegmentsInfo;
    private byte[][] gameObjectsParameters;
    private int gameObjectsCount;
    private int maxGameObjectsInTilemapSegment;
    public static final int MAP_SEGMENT_SIZE = 4;
    public static final int MAP_SEGMENT_IDX_Y_IN_TILES = 0;
    public static final int MAP_SEGMENT_IDX_LENGTH_IN_TILES = 1;
    public static final int MAP_SEGMENT_IDX_PARAM_1 = 2;
    public static final int MAP_SEGMENT_IDX_PARAM_2 = 3;
    private int[] tilemapSegmentsInfo;
    private int[] mapSegments;
    private int frontMapSegmentYInTiles;
    private int frontMapSegmentLength;
    private int frontMapSegmentTilemapSegmentYInTiles;
    private int lastSegmentTilemapObject;
    private int maxSegmentObjectHeightInTiles;
    private static final int PLAYER_SP_DATA_SIZE = 2;
    private static final int PLAYER_SP_DATA_IDX_X_IN_MAP_COORDINATES = 0;
    private static final int PLAYER_SP_DATA_IDX_Y_IN_MAP_COORDINATES = 1;
    private int[] playerSpData;
    public static int bondVehicleId;
    public static int DEFAULT_DISTANCE_TOLERANCE_FP;
    private int cameraX;
    private int cameraXFP;
    private int cameraY;
    private int cameraYFP;
    private int viewportWidth;
    private int viewportWidthFP;
    private int viewportHeight;
    private int viewportHeightFP;
    private int viewportX;
    private int viewportY;
    private int[] cameraVelocityFP;
    private int constraintTopFP;
    private int constraintBottomFP;
    private int constraintLeftFP;
    private int constraintRightFP;
    private boolean cameraMoving;
    private boolean cameraReachedObject;
    private GameObject gameObjectLockedOn;
    private int offsetX = 0;
    private int offsetY = 0;
    private static Image backBufferImage;
    private Image backBufferDebugImage;
    private Graphics backBuffer;
    private boolean repaintBackground = true;
    private int cameraXOld;
    private int cameraYOld;
    private int[] maxReusableObjectsInSegment;
    private int mapId;
    private byte[] mapLoadingData;
    private boolean mapLoaded;
    private int mapLoadingStep;
    private static final int mapLoadingMaxStep = 11;
    private int noOfLayers;
    private int offset = 0;

    public static void initFields() {
        DEFAULT_DISTANCE_TOLERANCE_FP = 256;
    }

    public void initialize() {
        this.generateReusables();
    }

    public void update(int n) {
        this.updateViewport(n);
        int n2 = Utils.floori(this.cameraY, 14);
        int n3 = this.viewportHeight / 14;
        this.segmentsUpdate(this.cameraY, this.viewportHeight, n2, n3);
        GameObjectManager.update(n);
    }

    public void render(Graphics graphics) {
        if (NineCanvas.useDoubleBuffer) {
            this.renderToBackBuffer(this.cameraX, this.cameraY, this.viewportWidth, this.viewportHeight);
            this.renderBackBufferToScreen(graphics, this.viewportX, this.viewportY);
        } else {
            this.renderMap(graphics, this.viewportX, this.viewportY, this.cameraX, this.cameraY, this.viewportWidth, this.viewportHeight);
        }
        GameObjectManager.render(graphics);
    }

    private void renderMap(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if (NineCanvas.useDoubleBuffer) {
            // empty if block
        }
        int n7 = n;
        int n8 = n2;
        int n9 = n5;
        int n10 = n6;
        int n11 = Utils.floori(n3, 14);
        int n12 = Utils.floori(n4, 14);
        int n13 = Utils.ceili(n3 + n5, 14);
        int n14 = Utils.ceili(n4 + n6, 14);
        int n15 = n13 - n11;
        int n16 = n14 - n12;
        int n17 = Utils.positiveModulo(n3, 14);
        int n18 = Utils.positiveModulo(n4, 14);
        this.drawSegments(graphics, n -= n17, n2 -= n18, n11, n12, n15, n16, n7, n8, n9, n10);
    }

    private void drawSegments(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        boolean bl = false;
        int n11 = this.frontMapSegmentYInTiles;
        int n12 = Utils.vectorSize(this.mapSegments);
        while (--n12 >= 0 && !bl) {
            int n13 = this.mapSegments[n12];
            int n14 = this.tilemapSegmentsInfo[n13 * 4 + 1];
            if (n11 + n14 - 1 >= n4) {
                if (n11 >= n4 + n6) {
                    bl = true;
                } else {
                    int n15;
                    int n16;
                    boolean bl2;
                    int n17 = this.tilemapSegmentsInfo[n13 * 4 + 0];
                    int n18 = n2;
                    int n19 = n17;
                    int n20 = n14;
                    boolean bl3 = bl2 = n11 < n4;
                    if (bl2) {
                        n16 = n4 - n11;
                        n19 += n16;
                        n20 -= n16;
                    }
                    int n21 = n16 = n11 > n4 ? 1 : 0;
                    if (n16 != 0) {
                        n15 = n11 - n4;
                        n18 += n15 * 14;
                    }
                    int n22 = n15 = n11 + n14 > n4 + n6 ? 1 : 0;
                    if (n15 != 0) {
                        int n23 = n11 + n14 - (n4 + n6);
                        n20 -= n23;
                    }
                    this.drawTileMap(graphics, n, n18, n3, n19, n5, n20, n7, n8, n9, n10, this.mapGraphicBackgroundData);
                    this.drawDecorations(graphics, n, n18, n3, n19, n5, n20, n7, n8, n9, n10, n13);
                }
            }
            n11 += n14;
        }
    }

    private void drawTileMap(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, byte[] byArray) {
        int n11 = n2;
        int n12 = n4 * this.mapWidthInTiles;
        int n13 = (n4 + n6) * this.mapWidthInTiles;
        int n14 = n3 + n5;
        int n15 = n3;
        for (int i = n12; i < n13; i += this.mapWidthInTiles) {
            int n16 = n;
            for (int j = n15; j < n14; ++j) {
                this.drawTile(graphics, n16, n11, n7, n8, n9, n10, byArray[i + j]);
                n16 += 14;
            }
            n11 += 14;
        }
    }

    private void drawDecorations(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        int n13;
        Utils.auxRect = Utils.fillRect(Utils.auxRect, n7, n8, n9, n10);
        if ((Utils.auxRect = Utils.intersection(Utils.auxRect, n, n2, n5 * 14, n6 * 14))[2] == 0 || Utils.auxRect[3] == 0) {
            return;
        }
        n5 += this.maxDecorationWidthInTiles;
        n6 += this.maxDecorationHeightInTiles;
        n -= this.maxDecorationWidthInTiles * 14;
        n2 -= this.maxDecorationHeightInTiles * 14;
        for (int i = n12 = this.findFirstDecorationInSegment(n11, n3 -= this.maxDecorationWidthInTiles, n4 -= this.maxDecorationHeightInTiles); i >= this.decorationsDataTilemapSegmentsInfo[n11] && (n13 = this.decorationsData[i + 1]) <= n4 + n6; i -= 5) {
            int n14;
            if (n13 < n4 || (n14 = this.decorationsData[i + 0]) < n3 || n14 >= n3 + n5) continue;
            int n15 = n + (n14 - n3) * 14;
            int n16 = n2 + (n13 - n4) * 14;
            int n17 = this.decorationsData[i + 3];
            int n18 = this.decorationsData[i + 4];
            if (n15 + n17 <= Utils.auxRect[0] || n16 + n18 <= Utils.auxRect[1]) continue;
            int n19 = this.decorationsData[i + 2];
            this.drawDecoration(graphics, n19, n15, n16, n7, n8, n9, n10);
        }
    }

    public int findFirstDecorationInSegment(int n, int n2, int n3) {
        int n4 = this.decorationsDataTilemapSegmentsInfo[n];
        int n5 = this.decorationsDataTilemapSegmentsInfo[n + 1] - 5;
        while (n4 <= n5) {
            int n6;
            int n7 = n4 + n5 >>> 1;
            if ((n6 = this.decorationsData[(n7 -= n7 % 5) + 1]) < n3) {
                n5 = n7 - 5;
                continue;
            }
            if (n6 > n3) {
                n4 = n7 + 5;
                continue;
            }
            int n8 = this.decorationsData[n7 + 0];
            if (n8 < n2) {
                n5 = n7 - 5;
                continue;
            }
            if (n8 > n2) {
                n4 = n7 + 5;
                continue;
            }
            return n7;
        }
        return n5;
    }

    private void drawDecoration(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    private void initBackBuffer() {
        if (NineCanvas.useDoubleBuffer) {
            if (backBufferImage == null) {
                backBufferImage = Image.createImage((int)this.getViewportWidth(), (int)this.getViewportHeight());
            }
            this.backBuffer = backBufferImage.getGraphics();
            this.repaintBackground = true;
        }
    }

    public void renderBackBufferToScreen(Graphics graphics, int n, int n2) {
        if (this.viewportHeight - this.offsetY > 0) {
            graphics.drawRegion(backBufferImage, this.offsetX, this.offsetY, this.viewportWidth - this.offsetX, this.viewportHeight - this.offsetY, 0, n, n2, Consts.TOP_LEFT);
            graphics.drawRegion(backBufferImage, 0, this.offsetY, this.offsetX, this.viewportHeight - this.offsetY, 0, n + this.viewportWidth - this.offsetX, n2, Consts.TOP_LEFT);
        }
        if (this.offsetY > 0) {
            graphics.drawRegion(backBufferImage, this.offsetX, 0, this.viewportWidth - this.offsetX, this.offsetY, 0, n, n2 + this.viewportHeight - this.offsetY, Consts.TOP_LEFT);
            graphics.drawRegion(backBufferImage, 0, 0, this.offsetX, this.offsetY, 0, n + this.viewportWidth - this.offsetX, n2 + this.viewportHeight - this.offsetY, Consts.TOP_LEFT);
        }
    }

    public void renderToBackBuffer(int n, int n2, int n3, int n4) {
        if (this.repaintBackground) {
            this.renderMap(this.backBuffer, 0, 0, n, n2, n3, n4);
            this.cameraXOld = n;
            this.cameraYOld = n2;
            this.offsetX = 0;
            this.offsetY = 0;
            this.repaintBackground = false;
        } else {
            int n5;
            int n6 = n - this.cameraXOld;
            boolean bl = true;
            int n7 = 0;
            if (n6 != 0) {
                while (bl) {
                    if (n6 > 0) {
                        if (this.offsetX + n6 > n3) {
                            n7 = n6 - (n3 - this.offsetX);
                            n6 = n3 - this.offsetX;
                        } else {
                            bl = false;
                        }
                        this.renderMap(this.backBuffer, this.offsetX, 0, this.cameraXOld + n3, this.cameraYOld + n4 - this.offsetY, n6, this.offsetY);
                        this.renderMap(this.backBuffer, this.offsetX, this.offsetY, this.cameraXOld + n3, this.cameraYOld, n6, n4 - this.offsetY);
                        this.offsetX += n6;
                        if (this.offsetX == n3) {
                            this.offsetX = 0;
                        }
                    } else {
                        if (this.offsetX + n6 < 0) {
                            n7 = n6 + this.offsetX;
                            n6 = -this.offsetX;
                            if (n6 == 0) {
                                this.offsetX += n3;
                                n6 = n7;
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                        this.offsetX += n6;
                        if (n6 < 0) {
                            this.renderMap(this.backBuffer, this.offsetX, 0, this.cameraXOld + n6, this.cameraYOld + n4 - this.offsetY, -n6, this.offsetY);
                            this.renderMap(this.backBuffer, this.offsetX, this.offsetY, this.cameraXOld + n6, this.cameraYOld, -n6, n4 - this.offsetY);
                        }
                    }
                    this.cameraXOld += n6;
                    if (bl) {
                        n6 = n7;
                    }
                    if (n6 != 0) continue;
                }
            }
            if ((n5 = n2 - this.cameraYOld) != 0) {
                bl = true;
                while (bl) {
                    if (n5 > 0) {
                        if (this.offsetY + n5 > n4) {
                            n7 = n5 - (n4 - this.offsetY);
                            n5 = n4 - this.offsetY;
                        } else {
                            bl = false;
                        }
                        this.renderMap(this.backBuffer, 0, this.offsetY, this.cameraXOld + n3 - this.offsetX, this.cameraYOld + n4, this.offsetX, n5);
                        this.renderMap(this.backBuffer, this.offsetX, this.offsetY, this.cameraXOld, this.cameraYOld + n4, n3 - this.offsetX, n5);
                        this.offsetY += n5;
                        if (this.offsetY == n4) {
                            this.offsetY = 0;
                        }
                    } else {
                        if (this.offsetY + n5 < 0) {
                            n7 = n5 + this.offsetY;
                            n5 = -this.offsetY;
                            if (n5 == 0) {
                                this.offsetY += n4;
                                n5 = n7;
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                        this.offsetY += n5;
                        if (n5 < 0) {
                            this.renderMap(this.backBuffer, 0, this.offsetY, this.cameraXOld + n3 - this.offsetX, this.cameraYOld + n5, this.offsetX, -n5);
                            this.renderMap(this.backBuffer, this.offsetX, this.offsetY, this.cameraXOld, this.cameraYOld + n5, n3 - this.offsetX, -n5);
                        }
                    }
                    this.cameraYOld += n5;
                    if (bl) {
                        n5 = n7;
                    }
                    if (n5 != 0) continue;
                    break;
                }
            }
        }
    }

    private void initializeSegments(int[] nArray) {
        this.tilemapSegmentsInfo = nArray;
        this.mapSegments = Utils.vectorCreate(nArray.length / 4);
    }

    private void segmentsUpdate(int n, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = n3 < this.frontMapSegmentYInTiles;
        if (bl) {
            Game.sendEventImmediately(15, -1, -1);
        }
    }

    public void addMapSegment(int n) {
        this.mapSegments = Utils.vectorPushLastElement(this.mapSegments, n);
        this.frontMapSegmentLength = this.tilemapSegmentsInfo[n * 4 + 1];
        this.frontMapSegmentYInTiles -= this.frontMapSegmentLength;
        this.frontMapSegmentTilemapSegmentYInTiles = this.tilemapSegmentsInfo[n * 4 + 0];
        this.placeObjectsFromSegmentOnMap(n, this.frontMapSegmentYInTiles);
    }

    public void lockCameraInCurrentSegment() {
        this.setConstraintTopFP(BRCanvasMaths.iToF(this.frontMapSegmentYInTiles));
    }

    public int getMapSegmentsCount() {
        return Utils.vectorSize(this.mapSegments);
    }

    public int getCurrentSegmentId() {
        return Utils.vectorPeekLastElement(this.mapSegments);
    }

    public int getSegmentLengthInTiles(int n) {
        return this.tilemapSegmentsInfo[n * 4 + 1];
    }

    public int getSegmentParameter(int n) {
        int n2 = Utils.vectorPeekLastElement(this.mapSegments);
        return this.tilemapSegmentsInfo[n2 * 4 + 2 + n];
    }

    private void placeObjectsFromSegmentOnMap(int n, int n2) {
        int n3 = this.tilemapSegmentsInfo[n * 4 + 0];
        for (int i = this.gameObjectsDataTilemapSegmentsInfo[n]; i < this.gameObjectsDataTilemapSegmentsInfo[n + 1]; ++i) {
            int n4;
            short s = this.gameObjectsData[i][0];
            if (Game.MAP_OBJECTS_CONFIGURATION[s] == null || !this.isSegmentObject(n4 = Game.MAP_OBJECTS_CONFIGURATION[s][0])) continue;
            int n5 = Game.ROLE_REUSABLE_TYPE_MAP[n4];
            GameObject gameObject = GameObjectManager.popReusableGameObject(n5);
            int n6 = BRCanvasMaths.iToF(n2 - n3);
            GameObject gameObject2 = this.createGameObject(this.gameObjectsData[i], this.gameObjectsParameters[i], n6, gameObject);
            GameObjectManager.addGameObject(gameObject2);
        }
    }

    private boolean isSegmentObject(int n) {
        return n != 2 && n != 5 && n != 0 && n != 18 && n != 4;
    }

    private void addObjectsFromSegmentOnMap(int n, int n2) {
        boolean bl;
        int n3 = Utils.floori(this.cameraY, 14);
        int n4 = this.frontMapSegmentTilemapSegmentYInTiles + (n3 - this.frontMapSegmentYInTiles);
        int n5 = n4 - 1;
        boolean bl2 = bl = n5 > this.frontMapSegmentTilemapSegmentYInTiles;
        if (bl) {
            for (int i = this.gameObjectsDataTilemapSegmentsInfo[n] + n2; i < this.gameObjectsDataTilemapSegmentsInfo[n + 1]; ++i) {
                short s = this.gameObjectsData[i][0];
            }
        }
    }

    public int getPositionInCurrentSegment(int n) {
        int n2 = 0;
        int n3 = BRCanvasMaths.FToi(Utils.floorFP(n));
        if (n3 < this.frontMapSegmentYInTiles) {
            n2 = 0;
        } else {
            boolean bl = false;
            int n4 = this.frontMapSegmentYInTiles;
            int n5 = Utils.vectorSize(this.mapSegments);
            while (--n5 >= 0 && !bl) {
                int n6 = this.mapSegments[n5];
                int n7 = this.tilemapSegmentsInfo[n6 * 4 + 1];
                if (n4 <= n3 && n3 < n4 + n7) {
                    n2 = n4 + n7 - n3;
                    bl = true;
                }
                n4 += n7;
            }
        }
        return n2;
    }

    public int getMapWidth() {
        return this.mapWidthInTiles;
    }

    public int getMapHeight() {
        return this.mapHeightInTiles;
    }

    public int getTileId(int n, int n2) {
        int n3 = n;
        int n4 = this.mapYInTilesFromGlobalCoordinatesToTileMapCoordinates(n2);
        return this.mapGraphicBackgroundData[n4 * this.mapWidthInTiles + n3];
    }

    public int getTileParameter(int n, int n2) {
        int n3 = this.getTileId(n, n2);
        return this.getTileParameter(n3);
    }

    public int getTileParameter(int n) {
        return n != -1 ? this.collisionData[n] : n;
    }

    public int mapYInTilesFromGlobalCoordinatesToTileMapCoordinates(int n) {
        int n2 = -1;
        if (n < this.frontMapSegmentYInTiles) {
            int n3 = Utils.vectorPeekLastElement(this.mapSegments);
            int n4 = this.tilemapSegmentsInfo[n3 * 4 + 0];
            int n5 = this.tilemapSegmentsInfo[n3 * 4 + 1];
            n2 = n4 + (n5 - (this.frontMapSegmentYInTiles - n) % n5) % n5;
        } else if (n >= 0) {
            n2 = n % this.mapHeightInTiles;
        } else if (n < this.frontMapSegmentYInTiles + this.frontMapSegmentLength) {
            n2 = this.frontMapSegmentTilemapSegmentYInTiles + (n - this.frontMapSegmentYInTiles);
        } else {
            boolean bl = false;
            int n6 = this.frontMapSegmentYInTiles + this.frontMapSegmentLength;
            int n7 = Utils.vectorSize(this.mapSegments) - 1;
            while (--n7 >= 0 && !bl) {
                int n8 = this.mapSegments[n7];
                int n9 = this.tilemapSegmentsInfo[n8 * 4 + 1];
                if (n >= n6 && n < n6 + n9) {
                    int n10 = this.tilemapSegmentsInfo[n8 * 4 + 0];
                    n2 = n10 + (n - n6);
                    bl = true;
                }
                n6 += n9;
            }
        }
        return n2;
    }

    public void setTilesetImageId(int n) {
        this.tilesetImageId = n;
        int n2 = NineCanvas.instance.getImageDimension(n, 0, 0, 0);
        this.tilesetColumns = n2 / 14;
    }

    public void drawTile(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 < 0) {
            return;
        }
        int n8 = Math.max(n, n3);
        int n9 = Math.min(n + 14, n3 + n5);
        int n10 = Math.max(n2, n4);
        int n11 = Math.min(n2 + 14, n4 + n6);
        if (n9 - n8 < 0 || n11 - n10 < 0) {
            return;
        }
        graphics.setClip(n8, n10, n9 - n8, n11 - n10);
        int n12 = n7 % this.tilesetColumns * 14;
        int n13 = n7 / this.tilesetColumns * 14;
        NineCanvas.instance.drawImageIDNoTransform(graphics, this.tilesetImageId, 0, n - n12, n2 - n13, 0);
    }

    public void initViewport(int n, int n2, int n3, int n4) {
        this.unsetAllConstraints();
        this.viewportX = n;
        this.viewportY = n2;
        this.viewportWidth = n3;
        this.viewportWidthFP = Map.mapPixelsToTilesFP(n3);
        this.viewportHeight = n4;
        this.viewportHeightFP = Map.mapPixelsToTilesFP(n4);
        this.setCameraPositionFP(0, -this.viewportHeightFP);
        this.cameraVelocityFP = new int[2];
        this.cameraMoving = false;
        this.cameraReachedObject = false;
        this.gameObjectLockedOn = null;
    }

    public void updateViewport(int n) {
        int n2 = BRCanvasMaths.Fmul(BRCanvasMaths.iToF(n), 1);
        if (this.gameObjectLockedOn != null) {
            int n3 = this.gameObjectLockedOn.getCameraPositionXFP() - (this.viewportWidthFP >> 1) - this.cameraXFP;
            int n4 = this.gameObjectLockedOn.getCameraPositionYFP() - (this.viewportHeightFP >> 1) - this.cameraYFP;
            Vehicle vehicle = (Vehicle)this.gameObjectLockedOn;
            this.cameraVelocityFP[0] = vehicle.getVelocity()[0];
            this.cameraVelocityFP[1] = vehicle.getVelocity()[1];
            this.cameraMoving = false;
            this.cameraReachedObject = true;
            if (Math.abs(n3) > DEFAULT_DISTANCE_TOLERANCE_FP) {
                this.cameraVelocityFP[0] = this.cameraVelocityFP[0] + n3;
                this.cameraMoving = true;
                this.cameraReachedObject = false;
            }
            if (Math.abs(n4) > DEFAULT_DISTANCE_TOLERANCE_FP) {
                this.cameraVelocityFP[1] = this.cameraVelocityFP[1] - n4;
                this.cameraMoving = true;
                this.cameraReachedObject = false;
            }
            int n5 = BRCanvasMaths.Fmul(this.cameraVelocityFP[0], n2);
            int n6 = -BRCanvasMaths.Fmul(this.cameraVelocityFP[1], n2);
            this.moveCameraFP(n5, n6);
        }
    }

    public void setCameraPositionFP(int n, int n2) {
        this.cameraXFP = n;
        this.cameraYFP = n2;
        this.applyConstraints();
        this.cameraX = Map.mapTilesFPToPixels(this.cameraXFP);
        this.cameraY = Map.mapTilesFPToPixels(this.cameraYFP);
    }

    public void moveCameraFP(int n, int n2) {
        this.setCameraPositionFP(this.cameraXFP + n, this.cameraYFP + n2);
    }

    public int getCameraX() {
        return this.cameraX;
    }

    public int getCameraXFP() {
        return this.cameraXFP;
    }

    public int getCameraY() {
        return this.cameraY;
    }

    public int getCameraYFP() {
        return this.cameraYFP;
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportWidthFP() {
        return this.viewportWidthFP;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public int getViewportHeightFP() {
        return this.viewportHeightFP;
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    private void applyConstraints() {
        if (this.cameraYFP < this.constraintTopFP) {
            this.cameraYFP = this.constraintTopFP;
        }
        if (this.cameraYFP + this.viewportHeightFP > this.constraintBottomFP) {
            this.cameraYFP = this.constraintBottomFP - this.viewportHeightFP;
        }
        if (this.cameraXFP < this.constraintLeftFP) {
            this.cameraXFP = this.constraintLeftFP;
        }
        if (this.cameraXFP + this.viewportWidthFP > this.constraintRightFP) {
            this.cameraXFP = this.constraintRightFP - this.viewportWidthFP;
        }
    }

    public void setConstraintTopFP(int n) {
        this.constraintTopFP = n;
        this.applyConstraints();
    }

    public void setConstraintBottomFP(int n) {
        this.constraintBottomFP = n;
        this.applyConstraints();
    }

    public void setConstraintLeftFP(int n) {
        this.constraintLeftFP = n;
        this.applyConstraints();
    }

    public void setConstraintRightFP(int n) {
        this.constraintRightFP = n;
        this.applyConstraints();
    }

    public int getConstraintLeftFP() {
        return this.constraintLeftFP;
    }

    public int getConstraintRightFP() {
        return this.constraintRightFP;
    }

    public int getConstraintTopFP() {
        return this.constraintTopFP;
    }

    public int getConstraintBottomFP() {
        return this.constraintBottomFP;
    }

    public void unsetConstraintTopFP() {
        this.constraintTopFP = Integer.MIN_VALUE;
    }

    public void unsetConstraintBottomFP() {
        this.constraintBottomFP = Integer.MAX_VALUE;
    }

    public void unsetConstraintLeftFP() {
        this.constraintLeftFP = Integer.MIN_VALUE;
    }

    public void unsetConstraintRightFP() {
        this.constraintRightFP = Integer.MAX_VALUE;
    }

    public void unsetAllConstraints() {
        this.unsetConstraintTopFP();
        this.unsetConstraintBottomFP();
        this.unsetConstraintLeftFP();
        this.unsetConstraintRightFP();
    }

    public void lockViewOnGameObject(GameObject gameObject, boolean bl) {
        this.gameObjectLockedOn = gameObject;
        if (bl) {
            int n = this.gameObjectLockedOn.getCameraPositionXFP() - (this.viewportWidthFP >> 1);
            int n2 = this.gameObjectLockedOn.getCameraPositionYFP() - (this.viewportHeightFP >> 1);
            this.setCameraPositionFP(n, n2);
            this.cameraMoving = false;
            this.cameraReachedObject = true;
        }
    }

    public GameObject getLockedOnObject() {
        return this.gameObjectLockedOn;
    }

    public boolean hasCameraReachedObject() {
        return this.cameraReachedObject;
    }

    public boolean isCameraMoving() {
        return this.cameraMoving;
    }

    private void generateReusables() {
        for (int i = 0; i < 9; ++i) {
            int n = this.maxReusableObjectsInSegment[i];
            for (int j = 0; j < n; ++j) {
                GameObject gameObject = null;
                switch (i) {
                    case 0: {
                        gameObject = new Vehicle(i);
                        break;
                    }
                    case 1: {
                        gameObject = new Vehicle(i);
                        break;
                    }
                    case 2: {
                        gameObject = new Bullet(i);
                        break;
                    }
                    case 3: {
                        gameObject = new Explosion(i);
                        break;
                    }
                    case 4: {
                        gameObject = new SpawningPoint(i);
                        break;
                    }
                    case 5: {
                        gameObject = new Decoration(i);
                        break;
                    }
                    case 6: {
                        gameObject = new Breakable(i);
                        break;
                    }
                    case 7: {
                        gameObject = new Pickup(i);
                        break;
                    }
                    case 8: {
                        gameObject = new Trigger(i);
                    }
                }
                if (gameObject == null) continue;
                GameObjectManager.pushReusableGameObject(i, gameObject);
            }
        }
    }

    public void initLoading(int n) {
        this.mapId = n;
        this.mapLoadingData = NineCanvas.instance.getResourceByteArray(this.mapId);
        this.mapLoadingStep = 0;
        this.maxSegmentObjectHeightInTiles = 0;
    }

    public int tickLoading() {
        if (this.mapLoadingStep == 11) {
            this.mapLoaded = true;
            return 11;
        }
        switch (this.mapLoadingStep) {
            case 0: {
                this.noOfLayers = this.mapLoadingData[this.offset];
                ++this.offset;
                this.mapWidthInTiles = this.mapLoadingData[this.offset];
                ++this.offset;
                this.mapHeightInTiles = BRCanvasResHandler.readShortFromByteArray(this.mapLoadingData, this.offset);
                this.offset += 2;
                break;
            }
            case 1: {
                int n;
                this.mapGraphicBackgroundData = new byte[this.mapHeightInTiles * this.mapWidthInTiles];
                int n2 = this.mapLoadingData[this.offset];
                ++this.offset;
                this.collisionData = new short[n2];
                for (n = 0; n < n2; ++n) {
                    this.collisionData[n] = this.mapLoadingData[this.offset];
                    ++this.offset;
                }
                n = this.offset;
                for (int i = 0; i < this.mapHeightInTiles; ++i) {
                    for (int j = 0; j < this.mapWidthInTiles; ++j) {
                        byte by;
                        this.mapGraphicBackgroundData[this.offset - n] = by = this.mapLoadingData[n + (j * this.mapHeightInTiles + i)];
                        ++this.offset;
                    }
                }
                break;
            }
            case 2: {
                int n = BRCanvasResHandler.readShortFromByteArray(this.mapLoadingData, this.offset);
                this.offset += 2;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                this.gameObjectsData = new short[n][];
                this.gameObjectsParameters = new byte[n][];
                for (int i = 0; i < n; ++i) {
                    int n7;
                    short s = this.mapLoadingData[this.offset];
                    ++this.offset;
                    if (s < 0) {
                        s = (short)(256 + s);
                    }
                    short s2 = this.mapLoadingData[this.offset];
                    ++this.offset;
                    short s3 = BRCanvasResHandler.readShortFromByteArray(this.mapLoadingData, this.offset);
                    this.offset += 2;
                    byte[] byArray = null;
                    if (s3 >= 0) {
                        n7 = this.mapLoadingData[this.offset];
                        ++this.offset;
                        byArray = new byte[n7];
                        for (int j = 0; j < n7; ++j) {
                            byArray[j] = this.mapLoadingData[this.offset];
                            ++this.offset;
                        }
                    } else {
                        s3 = (short)(s3 * -1);
                    }
                    this.gameObjectsData[i] = new short[3];
                    this.gameObjectsData[i][0] = s;
                    this.gameObjectsData[i][1] = s2;
                    this.gameObjectsData[i][2] = s3;
                    this.gameObjectsParameters[i] = byArray;
                    n7 = Game.MAP_OBJECTS_CONFIGURATION[s][0];
                    if (n7 == 5) {
                        ++n3;
                        continue;
                    }
                    if (n7 == 18) {
                        ++n6;
                        continue;
                    }
                    if (n7 == 0 && Game.MAP_OBJECTS_CONFIGURATION[s][1] == 2) {
                        ++n4;
                        this.maxGameObjectsInTilemapSegment = Math.max(this.maxGameObjectsInTilemapSegment, n5);
                        n5 = 0;
                        continue;
                    }
                    ++n5;
                }
                this.gameObjectsCount = n - n3;
                n4 = Math.max(1, n4);
                this.tilemapSegmentsInfo = new int[n4 * 4];
                this.gameObjectsDataTilemapSegmentsInfo = new int[n4 + 1];
                this.playerSpData = new int[n6 * 2];
                this.decorationsData = new int[n3 * 5];
                this.decorationsDataTilemapSegmentsInfo = new int[n4 + 1];
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                int n = NineCanvas.mainFontHeight + 1 + 0;
                int n8 = 17;
                this.initViewport(0, n, NineCanvas.SCREEN_WIDTH, BRCanvasDimensions.PARAM_BR_BASE_SCREEN_HEIGHT - 0 - (n + n8));
                n = Map.mapPixelsToTilesFP(1) / 2;
                this.setConstraintBottomFP(-n);
                this.setConstraintLeftFP(0);
                this.setConstraintRightFP(BRCanvasMaths.iToF(this.mapWidthInTiles) - 1);
                break;
            }
            case 5: {
                int n;
                int n9;
                GameObjectManager.init(this.maxGameObjectsInTilemapSegment * 2);
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                this.maxReusableObjectsInSegment = new int[9];
                int[] nArray = new int[9];
                this.gameObjectsDataTilemapSegmentsInfo[n12] = 0;
                this.decorationsDataTilemapSegmentsInfo[n12] = n11 * 5;
                for (n9 = 0; n9 < this.gameObjectsData.length; ++n9) {
                    int n13;
                    int n14;
                    n = this.gameObjectsData[n9][0];
                    if (Game.MAP_OBJECTS_CONFIGURATION[n] == null) continue;
                    int n15 = Game.MAP_OBJECTS_CONFIGURATION[n][0];
                    if (n15 == 0) {
                        int n16;
                        n14 = Game.MAP_OBJECTS_CONFIGURATION[n][1];
                        short s = this.gameObjectsData[n9][1];
                        int n17 = this.gameObjectsData[n9][2];
                        byte[] byArray = this.gameObjectsParameters[n9];
                        if (n14 != 2) continue;
                        if (n12 == 0) {
                            n16 = n12 * 4;
                            this.tilemapSegmentsInfo[n16 + 0] = n17;
                            this.tilemapSegmentsInfo[n16 + 1] = this.mapHeightInTiles - n17;
                            this.tilemapSegmentsInfo[n16 + 2] = byArray[0];
                            this.tilemapSegmentsInfo[n16 + 3] = byArray[1];
                        } else {
                            n16 = this.tilemapSegmentsInfo[(n12 - 1) * 4 + 0];
                            int n18 = n12 * 4;
                            this.tilemapSegmentsInfo[n18 + 0] = n17;
                            this.tilemapSegmentsInfo[n18 + 1] = n16 - n17;
                            this.tilemapSegmentsInfo[n18 + 2] = byArray[0];
                            this.tilemapSegmentsInfo[n18 + 3] = byArray[1];
                        }
                        this.decorationsDataTilemapSegmentsInfo[++n12] = n11 * 5;
                        this.gameObjectsDataTilemapSegmentsInfo[n12] = n9;
                        for (n16 = 0; n16 < 9; ++n16) {
                            this.maxReusableObjectsInSegment[n16] = Math.max(this.maxReusableObjectsInSegment[n16], nArray[n16]);
                            nArray[n16] = 0;
                        }
                        continue;
                    }
                    if (n15 == 5) continue;
                    if (n15 == 18) {
                        n13 = this.gameObjectsData[n9][1];
                        n14 = this.gameObjectsData[n9][2];
                        int n19 = n10 * 2;
                        ++n10;
                        this.playerSpData[n19 + 0] = n13;
                        this.playerSpData[n19 + 1] = n14;
                        continue;
                    }
                    if (n15 == 2) {
                        n13 = BRCanvasMaths.iToF(this.gameObjectsData[n9][1]);
                        n14 = BRCanvasMaths.iToF(-(this.mapHeightInTiles - this.gameObjectsData[n9][2]));
                        bondVehicleId = n;
                        Vehicle vehicle = Map.initBondVehicle(bondVehicleId, n13, n14, null);
                        GameObjectManager.addGameObject(vehicle);
                        GameObjectManager.setGameHero(vehicle);
                        continue;
                    }
                    int n20 = n13 = Game.ROLE_REUSABLE_TYPE_MAP[n15];
                    nArray[n20] = nArray[n20] + 1;
                }
                int n21 = n9 = n12 == 0 ? 1 : 0;
                if (n9 != 0) {
                    n = n12 * 4;
                    this.tilemapSegmentsInfo[n + 0] = 0;
                    this.tilemapSegmentsInfo[n + 1] = this.mapHeightInTiles;
                    this.tilemapSegmentsInfo[n + 2] = 0;
                    this.tilemapSegmentsInfo[n + 3] = 0;
                    this.gameObjectsDataTilemapSegmentsInfo[++n12] = this.gameObjectsData[0].length;
                    this.decorationsDataTilemapSegmentsInfo[n12] = n11 * 5;
                }
                this.initializeSegments(this.tilemapSegmentsInfo);
                for (n = 0; n < 9; ++n) {
                    this.maxReusableObjectsInSegment[n] = this.maxReusableObjectsInSegment[n] * 0 / 2;
                }
                this.maxReusableObjectsInSegment[0] = 6;
                this.maxReusableObjectsInSegment[2] = 36;
                this.maxReusableObjectsInSegment[3] = 16;
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                this.lockViewOnGameObject(GameObjectManager.getGameHero(), true);
                break;
            }
            case 9: {
                this.initBackBuffer();
                break;
            }
            case 10: {
                this.mapLoadingData = null;
            }
        }
        ++this.mapLoadingStep;
        return this.mapLoadingStep * 100 / 11;
    }

    public void deinit() {
    }

    public static Vehicle initBondVehicle(int n, int n2, int n3, Vehicle vehicle) {
        Vehicle vehicle2;
        int n4 = Game.MAP_OBJECTS_CONFIGURATION[n][1];
        int n5 = Game.MAP_OBJECTS_CONFIGURATION[n][2];
        int n6 = Game.MAP_OBJECTS_CONFIGURATION[n][3];
        int n7 = Game.MAP_OBJECTS_CONFIGURATION[n][4];
        int n8 = Game.MAP_OBJECTS_CONFIGURATION[n][5];
        boolean bl = Game.MAP_OBJECTS_CONFIGURATION[n][6] == 0;
        boolean bl2 = Game.MAP_OBJECTS_CONFIGURATION[n][8] == 1;
        boolean bl3 = Game.MAP_OBJECTS_CONFIGURATION[n][7] == 1;
        int n9 = Game.MAP_OBJECTS_CONFIGURATION[n][9];
        int n10 = Game.MAP_OBJECTS_CONFIGURATION[n][10];
        int n11 = Game.MAP_OBJECTS_CONFIGURATION[n][11];
        int n12 = Game.MAP_OBJECTS_CONFIGURATION[n][12];
        int n13 = Game.MAP_OBJECTS_CONFIGURATION[n][13];
        int n14 = Game.MAP_OBJECTS_CONFIGURATION[n][14];
        int n15 = Game.MAP_OBJECTS_CONFIGURATION[n][15];
        int n16 = Game.MAP_OBJECTS_CONFIGURATION[n][16];
        int n17 = Game.MAP_OBJECTS_CONFIGURATION[n][17];
        int n18 = Game.MAP_OBJECTS_CONFIGURATION[n][18];
        int n19 = Game.MAP_OBJECTS_CONFIGURATION[n][19];
        int n20 = Game.MAP_OBJECTS_CONFIGURATION[n][20];
        int n21 = Game.MAP_OBJECTS_CONFIGURATION[n][21];
        int n22 = Game.MAP_OBJECTS_CONFIGURATION[n][22];
        int[] nArray = Game.MAP_PLAYER_SKILLS[0];
        int n23 = n19 == 2 ? 101 : 51;
        Vehicle vehicle3 = vehicle2 = vehicle == null ? new Vehicle(-1) : vehicle;
        if (NineCanvas.currentQuickStoryLevel == 2) {
            n4 = 142;
        } else if (NineCanvas.currentQuickStoryLevel == 12) {
            n4 = 138;
        }
        vehicle2.init(2, n2, n3, n23, n4, n5, n6, n7, n8, bl, bl3, bl2, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n22, 0, nArray, n19, n20, n21);
        vehicle2.setHealth(2 * vehicle2.getMaxHealthPoints());
        NineCanvas.resetKeys();
        return vehicle2;
    }

    private GameObject createGameObject(short[] sArray, byte[] byArray, int n, GameObject gameObject) {
        short s = sArray[0];
        int n2 = BRCanvasMaths.iToF(sArray[1]);
        int n3 = BRCanvasMaths.iToF(sArray[2]) + n;
        short s2 = s;
        if (Game.MAP_OBJECTS_CONFIGURATION[s2] == null) {
            return null;
        }
        GameObject gameObject2 = null;
        int n4 = Game.MAP_OBJECTS_CONFIGURATION[s2][0];
        switch (n4) {
            case 0: {
                break;
            }
            case 11: {
                SpawningPoint spawningPoint = null;
                spawningPoint = gameObject == null ? new SpawningPoint(4) : (SpawningPoint)gameObject;
                int n5 = Game.MAP_OBJECTS_CONFIGURATION[s2][1];
                spawningPoint.init(n4, n5, n2, n3, 20, null);
                gameObject2 = spawningPoint;
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 19: {
                Decoration decoration = null;
                decoration = gameObject == null ? new Decoration(5) : (Decoration)gameObject;
                int n6 = Game.MAP_OBJECTS_CONFIGURATION[s2][1];
                int n7 = Game.MAP_OBJECTS_CONFIGURATION[s2][2];
                int n8 = Game.MAP_OBJECTS_CONFIGURATION[s2][3];
                decoration.init(n4, n2, n3, 20, n6, n7, n8);
                gameObject2 = decoration;
                break;
            }
            case 10: {
                Breakable breakable = null;
                breakable = gameObject == null ? new Breakable(6) : (Breakable)gameObject;
                int n9 = Game.MAP_OBJECTS_CONFIGURATION[s2][1];
                int n10 = Game.MAP_OBJECTS_CONFIGURATION[s2][2];
                int n11 = Game.MAP_OBJECTS_CONFIGURATION[s2][3];
                int n12 = Game.MAP_OBJECTS_CONFIGURATION[s2][4];
                int n13 = Game.MAP_OBJECTS_CONFIGURATION[s2][6];
                int n14 = Game.MAP_OBJECTS_CONFIGURATION[s2][7];
                int n15 = Game.MAP_OBJECTS_CONFIGURATION[s2][5];
                breakable.init(n4, n2, n3, 20, n9, n10, n11, n12, null, n15, n13, n14);
                gameObject2 = breakable;
                break;
            }
            case 6: {
                Pickup pickup = null;
                pickup = gameObject == null ? new Pickup(7) : (Pickup)gameObject;
                int n16 = Game.MAP_OBJECTS_CONFIGURATION[s2][1];
                int n17 = Game.MAP_OBJECTS_CONFIGURATION[s2][2];
                int n18 = Game.MAP_OBJECTS_CONFIGURATION[s2][3];
                pickup.init(n4, n2, n3, 30, n16, n17, n18, null);
                gameObject2 = pickup;
                break;
            }
            case 13: {
                Trigger trigger = null;
                trigger = gameObject == null ? new Trigger(8) : (Trigger)gameObject;
                int n19 = BRCanvasMaths.iToF(byArray[0]);
                int n20 = BRCanvasMaths.iToF(byArray[1]);
                byte by = byArray[2];
                byte by2 = byArray[3];
                trigger.init(n4, n2, n3, 20, n19, n20, by, by2);
                gameObject2 = trigger;
                break;
            }
        }
        return gameObject2;
    }

    public boolean isLoaded() {
        return this.mapLoaded;
    }

    public int getMapId() {
        return this.mapId;
    }

    public void spawnPlayerToNearestSpawnPoint() {
        int n;
        Vehicle vehicle = GameObjectManager.getGameHero();
        int n2 = this.mapYInTilesFromGlobalCoordinatesToTileMapCoordinates(vehicle.getPositionYFP() / 1024);
        int n3 = this.getCurrentSegmentId() * 4;
        int n4 = this.tilemapSegmentsInfo[n3 + 0] + this.tilemapSegmentsInfo[n3 + 1];
        int n5 = -1;
        int n6 = Integer.MAX_VALUE;
        for (n = 0; n < this.playerSpData.length; n += 2) {
            int n7 = this.playerSpData[n + 1];
            if (n7 <= n2 || n7 >= n4 || n7 - n2 >= n6) continue;
            n6 = n7 - n2;
            n5 = n;
        }
        if (n5 == -1) {
            return;
        }
        n = (this.playerSpData[n5 + 1] - n2) * 1024;
        vehicle.setPositionYFP(vehicle.getPositionYFP() + n);
        vehicle.setPositionXFP(this.playerSpData[n5 + 0] * 1024);
        this.lockViewOnGameObject(vehicle, true);
    }

    public static int mapTilesFPToPixels(int n) {
        return BRCanvasMaths.FToi(n * 14);
    }

    public static int mapPixelsToTilesFP(int n) {
        return BRCanvasMaths.iToF(n) / 14;
    }

    static {
        backBufferImage = null;
    }
}

