/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class GameTaskManager {
    private static GameTaskManager gameTaskManager;
    private Vector[] taskGroups;
    private int[] groupActiveTaskIds;
    private int[] gameObjectWithRoleCount;

    public GameTaskManager(int n) {
        this.taskGroups = new Vector[n];
        this.groupActiveTaskIds = new int[n];
        for (int i = 0; i < n; ++i) {
            this.taskGroups[i] = new Vector();
            this.groupActiveTaskIds[i] = -1;
        }
        this.gameObjectWithRoleCount = new int[20];
    }

    public static void init(int n) {
        gameTaskManager = new GameTaskManager(n);
    }

    public static void deinit() {
    }

    public static GameTaskManager getInstance() {
        return gameTaskManager;
    }

    public void initializeTasks() {
        for (int i = 0; i < this.taskGroups.length; ++i) {
            if (this.groupActiveTaskIds[i] != -1) continue;
            this.switchToNextTask(i);
        }
    }

    public void deinitInstance() {
    }

    public void update(int n) {
        for (int i = 0; i < this.taskGroups.length; ++i) {
            if (!this.isActiveTask(i)) continue;
            GameTask gameTask = this.getActiveTask(i);
            gameTask.update(n);
            if (!gameTask.isFinished()) continue;
            this.switchToNextTask(i);
        }
    }

    public void handleEvent(int n, int n2, int n3) {
        this.handleGameObjectWithRolesCount(n, n2, n3);
        this.handleTasksEvents(n, n2, n3);
    }

    private void handleTasksEvents(int n, int n2, int n3) {
        for (int i = 0; i < this.taskGroups.length; ++i) {
            GameTask gameTask;
            if (!this.isActiveTask(i) || !(gameTask = this.getActiveTask(i)).isActive()) continue;
            gameTask.handleEvent(n, n2, n3);
        }
    }

    public void addGameTask(GameTask gameTask, int n) {
        this.taskGroups[n].addElement(gameTask);
        gameTask.setGtm(this);
    }

    public boolean isActiveTask(int n) {
        int n2 = this.groupActiveTaskIds[n];
        return n2 >= 0 && n2 < this.taskGroups[n].size();
    }

    private void switchToNextTask(int n) {
        int n2 = n;
        this.groupActiveTaskIds[n2] = this.groupActiveTaskIds[n2] + 1;
        if (this.groupActiveTaskIds[n] < this.taskGroups[n].size()) {
            GameTask gameTask = this.getActiveTask(n);
            gameTask.initialize();
            gameTask.handleEvent(16, -1, -1);
        }
    }

    public int getActiveTaskId(int n) {
        return this.groupActiveTaskIds[n];
    }

    public GameTask getActiveTask(int n) {
        int n2 = this.groupActiveTaskIds[n];
        return (GameTask)this.taskGroups[n].elementAt(n2);
    }

    private void handleGameObjectWithRolesCount(int n, int n2, int n3) {
        switch (n) {
            case 14: {
                int n4;
                int n5 = n4 = Utils.unpackSecond(n2);
                this.gameObjectWithRoleCount[n5] = this.gameObjectWithRoleCount[n5] + 1;
                break;
            }
            case 10: {
                int n6;
                int n7 = Utils.unpackFirst(n2);
                int n8 = n6 = Utils.unpackSecond(n2);
                this.gameObjectWithRoleCount[n8] = this.gameObjectWithRoleCount[n8] - 1;
                break;
            }
            case 13: {
                int n9;
                int n10 = Utils.unpackFirst(n2);
                int n11 = n9 = Utils.unpackSecond(n2);
                this.gameObjectWithRoleCount[n11] = this.gameObjectWithRoleCount[n11] - 1;
                break;
            }
            case 5: {
                int n12;
                int n13 = n2;
                int n14 = n12 = GameObjectManager.getGameObject(n13).getRole();
                this.gameObjectWithRoleCount[n14] = this.gameObjectWithRoleCount[n14] - 1;
                break;
            }
            case 6: {
                int n15;
                int n16 = n2;
                int n17 = n15 = GameObjectManager.getGameObject(n16).getRole();
                this.gameObjectWithRoleCount[n17] = this.gameObjectWithRoleCount[n17] - 1;
                break;
            }
            case 8: {
                int n18;
                int n19 = n2;
                int n20 = n18 = GameObjectManager.getGameObject(n19).getRole();
                this.gameObjectWithRoleCount[n20] = this.gameObjectWithRoleCount[n20] - 1;
                break;
            }
        }
    }

    public int getGameObjectsCount(int n) {
        if (n == -1) {
            return 0;
        }
        return this.gameObjectWithRoleCount[n];
    }
}

