/*
 * Decompiled with CFR 0.152.
 */
public class GameTask {
    public static final int CONFIG_IDX_TYPE = 0;
    public static final int CONFIG_IDX_SEGMENTS_TO_DRIVE_COUNT = 1;
    public static final int CONFIG_IDX_LAST_SEGMENTS_TO_REPEAT_COUNT = 2;
    public static final int CONFIG_IDX_SEGMENTS_TO_DRIVE_START = 3;
    public static final int CONFIG_OFFSET_SPAWN_LIST_START = 1;
    public static final int ENEMY_CONFIGURATION_SIZE = 3;
    public static final int ENEMY_CONFIGURATION_OBJECT_ID = 0;
    public static final int ENEMY_CONFIGURATION_ENEMY_AI_TYPE = 1;
    public static final int ENEMY_CONFIGURATION_ENEMY_SKILL_LEVEL = 2;
    public static final int EVENT_SIZE = 4;
    public static final int EVENT_IDX_EVENT_ID = 0;
    public static final int EVENT_IDX_EVENT_PARAM = 1;
    public static final int EVENT_IDX_ACTION_ID = 2;
    public static final int EVENT_IDX_ACTION_PARAM = 3;
    private static final int VEHICLE_ID_NOT_SPAWNED = -1;
    private static final int VEHICLE_ID_KILLED = -2;
    protected int[] configuration;
    private boolean finished;
    protected GameTaskManager gtm;
    private int[] spawnedVehiclesIds;
    private int[] removedVehiclesLastHp;
    private int vehiclesLeftToSpawn;
    private int dominantRole;
    private int segmentsConfigurationIdx;
    private int segmentsOverallLength;
    private int segmentsCurrentLength;
    private boolean timerRunning;
    private long prevTime;
    private int timer;

    public GameTask(int[] nArray) {
        this.configuration = nArray;
        this.initializeSpawner();
        this.initializeSegmentManagement();
    }

    public void initialize() {
        this.handleSegmentManagement();
    }

    public void deinit() {
    }

    public void update(int n) {
        this.updateTimer();
    }

    public void handleEvent(int n, int n2, int n3) {
        this.executeActionsForEvent(n, n2, n3);
        this.segmentsManagementHandleEvent(n, n2, n3);
        this.spawnerHandleEvent(n, n2, n3);
    }

    public int getVehiclesLeftToSpawn() {
        return this.vehiclesLeftToSpawn;
    }

    public int getTotalVehicles() {
        return this.spawnedVehiclesIds.length;
    }

    public int getDestroyedVehiclesCount() {
        return this.getTotalVehicles() - this.vehiclesLeftToSpawn - this.gtm.getGameObjectsCount(this.getDominantRole());
    }

    private int getConfigFlags() {
        return this.configuration[0];
    }

    private int getDominantRole() {
        return this.dominantRole;
    }

    private void initializeSpawner() {
        int n = 3 + this.configuration[1];
        this.vehiclesLeftToSpawn = this.configuration[n];
        this.spawnedVehiclesIds = new int[this.vehiclesLeftToSpawn];
        this.removedVehiclesLastHp = new int[this.vehiclesLeftToSpawn];
        Utils.arrayFill(this.spawnedVehiclesIds, -1);
        if (this.vehiclesLeftToSpawn != 0) {
            int n2 = this.configuration[n + 1 + 0];
            this.dominantRole = Game.MAP_OBJECTS_CONFIGURATION[n2][0];
        } else {
            this.dominantRole = -1;
        }
    }

    private void spawnerHandleEvent(int n, int n2, int n3) {
        switch (n) {
            case 10: {
                boolean bl;
                int n4 = Utils.unpackFirst(n2);
                int n5 = Utils.arrayFind(this.spawnedVehiclesIds, n4);
                if (n5 == -1) break;
                int n6 = Utils.unpackSecond(n3);
                boolean bl2 = bl = (this.getConfigFlags() & 0x40) != 0;
                if (bl) {
                    this.spawnedVehiclesIds[n5] = -1;
                    ++this.vehiclesLeftToSpawn;
                } else if (n6 == 2) {
                    this.spawnedVehiclesIds[n5] = -2;
                } else {
                    this.spawnedVehiclesIds[n5] = -1;
                    ++this.vehiclesLeftToSpawn;
                }
                this.removedVehiclesLastHp[n5] = 0;
                break;
            }
            case 13: {
                boolean bl;
                int n7 = Utils.unpackFirst(n2);
                int n8 = Utils.arrayFind(this.spawnedVehiclesIds, n7);
                if (n8 == -1) break;
                int n9 = Utils.unpackSecond(n3);
                boolean bl3 = bl = (this.getConfigFlags() & 0x80) != 0;
                if (bl) {
                    this.spawnedVehiclesIds[n8] = -1;
                    ++this.vehiclesLeftToSpawn;
                } else if (n9 == 2) {
                    this.spawnedVehiclesIds[n8] = -2;
                } else {
                    this.spawnedVehiclesIds[n8] = -1;
                    ++this.vehiclesLeftToSpawn;
                }
                this.removedVehiclesLastHp[n8] = 0;
                break;
            }
            case 5: {
                boolean bl;
                int n10 = n2;
                int n11 = Utils.arrayFind(this.spawnedVehiclesIds, n10);
                if (n11 == -1) break;
                boolean bl4 = bl = (this.getConfigFlags() & 8) != 0;
                if (bl) {
                    this.spawnedVehiclesIds[n11] = -1;
                    ++this.vehiclesLeftToSpawn;
                } else {
                    this.spawnedVehiclesIds[n11] = -2;
                }
                this.removedVehiclesLastHp[n11] = 0;
                break;
            }
            case 6: {
                boolean bl;
                int n12 = n2;
                int n13 = Utils.arrayFind(this.spawnedVehiclesIds, n12);
                if (n13 == -1) break;
                boolean bl5 = bl = (this.getConfigFlags() & 0x10) != 0;
                if (bl) {
                    this.spawnedVehiclesIds[n13] = -1;
                    ++this.vehiclesLeftToSpawn;
                    Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(n12);
                    this.removedVehiclesLastHp[n13] = vehicle.getHealth();
                    break;
                }
                this.spawnedVehiclesIds[n13] = -2;
                this.removedVehiclesLastHp[n13] = 0;
                break;
            }
            case 8: {
                boolean bl;
                int n14 = n2;
                int n15 = Utils.arrayFind(this.spawnedVehiclesIds, n14);
                if (n15 == -1) break;
                boolean bl6 = bl = (this.getConfigFlags() & 0x20) != 0;
                if (bl) {
                    this.spawnedVehiclesIds[n15] = -1;
                    ++this.vehiclesLeftToSpawn;
                    Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(n14);
                    this.removedVehiclesLastHp[n15] = vehicle.getHealth();
                    break;
                }
                this.spawnedVehiclesIds[n15] = -2;
                this.removedVehiclesLastHp[n15] = 0;
                break;
            }
            case 1: {
                int n16;
                int n17;
                if (this.vehiclesLeftToSpawn <= 0) break;
                int n18 = this.getDominantRole() == 3 ? 0 : 1;
                int n19 = ResourceManager.map.getSegmentParameter(n18);
                if (this.gtm.getGameObjectsCount(this.getDominantRole()) >= n19) break;
                int n20 = n2;
                SpawningPoint spawningPoint = (SpawningPoint)GameObjectManager.getGameObject(n20);
                boolean bl = (this.getConfigFlags() & 4) != 0;
                int n21 = bl ? this.findAppropriateVehicleRandomely(this.spawnedVehiclesIds, spawningPoint) : this.findAppropriateVehicle(this.spawnedVehiclesIds, spawningPoint);
                if (n21 == -1) break;
                int n22 = 3 + this.configuration[1] + 1;
                int n23 = this.configuration[n22 + n21 * 3 + 0];
                int n24 = this.configuration[n22 + n21 * 3 + 1];
                int n25 = this.configuration[n22 + n21 * 3 + 2];
                int[] nArray = Game.MAP_PLAYER_SKILLS[n25];
                this.spawnedVehiclesIds[n21] = n17 = spawningPoint.spawn(Game.MAP_OBJECTS_CONFIGURATION[n23], n24, nArray);
                if (n17 == -1) break;
                Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(n17);
                if ((this.getConfigFlags() & 0x100) != 0 && (n16 = this.removedVehiclesLastHp[n21]) != 0) {
                    vehicle.setHealth(n16);
                }
                vehicle.tryToSetDestroyMissionMarker();
                --this.vehiclesLeftToSpawn;
                Game.sendEventImmediately(14, Utils.packInts(vehicle.getuId(), vehicle.getRole()), -1);
            }
        }
    }

    protected int findAppropriateVehicle(int[] nArray, SpawningPoint spawningPoint) {
        int n = 3 + this.configuration[1] + 1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -1) continue;
            int n2 = this.configuration[n + i * 3 + 1];
            int n3 = spawningPoint.getType();
            if ((n2 != 9 || n3 != 1) && (n2 == 9 || n3 == 1)) continue;
            return i;
        }
        return -1;
    }

    protected int findAppropriateVehicleRandomely(int[] nArray, SpawningPoint spawningPoint) {
        int n;
        int n2;
        boolean bl;
        int n3;
        int n4 = 3 + this.configuration[1] + 1;
        int n5 = spawningPoint.getType();
        if (n5 == 1) {
            n3 = 9;
            bl = true;
        } else {
            n3 = 9;
            bl = false;
        }
        int n6 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = this.configuration[n4 + n2 * 3 + 1];
            if ((!bl || n != n3) && (bl || n == n3)) continue;
            ++n6;
        }
        if (n6 == 0) {
            return -1;
        }
        n2 = BRCanvasMaths.random(n6);
        for (n = 0; n < nArray.length; ++n) {
            int n7 = this.configuration[n4 + n * 3 + 1];
            if ((!bl || n7 != n3) && (bl || n7 == n3)) continue;
            if (n2 <= 0) {
                return n;
            }
            --n2;
        }
        return -1;
    }

    private void initializeSegmentManagement() {
        int n = this.configuration[1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.configuration[3 + i];
            n2 += ResourceManager.map.getSegmentLengthInTiles(n3);
        }
        this.segmentsOverallLength = n2;
        this.segmentsCurrentLength = 0;
    }

    private void handleSegmentManagement() {
        boolean bl;
        boolean bl2 = bl = (this.getConfigFlags() & 1) != 0 && this.configuration[1] != 0;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = this.segmentsConfigurationIdx < this.configuration[1];
            if (bl3) {
                int n = this.configuration[3 + this.segmentsConfigurationIdx];
                if (ResourceManager.map.getMapSegmentsCount() > 0 && this.segmentsConfigurationIdx != 0) {
                    this.segmentsCurrentLength += ResourceManager.map.getSegmentLengthInTiles(ResourceManager.map.getCurrentSegmentId());
                }
                ResourceManager.map.addMapSegment(n);
                ++this.segmentsConfigurationIdx;
            } else if ((this.getConfigFlags() & 2) != 0 && (this.gtm.getGameObjectsCount(this.getDominantRole()) > 0 || this.vehiclesLeftToSpawn > 0)) {
                this.segmentsConfigurationIdx -= this.configuration[2];
                int n = this.configuration[3 + this.segmentsConfigurationIdx];
                if (ResourceManager.map.getMapSegmentsCount() > 0 && this.segmentsConfigurationIdx != 0) {
                    this.segmentsCurrentLength += ResourceManager.map.getSegmentLengthInTiles(ResourceManager.map.getCurrentSegmentId());
                }
                ResourceManager.map.addMapSegment(n);
                ++this.segmentsConfigurationIdx;
            } else {
                this.finish();
            }
        }
    }

    private void segmentsManagementHandleEvent(int n, int n2, int n3) {
        switch (n) {
            case 15: {
                this.handleSegmentManagement();
            }
        }
    }

    public int getSegmentsOverallLength() {
        return this.segmentsOverallLength;
    }

    public int getSegmentsCurrentLength() {
        return this.segmentsCurrentLength;
    }

    private void executeActionsForEvent(int n, int n2, int n3) {
        int n4;
        int n5 = 3 + this.configuration[1];
        for (int i = n4 = n5 + 1 + this.configuration[n5] * 3; i < this.configuration.length; i += 4) {
            if (!this.canExecuteAction(this.configuration[i + 0], this.configuration[i + 1], n, n2, n3)) continue;
            this.executeAction(this.configuration[i + 2], this.configuration[i + 3]);
        }
    }

    private boolean canExecuteAction(int n, int n2, int n3, int n4, int n5) {
        boolean bl = false;
        if (n == n3) {
            switch (n3) {
                case 10: 
                case 13: 
                case 14: {
                    int n6 = Utils.unpackFirst(n4);
                    int n7 = n2;
                    bl = this.spawnedVehiclesIds[n7] == n6;
                    break;
                }
                case 5: {
                    int n8 = n4;
                    int n9 = n2;
                    bl = this.spawnedVehiclesIds[n9] == n8;
                    break;
                }
                default: {
                    bl = true;
                    break;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void executeAction(int n, int n2) {
        switch (n) {
            case 0: {
                Game.sendEvent(4, -1, -1);
                break;
            }
            case 1: {
                Game.sendEvent(11, -1, -1);
                break;
            }
            case 2: {
                ResourceManager.map.lockCameraInCurrentSegment();
                break;
            }
            case 3: {
                int n3 = this.spawnedVehiclesIds[n2];
                Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(n3);
                GameObjectManager.setGameTarget(vehicle);
                break;
            }
            case 4: {
                this.timer = n2 * 1000;
                this.prevTime = NineCanvas.getTime();
                this.timerRunning = true;
                Game.setGameTimer(this.timer);
            }
        }
    }

    private void updateTimer() {
        if (this.timerRunning) {
            long l = NineCanvas.getTime();
            int n = (int)(l - this.prevTime);
            this.prevTime = l;
            this.timer -= n;
            Game.setGameTimer(this.timer);
            if (this.timer <= 0) {
                this.handleEvent(18, -1, -1);
                Game.setGameTimer(0);
                this.timerRunning = false;
            }
        }
    }

    public int getType() {
        return this.configuration[0];
    }

    protected void finish() {
        this.finished = true;
    }

    public boolean isActive() {
        return !this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setGtm(GameTaskManager gameTaskManager) {
        this.gtm = gameTaskManager;
    }
}

