/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GameObject {
    public static final int X = 0;
    public static final int Y = 1;
    protected static int[] auxiliaryRect;
    protected int uId;
    protected int role;
    protected int reusableType;
    protected int drawingLayer;
    protected boolean active;
    protected boolean excludeFromCollisionCheckHint;
    protected boolean excludeFromVisibilityCheckHint;
    public boolean canBeRemoved;
    public int[] positionFP;
    public int[] boundsFP;
    public int[] collisionBoxFP;
    public int drawX;
    public int drawY;

    public static void initFields() {
        auxiliaryRect = new int[4];
    }

    protected GameObject(int n) {
        this.reusableType = n;
        this.positionFP = new int[2];
        this.collisionBoxFP = new int[4];
        this.boundsFP = new int[4];
    }

    protected void init(int n, int n2, int n3, int n4, int[] nArray) {
        this.uId = -1;
        this.role = n;
        this.drawingLayer = n4;
        this.active = false;
        this.excludeFromCollisionCheckHint = false;
        this.excludeFromVisibilityCheckHint = false;
        this.canBeRemoved = false;
        this.setPositionFP(n2, n3);
        this.setCollisionBox(-7, -7, 14, 14);
        this.setBoundsFP(0, 0, 0, 0);
        this.drawX = 0;
        this.drawY = 0;
    }

    public void deinit() {
    }

    public void update(int n) {
    }

    public void updateDrawPosition(int n, int n2) {
        this.drawX = n + Map.mapTilesFPToPixels(this.getPositionXFP() - ResourceManager.map.getCameraXFP());
        this.drawY = n2 + Map.mapTilesFPToPixels(this.getPositionYFP() - ResourceManager.map.getCameraYFP());
    }

    public void notifyAfterCollision(GameObject gameObject) {
    }

    public void notifyAfterCollisionWithTile(int n, int n2, int n3) {
    }

    public void render(Graphics graphics, int n, int n2, int n3, int n4) {
        this.draw(graphics, n, n2, n3, n4);
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void wasAddedToGameWorld() {
    }

    public void wasRemovedFromGameWorld() {
    }

    public int distanceTo(GameObject gameObject) {
        return Math.abs(gameObject.getPositionXFP() - this.getPositionXFP()) + Math.abs(gameObject.getPositionYFP() - this.getPositionYFP());
    }

    public int getuId() {
        return this.uId;
    }

    public void setuId(int n) {
        this.uId = n;
    }

    public boolean isInGameWorld() {
        return this.uId != -1;
    }

    public int getRole() {
        return this.role;
    }

    public int getWidthFP() {
        return this.getCollisionBoxFP()[2];
    }

    public int getHeightFP() {
        return this.getCollisionBoxFP()[3];
    }

    public int getBoundsWidthFP() {
        return this.boundsFP[2];
    }

    public int getBoundsHeightFP() {
        return this.boundsFP[3];
    }

    public void setPositionFP(int n, int n2) {
        this.setPositionXFP(n);
        this.setPositionYFP(n2);
    }

    public void setPositionXFP(int n) {
        this.positionFP[0] = n;
    }

    public void setPositionYFP(int n) {
        this.positionFP[1] = n;
    }

    public boolean isOnTheRightTo(GameObject gameObject) {
        return this.positionFP[0] > gameObject.positionFP[0];
    }

    public boolean isOnTheLeftTo(GameObject gameObject) {
        return this.positionFP[0] < gameObject.positionFP[0];
    }

    public boolean isAtTheTopTo(GameObject gameObject) {
        return this.positionFP[1] < gameObject.positionFP[1];
    }

    public boolean isAtTheBottomTo(GameObject gameObject) {
        return this.positionFP[1] > gameObject.positionFP[1];
    }

    public boolean isOnTheRightSideOf(GameObject gameObject) {
        return this.positionFP[0] > gameObject.positionFP[0] && this.positionFP[1] >= gameObject.getTopFP() && this.positionFP[1] <= gameObject.getBottomFP();
    }

    public boolean isOnTheLeftSideOf(GameObject gameObject) {
        return this.positionFP[0] < gameObject.positionFP[0] && this.positionFP[1] >= gameObject.getTopFP() && this.positionFP[1] <= gameObject.getBottomFP();
    }

    public boolean isAtTheBackOf(GameObject gameObject) {
        return this.positionFP[1] > gameObject.positionFP[1] && this.positionFP[0] >= gameObject.getLeftFP() && this.positionFP[0] <= gameObject.getRightFP();
    }

    public boolean isAtTheLeftBackOf(GameObject gameObject) {
        return this.positionFP[1] > gameObject.positionFP[1] && this.positionFP[0] < gameObject.getLeftFP();
    }

    public boolean isAtTheRightBackOf(GameObject gameObject) {
        return this.positionFP[1] > gameObject.positionFP[1] && this.positionFP[0] > gameObject.getRightFP();
    }

    public boolean isInFrontOf(GameObject gameObject) {
        return this.positionFP[1] < gameObject.positionFP[1] && this.positionFP[0] >= gameObject.getLeftFP() && this.positionFP[0] <= gameObject.getRightFP();
    }

    public boolean isLeftFrontOf(GameObject gameObject) {
        return this.positionFP[1] < gameObject.positionFP[1] && this.positionFP[0] < gameObject.getLeftFP();
    }

    public boolean isRightFrontOf(GameObject gameObject) {
        return this.positionFP[1] < gameObject.positionFP[1] && this.positionFP[0] > gameObject.getRightFP();
    }

    public int[] getCollisionBoxFP() {
        return this.collisionBoxFP;
    }

    public int getLeftFP() {
        return this.positionFP[0] + this.collisionBoxFP[0];
    }

    public int getRightFP() {
        return this.positionFP[0] + this.collisionBoxFP[0] + this.collisionBoxFP[2];
    }

    public int getTopFP() {
        return this.positionFP[1] + this.collisionBoxFP[1];
    }

    public int getBottomFP() {
        return this.positionFP[1] + this.collisionBoxFP[1] + this.collisionBoxFP[3];
    }

    public int getCenterXFP() {
        return this.positionFP[0] + this.collisionBoxFP[0] + this.collisionBoxFP[2] / 2;
    }

    public int getCenterYFP() {
        return this.positionFP[1] + this.collisionBoxFP[1] + this.collisionBoxFP[3] / 2;
    }

    public void setCenterXFP(int n) {
        this.setPositionXFP(n - this.getCollisionBoxFP()[0] - this.getWidthFP() / 2);
    }

    public void setCenterYFP(int n) {
        this.setPositionYFP(n - this.getCollisionBoxFP()[1] - this.getHeightFP() / 2);
    }

    public void setLeftFP(int n) {
        this.setPositionXFP(n - this.getCollisionBoxFP()[0]);
    }

    public void setRightFP(int n) {
        this.setPositionXFP(n - this.getCollisionBoxFP()[2] - this.getCollisionBoxFP()[0]);
    }

    public void setTopFP(int n) {
        this.setPositionYFP(n - this.getCollisionBoxFP()[1]);
    }

    public void setCollisionBox(int n, int n2, int n3, int n4) {
        this.setCollisionBoxFP(Map.mapPixelsToTilesFP(n), Map.mapPixelsToTilesFP(n2), Map.mapPixelsToTilesFP(n3), Map.mapPixelsToTilesFP(n4));
    }

    public void setCollisionBoxFP(int n, int n2, int n3, int n4) {
        this.collisionBoxFP[0] = n;
        this.collisionBoxFP[1] = n2;
        this.collisionBoxFP[2] = n3;
        this.collisionBoxFP[3] = n4;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBoundsFP(Map.mapPixelsToTilesFP(n), Map.mapPixelsToTilesFP(n2), Map.mapPixelsToTilesFP(n3), Map.mapPixelsToTilesFP(n4));
    }

    public void setBoundsFP(int n, int n2, int n3, int n4) {
        this.boundsFP[0] = n;
        this.boundsFP[1] = n2;
        this.boundsFP[2] = n3;
        this.boundsFP[3] = n4;
    }

    public int[] getBoundsFP() {
        return this.boundsFP;
    }

    public int getBoundsLeftFP() {
        return this.positionFP[0] + this.boundsFP[0];
    }

    public int getBoundsRightFP() {
        return this.positionFP[0] + this.boundsFP[0] + this.boundsFP[2];
    }

    public int getBoundsTopFP() {
        return this.positionFP[1] + this.boundsFP[1];
    }

    public int getBoundsBottomFP() {
        return this.positionFP[1] + this.boundsFP[1] + this.boundsFP[3];
    }

    public int[] getPositionFP() {
        return this.positionFP;
    }

    public int getPositionXFP() {
        return this.positionFP[0];
    }

    public int getPositionYFP() {
        return this.positionFP[1];
    }

    public int getCameraPositionXFP() {
        return this.getPositionXFP();
    }

    public int getCameraPositionYFP() {
        return this.getPositionYFP();
    }

    public int getDrawX() {
        return this.drawX;
    }

    public int getDrawY() {
        return this.drawY;
    }

    public int getDrawingLayer() {
        return this.drawingLayer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public void markForRemoval() {
        this.canBeRemoved = true;
    }

    public boolean isMarkedForRemoval() {
        return this.canBeRemoved;
    }

    public boolean isVehicle() {
        return this.role == 2 || this.role == 3 || this.role == 4 || this.role == 9;
    }
}

