/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Game {
    public static SimpleSprite hudMark;
    public static SimpleSprite spriteBreakables;
    public static SimpleSprite spriteJumpers;
    private static SimpleSprite spriteHudTimeKill;
    public static SimpleSprite spritePickup;
    public static SimpleSprite spriteExplosion;
    public static int weaponGun;
    public static int weaponAirRocket;
    public static int weaponBomb;
    public static int weaponRocket;
    public static int weaponSpikes;
    public static SimpleSprite weaponSmoke;
    private static int hudBottom;
    public static int[] MISSION_TEXTS_CUTSCENES;
    public static int[][][][] LEVEL_TASKS_CONFIGURATION;
    public static int[][] MAP_PLAYER_SKILLS;
    public static int[][] MAP_OBJECTS_CONFIGURATION;
    public static byte[][] MAP_OBJECTS_COLLISION_CONFIGURATION;
    public static byte[] MAP_OBJECTS_COLLISION_WITH_TILESET_CONFIGURATION;
    public static byte[] BULLETS_VEHICLE_COLLISION_CONFIGURATION;
    public static int[][] EQUIPMENT_CONFIGURATION;
    public static int[] LEVELS_WITH_NO_SCORES;
    public static int[][] GUNS;
    public static int[][] LOSE_CONTROL_SCRIPTS;
    public static int[] TROPHY_SCORES;
    public static int[][] PALETTES_DEFINITIONS;
    public static int[] ROLE_REUSABLE_TYPE_MAP;
    public static boolean wasInQuickGame;
    private static int mapProgressGroup;
    private static int mapProgressNoTasksInGroup;
    private static int[] mapProgressTaskTypes;
    private static int[] mapProgressTaskTypesComplete;
    private static int activeTaskId;
    private static int progress;
    private static int gameMapId;
    public static final int STATE_PLAYING = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_STATISTICS = 3;
    public static final int STATE_INPUT_SCREEN = 4;
    public static final int STATE_ENDING = 6;
    public static final int STATE_DEMO_EXPIRED = 7;
    public static final int STATE_GET_MORE_GAMES = 8;
    public static final int SUBSTATE_HERO_DIED = 2;
    public static final int SUBSTATE_PAN_VIEW = 128;
    public static final int SUBSTATE_CUTSCENE = 256;
    public static final int SUBSTATE_END_LEVEL = 512;
    public static final int SUBSTATE_MISSION_FAILED = 2048;
    public static final int GAME_FREEZING_SUBSTATES = 2818;
    public static final int INPUT_BLOCKING_SUBSTATES = 2818;
    private static boolean hudUpdateKilled;
    public static final int HUD_MAX_BOOST_TILES_FP = 9216;
    private static int currentState;
    private static int currentSubstates;
    private static int maxCurrentLevelPoints;
    private static int enemiesToKill;
    private static boolean isTrophyDestroyerAvailable;
    private static boolean[] trophyAchieved;
    private static int currentLevelPoints;
    private static int currentGameTimerMS;
    private static int numEnemiesKilled;
    private static int numCiviliansKilled;
    public static int numDeathsCount;
    public static int pointsEnemies;
    public static int pointsCivilians;
    public static long levelTime;
    public static String levelTimeVerbose;
    public static int[] textFieldParams;
    public static String[][] textFieldMessages;
    private static String prevBackSoftKey;
    private static String prevFwrdSoftKey;
    private static long panTimerStart;
    private static int panStripH;
    private static boolean panStart;
    private static final String HUD_MASK_OF_ZEROS = "00000";
    private static int hudScore;
    private static String hudScoreText;
    private static int hudTime;
    private static String hudTimeOrKilledText;
    private static int hudGadgetGrabbedTimer;
    private static int hudWeaponGrabbedTimer;
    private static int[] hudAuxBounds;
    private static final int HUD_SCORE_PHASE_IDLE = -1;
    private static final int HUD_SCORE_PHASE_DOWN = 0;
    private static final int HUD_SCORE_PHASE_UP = 1;
    private static int hudScoreAnim;
    private static int hudScorePhase;
    protected static final int MAX_EVENTS = 32;
    protected static final int EVENT_SIZE = 3;
    protected static final int EVENT_ID = 0;
    protected static final int EVENT_PARAM_1 = 1;
    protected static final int EVENT_PARAM_2 = 2;
    protected static int[] eventQueue;
    protected static int eventQueueSize;
    public static boolean cutsceneIsPlaying;
    private static int cutsceneStep;
    public static boolean cutsceneFinished;
    private static boolean cutscenePlayed;
    private static boolean endLevelAfterCutscene;
    private static String[] splitText;
    private static final int ACTOR_BOND = 0;
    private static final int ACTOR_COURIER = 1;
    private static final int ACTOR_M = 3;
    private static final int ACTOR_OPERATIVE = 4;
    private static final int ACTOR_POMEROV = 6;
    private static final int ACTOR_Q = 7;
    private static final int ACTOR_RAK = 8;
    private static final int ACTOR_GOAL = 32;
    private static final int ACTOR_BANG = 33;
    private static final int ACTOR_MAX = 53;
    private static int currentGoalTextId;
    private static int currentBang;
    private static int[] BANG_COORDS;
    private static long bangTimer;
    private static final int BANG_TIME_INTERVAL = 500;
    private static int[] actorsRoles;
    private static int[] actorsFilmOffsets;
    private static short[] ACTORS_SPRITESET_ID;
    private static int[] bounds;
    private static short[] ACTORS_TILES_IDS;
    private static int whosTalking;
    private static final int ACTOR_ROLE_LEFT = 0;
    private static final int ACTOR_ROLE_RIGHT = 1;
    private static final int ACTOR_ROLE_BACKGROUND = 2;
    private static final int ACTOR_ROLE_FILM = 3;
    private static final int ACTOR_ROLE_BANG = 4;
    private static final int COMMAND_SET_ACTORS = -1;
    private static final int COMMAND_TALK = -2;
    private static final int COMMAND_END_CUTSCENE = -3;
    private static final int COMMAND_RENDER_FADE_IN = -4;
    private static final int COMMAND_RENDER_FADE_OUT = -5;
    private static final int COMMAND_SET_FADE_TIMER = -6;
    private static final int COMMAND_PLAY_FILM = -7;
    private static final int COMMAND_END_LEVEL_AFTER_CUTSCENE = -8;
    private static final int COMMAND_BANG = -9;
    private static long fadeStartTime;
    private static boolean waitForCutsceneInit;
    private static boolean splitTextAgain;
    private static int oldCutsceneStep;
    private static int scrollY;
    private static int[] CUTSCENE_TEXT_WIDTHS;
    private static final int COLOR_BORDER = 0x7E7C7C;
    private static final int BLINK_COUNTER_MAX = 20;
    private static int blinkCounter;
    private static short[] CUTSCENE_SCRIPT;
    private static int currentSlide;
    private static int maxSlides;
    private static int startSlide;
    private static byte[] playedCutscenes;
    private static final int SCROLL_SPEED = 2;
    public static boolean wasIngame;
    public static long deltaTimeDemo;
    public static long timeDemo;
    public static long lastTimeDemo;
    public static long testeDemo;
    private static int[] markedEnemies;
    private static SimpleSprite cutsceneSprite;

    public static void initFields() {
        CUTSCENE_TEXT_WIDTHS = new int[]{150, 150, 160};
        bounds = new int[4];
        actorsRoles = new int[53];
        actorsFilmOffsets = new int[106];
        BANG_COORDS = new int[]{50, 50, 70, 70, 70, 120};
        eventQueue = new int[96];
        progress = Integer.MAX_VALUE;
    }

    private static boolean isWaterLevel() {
        return NineCanvas.currentQuickStoryLevel == 3 || NineCanvas.currentQuickStoryLevel == 6 || NineCanvas.currentQuickStoryLevel == 10;
    }

    public static void init() {
        spriteJumpers = ResourceManager.createSprite(Game.isWaterLevel() ? 151 : 150, null);
        spriteBreakables = ResourceManager.createSprite(Game.isWaterLevel() ? 153 : 152, null);
        hudMark = ResourceManager.createSprite(129, null);
        spriteHudTimeKill = ResourceManager.createSprite(154, null);
        spriteExplosion = ResourceManager.createSprite(130, null);
        weaponGun = NineCanvas.instance.loadImageID(68);
        weaponAirRocket = NineCanvas.instance.loadImageID(64);
        weaponBomb = NineCanvas.instance.loadImageID(66);
        weaponRocket = NineCanvas.instance.loadImageID(70);
        weaponSpikes = NineCanvas.instance.loadImageID(74);
        weaponSmoke = ResourceManager.createSprite(155, null);
        hudBottom = NineCanvas.instance.loadImageID(14);
        markedEnemies = new int[56];
        currentSubstates = 0;
        Game.resetPoints(true);
        numDeathsCount = 0;
        Game.setGameState(0);
        levelTime = NineCanvas.getTime();
        trophyAchieved = new boolean[TROPHY_SCORES.length];
        Game.hudInit();
        Game.initCutscenes();
        wasInQuickGame = NineCanvas.getGameMode() == 1;
        for (int i = 0; i < trophyAchieved.length; ++i) {
            Game.trophyAchieved[i] = true;
        }
        eventQueueSize = 0;
    }

    public static void endLevel() {
        if (currentState != 0) {
            return;
        }
        if (NineCanvas.gluDemoMode != 0 && NineCanvas.gluDemoFreeLevels > 0 && NineCanvas.currentLevel >= NineCanvas.gluDemoFreeLevels) {
            NineCanvas.gluDemoExpired = true;
            Game.setGameState(7);
        } else if (NineCanvas.currentQuickStoryLevel > 0 || NineCanvas.currentQuickStoryLevel >= 0) {
            Game.setGameState(3);
        } else {
            Game.deinit(false);
        }
    }

    public static void deinit(boolean bl) {
        if (NineCanvas.getGameMode() == 0 && currentState != 1 && !bl) {
            maxCurrentLevelPoints = 0;
            if ((NineCanvas.currentLevel = (byte)(NineCanvas.currentLevel + 1)) > NineCanvas.unlockedLevel) {
                NineCanvas.unlockedLevel = NineCanvas.currentLevel;
            }
            if (NineCanvas.currentLevel > Consts.GAME_LEVELS_COUNT) {
                NineCanvas.setGameMode(-1);
                NineCanvas.isInStoryMode = false;
                NineCanvas.currentLevel = 0;
                ResourceManager.saveRMS(1);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6), true);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6, gameMapId), true);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(5));
                NineCanvas.instance.setLoadingNextState(5);
            } else {
                NineCanvas.instance.stopSound();
                ResourceManager.saveRMS(1);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6, gameMapId), true);
                NineCanvas.instance.setLoadingNextState(8);
            }
        } else {
            NineCanvas.instance.stopSound();
            if (NineCanvas.getGameMode() == 0) {
                if (NineCanvas.currentLevel == 1) {
                    NineCanvas.isInStoryMode = false;
                }
                ResourceManager.saveRMS(1);
            }
            currentState = 0;
            if (bl) {
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6), true);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6, gameMapId), true);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6), false);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6, gameMapId), false);
                NineCanvas.instance.setLoadingNextState(6);
            } else {
                maxCurrentLevelPoints = 0;
                currentState = 0;
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6), true);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6, gameMapId), true);
                ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(5));
                NineCanvas.instance.setLoadingNextState(5);
            }
        }
        NineCanvas.instance.setCurrentState(4);
        NineCanvas.resumeTimer();
        Game.hudDeinit();
    }

    public static void deinitDemo() {
        NineCanvas.instance.stopSound();
        if (NineCanvas.getGameMode() == 0) {
            if (NineCanvas.currentLevel == 1) {
                NineCanvas.isInStoryMode = false;
            }
            ResourceManager.saveRMS(1);
        }
        maxCurrentLevelPoints = 0;
        currentState = 0;
        ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6), true);
        ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(6, gameMapId), true);
        ResourceManager.copyToQueue(ResourceManager.getResourcesDefinition(5));
        NineCanvas.instance.setLoadingNextState(5);
        NineCanvas.instance.setCurrentState(4);
        NineCanvas.resumeTimer();
        Game.hudDeinit();
    }

    public static void resume() {
        NineCanvas.isSoundPlay = false;
        NineCanvas.instance.setSoftkeys(prevBackSoftKey, prevFwrdSoftKey);
        NineCanvas.resetKeys();
        Game.setGameState(0);
    }

    public static void render(Graphics graphics) {
        ResourceManager.map.render(graphics);
        switch (currentState) {
            case 0: {
                if (!Game.isGameSubstate(256)) {
                    Game.hudRender(graphics, false);
                }
                Game.renderSubstates(graphics);
                break;
            }
            case 7: {
                wasIngame = true;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                Game.hudRender(graphics, true);
                if (Game.isGameSubstate(2)) {
                    graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                }
                if (currentState == 1) {
                    graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.mainFontHeight + 1 + 0);
                }
                Menu.render(graphics);
            }
        }
        NineCanvas.instance.renderSoftkeys(graphics);
    }

    private static void hudInit() {
        hudAuxBounds = new int[4];
        spritePickup = ResourceManager.createSprite(131, null);
        hudScorePhase = -1;
        hudUpdateKilled = true;
        hudGadgetGrabbedTimer = 0;
        hudWeaponGrabbedTimer = 0;
        hudScore = 0;
        hudScoreText = HUD_MASK_OF_ZEROS;
        hudTime = 0;
        hudTimeOrKilledText = "";
        currentGameTimerMS = -1;
        Game.setInfoForProgressBar(NineCanvas.getMappedLevelId());
    }

    private static void hudDeinit() {
        spriteJumpers = null;
        spriteBreakables = null;
        hudMark = null;
        spriteHudTimeKill = null;
        spriteExplosion = null;
        weaponSmoke = null;
        markedEnemies = null;
        trophyAchieved = null;
        playedCutscenes = null;
        eventQueueSize = 0;
        hudAuxBounds = null;
        hudAuxBounds = null;
        spritePickup = null;
    }

    private static void hudUpdate(int n) {
        Game.updateMapProgressBar();
        boolean bl = currentGameTimerMS != -1;
        int n2 = currentGameTimerMS / 1000;
        if (bl) {
            if (hudTime != n2) {
                hudTime = n2;
                int n3 = hudTime / 60;
                int n4 = hudTime - n3 * 60;
                hudTimeOrKilledText = n3 + (n4 < 10 ? ":0" : ":") + n4;
            }
        } else if (hudUpdateKilled) {
            hudTimeOrKilledText = numEnemiesKilled + "/" + enemiesToKill;
            hudUpdateKilled = false;
        }
        if (hudGadgetGrabbedTimer > 0) {
            hudGadgetGrabbedTimer -= n;
        }
        if (hudWeaponGrabbedTimer > 0) {
            hudWeaponGrabbedTimer -= n;
        }
    }

    private static int getScoreYOffset() {
        return 0;
    }

    private static void hudRender(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (NineCanvas.useDoubleBuffer) {
            // empty if block
        }
        Vehicle vehicle = GameObjectManager.getGameHero();
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        graphics.setColor(0x888888);
        graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.mainFontHeight + 1 + 0);
        graphics.setColor(0);
        graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.mainFontHeight + 0);
        if (!bl) {
            NineCanvas.instance.drawImageIDNoTransform(graphics, hudBottom, 0, 0, NineCanvas.SCREEN_HEIGHT, 36);
            int n8 = NineCanvas.instance.getImageDimension(hudBottom, 0, 0, 0);
            graphics.setColor(0);
            graphics.fillRect(n8, NineCanvas.SCREEN_HEIGHT - 16, NineCanvas.SCREEN_WIDTH - n8, 16);
            graphics.setColor(0x888888);
            graphics.fillRect(n8, NineCanvas.SCREEN_HEIGHT - 16 - 1, NineCanvas.SCREEN_WIDTH - n8, 1);
        }
        if (Utils.arrayFind(LEVELS_WITH_NO_SCORES, NineCanvas.currentQuickStoryLevel) == -1) {
            String string = Integer.toString(Game.getCurrentLevelPoints());
            hudScoreText = HUD_MASK_OF_ZEROS.substring(0, HUD_MASK_OF_ZEROS.length() - string.length()).concat(string);
            NineCanvas.instance.drawString(graphics, hudScoreText, 13, 0, 20, -1);
        }
        NineCanvas.instance.drawString(graphics, hudTimeOrKilledText, NineCanvas.SCREEN_WIDTH - 20, 0, 24, -1);
        spriteHudTimeKill.render(graphics, NineCanvas.SCREEN_WIDTH, NineCanvas.mainFontHeight / 2, 10, currentGameTimerMS != -1 ? 0 : 1, 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        if (bl) {
            return;
        }
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(NineCanvas.SCREEN_WIDTH - 1 - 4, NineCanvas.SCREEN_HEIGHT - 1 - 10, 4, 10);
        graphics.fillRect(NineCanvas.SCREEN_WIDTH - 1 - 4 - 1 - 4, NineCanvas.SCREEN_HEIGHT - 1 - 10, 4, 10);
        if (NineCanvas.testCheats) {
            // empty if block
        }
        int n9 = 0;
        n9 += Utils.ceili(vehicle.getHealthPoints() * 5, vehicle.getMaxHealthPoints());
        n9 += Utils.ceili(vehicle.getArmorPoints() * 3, vehicle.getMaxArmorPoints());
        int n10 = NineCanvas.SCREEN_WIDTH - 1 - 4 - 1 - 4 - 3 - 48 - 14;
        int n11 = NineCanvas.SCREEN_HEIGHT - 1 - 5;
        for (n7 = 0; n7 < 8; ++n7) {
            n6 = n7 < 5 ? (n7 < n9 ? 0xFF0000 : 0x550000) : (n7 < n9 ? 0xFFFF00 : 0x555500);
            graphics.setColor(n6);
            graphics.fillRect(n10, n11, 6, 5);
            n10 += 8;
        }
        n7 = 8;
        n6 = BRCanvasMaths.Fdiv(BRCanvasMaths.Fmul(vehicle.getBoostFP(), 9216), vehicle.getBoostMaxFP());
        n6 = BRCanvasMaths.FToi(n6);
        int n12 = NineCanvas.SCREEN_WIDTH - 1 - 4 - 1 - 4 - 3 - 48 - 14;
        int n13 = NineCanvas.SCREEN_HEIGHT - 1 - 5 - 2 - 5;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5 < n6 ? 255 : 85;
            graphics.setColor(n4);
            graphics.fillRect(n12, n13, 6, 5);
            n12 += 8;
        }
        n5 = vehicle.getGadget();
        n4 = vehicle.getGadgetAmmo();
        if (n4 != -1) {
            n3 = EQUIPMENT_CONFIGURATION[n5][1];
            Game.hudDrawEquipmentProggressBarLight(graphics, 1, NineCanvas.SCREEN_HEIGHT - 1 - 3, Consts.HUD_WEAPON_MAG_BAR_WIDTH, 3, 0x888888, 7171562, n4, n3);
        }
        int n14 = n3 = hudGadgetGrabbedTimer > 0 && hudGadgetGrabbedTimer / 112 % 2 == 0 ? 1 : 0;
        if (n3 == 0) {
            n2 = n5 - 2;
            spritePickup.render(graphics, 1 + Consts.HUD_WEAPON_MAG_BAR_WIDTH / 2 - spritePickup.getBoundsWidth(n2) / 2 + 0, NineCanvas.SCREEN_HEIGHT - 1 - 3 - 1 - spritePickup.getBoundsHeight(n2) + -5, 20, n2, 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        }
        n2 = vehicle.getWeapon();
        int n15 = vehicle.getWeaponAmmo();
        if (n15 != -1) {
            n = EQUIPMENT_CONFIGURATION[n2][1];
            Game.hudDrawEquipmentProggressBarLight(graphics, 1 + Consts.HUD_WEAPON_MAG_BAR_WIDTH + 1 + 0 + 0, NineCanvas.SCREEN_HEIGHT - 1 - 3, Consts.HUD_WEAPON_MAG_BAR_WIDTH, 3, 0x888888, 7171562, n15, n);
        }
        int n16 = n = hudWeaponGrabbedTimer > 0 && hudWeaponGrabbedTimer / 112 % 2 == 0 ? 1 : 0;
        if (n == 0) {
            int n17 = n2;
            spritePickup.render(graphics, 1 + Consts.HUD_WEAPON_MAG_BAR_WIDTH + 1 + Consts.HUD_WEAPON_MAG_BAR_WIDTH / 2 - spritePickup.getBoundsWidth(n17) / 2 + 0 + 0, NineCanvas.SCREEN_HEIGHT - 1 - 3 - 1 - spritePickup.getBoundsHeight(n17) + -5, 20, n17, 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        }
        Game.renderMapProgressBar(graphics);
    }

    private static void renderMapProgressBar(Graphics graphics) {
        int n = 80;
        int n2 = n / mapProgressNoTasksInGroup;
        if (activeTaskId < 0) {
            return;
        }
        progress = Game.isGameSubstate(512) ? n : activeTaskId * n2 + Game.convertTaskProgressToBar(n2, mapProgressTaskTypesComplete[activeTaskId]);
        graphics.setClip(72, NineCanvas.SCREEN_HEIGHT + -10, n, 4);
        graphics.setColor(0x888888);
        graphics.fillRect(72, NineCanvas.SCREEN_HEIGHT + -10, n, 4);
        graphics.setColor(65280);
        graphics.fillRect(72, NineCanvas.SCREEN_HEIGHT + -10, progress, 4);
    }

    private static void updateMapProgressBar() {
        GameTaskManager gameTaskManager = GameTaskManager.getInstance();
        activeTaskId = gameTaskManager.getActiveTaskId(mapProgressGroup);
        if (activeTaskId < 0) {
            return;
        }
        GameTask gameTask = gameTaskManager.getActiveTask(mapProgressGroup);
        if ((mapProgressTaskTypes[activeTaskId] & 2) != 0) {
            Game.mapProgressTaskTypesComplete[Game.activeTaskId] = gameTask.getDestroyedVehiclesCount() * 100 / gameTask.getTotalVehicles();
        } else {
            int n = gameTask.getSegmentsCurrentLength() + ResourceManager.map.getPositionInCurrentSegment(ResourceManager.map.getCameraYFP());
            Game.mapProgressTaskTypesComplete[Game.activeTaskId] = n * 100 / gameTask.getSegmentsOverallLength();
        }
    }

    private static int convertTaskProgressToBar(int n, int n2) {
        return n * n2 / 100;
    }

    public static void hudGadgetGrabbed(int n) {
        hudGadgetGrabbedTimer = 500;
    }

    public static void hudWeaponGrabbed(int n) {
        hudWeaponGrabbedTimer = 500;
    }

    private static void hudDrawEquipmentProgressBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    private static void hudDrawEquipmentProggressBarLight(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = Utils.ceili(n7 * n3, n8);
        graphics.setClip(n, n2, n3, n4);
        graphics.setColor(n6);
        graphics.fillRect(n, n2, n9, n4);
        graphics.setColor(n5);
        graphics.fillRect(n + n9, n2, n3 - n9, n4);
    }

    public static void setGameTimer(int n) {
        currentGameTimerMS = n;
    }

    private static void renderSubstates(Graphics graphics) {
        if (Game.isGameSubstate(2)) {
            graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
            graphics.setColor(0);
            graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
            graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
            if (NineCanvas.getTime() - fadeStartTime <= 500L) {
                // empty if block
            }
            Game.renderMessage(graphics, 75, 78);
        }
        if (Game.isGameSubstate(128)) {
            Game.renderPanView(graphics);
        }
        if (Game.isGameSubstate(256)) {
            Game.renderCutscene(graphics, true);
        }
        if (Game.isGameSubstate(512)) {
            Game.renderMessage(graphics, 77, 78);
        }
        if (Game.isGameSubstate(2048)) {
            Game.renderMessage(graphics, 81, 78);
        }
    }

    private static void renderMessage(Graphics graphics, int n, int n2) {
        String string = NineCanvas.instance.getString(n) + "\n" + NineCanvas.instance.getString(n2);
        String[] stringArray = NineCanvas.instance.splitString(string, NineCanvas.font_green, Menu.getMenuBackgroundWidth() * 3 / 4);
        Menu.renderTextField(graphics, stringArray);
    }

    private static void renderPanView(Graphics graphics) {
        graphics.setColor(0);
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, panStripH);
    }

    public static void update(int n) {
        switch (currentState) {
            case 0: {
                if (NineCanvas.gluDemoMode != 0 && NineCanvas.gluDemoPlayLimit > 0 && NineCanvas.gluDemoRemainingPlays <= 0) {
                    NineCanvas.gluDemoExpired = true;
                }
                if (NineCanvas.gluDemoMode != 0 && NineCanvas.gluDemoTimeLimit > 0) {
                    timeDemo = System.currentTimeMillis();
                    if (lastTimeDemo > 0L && (deltaTimeDemo += timeDemo - lastTimeDemo) > (long)NineCanvas.gluDemoTimeLimit) {
                        NineCanvas.gluDemoExpired = true;
                        Game.setGameState(7);
                    }
                    lastTimeDemo = System.currentTimeMillis();
                }
                if (NineCanvas.sfkReverse) {
                    if (Game.isGameSubstate(256) || Game.isGameSubstate(2)) {
                        if (NineCanvas.isKeyPressed(0x2000000)) {
                            Game.setGameState(1);
                            return;
                        }
                    } else if (NineCanvas.isKeyPressed(4096) || NineCanvas.isKeyPressed(0x1000000)) {
                        Game.setGameState(1);
                        return;
                    }
                } else if (NineCanvas.isKeyPressed(4096) || NineCanvas.isKeyPressed(0x2000000)) {
                    Game.setGameState(1);
                    return;
                }
                if (Game.isGameSubstate(2818) || ResourceManager.map.getLockedOnObject() != GameObjectManager.getGameHero() || ResourceManager.map.hasCameraReachedObject()) {
                    // empty if block
                }
                if (!Game.isGameSubstate(2818)) {
                    NineCanvas.resumeTimer();
                    ResourceManager.map.update(n);
                    GameTaskManager.getInstance().update(n);
                    Game.broadcastEvents();
                    Game.hudUpdate(n);
                } else {
                    NineCanvas.pauseTimer();
                }
                Game.updateSubstates();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                Menu.update();
            }
        }
    }

    public static void handleEvent(int n, int n2, int n3) {
        switch (n) {
            case 2: {
                int n4 = n2;
                Game.startCutscene(n4);
                break;
            }
            case 4: {
                Game.setGameSubstate(512);
                break;
            }
            case 11: {
                Game.setGameSubstate(2048);
                break;
            }
            case 10: {
                int n5 = Utils.unpackFirst(n2);
                Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(n5);
                int n6 = Utils.unpackSecond(n3);
                if (n6 != 2) break;
                Game.refreshPoints(vehicle, true);
                break;
            }
            case 13: {
                int n7 = Utils.unpackFirst(n2);
                Vehicle vehicle = (Vehicle)GameObjectManager.getGameObject(n7);
                int n8 = Utils.unpackSecond(n3);
                if (n8 != 2) break;
                Game.refreshPoints(vehicle, false);
                break;
            }
        }
    }

    private static void updateSubstates() {
        if (Game.isGameSubstate(512) && NineCanvas.isKeyPressed(0x100020)) {
            Game.endLevel();
        }
        if (Game.isGameSubstate(2048) && NineCanvas.isKeyPressed(0x100020)) {
            Game.deinit(true);
        }
        if (!Game.isGameSubstate(2) && GameObjectManager.getGameHero().getState() == 5) {
            ++numDeathsCount;
            Game.setGameSubstate(2);
        }
        if (Game.isGameSubstate(256)) {
            Game.updateCutscene();
        }
        if (Game.isGameSubstate(2)) {
            long l = NineCanvas.getTime() - fadeStartTime;
            if (l <= 500L) {
                // empty if block
            }
            if (NineCanvas.isKeyPressed(0x1100020)) {
                Game.unsetGameSubstate(2);
            }
        }
        if (Game.isGameSubstate(128)) {
            if (panStart) {
                int n = NineCanvas.mainFontHeight + 1 + 0;
                int n2 = 17;
                panStripH = Math.max(n, n2);
            } else {
                int n = NineCanvas.mainFontHeight + 1 + 0;
                int n3 = 17;
                panStripH = Math.max(n, n3);
            }
            if (!panStart && panStripH == 0) {
                Game.unsetGameSubstate(128);
            }
        }
    }

    public static void panTrigger(boolean bl) {
        panStart = bl;
        panTimerStart = NineCanvas.getTimeTick();
    }

    public static void setGameState(int n) {
        switch (n) {
            case 6: {
                Menu.menuLoad(12, 3840);
                NineCanvas.pauseTimer();
                break;
            }
            case 1: {
                prevBackSoftKey = BRCanvasCore.back_softkey_string;
                prevFwrdSoftKey = BRCanvasCore.fwrd_softkey_string;
                NineCanvas.instance.stopSound();
                Menu.menuLoad(16, 3840);
                NineCanvas.pauseTimer();
                break;
            }
            case 7: {
                Menu.menuLoad(26, 3840);
                NineCanvas.pauseTimer();
                break;
            }
            case 3: {
                Menu.menuLoad(17, 3840);
                NineCanvas.pauseTimer();
                break;
            }
            case 4: {
                Menu.menuLoad(18, 3840);
                NineCanvas.pauseTimer();
                break;
            }
            case 0: {
                if (NineCanvas.gluDemoPlayLimit > 0 && !NineCanvas.gluDemoplayLimitReduced && NineCanvas.gluDemoPlayLimit > 0) {
                    byte[] byArray = new byte[]{(byte)(--NineCanvas.gluDemoRemainingPlays)};
                    NineCanvas.instance.setRecordStoreData(byArray, 3);
                    NineCanvas.gluDemoplayLimitReduced = true;
                }
                oldCutsceneStep = -1;
                scrollY = 0;
                waitForCutsceneInit = false;
                splitTextAgain = true;
                if (Game.isGameSubstate(2)) break;
                NineCanvas.resumeTimer();
            }
        }
        currentState = n;
    }

    public static int getGameState() {
        return currentState;
    }

    public static void setGameSubstate(int n) {
        switch (n) {
            case 512: {
                levelTime = NineCanvas.getTime() - levelTime;
                levelTimeVerbose = Utils.getVerboseTime(levelTime);
                Game.checkTrophies();
                break;
            }
            case 2: {
                Game.resetPoints(false);
                Game.trophyAchieved[2] = false;
                NineCanvas.instance.setSoftkeys(NineCanvas.instance.getString(56), NineCanvas.instance.getString(57));
                break;
            }
            case 128: {
                Game.panTrigger(true);
            }
        }
        currentSubstates |= n;
    }

    public static boolean isGameSubstate(int n) {
        return (n & currentSubstates) != 0;
    }

    private static void resetPoints(boolean bl) {
        numEnemiesKilled = bl ? 0 : numEnemiesKilled;
        pointsEnemies = 0;
        numCiviliansKilled = 0;
        pointsCivilians = 0;
        currentLevelPoints = 0;
        hudUpdateKilled = true;
    }

    public static void unsetGameSubstate(int n) {
        currentSubstates &= ~n;
        switch (n) {
            case 2: {
                NineCanvas.instance.setSoftkeys(NineCanvas.instance.getString(56), "");
                ResourceManager.map.spawnPlayerToNearestSpawnPoint();
                GameObjectManager.getGameHero().respawn();
                ResourceManager.map.lockViewOnGameObject(GameObjectManager.getGameHero(), true);
            }
        }
    }

    public static int getGameMapId() {
        return gameMapId;
    }

    public static void setGameMap(Map map, int n) {
        gameMapId = n;
    }

    public static void refreshPoints(Vehicle vehicle, boolean bl) {
        if (vehicle.getRole() == 3 && vehicle.getAnimationsetId() != 143) {
            currentLevelPoints += vehicle.scorePointsAfterKill;
            ++numEnemiesKilled;
            pointsEnemies += vehicle.scorePointsAfterKill;
            hudUpdateKilled = true;
        } else {
            if (!bl) {
                return;
            }
            currentLevelPoints += vehicle.scorePointsAfterKill;
            Game.trophyAchieved[3] = false;
            ++numCiviliansKilled;
            pointsCivilians += vehicle.scorePointsAfterKill;
        }
        if (hudScorePhase == -1) {
            hudScorePhase = 0;
            hudScore = vehicle.scorePointsAfterKill;
        }
        currentLevelPoints = Math.max(0, currentLevelPoints);
    }

    private static void checkTrophies() {
        if (numEnemiesKilled < enemiesToKill) {
            Game.trophyAchieved[1] = false;
        }
        if (isTrophyDestroyerAvailable) {
            Game.trophyAchieved[3] = false;
            if (!trophyAchieved[1] || !trophyAchieved[2]) {
                Game.trophyAchieved[0] = false;
            }
        } else {
            Game.trophyAchieved[1] = false;
            if (!trophyAchieved[3] || !trophyAchieved[2]) {
                Game.trophyAchieved[0] = false;
            }
        }
        if (trophyAchieved[0]) {
            for (int i = 1; i < trophyAchieved.length; ++i) {
                Game.trophyAchieved[i] = false;
            }
        }
    }

    public static int getTrophyAchieved() {
        int n = -1;
        for (int i = 0; i < trophyAchieved.length; ++i) {
            if (!trophyAchieved[i]) continue;
            return i;
        }
        return n;
    }

    public static int getMaxLevelPoints() {
        return maxCurrentLevelPoints;
    }

    public static void setInfoForProgressBar(int n) {
        mapProgressTaskTypes = null;
        mapProgressTaskTypesComplete = null;
        activeTaskId = -1;
        progress = Integer.MAX_VALUE;
        mapProgressNoTasksInGroup = -1;
        mapProgressGroup = -1;
        int[][][] nArray = LEVEL_TASKS_CONFIGURATION[n];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (mapProgressGroup == -1) {
                    switch (nArray[i][j][0]) {
                        case 1: 
                        case 59: {
                            mapProgressGroup = i;
                            mapProgressNoTasksInGroup = nArray[i].length;
                            mapProgressTaskTypes = new int[mapProgressNoTasksInGroup];
                            mapProgressTaskTypesComplete = new int[mapProgressNoTasksInGroup];
                        }
                    }
                }
                if (mapProgressGroup <= -1) continue;
                Game.mapProgressTaskTypes[j] = nArray[i][j][0];
                Game.mapProgressTaskTypesComplete[j] = 0;
            }
            if (mapProgressGroup > -1) break;
        }
    }

    public static void setMaxLevelPoints(int n) {
        maxCurrentLevelPoints = 0;
        enemiesToKill = 0;
        int[][][] nArray = LEVEL_TASKS_CONFIGURATION[n];
        for (int i = 0; i < nArray.length; ++i) {
            block4: for (int j = 0; j < nArray[i].length; ++j) {
                switch (nArray[i][j][0]) {
                    case 1: 
                    case 59: {
                        int n2 = 3 + nArray[i][j][1];
                        int n3 = n2 + 1;
                        int n4 = n3 + nArray[i][j][n2] * 3;
                        for (int k = n3; k < n4; k += 3) {
                            if (MAP_OBJECTS_CONFIGURATION[nArray[i][j][k]][9] <= 0) continue;
                            maxCurrentLevelPoints += MAP_OBJECTS_CONFIGURATION[nArray[i][j][k]][9];
                            ++enemiesToKill;
                        }
                        continue block4;
                    }
                }
            }
        }
        isTrophyDestroyerAvailable = enemiesToKill > 0;
        maxCurrentLevelPoints += TROPHY_SCORES[0];
    }

    public static int getCurrentLevelPoints() {
        return currentLevelPoints;
    }

    public static boolean insertMarkedEnemy(int n) {
        if (markedEnemies[n - 124] == 0) {
            Game.markedEnemies[n - 124] = 1;
            return true;
        }
        return false;
    }

    public static void sendEvent(int n, int n2, int n3) {
        Game.eventQueue[Game.eventQueueSize + 0] = n;
        Game.eventQueue[Game.eventQueueSize + 1] = n2;
        Game.eventQueue[Game.eventQueueSize + 2] = n3;
        eventQueueSize += 3;
    }

    public static void sendEventImmediately(int n, int n2, int n3) {
        Game.broadcastEvent(n, n2, n3);
    }

    public static void broadcastEvents() {
        for (int i = 0; i < eventQueueSize; i += 3) {
            Game.broadcastEvent(eventQueue[i + 0], eventQueue[i + 1], eventQueue[i + 2]);
        }
        eventQueueSize = 0;
    }

    private static void broadcastEvent(int n, int n2, int n3) {
        GameTaskManager.getInstance().handleEvent(n, n2, n3);
        Game.handleEvent(n, n2, n3);
    }

    public static void updateCutscene() {
        if (oldCutsceneStep > -1) {
            cutsceneStep = oldCutsceneStep;
            oldCutsceneStep = -1;
            scrollY = 0;
            waitForCutsceneInit = false;
            splitTextAgain = true;
        }
        switch (CUTSCENE_SCRIPT[cutsceneStep]) {
            case -9: {
                int n = BANG_COORDS.length / 2 + 1;
                whosTalking = 33;
                if (currentBang < n) {
                    if (currentBang == 0) {
                        bangTimer = NineCanvas.getTime();
                        ++currentBang;
                    } else if (NineCanvas.getTime() - bangTimer > 500L) {
                        if (currentBang < n - 1) {
                            // empty if block
                        }
                        bangTimer = NineCanvas.getTime();
                        ++currentBang;
                    }
                }
                if (currentBang < n) break;
                currentBang = 0;
                ++cutsceneStep;
                break;
            }
            case -8: {
                endLevelAfterCutscene = true;
                ++cutsceneStep;
                break;
            }
            case -6: {
                waitForCutsceneInit = true;
                fadeStartTime = NineCanvas.getTime();
                ++cutsceneStep;
                break;
            }
            case -5: {
                ++cutsceneStep;
                break;
            }
            case -4: {
                ++cutsceneStep;
                break;
            }
            case -1: {
                int n = CUTSCENE_SCRIPT[++cutsceneStep];
                for (int i = 0; i < n; ++i) {
                    int n2;
                    short s = CUTSCENE_SCRIPT[++cutsceneStep];
                    Game.actorsRoles[s] = n2 = CUTSCENE_SCRIPT[++cutsceneStep];
                }
                ++cutsceneStep;
                break;
            }
            case -7: {
                if (--blinkCounter < 0) {
                    blinkCounter = 20;
                }
                if (currentSlide == -1) {
                    currentSlide = 0;
                }
                waitForCutsceneInit = false;
                int n = cutsceneStep++;
                maxSlides = CUTSCENE_SCRIPT[cutsceneStep];
                startSlide = CUTSCENE_SCRIPT[++cutsceneStep];
                whosTalking = CUTSCENE_SCRIPT[cutsceneStep += currentSlide * 3];
                Game.actorsFilmOffsets[Game.whosTalking * 2] = CUTSCENE_SCRIPT[++cutsceneStep];
                Game.actorsFilmOffsets[Game.whosTalking * 2 + 1] = CUTSCENE_SCRIPT[++cutsceneStep];
                Game.updateCutsceneInput(n, true);
                break;
            }
            case -2: {
                waitForCutsceneInit = false;
                int n = cutsceneStep++;
                whosTalking = CUTSCENE_SCRIPT[cutsceneStep];
                int n3 = actorsRoles[whosTalking];
                ++cutsceneStep;
                if (splitTextAgain) {
                    if (CUTSCENE_SCRIPT[cutsceneStep] != -1) {
                        int n4 = -1;
                        splitText = NineCanvas.instance.splitString(n4 > -1 ? NineCanvas.instance.getString(n4) + "\n" + NineCanvas.instance.getString(CUTSCENE_SCRIPT[cutsceneStep]) : NineCanvas.instance.getString(CUTSCENE_SCRIPT[cutsceneStep]), NineCanvas.font_green, CUTSCENE_TEXT_WIDTHS[n3] - 20);
                        splitTextAgain = false;
                        scrollY = 0;
                    } else {
                        splitText = null;
                    }
                }
                Game.updateCutsceneInput(n, true);
                break;
            }
            case -3: {
                NineCanvas.instance.setSoftkeys(NineCanvas.instance.getString(56), "");
                Game.unsetGameSubstate(128);
                Game.unsetGameSubstate(256);
                cutsceneFinished = true;
                cutscenePlayed = false;
                cutsceneIsPlaying = false;
                if (!endLevelAfterCutscene) break;
                Game.setGameSubstate(512);
            }
        }
    }

    public static void updateCutsceneInput(int n, boolean bl) {
        boolean bl2;
        int n2 = 120 - 2 * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        int n3 = splitText == null ? 0 : splitText.length * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        int n4 = NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        n2 = n2 / n4 * n4;
        boolean bl3 = bl2 = scrollY - n2 > -n3;
        if (bl) {
            if (NineCanvas.isKeyPressed(0x100020) || NineCanvas.isKeyPressed(0x1000000)) {
                if (bl2) {
                    if ((scrollY += n2) > -n3 + n2) {
                        scrollY = -n3 + n2;
                    }
                    cutsceneStep = n;
                    NineCanvas.resetKeys();
                    return;
                }
                if (currentSlide >= maxSlides - 1) {
                    ++cutsceneStep;
                    currentSlide = -1;
                    maxSlides = 0;
                } else {
                    cutsceneStep = n;
                    ++currentSlide;
                }
                splitTextAgain = true;
                NineCanvas.resetKeys();
            } else {
                cutsceneStep = n;
            }
        }
        if (n3 > n2) {
            if (NineCanvas.isKeyRepeated(262148) && scrollY < 0) {
                scrollY += 2;
            }
            if (NineCanvas.isKeyRepeated(524544) && scrollY - n2 > -n3) {
                scrollY -= 2;
            }
        }
    }

    private static void renderArrows(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        int n4 = 120 - 2 * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        int n5 = splitText.length * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        if (n5 < n4) {
            return;
        }
        bounds = Menu.arrows.getBounds(bounds, 0);
        if (scrollY < 0) {
            Menu.arrows.render(graphics, n - bounds[2] / 2, n2 - 0 - bounds[3], Consts.TOP_LEFT, 0, 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        }
        if (scrollY - n4 > -n5) {
            Menu.arrows.render(graphics, n - bounds[2] / 2, n3 + 0, Consts.TOP_LEFT, 1, 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        }
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
    }

    public static void renderCutscene(Graphics graphics, boolean bl) {
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        if (bl) {
            // empty if block
        }
        if (waitForCutsceneInit) {
            return;
        }
        NineCanvas.instance.setFont(graphics, NineCanvas.font_green);
        if (cutsceneSprite == null) {
            cutsceneSprite = ResourceManager.createSprite(ACTORS_SPRITESET_ID[whosTalking], null);
            bounds = cutsceneSprite.getBounds(bounds, 0);
        }
        Menu.renderTextBackground(graphics, NineCanvas.SCREEN_WIDTH / 2 - Menu.getMenuBackgroundWidth() / 2, NineCanvas.SCREEN_HEIGHT / 2 - 60 - 2, 124);
        int n = bounds[2];
        int n2 = bounds[3];
        int n3 = splitText == null ? 0 : splitText.length * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        int n4 = NineCanvas.instance.getFontHeight(NineCanvas.font_green);
        switch (actorsRoles[whosTalking]) {
            case 4: {
                graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                graphics.setColor(0);
                graphics.fillRect(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                for (int i = 0; i < currentBang; ++i) {
                    cutsceneSprite.render(graphics, BANG_COORDS[i * 2], BANG_COORDS[i * 2 + 1], Consts.TOP_LEFT, 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                }
                break;
            }
            case 3: {
                if (currentSlide == -1) break;
                int n5 = currentSlide + 1;
                while (--n5 >= 0) {
                    cutsceneSprite.render(graphics, NineCanvas.SCREEN_WIDTH / 2 - n / 2 + actorsFilmOffsets[(startSlide + n5) * 2], NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2 + actorsFilmOffsets[(startSlide + n5) * 2 + 1], Consts.TOP_LEFT, (int)ACTORS_TILES_IDS[startSlide + n5], 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                    graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                    graphics.setColor(0x7E7C7C);
                    graphics.drawRect(NineCanvas.SCREEN_WIDTH / 2 - n / 2 + actorsFilmOffsets[(startSlide + n5) * 2], NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2 + actorsFilmOffsets[(startSlide + n5) * 2 + 1], bounds[2] - 1, bounds[3] - 1);
                }
                if (blinkCounter >= 10) break;
                NineCanvas.instance.drawString(graphics, NineCanvas.instance.getString(78), NineCanvas.SCREEN_WIDTH / 2, NineCanvas.SCREEN_HEIGHT - NineCanvas.mainFontHeight * 3 + 0, Consts.TOP_CENTERED, -1);
                break;
            }
            case 0: {
                int n6 = 20 + n + 10 + NineCanvas.cutScenesTextXOffset;
                int n7 = NineCanvas.SCREEN_HEIGHT / 2 - 60 + NineCanvas.instance.getFontHeight(NineCanvas.font_green);
                int n8 = CUTSCENE_TEXT_WIDTHS[actorsRoles[whosTalking]];
                int n9 = 120 - 2 * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
                n9 = n9 / n4 * n4;
                cutsceneSprite.render(graphics, 20, NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2, Consts.TOP_LEFT, (int)ACTORS_TILES_IDS[whosTalking], 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                Game.renderArrows(graphics, NineCanvas.SCREEN_WIDTH / 2, n7, n7 + n9);
                graphics.setColor(0x7E7C7C);
                graphics.drawRect(20, NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2, n, n2);
                graphics.setClip(n6, n7, n8, n9);
                if (n3 < n9) {
                    n7 = NineCanvas.SCREEN_HEIGHT / 2 - n3 / 2;
                }
                if (splitText == null) break;
                NineCanvas.instance.drawSplitString(graphics, splitText, n6, n7 + scrollY, Consts.TOP_LEFT, NineCanvas.instance.getFontHeight(NineCanvas.font_green));
                break;
            }
            case 1: {
                int n10 = NineCanvas.SCREEN_WIDTH - 20 - n - 10 - NineCanvas.cutScenesTextXOffset;
                int n11 = NineCanvas.SCREEN_HEIGHT / 2 - 60 + NineCanvas.instance.getFontHeight(NineCanvas.font_green);
                int n12 = CUTSCENE_TEXT_WIDTHS[actorsRoles[whosTalking]];
                int n13 = 120 - 2 * NineCanvas.instance.getFontHeight(NineCanvas.font_green);
                n13 = n13 / n4 * n4;
                cutsceneSprite.render(graphics, NineCanvas.SCREEN_WIDTH - 20 - n, NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2, Consts.TOP_LEFT, (int)ACTORS_TILES_IDS[whosTalking], 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                Game.renderArrows(graphics, NineCanvas.SCREEN_WIDTH / 2, n11, n11 + n13);
                graphics.setColor(0x7E7C7C);
                graphics.drawRect(NineCanvas.SCREEN_WIDTH - 20 - n, NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2, n, n2);
                graphics.setClip(n10 - CUTSCENE_TEXT_WIDTHS[actorsRoles[whosTalking]], n11, n12, n13);
                if (n3 < n13) {
                    n11 = NineCanvas.SCREEN_HEIGHT / 2 - n3 / 2;
                }
                if (splitText == null) break;
                NineCanvas.instance.drawSplitString(graphics, splitText, n10, n11 + scrollY, Consts.TOP_RIGHT, NineCanvas.instance.getFontHeight(NineCanvas.font_green));
                break;
            }
            case 2: {
                cutsceneSprite.render(graphics, NineCanvas.SCREEN_WIDTH / 2 - n / 2, NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2 + (splitText == null ? 0 : -10), Consts.TOP_LEFT, (int)ACTORS_TILES_IDS[whosTalking], 0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
                graphics.setColor(0x7E7C7C);
                graphics.drawRect(NineCanvas.SCREEN_WIDTH / 2 - n / 2, NineCanvas.SCREEN_HEIGHT / 2 - n2 / 2 + (splitText == null ? 0 : -10), n, n2);
                if (splitText == null) break;
                NineCanvas.instance.drawString(graphics, splitText[0], NineCanvas.SCREEN_WIDTH / 2, NineCanvas.SCREEN_HEIGHT / 2 + n2 / 2, Consts.TOP_CENTERED, -1);
            }
        }
        graphics.setClip(0, 0, NineCanvas.SCREEN_WIDTH, NineCanvas.SCREEN_HEIGHT);
        cutsceneSprite = null;
    }

    public static void startCutscene(int n) {
        if (playedCutscenes[n] == 1) {
            return;
        }
        Game.playedCutscenes[n] = 1;
        CUTSCENE_SCRIPT = NineCanvas.instance.getResourceShortArray(237 + n);
        blinkCounter = 20;
        NineCanvas.instance.setSoftkeys(NineCanvas.instance.getString(56), NineCanvas.instance.getString(31));
        currentBang = 0;
        cutscenePlayed = true;
        cutsceneIsPlaying = true;
        endLevelAfterCutscene = false;
        Game.setGameSubstate(128);
        cutsceneStep = 0;
        splitText = null;
        cutsceneFinished = false;
        waitForCutsceneInit = true;
        splitTextAgain = true;
        scrollY = 0;
        fadeStartTime = NineCanvas.getTime();
        Game.searchGoal();
        Utils.changeAlphaLevel(NineCanvas.fadeTile, 0, 0);
        Game.setGameSubstate(256);
    }

    public static void showGoal() {
        oldCutsceneStep = cutsceneStep;
        scrollY = 0;
        waitForCutsceneInit = false;
        whosTalking = 32;
        Game.actorsRoles[Game.whosTalking] = 1;
        splitText = NineCanvas.instance.splitString(NineCanvas.instance.getString(currentGoalTextId), NineCanvas.font_green, CUTSCENE_TEXT_WIDTHS[1] - 20);
    }

    private static void searchGoal() {
        short[] sArray = CUTSCENE_SCRIPT;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != -2 || sArray[i + 1] != 32) continue;
            currentGoalTextId = sArray[i + 2];
            return;
        }
    }

    public static boolean isCutsceneFinished() {
        return cutsceneFinished;
    }

    public static boolean isCutscenePlayed() {
        return cutscenePlayed;
    }

    public static void initCutscenes() {
        oldCutsceneStep = -1;
        if (ACTORS_SPRITESET_ID == null) {
            ACTORS_SPRITESET_ID = NineCanvas.instance.getResourceShortArray(236);
            ACTORS_TILES_IDS = NineCanvas.instance.getResourceShortArray(235);
        }
        playedCutscenes = new byte[43];
    }

    public static void setMaxPoints() {
        numEnemiesKilled = enemiesToKill;
        pointsEnemies = maxCurrentLevelPoints;
        numCiviliansKilled = 0;
        pointsCivilians = 0;
        currentLevelPoints = maxCurrentLevelPoints;
        hudUpdateKilled = true;
    }

    public static byte getPlayedCutscenes(int n) {
        return playedCutscenes[n];
    }

    public static void setPlayedCutscenes(int n, byte by) {
        Game.playedCutscenes[n] = by;
    }

    static {
        wasIngame = false;
        deltaTimeDemo = 0L;
        timeDemo = 0L;
        lastTimeDemo = 0L;
        testeDemo = 0L;
    }
}

