/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class BRCanvasResHandler
extends BRCanvasRecordStore {
    public static final int BLOCKPACKPMAPPING_PACKID = 0;
    public static final int BLOCKPACKPMAPPING_INDEX = 1;
    public static final int BLOCKPACKPMAPPING_LENGTH = 5;
    public static final int SIZE_BLOCKPACKPMAPPINGS = 9;
    public static final int RESBLOCKMAPPING_BLOCKID = 0;
    public static final int RESBLOCKMAPPING_INDEX = 1;
    public static final int RESBLOCKMAPPING_LENGTH = 5;
    public static final int SIZE_RESBLOCKMAPPINGS = 9;
    public static byte[] res_block_mappings;
    public static byte[] block_pack_mappings;
    public static byte[][] resource_packs;
    public static byte[] times_resource_pack_reference;
    public static byte[][] resource_blocks;
    public static String[] resource_identifiers;
    public static byte[] languages;
    public int[][] menu_cache;
    public static int[] internal_key_mappings;
    public static Class rtclass;

    public void initBedrock() {
        int n;
        byte[] byArray = this.loadFileFromJar("resmap", -1);
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        int n4 = BRCanvasResHandler.readIntFromByteArray(byArray, 2);
        languages = new byte[32];
        System.arraycopy(byArray, 6, languages, 0, 32);
        block_pack_mappings = new byte[n3 * 9];
        System.arraycopy(byArray, 38, block_pack_mappings, 0, n3 * 9);
        int n5 = 38 + n3 * 9;
        res_block_mappings = new byte[n4 * 9];
        System.arraycopy(byArray, n5, res_block_mappings, 0, n4 * 9);
        n5 += n4 * 9;
        int n6 = byArray[n5++] & 0xFF;
        if (n6 != 0) {
            internal_key_mappings = new int[n6 << 1];
            n = 0;
            while (n < n6) {
                BRCanvasResHandler.internal_key_mappings[n << 1] = (short)((byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF);
                BRCanvasResHandler.internal_key_mappings[(n << 1) + 1] = BRCanvasResHandler.readIntFromByteArray(byArray, n5 += 2);
                ++n;
                n5 += 4;
            }
        }
        if ((n = byArray[n5++] & 0xFF) != 0) {
            this.menu_cache = new int[n][];
            for (int i = 0; i < n; ++i) {
                int n7 = BRCanvasResHandler.readIntFromByteArray(byArray, n5);
                n5 += 4;
                if (n7 == 0) continue;
                this.menu_cache[i] = new int[n7];
                int n8 = 0;
                while (n8 < n7) {
                    this.menu_cache[i][n8] = BRCanvasResHandler.readIntFromByteArray(byArray, n5);
                    ++n8;
                    n5 += 4;
                }
            }
        }
        resource_blocks = new byte[n3][];
    }

    public static short readShortFromByteArray(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public static int readIntFromByteArray(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static long readLongFromByteArray(byte[] byArray, int n) {
        return (long)(byArray[n] & 0xFF) << 56 | (long)(byArray[n + 1] & 0xFF) << 48 | (long)(byArray[n + 2] & 0xFF) << 40 | (long)(byArray[n + 3] & 0xFF) << 32 | (long)(byArray[n + 4] & 0xFF) << 24 | (long)((byArray[n + 5] & 0xFF) << 16) | (long)((byArray[n + 6] & 0xFF) << 8) | (long)(byArray[n + 7] & 0xFF);
    }

    public static int writeIntToByteArray(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
        return n;
    }

    public DataInputStream getFileFromJarAsDataInputStream(String string) {
        if (rtclass == null) {
            rtclass = this.getClass();
        }
        DataInputStream dataInputStream = new DataInputStream(rtclass.getResourceAsStream("/" + string));
        return dataInputStream;
    }

    public byte[] loadFileFromJar(String string, int n) {
        byte[] byArray = null;
        DataInputStream dataInputStream = this.getFileFromJarAsDataInputStream(string);
        if (dataInputStream != null) {
            try {
                if (n == -1) {
                    int n2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray2 = new byte[1024];
                    while ((n2 = dataInputStream.read(byArray2)) > 0) {
                        byteArrayOutputStream.write(byArray2, 0, n2);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                } else {
                    byArray = new byte[n];
                    dataInputStream.readFully(byArray);
                }
                dataInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return byArray;
    }

    public void loadResourceBlock(int n) {
        if (resource_blocks[n] != null) {
            return;
        }
        byte by = block_pack_mappings[n * 9 + 0];
        if (by != -1) {
            String string = "pk" + by;
            int n2 = BRCanvasResHandler.readIntFromByteArray(block_pack_mappings, n * 9 + 1);
            int n3 = BRCanvasResHandler.readIntFromByteArray(block_pack_mappings, n * 9 + 5);
            DataInputStream dataInputStream = this.getFileFromJarAsDataInputStream(string);
            if (dataInputStream != null) {
                try {
                    int n4;
                    dataInputStream.skip(n2);
                    int n5 = 0;
                    BRCanvasResHandler.resource_blocks[n] = new byte[n3];
                    while ((n4 = dataInputStream.read(resource_blocks[n], n5, n3 - n5)) > 0) {
                        n5 += n4;
                    }
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.gc();
    }

    public void unloadResourceBlock(int n) {
        if (resource_blocks[n] != null) {
            BRCanvasResHandler.resource_blocks[n] = null;
            System.gc();
        }
    }

    public void unloadUnusedResourcePacks() {
    }

    public int getBlockOfResource(int n) {
        return res_block_mappings[n * 9 + 0];
    }

    public int getResID(String string) {
        return -1;
    }

    public String getResString(int n) {
        return String.valueOf(n);
    }

    public byte[] getResourceByteArray(int n) {
        byte[] byArray = null;
        int n2 = this.getBlockOfResource(n);
        int n3 = BRCanvasResHandler.readIntFromByteArray(res_block_mappings, n * 9 + 5);
        if (n2 != -1) {
            int n4 = BRCanvasResHandler.readIntFromByteArray(res_block_mappings, n * 9 + 1);
            if (resource_blocks[n2] != null) {
                byArray = new byte[n3];
                System.arraycopy(resource_blocks[n2], n4, byArray, 0, n3);
            }
        } else {
            byArray = this.loadFileFromJar("ur" + n, n3);
        }
        return byArray;
    }

    public static int numLanguagesIncluded() {
        return languages.length / 4;
    }

    public static String getLanguageIDString(int n) {
        int n2;
        int n3 = n * 4;
        for (n2 = 0; n2 < 4 && languages[n3 + n2] != 0; ++n2) {
        }
        return new String(languages, n3, n2);
    }
}

