/*
 * Decompiled with CFR 0.152.
 */
public abstract class BRCanvasMaths
extends BRCanvasDimensions {
    public static final int FPI = 3217;
    public static long random_seed;
    public static int random_seed_high;
    public static int random_seed_low;

    public static int iToF(int n) {
        return n << 10;
    }

    public static int FToi(int n) {
        if (n < 0) {
            return -(-n >> 10);
        }
        return n >> 10;
    }

    public static int FToiNearest(int n) {
        if (n < 0) {
            return -(-n + 512 >> 10);
        }
        return n + 512 >> 10;
    }

    public static long FmulToLong(int n, int n2) {
        return (long)n * (long)n2 >> 10;
    }

    public static int Fmul(int n, int n2) {
        if (n < 0) {
            if (n2 < 0) {
                return BRCanvasMaths.Fmul(-n, -n2);
            }
            return -BRCanvasMaths.Fmul(-n, n2);
        }
        if (n2 < 0) {
            return -BRCanvasMaths.Fmul(n, -n2);
        }
        return (int)BRCanvasMaths.FmulToLong(n, n2);
    }

    public static int Fdiv(int n, int n2) {
        if (n < 0) {
            if (n2 < 0) {
                return BRCanvasMaths.Fdiv(-n, -n2);
            }
            return -BRCanvasMaths.Fdiv(-n, n2);
        }
        if (n2 < 0) {
            return -BRCanvasMaths.Fdiv(n, -n2);
        }
        return (int)((long)n * (long)(0x40000000 / n2) >> 20);
    }

    public static int sqrt(int n) {
        int n2 = n;
        if (n > 0) {
            int n3;
            if (n > 65536) {
                n2 = n > 0x1000000 ? (n2 >>= 12) : (n2 >>= 8);
            } else if (n > 256) {
                n2 >>= 4;
            }
            while ((n2 = (n3 = n2) + n / n3 >> 1) < n3 && n2 > 0) {
            }
        }
        return n2;
    }

    public static int Fsqrt(int n) {
        int n2 = n;
        if (n > 0) {
            n2 = n >> 20 != 0 ? BRCanvasMaths.sqrt(n) << 5 : BRCanvasMaths.sqrt(n << 10);
        }
        return n2;
    }

    public static int cbrt(int n) {
        int n2 = n;
        if (n > 0) {
            int n3;
            if (n > 32768) {
                n2 = n > 5931641 ? (n2 >>= 15) : (n2 >>= 10);
            } else if (n > 181) {
                n2 >>= 5;
            }
            while ((n2 += (n / ((n3 = n2) * n3) - n3) / 3) < n3 && n2 > 0) {
            }
        }
        return n2;
    }

    public static int Fcbrt(int n) {
        int n2 = n;
        if (n > 0) {
            n2 = n >> 10 != 0 ? (n >> 25 != 0 ? BRCanvasMaths.cbrt(n << 2) << 6 : BRCanvasMaths.cbrt(n << 11) << 3) : BRCanvasMaths.cbrt(n << 20);
        }
        return n2;
    }

    public static int FdegToFRad(int n) {
        if (n < 0) {
            return -BRCanvasMaths.FdegToFRad(-n);
        }
        return ((n %= 368640) * 3217 + 92160) / 184320;
    }

    public static int FradToFDeg(int n) {
        if (n < 0) {
            return -BRCanvasMaths.FradToFDeg(-n);
        }
        return ((n %= 6434) * 184320 + 1608) / 3217;
    }

    public static int idegToFRad(int n) {
        return BRCanvasMaths.FdegToFRad(BRCanvasMaths.iToF(n));
    }

    public static int FradToiDeg(int n) {
        return BRCanvasMaths.FToiNearest(BRCanvasMaths.FradToFDeg(n));
    }

    public static int Fsin(int n) {
        while (n > 3217) {
            n -= 6434;
        }
        while (n < -3217) {
            n += 6434;
        }
        if (n > 2412) {
            return BRCanvasMaths.Fsin(3217 - n);
        }
        if (n > 804) {
            return BRCanvasMaths.Fcos(n - 1608);
        }
        if (n < -2412) {
            return -BRCanvasMaths.Fsin(n + 3217);
        }
        if (n < -804) {
            return -BRCanvasMaths.Fcos(n + 1608);
        }
        int n2 = 0;
        int n3 = n;
        n2 += n3;
        n3 = n3 * n * n / 3 >> 21;
        n2 -= n3;
        n3 = n3 * n * n / 5 >> 22;
        return n2 + n3;
    }

    public static int Fcos(int n) {
        while (n > 3217) {
            n -= 6434;
        }
        while (n < -3217) {
            n += 6434;
        }
        if (n > 2412) {
            return -BRCanvasMaths.Fcos(3217 - n);
        }
        if (n > 804) {
            return BRCanvasMaths.Fsin(1608 - n);
        }
        if (n < -2412) {
            return -BRCanvasMaths.Fcos(n + 3217);
        }
        if (n < -804) {
            return BRCanvasMaths.Fsin(n + 1608);
        }
        int n2 = 1024;
        int n3 = n * n >> 11;
        n2 -= n3;
        n3 = n3 * n * n / 3 >> 22;
        return n2 + n3;
    }

    public static int vectorToFRad(int n, int n2) {
        if (n < 0) {
            if (n2 < 0) {
                return BRCanvasMaths.vectorToFRad(-n, -n2) - 3217;
            }
            return -BRCanvasMaths.vectorToFRad(-n, n2);
        }
        if (n2 < 0) {
            return 3217 - BRCanvasMaths.vectorToFRad(n, -n2);
        }
        if (n > n2) {
            return 1608 - BRCanvasMaths.vectorToFRad(n2, n);
        }
        if (n == 0 && n2 == 0) {
            return 0;
        }
        while (n < 2048 && n2 < 2048 && n > -2048 && n2 > -2048) {
            n <<= 1;
            n2 <<= 1;
        }
        while (n > 4096 || n2 > 4096 || n < -4096 || n2 < -4096) {
            n >>= 1;
            n2 >>= 1;
        }
        int n3 = (n << 10) / BRCanvasMaths.sqrt(n * n + n2 * n2);
        return n3 * (1024 + (n3 * n3 * (171 + (n3 * n3 * (77 + (n3 * n3 * 46 >> 20)) >> 20)) >> 20)) >> 10;
    }

    public static int FsinFromFDeg(int n) {
        return BRCanvasMaths.Fsin(BRCanvasMaths.FdegToFRad(n));
    }

    public static int FsinFromiDeg(int n) {
        return BRCanvasMaths.Fsin(BRCanvasMaths.idegToFRad(n));
    }

    public static int FcosFromFDeg(int n) {
        return BRCanvasMaths.Fcos(BRCanvasMaths.FdegToFRad(n));
    }

    public static int FcosFromiDeg(int n) {
        return BRCanvasMaths.Fcos(BRCanvasMaths.idegToFRad(n));
    }

    public static int vectorToFDeg(int n, int n2) {
        return BRCanvasMaths.FradToFDeg(BRCanvasMaths.vectorToFRad(n, n2));
    }

    public static int vectorToiDeg(int n, int n2) {
        return BRCanvasMaths.FradToiDeg(BRCanvasMaths.vectorToFRad(n, n2));
    }

    public static void setRandomNumberSeed(long l) {
        random_seed = l;
    }

    public static int random(int n) {
        random_seed = random_seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        int n2 = (int)(random_seed >>> 17);
        if (n == 0) {
            return 0;
        }
        return n2 % n;
    }

    public static void randomAddToIntSeed(int n) {
        if ((n & Integer.MIN_VALUE) != 0) {
            if ((random_seed_low & Integer.MIN_VALUE) != 0) {
                ++random_seed_high;
                random_seed_low &= Integer.MAX_VALUE;
            } else {
                random_seed_low |= Integer.MIN_VALUE;
            }
            n &= Integer.MAX_VALUE;
        }
        if ((random_seed_low += n) >= 0 && random_seed_low < n) {
            ++random_seed_high;
        }
    }
}

