/*
 * Decompiled with CFR 0.152.
 */
public class AI {
    private static final int reachPointToleranceXFP = 1024;
    private static final int reachPointToleranceYFP = 341;
    protected GameObject controlledObject;
    protected int type;
    private int collideAiRammingTimer;
    private int collideAiTelegraphyTimer;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean fire;
    private boolean activateGadget;
    private boolean auxPrevUp;
    private int brakeTimer;
    private int boostTimer;
    private int aiSupportTimer;
    int[] allCutScenes = new int[]{269, 239, 268, 270, 238, 278, 275, 240, 242, 274, 276, 245, 279, 241, 237, 273, 243, 248, 249, 272, 250, 251, 277, 252, 254, 255, 257, 256, 258, 262, 263, 260, 264, 266, 267};
    private static byte BYTE_0 = 0;

    public void init(GameObject gameObject, int n) {
        this.controlledObject = gameObject;
        this.type = n;
    }

    public void deinit() {
    }

    private boolean reachPoint(int n, int n2, int n3, int n4) {
        int n5 = n - this.controlledObject.getPositionXFP();
        int n6 = n2 - this.controlledObject.getPositionYFP();
        boolean bl = true;
        if (Math.abs(n5) > n3) {
            this.left = n5 < 0;
            this.right = !this.left;
            bl = false;
        }
        if (Math.abs(n6) > n4) {
            this.up = n6 < 0;
            this.down = !this.up;
            bl = false;
        }
        return bl;
    }

    private boolean holdPosition(int n, int n2, int n3, int n4) {
        int n5 = n - this.controlledObject.getPositionXFP();
        int n6 = n2 - this.controlledObject.getPositionYFP();
        if (n5 != 0) {
            this.left = n5 < 0;
            boolean bl = this.right = !this.left;
        }
        if (n6 != 0) {
            this.up = n6 < 0;
            this.down = !this.up;
        }
        return Math.abs(n5) < n3 && Math.abs(n6) < n4;
    }

    private void processEnemySensors() {
        Sensor sensor;
        int n;
        boolean bl = this.processSensors();
        Vehicle vehicle = (Vehicle)this.controlledObject;
        if (bl && Math.abs(n = (sensor = vehicle.getSensor(0)).getTurnValueFP()) > 128) {
            if (this.right && n > 0) {
                this.right = false;
            }
            if (this.left && n < 0) {
                this.left = false;
            }
        }
    }

    private boolean isPointReached(int n, int n2, int n3, int n4) {
        return this.controlledObject.getPositionXFP() >= n - n3 && this.controlledObject.getPositionXFP() <= n + n3 && this.controlledObject.getPositionYFP() >= n2 - n3 && this.controlledObject.getPositionYFP() <= n2 + n3;
    }

    public boolean processSensors() {
        boolean bl = false;
        Vehicle vehicle = (Vehicle)this.controlledObject;
        Sensor sensor = vehicle.getSensor(0);
        if (vehicle.getSensor(1).IsObstacleDetected()) {
            if (sensor.isEnabled()) {
                bl = true;
                int n = sensor.getTurnValueFP();
                if (Math.abs(n) > 256) {
                    if (n <= 0) {
                        this.right = true;
                        this.left = false;
                    } else {
                        this.left = true;
                        this.right = false;
                    }
                }
            } else {
                sensor.setEnabled(true);
            }
        } else {
            sensor.setEnabled(false);
        }
        return bl;
    }

    public void update(int n) {
        this.fire = false;
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
        this.aiSupportTimer -= n;
        this.collideAiRammingTimer -= n;
        this.collideAiTelegraphyTimer -= n;
        switch (this.type) {
            case 4: {
                if (this.aiSupportTimer < 0) {
                    this.processCollideAi();
                } else {
                    this.processChaseAi();
                }
                this.processEnemySensors();
                break;
            }
            case 2: {
                this.processCollideAi();
                this.processEnemySensors();
                break;
            }
            case 9: {
                Vehicle vehicle = GameObjectManager.getGameTarget();
                Vehicle vehicle2 = (Vehicle)this.controlledObject;
                if (vehicle.getPositionYFP() < vehicle2.getPositionYFP()) {
                    if (vehicle2.vehicleType == 1) {
                        vehicle2.ai.type = 8;
                        break;
                    }
                    vehicle2.ai.type = 1;
                    break;
                }
                vehicle2.stopImmediate();
                break;
            }
            case 0: {
                this.brakeTimer -= n;
                this.boostTimer -= n;
                this.updateInput(n);
                if (this.up) {
                    this.down = false;
                    this.brakeTimer = 0;
                    this.boostTimer = !this.auxPrevUp ? 0 : 1500;
                } else if (this.left || this.right) {
                    this.up = false;
                    this.boostTimer = 0;
                } else if (this.down) {
                    this.up = false;
                    this.boostTimer = 0;
                    this.brakeTimer = 1500;
                }
                this.auxPrevUp = this.up;
                this.up = this.boostTimer > 0;
                this.down = this.brakeTimer > 0;
                break;
            }
            case 7: {
                this.processEnemySensors();
                break;
            }
            case 3: 
            case 10: {
                this.fire = this.type == 10;
                Vehicle vehicle = GameObjectManager.getGameTarget();
                int n2 = this.controlledObject.getPositionXFP() - vehicle.getPositionXFP();
                int n3 = this.controlledObject.getPositionYFP() - vehicle.getPositionYFP();
                if (Math.abs(n2) < 2048) {
                    this.left = n2 < 0;
                    boolean bl = this.right = !this.left;
                }
                if (Math.abs(n3) < 5120) {
                    this.up = true;
                    this.down = false;
                    this.fire = this.type != 10;
                } else if (Math.abs(n3) > 7168) {
                    this.down = true;
                }
                if (this.aiSupportTimer < 0) {
                    this.fire = false;
                    this.aiSupportTimer = Game.EQUIPMENT_CONFIGURATION[8][2] * 4;
                }
                this.processEnemySensors();
                break;
            }
            case 11: {
                int n4 = this.controlledObject.getPositionYFP() - ResourceManager.map.getCameraYFP();
                if (n4 - 8192 > 0) {
                    this.up = true;
                    this.down = false;
                } else if (n4 - 4096 < 0) {
                    this.down = true;
                    this.up = false;
                }
                this.processEnemySensors();
                break;
            }
            case 5: {
                Vehicle vehicle = GameObjectManager.getGameTarget();
                int n5 = vehicle.getPositionYFP() - 6144;
                this.fire = this.holdPosition(vehicle.getPositionXFP(), n5, 2048, 2048);
                break;
            }
            case 1: {
                this.processChaseAi();
                this.processEnemySensors();
                break;
            }
            case 8: {
                Vehicle vehicle = GameObjectManager.getGameTarget();
                int n6 = vehicle.getPositionYFP() + 4096;
                this.fire = this.reachPoint(vehicle.getPositionXFP(), n6, 1024, 1024);
                this.processEnemySensors();
            }
        }
        ((Vehicle)this.controlledObject).setInput(this.up, this.down, this.left, this.right, this.fire, this.activateGadget);
    }

    private void updateInput(int n) {
        if (NineCanvas.testCheats) {
            if (NineCanvas.isKeyPressed(1)) {
                Menu.pointsCounter = 70000;
                NineCanvas.storyModePoints += Menu.pointsCounter;
                Game.setGameSubstate(512);
            } else if (NineCanvas.isKeyPressed(2048)) {
                Game.setGameSubstate(2048);
            } else if (NineCanvas.isKeyPressed(1024)) {
                Game.setGameSubstate(2);
            }
        }
        this.right = NineCanvas.isKeyRepeated(131136);
        this.left = NineCanvas.isKeyRepeated(65552);
        this.up = NineCanvas.isKeyRepeated(262148);
        this.down = NineCanvas.isKeyRepeated(524544);
        this.fire = NineCanvas.isKeyRepeated(0x100020);
        this.activateGadget = NineCanvas.isKeyPressed(10);
    }

    public void notifyAfterCollission(Vehicle vehicle) {
        if (this.type == 9 && vehicle.getRole() == 2) {
            this.type = vehicle.vehicleType == 1 ? 8 : 1;
        }
        if (vehicle.role == 2) {
            this.aiSupportTimer = 3000;
            this.collideAiTelegraphyTimer = 900;
        }
    }

    private void processChaseAi() {
        Vehicle vehicle = GameObjectManager.getGameTarget();
        int n = vehicle.getPositionXFP();
        int n2 = vehicle.getBottomFP();
        int n3 = BRCanvasMaths.iToF(2);
        int n4 = vehicle.getHeightFP() + this.controlledObject.getHeightFP() / 2;
        this.reachPoint(n += vehicle.isOnTheLeftTo(this.controlledObject) ? 3072 : -3072, n2, 1024, 341);
        this.fire = this.isPointReached(n, n2, n3, n4);
    }

    private void processCollideAi() {
        Vehicle vehicle = GameObjectManager.getGameTarget();
        int n = BRCanvasMaths.iToF(2);
        int n2 = vehicle.getHeightFP() + this.controlledObject.getHeightFP() / 2;
        int n3 = vehicle.getPositionXFP();
        int n4 = vehicle.getBottomFP();
        if (this.collideAiRammingTimer > 0) {
            ((Vehicle)this.controlledObject).setSignalLeft(false);
            ((Vehicle)this.controlledObject).setSignalRight(false);
        } else if (this.isPointReached(n3 += vehicle.isOnTheLeftSideOf(this.controlledObject) ? 3072 : -3072, vehicle.getPositionYFP(), n, n2)) {
            if (vehicle.isOnTheLeftSideOf(this.controlledObject)) {
                ((Vehicle)this.controlledObject).setSignalLeft(true);
                ((Vehicle)this.controlledObject).setSignalRight(false);
            } else {
                ((Vehicle)this.controlledObject).setSignalLeft(false);
                ((Vehicle)this.controlledObject).setSignalRight(true);
            }
            if (this.collideAiTelegraphyTimer <= 0) {
                this.collideAiRammingTimer = 2000;
            }
        } else {
            ((Vehicle)this.controlledObject).setSignalLeft(false);
            ((Vehicle)this.controlledObject).setSignalRight(false);
            this.collideAiTelegraphyTimer = 900;
        }
        this.reachPoint(n3, n4, 1024, 341);
    }
}

