/*
 * Decompiled with CFR 0.152.
 */
final class BitUtils {
    private BitUtils() {
    }

    static int countLeadingZeros(int n) {
        if (n <= 0) {
            if (n == 0) {
                return 32;
            }
            return 0;
        }
        int n2 = 0;
        if ((n & 0xFFFF0000) == 0) {
            n <<= 16;
            n2 = 16;
        }
        if ((n & 0xFF000000) == 0) {
            n <<= 8;
            n2 += 8;
        }
        while (n > 0) {
            ++n2;
            n <<= 1;
        }
        return n2;
    }

    static int countLeadingZeros(long l) {
        int n = BitUtils.countLeadingZeros((int)(l >> 32));
        if (n == 32) {
            return BitUtils.countLeadingZeros((int)l) + 32;
        }
        return n;
    }

    static int stickyRightShift(int n, int n2) {
        if (n2 >= 32) {
            return n == 0 ? 0 : 1;
        }
        if (n << 32 - n2 == 0) {
            return n >>> n2;
        }
        return n >>> n2 | 1;
    }

    static long stickyRightShift(long l, int n) {
        if (n >= 64) {
            return l == 0L ? 0 : 1;
        }
        if (l << 64 - n == 0L) {
            return l >>> n;
        }
        return l >>> n | 1L;
    }

    static int roundingRightShift(int n, int n2) {
        int n3;
        if (n2 > 32) {
            return 0;
        }
        if (n2 == 32) {
            n3 = n;
            n = 0;
        } else {
            n3 = n << 32 - n2;
            n >>>= n2;
        }
        if (n3 < 0 && (n3 != Integer.MIN_VALUE || (n & 1) == 1)) {
            return n + 1;
        }
        return n;
    }

    static long roundingRightShift(long l, int n) {
        long l2;
        if (n > 64) {
            return 0L;
        }
        if (n == 64) {
            l2 = l;
            l = 0L;
        } else {
            l2 = l << 64 - n;
            l >>>= n;
        }
        if (l2 < 0L && (l2 != Long.MIN_VALUE || (l & 1L) == 1L)) {
            return l + 1L;
        }
        return l;
    }
}

