/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class MicroDouble {
    public static final long POSITIVE_INFINITY = 0x7FF0000000000000L;
    public static final long NEGATIVE_INFINITY = -4503599627370496L;
    public static final long NaN = 9221120237041090560L;
    public static final long MAX_VALUE = 0x7FEFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = 1L;
    public static final long E = 4613303445314885481L;
    public static final long PI = 4614256656552045848L;
    public static final long ZERO = 0L;
    public static final long NEGATIVE_ZERO = Long.MIN_VALUE;
    public static final long ONE = 0x3FF0000000000000L;
    public static final long NEGATIVE_ONE = -4616189618054758400L;
    public static final long TWO = 0x4000000000000000L;
    public static final long THREE = 0x4008000000000000L;
    public static final long FOUR = 0x4010000000000000L;
    public static final long FIVE = 0x4014000000000000L;
    public static final long SIX = 4618441417868443648L;
    public static final long EIGHT = 0x4020000000000000L;
    public static final long TEN = 0x4024000000000000L;
    public static final long ONE_HUNDRED = 4636737291354636288L;
    public static final long THREE_HALVES = 4609434218613702656L;
    public static final long ONE_HALF = 4602678819172646912L;
    public static final long ONE_THIRD = 4599676419421066581L;
    public static final long ONE_FOURTH = 4598175219545276416L;
    public static final long ONE_EIGHTH = 4593671619917905920L;
    public static final long LN2 = 4604418534313441775L;
    private static final long ABS_MASK = Long.MAX_VALUE;
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final long FRACTION_MASK = 0xFFFFFFFFFFFFFL;
    private static final long IMPLIED_ONE = 0x10000000000000L;
    private static Random random;
    private static final long[] pow10m;
    private static final short[] pow10x;
    private static final long[] pow2m;
    private static final short[] pow2x;
    private static final long ONE_EIGHTY = 4640537203540230144L;
    private static final long TWO_HUNDRED = 4641240890982006784L;
    private static final long EXP_UNDERFLOW = -4573606559926636463L;
    private static final long EXP_OVERFLOW = 4649454530587146735L;
    private static final long LN2_HI = 4604418534311723008L;
    private static final long LN2_LO = 4461442080421002358L;
    private static final long INV_LN2 = 4609176140021203710L;
    private static final long P1 = 4595172819793696062L;
    private static final long P2 = -4654820494858601069L;
    private static final long P3 = 4544508515198557740L;
    private static final long P4 = -4702957295668925455L;
    private static final long P5 = 4496342204012209360L;
    private static final long Q1 = -4638407376216452876L;
    private static final long Q2 = 4564962959435912581L;
    private static final long Q3 = -4677887503499600969L;
    private static final long Q4 = 4526346094260933177L;
    private static final long Q5 = -4716678695450197203L;
    private static final long[] BP;
    private static final long[] DP_HI;
    private static final long[] DP_LO;
    private static final long L1 = 4603579539098120963L;
    private static final long L2 = 4601392076422097919L;
    private static final long L3 = 4599676419357746765L;
    private static final long L4 = 4598584653024936193L;
    private static final long L5 = 4597478449480325989L;
    private static final long L6 = 4596625081194860271L;
    private static final long LN2_HI_B = 4604418534330597376L;
    private static final long LN2_LO_B = -4746692435354555335L;
    private static final long OVT = 4365981760143196926L;
    private static final long CP = 4606838314010018813L;
    private static final long CP_HI = 4606838314073325568L;
    private static final long CP_LO = -4738297118486494731L;
    private static final long INV_LN2_HI = 4609176139934466048L;
    private static final long INV_LN2_LO = 4491406094830001988L;
    private static final long IVLN10 = 4601495173785380110L;
    private static final long LOG10_2HI = 4599094494223097856L;
    private static final long LOG10_2LO = 4420844829172378422L;
    private static final long LG1 = 4604180019048437139L;
    private static final long LG2 = 4600877379321592324L;
    private static final long LG3 = 4598818590951641945L;
    private static final long LG4 = 4597174411056806063L;
    private static final long LG5 = 4595719342595441630L;
    private static final long LG6 = 4594685411790997151L;
    private static final long LG7 = 4594499633228436036L;
    private static final long LP1 = 4604180019048437139L;
    private static final long LP2 = 4600877379321592324L;
    private static final long LP3 = 4598818590951641945L;
    private static final long LP4 = 4597174411056806063L;
    private static final long LP5 = 4595719342595441630L;
    private static final long LP6 = 4594685411790997151L;
    private static final long LP7 = 4594499633228436036L;
    private static final long PIO4 = 4605249457297304856L;
    private static final long PIO4_LO = 4359948597267291143L;
    private static final long T0 = 4599676419421066595L;
    private static final long T1 = 4593971859893059194L;
    private static final long T2 = 4587938466107703806L;
    private static final long T3 = 4581960672245896759L;
    private static final long T4 = 4576262931677611155L;
    private static final long T5 = 4570429193025094440L;
    private static final long T6 = 4564358403679355669L;
    private static final long T7 = 4558562946408670465L;
    private static final long T8 = 4553182066015801448L;
    private static final long T9 = 4545397049192321702L;
    private static final long T10 = 4544897349388904425L;
    private static final long T11 = -4687273268743220365L;
    private static final long T12 = 4538267711989316308L;
    private static long S1;
    private static long S2;
    private static long S3;
    private static long S4;
    private static long S5;
    private static long S6;
    private static final long C1 = 4586165620538955084L;
    private static final long C2 = -4659324094485802633L;
    private static final long C3 = 4537941361668330896L;
    private static final long C4 = -4714566979978243411L;
    private static final long C5 = 4477121870137962948L;
    private static final long C6 = -4780295122622859052L;
    private static final long[] PIO2;
    private static final int[] TWO_OVER_PI;
    private static final int[] NPIO2_HW;
    private static final long TWO24 = 4715268809856909312L;
    private static final long INV_PIO2 = 4603909380684499075L;
    private static final long PIO2_1 = 4609753056924401664L;
    private static final long PIO2_1T = 4454258360616903473L;
    private static final long PIO2_2 = 4454258360616747008L;
    private static final long PIO2_2T = 4297306550709743731L;
    private static final long PIO2_3 = 4297306550709518336L;
    private static final long PIO2_3T = 4142048980368378305L;
    private static final long PIO2_HI = 4609753056924675352L;
    private static final long PIO2_LO = 4364452196894661639L;
    private static final long PIO4_HI = 4605249457297304856L;
    private static final long PS0 = 4595172819793696085L;
    private static final long PS1 = -4623835544539140227L;
    private static final long PS2 = 4596417465768494165L;
    private static final long PS3 = -4637438604930937029L;
    private static final long PS4 = 4560439845004096136L;
    private static final long PS5 = 4540259411154564873L;
    private static final long QS1 = -4610777653840302773L;
    private static final long QS2 = 4611733184086379208L;
    private static final long QS3 = -4618997306433404583L;
    private static final long QS4 = 4590215604441354882L;
    private static final long[] atanhi;
    private static final long[] atanlo;
    private static final long AT0 = 4599676419421066509L;
    private static final long AT1 = -4626998257160492092L;
    private static final long AT2 = 4594314991288484863L;
    private static final long AT3 = -4630701217362536847L;
    private static final long AT4 = 4591215095208222830L;
    private static final long AT5 = -4633165035261879699L;
    private static final long AT6 = 4589464229703073105L;
    private static final long AT7 = -4634804155249132134L;
    private static final long AT8 = 4587333258118041067L;
    private static final long AT9 = -4637946461342241745L;
    private static final long AT10 = 4580351289466214929L;
    private static final long A0 = 4590228395698008264L;
    private static final long A1 = 4599480669564178349L;
    private static final long A2 = 4589517665429971623L;
    private static final long A3 = 4581589235564434555L;
    private static final long A4 = 4575164982564483048L;
    private static final long A5 = 4568811493649781355L;
    private static final long A6 = 4563143216008740701L;
    private static final long A7 = 4557843786729364480L;
    private static final long A8 = 4552280422768239949L;
    private static final long A9 = 4547598271341525767L;
    private static final long A10 = 4538063219164248658L;
    private static final long A11 = 4541745596584974391L;
    private static final long TC = 4609261425156079167L;
    private static final long TF = -4629953606387004862L;
    private static final long TT = -4877178723284379873L;
    private static final long TB0 = 4602387636645935266L;
    private static final long TB1 = -4628886608449977079L;
    private static final long TB2 = 4589321138371641755L;
    private static final long TB3 = -4638485889055082733L;
    private static final long TB4 = 4580836915846773228L;
    private static final long TB5 = -4646272669672412054L;
    private static final long TB6 = 4573683464413438788L;
    private static final long TB7 = -4652729689257208617L;
    private static final long TB8 = 4567356815629994261L;
    private static final long TB9 = -4659256875421984015L;
    private static final long TB10 = 4561265769268226281L;
    private static final long TB11 = -4665265148704595732L;
    private static final long TB12 = 4554458007677615095L;
    private static final long TB13 = -4668967117108573128L;
    private static final long TB14 = 4554825044790006772L;
    private static final long U0 = -4633143641156767544L;
    private static final long U1 = 4603875219004743167L;
    private static final long U2 = 4609231207607680367L;
    private static final long U3 = 4606981716134495312L;
    private static final long U4 = 4597417307973683492L;
    private static final long U5 = 4578867296057666313L;
    private static final long V1 = 4612712789461262748L;
    private static final long V2 = 4611975351653570805L;
    private static final long V3 = 4605104324179153071L;
    private static final long V4 = 4592174453748890760L;
    private static final long V5 = 4569564532599476065L;
    private static final long SB0 = -4633143641156767544L;
    private static final long SB1 = 4596913578117826680L;
    private static final long SB2 = 4599540328982355801L;
    private static final long SB3 = 4594440851763360503L;
    private static final long SB4 = 4583336332999498081L;
    private static final long SB5 = 4566129637262422585L;
    private static final long SB6 = 4539839448431978821L;
    private static final long R1 = 4608947853879192436L;
    private static final long R2 = 4604677836871294172L;
    private static final long R3 = 4595362590636105511L;
    private static final long R4 = 4581031541704938613L;
    private static final long R5 = 4560314476338981211L;
    private static final long R6 = 4530263847980990784L;
    private static final long W0 = 4601218545606032745L;
    private static final long W1 = 4590669220166325563L;
    private static final long W2 = -4654820494859555236L;
    private static final long W3 = 4560459357641193654L;
    private static final long W4 = -4664743177309132991L;
    private static final long W5 = 4560853097493747153L;
    private static final long W6 = -4658207879917059100L;
    private static final long TWO52 = 0x4330000000000000L;
    private final long value;

    static boolean unpackSign(long l) {
        return l < 0L;
    }

    static int unpackExponent(long l) {
        return ((int)(l >> 52) & 0x7FF) - 1075;
    }

    static long unpackMantissa(long l) {
        if ((l & 0x7FF0000000000000L) == 0L) {
            return (l & 0xFFFFFFFFFFFFFL) << 1;
        }
        return l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
    }

    static long pack(boolean bl, int n, long l) {
        if (l != 0L) {
            int n2 = BitUtils.countLeadingZeros(l);
            l <<= n2;
            if ((n -= n2) < -1085) {
                l = BitUtils.roundingRightShift(l, -1074 - n);
            } else {
                if ((l = BitUtils.roundingRightShift(l, 11)) == 0x20000000000000L) {
                    l = 0x10000000000000L;
                    ++n;
                }
                if (n > 960) {
                    l = 0x7FF0000000000000L;
                } else {
                    l ^= 0x10000000000000L;
                    l |= (long)(n + 1086) << 52;
                }
            }
        }
        if (bl) {
            l |= Long.MIN_VALUE;
        }
        return l;
    }

    public static boolean isNaN(long l) {
        return (l & Long.MAX_VALUE) > 0x7FF0000000000000L;
    }

    public static boolean isInfinite(long l) {
        return (l & Long.MAX_VALUE) == 0x7FF0000000000000L;
    }

    public static boolean isZero(long l) {
        return (l & Long.MAX_VALUE) == 0L;
    }

    public static long abs(long l) {
        return l & Long.MAX_VALUE;
    }

    public static long negate(long l) {
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        return l ^ Long.MIN_VALUE;
    }

    public static boolean eq(long l, long l2) {
        return l == l2 && !MicroDouble.isNaN(l) || MicroDouble.isZero(l) && MicroDouble.isZero(l2);
    }

    public static boolean ne(long l, long l2) {
        return !MicroDouble.eq(l, l2);
    }

    public static boolean lt(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return false;
        }
        if (l2 == 0L) {
            l2 = Long.MIN_VALUE;
        }
        return MicroDouble.cmp(l, l2) < 0;
    }

    public static boolean le(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return false;
        }
        if (l2 == Long.MIN_VALUE) {
            l2 = 0L;
        }
        return MicroDouble.cmp(l, l2) <= 0;
    }

    public static boolean gt(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return false;
        }
        if (l == 0L) {
            l = Long.MIN_VALUE;
        }
        return MicroDouble.cmp(l, l2) > 0;
    }

    public static boolean ge(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return false;
        }
        if (l == Long.MIN_VALUE) {
            l = 0L;
        }
        return MicroDouble.cmp(l, l2) >= 0;
    }

    public static int compare(long l, long l2) {
        boolean bl = MicroDouble.isNaN(l);
        boolean bl2 = MicroDouble.isNaN(l2);
        if (bl || bl2) {
            if (bl && bl2) {
                return 0;
            }
            return bl ? 1 : -1;
        }
        return MicroDouble.cmp(l, l2);
    }

    public static long max(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        return MicroDouble.cmp(l, l2) >= 0 ? l : l2;
    }

    public static long min(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        return MicroDouble.cmp(l, l2) < 0 ? l : l2;
    }

    private static int cmp(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l < 0L) {
            if (l2 < 0L) {
                return l < l2 ? 1 : -1;
            }
            return -1;
        }
        if (l2 < 0L) {
            return 1;
        }
        return l < l2 ? -1 : 1;
    }

    public static long intToDouble(int n) {
        return MicroDouble.longToDouble(n);
    }

    public static long longToDouble(long l) {
        if (l < 0L) {
            return MicroDouble.pack(true, 0, -l);
        }
        return MicroDouble.pack(false, 0, l);
    }

    public static long floatToDouble(int n) {
        if (MicroFloat.isNaN(n)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroFloat.unpackSign(n);
        if (MicroFloat.isZero(n)) {
            return bl ? Long.MIN_VALUE : 0L;
        }
        if (MicroFloat.isInfinite(n)) {
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        int n2 = MicroFloat.unpackExponent(n);
        long l = MicroFloat.unpackMantissa(n);
        return MicroDouble.pack(bl, n2, l);
    }

    public static byte byteValue(long l) {
        return (byte)MicroDouble.intValue(l);
    }

    public static short shortValue(long l) {
        return (short)MicroDouble.intValue(l);
    }

    public static int intValue(long l) {
        long l2 = MicroDouble.longValue(l);
        if (l2 >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static long longValue(long l) {
        if (MicroDouble.isNaN(l)) {
            return 0L;
        }
        boolean bl = MicroDouble.unpackSign(l);
        int n = MicroDouble.unpackExponent(l);
        long l2 = MicroDouble.unpackMantissa(l);
        if (n > 0) {
            if (n >= 63 || l2 >> 63 - n != 0L) {
                return bl ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            l2 <<= n;
        } else {
            if (n <= -53) {
                return 0L;
            }
            l2 >>>= -n;
        }
        return bl ? -l2 : l2;
    }

    public static int floatValue(long l) {
        return MicroFloat.doubleToFloat(l);
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    public static long random() {
        return MicroDouble.pack(false, -64, MicroDouble.getRandom().nextLong() << 11);
    }

    public static long add(long l, long l2) {
        long l3;
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l);
        boolean bl2 = MicroDouble.unpackSign(l2);
        boolean bl3 = MicroDouble.isInfinite(l);
        boolean bl4 = MicroDouble.isInfinite(l2);
        if (bl3 || bl4) {
            if (bl3 && bl4) {
                if (bl != bl2) {
                    return 9221120237041090560L;
                }
                return l;
            }
            if (bl3) {
                return l;
            }
            return l2;
        }
        boolean bl5 = MicroDouble.isZero(l);
        boolean bl6 = MicroDouble.isZero(l2);
        if (bl5 || bl6) {
            if (bl5 && bl6) {
                if (bl != bl2) {
                    return 0L;
                }
                return l;
            }
            if (bl5) {
                return l2;
            }
            return l;
        }
        long l4 = MicroDouble.unpackMantissa(l) << 3;
        int n = MicroDouble.unpackExponent(l) - 3;
        long l5 = MicroDouble.unpackMantissa(l2) << 3;
        int n2 = MicroDouble.unpackExponent(l2) - 3;
        int n3 = n - n2;
        if (n3 > 0) {
            l5 = BitUtils.stickyRightShift(l5, n3);
            n2 = n;
        } else if (n3 < 0) {
            l4 = BitUtils.stickyRightShift(l4, -n3);
            n = n2;
        }
        if (bl ^ bl2) {
            if (l4 > l5) {
                l5 = -l5;
            } else {
                l4 = -l4;
                bl = bl2;
            }
        }
        if ((l3 = MicroDouble.pack(bl, n, l4 += l5)) == Long.MIN_VALUE) {
            return 0L;
        }
        return l3;
    }

    public static long sub(long l, long l2) {
        return MicroDouble.add(l, MicroDouble.negate(l2));
    }

    public static long mul(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l) ^ MicroDouble.unpackSign(l2);
        if (MicroDouble.isInfinite(l) || MicroDouble.isInfinite(l2)) {
            if (MicroDouble.isZero(l) || MicroDouble.isZero(l2)) {
                return 9221120237041090560L;
            }
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long l3 = MicroDouble.unpackMantissa(l);
        int n = MicroDouble.unpackExponent(l);
        long l4 = MicroDouble.unpackMantissa(l2);
        int n2 = MicroDouble.unpackExponent(l2);
        n += n2;
        long l5 = l3 & 0xFFFFFFFL;
        long l6 = l3 >> 28;
        long l7 = l4 & 0xFFFFFFFL;
        long l8 = l4 >> 28;
        long l9 = l5 * l7;
        long l10 = l5 * l8 + l6 * l7;
        long l11 = l6 * l8;
        l11 += l10 >>> 28;
        l9 <<= 8;
        int n3 = BitUtils.countLeadingZeros(l11 += (l9 += (l10 & 0xFFFFFFFL) << 28) >>> 56);
        n += 56 - n3;
        if (n3 == 64) {
            l11 = l9;
        } else {
            l11 <<= n3;
            l11 |= l9 >>> 64 - n3;
            if (l9 << n3 != 0L) {
                l11 |= 1L;
            }
        }
        return MicroDouble.pack(bl, n, l11);
    }

    public static long div(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l) ^ MicroDouble.unpackSign(l2);
        boolean bl2 = MicroDouble.isInfinite(l);
        boolean bl3 = MicroDouble.isInfinite(l2);
        if (bl2 || bl3) {
            if (bl2 && bl3) {
                return 9221120237041090560L;
            }
            if (bl2) {
                return bl ? -4503599627370496L : 0x7FF0000000000000L;
            }
            return bl ? Long.MIN_VALUE : 0L;
        }
        bl2 = MicroDouble.isZero(l);
        bl3 = MicroDouble.isZero(l2);
        if (bl2 || bl3) {
            if (bl2 && bl3) {
                return 9221120237041090560L;
            }
            if (bl2) {
                return bl ? Long.MIN_VALUE : 0L;
            }
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long l3 = MicroDouble.unpackMantissa(l);
        int n = MicroDouble.unpackExponent(l);
        long l4 = MicroDouble.unpackMantissa(l2);
        int n2 = MicroDouble.unpackExponent(l2);
        long l5 = 0L;
        n -= n2;
        while (true) {
            int n3;
            if ((n3 = Math.min(BitUtils.countLeadingZeros(l3) - 1, BitUtils.countLeadingZeros(l5))) <= 8) {
                if (l3 == 0L) break;
                l5 |= 1L;
                break;
            }
            l5 <<= n3;
            n -= n3;
            l5 |= (l3 <<= n3) / l4;
            l3 %= l4;
        }
        return MicroDouble.pack(bl, n, l5);
    }

    public static long mod(long l, long l2) {
        int n;
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2) || MicroDouble.isInfinite(l) || MicroDouble.isZero(l2)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(l) || MicroDouble.isInfinite(l2)) {
            return l;
        }
        int n2 = MicroDouble.unpackExponent(l);
        if (n2 < (n = MicroDouble.unpackExponent(l2))) {
            return l;
        }
        boolean bl = MicroDouble.unpackSign(l);
        long l3 = MicroDouble.unpackMantissa(l);
        long l4 = MicroDouble.unpackMantissa(l2);
        if (n2 == n) {
            l3 %= l4;
        } else {
            while (n2 != n) {
                int n3 = Math.min(BitUtils.countLeadingZeros(l3) - 1, n2 - n);
                n2 -= n3;
                l3 = (l3 << n3) % l4;
            }
        }
        return MicroDouble.pack(bl, n2, l3);
    }

    public static long truncate(long l) {
        return MicroDouble.round(l, false, MicroDouble.unpackSign(l));
    }

    public static long rint(long l) {
        return MicroDouble.round(l, true, false);
    }

    public static long floor(long l) {
        return MicroDouble.round(l, false, false);
    }

    public static long ceil(long l) {
        return MicroDouble.round(l, false, true);
    }

    public static long round(long l) {
        return MicroDouble.longValue(MicroDouble.floor(MicroDouble.add(l, 4602678819172646912L)));
    }

    private static long round(long l, boolean bl, boolean bl2) {
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(l) || MicroDouble.isInfinite(l)) {
            return l;
        }
        int n = MicroDouble.unpackExponent(l);
        if (n >= 0) {
            return l;
        }
        boolean bl3 = MicroDouble.unpackSign(l);
        long l2 = MicroDouble.unpackMantissa(l);
        if (bl) {
            l2 = BitUtils.roundingRightShift(l2, -n);
        } else {
            long l3;
            if (n <= -64) {
                l3 = l2;
                l2 = 0L;
            } else {
                l3 = l2 << 64 + n;
                l2 >>>= -n;
            }
            if (bl3 ^ bl2 && l3 != 0L) {
                ++l2;
            }
        }
        return MicroDouble.pack(bl3, 0, l2);
    }

    private static long decToDouble(boolean bl, int n, long l) {
        if (l == 0L) {
            return bl ? Long.MIN_VALUE : 0L;
        }
        while (l > 0L && l <= 0x1999999999999999L) {
            l = (l << 3) + (l << 1);
            --n;
        }
        if ((n /= 3) < 0) {
            return bl ? Long.MIN_VALUE : 0L;
        }
        if (n > 218) {
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        int n2 = pow10x[n];
        int n3 = BitUtils.countLeadingZeros(l);
        n2 -= n3;
        long l2 = MicroDouble.dpMul(l <<= n3, pow10m[n]);
        for (int i = (n += 345) % 3; i > 0; --i) {
            if (l2 < 0L) {
                l2 >>>= 1;
                ++n2;
            }
            l2 += l2 >>> 2;
            n2 += 3;
        }
        return MicroDouble.pack(bl, n2, l2);
    }

    private static final long dpMul(long l, long l2) {
        long l3 = (l >>> 32) * (l2 >>> 32);
        long l4 = (l & 0xFFFFFFFFL) * (l2 >>> 32);
        long l5 = (l >>> 32) * (l2 & 0xFFFFFFFFL);
        l3 += l4 >>> 32;
        l3 += l5 >>> 32;
        if (l4 + l5 << 32 < 0L) {
            ++l3;
        }
        return l3;
    }

    public static long parseDouble(String string) {
        int n = (string = string.trim().toUpperCase()).length();
        if (n == 0) {
            throw new NumberFormatException(string);
        }
        if ("NAN".equals(string)) {
            return 9221120237041090560L;
        }
        int n2 = 0;
        boolean bl = false;
        char c = string.charAt(0);
        boolean bl2 = bl = c == '-';
        if (bl || c == '+') {
            n2 = 1;
        }
        if (n2 < n && ((c = string.charAt(n2)) == 'I' || c == 'i') && "INFINITY".equals(string.substring(n2))) {
            return bl ? -4503599627370496L : 0x7FF0000000000000L;
        }
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c == '.') {
                if (bl4) {
                    throw new NumberFormatException(string);
                }
                bl4 = true;
            } else {
                if (c < '0' || c > '9') break;
                ++n4;
                if (l <= 0x1999999999999998L) {
                    l = (l << 3) + (l << 1) + (long)(c - 48);
                    if (bl4) {
                        --n3;
                    }
                } else {
                    if (!bl4) {
                        ++n3;
                    }
                    bl3 |= c != '0';
                }
            }
            ++n2;
        }
        if (n4 == 0) {
            throw new NumberFormatException(string);
        }
        if (n2 + 1 < n && (string.charAt(n2) == 'E' || string.charAt(n2) == 'e')) {
            try {
                n3 += Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException(string);
            }
            n2 = n;
        } else if (n2 != n) {
            throw new NumberFormatException(string);
        }
        return MicroDouble.decToDouble(bl, n3, l);
    }

    public static String toString(long l) {
        return MicroDouble.toString(l, 100);
    }

    public static String toString(long l, int n) {
        if (MicroDouble.isNaN(l)) {
            return "NaN";
        }
        boolean bl = MicroDouble.unpackSign(l);
        if (MicroDouble.isZero(l)) {
            return bl ? "-0.0" : "0.0";
        }
        if (MicroDouble.isInfinite(l)) {
            return bl ? "-Infinity" : "Infinity";
        }
        if (n < 9) {
            n = 9;
        }
        int n2 = MicroDouble.unpackExponent(l);
        long l2 = MicroDouble.unpackMantissa(l);
        int n3 = n2 + 1075;
        int n4 = n3 % 11;
        l2 <<= n4;
        int n5 = pow2x[n3 /= 11];
        while (l2 <= 0xCCCCCCCCCCCCCCCL) {
            l2 = (l2 << 3) + (l2 << 1);
            --n5;
        }
        long l3 = MicroDouble.dpMul(l2, pow2m[n3]);
        boolean bl2 = false;
        while (true) {
            int n6 = (int)(l3 % 10L);
            long l4 = l3 / 10L;
            int n7 = n5 + 1;
            if (n6 != 0) {
                boolean bl3;
                if (n6 > 5 || n6 == 5 && !bl2) {
                    bl3 = true;
                    ++l4;
                } else {
                    bl3 = false;
                }
                long l5 = MicroDouble.decToDouble(bl, n7, l4);
                if (l5 != l) {
                    l4 = bl3 ? --l4 : ++l4;
                    bl3 ^= true;
                    l5 = MicroDouble.decToDouble(bl, n7, l4);
                    if (l5 != l) break;
                }
                bl2 = bl3;
            }
            l3 = l4;
            n5 = n7;
        }
        String string;
        block2: while ((string = MicroDouble.toString(bl, n5, l3)).length() > n) {
            int n8 = (int)(l3 % 10L);
            l3 /= 10L;
            ++n5;
            if (n8 > 5 || n8 == 5 && !bl2) {
                bl2 = true;
                ++l3;
            } else {
                bl2 = false;
            }
            while (true) {
                if (l3 % 10L != 0L) continue block2;
                l3 /= 10L;
                ++n5;
            }
            break;
        }
        return string;
    }

    private static String toString(boolean bl, int n, long l) {
        int n2;
        int n3;
        String string;
        boolean bl2;
        StringBuffer stringBuffer = new StringBuffer(26);
        if (bl) {
            stringBuffer.append('-');
        }
        boolean bl3 = bl2 = (n += (string = Long.toString(l)).length() - 1) < -3 || n >= 7;
        if (bl2) {
            n3 = 1;
        } else {
            n3 = n + 1;
            if (n3 < 1) {
                stringBuffer.append('0');
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 < string.length()) {
                stringBuffer.append(string.charAt(n2));
                continue;
            }
            stringBuffer.append('0');
        }
        stringBuffer.append('.');
        if (n3 >= string.length()) {
            stringBuffer.append('0');
        } else {
            for (n2 = n3; n2 < string.length(); ++n2) {
                if (n2 < 0) {
                    stringBuffer.append('0');
                    continue;
                }
                stringBuffer.append(string.charAt(n2));
            }
        }
        if (bl2) {
            stringBuffer.append('E');
            stringBuffer.append(Integer.toString(n));
        }
        return stringBuffer.toString();
    }

    public static long toDegrees(long l) {
        return MicroDouble.div(MicroDouble.mul(l, 4640537203540230144L), 4614256656552045848L);
    }

    public static long toRadians(long l) {
        return MicroDouble.mul(MicroDouble.div(l, 4640537203540230144L), 4614256656552045848L);
    }

    public static long toGradians(long l) {
        return MicroDouble.div(MicroDouble.mul(l, 4641240890982006784L), 4614256656552045848L);
    }

    public static long gradiansToRadians(long l) {
        return MicroDouble.mul(MicroDouble.div(l, 4641240890982006784L), 4614256656552045848L);
    }

    private static long set(int n, int n2) {
        return (long)n << 32 | (long)n2;
    }

    private static long setLO(long l, int n) {
        return l & 0xFFFFFFFF00000000L | (long)n;
    }

    private static long setHI(long l, int n) {
        return l & 0xFFFFFFFFL | (long)n << 32;
    }

    private static int getHI(long l) {
        return (int)(l >> 32);
    }

    private static int getLO(long l) {
        return (int)l;
    }

    private static int ilogb(long l) {
        if (MicroDouble.isZero(l)) {
            return -2147483647;
        }
        if (MicroDouble.isNaN(l) || MicroDouble.isInfinite(l)) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(l >> 52) & 0x7FF;
        if (n == 0) {
            long l2 = l & 0xFFFFFFFFFFFFFL;
            while (l2 < 0x10000000000000L) {
                l2 <<= 1;
                --n;
            }
        }
        return n - 1023;
    }

    private static long copySign(long l, long l2) {
        return l & Long.MAX_VALUE | l2 & Long.MIN_VALUE;
    }

    public static long scalbn(long l, int n) {
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (n == 0 || MicroDouble.isInfinite(l) || MicroDouble.isZero(l)) {
            return l;
        }
        if (n >= 2098) {
            return MicroDouble.copySign(0x7FF0000000000000L, l);
        }
        if (n <= -2099) {
            return MicroDouble.copySign(0L, l);
        }
        int n2 = (int)(l >> 52) & 0x7FF;
        int n3 = n2 + n;
        if (n2 == 0 || n3 <= 0) {
            return MicroDouble.pack(MicroDouble.unpackSign(l), n3 - 1075, MicroDouble.unpackMantissa(l));
        }
        if (n3 >= 2047) {
            return MicroDouble.copySign(0x7FF0000000000000L, l);
        }
        return l & 0x800FFFFFFFFFFFFFL | (long)n3 << 52;
    }

    public static long IEEEremainder(long l, long l2) {
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2) || MicroDouble.isInfinite(l) || MicroDouble.isZero(l2)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(l) || MicroDouble.isInfinite(l2)) {
            return l;
        }
        int n = MicroDouble.getHI(l);
        int n2 = MicroDouble.getLO(l);
        int n3 = MicroDouble.getHI(l2);
        int n4 = MicroDouble.getLO(l2);
        boolean bl = MicroDouble.unpackSign(l);
        n &= Integer.MAX_VALUE;
        if ((n3 &= Integer.MAX_VALUE) <= 0x7FDFFFFF) {
            l = MicroDouble.mod(l, MicroDouble.scalbn(l2, 1));
        }
        if ((n - n3 | n2 - n4) == 0) {
            return 0L;
        }
        l = MicroDouble.abs(l);
        l2 = MicroDouble.abs(l2);
        if (n3 < 0x200000) {
            if (MicroDouble.gt(MicroDouble.scalbn(l, 1), l2) && MicroDouble.ge(MicroDouble.scalbn(l = MicroDouble.sub(l, l2), 1), l2)) {
                l = MicroDouble.sub(l, l2);
            }
        } else {
            long l3 = MicroDouble.scalbn(l2, -1);
            if (MicroDouble.gt(l, l3) && MicroDouble.ge(l = MicroDouble.sub(l, l2), l3)) {
                l = MicroDouble.sub(l, l2);
            }
        }
        if (bl) {
            return MicroDouble.negate(l);
        }
        return l;
    }

    public static long sqrt(long l) {
        if (MicroDouble.isZero(l)) {
            return l;
        }
        if (MicroDouble.unpackSign(l) || MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (l == 0x7FF0000000000000L) {
            return l;
        }
        int n = MicroDouble.unpackExponent(l);
        long l2 = MicroDouble.unpackMantissa(l);
        while (l2 < 0x10000000000000L) {
            l2 <<= 1;
            --n;
        }
        if ((n & 1) != 0) {
            l2 <<= 1;
        }
        n = (n >> 1) - 26;
        l2 <<= 1;
        long l3 = 0L;
        long l4 = 0L;
        for (long i = 0x20000000000000L; i != 0L; i >>= 1) {
            long l5 = l4 + i;
            if (l5 < l2) {
                l4 = l5 + i;
                l2 -= l5;
                l3 |= i;
            }
            l2 <<= 1;
        }
        if (l2 != 0L) {
            l3 += l3 & 1L;
        }
        return (long)n + 1075L << 52 | (l3 >>= 1) & 0xFFFFFFFFFFFFFL;
    }

    public static long exp(long l) {
        long l2;
        long l3 = l;
        if (MicroDouble.isNaN(l3)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isZero(l3)) {
            return 0x3FF0000000000000L;
        }
        if (MicroDouble.le(l3, -4573606559926636463L)) {
            return 0L;
        }
        if (MicroDouble.ge(l3, 4649454530587146735L)) {
            return 0x7FF0000000000000L;
        }
        long l4 = 0L;
        long l5 = 0L;
        int n = 0;
        int n2 = MicroDouble.getHI(l3) & Integer.MAX_VALUE;
        if (n2 > 1071001154) {
            if (n2 < 1072734898) {
                if (MicroDouble.unpackSign(l3)) {
                    l4 = MicroDouble.add(l3, 4604418534311723008L);
                    l5 = -4761929956433773450L;
                    n = -1;
                } else {
                    l4 = MicroDouble.sub(l3, 4604418534311723008L);
                    l5 = 4461442080421002358L;
                    n = 1;
                }
            } else {
                l2 = MicroDouble.rint(MicroDouble.mul(4609176140021203710L, l3));
                n = MicroDouble.intValue(l2);
                l4 = MicroDouble.sub(l3, MicroDouble.mul(l2, 4604418534311723008L));
                l5 = MicroDouble.mul(l2, 4461442080421002358L);
            }
            l3 = MicroDouble.sub(l4, l5);
        } else {
            if (n2 < 0x3E300000) {
                return MicroDouble.add(l3, 0x3FF0000000000000L);
            }
            n = 0;
        }
        l2 = MicroDouble.mul(l3, l3);
        long l6 = MicroDouble.sub(l3, MicroDouble.mul(l2, MicroDouble.add(4595172819793696062L, MicroDouble.mul(l2, MicroDouble.add(-4654820494858601069L, MicroDouble.mul(l2, MicroDouble.add(4544508515198557740L, MicroDouble.mul(l2, MicroDouble.add(-4702957295668925455L, MicroDouble.mul(l2, 4496342204012209360L))))))))));
        if (n == 0) {
            return MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(MicroDouble.div(MicroDouble.mul(l3, l6), MicroDouble.sub(l6, 0x4000000000000000L)), l3));
        }
        l3 = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(MicroDouble.sub(l5, MicroDouble.div(MicroDouble.mul(l3, l6), MicroDouble.sub(0x4000000000000000L, l6))), l4));
        return MicroDouble.scalbn(l3, n);
    }

    public static long expm1(long l) {
        long l2;
        long l3;
        long l4;
        int n;
        int n2 = MicroDouble.getHI(l);
        int n3 = n2 & Integer.MIN_VALUE;
        long l5 = n3 == 0 ? l : -l;
        if ((n2 &= Integer.MAX_VALUE) >= 1078159482) {
            if (n2 >= 1082535490) {
                if (n2 >= 0x7FF00000) {
                    if ((n2 & 0xFFFFF | MicroDouble.getLO(l)) != 0) {
                        return 9221120237041090560L;
                    }
                    return n3 == 0 ? l : -4616189618054758400L;
                }
                if (l > 4649454530587146735L) {
                    return 0x7FF0000000000000L;
                }
            }
            if (n3 != 0) {
                return -4616189618054758400L;
            }
        }
        if (n2 > 1071001154) {
            long l6;
            long l7;
            if (n2 < 1072734898) {
                if (n3 == 0) {
                    l7 = MicroDouble.sub(l, 4604418534311723008L);
                    l6 = 4461442080421002358L;
                    n = 1;
                } else {
                    l7 = MicroDouble.add(l, 4604418534311723008L);
                    l6 = MicroDouble.negate(4461442080421002358L);
                    n = -1;
                }
            } else {
                l4 = MicroDouble.mul(4609176140021203710L, l);
                l4 = n3 == 0 ? MicroDouble.add(l4, 4602678819172646912L) : MicroDouble.sub(l4, 4602678819172646912L);
                n = MicroDouble.intValue(MicroDouble.add(MicroDouble.mul(4609176140021203710L, l), n3 == 0 ? 4602678819172646912L : MicroDouble.negate(4602678819172646912L)));
                l3 = MicroDouble.intToDouble(n);
                l7 = MicroDouble.sub(l, MicroDouble.mul(l3, 4604418534311723008L));
                l6 = MicroDouble.mul(l3, 4461442080421002358L);
            }
            l = MicroDouble.sub(l7, l6);
            l2 = MicroDouble.sub(MicroDouble.sub(l7, l), l6);
        } else {
            if (n2 < 1016070144) {
                return l;
            }
            n = 0;
            l2 = 0L;
        }
        l4 = MicroDouble.scalbn(l, -1);
        l3 = MicroDouble.mul(l, l4);
        long l8 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(l3, MicroDouble.add(-4638407376216452876L, MicroDouble.mul(l3, MicroDouble.add(4564962959435912581L, MicroDouble.mul(l3, MicroDouble.add(-4677887503499600969L, MicroDouble.mul(l3, MicroDouble.add(4526346094260933177L, MicroDouble.mul(l3, -4716678695450197203L))))))))));
        long l9 = MicroDouble.sub(0x4008000000000000L, MicroDouble.mul(l8, l4));
        long l10 = MicroDouble.mul(l3, MicroDouble.div(MicroDouble.sub(l8, l9), MicroDouble.sub(4618441417868443648L, MicroDouble.mul(l, l9))));
        if (n == 0) {
            return MicroDouble.sub(l, MicroDouble.sub(MicroDouble.mul(l, l10), l3));
        }
        l10 = MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(l, MicroDouble.sub(l10, l2)), l2), l3);
        if (n == -1) {
            return MicroDouble.sub(MicroDouble.scalbn(MicroDouble.sub(l, l10), -1), 4602678819172646912L);
        }
        if (n == 1) {
            if (MicroDouble.lt(l, MicroDouble.negate(4598175219545276416L))) {
                return MicroDouble.negate(MicroDouble.scalbn(MicroDouble.sub(l10, MicroDouble.add(l, 4602678819172646912L)), 1));
            }
            return MicroDouble.add(0x3FF0000000000000L, MicroDouble.scalbn(MicroDouble.sub(l, l10), 1));
        }
        if (n <= -2 || n > 56) {
            l5 = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(l10, l));
            l5 = MicroDouble.setHI(l5, MicroDouble.getHI(l5) + (n << 20));
            return MicroDouble.sub(l5, 0x3FF0000000000000L);
        }
        l9 = 0x3FF0000000000000L;
        if (n < 20) {
            l9 = MicroDouble.setHI(l9, 0x3FF00000 - (0x200000 >> n));
            l5 = MicroDouble.sub(l9, MicroDouble.sub(l10, l));
            l5 = MicroDouble.setHI(l5, MicroDouble.getHI(l5) + (n << 20));
        } else {
            l9 = MicroDouble.setHI(l9, 1023 - n << 20);
            l5 = MicroDouble.add(MicroDouble.sub(l, MicroDouble.add(l10, l9)), 0x3FF0000000000000L);
            l5 = MicroDouble.setHI(l5, MicroDouble.getHI(l5) + (n << 20));
        }
        return l5;
    }

    public static long pow(long l, long l2) {
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        boolean bl;
        if (MicroDouble.isZero(l2)) {
            return 0x3FF0000000000000L;
        }
        if (MicroDouble.isNaN(l) || MicroDouble.isNaN(l2)) {
            return 9221120237041090560L;
        }
        int n = -8388607;
        int n2 = 1 - n;
        int n3 = MicroDouble.getHI(l);
        int n4 = MicroDouble.getLO(l);
        int n5 = MicroDouble.getHI(l2);
        int n6 = MicroDouble.getLO(l2);
        int n7 = n3 & Integer.MAX_VALUE;
        int n8 = n5 & Integer.MAX_VALUE;
        int n9 = 0;
        if (n3 < 0) {
            if (n8 >= 0x43400000) {
                n9 = 2;
            } else if (n8 >= 0x3FF00000) {
                int n10;
                int n11 = (n8 >> 20) - 1023;
                if (n11 > 20) {
                    int n12 = n6 >>> 52 - n11;
                    if (n12 << 52 - n11 == n6) {
                        n9 = 2 - (n12 & 1);
                    }
                } else if (n6 == 0 && (n10 = n8 >> 20 - n11) << 20 - n11 == n8) {
                    n9 = 2 - (n10 & 1);
                }
            }
        }
        if (n6 == 0) {
            if (n8 == 0x7FF00000) {
                if ((n7 - 0x3FF00000 | n4) == 0) {
                    return 9221120237041090560L;
                }
                if (n7 >= 0x3FF00000) {
                    return n5 >= 0 ? 0x7FF0000000000000L : 0L;
                }
                return n5 < 0 ? 0x7FF0000000000000L : 0L;
            }
            if (n8 == 0x3FF00000) {
                if (n5 < 0) {
                    return MicroDouble.div(0x3FF0000000000000L, l);
                }
                return l;
            }
            if (n5 == 0x40000000) {
                return MicroDouble.mul(l, l);
            }
            if (n5 == 1071644672 && n3 >= 0) {
                return MicroDouble.sqrt(l);
            }
        }
        long l10 = MicroDouble.abs(l);
        if (n4 == 0 && (n7 == 0x7FF00000 || n7 == 0 || n7 == 0x3FF00000)) {
            long l11 = l10;
            if (n5 < 0) {
                l11 = MicroDouble.div(0x3FF0000000000000L, l11);
            }
            if (n3 < 0) {
                if ((n7 - 0x3FF00000 | n9) == 0) {
                    l11 = 9221120237041090560L;
                } else if (n9 == 1) {
                    l11 = MicroDouble.negate(l11);
                }
            }
            return l11;
        }
        int n13 = (n3 >> 31) + 1;
        if ((n13 | n9) == 0) {
            return 9221120237041090560L;
        }
        boolean bl2 = bl = (n13 | n9 - 1) == 0;
        if (n8 > 1105199104) {
            if (n8 > 1139802112) {
                if (n7 <= 0x3FEFFFFF) {
                    return n5 < 0 ? 0x7FF0000000000000L : 0L;
                }
                return n5 > 0 ? 0x7FF0000000000000L : 0L;
            }
            if (n7 < 0x3FEFFFFF) {
                if (bl) {
                    return n5 < 0 ? -4503599627370496L : Long.MIN_VALUE;
                }
                return n5 < 0 ? 0x7FF0000000000000L : 0L;
            }
            if (n7 > 0x3FF00000) {
                if (bl) {
                    return n5 > 0 ? -4503599627370496L : Long.MIN_VALUE;
                }
                return n5 > 0 ? 0x7FF0000000000000L : 0L;
            }
            l9 = MicroDouble.sub(l10, 0x3FF0000000000000L);
            l8 = MicroDouble.mul(MicroDouble.mul(l9, l9), MicroDouble.sub(4602678819172646912L, MicroDouble.mul(l9, MicroDouble.sub(4599676419421066581L, MicroDouble.mul(l9, 4598175219545276416L)))));
            l7 = MicroDouble.mul(4609176139934466048L, l9);
            l6 = MicroDouble.sub(MicroDouble.mul(l9, 4491406094830001988L), MicroDouble.mul(l8, 4609176140021203710L));
            l5 = MicroDouble.setLO(MicroDouble.add(l7, l6), 0);
            l4 = MicroDouble.sub(l6, MicroDouble.sub(l5, l7));
        } else {
            int n14;
            n13 = 0;
            if (n7 < 0x100000) {
                l10 = MicroDouble.scalbn(l10, 53);
                n13 -= 53;
                n7 = MicroDouble.getHI(l10);
            }
            n13 += (n7 >> 20) - 1023;
            int n15 = n7 & 0xFFFFF;
            n7 = n15 | 0x3FF00000;
            if (n15 <= 235662) {
                n14 = 0;
            } else if (n15 < 767610) {
                n14 = 1;
            } else {
                n14 = 0;
                ++n13;
                n7 -= 0x100000;
            }
            l10 = MicroDouble.setHI(l10, n7);
            l8 = MicroDouble.sub(l10, BP[n14]);
            l7 = MicroDouble.div(0x3FF0000000000000L, MicroDouble.add(l10, BP[n14]));
            l6 = MicroDouble.mul(l8, l7);
            long l12 = MicroDouble.setLO(l6, 0);
            long l13 = MicroDouble.setHI(0L, (n7 >> 1 | 0x20000000) + 524288 + (n14 << 18));
            long l14 = MicroDouble.sub(l10, MicroDouble.sub(l13, BP[n14]));
            long l15 = MicroDouble.mul(l7, MicroDouble.sub(MicroDouble.sub(l8, MicroDouble.mul(l12, l13)), MicroDouble.mul(l12, l14)));
            long l16 = MicroDouble.mul(l6, l6);
            long l17 = MicroDouble.mul(MicroDouble.mul(l16, l16), MicroDouble.add(4603579539098120963L, MicroDouble.mul(l16, MicroDouble.add(4601392076422097919L, MicroDouble.mul(l16, MicroDouble.add(4599676419357746765L, MicroDouble.mul(l16, MicroDouble.add(4598584653024936193L, MicroDouble.mul(l16, MicroDouble.add(4597478449480325989L, MicroDouble.mul(l16, 4596625081194860271L)))))))))));
            l17 = MicroDouble.add(l17, MicroDouble.mul(l15, MicroDouble.add(l12, l6)));
            l16 = MicroDouble.mul(l12, l12);
            l13 = MicroDouble.setLO(MicroDouble.add(MicroDouble.add(0x4008000000000000L, l16), l17), 0);
            l14 = MicroDouble.sub(l17, MicroDouble.sub(MicroDouble.sub(l13, 0x4008000000000000L), l16));
            l8 = MicroDouble.mul(l12, l13);
            l7 = MicroDouble.add(MicroDouble.mul(l15, l13), MicroDouble.mul(l14, l6));
            long l18 = MicroDouble.setLO(MicroDouble.add(l8, l7), 0);
            long l19 = MicroDouble.sub(l7, MicroDouble.sub(l18, l8));
            long l20 = MicroDouble.mul(4606838314073325568L, l18);
            long l21 = MicroDouble.add(MicroDouble.add(MicroDouble.mul(-4738297118486494731L, l18), MicroDouble.mul(l19, 4606838314010018813L)), DP_LO[n14]);
            long l22 = MicroDouble.intToDouble(n13);
            l5 = MicroDouble.setLO(MicroDouble.add(MicroDouble.add(MicroDouble.add(l20, l21), DP_HI[n14]), l22), 0);
            l4 = MicroDouble.sub(l21, MicroDouble.sub(MicroDouble.sub(MicroDouble.sub(l5, l22), DP_HI[n14]), l20));
        }
        l9 = MicroDouble.setLO(l2, 0);
        l8 = MicroDouble.add(MicroDouble.mul(MicroDouble.sub(l2, l9), l5), MicroDouble.mul(l2, l4));
        l7 = MicroDouble.mul(l9, l5);
        l6 = MicroDouble.add(l8, l7);
        int n16 = MicroDouble.getHI(l6);
        int n17 = MicroDouble.getLO(l6);
        if (n16 >= 0x40900000) {
            if ((n16 - 0x40900000 | n17) != 0 || MicroDouble.gt(MicroDouble.add(l8, 4365981760143196926L), MicroDouble.sub(l6, l7))) {
                return bl ? -4503599627370496L : 0x7FF0000000000000L;
            }
        } else if ((n16 & Integer.MAX_VALUE) >= 1083231232 && ((n16 - -1064252416 | n17) != 0 || MicroDouble.le(l8, MicroDouble.sub(l6, l7)))) {
            return bl ? Long.MIN_VALUE : 0L;
        }
        n17 = n16 & Integer.MAX_VALUE;
        int n18 = (n17 >> 20) - 1023;
        n13 = 0;
        if (n17 > 1071644672) {
            n13 = n16 + (0x100000 >> n18 + 1);
            n18 = ((n13 & Integer.MAX_VALUE) >> 20) - 1023;
            l3 = 0L;
            l3 = MicroDouble.setHI(l3, n13 & ~(1048575 >> n18));
            n13 = (n13 & 0xFFFFF | 0x100000) >> 20 - n18;
            if (n16 < 0) {
                n13 = -n13;
            }
            l7 = MicroDouble.sub(l7, l3);
        }
        l3 = MicroDouble.setLO(MicroDouble.add(l8, l7), 0);
        long l23 = MicroDouble.mul(l3, 4604418534330597376L);
        long l24 = MicroDouble.add(MicroDouble.mul(MicroDouble.sub(l8, MicroDouble.sub(l3, l7)), 4604418534313441775L), MicroDouble.mul(l3, -4746692435354555335L));
        l6 = MicroDouble.add(l23, l24);
        long l25 = MicroDouble.sub(l24, MicroDouble.sub(l6, l23));
        l3 = MicroDouble.mul(l6, l6);
        l5 = MicroDouble.sub(l6, MicroDouble.mul(l3, MicroDouble.add(4595172819793696062L, MicroDouble.mul(l3, MicroDouble.add(-4654820494858601069L, MicroDouble.mul(l3, MicroDouble.add(4544508515198557740L, MicroDouble.mul(l3, MicroDouble.add(-4702957295668925455L, MicroDouble.mul(l3, 4496342204012209360L))))))))));
        long l26 = MicroDouble.sub(MicroDouble.div(MicroDouble.mul(l6, l5), MicroDouble.sub(l5, 0x4000000000000000L)), MicroDouble.add(l25, MicroDouble.mul(l6, l25)));
        l6 = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(l26, l6));
        n16 = MicroDouble.getHI(l6);
        if ((n16 += n13 << 20) >> 20 <= 0) {
            l6 = MicroDouble.scalbn(l6, n13);
        } else {
            n17 = MicroDouble.getHI(l6);
            l6 = MicroDouble.setHI(l6, n17 += n13 << 20);
        }
        if (bl) {
            l6 = MicroDouble.negate(l6);
        }
        return l6;
    }

    public static long log(long l, long l2) {
        if (l2 == 4613303445314885481L) {
            return MicroDouble.log(l);
        }
        if (l2 == 0x4024000000000000L) {
            return MicroDouble.log10(l);
        }
        if (MicroDouble.isZero(l2) || MicroDouble.isInfinite(l2) || MicroDouble.isNaN(l2) || MicroDouble.unpackSign(l2)) {
            return 9221120237041090560L;
        }
        return MicroDouble.div(MicroDouble.log(l), MicroDouble.log(l2));
    }

    public static long log10(long l) {
        if (MicroDouble.isZero(l)) {
            return -4503599627370496L;
        }
        if (MicroDouble.isNaN(l) || MicroDouble.unpackSign(l)) {
            return 9221120237041090560L;
        }
        if (l == 0x7FF0000000000000L) {
            return l;
        }
        int n = MicroDouble.ilogb(l);
        if (n < 0) {
            ++n;
        }
        l = MicroDouble.scalbn(l, -n);
        long l2 = MicroDouble.intToDouble(n);
        return MicroDouble.add(MicroDouble.mul(l2, 4599094494223097856L), MicroDouble.add(MicroDouble.mul(l2, 4420844829172378422L), MicroDouble.mul(4601495173785380110L, MicroDouble.log(l))));
    }

    public static long log(long l) {
        if (MicroDouble.isZero(l)) {
            return -4503599627370496L;
        }
        if (MicroDouble.isNaN(l) || MicroDouble.unpackSign(l)) {
            return 9221120237041090560L;
        }
        if (l == 0x7FF0000000000000L) {
            return l;
        }
        int n = MicroDouble.getHI(l);
        int n2 = 0;
        if (n < 0x100000) {
            n2 -= 54;
            l = MicroDouble.scalbn(l, 54);
            n = MicroDouble.getHI(l);
        }
        n2 += (n >> 20) - 1023;
        int n3 = (n &= 0xFFFFF) + 614244 & 0x100000;
        l = MicroDouble.setHI(l, n | n3 ^ 0x3FF00000);
        n2 += n3 >> 20;
        long l2 = MicroDouble.sub(l, 0x3FF0000000000000L);
        if ((0xFFFFF & 2 + n) < 3) {
            if (MicroDouble.isZero(l2)) {
                if (n2 == 0) {
                    return 0L;
                }
                long l3 = MicroDouble.intToDouble(n2);
                return MicroDouble.add(MicroDouble.mul(l3, 4604418534311723008L), MicroDouble.mul(l3, 4461442080421002358L));
            }
            long l4 = MicroDouble.mul(MicroDouble.mul(l2, l2), MicroDouble.sub(4602678819172646912L, MicroDouble.mul(4599676419421066581L, l2)));
            if (n2 == 0) {
                return MicroDouble.sub(l2, l4);
            }
            long l5 = MicroDouble.intToDouble(n2);
            return MicroDouble.sub(MicroDouble.mul(l5, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(l4, MicroDouble.mul(l5, 4461442080421002358L)), l2));
        }
        long l6 = MicroDouble.intToDouble(n2);
        long l7 = MicroDouble.div(l2, MicroDouble.add(0x4000000000000000L, l2));
        long l8 = MicroDouble.mul(l7, l7);
        long l9 = MicroDouble.mul(l8, l8);
        long l10 = MicroDouble.add(MicroDouble.mul(l9, MicroDouble.add(4600877379321592324L, MicroDouble.mul(l9, MicroDouble.add(4597174411056806063L, MicroDouble.mul(l9, 4594685411790997151L))))), MicroDouble.mul(l8, MicroDouble.add(4604180019048437139L, MicroDouble.mul(l9, MicroDouble.add(4598818590951641945L, MicroDouble.mul(l9, MicroDouble.add(4595719342595441630L, MicroDouble.mul(l9, 4594499633228436036L))))))));
        n3 = n - 398458 | 440401 - n;
        if (n3 > 0) {
            long l11 = MicroDouble.mul(MicroDouble.scalbn(l2, -1), l2);
            if (n2 == 0) {
                return MicroDouble.sub(l2, MicroDouble.sub(l11, MicroDouble.mul(l7, MicroDouble.add(l11, l10))));
            }
            return MicroDouble.sub(MicroDouble.mul(l6, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(l11, MicroDouble.add(MicroDouble.mul(l7, MicroDouble.add(l11, l10)), MicroDouble.mul(l6, 4461442080421002358L))), l2));
        }
        if (n2 == 0) {
            return MicroDouble.sub(l2, MicroDouble.mul(l7, MicroDouble.sub(l2, l10)));
        }
        return MicroDouble.sub(MicroDouble.mul(l6, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(l7, MicroDouble.sub(l2, l10)), MicroDouble.mul(l6, 4461442080421002358L)), l2));
    }

    public static long log1p(long l) {
        int n = MicroDouble.getHI(l);
        int n2 = n & Integer.MAX_VALUE;
        int n3 = 1;
        int n4 = 0;
        long l2 = 0L;
        if (n < 1071284858) {
            if (n2 >= 0x3FF00000) {
                if (l == -4616189618054758400L) {
                    return -4503599627370496L;
                }
                return 9221120237041090560L;
            }
            if (n2 < 1042284544) {
                if (n2 < 1016070144) {
                    return l;
                }
                return MicroDouble.sub(l, MicroDouble.scalbn(MicroDouble.mul(l, l), -1));
            }
            if (n > 0 || n <= -1076707645) {
                n3 = 0;
                l2 = l;
                n4 = 1;
            }
        }
        if (n >= 0x7FF00000) {
            return l;
        }
        long l3 = 0L;
        if (n3 != 0) {
            long l4;
            if (n < 0x43400000) {
                l4 = MicroDouble.add(0x3FF0000000000000L, l);
                n4 = MicroDouble.getHI(l4);
                n3 = (n4 >> 20) - 1023;
                l3 = n3 > 0 ? MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(l4, l)) : MicroDouble.sub(l, MicroDouble.sub(l4, 0x3FF0000000000000L));
                l3 = MicroDouble.div(l3, l4);
            } else {
                l4 = l;
                n4 = MicroDouble.getHI(l4);
                n3 = (n4 >> 20) - 1023;
                l3 = 0L;
            }
            if ((n4 &= 0xFFFFF) < 434334) {
                l4 = MicroDouble.setHI(l4, n4 | 0x3FF00000);
            } else {
                ++n3;
                l4 = MicroDouble.setHI(l4, n4 | 0x3FE00000);
                n4 = 0x100000 - n4 >> 2;
            }
            l2 = MicroDouble.add(l4, -4616189618054758400L);
        }
        long l5 = MicroDouble.scalbn(MicroDouble.mul(l2, l2), -1);
        long l6 = MicroDouble.intToDouble(n3);
        if (n4 == 0) {
            if (MicroDouble.isZero(l2)) {
                if (n3 == 0) {
                    return 0L;
                }
                l3 = MicroDouble.add(l3, MicroDouble.mul(l6, 4461442080421002358L));
                return MicroDouble.add(MicroDouble.mul(l6, 4604418534311723008L), l3);
            }
            long l7 = MicroDouble.mul(l5, MicroDouble.sub(0x3FF0000000000000L, MicroDouble.div(MicroDouble.scalbn(l2, 2), 0x4008000000000000L)));
            if (n3 == 0) {
                return MicroDouble.sub(l2, l7);
            }
            return MicroDouble.sub(MicroDouble.mul(l6, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(l7, MicroDouble.add(MicroDouble.mul(l6, 4461442080421002358L), l3)), l2));
        }
        long l8 = MicroDouble.div(l2, MicroDouble.add(0x4000000000000000L, l2));
        long l9 = MicroDouble.mul(l8, l8);
        long l10 = MicroDouble.mul(l9, MicroDouble.add(4604180019048437139L, MicroDouble.mul(l9, MicroDouble.add(4600877379321592324L, MicroDouble.mul(l9, MicroDouble.add(4598818590951641945L, MicroDouble.mul(l9, MicroDouble.add(4597174411056806063L, MicroDouble.mul(l9, MicroDouble.add(4595719342595441630L, MicroDouble.mul(l9, MicroDouble.add(4594685411790997151L, MicroDouble.mul(l9, 4594499633228436036L)))))))))))));
        if (n3 == 0) {
            return MicroDouble.sub(l2, MicroDouble.sub(l5, MicroDouble.mul(l8, MicroDouble.add(l5, l10))));
        }
        return MicroDouble.sub(MicroDouble.mul(l6, 4604418534311723008L), MicroDouble.sub(MicroDouble.sub(l5, MicroDouble.add(MicroDouble.mul(l8, MicroDouble.add(l5, l10)), MicroDouble.add(MicroDouble.mul(l6, 4461442080421002358L), l3))), l2));
    }

    public static long sin(long l) {
        int n = MicroDouble.getHI(l) & Integer.MAX_VALUE;
        if (n <= 1072243195) {
            return MicroDouble.kernelSin(l, 0L, 0);
        }
        if (n >= 0x7FF00000) {
            return 9221120237041090560L;
        }
        long[] lArray = new long[2];
        int n2 = MicroDouble.remPio2(l, lArray);
        switch (n2 & 3) {
            case 0: {
                return MicroDouble.kernelSin(lArray[0], lArray[1], 1);
            }
            case 1: {
                return MicroDouble.kernelCos(lArray[0], lArray[1]);
            }
            case 2: {
                return MicroDouble.negate(MicroDouble.kernelSin(lArray[0], lArray[1], 1));
            }
        }
        return MicroDouble.negate(MicroDouble.kernelCos(lArray[0], lArray[1]));
    }

    public static long cos(long l) {
        int n = MicroDouble.getHI(l) & Integer.MAX_VALUE;
        if (n <= 1072243195) {
            return MicroDouble.kernelCos(l, 0L);
        }
        if (n >= 0x7FF00000) {
            return 9221120237041090560L;
        }
        long[] lArray = new long[2];
        int n2 = MicroDouble.remPio2(l, lArray);
        switch (n2 & 3) {
            case 0: {
                return MicroDouble.kernelCos(lArray[0], lArray[1]);
            }
            case 1: {
                return MicroDouble.negate(MicroDouble.kernelSin(lArray[0], lArray[1], 1));
            }
            case 2: {
                return MicroDouble.negate(MicroDouble.kernelCos(lArray[0], lArray[1]));
            }
        }
        return MicroDouble.kernelSin(lArray[0], lArray[1], 1);
    }

    public static long tan(long l) {
        int n = MicroDouble.getHI(l) & Integer.MAX_VALUE;
        if (n <= 1072243195) {
            return MicroDouble.kernelTan(l, 0L, 1);
        }
        if (n >= 0x7FF00000) {
            return 9221120237041090560L;
        }
        long[] lArray = new long[2];
        int n2 = MicroDouble.remPio2(l, lArray);
        return MicroDouble.kernelTan(lArray[0], lArray[1], 1 - ((n2 & 1) << 1));
    }

    private static long kernelTan(long l, long l2, int n) {
        int n2 = MicroDouble.getHI(l);
        int n3 = n2 & Integer.MAX_VALUE;
        if (n3 < 0x3E300000 && MicroDouble.intValue(l) == 0) {
            if ((n3 | MicroDouble.getLO(l) | n + 1) == 0) {
                return 0x7FF0000000000000L;
            }
            if (n == 1) {
                return l;
            }
            long l3 = MicroDouble.add(l, l2);
            long l4 = MicroDouble.setLO(l3, 0);
            long l5 = MicroDouble.sub(l2, MicroDouble.sub(l4, l));
            long l6 = MicroDouble.div(-4616189618054758400L, l3);
            long l7 = MicroDouble.setLO(l6, 0);
            long l8 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(l7, l4));
            return MicroDouble.add(l7, MicroDouble.mul(l6, MicroDouble.add(l8, MicroDouble.mul(l7, l5))));
        }
        if (n3 >= 1072010280) {
            if (n2 < 0) {
                l = MicroDouble.negate(l);
                l2 = MicroDouble.negate(l2);
            }
            l = MicroDouble.add(MicroDouble.sub(4605249457297304856L, l), MicroDouble.sub(4359948597267291143L, l2));
            l2 = 0L;
        }
        long l9 = MicroDouble.mul(l, l);
        long l10 = MicroDouble.mul(l9, l9);
        long l11 = MicroDouble.add(4593971859893059194L, MicroDouble.mul(l10, MicroDouble.add(4581960672245896759L, MicroDouble.mul(l10, MicroDouble.add(4570429193025094440L, MicroDouble.mul(l10, MicroDouble.add(4558562946408670465L, MicroDouble.mul(l10, MicroDouble.add(4545397049192321702L, MicroDouble.mul(l10, -4687273268743220365L))))))))));
        long l12 = MicroDouble.mul(l9, MicroDouble.add(4587938466107703806L, MicroDouble.mul(l10, MicroDouble.add(4576262931677611155L, MicroDouble.mul(l10, MicroDouble.add(4564358403679355669L, MicroDouble.mul(l10, MicroDouble.add(4553182066015801448L, MicroDouble.mul(l10, MicroDouble.add(4544897349388904425L, MicroDouble.mul(l10, 4538267711989316308L)))))))))));
        long l13 = MicroDouble.mul(l9, l);
        l11 = MicroDouble.add(MicroDouble.add(l2, MicroDouble.mul(l9, MicroDouble.add(MicroDouble.mul(l13, MicroDouble.add(l11, l12)), l2))), MicroDouble.mul(4599676419421066595L, l13));
        l10 = MicroDouble.add(l, l11);
        if (n3 >= 1072010280) {
            l12 = MicroDouble.intToDouble(n);
            return MicroDouble.mul(MicroDouble.intToDouble(1 - (n2 >> 30 & 2)), MicroDouble.sub(l12, MicroDouble.mul(0x4000000000000000L, MicroDouble.sub(l, MicroDouble.sub(MicroDouble.div(MicroDouble.mul(l10, l10), MicroDouble.add(l10, l12)), l11)))));
        }
        if (n == 1) {
            return l10;
        }
        l9 = MicroDouble.setLO(l10, 0);
        l12 = MicroDouble.sub(l11, MicroDouble.sub(l9, l));
        long l14 = MicroDouble.div(-4616189618054758400L, l10);
        long l15 = MicroDouble.setLO(l14, 0);
        l13 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(l15, l9));
        return MicroDouble.add(l15, MicroDouble.mul(l14, MicroDouble.add(l13, MicroDouble.mul(l15, l12))));
    }

    private static long kernelSin(long l, long l2, int n) {
        int n2 = MicroDouble.getHI(l) & Integer.MAX_VALUE;
        if (n2 < 1044381696) {
            return l;
        }
        long l3 = MicroDouble.mul(l, l);
        long l4 = MicroDouble.mul(l3, l);
        long l5 = MicroDouble.add(S2, MicroDouble.mul(l3, MicroDouble.add(S3, MicroDouble.mul(l3, MicroDouble.add(S4, MicroDouble.mul(l3, MicroDouble.add(S5, MicroDouble.mul(l3, S6))))))));
        if (n == 0) {
            return MicroDouble.add(l, MicroDouble.mul(l4, MicroDouble.add(S1, MicroDouble.mul(l3, l5))));
        }
        return MicroDouble.sub(l, MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(l3, MicroDouble.sub(MicroDouble.mul(4602678819172646912L, l2), MicroDouble.mul(l4, l5))), l2), MicroDouble.mul(l4, S1)));
    }

    private static long kernelCos(long l, long l2) {
        int n = MicroDouble.getHI(l) & Integer.MAX_VALUE;
        if (n < 1044381696) {
            return 0x3FF0000000000000L;
        }
        long l3 = MicroDouble.mul(l, l);
        long l4 = MicroDouble.mul(l3, MicroDouble.add(4586165620538955084L, MicroDouble.mul(l3, MicroDouble.add(-4659324094485802633L, MicroDouble.mul(l3, MicroDouble.add(4537941361668330896L, MicroDouble.mul(l3, MicroDouble.add(-4714566979978243411L, MicroDouble.mul(l3, MicroDouble.add(4477121870137962948L, MicroDouble.mul(l3, -4780295122622859052L)))))))))));
        if (n < 0x3FD33333) {
            return MicroDouble.sub(0x3FF0000000000000L, MicroDouble.sub(MicroDouble.mul(4602678819172646912L, l3), MicroDouble.sub(MicroDouble.mul(l3, l4), MicroDouble.mul(l, l2))));
        }
        long l5 = n > 1072234496 ? 4598738169498697728L : MicroDouble.set(n - 0x200000, 0);
        long l6 = MicroDouble.sub(MicroDouble.mul(4602678819172646912L, l3), l5);
        long l7 = MicroDouble.sub(0x3FF0000000000000L, l5);
        return MicroDouble.sub(l7, MicroDouble.sub(l6, MicroDouble.sub(MicroDouble.mul(l3, l4), MicroDouble.mul(l, l2))));
    }

    private static int remPio2(long l, long[] lArray) {
        int n;
        int n2 = MicroDouble.getHI(l);
        int n3 = n2 & Integer.MAX_VALUE;
        if (n3 <= 1072243195) {
            lArray[0] = l;
            lArray[1] = 0L;
            return 0;
        }
        if (n3 < 1073928572) {
            long l2;
            long l3 = 4609753056924401664L;
            long l4 = l2 = n3 == 1073291771 ? 4297306550709743731L : 4454258360616903473L;
            if (n2 > 0) {
                l3 = MicroDouble.negate(l3);
                l2 = MicroDouble.negate(l2);
            }
            long l5 = MicroDouble.add(l, l3);
            lArray[0] = MicroDouble.add(l5, l2);
            lArray[1] = MicroDouble.add(MicroDouble.sub(l5, lArray[0]), l2);
            return n2 > 0 ? 1 : -1;
        }
        if (n3 <= 1094263291) {
            long l6 = MicroDouble.abs(l);
            long l7 = MicroDouble.rint(MicroDouble.mul(l6, 4603909380684499075L));
            int n4 = MicroDouble.intValue(l7);
            long l8 = MicroDouble.sub(l6, MicroDouble.mul(l7, 4609753056924401664L));
            long l9 = MicroDouble.mul(l7, 4454258360616903473L);
            if (n4 < 32 && n3 != NPIO2_HW[n4 - 1]) {
                lArray[0] = MicroDouble.sub(l8, l9);
            } else {
                int n5 = n3 >> 20;
                lArray[0] = MicroDouble.sub(l8, l9);
                int n6 = n5 - (MicroDouble.getHI(lArray[0]) >> 20 & 0x7FF);
                if (n6 > 16) {
                    l6 = l8;
                    l9 = MicroDouble.mul(l7, 4454258360616747008L);
                    l8 = MicroDouble.sub(l6, l9);
                    l9 = MicroDouble.sub(MicroDouble.mul(l7, 4297306550709743731L), MicroDouble.sub(MicroDouble.sub(l6, l8), l9));
                    lArray[0] = MicroDouble.sub(l8, l9);
                    n6 = n5 - (MicroDouble.getHI(lArray[0]) >> 20 & 0x7FF);
                    if (n6 > 49) {
                        l6 = l8;
                        l9 = MicroDouble.mul(l7, 4297306550709518336L);
                        l8 = MicroDouble.sub(l6, l9);
                        l9 = MicroDouble.sub(MicroDouble.mul(l7, 4142048980368378305L), MicroDouble.sub(MicroDouble.sub(l6, l8), l9));
                        lArray[0] = MicroDouble.sub(l8, l9);
                    }
                }
            }
            lArray[1] = MicroDouble.sub(MicroDouble.sub(l8, lArray[0]), l9);
            if (n2 < 0) {
                lArray[0] = MicroDouble.negate(lArray[0]);
                lArray[1] = MicroDouble.negate(lArray[1]);
                return -n4;
            }
            return n4;
        }
        if (n3 >= 0x7FF00000) {
            lArray[1] = 9221120237041090560L;
            lArray[0] = 9221120237041090560L;
            return 0;
        }
        long l10 = MicroDouble.getLO(l);
        int n7 = (n3 >> 20) - 1046;
        l10 = MicroDouble.setHI(l10, n3 - (n7 << 20));
        long[] lArray2 = new long[3];
        for (n = 0; n < 2; ++n) {
            lArray2[n] = MicroDouble.intToDouble(MicroDouble.intValue(l10));
            l10 = MicroDouble.scalbn(MicroDouble.sub(l10, lArray2[n]), 24);
        }
        lArray2[2] = l10;
        n = 3;
        while (MicroDouble.isZero(lArray2[n - 1])) {
            --n;
        }
        int n8 = MicroDouble.kernelRemPio2(lArray2, lArray, n7, n);
        if (n2 < 0) {
            lArray[0] = MicroDouble.negate(lArray[0]);
            lArray[1] = MicroDouble.negate(lArray[1]);
            return -n8;
        }
        return n8;
    }

    private static int kernelRemPio2(long[] lArray, long[] lArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        long l;
        boolean bl;
        int n6;
        int n7;
        int n8 = n7 = 4;
        int n9 = n2 - 1;
        int n10 = (n - 3) / 24;
        if (n10 < 0) {
            n10 = 0;
        }
        int n11 = n - 24 * (n10 + 1);
        int n12 = n10 - n9;
        int n13 = n9 + n7;
        long[] lArray3 = new long[20];
        int n14 = 0;
        while (n14 <= n13) {
            lArray3[n14] = n12 < 0 ? 0L : MicroDouble.intToDouble(TWO_OVER_PI[n12]);
            ++n14;
            ++n12;
        }
        long[] lArray4 = new long[20];
        for (n6 = 0; n6 <= n7; ++n6) {
            long l2 = 0L;
            for (n12 = 0; n12 <= n9; ++n12) {
                l2 = MicroDouble.add(l2, MicroDouble.mul(lArray[n12], lArray3[n9 + n6 - n12]));
            }
            lArray4[n6] = l2;
        }
        n6 = n7;
        int[] nArray = new int[20];
        do {
            bl = false;
            int n15 = 0;
            l = lArray4[n6];
            for (n12 = n6; n12 > 0; --n12) {
                long l3 = MicroDouble.intToDouble(MicroDouble.intValue(MicroDouble.scalbn(l, -24)));
                nArray[n15] = MicroDouble.intValue(MicroDouble.sub(l, MicroDouble.scalbn(l3, 24)));
                l = MicroDouble.add(lArray4[n12 - 1], l3);
                ++n15;
            }
            l = MicroDouble.scalbn(l, n11);
            l = MicroDouble.sub(l, MicroDouble.scalbn(MicroDouble.floor(MicroDouble.scalbn(l, -3)), 3));
            l = MicroDouble.sub(l, MicroDouble.mul(0x4020000000000000L, MicroDouble.floor(MicroDouble.mul(l, 4593671619917905920L))));
            n5 = MicroDouble.intValue(l);
            l = MicroDouble.sub(l, MicroDouble.intToDouble(n5));
            n4 = 0;
            if (n11 > 0) {
                n15 = nArray[n6 - 1] >> 24 - n11;
                n5 += n15;
                int n16 = n6 - 1;
                nArray[n16] = nArray[n16] - (n15 << 24 - n11);
                n4 = nArray[n6 - 1] >> 23 - n11;
            } else if (n11 == 0) {
                n4 = nArray[n6 - 1] >> 23;
            } else if (MicroDouble.ge(l, 4602678819172646912L)) {
                n4 = 2;
            }
            if (n4 > 0) {
                ++n5;
                boolean bl2 = false;
                for (n15 = 0; n15 < n6; ++n15) {
                    n12 = nArray[n15];
                    if (!bl2) {
                        if (n12 == 0) continue;
                        bl2 = true;
                        nArray[n15] = 0x1000000 - n12;
                        continue;
                    }
                    nArray[n15] = 0xFFFFFF - n12;
                }
                if (n11 > 0) {
                    switch (n11) {
                        case 1: {
                            int n17 = n6 - 1;
                            nArray[n17] = nArray[n17] & 0x7FFFFF;
                            break;
                        }
                        case 2: {
                            int n18 = n6 - 1;
                            nArray[n18] = nArray[n18] & 0x3FFFFF;
                        }
                    }
                }
                if (n4 == 2) {
                    l = MicroDouble.sub(0x3FF0000000000000L, l);
                    if (bl2) {
                        l = MicroDouble.sub(l, MicroDouble.scalbn(0x3FF0000000000000L, n11));
                    }
                }
            }
            if (!MicroDouble.isZero(l)) continue;
            n12 = 0;
            for (n15 = n6 - 1; n15 >= n7; --n15) {
                n12 |= nArray[n15];
            }
            if (n12 != 0) continue;
            int n19 = 1;
            while (nArray[n7 - n19] == 0) {
                ++n19;
            }
            for (n15 = n6 + 1; n15 <= n6 + n19; ++n15) {
                lArray3[n9 + n15] = MicroDouble.intToDouble(TWO_OVER_PI[n10 + n15]);
                long l4 = 0L;
                for (n12 = 0; n12 <= n9; ++n12) {
                    l4 = MicroDouble.add(l4, MicroDouble.mul(lArray[n12], lArray3[n9 + n15 - n12]));
                }
                lArray4[n15] = l4;
            }
            n6 += n19;
            bl = true;
        } while (bl);
        if (MicroDouble.isZero(l)) {
            --n6;
            n11 -= 24;
            while (nArray[n6] == 0) {
                --n6;
                n11 -= 24;
            }
        } else if (MicroDouble.ge(l = MicroDouble.scalbn(l, -n11), 4715268809856909312L)) {
            long l5 = MicroDouble.intToDouble(MicroDouble.intValue(MicroDouble.scalbn(l, -24)));
            nArray[n6] = MicroDouble.intValue(MicroDouble.sub(l, MicroDouble.scalbn(l5, 24)));
            n11 += 24;
            nArray[++n6] = MicroDouble.intValue(l5);
        } else {
            nArray[n6] = MicroDouble.intValue(l);
        }
        long l6 = MicroDouble.scalbn(0x3FF0000000000000L, n11);
        for (int i = n6; i >= 0; --i) {
            lArray4[i] = MicroDouble.mul(l6, MicroDouble.intToDouble(nArray[i]));
            l6 = MicroDouble.scalbn(l6, -24);
        }
        long[] lArray5 = new long[20];
        for (n3 = n6; n3 >= 0; --n3) {
            l6 = 0L;
            for (int i = 0; i <= n8 && i <= n6 - n3; ++i) {
                l6 = MicroDouble.add(l6, MicroDouble.mul(PIO2[i], lArray4[n3 + i]));
            }
            lArray5[n6 - n3] = l6;
        }
        l6 = 0L;
        for (n3 = n6; n3 >= 0; --n3) {
            l6 = MicroDouble.add(l6, lArray5[n3]);
        }
        lArray2[0] = n4 == 0 ? l6 : MicroDouble.negate(l6);
        l6 = MicroDouble.sub(lArray5[0], l6);
        for (n3 = 1; n3 <= n6; ++n3) {
            l6 = MicroDouble.add(l6, lArray5[n3]);
        }
        lArray2[1] = n4 == 0 ? l6 : MicroDouble.negate(l6);
        return n5 & 7;
    }

    private static long pOverQ(long l) {
        return MicroDouble.div(MicroDouble.mul(l, MicroDouble.add(4595172819793696085L, MicroDouble.mul(l, MicroDouble.add(-4623835544539140227L, MicroDouble.mul(l, MicroDouble.add(4596417465768494165L, MicroDouble.mul(l, MicroDouble.add(-4637438604930937029L, MicroDouble.mul(l, MicroDouble.add(4560439845004096136L, MicroDouble.mul(l, 4540259411154564873L))))))))))), MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(l, MicroDouble.add(-4610777653840302773L, MicroDouble.mul(l, MicroDouble.add(4611733184086379208L, MicroDouble.mul(l, MicroDouble.add(-4618997306433404583L, MicroDouble.mul(l, 4590215604441354882L)))))))));
    }

    public static final long asin(long l) {
        int n = MicroDouble.getHI(l);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 >= 0x3FF00000) {
            if ((n2 - 0x3FF00000 | MicroDouble.getLO(l)) == 0) {
                return MicroDouble.copySign(4609753056924675352L, l);
            }
            return 9221120237041090560L;
        }
        if (n2 < 1071644672) {
            if (n2 < 1044381696) {
                return l;
            }
            long l2 = MicroDouble.mul(l, l);
            long l3 = MicroDouble.pOverQ(l2);
            return MicroDouble.add(l, MicroDouble.mul(l, l3));
        }
        long l4 = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.abs(l));
        long l5 = MicroDouble.scalbn(l4, -1);
        long l6 = MicroDouble.sqrt(l5);
        if (n2 >= 0x3FEF3333) {
            l4 = MicroDouble.pOverQ(l5);
            l5 = MicroDouble.sub(4609753056924675352L, MicroDouble.sub(MicroDouble.scalbn(MicroDouble.add(l6, MicroDouble.mul(l6, l4)), 1), 4364452196894661639L));
        } else {
            l4 = MicroDouble.setLO(l6, 0);
            long l7 = MicroDouble.div(MicroDouble.sub(l5, MicroDouble.mul(l4, l4)), MicroDouble.add(l6, l4));
            long l8 = MicroDouble.pOverQ(l5);
            long l9 = MicroDouble.sub(MicroDouble.mul(MicroDouble.scalbn(l6, 1), l8), MicroDouble.sub(4364452196894661639L, MicroDouble.scalbn(l7, 1)));
            long l10 = MicroDouble.sub(4605249457297304856L, MicroDouble.scalbn(l4, 1));
            l5 = MicroDouble.sub(4605249457297304856L, MicroDouble.sub(l9, l10));
        }
        return n > 0 ? l5 : MicroDouble.negate(l5);
    }

    public static long acos(long l) {
        int n = MicroDouble.getHI(l);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 >= 0x3FF00000) {
            if ((n2 - 0x3FF00000 | MicroDouble.getLO(l)) == 0) {
                if (n > 0) {
                    return 0L;
                }
                return 4614256656552045848L;
            }
            return 9221120237041090560L;
        }
        if (n2 < 1071644672) {
            if (n2 <= 1012924416) {
                return 4609753056924675352L;
            }
            long l2 = MicroDouble.mul(l, l);
            long l3 = MicroDouble.pOverQ(l2);
            return MicroDouble.sub(4609753056924675352L, MicroDouble.sub(l, MicroDouble.sub(4364452196894661639L, MicroDouble.mul(l, l3))));
        }
        if (n < 0) {
            long l4 = MicroDouble.scalbn(MicroDouble.add(0x3FF0000000000000L, l), -1);
            long l5 = MicroDouble.sqrt(l4);
            long l6 = MicroDouble.pOverQ(l4);
            long l7 = MicroDouble.sub(MicroDouble.mul(l6, l5), 4364452196894661639L);
            return MicroDouble.sub(4614256656552045848L, MicroDouble.scalbn(MicroDouble.add(l5, l7), 1));
        }
        long l8 = MicroDouble.scalbn(MicroDouble.sub(0x3FF0000000000000L, l), -1);
        long l9 = MicroDouble.sqrt(l8);
        long l10 = MicroDouble.setLO(l9, 0);
        long l11 = MicroDouble.div(MicroDouble.sub(l8, MicroDouble.mul(l10, l10)), MicroDouble.add(l9, l10));
        long l12 = MicroDouble.pOverQ(l8);
        long l13 = MicroDouble.add(MicroDouble.mul(l12, l9), l11);
        return MicroDouble.scalbn(MicroDouble.add(l10, l13), 1);
    }

    public static long atan(long l) {
        int n;
        int n2 = MicroDouble.getHI(l);
        int n3 = n2 & Integer.MAX_VALUE;
        if (n3 >= 0x44100000) {
            if (n3 > 0x7FF00000 || n3 == 0x7FF00000 && MicroDouble.getLO(l) != 0) {
                return 9221120237041090560L;
            }
            return n2 > 0 ? atanhi[3] : MicroDouble.negate(atanhi[3]);
        }
        if (n3 < 1071382528) {
            if (n3 < 1042284544) {
                return l;
            }
            n = -1;
        } else {
            l = MicroDouble.abs(l);
            if (n3 < 0x3FF30000) {
                if (n3 < 1072037888) {
                    n = 0;
                    l = MicroDouble.div(MicroDouble.sub(MicroDouble.scalbn(l, 1), 0x3FF0000000000000L), MicroDouble.add(0x4000000000000000L, l));
                } else {
                    n = 1;
                    l = MicroDouble.div(MicroDouble.sub(l, 0x3FF0000000000000L), MicroDouble.add(l, 0x3FF0000000000000L));
                }
            } else if (n3 < 1073971200) {
                n = 2;
                l = MicroDouble.div(MicroDouble.sub(l, 4609434218613702656L), MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(4609434218613702656L, l)));
            } else {
                n = 3;
                l = MicroDouble.div(-4616189618054758400L, l);
            }
        }
        long l2 = MicroDouble.mul(l, l);
        long l3 = MicroDouble.mul(l2, l2);
        long l4 = MicroDouble.mul(l2, MicroDouble.add(4599676419421066509L, MicroDouble.mul(l3, MicroDouble.add(4594314991288484863L, MicroDouble.mul(l3, MicroDouble.add(4591215095208222830L, MicroDouble.mul(l3, MicroDouble.add(4589464229703073105L, MicroDouble.mul(l3, MicroDouble.add(4587333258118041067L, MicroDouble.mul(l3, 4580351289466214929L)))))))))));
        long l5 = MicroDouble.mul(l3, MicroDouble.add(-4626998257160492092L, MicroDouble.mul(l3, MicroDouble.add(-4630701217362536847L, MicroDouble.mul(l3, MicroDouble.add(-4633165035261879699L, MicroDouble.mul(l3, MicroDouble.add(-4634804155249132134L, MicroDouble.mul(l3, -4637946461342241745L)))))))));
        if (n < 0) {
            return MicroDouble.sub(l, MicroDouble.mul(l, MicroDouble.add(l4, l5)));
        }
        l2 = MicroDouble.sub(atanhi[n], MicroDouble.sub(MicroDouble.sub(MicroDouble.mul(l, MicroDouble.add(l4, l5)), atanlo[n]), l));
        return n2 < 0 ? MicroDouble.negate(l2) : l2;
    }

    public static long cosh(long l) {
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isInfinite(l)) {
            return 0x7FF0000000000000L;
        }
        int n = MicroDouble.getHI(l) & Integer.MAX_VALUE;
        if (n < 1071001155) {
            long l2 = MicroDouble.expm1(MicroDouble.abs(l));
            long l3 = MicroDouble.add(0x3FF0000000000000L, l2);
            if (n < 1015021568) {
                return l3;
            }
            return MicroDouble.add(0x3FF0000000000000L, MicroDouble.div(MicroDouble.mul(l2, l2), MicroDouble.add(l3, l3)));
        }
        if (n < 1077280768) {
            long l4 = MicroDouble.exp(MicroDouble.abs(l));
            return MicroDouble.add(MicroDouble.scalbn(l4, -1), MicroDouble.div(4602678819172646912L, l4));
        }
        if (n < 1082535490) {
            return MicroDouble.scalbn(MicroDouble.exp(MicroDouble.abs(l)), -1);
        }
        if (MicroDouble.abs(l) <= 4649460627574225021L) {
            long l5 = MicroDouble.exp(MicroDouble.scalbn(MicroDouble.abs(l), -1));
            long l6 = MicroDouble.scalbn(l5, -1);
            return MicroDouble.mul(l6, l5);
        }
        return 0x7FF0000000000000L;
    }

    public static long sinh(long l) {
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isInfinite(l)) {
            return 0x7FF0000000000000L;
        }
        int n = MicroDouble.getHI(l);
        int n2 = n & Integer.MAX_VALUE;
        long l2 = 4602678819172646912L;
        if (n < 0) {
            l2 = MicroDouble.negate(l2);
        }
        if (n2 < 1077280768) {
            if (n2 < 0x3E300000) {
                return l;
            }
            long l3 = MicroDouble.expm1(MicroDouble.abs(l));
            if (n2 < 0x3FF00000) {
                return MicroDouble.mul(l2, MicroDouble.sub(MicroDouble.scalbn(l3, 1), MicroDouble.mul(l3, MicroDouble.div(l3, MicroDouble.add(l3, 0x3FF0000000000000L)))));
            }
            return MicroDouble.mul(l2, MicroDouble.add(l3, MicroDouble.div(l3, MicroDouble.add(l3, 0x3FF0000000000000L))));
        }
        if (n2 < 1082535490) {
            return MicroDouble.mul(l2, MicroDouble.exp(MicroDouble.abs(l)));
        }
        if (MicroDouble.abs(l) <= 4649460627574225021L) {
            long l4 = MicroDouble.exp(MicroDouble.scalbn(MicroDouble.abs(l), -1));
            long l5 = MicroDouble.mul(l2, l4);
            return MicroDouble.mul(l5, l4);
        }
        return MicroDouble.copySign(0x7FF0000000000000L, l);
    }

    public static long tanh(long l) {
        long l2;
        if (MicroDouble.isNaN(l)) {
            return 9221120237041090560L;
        }
        if (MicroDouble.isInfinite(l)) {
            return MicroDouble.copySign(0x7FF0000000000000L, l);
        }
        int n = MicroDouble.getHI(l);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 < 1077280768) {
            if (n2 < 1015021568) {
                return l;
            }
            if (n2 >= 0x3FF00000) {
                long l3 = MicroDouble.expm1(MicroDouble.scalbn(MicroDouble.abs(l), 1));
                l2 = MicroDouble.sub(0x3FF0000000000000L, MicroDouble.div(0x4000000000000000L, MicroDouble.add(l3, 0x4000000000000000L)));
            } else {
                long l4 = MicroDouble.expm1(MicroDouble.negate(MicroDouble.mul(0x4000000000000000L, MicroDouble.abs(l))));
                l2 = MicroDouble.negate(MicroDouble.div(l4, MicroDouble.add(l4, 0x4000000000000000L)));
            }
        } else {
            l2 = 0x3FF0000000000000L;
        }
        return n >= 0 ? l2 : MicroDouble.negate(l2);
    }

    public static long acosh(long l) {
        if (MicroDouble.isNaN(l) || MicroDouble.lt(l, 0x3FF0000000000000L)) {
            return 9221120237041090560L;
        }
        if (l == 0x7FF0000000000000L) {
            return l;
        }
        if (l == 0x3FF0000000000000L) {
            return 0L;
        }
        int n = MicroDouble.getHI(l);
        if (n > 1102053376) {
            return MicroDouble.add(MicroDouble.log(l), 4604418534313441775L);
        }
        if (n > 0x40000000) {
            long l2 = MicroDouble.mul(l, l);
            return MicroDouble.log(MicroDouble.sub(MicroDouble.scalbn(l, 1), MicroDouble.div(0x3FF0000000000000L, MicroDouble.add(l, MicroDouble.sqrt(MicroDouble.sub(l2, 0x3FF0000000000000L))))));
        }
        long l3 = MicroDouble.sub(l, 0x3FF0000000000000L);
        return MicroDouble.log1p(MicroDouble.add(l3, MicroDouble.sqrt(MicroDouble.add(MicroDouble.scalbn(l3, 1), MicroDouble.mul(l3, l3)))));
    }

    public static long asinh(long l) {
        long l2;
        int n = MicroDouble.getHI(l);
        int n2 = n & Integer.MAX_VALUE;
        if (n2 >= 0x7FF00000) {
            return l;
        }
        if (n2 < 0x3E300000) {
            return l;
        }
        if (n2 > 1102053376) {
            l2 = MicroDouble.add(MicroDouble.log(MicroDouble.abs(l)), 4604418534313441775L);
        } else if (n2 > 0x40000000) {
            long l3 = MicroDouble.abs(l);
            l2 = MicroDouble.log(MicroDouble.add(MicroDouble.scalbn(l3, 1), MicroDouble.div(0x3FF0000000000000L, MicroDouble.add(MicroDouble.sqrt(MicroDouble.add(MicroDouble.mul(l, l), 0x3FF0000000000000L)), l3))));
        } else {
            long l4 = MicroDouble.mul(l, l);
            l2 = MicroDouble.log1p(MicroDouble.add(MicroDouble.abs(l), MicroDouble.div(l4, MicroDouble.add(0x3FF0000000000000L, MicroDouble.sqrt(MicroDouble.add(0x3FF0000000000000L, l4))))));
        }
        if (n > 0) {
            return l2;
        }
        return MicroDouble.negate(l2);
    }

    public static long atanh(long l) {
        if (MicroDouble.isNaN(l) || MicroDouble.gt(l, 0x3FF0000000000000L) || MicroDouble.lt(l, -4616189618054758400L)) {
            return 9221120237041090560L;
        }
        boolean bl = MicroDouble.unpackSign(l);
        if ((l = MicroDouble.abs(l)) == 0x3FF0000000000000L) {
            l = 0x7FF0000000000000L;
        } else if (MicroDouble.lt(l, 4602678819172646912L)) {
            long l2 = MicroDouble.add(l, l);
            l = MicroDouble.scalbn(MicroDouble.log1p(MicroDouble.add(l2, MicroDouble.div(MicroDouble.mul(l2, l), MicroDouble.sub(0x3FF0000000000000L, l)))), -1);
        } else {
            l = MicroDouble.scalbn(MicroDouble.log1p(MicroDouble.div(MicroDouble.add(l, l), MicroDouble.sub(0x3FF0000000000000L, l))), -1);
        }
        if (bl) {
            l = MicroDouble.negate(l);
        }
        return l;
    }

    public static long percentChange(long l, long l2) {
        return MicroDouble.mul(MicroDouble.div(MicroDouble.sub(l2, l), l), 4636737291354636288L);
    }

    public static long percentTotal(long l, long l2) {
        return MicroDouble.mul(MicroDouble.div(l2, l), 4636737291354636288L);
    }

    public static long factorial(long l) {
        if (MicroDouble.isZero(l)) {
            return 0x3FF0000000000000L;
        }
        if (!MicroDouble.isPositiveInteger(l)) {
            return 9221120237041090560L;
        }
        return MicroDouble.factorial(0x3FF0000000000000L, l, 0x3FF0000000000000L);
    }

    private static boolean isPositiveInteger(long l) {
        return !MicroDouble.unpackSign(l) && !MicroDouble.isNaN(l) && !MicroDouble.isInfinite(l) && !MicroDouble.isZero(l) && MicroDouble.rint(l) == l;
    }

    private static long factorial(long l, long l2, long l3) {
        while (l2 != l3 && l != 0x7FF0000000000000L) {
            l = MicroDouble.mul(l, l2);
            l2 = MicroDouble.add(l2, -4616189618054758400L);
        }
        return l;
    }

    public static long permutations(long l, long l2) {
        if (!(MicroDouble.isPositiveInteger(l) && MicroDouble.isPositiveInteger(l2) && MicroDouble.ge(l, l2))) {
            return 9221120237041090560L;
        }
        return MicroDouble.factorial(0x3FF0000000000000L, l, MicroDouble.sub(l, l2));
    }

    public static long combinations(long l, long l2) {
        if (!(MicroDouble.isPositiveInteger(l) && MicroDouble.isPositiveInteger(l2) && MicroDouble.ge(l, l2))) {
            return 9221120237041090560L;
        }
        long l3 = MicroDouble.sub(l, l2);
        if (MicroDouble.gt(l3, l2)) {
            long l4 = l3;
            l3 = l2;
            l2 = l4;
        }
        l3 = MicroDouble.isZero(l3) ? 0x3FF0000000000000L : MicroDouble.div(0x3FF0000000000000L, MicroDouble.factorial(0x3FF0000000000000L, l3, 0x3FF0000000000000L));
        return MicroDouble.factorial(l3, l, l2);
    }

    public static long gamma(long l) {
        if (MicroDouble.isNaN(l) || MicroDouble.isZero(l) || MicroDouble.lt(l, 0L) && (l == -4503599627370496L || MicroDouble.rint(l) == l)) {
            return 9221120237041090560L;
        }
        return MicroDouble.lgamma(l, true);
    }

    public static long lgamma(long l) {
        return MicroDouble.lgamma(l, false);
    }

    private static long lgamma(long l, boolean bl) {
        long l2;
        long l3;
        long l4;
        int n = MicroDouble.getHI(l);
        int n2 = MicroDouble.getLO(l);
        boolean bl2 = false;
        int n3 = n & Integer.MAX_VALUE;
        if (n3 >= 0x7FF00000) {
            return MicroDouble.mul(l, l);
        }
        if ((n3 | n2) == 0) {
            return 0x7FF0000000000000L;
        }
        if (n3 < 999292928) {
            if (n < 0) {
                bl2 = true;
                l = MicroDouble.negate(l);
            }
            l = MicroDouble.negate(MicroDouble.log(l));
            if (bl) {
                l = MicroDouble.exp(l);
                if (bl2) {
                    l = MicroDouble.negate(l);
                }
            }
            return l;
        }
        if (n < 0) {
            if (n3 >= 0x43300000) {
                return 0x7FF0000000000000L;
            }
            l4 = MicroDouble.sinPi(l);
            if (MicroDouble.isZero(l4)) {
                return 0x7FF0000000000000L;
            }
            l3 = MicroDouble.log(MicroDouble.div(4614256656552045848L, MicroDouble.abs(MicroDouble.mul(l4, l))));
            if (MicroDouble.lt(l4, 0L)) {
                bl2 = true;
            }
            l = MicroDouble.negate(l);
        } else {
            l3 = 0L;
        }
        if ((n3 - 0x3FF00000 | n2) == 0 || (n3 - 0x40000000 | n2) == 0) {
            l2 = 0L;
        } else if (n3 < 0x40000000) {
            int n4;
            long l5;
            if (n3 <= 1072483532) {
                l2 = MicroDouble.negate(MicroDouble.log(l));
                if (n3 >= 1072130372) {
                    l5 = MicroDouble.sub(0x3FF0000000000000L, l);
                    n4 = 0;
                } else if (n3 >= 1070442081) {
                    l5 = MicroDouble.sub(l, MicroDouble.sub(4609261425156079167L, 0x3FF0000000000000L));
                    n4 = 1;
                } else {
                    l5 = l;
                    n4 = 2;
                }
            } else {
                l2 = 0L;
                if (n3 >= 1073460419) {
                    l5 = MicroDouble.sub(0x4000000000000000L, l);
                    n4 = 0;
                } else if (n3 >= 1072936132) {
                    l5 = MicroDouble.sub(l, 4609261425156079167L);
                    n4 = 1;
                } else {
                    l5 = MicroDouble.sub(l, 0x3FF0000000000000L);
                    n4 = 2;
                }
            }
            switch (n4) {
                case 0: {
                    long l6 = MicroDouble.mul(l5, l5);
                    long l7 = MicroDouble.add(4590228395698008264L, MicroDouble.mul(l6, MicroDouble.add(4589517665429971623L, MicroDouble.mul(l6, MicroDouble.add(4575164982564483048L, MicroDouble.mul(l6, MicroDouble.add(4563143216008740701L, MicroDouble.mul(l6, MicroDouble.add(4552280422768239949L, MicroDouble.mul(l6, 4538063219164248658L))))))))));
                    long l8 = MicroDouble.mul(l6, MicroDouble.add(4599480669564178349L, MicroDouble.mul(l6, MicroDouble.add(4581589235564434555L, MicroDouble.mul(l6, MicroDouble.add(4568811493649781355L, MicroDouble.mul(l6, MicroDouble.add(4557843786729364480L, MicroDouble.mul(l6, MicroDouble.add(4547598271341525767L, MicroDouble.mul(l6, 4541745596584974391L)))))))))));
                    long l9 = MicroDouble.add(MicroDouble.mul(l5, l7), l8);
                    l2 = MicroDouble.add(l2, MicroDouble.sub(l9, MicroDouble.scalbn(l5, -1)));
                    break;
                }
                case 1: {
                    long l10 = MicroDouble.mul(l5, l5);
                    long l11 = MicroDouble.mul(l10, l5);
                    long l12 = MicroDouble.add(4602387636645935266L, MicroDouble.mul(l11, MicroDouble.add(-4638485889055082733L, MicroDouble.mul(l11, MicroDouble.add(4573683464413438788L, MicroDouble.mul(l11, MicroDouble.add(-4659256875421984015L, MicroDouble.mul(l11, 4554458007677615095L))))))));
                    long l13 = MicroDouble.add(-4628886608449977079L, MicroDouble.mul(l11, MicroDouble.add(4580836915846773228L, MicroDouble.mul(l11, MicroDouble.add(-4652729689257208617L, MicroDouble.mul(l11, MicroDouble.add(4561265769268226281L, MicroDouble.mul(l11, -4668967117108573128L))))))));
                    long l14 = MicroDouble.add(4589321138371641755L, MicroDouble.mul(l11, MicroDouble.add(-4646272669672412054L, MicroDouble.mul(l11, MicroDouble.add(4567356815629994261L, MicroDouble.mul(l11, MicroDouble.add(-4665265148704595732L, MicroDouble.mul(l11, 4554825044790006772L))))))));
                    long l15 = MicroDouble.sub(MicroDouble.mul(l10, l12), MicroDouble.sub(-4877178723284379873L, MicroDouble.mul(l11, MicroDouble.add(l13, MicroDouble.mul(l5, l14)))));
                    l2 = MicroDouble.add(l2, MicroDouble.add(-4629953606387004862L, l15));
                    break;
                }
                case 2: {
                    long l16 = MicroDouble.mul(l5, MicroDouble.add(-4633143641156767544L, MicroDouble.mul(l5, MicroDouble.add(4603875219004743167L, MicroDouble.mul(l5, MicroDouble.add(4609231207607680367L, MicroDouble.mul(l5, MicroDouble.add(4606981716134495312L, MicroDouble.mul(l5, MicroDouble.add(4597417307973683492L, MicroDouble.mul(l5, 4578867296057666313L)))))))))));
                    long l17 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(l5, MicroDouble.add(4612712789461262748L, MicroDouble.mul(l5, MicroDouble.add(4611975351653570805L, MicroDouble.mul(l5, MicroDouble.add(4605104324179153071L, MicroDouble.mul(l5, MicroDouble.add(4592174453748890760L, MicroDouble.mul(l5, 4569564532599476065L))))))))));
                    l2 = MicroDouble.add(l2, MicroDouble.add(MicroDouble.negate(MicroDouble.scalbn(l5, -1)), MicroDouble.div(l16, l17)));
                }
            }
        } else if (n3 < 0x40200000) {
            int n5 = MicroDouble.intValue(l);
            l4 = 0L;
            long l18 = MicroDouble.sub(l, MicroDouble.intToDouble(n5));
            long l19 = MicroDouble.mul(l18, MicroDouble.add(-4633143641156767544L, MicroDouble.mul(l18, MicroDouble.add(4596913578117826680L, MicroDouble.mul(l18, MicroDouble.add(4599540328982355801L, MicroDouble.mul(l18, MicroDouble.add(4594440851763360503L, MicroDouble.mul(l18, MicroDouble.add(4583336332999498081L, MicroDouble.mul(l18, MicroDouble.add(4566129637262422585L, MicroDouble.mul(l18, 4539839448431978821L)))))))))))));
            long l20 = MicroDouble.add(0x3FF0000000000000L, MicroDouble.mul(l18, MicroDouble.add(4608947853879192436L, MicroDouble.mul(l18, MicroDouble.add(4604677836871294172L, MicroDouble.mul(l18, MicroDouble.add(4595362590636105511L, MicroDouble.mul(l18, MicroDouble.add(4581031541704938613L, MicroDouble.mul(l18, MicroDouble.add(4560314476338981211L, MicroDouble.mul(l18, 4530263847980990784L))))))))))));
            l2 = MicroDouble.add(MicroDouble.scalbn(l18, -1), MicroDouble.div(l19, l20));
            long l21 = 0x3FF0000000000000L;
            switch (n5) {
                case 7: {
                    l21 = MicroDouble.mul(l21, MicroDouble.add(l18, 4618441417868443648L));
                }
                case 6: {
                    l21 = MicroDouble.mul(l21, MicroDouble.add(l18, 0x4014000000000000L));
                }
                case 5: {
                    l21 = MicroDouble.mul(l21, MicroDouble.add(l18, 0x4010000000000000L));
                }
                case 4: {
                    l21 = MicroDouble.mul(l21, MicroDouble.add(l18, 0x4008000000000000L));
                }
                case 3: {
                    l21 = MicroDouble.mul(l21, MicroDouble.add(l18, 0x4000000000000000L));
                    l2 = MicroDouble.add(l2, MicroDouble.log(l21));
                }
            }
        } else if (n3 < 1133510656) {
            l4 = MicroDouble.log(l);
            long l22 = MicroDouble.div(0x3FF0000000000000L, l);
            long l23 = MicroDouble.mul(l22, l22);
            long l24 = MicroDouble.add(4601218545606032745L, MicroDouble.mul(l22, MicroDouble.add(4590669220166325563L, MicroDouble.mul(l23, MicroDouble.add(-4654820494859555236L, MicroDouble.mul(l23, MicroDouble.add(4560459357641193654L, MicroDouble.mul(l23, MicroDouble.add(-4664743177309132991L, MicroDouble.mul(l23, MicroDouble.add(4560853097493747153L, MicroDouble.mul(l23, -4658207879917059100L))))))))))));
            l2 = MicroDouble.add(MicroDouble.mul(MicroDouble.sub(l, 4602678819172646912L), MicroDouble.sub(l4, 0x3FF0000000000000L)), l24);
        } else {
            l2 = MicroDouble.mul(l, MicroDouble.sub(MicroDouble.log(l), 0x3FF0000000000000L));
        }
        if (n < 0) {
            l2 = MicroDouble.sub(l3, l2);
        }
        if (bl) {
            l2 = MicroDouble.exp(l2);
            if (bl2) {
                l2 = MicroDouble.negate(l2);
            }
        }
        return l2;
    }

    private static long sinPi(long l) {
        int n;
        int n2 = Integer.MAX_VALUE & MicroDouble.getHI(l);
        if (n2 < 1070596096) {
            return MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, l), 0L, 0);
        }
        long l2 = MicroDouble.negate(l);
        long l3 = MicroDouble.floor(l2);
        if (MicroDouble.ne(l3, l2)) {
            l2 = MicroDouble.scalbn(l2, -1);
            l2 = MicroDouble.scalbn(MicroDouble.sub(l2, MicroDouble.floor(l2)), 1);
            n = MicroDouble.intValue(MicroDouble.scalbn(l2, 2));
        } else if (n2 >= 0x43400000) {
            l2 = 0L;
            n = 0;
        } else {
            if (n2 < 0x43300000) {
                l3 = MicroDouble.add(l2, 0x4330000000000000L);
            }
            n = MicroDouble.getLO(l3) & 1;
            l2 = MicroDouble.intToDouble(n);
            n <<= 2;
        }
        switch (n) {
            case 0: {
                l2 = MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, l2), 0L, 0);
                break;
            }
            case 1: 
            case 2: {
                l2 = MicroDouble.kernelCos(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(4602678819172646912L, l2)), 0L);
                break;
            }
            case 3: 
            case 4: {
                l2 = MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(0x3FF0000000000000L, l2)), 0L, 0);
                break;
            }
            case 5: 
            case 6: {
                l2 = MicroDouble.negate(MicroDouble.kernelCos(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(l2, 4609434218613702656L)), 0L));
                break;
            }
            default: {
                l2 = MicroDouble.kernelSin(MicroDouble.mul(4614256656552045848L, MicroDouble.sub(l2, 0x4000000000000000L)), 0L, 0);
            }
        }
        return MicroDouble.negate(l2);
    }

    public MicroDouble(long l) {
        if (MicroDouble.isNaN(l)) {
            l = 9221120237041090560L;
        }
        this.value = l;
    }

    public MicroDouble(String string) {
        this(MicroDouble.parseDouble(string));
    }

    public long doubleValue() {
        return this.value;
    }

    public String toString() {
        return MicroDouble.toString(this.value);
    }

    public int hashCode() {
        return (int)this.value ^ (int)(this.value >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof MicroDouble && ((MicroDouble)object).value == this.value;
    }

    static {
        pow10m = new long[]{-815021110370542983L, -1228264617323800998L, -1631822729582842028L, -2025922448585811784L, -2410785455424649436L, -2786628235540701831L, -3153662200497784248L, -3512093806901185046L, -3862124672529506137L, -4203951689744663453L, -4537767136243840519L, -4863758783215693123L, -5182110000961642932L, -5492999862041672041L, -5796603242002637969L, -6093090917745768758L, -6382629663588669918L, -6665382345075878083L, -6941508010590729807L, -7211161980820077193L, -7474495936122174249L, -7731658001846878407L, -7982792831656159810L, -8228041688891786180L, -8467542526035952558L, -8701430062309552536L, -8929835859451740014L, -9152888395723407474L, -294682202642863838L, -720121152745989333L, -1135588877456072824L, -1541319077368263733L, -1937539975720012667L, -2324474446766642487L, -2702340141148116919L, -3071349608317525545L, -3431710416100151156L, -3783625267450371479L, -4127292114472071014L, -4462904269766699465L, -4790650515171610063L, -5110715207949843068L, -5423278384491086237L, -5728515861582144019L, -6026599335303880135L, -6317696477610263060L, -6601971030643840136L, -6879582898840692748L, -7150688238876681628L, -7415439547505577019L, -7673985747338482673L, -7926472270612804602L, -8173041140997884610L, -8413831053483314305L, -8648977452394866742L, -8878612607581929669L, -9102865688819295808L, -196981603220770741L, -624710411122851543L, -1042414325089727326L, -1450328303573004458L, -1848681798185579782L, -2237698882768172872L, -2617598379430861436L, -2988593981640518237L, -3350894374423386207L, -3704703351750405709L, -4050219931171323191L, -4387638465762062920L, -4717148753448332186L, -5038936143766954516L, -5353181642124984136L, -5660062011615247436L, -5959749872445582690L, -6252413799037706962L, -6538218414850328321L, -6817324484979841367L, -7089889006590693951L, -7356065297226292178L, -7616003081050118571L, -7869848573065574033L, -8117744561361917257L, -8359830487432564938L, -8596242524610931813L, -8827113654667930715L, -9052573742614218704L, -98755145788979523L, -528786136287117932L, -948738275445456221L, -1358847786342270957L, -1759345355577441597L, -2150456263033662926L, -2532400508596379067L, -2905392935903719049L, -3269643353196043249L, -3625356651333078602L, -3972732919045027188L, -4311967555482476979L, -4643251380128424041L, -4966770740134231719L, -5282707615139903279L, -5591239719637629412L, -5892540602936190088L, -6186779746782440749L, -6474122660694794910L, -6754730975062328270L, -7028762532061872568L, -7296371474444240045L, -7557708332239520785L, -7812920107430224633L, -8062150356639896359L, -8305539271883716404L, -8543223759426509417L, -8775337516792518218L, -9002011107970261189L, Long.MIN_VALUE, -432345564227567616L, -854558029293551616L, -1266874889709551616L, -1669528073709551616L, -2062744073709551616L, -2446744073709551616L, -2821744073709551616L, -3187955011209551616L, -3545582879861895366L, -3894828845342699809L, -4235889358507547899L, -4568956265895094861L, -4894216917640746191L, -5211854272861108818L, -5522047002568494196L, -5824969590173362729L, -6120792429631242156L, -6409681921289327534L, -6691800565486676536L, -6967307053960650171L, -7236356359111015049L, -7499099821171918249L, -7755685233340769031L, -8006256924911912373L, -8250955842461857043L, -8489919629131724885L, -8723282702051517699L, -8951176327949752869L, -9173728696990998152L, -335385916056126881L, -759870872876129023L, -1174406963520662365L, -1579227364540714457L, -1974559787411859078L, -2360626606621961247L, -2737644984756826646L, -3105826994654156138L, -3465379738694516969L, -3816505465296431844L, -4159401682681114338L, -4494261269970843337L, -4821272585683469312L, -5140619573684080616L, -5452481866653427593L, -5757034887131305500L, -6054449946191733143L, -6344894339805432013L, -6628531442943809817L, -6905520801477381890L, -7176018221920323368L, -7440175859071633405L, -7698142301602209613L, -7950062655635975441L, -8196078626372074883L, -8436328597794046994L, -8670947710510816633L, -8900067937773286985L, -9123818159709293187L, -237904397927796872L, -664674077828931748L, -1081441343357383777L, -1488440626100012710L, -1885900863153361278L, -2274045625900771989L, -2653093245771290262L, -3023256937051093262L, -3384744916816525880L, -3737760522056206171L, -4082502324048081455L, -4419164240055772162L, -4747935642407032618L, -5069001465015685407L, -5382542307406947896L, -5688734536304665171L, -5987750384837592197L, -6279758049420528746L, -6564921784364802719L, -6843401994271320271L, -7115355324258153818L, -7380934748073420954L, -7640289654143017767L, -7893565929601608404L, -8140906042354138323L, -8382449121214030822L, -8618331034163144591L, -8848684464777513505L, -9073638986861858148L, -139898200960150312L, -568964901102714405L, -987975350460687152L, -1397165242411832413L, -1796764746270372707L, -2186998636757228463L, -2568086420435798537L, -2940242459184402124L, -3303676090774835316L, -3658591746624867729L, -4005189066790915007L, -4343663012265570553L, -4674203974643163859L, -4996997883215032322L, -5312226309554747618L, -5620066569652125837L};
        pow10x = new short[]{-1146, -1136, -1126, -1116, -1106, -1096, -1086, -1076, -1066, -1056, -1046, -1036, -1026, -1016, -1006, -996, -986, -976, -966, -956, -946, -936, -926, -916, -906, -896, -886, -876, -867, -857, -847, -837, -827, -817, -807, -797, -787, -777, -767, -757, -747, -737, -727, -717, -707, -697, -687, -677, -667, -657, -647, -637, -627, -617, -607, -597, -587, -578, -568, -558, -548, -538, -528, -518, -508, -498, -488, -478, -468, -458, -448, -438, -428, -418, -408, -398, -388, -378, -368, -358, -348, -338, -328, -318, -308, -298, -289, -279, -269, -259, -249, -239, -229, -219, -209, -199, -189, -179, -169, -159, -149, -139, -129, -119, -109, -99, -89, -79, -69, -59, -49, -39, -29, -19, -9, 1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 210, 220, 230, 240, 250, 260, 270, 280, 290, 299, 309, 319, 329, 339, 349, 359, 369, 379, 389, 399, 409, 419, 429, 439, 449, 459, 469, 479, 489, 499, 509, 519, 529, 539, 549, 559, 569, 579, 588, 598, 608, 618, 628, 638, 648, 658, 668, 678, 688, 698, 708, 718, 728, 738, 748, 758, 768, 778, 788, 798, 808, 818, 828, 838, 848, 858, 868, 877, 887, 897, 907, 917, 927, 937, 947, 957, 967, 977, 987, 997, 1007, 1017, 1027};
        pow2m = new long[]{4556951262222748433L, -9114107888677362826L, 1911323890694592264L, 3914391328142524957L, 8016673440035891112L, -2028596868516046619L, 3362436547623629823L, 6886270049533193878L, -4343663012265570553L, 2888311001383727322L, 5915260930833873555L, -6332289687361778576L, 2481040258324023919L, 5081170449047600985L, -8040506994060064798L, 2131197353912214900L, 4364692180812216116L, 8938889586303418605L, -139898200960150312L, 3749242034739077387L, 7678447687145630489L, -2721283210435300375L, 3220574384798566654L, 6595736340067464508L, -4938676049251384304L, 2766452331409032665L, 5665694374725698899L, -6843401994271320271L, 2376364457868949779L, 4866794409715609148L, -8479549122611984080L, 2041281525984781831L, 4180544565216833190L, 8561755269564074374L, -912269281642327298L, 3591060437415367540L, 7354491775826672723L, -3384744916816525880L, 3084697427331691671L, 6317460331175304542L, -5508585315462527915L, 2649734913688990454L, 5426657103235052450L, -7332950326284164199L, 2276104959472719343L, 4661462957000129215L, -8900067937773286985L, 1955159272639746997L, 4004166190366201849L, 8200532357869981386L, -1652053804791829737L, 3439552567074349441L, 7044203657368267655L, -4020214983419339459L, 2954553157691435450L, 6050924866952059801L, -6054449946191733143L, 2537941837315649223L, 5197704882822449609L, -7801844473689174816L, 2180075438084173169L, 4464794497196386649L, 9143899130258199858L, 1872670541876879331L, 3835229269763848870L, 7854549544476362485L, -2360626606621961247L, 3294436857259538508L, 6747006683667534864L, -4628874385558440215L, 2829899712133347615L, 5795634610449095915L, -6577284391509803182L, 2430865342914508479L, 4978412222288913366L, -8250955842461857043L, 2088097429759527849L, 4276423536147513034L, 8758115402030106693L, -510123730351893108L, 3673419846319648462L, 7523163845262640051L, -3039304518611664792L, 3155443620884047222L, 6462348535570528710L, -5211854272861108818L, 2710505431213761085L, 5551115123125782702L, -7078060301547948642L, 2328306436538696289L, 4768371582031250000L, -8681119073709551616L, 2000000000000000000L, 4096000000000000000L, 8388608000000000000L, -1266874889709551616L, 3518437208883200000L, 0x6400000000000000L, -3689348814741910323L, 3022314549036572937L, 6189700196426901374L, -5770238071427257601L, 2596148429267413814L, 5316911983139663492L, -7557708332239520785L, 2230074519853062314L, 4567192616659071619L, -9093133594791772939L, 1915619426082361073L, 3923188584616675477L, 8034690221294951378L, -1991698500497491194L, 3369993333393829974L, 6901746346790563787L, -4311967555482476979L, 2894802230932904886L, 5928554968950589206L, -6305063497298744923L, 2486616182048933211L, 5092589940836215216L, -8017119874876982854L, 2135987035920910082L, 4374501449566023849L, 8958978968711216842L, -98755145788979523L, 3757668132438133165L, 7695704335233296721L, -2685941595151759931L, 3227812347608635737L, 6610559687902485990L, -4908317832885260309L, 2772669694120814860L, 5678427533559428832L, -6817324484979841367L, 2381705131771844659L, 4877732109868737862L, -8457148712698376476L, 2045869129935088669L, 4189939978107061594L, 8580997075163262144L, -872862063775190746L, 3599131035634557106L, 7371020360979572954L, -3350894374423386207L, 3091630018413806676L, 6331658277711476072L, -5479507920956448621L, 2655689964083835493L, 5438853046443695091L, -7307973034592864070L, 2281220308811097609L, 4671939192445127904L, -8878612607581929669L, 1959553324262936975L, 4013165208090494924L, 8218962346169333605L, -1614309188754756393L, 3447282664438742062L, 7060034896770543742L, -3987792605123478032L, 2961193260766427870L, 6064523798049644278L, -6026599335303880135L, 2543645642425481519L, 5209386275687386152L, -7777920981101784777L, 2184974969366070649L, 4474828737261712688L, 9164449253911987585L, 1876879207201175057L, 3843848616348006518L, 7872201966280717348L, -2324474446766642487L, 3301840819597907790L, 6762169998536515153L, -4597819916706768582L, 2836259667354169965L, 5808659798741340089L, -6550608805887287114L, 2436328502849999770L, 4989600773836799529L, -8228041688891786180L, 2092790248410678361L, 4286034428745069284L, 8777798510069901893L, -469812725086392539L, 3681675540198022979L};
        pow2x = new short[]{-323, -320, -316, -313, -310, -307, -303, -300, -297, -293, -290, -287, -283, -280, -277, -273, -270, -267, -264, -260, -257, -254, -250, -247, -244, -240, -237, -234, -230, -227, -224, -220, -217, -214, -211, -207, -204, -201, -197, -194, -191, -187, -184, -181, -177, -174, -171, -167, -164, -161, -158, -154, -151, -148, -144, -141, -138, -134, -131, -128, -124, -121, -118, -114, -111, -108, -105, -101, -98, -95, -91, -88, -85, -81, -78, -75, -71, -68, -65, -62, -58, -55, -52, -48, -45, -42, -38, -35, -32, -28, -25, -22, -18, -15, -12, -9, -5, -2, 1, 5, 8, 11, 15, 18, 21, 25, 28, 31, 35, 38, 41, 44, 48, 51, 54, 58, 61, 64, 68, 71, 74, 78, 81, 84, 87, 91, 94, 97, 101, 104, 107, 111, 114, 117, 121, 124, 127, 131, 134, 137, 140, 144, 147, 150, 154, 157, 160, 164, 167, 170, 174, 177, 180, 184, 187, 190, 193, 197, 200, 203, 207, 210, 213, 217, 220, 223, 227, 230, 233, 237, 240, 243, 246, 250, 253, 256, 260, 263, 266, 270, 273, 276, 280, 283, 286, 289, 293};
        BP = new long[]{0x3FF0000000000000L, 4609434218613702656L};
        DP_HI = new long[]{0L, 4603444093224222720L};
        DP_LO = new long[]{0L, 4489242115478376454L};
        S1 = -4628199217061079735L;
        S2 = 4575957461383575718L;
        S3 = -4671919876304969259L;
        S4 = 4523617212983017085L;
        S5 = -4730215680275931925L;
        S6 = 4460209850635244924L;
        PIO2 = new long[]{4609753056584663040L, 4500296887714185216L, 4393339057296375808L, 4285399695318056960L, 4174867106174599168L, 4069606033725587456L, 3955147982449410048L, 3848874662444400640L};
        TWO_OVER_PI = new int[]{10680707, 0x6E4E44, 1387004, 2578385, 16069853, 12639074, 9804092, 4427841, 16666979, 11263675, 12935607, 2387514, 0x424DD2, 14681673, 3074569, 13734428, 16653803, 1880361, 10960616, 8533493, 3062596, 8710556, 7349940, 6258241, 3772886, 3769171, 3798172, 8675211, 12450088, 3874808, 9961438, 366607, 15675153, 9132554, 7151469, 3571407, 2607881, 12013382, 4155038, 6285869, 7677882, 13102053, 15825725, 473591, 9065106, 15363067, 6271263, 9264392, 5636912, 4652155, 7056368, 13614112, 10155062, 1944035, 9527646, 15080200, 6658437, 6231200, 6832269, 16767104, 5075751, 3212806, 1398474, 7579849, 6349435, 12618859};
        NPIO2_HW = new int[]{1073291771, 1074340347, 1074977148, 1075388923, 1075800698, 1076025724, 1076231611, 1076437499, 1076643386, 1076849274, 1076971356, 1077074300, 1077177244, 1077280187, 1077383131, 1077486075, 1077589019, 1077691962, 1077794906, 1077897850, 1077968460, 1078019932, 1078071404, 1078122876, 1078174348, 1078225820, 1078277292, 1078328763, 1078380235, 1078431707, 1078483179, 1078534651};
        atanhi = new long[]{4602023952714414927L, 4605249457297304856L, 4607027438436873883L, 4609753056924675352L};
        atanlo = new long[]{4357843414468748770L, 4359948597267291143L, 4354989122426817469L, 4364452196894661639L};
    }
}

