/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public abstract class CardUtils
implements CardDefs {
    static final boolean CONFIG_ALLOW_MULTIPACK = false;
    static final boolean CONFIG_CARDS_VALIDATE = false;
    static final boolean CONFIG_JOKERS = false;
    protected byte[] pack = null;
    protected int topPack = -1;
    protected int packSize = -1;
    protected int numPacks = 1;
    protected byte[] jokerAs = null;
    protected int numJokers = 0;
    final Random rand = new Random();
    protected boolean bSeedExternal = false;
    protected boolean bLockSeed = false;
    static final char joker = 'j';
    static final char[] suitChar = new char[]{'S', 'D', 'C', 'H'};
    static final char[] cardChar = new char[]{'A', '2', '3', '4', '5', '6', '7', '8', '9', 'T', 'J', 'Q', 'K'};

    CardUtils() {
        this.Debug_Message(this, "CLASS_ID=CardsUtils instantiating");
    }

    static final byte DecodeCard(byte by) {
        if (by == -1) {
            return -1;
        }
        return (byte)(by % 13);
    }

    static final byte DecodeCardAH(byte by) {
        if (by <= -1) {
            return -1;
        }
        byte by2 = (byte)(by % 13);
        if (by2 == 0) {
            by2 = 13;
        }
        return (byte)by2;
    }

    static final byte DecodeSuit(byte by) {
        if (by <= -1) {
            return -1;
        }
        return (byte)(by / 13);
    }

    static final byte EncodePack(byte by, byte by2) {
        if (by2 == 13) {
            by2 = 0;
        }
        return (byte)(by * 13 + by2);
    }

    static final void DecodeHand(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == -1) {
                byArray2[i] = -1;
                byArray3[i] = -1;
                continue;
            }
            byArray2[i] = CardUtils.DecodeSuit(byArray[i]);
            byArray3[i] = CardUtils.DecodeCardAH(byArray[i]);
        }
    }

    static final void CountCardsNSuits(byte[] byArray, int n, int[] nArray, int[] nArray2) {
        int n2;
        for (n2 = 0; n2 <= 13; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            nArray2[n2] = 0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (byArray[n2] <= -1) continue;
            byte by = CardUtils.DecodeCard(byArray[n2]);
            nArray[by] = nArray[by] + 1;
            byte by2 = CardUtils.DecodeSuit(byArray[n2]);
            nArray2[by2] = nArray2[by2] + 1;
        }
        nArray[13] = nArray[0];
    }

    static final void CopyHand(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
    }

    static final int FindInCards(byte by, byte[] byArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    static boolean DoHandsMatch(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            if (CardUtils.FindInCards(byArray[n3], byArray2, n2) >= 0) continue;
            return false;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            if (CardUtils.FindInCards(byArray2[n3], byArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    static final int GetNumInHand(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] <= -1) continue;
            ++n2;
        }
        return n2;
    }

    static final int GetNumMatches(byte by, byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            ++n2;
        }
        return n2;
    }

    static final void SetMatches(byte by, byte[] byArray, int n, byte by2) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            byArray[i] = by2;
        }
    }

    static final void SortHandCard(byte[] byArray, int n, boolean bl, boolean bl2) {
        boolean bl3;
        do {
            bl3 = false;
            for (int i = 0; i < n - 1; ++i) {
                boolean bl4;
                if (bl) {
                    bl4 = bl2 ? (byArray[i] <= -1 && byArray[i + 1] > -1 ? true : (byArray[i + 1] <= -1 ? false : CardUtils.DecodeCard(byArray[i]) < CardUtils.DecodeCard(byArray[i + 1]))) : CardUtils.DecodeCardAH(byArray[i]) < CardUtils.DecodeCardAH(byArray[i + 1]);
                } else if (bl2) {
                    bl4 = byArray[i] <= -1 && byArray[i + 1] > -1 ? true : (byArray[i + 1] <= -1 ? false : CardUtils.DecodeCard(byArray[i]) > CardUtils.DecodeCard(byArray[i + 1]));
                } else {
                    boolean bl5 = bl4 = CardUtils.DecodeCardAH(byArray[i]) > CardUtils.DecodeCardAH(byArray[i + 1]);
                }
                if (!bl4) continue;
                byte by = byArray[i];
                byArray[i] = byArray[i + 1];
                byArray[i + 1] = by;
                bl3 = true;
            }
        } while (bl3);
    }

    static final void SortHandSuit(byte[] byArray, int n, boolean bl) {
        boolean bl2;
        do {
            bl2 = false;
            for (int i = 0; i < n - 1; ++i) {
                boolean bl3;
                byte by = CardUtils.DecodeSuit(byArray[i]);
                byte by2 = CardUtils.DecodeSuit(byArray[i + 1]);
                if (bl) {
                    bl3 = by == by2 && CardUtils.DecodeCard(byArray[i]) < CardUtils.DecodeCard(byArray[i + 1]);
                } else {
                    boolean bl4 = bl3 = by == by2 && CardUtils.DecodeCardAH(byArray[i]) < CardUtils.DecodeCardAH(byArray[i + 1]);
                }
                if (by >= by2 && !bl3) continue;
                byte by3 = byArray[i];
                byArray[i] = byArray[i + 1];
                byArray[i + 1] = by3;
                bl2 = true;
            }
        } while (bl2);
    }

    static final void MoveCard(int n, int n2, byte[] byArray, int n3) {
        if (n < 0 || n2 < 0 || n >= n3 || n2 >= n3) {
            return;
        }
        byte by = byArray[n];
        if (n2 > n) {
            for (int i = n; i < n2; ++i) {
                byArray[i] = byArray[i + 1];
            }
        } else if (n2 < n) {
            for (int i = n; i >= n2 + 1; --i) {
                byArray[i] = byArray[i - 1];
            }
        }
        byArray[n2] = by;
    }

    final void InitPack(int n, int n2) {
        if (n2 > 0) {
            this.Debug_Error(this, "InitPack. must use CONFIG_ALLOW_MULTIPACK & CONFIG_JOKERS for jokers");
        }
        this.packSize = 52;
        this.pack = new byte[this.packSize];
    }

    final void StartPack() {
        for (int i = 0; i < 52; ++i) {
            this.pack[i] = (byte)i;
        }
        this.topPack = this.packSize - 1;
    }

    final byte DealCard() {
        if (this.topPack < 0) {
            return -1;
        }
        byte by = this.pack[this.topPack];
        --this.topPack;
        return by;
    }

    final void ShuffleFlip(int n) {
        if (this.RandX(100) > 49) {
            int n2 = n - 1;
            for (int i = 0; i < n / 2; ++i) {
                byte by = this.pack[i];
                this.pack[i] = this.pack[n2];
                this.pack[n2] = by;
                --n2;
            }
        }
    }

    final void Shuffle(int n, int n2, int n3) {
        if (n2 > n3 / 2 - 1) {
            n2 = n3 / 2 - 1;
        }
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6 = this.RandX(n3 / 2) + n3 / 2;
            if (n6 + (n5 = this.RandX(n2 - 1) + 1) > n3) {
                n5 = n3 - n6;
            }
            int n7 = this.RandX(n3 / 2);
            if (n == 1) {
                n4 = n3 / 2 - (n5 = (n5 + n2) / 2) - 2;
                if (n4 < 1) {
                    n4 = 1;
                }
                n6 = n3 / 2 - 1 + this.RandX(n4);
                n7 = 0;
            }
            n4 = n6;
            while (n4 < n6 + n5) {
                byte by = this.pack[n4];
                this.pack[n4] = this.pack[n7];
                this.pack[n7] = by;
                ++n4;
                ++n7;
            }
        }
    }

    final boolean ReStartPack(boolean[] blArray) {
        int n;
        if (blArray.length < this.packSize) {
            return false;
        }
        this.StartPack();
        for (n = 0; n < this.packSize; ++n) {
            if (!blArray[n]) continue;
            this.pack[n] = -1;
        }
        this.topPack = this.packSize - 1;
        for (n = 0; n <= this.topPack; ++n) {
            if (this.pack[n] != -1) continue;
            for (int i = n + 1; i < this.packSize; ++i) {
                this.pack[i - 1] = this.pack[i];
            }
            this.pack[this.topPack] = -1;
            --this.topPack;
            --n;
        }
        if (this.topPack < 0) {
            this.topPack = 0;
        }
        return true;
    }

    public final int RandX(int n) {
        int n2 = this.rand.nextInt();
        int n3 = n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3 %= n;
    }

    public final void LockSeed(long l) {
        this.SetSeed(l);
        this.bLockSeed = true;
    }

    public final void SetSeed(long l) {
        if (this.bLockSeed) {
            return;
        }
        this.rand.setSeed(l);
        this.bSeedExternal = true;
    }

    public final void ClearSeedInternal() {
        this.bSeedExternal = false;
    }

    public final void ClearLockSeed() {
        this.bLockSeed = false;
    }

    public void Debug_Error(Object object, String string) {
        ShellyCanvas.reportError(object.toString() + ": " + string);
    }

    public void Debug_Warn(Object object, String string) {
        ShellyCanvas.reportWarning(object.toString() + ": " + string);
    }

    public void Debug_Message(Object object, String string) {
        ShellyCanvas.reportDebug(object.toString() + ": " + string);
    }

    static final char DecodeSuitChar(byte by) {
        byte by2 = CardUtils.DecodeSuit(by);
        if (by2 < 0) {
            return 'N';
        }
        return suitChar[by2];
    }

    static final char DecodeCardChar(byte by) {
        byte by2 = CardUtils.DecodeCard(by);
        if (by2 < 0) {
            return 'N';
        }
        return cardChar[by2];
    }

    static final char[] DecodeChar(byte by) {
        char[] cArray = new char[]{CardUtils.DecodeCardChar(by), CardUtils.DecodeSuitChar(by)};
        return cArray;
    }

    static final String DecodeString(byte by) {
        char[] cArray = CardUtils.DecodeChar(by);
        return String.valueOf(cArray);
    }

    static final byte EncodeSuitChar(char c) {
        for (byte by = 0; by < 4; by = (byte)(by + 1)) {
            if (suitChar[by] != c) continue;
            return by;
        }
        return -1;
    }

    static final byte EncodeCardChar(char c) {
        for (byte by = 0; by < 13; by = (byte)(by + 1)) {
            if (cardChar[by] != c) continue;
            return by;
        }
        return -1;
    }

    static final byte EncodeChar(char[] cArray) {
        byte by = CardUtils.EncodeCardChar(cArray[0]);
        byte by2 = CardUtils.EncodeSuitChar(cArray[1]);
        return CardUtils.EncodePack(by2, by);
    }

    static final byte EncodeChar(String string) {
        return CardUtils.EncodeChar(string.toCharArray());
    }

    static final void ParseHand(String string, byte[] byArray, int n) {
        if (byArray == null) {
            byArray = new byte[n];
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < n && string.length() >= n2 * 2 + 1 + n3) {
            char c;
            byArray[n2] = CardUtils.EncodeChar(string.substring(n2 * 2 + n3, n2 * 2 + 1 + n3 + 1));
            if (string.length() < ++n2 * 2 + 1 + n3 || (c = string.charAt(n2 * 2 + n3)) != ',' && c != ';' && c != ' ') continue;
            ++n3;
        }
        while (n2 < n) {
            byArray[n2++] = -1;
        }
    }

    static final String StringHand(byte[] byArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + CardUtils.DecodeString(byArray[i]);
            if (i >= n - 1) continue;
            string = string + " ";
        }
        return string;
    }
}

