/*
 * Decompiled with CFR 0.152.
 */
public class CafeCardsPlayer
implements CafeCardsDefs,
CC_BuildConfig {
    private int gameType = 0;
    private int playerType = 0;
    private int skillLevel = 5;
    private int rankPlayer = 5;
    final int SMAX;
    final int SUNUSED;
    final int SREJECT;
    private CafeCardsEngine engineParent = null;
    private int meInRef = -1;
    private byte[] handRef;
    private byte[] hand;
    private int numCards;
    private int[] score;
    private int objective;
    private int tactics;
    private int[] countCards = new int[14];
    private int[] countSuits = new int[4];
    private int[] scratch = new int[14];
    private byte[] meldPlay;
    private byte[] meldKnock;
    private byte[] handKnock;
    private byte[] ginTemp;
    private byte[] ginTemp2;
    private byte[] ginTemp3;
    private byte ginLastDiscard = (byte)-1;
    private boolean ginFirstPass;
    int memory = 10;
    static final int OBJECTIVE_HEARTS_NONE = 0;
    static final int OBJECTIVE_HEARTS_MINIMISE = 1;
    static final int OBJECTIVE_HEARTS_SHOOTMOON = 2;
    private boolean gotQueenSpades;
    private static final int PLAYMODE_LEAD = 0;
    private static final int PLAYMODE_FOLLOWSUIT = 1;
    private static final int PLAYMODE_OFFSUIT = 2;
    private byte leadSuit;
    private byte leadCard;
    private byte rankCap;
    private byte suitCap;
    private int playMode;
    private int trickWinner;
    static final int FISH_SPADES_PAVE_QS = 0;
    static final int FISH_LOW_HEARTS = 1;
    static final int FISH_ENDGAME_HEARTS = 2;
    static final int FISH_NUM = 2;
    static final int OBJECTIVE_SPADES_NONE = 0;
    static final int OBJECTIVE_SPADES_WINTRICK = 1;
    static final int OBJECTIVE_SPADES_LOSETRICK = 2;
    static final int TACTIC_SPADES_NONE = 0;
    static final int TACTIC_SPADES_FORCESET = 1;
    static final int TACTIC_SPADES_OPPDOOMED = 2;
    int spadesMyTricksDiff;
    int spadesTeamTricksDiff;
    int spadesOppTeamTricksDiff;
    boolean bSpadesNilBid;
    int partner;
    int oppTeam1;
    int oppTeam2;
    public static final short[] ginMeldWeights_Weak = new short[]{46, 1, 182, 26, 33, -1, 30, 216, 32, 265, 9, 44, 3, 17, 33, 120};
    public static final short[] ginMeldWeights_Edna = new short[]{49, -5, 159, 18, 40, -1, 60, 217, 44, 245, 21, 56, 29, 79, 28, 100};
    public static final short[] ginMeldWeights_BasPlay = new short[]{50, 15, 190, 20, 17, -2, 50, 80, 40, 250, 20, 35, 0, 30, 50, 100};
    public static final short[] ginMeldWeights_SrchPlay = new short[]{56, 14, 242, 12, 27, 1, 35, 51, 39, 359, 47, 56, 11, 64, 68, 81};
    public static final short[] ginMeldWeights_ProbPlay = new short[]{18, 34, 153, 54, 33, 1, 43, 87, 30, 161, 16, 26, 42, 66, 80, 69};
    public static final short[] ginMeldWeights_Expert = new short[]{34, 21, 96, 35, 32, 5, 40, 125, 46, 301, 45, 101, 41, 93, 83, 110};
    public static final short[] ginMeldWeights_BasPlay_T = new short[]{50, 15, 190, 20, 17, -2, 50, 80, 40, 250, 45, 50, 0, 50, 50, 100};
    public static final short[] ginMeldWeights_Expert_T = new short[]{31, 18, 108, 35, 31, 3, 44, 96, 42, 290, 44, 83, 40, 92, 81, 119};
    byte cardTakenDiscard;
    private int gp_MeldToTries = 5;
    private int gp_FindMeldTries = 10;
    private int gp_MeldTriesKnock = 10;
    private int gp_MeldGap = 0;
    private int gp_MinMeld = 2;
    private int gp_MinMeldMatchDiscard = 2;
    private int gp_MeldLowest = 0;
    private int gp_KnockDeadWood = 10;
    private int gp_PickCaution = 10;
    private boolean gp_SrchConistent = false;
    private boolean gp_RejectUnmeldedDiscards = true;
    private boolean gp_OverRideForKnock = true;
    private boolean gp_CrossCheckTake = true;
    private boolean gp_TakeKnockFullTest = true;
    private static final int GP_TAKECARD_BYMELDS = 0;
    private static final int GP_DISCARD_BYMELDS = 1;
    private static final int GP_INITORDER = 3;
    private static final int GP_MELDDEFINE = 4;
    private static final int GP_DISCARD_BYMELDSSCORE = 5;
    private static final int GP_DISCARD_KNOCKOPTION = 6;
    private int deadWood = 100;
    boolean bKnockSuppress = false;
    private static final byte[][] emoteMeDid = new byte[][]{{10, 3, 3, 10, 3, 15, 10, 20}, {5, 5, 0, 0, 10, 30, 15, 10}, {0, 0, 0, 0, 0, 5, 0, 15}, {0, 5, 0, 0, 5, 10, 30, 0}, {0, 10, 20, 0, 5, 40, 40, 0}, {0, 0, 50, 0, 0, 60, 80, 0}, {20, 5, 10, 30, 5, 5, 0, 10}, {20, 0, 20, 20, 0, 0, 0, 20}, {30, 0, 10, 25, 20, 0, 0, 10}, {0, 15, 0, 0, 10, 15, 30, 0}, {0, 15, 15, 0, 5, 25, 50, 0}, {30, 20, 15, 50, 20, 0, 0, 10}, {0, 50, 20, 0, 10, 30, 20, 5}, {10, 5, 0, 5, 0, 10, 0, 40}, {0, 10, 0, 0, 0, 10, 0, 15}, {5, 5, 0, 5, 5, 10, 5, 15}, {5, 0, 0, 0, 5, 10, 5, 15}, {15, 5, 10, 30, 5, 0, 0, 5}};
    private static final byte[][] emoteOppDid = new byte[][]{{10, 3, 3, 10, 3, 15, 10, 20}, {0, 5, 0, 10, 0, 10, 10, 15}, {0, 10, 0, 10, 10, 20, 5, 30}, {0, 5, 10, 30, 5, 20, 0, 10}, {0, 5, 10, 30, 10, 20, 0, 10}, {5, 5, 20, 50, 5, 30, 5, 0}, {10, 0, 0, 20, 20, 20, 20, 20}, {0, 0, 0, 0, 15, 30, 20, 0}, {0, 10, 10, 10, 10, 0, 15, 10}, {0, 40, 40, 25, 20, 10, 0, 0}, {30, 10, 20, 20, 0, 10, 0, 20}, {0, 15, 10, 5, 10, 30, 20, 10}, {20, 50, 20, 30, 20, 50, 5, 10}, {10, 10, 0, 10, 0, 15, 10, 50}, {0, 10, 0, 0, 0, 10, 0, 15}, {5, 5, 0, 5, 5, 10, 5, 15}, {5, 0, 5, 5, 5, 5, 5, 15}, {0, 0, 0, 0, 5, 10, 5, 5}};
    private static final byte[][] emotePlayerFac = new byte[][]{{-20, -10, -80, -50, -100, 30, 50, 20}, {0, 0, 0, 10, -50, 10, 0, 0}, {0, 0, 40, 30, 20, 20, 10, 0}, {20, -50, -70, 20, -80, -20, -70, 20}, {-20, -30, -30, -30, -30, -30, -30, -50}, {20, 20, 40, 20, 50, -10, 20, -30}, {0, 30, 10, -20, -40, 0, 90, 0}, {-10, 50, 20, 20, 30, -30, 0, -20}, {-20, -10, -30, -10, -80, -20, -10, 50}, {-40, -40, -90, -40, -100, 40, -40, 80}, {-50, 0, 20, -30, -60, 20, 70, 0}, {-70, -30, -30, -10, -40, 50, 20, 0}};

    private CafeCardsPlayer() {
        this.SMAX = 1000;
        this.SUNUSED = 99999;
        this.SREJECT = 9999;
    }

    public CafeCardsPlayer(CafeCardsEngine cafeCardsEngine, int n, int n2) {
        this.SMAX = 1000;
        this.SUNUSED = 99999;
        this.SREJECT = 9999;
        this.gameType = n;
        this.engineParent = cafeCardsEngine;
        this.meInRef = n2;
        this.engineParent.Debug_Message(this, "CLASS_ID=CafeCardsPlayer instantiating");
        if (this.gameType == 1 || this.gameType == 2) {
            this.handRef = this.engineParent.GetPlayerHand(this.meInRef);
            this.hand = new byte[13];
            this.score = new int[13];
            this.numCards = 13;
        } else if (this.gameType == 3) {
            this.handRef = this.engineParent.GetPlayerHand(this.meInRef);
            this.hand = new byte[11];
            this.numCards = 11;
            this.meldPlay = new byte[11];
            this.meldKnock = new byte[11];
            this.handKnock = new byte[11];
            this.ginTemp = new byte[11];
            this.ginTemp2 = new byte[11];
            this.ginTemp3 = new byte[11];
            this.score = new int[11];
        }
    }

    public void SetPlayerType(int n, int n2) {
        this.playerType = n;
        this.skillLevel = n2 + this.RandX(1) - this.RandX(1);
        if (this.skillLevel > 10) {
            this.skillLevel = 10;
        }
        if (this.skillLevel < 0) {
            this.skillLevel = 0;
        }
        this.rankPlayer = this.skillLevel - 2;
        switch (this.playerType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.memory = this.RandX(9) + this.playerType >> 1;
                this.rankPlayer = this.playerType + (this.skillLevel >> 3) - 1;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.memory = 3 + this.RandX(13) + this.playerType * 3 >> 2;
                this.rankPlayer = (this.playerType >> 1) + (this.skillLevel + 2) >> 1;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.memory = 10 + this.RandX(13) + this.playerType * 6 >> 3;
                this.rankPlayer = this.playerType + this.skillLevel + 18 >> 2;
                break;
            }
            case 12: {
                this.memory = 10 + this.RandX(13) + this.playerType * 6 >> 3;
                this.rankPlayer = this.skillLevel + 70 >> 3;
                break;
            }
        }
        if (this.memory > 10) {
            this.memory = 10;
        }
        if (this.rankPlayer > 10) {
            this.rankPlayer = 10;
        }
        if (this.rankPlayer < 0) {
            this.rankPlayer = 0;
        }
    }

    public int GetSkillLevel() {
        return this.skillLevel;
    }

    public int GetRank() {
        return this.rankPlayer;
    }

    public CafeCardsEngine GetParent() {
        return this.engineParent;
    }

    public int GetPlayerType() {
        return this.playerType;
    }

    public void SetHand(byte[] byArray, int n) {
        int n2;
        if (this.gameType == 3 && this.engineParent.lastGameState > 1) {
            int n3;
            boolean bl = true;
            boolean bl2 = false;
            for (n2 = 0; n2 < 11; ++n2) {
                if (this.hand[n2] > -1 && (n3 = CardUtils.FindInCards(this.hand[n2], byArray, 11)) < 0) {
                    this.hand[n2] = -1;
                    this.meldPlay[n2] = 0;
                }
                bl2 |= this.hand[n2] > -1;
            }
            if (bl2) {
                this.engineParent.GinSortByMeld(this.hand, this.meldPlay, true, false);
            }
            for (n2 = 0; n2 < n; ++n2) {
                n3 = CardUtils.FindInCards(byArray[n2], this.hand, 11);
                if (n3 >= 0) continue;
                for (int i = 0; i < 11; ++i) {
                    if (this.hand[i] > -1) continue;
                    this.hand[i] = byArray[n2];
                    n3 = 1;
                    break;
                }
                if (n3 >= 0) continue;
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.hand[n2] = byArray[n2];
        }
    }

    public void ReadyNewGame() {
        if (this.gameType == 3) {
            this.GinClearNewGame();
        }
    }

    public void CardHasPlayed(byte by) {
        int n = CardUtils.FindInCards(by, this.hand, this.hand.length);
        if (n >= 0) {
            this.hand[n] = -1;
        }
    }

    private int RandX(int n) {
        return this.engineParent.RandX(n);
    }

    private void ResetScores(int n) {
        for (int i = 0; i < this.numCards; ++i) {
            this.score[i] = this.hand[i] == -1 ? 99999 : (this.RandX(76) - this.RandX(76)) / (1 + n);
        }
    }

    private void RandomiseScores(int n) {
        for (int i = 0; i < this.numCards; ++i) {
            if (this.hand[i] == -1) continue;
            int n2 = this.score[i] + this.RandX(n) - this.RandX(n);
            this.UpdateScore(i, n2, 900);
        }
    }

    private int RandomiseScore(int n, int n2) {
        return n + this.RandX(n2) - this.RandX(n2);
    }

    private int GetGroupMask(int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = 1;
        for (int i = 0; i < this.numCards; ++i) {
            if (this.hand[i] != -1) {
                byte by = CardUtils.DecodeSuit(this.hand[i]);
                byte by2 = bl ? CardUtils.DecodeCardAH(this.hand[i]) : CardUtils.DecodeCard(this.hand[i]);
                if ((n < 0 || n == by) && by2 >= n2 && by2 <= n3) {
                    n4 |= n5;
                }
            }
            n5 <<= 1;
        }
        return n4;
    }

    private void GroupReOrder(int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        if (n <= n2) {
            n8 = n2 - n >> 12;
            n2 = n + n2 >> 1;
            n += n8;
        }
        int n9 = -1000;
        int n10 = 1000;
        int n11 = 1;
        for (n7 = 0; n7 < this.numCards; ++n7) {
            if ((n11 & n3) != 0) {
                if (this.score[n7] > n9) {
                    n9 = this.score[n7];
                }
                if (this.score[n7] < n10) {
                    n10 = this.score[n7];
                }
                this.UpdateScore(n7, 0, n4);
            }
            n11 <<= 1;
        }
        if (n9 == n10) {
            n5 = 990;
        }
        if ((n6 = ((n = (n * n5 + n9 * (1000 - n5)) / 1000) - (n2 = (n2 * n5 + n10 * (1000 - n5)) / 1000)) / 29) < 2) {
            n6 = 2;
        }
        n11 = 1;
        for (n7 = 0; n7 < this.numCards; ++n7) {
            if ((n11 & n3) != 0) {
                byte by = bl ? CardUtils.DecodeCardAH(this.hand[n7]) : CardUtils.DecodeCard(this.hand[n7]);
                n8 = bl2 ? n2 + (n - n2) * by / 13 : n - (n - n2) * by / 13;
                this.UpdateScore(n7, n8 += this.RandX(n6) - this.RandX(n6), 950);
            }
            n11 <<= 1;
        }
    }

    private void GroupUpdate(int n, int n2, boolean bl, int n3) {
        int n4 = 1;
        for (int i = 0; i < this.numCards; ++i) {
            if ((n4 & n2) != 0) {
                this.UpdateScore(i, n, n3);
            }
            n4 <<= 1;
        }
    }

    private void UpdateScore(int n, int n2, int n3) {
        if (n3 < 1) {
            n3 = 1;
        }
        if (n3 > 999) {
            n3 = 999;
        }
        this.score[n] = this.score[n] * (1000 - n3) + n2 * n3;
        int n4 = n;
        this.score[n4] = this.score[n4] / 1000;
        if (this.score[n] > 1000) {
            this.score[n] = 1000;
        }
        if (this.score[n] < -1000) {
            this.score[n] = -1000;
        }
    }

    private void PromoteScore(int n, int n2, int n3) {
        int n4 = -2000;
        this.UpdateScore(n, 1000, n2);
        n4 = this.score[n];
        n4 -= 10;
        n4 += 1000;
        n2 = n2 + 1000 >> 1;
        for (int i = 0; i < n3; ++i) {
            if (i == n || this.hand[i] == -1) continue;
            int n5 = (this.score[i] + 1000) * n4 / 2000 - 1000;
            this.UpdateScore(i, n5, n2);
        }
    }

    private void NormScore(int n, int n2) {
        int n3;
        int n4 = -1000;
        int n5 = 1000;
        for (n3 = 0; n3 < this.numCards; ++n3) {
            if (this.score[n3] >= 7999) continue;
            if (this.score[n3] > n4) {
                n4 = this.score[n3];
            }
            if (this.score[n3] >= n5) continue;
            n5 = this.score[n3];
        }
        if (n4 == n5) {
            return;
        }
        for (n3 = 0; n3 < this.numCards; ++n3) {
            if (this.score[n3] >= 7999) continue;
            int n6 = this.score[n3] - n5;
            n6 = n6 * (n - n2) / (n4 - n5);
            this.score[n3] = n6 + n2;
        }
    }

    private int GetHighestScore() {
        int n = -1;
        int n2 = -1001;
        for (int i = 0; i < this.numCards; ++i) {
            if (this.score[i] <= n2 || this.score[i] >= 7999) continue;
            n2 = this.score[i];
            n = i;
        }
        return n;
    }

    private int GetLowestScore() {
        int n = -1;
        int n2 = 1001;
        for (int i = 1; i < this.numCards; ++i) {
            if (this.score[i] >= n2) continue;
            n2 = this.score[i];
            n = i;
        }
        return n;
    }

    public byte GetHighestOfSuit(byte by, boolean bl) {
        return this.GetHighLowOfSuit(by, bl, true);
    }

    public byte GetLowestOfSuit(byte by, boolean bl) {
        return this.GetHighLowOfSuit(by, bl, false);
    }

    public byte GetHighLowOfSuit(byte by, boolean bl, boolean bl2) {
        byte by2 = -1;
        if (!bl2) {
            by2 = 14;
        }
        for (int n = 0; n < this.numCards; n = (int)((byte)(n + 1))) {
            if (this.hand[n] == -1 || by != -1 && CardUtils.DecodeSuit(this.hand[n]) != by || bl && !this.engineParent.IsLegalWhistCard(n, this.handRef, this.numCards, this.engineParent.trumpBroken ? -1 : 3)) continue;
            byte by3 = CardUtils.DecodeCardAH(this.hand[n]);
            if (bl2) {
                if (by3 <= by2) continue;
                by2 = by3;
                continue;
            }
            if (by3 >= by2) continue;
            by2 = by3;
        }
        return by2;
    }

    public int GetNumAboveSuit(byte by, byte by2) {
        int n = 0;
        for (int n2 = 0; n2 < this.numCards; n2 = (int)((byte)(n2 + 1))) {
            if (this.hand[n2] == -1 || CardUtils.DecodeSuit(this.hand[n2]) != by || CardUtils.DecodeCardAH(this.hand[n2]) <= by2) continue;
            ++n;
        }
        return n;
    }

    public int GetNumBelowSuit(byte by, byte by2) {
        int n = 0;
        for (int n2 = 0; n2 < this.numCards; n2 = (int)((byte)(n2 + 1))) {
            if (this.hand[n2] == -1 || CardUtils.DecodeSuit(this.hand[n2]) != by || CardUtils.DecodeCardAH(this.hand[n2]) >= by2) continue;
            ++n;
        }
        return n;
    }

    int DataClarity(int n, int n2, int n3) {
        if (this.RandX(100) < 11 - this.memory) {
            int n4;
            if ((n += (this.RandX(n4 = 8 + n * 3 + (n3 - n2)) - this.RandX(n4)) / (10 + this.memory)) > n3) {
                n = n3;
            }
            if (n < n2) {
                n = n2;
            }
        }
        return n;
    }

    private int GetHighestScoreWhist(boolean bl, boolean bl2, byte by) {
        int n;
        int n2;
        for (n2 = 0; n2 < 13; ++n2) {
            if (this.hand[n2] > -1) {
                if (this.score[n2] > 1125) {
                    this.score[n2] = 1125;
                }
                if (this.score[n2] >= -1125) continue;
                this.score[n2] = -1125;
                continue;
            }
            this.score[n2] = 99999;
        }
        int n3 = -1;
        boolean bl3 = true;
        do {
            n = this.GetHighestScore();
            n3 = CardUtils.FindInCards(this.hand[n], this.handRef, 13);
            int n4 = n;
            this.score[n4] = this.score[n4] + 9999;
            if (bl2) {
                bl3 = this.engineParent.IsLegalWhistCard(n3, this.handRef, 13, this.engineParent.trumpBroken ? -1 : (int)by);
                continue;
            }
            boolean bl4 = bl3 = this.hand[n] != -1;
        } while (!bl3);
        for (n2 = 0; n2 < 13; ++n2) {
            while (this.hand[n2] > -1 && this.score[n2] >= 8874) {
                int n5 = n2;
                this.score[n5] = this.score[n5] - 9999;
            }
        }
        if (bl) {
            return n3;
        }
        return n;
    }

    private void InitPlayCardWhist() {
        CardUtils.CountCardsNSuits(this.hand, 13, this.countCards, this.countSuits);
        this.leadSuit = this.engineParent.GetLeadSuitWhist();
        this.leadCard = this.engineParent.GetLeadCardWhist();
        byte by = -1;
        if (this.gameType == 2) {
            by = 0;
        }
        this.rankCap = this.engineParent.GetWinningPileCardWhist(by);
        this.suitCap = this.engineParent.GetWinningPileSuitWhist(by);
        this.trickWinner = this.engineParent.TrickWinnerWhist(by);
        this.playMode = this.engineParent.numInPile == 0 ? 0 : (this.countSuits[this.leadSuit] != 0 ? 1 : 2);
    }

    public void Hearts_PlayCard_Test() {
        switch (this.playerType) {
            case 101: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_ShootDef1(3);
                break;
            }
            case 102: {
                this.Hearts_Analyse_ShootOn(10, 0);
                if (this.objective == 1002) {
                    this.Hearts_Play_Shoot1(10);
                    break;
                }
                this.Hearts_Play_Basics(10);
                break;
            }
            case 103: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_ShootDef1(10);
                break;
            }
            case 104: {
                this.Hearts_Play_RiskCheck(10);
                break;
            }
            case 105: {
                this.Hearts_Play_Basics(9);
                this.Hearts_Play_TweakDucking(10);
                break;
            }
            case 106: {
                this.Hearts_Play_RiskCheck(10);
                this.Hearts_Play_TweakDucking(10);
                break;
            }
            case 107: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_TweakBlocking(10);
                break;
            }
            case 108: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_TweakFishing(10);
                break;
            }
            case 109: {
                this.Hearts_Analyse_ShootOn(10, 0);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(10);
                    break;
                }
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_TweakFishing(4);
                this.Hearts_Play_TweakExpert1(10);
                this.Hearts_Play_ShootDef1(10);
                break;
            }
            case 110: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_TweakExpert1(10);
                break;
            }
            case 200: {
                break;
            }
            case 201: {
                this.Whist_PlayRandom();
                break;
            }
        }
    }

    public int Hearts_PlayCard() {
        this.ResetScores(this.skillLevel);
        this.InitPlayCardWhist();
        this.gotQueenSpades = CardUtils.FindInCards(CafeCardsDefs.QUEEN_SPADES, this.hand, 13) >= 0;
        switch (this.playerType) {
            case 1: {
                this.Hearts_Analyse_ShootOn(4, -50);
                this.RandomiseScores(300);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(1 + this.skillLevel / 3);
                    if (this.RandX(11) >= this.skillLevel) break;
                    this.Hearts_Play_Basics(0);
                    break;
                }
                this.Hearts_Play_RiskCheck(5);
                this.Hearts_Play_Basics(1 + this.skillLevel / 3);
                break;
            }
            case 2: {
                this.Hearts_Play_Basics(4 + this.skillLevel / 3);
                this.Hearts_Play_TweakDucking(2);
                this.RandomiseScores(50);
                break;
            }
            case 3: {
                this.Hearts_Analyse_ShootOn(0, -100);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(1 + this.skillLevel / 3);
                    break;
                }
                this.Hearts_Play_Basics(2 + this.skillLevel / 3);
                this.Hearts_Play_TweakFishing(10);
                this.RandomiseScores(50);
                break;
            }
            case 4: {
                this.Hearts_Play_RiskCheck(6 + this.skillLevel / 4);
                this.Hearts_Play_TweakDucking(10);
                this.Hearts_Play_TweakFishing(8);
                this.Hearts_Play_TweakBlocking(7);
                this.Hearts_Play_TweakExpert1(3);
                break;
            }
            case 5: {
                this.Hearts_Play_RiskCheck(10);
                if (this.objective == 2) {
                    this.Hearts_Analyse_ShootOn(7, 100);
                }
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(5 + this.skillLevel / 4);
                    break;
                }
                this.Hearts_Play_Basics(8);
                this.Hearts_Play_TweakDucking(7);
                this.Hearts_Play_ShootDef1(7 + this.skillLevel / 4);
                this.Hearts_Play_TweakBlocking(1);
                break;
            }
            case 6: {
                this.Hearts_Analyse_ShootOn(7, -120);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(6 + this.skillLevel / 4);
                    break;
                }
                this.Hearts_Play_Basics(7);
                this.Hearts_Play_TweakFishing(8);
                this.Hearts_Play_ShootDef1(5 + this.skillLevel / 3);
                this.Hearts_Play_TweakBlocking(4);
                break;
            }
            case 7: {
                boolean bl = this.objective == 2;
                this.Hearts_Analyse_ShootOn(5, 50);
                if (!bl && this.objective == 2 && this.RandX(10) < 4) {
                    this.objective = 1;
                }
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(5 + this.skillLevel / 4);
                    break;
                }
                this.Hearts_Play_Basics(8);
                this.Hearts_Play_TweakBlocking(0);
                this.Hearts_Play_TweakFishing(7);
                this.Hearts_Play_TweakDucking(7);
                this.Hearts_Play_ShootDef1(3);
                break;
            }
            case 8: {
                this.Hearts_Analyse_ShootOn(7, 0);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(8);
                    break;
                }
                this.Hearts_Play_Basics(8 + this.skillLevel / 4);
                this.Hearts_Play_TweakFishing(0);
                this.Hearts_Play_TweakExpert1(2);
                this.Hearts_Play_TweakBlocking(6);
                break;
            }
            case 9: {
                this.Hearts_Analyse_ShootOn(7, -10);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(7);
                    break;
                }
                this.Hearts_Play_Basics(4 + this.skillLevel / 4);
                this.Hearts_Play_TweakDucking(6);
                this.Hearts_Play_TweakFishing(1);
                this.Hearts_Play_TweakExpert1(3);
                this.Hearts_Play_TweakBlocking(7);
                this.Hearts_Play_ShootDef1(8);
                break;
            }
            case 10: {
                this.Hearts_Analyse_ShootOn(8, 60);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(6);
                    break;
                }
                this.Hearts_Play_Basics(4 + this.skillLevel / 4);
                this.Hearts_Play_TweakFishing(0);
                this.Hearts_Play_TweakDucking(7);
                this.Hearts_Play_TweakExpert1(7);
                this.Hearts_Play_TweakBlocking(9);
                this.Hearts_Play_ShootDef1(7 + this.skillLevel / 4);
                break;
            }
            case 11: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Play_TweakFishing(5);
                this.Hearts_Play_TweakDucking(7);
                this.Hearts_Analyse_ShootOn(9, -20);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(10);
                    break;
                }
                this.Hearts_Play_TweakExpert1(8 + this.skillLevel / 4);
                this.Hearts_Play_ShootDef1(8);
                this.Hearts_Play_TweakBlocking(6);
                break;
            }
            case 12: {
                this.Hearts_Play_Basics(10);
                this.Hearts_Analyse_ShootOn(10, -40);
                if (this.objective == 2) {
                    this.Hearts_Play_Shoot1(10);
                    break;
                }
                this.Hearts_Play_TweakFishing(5);
                this.Hearts_Play_TweakDucking(6);
                this.Hearts_Play_TweakExpert1(10);
                this.Hearts_Play_TweakBlocking(6);
                this.Hearts_Play_ShootDef1(10);
                break;
            }
        }
        int n = this.GetHighestScoreWhist(true, true, (byte)3);
        return n;
    }

    public void Hearts_ChangeCard_Test() {
        switch (this.playerType) {
            case 101: {
                this.Hearts_Change_Basics(10);
                break;
            }
            case 102: {
                this.Hearts_Analyse_ShootOn(10, 0);
                if (this.objective == 2) {
                    this.Hearts_Change_Shoot1(10);
                    break;
                }
                this.Hearts_Change_Basics(10);
                break;
            }
            case 103: {
                this.Hearts_Change_Basics(10);
                this.Hearts_Change_ShootDef1(10);
                break;
            }
            case 104: {
                this.Hearts_Change_Basics(8);
                break;
            }
            case 105: {
                this.Hearts_Change_Basics(10);
                break;
            }
            case 106: {
                this.Hearts_Change_Basics(10);
                break;
            }
            case 107: {
                this.Hearts_Change_Basics(10);
                break;
            }
            case 108: {
                this.Hearts_Change_Basics(10);
                break;
            }
            case 109: {
                this.Hearts_Analyse_ShootOn(10, 0);
                if (this.objective == 2) {
                    this.Hearts_Change_Shoot1(10);
                    break;
                }
                this.Hearts_Change_Basics(10);
                this.Hearts_Change_ShootDef1(10);
                break;
            }
            case 110: {
                this.Hearts_Change_Basics(10);
                break;
            }
            case 200: {
                this.Hearts_Change_Test(10);
                break;
            }
        }
    }

    public int Hearts_ChangeCard() {
        int n = 0;
        this.ResetScores(this.skillLevel);
        this.objective = 0;
        CardUtils.CountCardsNSuits(this.hand, 13, this.countCards, this.countSuits);
        this.gotQueenSpades = CardUtils.FindInCards(CafeCardsDefs.QUEEN_SPADES, this.hand, 13) >= 0;
        switch (this.playerType) {
            case 1: {
                this.Hearts_Analyse_ShootOn(4, -80);
                if (this.objective == 2) {
                    this.Hearts_Change_Shoot1(1 + this.skillLevel / 3);
                } else {
                    this.Hearts_Change_Basics(1 + this.skillLevel / 3);
                }
                this.RandomiseScores(200);
                break;
            }
            case 2: {
                this.Hearts_Change_Basics(3 + this.skillLevel / 2);
                this.RandomiseScores(150);
                break;
            }
            case 3: {
                this.Hearts_Change_Basics(0 + this.skillLevel / 3);
                this.RandomiseScores(300);
                break;
            }
            case 4: {
                this.Hearts_Change_Basics(5 + this.skillLevel / 3);
                this.Hearts_Change_ShootDef1(1);
                break;
            }
            case 5: {
                this.Hearts_Change_Basics(7 + this.skillLevel / 5);
                this.Hearts_Change_ShootDef1(6 + this.skillLevel / 3);
                this.Hearts_Analyse_ShootOn(8, 120);
                if (this.objective != 2) break;
                this.Hearts_Change_Shoot1(4 + this.skillLevel / 3);
                break;
            }
            case 6: {
                this.Hearts_Analyse_ShootOn(5, -350);
                if (this.objective == 2) {
                    this.Hearts_Change_Shoot1(1 + this.skillLevel / 3);
                } else {
                    this.Hearts_Change_Basics(5 + this.skillLevel / 5);
                    this.Hearts_Change_ShootDef1(5 + this.skillLevel / 4);
                }
                this.RandomiseScores(90);
                break;
            }
            case 7: {
                this.Hearts_Change_Basics(7);
                this.Hearts_Change_ShootDef1(3);
                this.Hearts_Analyse_ShootOn(7 + this.skillLevel / 3, -30);
                if (this.objective != 2) break;
                this.Hearts_Change_Shoot1(6 + this.skillLevel / 3);
                break;
            }
            case 8: {
                this.Hearts_Change_Basics(5 + this.skillLevel / 3);
                this.Hearts_Analyse_ShootOn(7, -50);
                if (this.objective != 2) break;
                this.Hearts_Change_Shoot1(9);
                break;
            }
            case 9: {
                this.Hearts_Analyse_ShootOn(7, 0);
                if (this.objective == 2) {
                    this.Hearts_Change_Shoot1(7 + this.skillLevel / 3);
                    break;
                }
                this.Hearts_Change_Basics(6 + this.skillLevel / 5);
                this.Hearts_Change_ShootDef1(9);
                break;
            }
            case 10: {
                this.Hearts_Change_Basics(9 + this.skillLevel / 5);
                this.Hearts_Change_ShootDef1(9);
                break;
            }
            case 11: {
                this.Hearts_Change_Basics(9);
                this.Hearts_Analyse_ShootOn(8, 0);
                if (this.objective == 2) {
                    this.Hearts_Change_Shoot1(9);
                    break;
                }
                this.Hearts_Change_ShootDef1(8);
                break;
            }
            case 12: {
                this.Hearts_Change_Basics(10);
                this.Hearts_Change_ShootDef1(10);
                this.Hearts_Analyse_ShootOn(10, -50);
                if (this.objective != 2) break;
                this.Hearts_Change_Shoot1(10);
                break;
            }
        }
        n = 0;
        int n2 = 0;
        while (n2 < 3) {
            int n3 = this.GetHighestScore();
            int n4 = 1 << n3;
            if ((n4 & n) != 0) continue;
            n |= n4;
            ++n2;
            this.score[n3] = 9999;
        }
        return n;
    }

    private void Whist_PlayRandom() {
        for (int i = 0; i < 13; ++i) {
            this.score[i] = this.RandX(1000);
        }
    }

    private void Hearts_Change_Basics(int n) {
        byte by;
        int n2;
        int n3;
        byte by2;
        int n4 = 100 + n * 70;
        byte by3 = -1;
        int n5 = n * this.RandX(5);
        for (by2 = 0; by2 < 4; by2 = (byte)(by2 + 1)) {
            if (this.countSuits[by2] != 3) continue;
            n3 = this.GetHighestOfSuit(by2, false) * 10;
            if (by2 == 0 && (n3 += this.RandX(30) - 15) < 80) {
                n3 = -n * 10;
            }
            if (by2 == 3) {
                n3 += 15;
            }
            if (by2 == 2) {
                n3 += 5;
            }
            for (n2 = 0; n2 < this.numCards; ++n2) {
                by = this.hand[n2];
                if (by2 != CardUtils.DecodeSuit(by)) continue;
                n3 += CardUtils.DecodeCardAH(by);
            }
            if (n3 <= n5) continue;
            n5 = n3;
            by3 = by2;
        }
        for (n2 = 0; n2 < this.numCards; ++n2) {
            by = this.hand[n2];
            if (by == -1) continue;
            n5 = CardUtils.DecodeCardAH(by);
            by2 = CardUtils.DecodeSuit(by);
            if (by == CafeCardsDefs.QUEEN_SPADES) {
                this.UpdateScore(n2, 1000, n4 + 1000 >> 1);
                continue;
            }
            if (by2 == 3) {
                n3 = n5 * 1000 / 13;
                n3 = n3 * 3 + 1000 >> 2;
            } else {
                n3 = by2 == 0 ? (n5 > 11 ? 900 + 100 * (n5 - 11) : 800 - (n + 5) * 1000 / 15 * (11 - n5)) : (n5 - 4 - (10 - n >> 1)) * 875 / 9;
            }
            if (by3 > -1) {
                n3 = by3 == by2 ? 1000 + n3 >> 1 : n3 - 1000 >> 1;
            } else if (this.RandX(9) < n && this.countSuits[by2] <= 3 && !this.gotQueenSpades && by2 != 0) {
                int n6 = 4 - this.countSuits[by2];
                n3 = (n3 + 1000 * n6 + n5 * 76) / (2 + n6);
                if (by2 == 2 && n > 6) {
                    n3 = 1000 + n3 * 7 >> 3;
                }
            }
            this.UpdateScore(n2, n3, n4);
        }
    }

    private void Hearts_Play_Basics(int n) {
        int n2;
        boolean bl;
        int n3;
        byte by;
        int n4 = 100 + n * 80;
        boolean bl2 = this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this);
        int n5 = this.GetGroupMask(-1, 0, 13, true);
        if (this.playMode == 0) {
            for (by = 0; by < 4; by = (byte)(by + 1)) {
                n5 = this.GetGroupMask(by, 0, 13, true);
                n3 = this.engineParent.GetNumSuitPlayed(by, this);
                bl = this.engineParent.currentRound < 5 && n3 < 6;
                n2 = 850;
                if (this.gotQueenSpades) {
                    if (by == 0) {
                        bl = n3 < 3;
                        n2 = 1000;
                        if (this.rankPlayer > 7 && this.engineParent.heartsQSPenalty > 13) {
                            n2 = -1000;
                        }
                    } else {
                        n2 = 0 + this.rankPlayer * 50;
                    }
                }
                if (by == 3) {
                    bl = false;
                    n2 = 1000 - (1000 - n4 >> 3);
                }
                this.GroupReOrder(n2, -500, n5, true, bl, n4, n4);
            }
        } else if (this.playMode == 2) {
            this.GroupReOrder(950, -900, n5, true, true, n4, n4);
        } else {
            n3 = this.engineParent.GetNumSuitPlayed(this.leadSuit, this);
            bl = this.engineParent.currentRound < 7 && n3 < 9 && this.leadSuit != 3;
            int n6 = this.engineParent.GetNumSuitInPile((byte)3);
            if (n6 > 0) {
                bl = false;
            }
            if (bl) {
                this.GroupReOrder(900, -600, n5, true, bl, n4, n4);
            } else {
                n5 = this.GetGroupMask(-1, 0, this.rankCap, true);
                this.GroupReOrder(900, 0, n5, true, true, n4, n4);
                n5 = this.GetGroupMask(-1, this.rankCap, 13, true);
                bl = this.engineParent.numInPile == 3;
                this.GroupReOrder(0, -1000, n5, true, bl, n4, n4);
            }
        }
        for (int i = 0; i < this.numCards; ++i) {
            byte by2 = this.hand[i];
            if (by2 == -1) continue;
            byte by3 = CardUtils.DecodeCardAH(by2);
            by = CardUtils.DecodeSuit(by2);
            if (this.playMode == 0) {
                n3 = this.engineParent.GetNumSuitPlayed(by, this);
                if (by2 == CafeCardsDefs.QUEEN_SPADES) {
                    if (n3 > 8 && this.GetHighestOfSuit((byte)0, false) == 11 && this.engineParent.GetNumSuitPlayedAbove((byte)0, (byte)11, this) < 2) {
                        this.UpdateScore(i, 1000, 450 - n * 15);
                        continue;
                    }
                    this.UpdateScore(i, -1000, n4 + 1000 >> 1);
                    continue;
                }
                if (by == 0 && !bl2) {
                    if (this.gotQueenSpades) continue;
                    if (by3 > 11) {
                        this.UpdateScore(i, -1000, n4);
                        continue;
                    }
                    if (this.countSuits[0] < 2) {
                        this.UpdateScore(i, 1000, n4 >> 3);
                        continue;
                    }
                    if (by3 >= 7) continue;
                    this.UpdateScore(i, -1000, n4 >> 3);
                    continue;
                }
                if (this.countSuits[by] > 4) continue;
                n2 = this.countSuits[by];
                n2 = (900 + 10 * by3 - n2 * n2 * n2 * 15) * n4 / 1000;
                if (by == 3) {
                    n2 -= 40 + by3 * 25;
                }
                n2 = n2 * 40 / (40 + this.engineParent.currentRound);
                this.UpdateScore(i, 1000, n2);
                continue;
            }
            if (this.playMode == 2) {
                if (this.countSuits[by] < 4) {
                    n2 = n4 * 2 / (5 + this.countSuits[by]);
                    n2 = n2 * 6 / (6 + this.engineParent.currentRound);
                    this.UpdateScore(i, 950, n2);
                }
                if (by2 == CafeCardsDefs.QUEEN_SPADES) {
                    this.UpdateScore(i, 1000, n4 + 3000 >> 2);
                    continue;
                }
                if (by == 3) {
                    n2 = (850 + by3 * 10) * by3 / this.GetHighestOfSuit((byte)3, false);
                    this.UpdateScore(i, n2, n4);
                    continue;
                }
                if (this.gotQueenSpades || by != 0 || by3 <= 11) continue;
                this.UpdateScore(i, 1000, n4 + 3000 >> 2);
                continue;
            }
            if (by != this.leadSuit) {
                this.UpdateScore(i, -1000, 900);
                continue;
            }
            if (by == 0) {
                if (by3 == 11) {
                    n2 = this.rankCap > 11 ? 1000 : -1000;
                    this.UpdateScore(i, n2, n4 + 6600 >> 3);
                } else if (!this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this) && by3 > 11 && this.engineParent.numInPile == 3) {
                    this.UpdateScore(i, 1000, n4 + 850 >> 1);
                } else if (by3 > 11) {
                    this.UpdateScore(i, -1000, n4 + 800 >> 1);
                }
            }
            if (!this.engineParent.GetCardInPile(CafeCardsDefs.QUEEN_SPADES) || by3 <= this.rankCap || this.GetLowestOfSuit(by, false) >= this.rankCap) continue;
            n2 = (n4 >> 1) + 500 * by3 / 13;
            this.UpdateScore(i, -1000, n2);
        }
    }

    private void Hearts_Play_RiskCheck(int n) {
        byte by;
        int n2;
        int n3;
        int n4 = 100 + n * 80;
        int n5 = 100 + n * 50;
        byte[] byArray = this.engineParent.pile;
        int n6 = 0;
        for (n3 = 0; n3 < 4; n3 = (int)((byte)(n3 + 1))) {
            if (this.countSuits[n3] <= n6) continue;
            n6 = this.countSuits[n3];
        }
        int n7 = this.GetGroupMask(2, 0, 13, true);
        int n8 = -1000;
        if (this.countSuits[2] == 1) {
            n8 = 0;
        }
        int n9 = 1000 - (n6 - this.countSuits[2]) * 50 - this.RandX(100);
        this.GroupReOrder(n9, n8, n7, true, false, n5, n4);
        n7 = this.GetGroupMask(1, 0, 13, true);
        n8 = -1000;
        if (this.countSuits[1] == 1) {
            n8 = 0;
        }
        n9 = 1000 - (n6 - this.countSuits[1]) * 50;
        this.GroupReOrder(n9, n8, n7, true, false, n5, n4);
        n7 = this.GetGroupMask(3, 0, 13, true);
        n9 = this.countSuits[3];
        n9 = 820 - n9 * n9 * (n + 7);
        n8 = -1000;
        if (this.playMode == 0) {
            int n10 = 0;
            for (n2 = 0; n2 < 4; ++n2) {
                if (n2 == this.meInRef || !this.engineParent.GetSuitEmptyWhistPlayer((byte)3, n2, this)) continue;
                n9 -= 50;
                ++n10;
            }
            if (n > 6 && n10 == 3) {
                n9 -= 100;
            }
            if (this.engineParent.GetNumSuitPlayedAbove((byte)3, by = this.GetLowestOfSuit((byte)3, false), this) < 13 - by - this.GetNumAboveSuit((byte)3, by)) {
                n9 = 1000;
                n8 = n * 1000 / 18;
            }
        }
        this.GroupReOrder(n9, n8, n7, true, false, n5, n4);
        n7 = this.GetGroupMask(0, 0, 13, true);
        n9 = 600;
        if (this.gotQueenSpades) {
            n9 = this.countSuits[0] > 3 && n > 7 ? 1000 : 0;
        }
        if (!this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this)) {
            n9 = this.countSuits[0] * (10 + n * 7);
            if (this.GetLowestOfSuit((byte)0, false) < 11) {
                n9 = n9 * 3 >> 1;
            }
        } else {
            n9 = 1000 - (n6 - this.countSuits[0]) * 70;
        }
        this.GroupReOrder(n9, -1000, n7, true, false, n5, n4);
        if (this.playMode == 0) {
            return;
        }
        int n11 = 0;
        if (this.playMode == 1 && this.GetHighestOfSuit(this.leadSuit, true) > this.rankCap && this.GetLowestOfSuit(this.leadSuit, true) < this.rankCap + (4 - this.engineParent.numInPile) * 2) {
            n11 = this.engineParent.GetHeartsPointsMatch() + 100 >> 1;
            n11 = 100 + (180 + n * 5) * this.engineParent.pointsMatch[this.meInRef] / n11 + this.engineParent.currentRound * 18;
            for (n2 = 0; n2 < 4; ++n2) {
                if (n2 == this.meInRef) continue;
                by = byArray[n2];
                if (by < 0) {
                    boolean bl = this.engineParent.GetSuitEmptyWhistPlayer(this.leadSuit, n2, this);
                    if (!this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this) && ((bl |= this.engineParent.GetNumSuitPlayedBy(n2, this.leadSuit, this) > 2 + this.RandX(3)) || this.leadSuit == 0)) {
                        n11 += 250;
                    }
                    if (this.leadSuit != 3 && !bl) continue;
                    n11 += 30;
                    n9 = 160 - this.engineParent.GetNumSuitPlayedBy(n2, (byte)3, this) * 12;
                    if (n9 <= 0) continue;
                    n11 += n9;
                    continue;
                }
                byte by2 = CardUtils.DecodeCardAH(by);
                n3 = CardUtils.DecodeSuit(by);
                n11 += (13 - by2) * 20;
                if (by == CafeCardsDefs.QUEEN_SPADES) {
                    n11 += 1000;
                }
                if (CardUtils.DecodeSuit(by) != 3) continue;
                n11 += 200 + this.RandX(20 * n + 80);
            }
        }
        if (n11 <= 0 || this.RandX(n11) < 100) {
            n7 = this.GetGroupMask(-1, 0, 13, true);
            this.GroupReOrder(1000, -1000, n7, true, true, n5, 10);
        } else if (this.playMode == 1) {
            n7 = this.GetGroupMask(this.leadSuit, 0, this.rankCap, true);
            this.GroupReOrder(1000, 0, n7, true, true, n5, n4);
        }
        if (n11 < 70 - n) {
            if (this.gotQueenSpades) {
                n7 = this.GetGroupMask(0, 11, 11, true);
                this.GroupUpdate(1000, n7, true, n4);
            } else if (this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this)) {
                n7 = this.GetGroupMask(3, 0, 13, true);
                this.GroupReOrder(1000, 333, n7, true, true, n5, n4);
            }
        }
    }

    private void Hearts_Analyse_ShootOn(int n, int n2) {
        int n3;
        byte by;
        int n4;
        byte by2;
        if (this.engineParent.heartsShootBonus <= 0) {
            this.objective = 1;
            return;
        }
        int n5 = this.engineParent.GetNumSuitPlayed((byte)3, this) - this.engineParent.GetNumSuitInPile((byte)3);
        if (this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this) && !this.engineParent.GetCardInPile(CafeCardsDefs.QUEEN_SPADES)) {
            n5 += this.engineParent.heartsQSPenalty;
        }
        if (this.engineParent.pointsGame[this.meInRef] != n5 && (n > 3 || this.objective != 2 || this.RandX(100) < n * 10 + 60)) {
            this.objective = 1;
            return;
        }
        if (this.RandX(100) < 90 + n) {
            int n6;
            int by22 = 1000;
            by2 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                if (this.engineParent.pointsMatch[n4] + this.engineParent.heartsShootBonus > this.engineParent.heartsPointsMatch - n) {
                    by2 = 1;
                }
                if (this.engineParent.pointsMatch[n4] >= n6) continue;
                n6 = this.engineParent.pointsMatch[n4];
            }
            if (by2 != 0 && n6 != this.engineParent.pointsMatch[this.meInRef]) {
                this.objective = 1;
                return;
            }
        }
        n4 = (3 + this.rankPlayer) * n5 / (13 + this.engineParent.heartsQSPenalty) + (10 - this.rankPlayer);
        n4 = this.objective != 2 ? n5 * (15 + (n >> 1) + n4 * 7 - this.engineParent.currentRound) : n5 * (38 + (n >> 1) + n4 * 3 - this.engineParent.currentRound * 2);
        byte by3 = -1;
        int n7 = -1;
        boolean bl = false;
        while (by < 4) {
            if (this.countSuits[by] > 5 * (13 - this.engineParent.currentRound) / 7) {
                n3 = this.GetHighestOfSuit(by, false);
                n4 += 160 + n3 * n3;
                n4 += (this.countSuits[by] + this.engineParent.currentRound - 10) * 45;
                if (n3 >= this.engineParent.GetHighestNotPlayedOfSuit(by, this)) {
                    n4 += 80;
                }
                if (by == 3) {
                    n4 += 60;
                }
                if (n > 6 && this.countSuits[by] > n7) {
                    n7 = this.countSuits[by];
                    by3 = by;
                }
            }
            by = (byte)(by + true);
        }
        int n8 = (1200 + n * 35 - n4) / (16 - this.engineParent.currentRound);
        if (n8 < 100) {
            n8 = 100;
        }
        for (n3 = 0; n3 < this.numCards; ++n3) {
            by2 = CardUtils.DecodeCardAH(this.hand[n3]);
            byte by4 = CardUtils.DecodeSuit(this.hand[n3]);
            int n9 = 0;
            if (by2 > 8) {
                if (by4 == 3) {
                    n9 += 2;
                }
                if (by2 == 13 && CardUtils.DecodeSuit(this.hand[n3]) == 2 && this.engineParent.currentRound <= 1) {
                    n9 += 5;
                }
                n4 += n8 * (1 + by2 + n9) / 13;
                continue;
            }
            if (by4 != by3 || by2 <= -1) continue;
            n4 -= (8 - by2) * 7 + 30;
        }
        if (this.gotQueenSpades) {
            n4 += 170;
            if (this.engineParent.GetHighestNotPlayedOfSuit((byte)0, this) <= 11) {
                n4 += 50;
            }
        } else {
            n3 = this.GetNumAboveSuit((byte)0, (byte)11);
            n4 += 3 * n3 * n;
        }
        if ((n3 = this.GetNumAboveSuit((byte)3, (byte)9)) >= 13 - this.engineParent.currentRound >> 2) {
            n4 += (200 + n3 * n3 * 25 + n * n3 * 50) / (8 + this.engineParent.currentRound - n3);
        }
        if (n > 10) {
            n = 10;
        }
        int n10 = 250 - n * 20;
        n3 = (n4 += this.RandX(n10) - this.RandX(n10)) * this.engineParent.heartsShootBonus / (13 + this.engineParent.heartsQSPenalty);
        n4 = n4 * 7 + n3 >> 3;
        n3 = 13 * n4 / (1 + this.engineParent.heartsQSPenalty);
        n4 = (n4 * 15 + n3 * n) / (15 + n);
        if ((n4 -= n2) > 1000 || n4 > 800 && this.objective == 2) {
            if (this.objective != 2) {
                this.FilterEmoticon(7, 50);
                this.FilterEmoticon(6, 70);
            }
            this.objective = 2;
            return;
        }
        if (this.objective == 2) {
            this.FilterEmoticon(4, 50);
        }
        this.objective = 1;
    }

    private void Hearts_Change_Shoot1(int n) {
        int n2 = 300 + n * 50;
        for (int i = 0; i < this.numCards; ++i) {
            byte by = this.hand[i];
            if (by == -1) continue;
            byte by2 = CardUtils.DecodeCardAH(by);
            byte by3 = CardUtils.DecodeSuit(by);
            int n3 = this.countSuits[by3];
            int n4 = 1000 - by2 * 2 * 1000 / 13;
            n4 = (n4 * 19 + (13 - n3) * 1000) / 32;
            if (by == CafeCardsDefs.QUEEN_SPADES) {
                n4 = n4 - 7000 >> 3;
            }
            if (by3 == 3) {
                int n5 = -1000;
                if (n > 5) {
                    n5 = 1000 - by2 * by2 * 2000 / 169;
                }
                n4 = n4 + n5 >> 1;
            }
            if (by3 == 2 && this.GetHighestOfSuit((byte)2, false) == by2) {
                n4 = n4 - 1000 >> 1;
            }
            if (!this.gotQueenSpades && by3 == 0 && by2 > 11) {
                n4 = n4 - 7000 >> 3;
            }
            if (this.countSuits[by3] <= 3 && n4 > 0) {
                n4 = n4 * 7 + 1000 >> 3;
            }
            if (by3 == 0 && by2 == 11 && n < 4 && this.RandX(8) > n) {
                n4 = -1000;
            }
            this.UpdateScore(i, n4, n2);
        }
        this.FilterEmoticon(6, 80);
        this.FilterEmoticon(8, 30);
    }

    private void Hearts_Play_Shoot1(int n) {
        int n2 = 150 + n * 60;
        int n3 = 50 + n * 50;
        int n4 = this.GetGroupMask(-1, 0, 13, true);
        if (this.playMode == 2) {
            this.GroupReOrder(900, 0, n4, true, false, n3, n2);
            n4 = this.GetGroupMask(3, 0, 13, true);
            this.GroupReOrder(0, -1000, n4, true, false, n3, n2);
            n4 = this.GetGroupMask(0, 11, 11, true);
            this.GroupUpdate(-1000, n4, true, n2 + 1000 >> 1);
            return;
        }
        this.GroupReOrder(900, 0, n4, true, true, n3, n2);
        for (int i = 0; i < this.numCards; ++i) {
            int n5;
            byte by = this.hand[i];
            if (by == -1) continue;
            byte by2 = CardUtils.DecodeCardAH(by);
            byte by3 = CardUtils.DecodeSuit(by);
            int n6 = this.GetNumAboveSuit(by3, by2) + this.engineParent.GetNumSuitPlayedAbove(by3, by2, this);
            n6 = 13 - by2 - n6;
            if (this.playMode == 0) {
                if (by == CafeCardsDefs.QUEEN_SPADES) {
                    if (n6 == 0) {
                        this.UpdateScore(i, 1000, n2);
                        continue;
                    }
                    n5 = 70 + n * 15 * n6;
                    n5 = n5 * (this.engineParent.pointsGame[this.meInRef] + 10) / 20;
                    n5 = n5 * (this.engineParent.GetNumSuitPlayed((byte)0, this) + 10) / 20;
                    this.UpdateScore(i, -1000, n5);
                    continue;
                }
                if (by3 == 0 && by2 > 11 && !this.gotQueenSpades) {
                    n5 = 20 + n * 25;
                    n5 = n5 * (this.engineParent.pointsGame[this.meInRef] + 10) / 20;
                    n5 = n5 * (this.engineParent.GetNumSuitPlayed((byte)0, this) + 10) / 20;
                    n5 = n5 * (18 - this.engineParent.currentRound) / 18;
                    this.UpdateScore(i, -1000, n5);
                    continue;
                }
                if (n6 <= 0) continue;
                this.UpdateScore(i, -1000, 30 + n6 * 20);
                continue;
            }
            if (this.playMode != 1) continue;
            n5 = this.score[i];
            if (this.engineParent.GetNumSuitInPile((byte)3) > 0 || this.engineParent.GetCardInPile(CafeCardsDefs.QUEEN_SPADES)) {
                if (by3 == this.leadSuit && by2 > this.rankCap) {
                    n5 = 500 + by2 * 500 / 13;
                }
            } else if (by3 == 0 && this.gotQueenSpades) {
                n5 = -1000;
                if (this.engineParent.numInPile == 3 && this.rankCap < 11) {
                    n5 = 1000;
                } else if (n6 == 0) {
                    n5 = 1000;
                } else {
                    n5 = 1000 - 200 * n6;
                    n5 -= this.engineParent.pointsGame[this.meInRef] * 15;
                    n5 -= this.engineParent.GetNumSuitPlayed((byte)0, this) * 15;
                }
            } else if (by2 > this.rankCap && by3 == this.leadSuit) {
                n5 = by2 * 1000 / 52;
                n5 = this.engineParent.numInPile == 3 || n6 == 0 ? 1000 - n5 : (n5 += 750);
            } else {
                n5 = 1000 - by2 * 1000 / 13;
            }
            this.UpdateScore(i, n5, n2);
        }
    }

    private void Hearts_Change_ShootDef1(int n) {
        int n2 = this.RandX(50 + n * 20);
        int n3 = this.GetGroupMask(3, 0, 13, true);
        this.GroupReOrder(1000, -1000, n3, true, true, 0, n2);
        n2 = this.RandX(n2 + n * 15);
        n3 = this.GetGroupMask(3, 0, 10, true);
        this.GroupReOrder(900, -1000, n3, true, true, 0, n2);
        for (int i = 0; i < this.numCards; ++i) {
            byte by = CardUtils.DecodeCardAH(this.hand[i]);
            byte by2 = CardUtils.DecodeSuit(this.hand[i]);
            if (by2 == 3 && by == this.GetHighestOfSuit((byte)3, false)) {
                n2 = 100 + n * 30 + this.RandX(300);
                this.UpdateScore(i, -1000, n2);
            }
            if (by2 != 0 || by <= 11) continue;
            n2 = 5;
            if (this.countSuits[0] > 3) {
                n2 += 8;
            }
            if (this.gotQueenSpades) {
                n2 >>= 1;
            }
            if (n2 <= 0) continue;
            n2 = this.RandX(n2 * n);
            this.UpdateScore(i, -1000, n2);
        }
    }

    private void Hearts_Play_ShootDef1(int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        if (this.engineParent.pointsGame[this.meInRef] > 0) {
            return;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.engineParent.pointsGame[n2] == 0) {
                ++n3;
                continue;
            }
            if (this.engineParent.pointsGame[n2] <= n4) continue;
            n4 = this.engineParent.pointsGame[n2];
            n5 = n2;
        }
        if (n3 < 3) {
            return;
        }
        int n6 = 100 + n * 15 + this.RandX(200 + n * 30);
        this.FilterEmoticon(8, 10);
        int n7 = this.GetGroupMask(-1, 0, 13, true);
        this.GroupUpdate(-1000, n7, true, n6 >> 2);
        n7 = this.GetGroupMask(3, 0, 13, true);
        if (n4 > 7 && n4 < 13 || n4 > 17) {
            if (this.playMode == 1 && this.leadSuit == 3 && this.GetHighestOfSuit((byte)3, false) < this.rankCap && n5 == this.trickWinner) {
                this.GroupReOrder(1000, 0, n7, true, false, 0, n6);
            } else if (this.playMode == 2 && this.leadSuit != 3) {
                if (n5 == this.trickWinner || this.engineParent.pile[n5] == -1) {
                    this.GroupReOrder(-666, -1000, n7, true, false, n6, n6);
                } else {
                    this.GroupReOrder(1000, 500, n7, true, true, n6, n6);
                }
            } else {
                this.GroupReOrder(1000, 0, n7, true, true, n6, n6);
            }
        }
        if (this.leadSuit == 0 && (n5 == this.trickWinner || n3 == 4) && this.rankCap > 11 && this.gotQueenSpades) {
            n7 = this.GetGroupMask(0, 11, 11, true);
            this.GroupUpdate(-1000, n7, true, n6);
        }
        for (n2 = 0; n2 < this.numCards; ++n2) {
            byte by = this.hand[n2];
            if (by == -1) continue;
            byte by2 = CardUtils.DecodeCardAH(by);
            byte by3 = CardUtils.DecodeSuit(by);
            if ((n4 <= 7 || n4 >= 13) && n4 <= 17) continue;
            int n8 = 0;
            if (by2 > this.rankCap && by3 == this.leadSuit) {
                if (this.leadSuit == 3 && (n5 == this.trickWinner || this.engineParent.pile[n5] == -1)) {
                    if (by2 == this.engineParent.GetHighestNotPlayedOfSuit((byte)3, this)) {
                        n8 = 200 + n * 60;
                    }
                } else if (this.leadSuit != 3 && this.leadSuit != 0) {
                    n8 = 200 + n * 60;
                }
            }
            if (n8 <= 0) continue;
            n8 = n6 * n8 / 1000;
            n8 = n4 * n8 / 20;
            if (this.engineParent.heartsQSPenalty > 13) {
                n8 = 23 * n8 / (10 + this.engineParent.heartsQSPenalty);
            }
            this.UpdateScore(n2, 1000, n8);
        }
    }

    private void Hearts_Play_TweakDucking(int n) {
        int n2 = 150 + n * 80;
        int n3 = this.GetHighestScoreWhist(false, true, (byte)3);
        byte by = this.hand[n3];
        byte by2 = CardUtils.DecodeCardAH(by);
        byte by3 = CardUtils.DecodeSuit(by);
        if (by == CafeCardsDefs.QUEEN_SPADES) {
            return;
        }
        int n4 = -1;
        if (this.playMode == 0) {
            return;
        }
        if (this.playMode == 1) {
            if (by2 > this.rankCap) {
                n4 = 13;
                if (this.leadSuit == 0 && !this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this)) {
                    n4 = 10;
                }
                if (this.leadSuit == 3) {
                    n4 = this.rankCap - 1;
                }
            } else {
                n4 = this.rankCap - 1;
                this.FilterEmoticon(6, 30);
            }
        } else {
            n4 = this.GetHighestOfSuit(by3, false);
        }
        if (n4 > -1) {
            int n5 = this.GetGroupMask(-1, 0, 13, true);
            this.GroupUpdate(-1000, n5, true, n2 >> 1);
            n5 = this.GetGroupMask(by3, 0, n4, true);
            this.GroupReOrder(14000 / (1 + n4), 0, n5, true, true, 0, n2);
        }
    }

    private void Hearts_Play_TweakBlocking(int n) {
        int n2 = 150 + n * 80;
        int n3 = (20 + n) / 3;
        int n4 = this.GetHighestScoreWhist(false, true, (byte)3);
        byte by = this.hand[n4];
        byte by2 = CardUtils.DecodeCardAH(by);
        byte by3 = CardUtils.DecodeSuit(by);
        int n5 = this.engineParent.GetBlackBoard(4 + this.meInRef);
        if (this.leadSuit == 0 && !this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this)) {
            byte by4 = this.GetHighestOfSuit((byte)0, false);
            if (!(by4 <= 11 || by4 <= by2 || by2 == 11 || by2 < 11 && this.gotQueenSpades)) {
                boolean bl = this.engineParent.GetCardBlocked(CafeCardsDefs.QUEEN_SPADES, this.meInRef, this);
                int n6 = this.meInRef + 1;
                if (n6 == 4) {
                    n6 = 0;
                }
                if (bl |= this.engineParent.numInPile == 2 && n5 == n6 && !this.engineParent.GetCardWasPassed(CafeCardsDefs.QUEEN_SPADES, this.meInRef, this)) {
                    int n7 = this.GetGroupMask(-1, 0, 13, true);
                    this.GroupUpdate(-1000, n7, true, n2 >> 2);
                    n7 = this.GetGroupMask(0, by4, by4, true);
                    this.GroupUpdate(1000, n7, true, n2);
                }
            }
        } else if (this.engineParent.numInPile == 0 || by3 != this.engineParent.GetLeadSuitWhist()) {
            int n8;
            int n9 = 0;
            for (n8 = 0; n8 < 4; ++n8) {
                if (n8 == this.meInRef || !this.engineParent.GetSuitEmptyWhistPlayer(by3, n8, this)) continue;
                n9 += 190 + (n9 >> 1) - this.engineParent.currentRound * 3;
            }
            if (n9 > 0) {
                int n10 = -1;
                int n11 = 0;
                for (byte by5 = 0; by5 < 4; by5 = (byte)(by5 + 1)) {
                    if (by5 == by3 || by5 == 3) continue;
                    int n12 = -this.countSuits[by5] * 4;
                    for (n8 = 0; n8 < 4; ++n8) {
                        if (n8 == this.meInRef || this.engineParent.GetSuitEmptyWhistPlayer(by5, n8, this) || this.countSuits[by5] <= 0) continue;
                        n12 += 220;
                    }
                    if (n12 <= n11) continue;
                    n11 = n12;
                    n10 = by5;
                }
                if (n10 != -1) {
                    if ((n9 = (n9 + n11) * n2 / 1700) > 800) {
                        n9 = 800 + (n9 - 800) >> 4;
                    }
                    int n13 = this.GetGroupMask(by3, 0, 13, true);
                    this.GroupUpdate(-1000, n13, true, n9);
                    n13 = this.GetGroupMask(n10, 0, 13, true);
                    this.GroupUpdate(1000, n13, true, n9);
                }
            }
        }
    }

    private void Hearts_Play_TweakExpert1(int n) {
        int n2;
        byte by;
        int n3;
        boolean bl;
        int n4 = 150 + n * 80;
        int n5 = this.GetHighestScoreWhist(false, true, (byte)3);
        byte by2 = this.hand[n5];
        byte by3 = CardUtils.DecodeCardAH(by2);
        byte by4 = CardUtils.DecodeSuit(by2);
        int n6 = this.engineParent.GetBlackBoard(4 + this.meInRef);
        int n7 = 0;
        do {
            bl = false;
            if (this.engineParent.currentRound > 3 && by4 == this.leadSuit && by3 > this.rankCap) {
                n3 = 80;
                for (by = 0; by < 4; by = (byte)(by + 1)) {
                    n2 = this.engineParent.GetHighestNotPlayedOfSuit(by, this) - 2;
                    if ((n2 = this.GetNumBelowSuit(by, (byte)n2)) <= 0 || by == by4) continue;
                    n3 /= 1 + n2;
                }
                if (n3 > 20) {
                    n3 = n3 * n4 / 1000;
                    this.UpdateScore(n5, -1000, n3);
                    bl = true;
                }
            }
            n5 = this.GetHighestScoreWhist(false, true, (byte)3);
            by2 = this.hand[n5];
            by3 = CardUtils.DecodeCardAH(by2);
            by4 = CardUtils.DecodeSuit(by2);
        } while (n7++ < 5 && bl);
        if (this.engineParent.currentRound > 6 && this.countSuits[by4] == 1) {
            n3 = 50;
            boolean bl2 = false;
            for (by = 0; by < 4; by = (byte)(by + 1)) {
                if (this.countSuits[by] <= 1) continue;
                bl2 = true;
                n3 += this.countSuits[by] * 15;
            }
            if (bl2) {
                n3 /= 8 + by3;
                n3 = n3 * n4 / 1000;
                this.UpdateScore(n5, -1000, n3);
            }
        }
        if (this.engineParent.numInPile == 0) {
            for (int i = 0; i < 4; ++i) {
                if (i == this.meInRef) continue;
                int n8 = this.engineParent.GetBlackBoard(4 + i);
                for (by = 0; by < 4; by = (byte)(by + 1)) {
                    int n9;
                    n3 = -90;
                    if (this.meInRef == n8) {
                        n2 = 0;
                        for (n9 = 0; n9 < 3; ++n9) {
                            if (CardUtils.DecodeSuit(this.engineParent.changeHand[i][n9]) != by) continue;
                            byte by5 = CardUtils.DecodeCardAH(this.engineParent.changeHand[i][n9]);
                            n2 += n2 + 40 + (13 - by5) * 110;
                        }
                        n3 += n2;
                    }
                    int n10 = 0;
                    if (n3 > 0) {
                        n10 = n3;
                    }
                    if ((n2 = this.engineParent.GetNumSuitPlayedBelowBy(i, by, (byte)7, this)) > 0) {
                        n3 += 100 + n2 * 330 + (n10 >> 2);
                    }
                    n3 /= 8 + this.engineParent.currentRound;
                    n3 = n3 * n4 / 1000;
                    for (n9 = 0; n9 < 13; ++n9) {
                        n2 = CardUtils.DecodeSuit(this.hand[n9]);
                        if (n2 != by) continue;
                        if (n3 > 0) {
                            this.UpdateScore(n9, -1000, n3);
                            continue;
                        }
                        this.UpdateScore(n9, 1000, -n3);
                    }
                }
            }
        }
    }

    private void Hearts_Play_TweakFishing(int n) {
        if (this.playMode != 0) {
            return;
        }
        int n2 = 50 + n * 90;
        boolean bl = this.gotQueenSpades && this.countSuits[0] > 2;
        bl |= this.countSuits[0] > 3 + this.RandX(2);
        bl &= !this.engineParent.GetCardPlayed(CafeCardsDefs.QUEEN_SPADES, this);
        bl &= this.engineParent.GetNumSuitPlayedBelow((byte)0, (byte)11, this) < 7;
        if (bl &= this.GetLowestOfSuit((byte)0, false) < 8) {
            this.FilterEmoticon(5, 30);
            int n3 = this.GetGroupMask(-1, 0, 13, true);
            this.GroupUpdate(-1000, n3, true, n2 >> 2);
            n3 = this.GetGroupMask(0, 0, 10, true);
            boolean bl2 = this.engineParent.currentRound < 3 && this.countSuits[0] > 4 && !this.engineParent.trumpBroken;
            this.GroupReOrder(1000, 0, n3, true, bl2, n2 >> 1, n2);
            return;
        }
        boolean bl3 = this.engineParent.trumpBroken;
        byte by = this.GetLowestOfSuit((byte)3, false);
        bl3 &= this.engineParent.GetNumSuitPlayedAbove((byte)3, by, this) < 13 - by;
        if (bl3 &= this.engineParent.pointsGame[this.meInRef] > 0) {
            int n4 = this.GetGroupMask(-1, 0, 13, true);
            this.GroupUpdate(-1000, n4, true, n2 >> 2);
            n4 = this.GetGroupMask(3, 0, 12, true);
            this.GroupReOrder(1000, 0, n4, true, false, n2, n2);
            return;
        }
    }

    private void Hearts_Change_Test(int n) {
        this.Hearts_Change_Basics(10);
    }

    private void Hearts_Play_Test(int n) {
        int n2 = 150 + n * 60;
        for (int i = 0; i < this.numCards; ++i) {
            byte by = this.hand[i];
            if (by == -1) continue;
            byte by2 = CardUtils.DecodeCardAH(by);
            byte by3 = CardUtils.DecodeSuit(by);
            int n3 = this.GetNumAboveSuit(by3, by2) + this.engineParent.GetNumSuitPlayedAbove(by3, by2, this);
            n3 = 13 - by2 - n3;
            int n4 = by2 * 1000 / 13;
            this.UpdateScore(i, n4, n2);
            if (this.engineParent.numInPile == 0) {
                if (by == CafeCardsDefs.QUEEN_SPADES) {
                    if (n3 == 0) {
                        this.UpdateScore(i, 1000, n2);
                        continue;
                    }
                    if (n3 != 2) continue;
                    this.UpdateScore(i, -1000, 150);
                    continue;
                }
                if (n3 <= 0) continue;
                this.UpdateScore(i, -1000, 30 + n3 * 20);
                continue;
            }
            if (this.countSuits[this.leadSuit] == 0) {
                if (by == CafeCardsDefs.QUEEN_SPADES || by3 == 3) {
                    this.UpdateScore(i, -1000, n2 + 1000 >> 1);
                    continue;
                }
                n4 = 1000 - by2 * 1000 / 13;
                this.UpdateScore(i, n4, n2);
                continue;
            }
            if (this.engineParent.GetNumSuitInPile((byte)3) > 0 || this.engineParent.GetCardInPile(CafeCardsDefs.QUEEN_SPADES)) {
                if (by3 == this.leadSuit && by2 > this.rankCap) {
                    n4 = 250 + by2 * 1000 / 26;
                }
            } else if (by3 == 0 && this.gotQueenSpades) {
                n4 = -1000;
                if (this.engineParent.numInPile == 3 && this.rankCap < 11) {
                    n4 = 1000;
                }
                if (n3 == 0) {
                    n4 = 1000;
                }
            } else if (by2 > this.rankCap && by3 == this.leadSuit) {
                n4 = by2 * 1000 / 52;
                n4 = this.engineParent.numInPile == 3 || n3 == 0 ? 1000 - n4 : (n4 += 750);
            } else {
                n4 = 1000 - by2 * 1000 / 13;
            }
            this.UpdateScore(i, n4, n2);
        }
    }

    private void InitSpadesInfo() {
        this.partner = this.meInRef + 2;
        if (this.partner >= 4) {
            this.partner -= 4;
        }
        this.oppTeam1 = this.meInRef + 1;
        if (this.oppTeam1 >= 4) {
            this.oppTeam1 -= 4;
        }
        this.oppTeam2 = this.meInRef - 1;
        if (this.oppTeam2 < 0) {
            this.oppTeam2 += 4;
        }
    }

    public void Spades_PlayCard_Test() {
        switch (this.playerType) {
            case 101: {
                this.Spades_Play_Basic1(10);
                break;
            }
            case 102: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Ducking(10, false);
                break;
            }
            case 103: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Partners1(10);
                break;
            }
            case 104: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Suits1(10);
                break;
            }
            case 105: {
                this.Spades_Play_Basic1(10);
                break;
            }
            case 106: {
                this.Spades_Play_Basic1(10);
                break;
            }
            case 107: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Ducking(10, this.engineParent.trickBid[this.meInRef] == 0);
                this.Spades_Play_Nil(10);
                break;
            }
            case 108: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_NilDef(10);
                break;
            }
            case 109: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Partners1(10);
                this.Spades_Play_Suits1(10);
                this.Spades_Play_NoBagging(8);
                this.Spades_Play_Ducking(10, false);
                this.Spades_Play_NilDef(8);
                this.Spades_Play_Nil(10);
                this.Spades_Play_Cunning(10);
                this.Spades_Play_Aggressive(7);
                this.Spades_Play_Expert1(10);
                break;
            }
            case 110: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Cunning(10);
                break;
            }
            case 200: {
                break;
            }
            case 201: {
                this.Whist_PlayRandom();
                break;
            }
        }
    }

    public int Spades_PlayCard() {
        this.ResetScores(this.skillLevel);
        this.InitPlayCardWhist();
        this.InitSpadesInfo();
        this.spadesMyTricksDiff = this.engineParent.pointsGame[this.meInRef] - this.engineParent.trickBid[this.meInRef];
        this.spadesTeamTricksDiff = this.engineParent.pointsGame[this.meInRef] + this.engineParent.pointsGame[this.partner] - (this.engineParent.trickBid[this.meInRef] + this.engineParent.trickBid[this.partner]);
        this.spadesOppTeamTricksDiff = this.engineParent.pointsGame[this.oppTeam1] + this.engineParent.pointsGame[this.oppTeam2] - (this.engineParent.trickBid[this.oppTeam1] + this.engineParent.trickBid[this.oppTeam2]);
        this.bSpadesNilBid = this.engineParent.trickBid[this.meInRef] == 0;
        this.objective = 0;
        switch (this.playerType) {
            case 1: {
                this.Spades_Play_Basic1(3 + this.skillLevel / 5);
                this.Spades_Play_Nil(2);
                this.Spades_Play_Partners1(7);
                break;
            }
            case 2: {
                this.Spades_Play_Basic1(4 + this.skillLevel / 5);
                this.Spades_Play_Nil(5);
                this.RandomiseScores(40);
                break;
            }
            case 3: {
                this.Spades_Play_Basic1(4 + this.skillLevel / 4);
                this.Spades_Play_Ducking(3, false);
                this.Spades_Play_Nil(8 + this.skillLevel / 5);
                this.Spades_Play_Aggressive(9);
                this.RandomiseScores(60);
                break;
            }
            case 4: {
                this.Spades_Play_Basic1(5 + this.skillLevel / 5);
                if (this.RandX(20) < 7) {
                    this.Spades_Play_Cunning(0);
                }
                this.Spades_Play_Suits1(2);
                this.Spades_Play_NoBagging(5 + this.skillLevel / 4);
                this.Spades_Play_NilDef(3);
                break;
            }
            case 5: {
                this.Spades_Play_Basic1(3 + this.skillLevel / 5);
                this.Spades_Play_Suits1(7);
                this.Spades_Play_Expert1(1);
                this.RandomiseScores(30);
                this.Spades_Play_NoBagging(8 + this.skillLevel / 7);
                this.Spades_Play_NilDef(7);
                break;
            }
            case 6: {
                this.Spades_Play_Basic1(9 + this.skillLevel / 6);
                if (this.engineParent.pointsMatch[this.meInRef] < this.engineParent.pointsMatch[this.oppTeam1] - 80) {
                    this.Spades_Play_Cunning(2);
                }
                this.Spades_Play_Ducking(5, false);
                this.Spades_Play_Aggressive(10);
                this.Spades_Play_Nil(7 + this.skillLevel / 5);
                this.Spades_Play_NilDef(8);
                break;
            }
            case 7: {
                this.Spades_Play_Basic1(9 + this.skillLevel / 7);
                this.Spades_Play_Nil(7);
                this.Spades_Play_NilDef(5);
                this.Spades_Play_Partners1(5);
                this.Spades_Play_Ducking(4, false);
                break;
            }
            case 8: {
                this.Spades_Play_Basic1(8 + this.skillLevel / 7);
                this.Spades_Play_Nil(5);
                this.Spades_Play_NilDef(3);
                this.Spades_Play_Partners1(7);
                this.Spades_Play_Expert1(2 + this.skillLevel / 5);
                break;
            }
            case 9: {
                this.Spades_Play_Basic1(8 + this.skillLevel / 5);
                this.Spades_Play_Suits1(7);
                this.Spades_Play_Ducking(6 + this.skillLevel / 6, false);
                this.Spades_Play_Partners1(5);
                this.Spades_Play_NoBagging(9 - this.skillLevel / 7);
                this.Spades_Play_NilDef(9);
                this.Spades_Play_Nil(10);
                break;
            }
            case 10: {
                this.Spades_Play_Basic1(6);
                this.Spades_Play_Ducking(7, false);
                this.Spades_Play_NoBagging(9);
                this.Spades_Play_NilDef(6);
                this.Spades_Play_Nil(1);
                this.Spades_Play_Partners1(5);
                this.Spades_Play_Expert1(3 + this.skillLevel / 5);
                this.Spades_Play_Cunning(10);
                break;
            }
            case 11: {
                this.Spades_Play_Basic1(8);
                this.RandomiseScores(30);
                this.Spades_Play_Partners1(7 + this.skillLevel / 8);
                this.Spades_Play_Suits1(7);
                this.Spades_Play_NoBagging(7);
                this.Spades_Play_Ducking(8, false);
                this.Spades_Play_NilDef(9);
                this.Spades_Play_Nil(8);
                this.Spades_Play_Aggressive(3);
                this.Spades_Play_Expert1(7 + this.skillLevel / 8);
                break;
            }
            case 12: {
                this.Spades_Play_Basic1(10);
                this.Spades_Play_Partners1(9);
                this.Spades_Play_Suits1(10);
                this.Spades_Play_NoBagging(8);
                this.Spades_Play_Ducking(10, false);
                this.Spades_Play_NilDef(7);
                this.Spades_Play_Nil(10);
                this.Spades_Play_Cunning(3 + this.skillLevel / 5);
                this.Spades_Play_Aggressive(7);
                this.Spades_Play_Expert1(9 + this.skillLevel / 8);
                break;
            }
        }
        int n = this.GetHighestScoreWhist(true, true, (byte)0);
        return n;
    }

    public void Spades_MakeBid_Test() {
        int n = -1;
        switch (this.playerType) {
            case 101: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                break;
            }
            case 102: {
                this.Spades_Bid_Basic1(10);
                break;
            }
            case 103: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                break;
            }
            case 104: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                break;
            }
            case 105: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                this.Spades_Bid_BidBalance(10);
                break;
            }
            case 106: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                this.Spades_Bid_Expert1(10);
                break;
            }
            case 107: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_Nil(10);
                break;
            }
            case 108: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                break;
            }
            case 109: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AdjustTrait(20);
                this.Spades_Bid_BidBalance(10);
                this.Spades_Bid_Aggressive(8);
                this.Spades_Bid_Expert1(10);
                this.Spades_Bid_Nil(10);
                break;
            }
            case 110: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AvoidNil(10);
                this.Spades_Bid_BidBalance(10);
                break;
            }
            case 200: {
                this.Spades_Bid_Test(10);
                break;
            }
            case 201: {
                this.score[0] = 100 + this.RandX(500);
            }
        }
    }

    public int Spades_MakeBid() {
        int n = -1;
        this.score[0] = 0;
        this.tactics = 0;
        CardUtils.CountCardsNSuits(this.hand, 13, this.countCards, this.countSuits);
        this.InitSpadesInfo();
        switch (this.playerType) {
            case 1: {
                this.Spades_Bid_Basic1(0 + this.skillLevel / 4);
                this.Spades_Bid_AdjustTrait(30);
                this.score[0] = this.RandomiseScore(this.score[0], 130);
                this.Spades_Bid_AvoidNil(5);
                this.Spades_Bid_Nil(1);
                this.Spades_Bid_BidBalance(5 + this.skillLevel / 4);
                break;
            }
            case 2: {
                this.Spades_Bid_Basic1(4 + this.skillLevel / 4);
                this.Spades_Bid_AdjustTrait(-25);
                this.score[0] = this.RandomiseScore(this.score[0], 50);
                this.Spades_Bid_AvoidNil(4);
                break;
            }
            case 3: {
                this.Spades_Bid_Basic1(3 + this.skillLevel / 4);
                this.Spades_Bid_AdjustTrait(50);
                this.score[0] = this.RandomiseScore(this.score[0], 25);
                this.Spades_Bid_Nil(7);
                break;
            }
            case 4: {
                this.Spades_Bid_Basic1(6 + this.skillLevel / 4);
                this.Spades_Bid_AdjustTrait(-45);
                this.score[0] = this.RandomiseScore(this.score[0], 20);
                this.Spades_Bid_AvoidNil(9);
                break;
            }
            case 5: {
                this.Spades_Bid_Basic1(5 + this.skillLevel / 4);
                this.Spades_Bid_AdjustTrait(-80);
                this.Spades_Bid_BidBalance(6 + this.skillLevel / 4);
                this.Spades_Bid_AvoidNil(9);
                this.score[0] = this.RandomiseScore(this.score[0], 40);
                break;
            }
            case 6: {
                this.Spades_Bid_Basic1(6 + this.skillLevel / 4);
                this.Spades_Bid_AvoidNil(9);
                this.Spades_Bid_AdjustTrait(8);
                this.score[0] = this.RandomiseScore(this.score[0], 15);
                this.Spades_Bid_Aggressive(8 + this.skillLevel / 4);
                this.Spades_Bid_Expert1(3);
                this.Spades_Bid_Nil(6);
                break;
            }
            case 7: {
                this.Spades_Bid_Basic1(9 + this.skillLevel / 9);
                this.score[0] = this.RandomiseScore(this.score[0], 30);
                this.Spades_Bid_AvoidNil(8);
                this.Spades_Bid_BidBalance(6 + this.skillLevel / 4);
                this.Spades_Bid_Nil(5);
                break;
            }
            case 8: {
                this.Spades_Bid_Basic1(7 + this.skillLevel / 9);
                this.Spades_Bid_AvoidNil(8);
                this.Spades_Bid_BidBalance(7 + this.skillLevel / 4);
                this.score[0] = this.RandomiseScore(this.score[0], 80);
                this.Spades_Bid_Nil(5);
                break;
            }
            case 9: {
                this.Spades_Bid_Basic1(9 + this.skillLevel / 9);
                this.score[0] = this.RandomiseScore(this.score[0], 10);
                this.Spades_Bid_AdjustTrait(10);
                this.Spades_Bid_AvoidNil(10);
                this.Spades_Bid_BidBalance(9);
                this.Spades_Bid_Expert1(4 + this.skillLevel / 4);
                this.Spades_Bid_Nil(9);
                break;
            }
            case 10: {
                this.Spades_Bid_Basic1(8 + this.skillLevel / 9);
                this.Spades_Bid_AvoidNil(10);
                this.Spades_Bid_Nil(3);
                this.score[0] = this.RandomiseScore(this.score[0], 25);
                this.Spades_Bid_AdjustTrait(-25);
                this.Spades_Bid_Expert1(2 + this.skillLevel / 8);
                this.Spades_Bid_BidBalance(9);
                break;
            }
            case 11: {
                this.Spades_Bid_Basic1(10);
                this.Spades_Bid_AdjustTrait(-10);
                this.score[0] = this.RandomiseScore(this.score[0], 15);
                this.Spades_Bid_Aggressive(3);
                this.Spades_Bid_Expert1(7);
                this.Spades_Bid_Nil(6 + this.skillLevel / 8);
                this.Spades_Bid_BidBalance(9 + this.skillLevel / 8);
                break;
            }
            case 12: {
                this.Spades_Bid_Basic1(9 + this.skillLevel / 8);
                this.Spades_Bid_AvoidNil(3);
                this.Spades_Bid_BidBalance(9 + this.skillLevel / 8);
                this.Spades_Bid_Aggressive(9);
                this.Spades_Bid_Expert1(10);
                this.Spades_Bid_AdjustTrait(18);
                this.Spades_Bid_Nil(10);
                break;
            }
        }
        if (n < 0) {
            n = this.score[0] / 100;
        }
        if (n > 13) {
            n = 13;
        }
        return n;
    }

    private int Spades_Play_Random() {
        int n;
        do {
            if (this.engineParent.IsLegalWhistCard(n = this.RandX(13), this.handRef, 13, this.engineParent.trumpBroken ? -1 : 0)) continue;
            n = -1;
        } while (n < 0);
        return n;
    }

    private void Spades_ScoreLose(int n, int n2, int n3) {
        int n4 = this.GetGroupMask(-1, 0, 13, true);
        this.GroupReOrder(n2, 0, n4, true, false, n, n);
        n4 = this.GetGroupMask(0, 0, 13, true);
        this.GroupReOrder(n3, -1000, n4, true, false, n, n);
    }

    private void Spades_Play_Basic1(int n) {
        int n2;
        int n3 = 200 + n * 70;
        int n4 = this.GetGroupMask(-1, 0, 13, true);
        this.GroupReOrder(-900, -1000, n4, true, true, 0, 10);
        boolean bl = !this.bSpadesNilBid;
        int n5 = 5;
        if (this.spadesTeamTricksDiff >= 0) {
            n5 = 30 + this.engineParent.pointsMatch[this.meInRef] % 10 * 4;
        }
        int n6 = (16 - this.engineParent.currentRound) * (10 + n) / 30;
        for (n2 = this.spadesMyTricksDiff; n2 > 0; --n2) {
            n5 = (n5 * 100 + 90 * n6) / (100 + n6);
        }
        n6 = 20;
        for (n2 = this.spadesTeamTricksDiff; n2 > 0; --n2) {
            n5 = (n5 * 100 + 95 * (n6 += n)) / (100 + n6);
        }
        if (this.RandX(100) < n5) {
            bl = false;
        }
        int n7 = -1;
        if (bl && this.playMode != 0) {
            byte by = this.GetHighestOfSuit((byte)0, false);
            if (this.playMode == 2) {
                if ((this.suitCap != 0 || this.rankCap < by) && this.countSuits[0] > 0 && by > 4 && this.RandX(10) < n) {
                    n7 = 0;
                } else if (this.RandX(50) < 40 + n) {
                    bl = false;
                }
            }
            if (this.playMode == 1) {
                by = this.GetHighestOfSuit(this.leadSuit, false);
                if (this.rankCap > by && this.RandX(100) < 90 + n) {
                    bl = false;
                }
                if (this.suitCap == 0 && this.leadSuit != 0 && this.RandX(100) < 90 + n) {
                    bl = false;
                }
            }
        }
        n4 = this.GetGroupMask(n7, 0, 13, true);
        if (bl) {
            this.GroupReOrder(900, -900, n4, true, true, n3, n3);
            this.objective = 1;
        } else {
            this.Spades_ScoreLose(n3, 900, -1);
            this.objective = 2;
        }
    }

    private void Spades_Bid_Basic1(int n) {
        if (n > 10) {
            n = 10;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = 105 - this.RandX(20 + (10 - n) * 7);
        for (int i = 0; i < 13; ++i) {
            byte by = CardUtils.DecodeSuit(this.hand[i]);
            byte by2 = CardUtils.DecodeCardAH(this.hand[i]);
            int n3 = by2 * by2 / 5;
            if (by2 > 8) {
                n3 += 23 + (by2 - 8) * 12;
            }
            if (by2 == 13) {
                n3 = n3 + 120 >> 1;
            }
            if (by2 == 12) {
                int n4 = 106;
                if (this.GetHighestOfSuit(by, false) == 13) {
                    this.FilterEmoticon(7, 40);
                    n4 += n + 1;
                }
                n3 = n3 * 3 + n4 - (n >> 1) >> 2;
            }
            if (by == 0) {
                n3 = n3 + 116 + (n >> 1) >> 1;
            }
            n3 = n3 > 100 ? 100 + n3 >> 1 : (n3 /= 5);
            n2 += n3;
        }
        this.score[0] = n2;
    }

    private void Spades_Bid_AvoidNil(int n) {
        if (this.score[0] < 101) {
            int n2 = 101 - this.score[0] + n * 2;
            this.score[0] = this.score[0] + this.RandX(n2);
        }
    }

    private void Spades_Bid_AdjustTrait(int n) {
        if (n > 0) {
            this.score[0] = (1000 * this.score[0] + n * 1300) / (1000 + n);
        } else if (this.score[0] > 100) {
            this.score[0] = (1000 * this.score[0] + n * 100) / (1000 + n);
        }
    }

    private void Spades_Bid_BidBalance(int n) {
        int n2;
        int n3 = 15 + n * 3;
        this.score[0] = (this.score[0] * (1000 - n3) + 330 * n3) / 1000;
        if (this.engineParent.trickBid[this.partner] > -999) {
            if (this.engineParent.trickBid[this.partner] > 4) {
                this.score[0] = this.score[0] - (this.engineParent.trickBid[this.partner] - 4) * (12 + this.RandX(12 - n)) * this.score[0] / 200;
            } else if (this.engineParent.trickBid[this.partner] < 2) {
                this.score[0] = this.score[0] + (10 + this.RandX(15 - n) + n);
            }
        }
        int n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (n2 != this.meInRef && this.engineParent.trickBid[n2] > 5) {
                this.score[0] = this.score[0] - (20 + (10 - n) * 3);
            }
            if (this.engineParent.trickBid[n2] > -999) {
                n4 += this.engineParent.trickBid[n2];
                ++n3;
                continue;
            }
            if (this.meInRef == n2) continue;
            n4 += 2;
        }
        if (n3 == 0) {
            this.score[0] = this.score[0] - n;
            this.FilterEmoticon(8, 40);
        } else {
            if (n3 == 3) {
                n2 = n4 + this.score[0] / 100;
                if (n2 < 10) {
                    this.FilterEmoticon(6, 60);
                }
                while (n2 < 10) {
                    n3 = 117 - n2 + (10 - n);
                    this.score[0] = this.score[0] * n3 / (110 - n);
                    ++n2;
                }
            }
            for (n2 = n4 + this.score[0] / 100; n2 > 10; --n2) {
                n3 = 96 - (n2 >> 1) + (10 - n);
                this.score[0] = this.score[0] * n3 / (110 - n);
            }
        }
    }

    private void Spades_Bid_Aggressive(int n) {
        int n2 = this.engineParent.trickBid[this.oppTeam1] + this.engineParent.trickBid[this.oppTeam2];
        if (n2 > 5) {
            this.score[0] = this.score[0] + ((n2 - 5) * (n + 4) >> 1);
            this.FilterEmoticon(5, 70);
        }
    }

    private void Spades_Bid_Expert1(int n) {
        byte by;
        if (this.countSuits[0] > 3) {
            this.score[0] = this.score[0] + (this.countSuits[0] - 3) * (8 + n);
            for (by = 0; by < 4; by = (byte)(by + 1)) {
                if (this.countSuits[by] >= 2) continue;
                this.score[0] = this.score[0] + (3 + n) / (this.countSuits[by] + 2);
            }
        }
        for (int i = 0; i < 13; ++i) {
            byte by2;
            by = CardUtils.DecodeSuit(this.hand[i]);
            int n2 = this.GetNumAboveSuit(by, by2 = CardUtils.DecodeCardAH(this.hand[i]));
            if (n2 != 13 - by2) continue;
            this.score[0] = this.score[0] + ((13 - by2) * 6 >> 3) * (n + 3) / 12;
        }
        while (this.score[0] / 100 + this.engineParent.trickBid[this.partner] > 10) {
            this.score[0] = this.score[0] - (20 + (this.score[0] >> 4));
        }
    }

    private void Spades_Bid_Nil(int n) {
        byte by;
        int n2;
        if (this.score[0] > 300) {
            return;
        }
        int n3 = 0;
        if (this.engineParent.trickBid[this.partner] == 0) {
            this.Spades_Bid_AvoidNil(10);
            int n4 = (400 - this.score[0]) / 4;
            if (n4 < 0) {
                n4 = 0;
            }
            this.score[0] = this.score[0] + (20 + n4) * 5 / (15 - n);
            return;
        }
        for (n2 = 0; n2 < 13; ++n2) {
            by = CardUtils.DecodeSuit(this.hand[n2]);
            byte by2 = CardUtils.DecodeCardAH(this.hand[n2]);
            if (by2 == 13 && by == 0) {
                return;
            }
            if (by2 >= 12 && this.RandX(11) < n) {
                return;
            }
            n3 += (by2 - 1) * 10 + by2;
        }
        int n5 = this.score[0];
        if ((n3 /= 13) < 59) {
            n5 = (n5 - 50) * (n3 + 30) / 89;
        }
        n5 += (this.countSuits[0] - 3) * 11;
        for (by = 0; by < 4; by = (byte)(by + 1)) {
            if (this.countSuits[by] >= 2) continue;
            n5 -= 8;
        }
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.engineParent.trickBid[n2] == -999) {
                n5 = n5 * 3 + 110 >> 2;
                continue;
            }
            n5 -= (this.engineParent.trickBid[n2] - 2) * 11;
        }
        if (this.engineParent.trickBid[this.oppTeam1] == 0 || this.engineParent.trickBid[this.oppTeam2] == 0) {
            n5 >>= 2;
        }
        if (n5 < 10 + this.RandX(115 - n * 4) + n) {
            this.score[0] = 0;
        } else {
            this.Spades_Bid_AvoidNil(10);
            this.FilterEmoticon(4, 30);
        }
    }

    private void Spades_Play_Nil(int n) {
        byte by;
        int n2;
        int n3;
        if (this.engineParent.trickBid[this.partner] == 0 && this.engineParent.pointsGame[this.partner] == 0) {
            int n4 = this.engineParent.pointsMatch[this.meInRef] % 10;
            if (this.trickWinner == this.partner && this.spadesTeamTricksDiff + n4 < 10 && this.objective != 1 && this.GetHighestOfSuit(this.suitCap, false) > this.rankCap) {
                n3 = this.GetGroupMask(this.suitCap, 0, 13, true);
                n2 = 400 + n * 50;
                this.GroupReOrder(1000, 800, n3, true, true, n2, n2);
                this.objective = 1;
                this.FilterEmoticon(6, 60);
            } else if (this.playMode == 0) {
                n3 = this.GetGroupMask(-1, 0, 13, true);
                this.GroupUpdate(-1000, n3, true, 100);
                for (by = 0; by < 4; by = (byte)(by + 1)) {
                    if (!this.engineParent.GetSuitEmptyWhistPlayer(by, this.partner, this)) continue;
                    n2 = 200 + n * 20;
                    n3 = this.GetGroupMask(by, 0, 13, true);
                    this.GroupUpdate(1000, n3, true, n2);
                }
            }
        }
        if (this.engineParent.trickBid[this.meInRef] == 0 && this.engineParent.pointsGame[this.meInRef] == 0) {
            this.FilterEmoticon(8, 10);
            n3 = this.GetGroupMask(-1, 0, 13, true);
            this.GroupUpdate(-1000, n3, true, 150);
            for (by = 0; by < 4; by = (byte)(by + 1)) {
                n2 = 400 - (10 + n) * this.countSuits[by];
                if (by == 0) {
                    n2 >>= 1;
                }
                if ((n2 -= 20 * (this.GetLowestOfSuit(by, false) - this.engineParent.GetLowestNotPlayedOfSuit(by, this))) <= 0) continue;
                n3 = this.GetGroupMask(by, 0, 13, true);
                this.GroupUpdate(1000, n3, true, n2);
            }
        }
    }

    private void Spades_Play_NilDef(int n) {
        int n2;
        int n3 = -1;
        if (this.engineParent.trickBid[this.oppTeam1] == 0 && this.engineParent.pointsGame[this.oppTeam1] == 0) {
            n3 = this.oppTeam1;
        }
        if (this.engineParent.trickBid[this.oppTeam2] == 0 && this.engineParent.pointsGame[this.oppTeam2] == 0) {
            n3 = this.oppTeam2;
        }
        if (n3 < 0) {
            return;
        }
        int n4 = n2 = n3 == this.oppTeam1 ? this.oppTeam2 : this.oppTeam1;
        if (this.engineParent.pile[n3] > -1 && this.trickWinner != n3) {
            if (this.objective == 2 && this.spadesMyTricksDiff > -2) {
                this.Spades_Play_Ducking(n + 10 >> 1, true);
            } else {
                int n5 = this.GetGroupMask(-1, 0, 5, true);
                int n6 = 250 - this.engineParent.currentRound * (n + 7);
                this.GroupReOrder(0, -1000, n5, true, true, 0, n6);
            }
            return;
        }
        if (this.trickWinner == n2 && this.rankCap > 7 && this.objective == 1) {
            return;
        }
        int n7 = this.GetGroupMask(-1, 0, 13, true);
        this.GroupReOrder(500, -1000, n7, true, false, 0, 700);
        this.objective = 2;
        this.FilterEmoticon(1, 50);
        if (this.playMode == 0) {
            for (byte by = 0; by < 4; by = (byte)(by + 1)) {
                n7 = this.GetGroupMask(by, 0, 13, true);
                int n8 = 400 + (3 - this.engineParent.GetNumSuitPlayedAboveBy(n3, by, (byte)0, this)) * 60;
                n8 += (7 - this.engineParent.GetNumSuitPlayed(by, this)) * 25;
                n8 += this.engineParent.GetNumSuitPlayedAboveBy(n2, by, (byte)7, this) * 30;
                if (by == 0 && this.engineParent.trumpBroken) {
                    n8 = 1000 + n8 >> 1;
                }
                if (this.GetLowestOfSuit(by, false) > 10 && this.spadesTeamTricksDiff > -2) {
                    n8 -= 20 * n;
                }
                if (this.engineParent.GetSuitEmptyWhistPlayer(by, n3, this)) {
                    n8 -= 50;
                }
                if ((n8 = n8 * (2 + n) / 12) > 0) {
                    this.GroupReOrder(1000, 500, n7, true, false, 0, n8);
                    continue;
                }
                this.GroupReOrder(0, 0, n7, true, false, 0, -n8);
            }
        } else if (this.playMode == 2 && this.suitCap != 0) {
            int n9 = 500 + n * 40;
            n7 = this.GetGroupMask(-1, 0, 13, true);
            boolean bl = this.spadesTeamTricksDiff > -1;
            this.GroupReOrder(1000, 0, n7, true, bl, 0, n9);
            n7 = this.GetGroupMask(0, 0, 13, true);
            this.GroupReOrder(0, -1000, n7, true, false, 0, n9);
            this.objective = 2;
        }
    }

    private void Spades_Play_Aggressive(int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.engineParent.pointsMatch[this.meInRef] % 10;
        int n5 = this.spadesOppTeamTricksDiff + (13 - this.engineParent.currentRound);
        int n6 = this.engineParent.trickBid[this.oppTeam1] + this.engineParent.trickBid[this.oppTeam2];
        if (n6 > 4 && this.spadesOppTeamTricksDiff < 0 && this.objective == 2 && this.trickWinner != this.partner && n4 < 7 && n5 >= 0) {
            this.FilterEmoticon(5, 50);
            n3 = 30 + n * 3 + n6 * 3 - n5 * 8 - n4 * 3;
            if (n3 > 0 && this.engineParent.currentRound > 6) {
                n3 += 10 + this.engineParent.currentRound;
            }
            if ((this.tactics & 1) != 0) {
                n3 = n3 + 300 >> 2;
            }
            if (this.RandX(100) < n3) {
                this.tactics |= 1;
                bl = true;
                if (this.spadesTeamTricksDiff >= 0) {
                    this.objective = 1;
                    n2 = 200 + n * 50;
                    int n7 = this.GetGroupMask(-1, 0, 13, true);
                    this.GroupReOrder(500, -1000, n7, true, true, 0, n2);
                    n7 = this.GetGroupMask(0, 0, 13, true);
                    this.GroupReOrder(1000, 500, n7, true, false, 0, n2);
                }
            }
        }
        if (!bl) {
            this.tactics &= 0xFFFFFFFE;
        }
        if ((this.tactics & 1) == 0 && n5 < 0 && this.spadesTeamTricksDiff >= 0) {
            n3 = 10 + n * 8;
            if (this.RandX(100) < n3) {
                this.tactics |= 2;
            }
        }
        if ((this.tactics & 2) != 0) {
            this.objective = 2;
            n2 = 300 + n * 35;
            this.Spades_ScoreLose(n2, 900, 200);
            this.FilterEmoticon(7, 50);
        }
    }

    private void Spades_Play_Cunning(int n) {
        int n2 = this.engineParent.pointsMatch[this.meInRef] % 10;
        if (this.playMode == 0) {
            int n3 = 0;
            for (byte by = 0; by < 4; by = (byte)(by + 1)) {
                int n4;
                int n5 = this.GetGroupMask(by, 0, 13, true);
                this.GroupUpdate(-1000, n5, true, 100);
                if (this.spadesTeamTricksDiff < 0) {
                    int n6;
                    if (!this.engineParent.trumpBroken && this.engineParent.currentRound < 6 && this.countSuits[0] < 4) {
                        n4 = 50 + (7 - this.countSuits[by]) * 15;
                        n6 = 200 - this.countSuits[0] * 20;
                        if (this.engineParent.GetSuitEmptyWhistPlayer(by, this.partner, this)) {
                            n4 += n6;
                        }
                        if (this.engineParent.GetSuitEmptyWhistPlayer(by, this.oppTeam1, this)) {
                            n4 += n6;
                        }
                        if (this.engineParent.GetSuitEmptyWhistPlayer(by, this.oppTeam2, this)) {
                            n4 += n6;
                        }
                        n4 = n4 * n / 10;
                        this.GroupUpdate(-1000, n5, true, n4);
                    }
                    if (this.engineParent.currentRound >= 3) continue;
                    byte by2 = CardUtils.EncodePack(by, (byte)13);
                    n6 = CardUtils.FindInCards(by2, this.hand, 13);
                    if (n6 >= 0) {
                        n4 = 30 + n * 6;
                        this.UpdateScore(n6, -1000, n4);
                        this.FilterEmoticon(8, 50);
                    } else {
                        n4 = 50 + n * 50;
                        n6 = 1000 - this.countSuits[by] * 15;
                        this.GroupReOrder(n6, -1000, n5, true, false, 0, n4);
                        ++n3;
                    }
                    if (by != 0 || this.engineParent.trumpBroken) continue;
                    ++n3;
                    continue;
                }
                if (this.GetHighestOfSuit(by, false) >= 6 || this.countSuits[by] >= 4) continue;
                n4 = 100 + n * 40;
                this.GroupReOrder(1000, 0, n5, true, true, 0, n4);
            }
            if (n3 == 4) {
                this.objective = 2;
            }
        } else if (this.playMode == 2) {
            if (!this.engineParent.trumpBroken && this.engineParent.currentRound < 7 && this.countSuits[0] < 3) {
                int n7 = this.GetGroupMask(0, 0, 13, true);
                this.GroupUpdate(-1000, n7, true, 50 + n * 30);
                this.objective = 2;
            }
        } else {
            byte by = this.GetHighestOfSuit(this.suitCap, false);
            if (!this.engineParent.LastToPlayWhist(this.meInRef) && by < 13 && this.engineParent.GetNumSuitPlayedAbove(this.suitCap, by, this) != 13 - by) {
                int n8 = 10 + this.RandX(50 + n * 30);
                int n9 = this.GetGroupMask(0, 0, 13, true);
                this.GroupReOrder(0, -1000, n9, true, false, n8, n8);
                this.FilterEmoticon(8, 60);
            }
        }
    }

    private void Spades_Play_NoBagging(int n) {
        if (this.spadesTeamTricksDiff >= 0) {
            int n2 = n * 2 + this.spadesTeamTricksDiff * 20 + this.engineParent.pointsMatch[this.meInRef] % 10 * 3;
            if (n2 > 80) {
                n2 = 80 + (n2 - 80) >> 2;
            }
            if (this.RandX(100) < n2) {
                this.objective = 2;
                int n3 = 500 + n * 18;
                this.Spades_ScoreLose(n3, 900, -10 + n * 30);
                this.FilterEmoticon(1, 50);
            }
        }
    }

    private void Spades_Play_Expert1(int n) {
        int n2 = this.engineParent.pointsMatch[this.meInRef] % 10;
        if (this.objective == 2) {
            boolean bl;
            int n3;
            int n4;
            for (int i = 0; i < 13; ++i) {
                if (this.hand[i] == -1) continue;
                byte by = CardUtils.DecodeSuit(this.hand[i]);
                byte by2 = CardUtils.DecodeCardAH(this.hand[i]);
                n4 = this.engineParent.GetNumSuitPlayedAbove(by, by2, this) + this.GetNumAboveSuit(by, by2);
                n4 = 13 - by2 - n4;
                if (this.spadesTeamTricksDiff < 0) {
                    if (n4 <= 0) continue;
                    n3 = n4 * (n + 10);
                    this.UpdateScore(i, -1000, n3);
                    continue;
                }
                n3 = (13 - n4) * (n * 2 + 5 + n2);
                this.UpdateScore(i, -1000, n3);
            }
            n4 = n + 3 >> 1;
            do {
                bl = false;
                int n5 = this.GetHighestScoreWhist(false, true, (byte)0);
                byte by = CardUtils.DecodeSuit(this.hand[n5]);
                byte by3 = CardUtils.DecodeCardAH(this.hand[n5]);
                if (by3 <= this.rankCap || by != this.suitCap && by != 0) continue;
                bl = true;
                n3 = 60 + n * 20;
                this.UpdateScore(n5, -1000, n3);
            } while (n4-- > 0 && bl);
        } else if (this.playMode == 0) {
            boolean bl;
            int n6 = n + 1 >> 2;
            if (n6 < 2) {
                n6 = 2;
            }
            do {
                bl = false;
                int n7 = this.GetHighestScoreWhist(false, true, (byte)0);
                byte by = CardUtils.DecodeSuit(this.hand[n7]);
                byte by4 = CardUtils.DecodeCardAH(this.hand[n7]);
                int n8 = this.engineParent.GetNumSuitPlayedAbove(by, by4, this) + this.GetNumAboveSuit(by, by4);
                if ((n8 = 13 - by4 - n8) <= 0 || by4 <= 8) continue;
                bl = true;
                int n9 = 10 + n * 20 * n8 / (13 - by4);
                n9 += by4 * (5 + n >> 1);
                if (by == 0) {
                    n9 += 25;
                }
                if (by4 == this.GetHighestOfSuit(by, false)) {
                    n9 += 7;
                }
                this.UpdateScore(n7, -1000, n9);
            } while (n6-- > 0 && bl);
        } else {
            for (int i = 0; i < 13; ++i) {
                if (this.hand[i] == -1) continue;
                byte by = CardUtils.DecodeSuit(this.hand[i]);
                byte by5 = CardUtils.DecodeCardAH(this.hand[i]);
                if ((by == this.suitCap && by5 > this.rankCap || this.suitCap <= -1) && this.spadesTeamTricksDiff < -1) {
                    int n10 = (13 - by5) * 35;
                    int n11 = this.engineParent.GetNumSuitPlayedAbove(by, by5, this) + this.GetNumAboveSuit(by, by5);
                    n11 = 13 - by5 - n11;
                    if ((n10 /= 5 - this.engineParent.numInPile) <= 0) continue;
                    n10 = n11 <= 0 ? n10 + 1000 >> 1 : (n10 /= 1 + n11);
                    this.UpdateScore(i, 1000, n10);
                    continue;
                }
                this.UpdateScore(i, -1000, n * 20);
            }
        }
    }

    private void Spades_Play_Ducking(int n, boolean bl) {
        int n2 = 200 + n * 70;
        int n3 = this.engineParent.pointsMatch[this.meInRef] % 10;
        int n4 = this.GetHighestScoreWhist(false, true, (byte)0);
        byte by = CardUtils.DecodeSuit(this.hand[n4]);
        byte by2 = CardUtils.DecodeCardAH(this.hand[n4]);
        int n5 = 11 - n3 >> 1;
        if (this.spadesOppTeamTricksDiff >= 0 && n5 > 1) {
            n5 >>= 1;
        }
        if (this.spadesMyTricksDiff > n5 || this.spadesTeamTricksDiff > n5 + 1 || bl) {
            this.objective = 2;
            this.FilterEmoticon(6, 50);
            if (this.playMode == 1) {
                int n6 = this.GetGroupMask(this.suitCap, 0, this.rankCap, true);
                this.GroupReOrder(1000, 750, n6, true, true, 0, n2);
            } else if (this.playMode == 0) {
                this.Spades_ScoreLose(n2, 1000, 990);
            } else {
                int n7 = this.GetGroupMask(-1, 0, 13, true);
                this.GroupReOrder(800, 0, n7, true, true, 0, n2);
                if (this.suitCap == 0) {
                    n7 = this.GetGroupMask(0, this.rankCap, 13, true);
                    this.GroupReOrder(0, -1000, n7, true, false, 0, n2);
                    n7 = this.GetGroupMask(0, 0, this.rankCap, true);
                    this.GroupReOrder(1000, 650, n7, true, true, n2, n2);
                } else {
                    n7 = this.GetGroupMask(0, 0, 13, true);
                    this.GroupReOrder(0, -1000, n7, true, false, 0, n2);
                }
            }
        } else if (this.objective == 1 && this.playMode != 0) {
            n5 = 0;
            if (n < 7) {
                n5 = -1;
            }
            if (0 == by && this.engineParent.LastToPlayWhist(this.meInRef) && this.suitCap != 0 && this.spadesMyTricksDiff < n5 && this.spadesTeamTricksDiff < n5) {
                int n8 = this.GetGroupMask(0, 0, 13, true);
                this.GroupReOrder(1000, 0, n8, true, false, 0, n2);
            } else if (this.playMode == 1 && this.engineParent.LastToPlayWhist(this.meInRef) && this.spadesMyTricksDiff < -2) {
                int n9 = this.GetGroupMask(this.suitCap, this.rankCap + 1, 13, true);
                this.GroupReOrder(1000, 875, n9, true, false, 0, n2);
            }
        }
    }

    private void Spades_Play_Partners1(int n) {
        if (this.trickWinner == this.partner) {
            int n2 = 700 + n * 20;
            int n3 = this.engineParent.pointsMatch[this.meInRef] % 10;
            int n4 = 0 - (n3 * n - this.spadesMyTricksDiff * 5) / 39;
            if (this.objective == 1 && this.spadesTeamTricksDiff < n4 && this.RandX(10) <= n) {
                this.objective = 2;
                this.Spades_ScoreLose(n2, 900, -1);
                this.FilterEmoticon(6, 100);
            }
        }
    }

    private void Spades_Play_Suits1(int n) {
        if (this.spadesTeamTricksDiff < 0) {
            for (byte by = 0; by < 4; by = (byte)((byte)(by + 1))) {
                int n2;
                int n3 = this.GetGroupMask(by, 0, 13, true);
                if (this.objective == 2) {
                    if (by == 0 || this.countSuits[0] <= 0) continue;
                    n2 = (90 + n * 9) / (this.countSuits[by] * this.countSuits[by] + 1);
                    this.GroupUpdate(1000, n3, true, n2);
                    continue;
                }
                if (by == 0) {
                    n2 = -this.spadesTeamTricksDiff * (5 + (n >> 1)) / (this.countSuits[by] + 1);
                    if (this.engineParent.GetNumSuitPlayedAboveBy(this.oppTeam1, (byte)0, (byte)0, this) < 3) {
                        n2 += 5;
                    }
                    if (this.engineParent.GetNumSuitPlayedAboveBy(this.oppTeam2, (byte)0, (byte)0, this) < 3) {
                        n2 += 5;
                    }
                    this.GroupUpdate(-1000, n3, true, n2);
                }
                if (this.playMode != 0) continue;
                n2 = (1 + this.engineParent.GetNumSuitPlayed(by, this)) * (2 + n) / (3 + this.engineParent.GetNumSuitPlayed((byte)0, this));
                if (this.engineParent.GetNumSuitPlayedAboveBy(this.oppTeam1, by, (byte)0, this) > 2) {
                    n2 += 12;
                }
                if (this.engineParent.GetNumSuitPlayedAboveBy(this.oppTeam2, by, (byte)0, this) > 2) {
                    n2 += 12;
                }
                if (by == 0) {
                    n2 >>= 1;
                    if (this.engineParent.GetSuitEmptyWhistPlayer((byte)0, this.oppTeam1, this)) {
                        n2 >>= n / 4;
                    }
                    if (this.engineParent.GetSuitEmptyWhistPlayer((byte)0, this.oppTeam2, this)) {
                        n2 >>= n / 4;
                    }
                }
                this.GroupUpdate(-1000, n3, true, n2);
            }
        }
    }

    private void Spades_Play_Test(int n) {
        int n2;
        int n3 = 500 + n * 40;
        int n4 = this.GetGroupMask(-1, 0, 13, true);
        this.GroupReOrder(-900, -1000, n4, true, true, 0, 10);
        boolean bl = !this.bSpadesNilBid;
        int n5 = 0;
        int n6 = 10;
        for (n2 = this.spadesMyTricksDiff; n2 > 0; --n2) {
            n5 = (n5 * 100 + 90 * (n6 += n >> 1)) / (100 + n6);
        }
        n6 = 22;
        for (n2 = this.spadesTeamTricksDiff; n2 > 0; --n2) {
            n5 = (n5 * 100 + 95 * (n6 += 9 + n)) / (100 + n6);
        }
        if (this.RandX(100) < n5) {
            bl = false;
        }
        int n7 = -1;
        if (bl && this.playMode != 0) {
            byte by = this.engineParent.pile[this.trickWinner];
            byte by2 = CardUtils.DecodeSuit(by);
            byte by3 = CardUtils.DecodeCardAH(by);
            byte by4 = this.GetHighestOfSuit((byte)0, false);
            if (this.playMode == 2) {
                if ((by2 != 0 || by3 < by4) && this.countSuits[0] > 0) {
                    n7 = 0;
                } else {
                    bl = false;
                }
            }
            if (this.playMode == 1) {
                by4 = this.GetHighestOfSuit(this.suitCap, false);
                if (by3 > by4) {
                    bl = false;
                }
                if (this.suitCap == 0) {
                    bl = false;
                }
            }
        }
        n4 = this.GetGroupMask(n7, 0, 13, true);
        if (bl) {
            this.GroupReOrder(900, -900, n4, true, true, n3, n3);
            this.objective = 1;
        } else {
            this.GroupReOrder(900, 0, n4, true, false, n3, n3);
            n4 = this.GetGroupMask(0, 0, 13, true);
            this.GroupReOrder(-1, -1000, n4, true, false, n3, n3);
            this.objective = 2;
        }
    }

    private void Spades_Bid_Test(int n) {
    }

    private void GinClearNewGame() {
        for (int i = 0; i < 11; ++i) {
            this.meldPlay[i] = 0;
            this.meldKnock[i] = 0;
            this.hand[i] = -1;
            this.handKnock[i] = -1;
        }
        this.ginLastDiscard = (byte)-1;
        this.ginFirstPass = true;
    }

    private int GetHighestScoreGin(byte[] byArray) {
        int n = -999999;
        int n2 = -1;
        for (int i = 0; i < 11; ++i) {
            if (byArray[i] <= -1 || this.score[i] <= n) continue;
            n = this.score[i];
            n2 = i;
        }
        return n2;
    }

    void FindMelds_Test(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        switch (this.playerType) {
            case 101: 
            case 103: 
            case 104: 
            case 105: {
                this.engineParent.FindMelds3(byArray, byArray2, this.GetGinWeights(), n, n2, n3, this);
                break;
            }
            case 102: {
                this.engineParent.FindMelds5(byArray, byArray2, this.GetGinWeights(), n, n2, n3, this);
                break;
            }
            case 200: {
                this.engineParent.FindMelds3(byArray, byArray2, this.GetGinWeights(), n, n2, n3, this);
                break;
            }
        }
    }

    void FindMelds(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        switch (this.playerType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.engineParent.FindMelds3(byArray, byArray2, this.GetGinWeights(), n, n2, n3, this);
                break;
            }
            case 12: {
                this.engineParent.FindMelds3(byArray, byArray2, this.GetGinWeights(), n, n2, n3, this);
                break;
            }
        }
    }

    private short[] GetGinWeights_Test() {
        switch (this.playerType) {
            case 101: 
            case 104: {
                return ginMeldWeights_BasPlay;
            }
            case 102: {
                return ginMeldWeights_SrchPlay;
            }
            case 103: {
                return ginMeldWeights_ProbPlay;
            }
            case 105: {
                return ginMeldWeights_Expert;
            }
            case 200: {
                return ginMeldWeights_BasPlay_T;
            }
        }
        return ginMeldWeights_BasPlay;
    }

    private short[] GetGinWeights() {
        switch (this.playerType) {
            case 1: 
            case 3: {
                return ginMeldWeights_Weak;
            }
            case 4: 
            case 11: {
                return ginMeldWeights_ProbPlay;
            }
            case 6: {
                return ginMeldWeights_Edna;
            }
            case 8: 
            case 10: {
                return ginMeldWeights_SrchPlay;
            }
            case 2: 
            case 5: 
            case 7: {
                return ginMeldWeights_BasPlay;
            }
            case 9: 
            case 12: {
                return ginMeldWeights_Expert;
            }
        }
        return null;
    }

    private void SetGinParams(int n) {
        this.gp_MeldToTries = 3 + (this.rankPlayer >> 1);
        int n2 = this.gp_MeldGap = this.rankPlayer > 6 ? 0 : 1;
        if (n == 5) {
            this.gp_MeldGap = this.rankPlayer < 3 ? 1 : 0;
        }
        this.gp_MeldLowest = 0;
        this.gp_MeldTriesKnock = n == 4 ? 8 + (this.rankPlayer >> 1) : (n == 6 ? 5 + (this.rankPlayer >> 1) : 3 + this.rankPlayer);
        this.gp_FindMeldTries = 6 + (this.rankPlayer >> 1);
        this.gp_KnockDeadWood = 10;
        if (this.rankPlayer < 5) {
            this.gp_KnockDeadWood = 10 - this.RandX(10) * this.RandX(10) / 10;
        }
        this.gp_MinMeld = 2;
        this.gp_SrchConistent = false;
        this.gp_RejectUnmeldedDiscards = this.rankPlayer > 4;
        this.gp_OverRideForKnock = this.rankPlayer > 7;
        this.gp_CrossCheckTake = this.rankPlayer > 3;
        this.gp_PickCaution = this.rankPlayer;
        this.gp_TakeKnockFullTest = this.rankPlayer > 4;
        this.gp_MinMeldMatchDiscard = 2;
        switch (this.playerType) {
            case 1: {
                if (this.RandX(100) < 10) {
                    this.gp_MeldLowest = 1;
                }
                --this.gp_MeldTriesKnock;
                this.gp_MeldToTries += 2;
                if (this.RandX(100) < 40) {
                    this.gp_MinMeld = 3;
                }
                this.gp_PickCaution = 6;
                break;
            }
            case 2: {
                this.gp_KnockDeadWood = 10 + this.gp_KnockDeadWood >> 1;
                this.gp_SrchConistent = true;
                break;
            }
            case 3: {
                this.gp_FindMeldTries += 6 - (this.engineParent.currentRound >> 5);
                this.gp_MeldGap = 1;
                if (this.engineParent.currentRound > 24) {
                    this.gp_MeldLowest = 1;
                }
                if (this.engineParent.currentRound > 14) {
                    this.gp_MeldGap = 2;
                }
                this.gp_PickCaution = 1;
                break;
            }
            case 4: {
                this.gp_CrossCheckTake = true;
                break;
            }
            case 5: {
                this.gp_PickCaution = 10;
                this.gp_RejectUnmeldedDiscards = false;
                ++this.gp_MeldTriesKnock;
                this.gp_MeldGap = 0;
                break;
            }
            case 6: {
                this.gp_FindMeldTries += 3;
                --this.gp_MeldTriesKnock;
                ++this.gp_MeldToTries;
                this.gp_MinMeldMatchDiscard = 1;
                break;
            }
            case 7: {
                this.gp_MeldToTries += 2;
                break;
            }
            case 8: {
                this.gp_MeldToTries = 2;
                this.gp_RejectUnmeldedDiscards = false;
                break;
            }
            case 9: {
                this.gp_PickCaution = 11;
                break;
            }
            case 10: {
                this.gp_MinMeld = 3;
                --this.gp_FindMeldTries;
                this.gp_SrchConistent = true;
                break;
            }
            case 11: {
                this.gp_PickCaution = 4;
                if (n == 0) {
                    this.gp_MeldToTries -= 2;
                } else {
                    ++this.gp_FindMeldTries;
                    ++this.gp_MeldToTries;
                }
                this.gp_MinMeldMatchDiscard = 3;
                break;
            }
            case 12: {
                this.gp_FindMeldTries += 2;
                this.gp_MeldTriesKnock += 3;
                this.gp_MeldToTries += 2;
                this.gp_PickCaution = 8;
                this.gp_MinMeldMatchDiscard = 1;
                break;
            }
        }
    }

    public void Gin_InitOrder() {
        this.SetGinParams(3);
        this.engineParent.FindMelds1(this.hand, this.meldPlay, this.GetGinWeights(), this.gp_MinMeld, this.gp_MeldGap, this);
        this.FindMelds(this.hand, this.meldPlay, this.gp_MinMeld, this.gp_MeldGap, this.gp_FindMeldTries);
        for (int i = 0; i < 11; ++i) {
            this.meldKnock[i] = this.meldPlay[i];
            this.handKnock[i] = this.hand[i];
        }
        this.FindMelds(this.handKnock, this.meldKnock, 3, 0, this.gp_MeldTriesKnock >> 1);
        this.engineParent.PushPlayerData(131072, this.meInRef, this.handKnock);
        this.engineParent.PushPlayerData(524288, this.meInRef, this.meldKnock);
    }

    public int Gin_TakeCard() {
        if (this.ginFirstPass) {
            this.ginFirstPass = false;
            this.Gin_InitOrder();
        }
        if (this.engineParent.currentGameState == 2) {
            return 0;
        }
        if (this.engineParent.pile[0] == this.ginLastDiscard) {
            return 0;
        }
        return this.Gin_TakeCard_ByMelds();
    }

    public int Gin_DiscardCard() {
        int n = this.Gin_DiscardCard2(true);
        this.engineParent.PushPlayerData(131072, this.meInRef, this.hand);
        this.engineParent.PushPlayerData(524288, this.meInRef, this.meldPlay);
        this.ginLastDiscard = this.hand[n];
        this.hand[n] = -1;
        return this.ginLastDiscard;
    }

    public int Gin_DiscardCard2(boolean bl) {
        switch (this.playerType) {
            case 1: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                this.RandomiseScores(40);
                break;
            }
            case 4: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                this.RandomiseScores(30);
                break;
            }
            case 2: 
            case 3: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                break;
            }
            case 5: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                if (!bl) break;
                this.Gin_SafeDiscard(4, this.hand, this.meldPlay);
                break;
            }
            case 6: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                if (!bl) break;
                this.Gin_SafeDiscard(10, this.hand, this.meldPlay);
                break;
            }
            case 10: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                if (!bl) break;
                this.Gin_SafeDiscard(8, this.hand, this.meldPlay);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                if (!bl) break;
                this.Gin_SafeDiscard(5 + this.rankPlayer / 4, this.hand, this.meldPlay);
                break;
            }
            case 12: {
                this.Gin_Discard_ByMelds(this.GetGinWeights(), bl);
                if (!bl) break;
                this.Gin_SafeDiscard(10, this.hand, this.meldPlay);
                break;
            }
        }
        int n = this.GetHighestScoreGin(this.hand);
        return n;
    }

    public boolean Gin_KnockOption() {
        boolean bl = this.Gin_KnockOption_ByMelds();
        switch (this.playerType) {
            case 6: {
                bl = this.Gin_GoForGin(10, bl);
                break;
            }
            case 9: {
                bl = this.Gin_GoForGin(2, bl);
                break;
            }
        }
        return bl;
    }

    public void Gin_MeldDefine(boolean bl) {
        this.SetGinParams(4);
        if (this.ginFirstPass) {
            this.ginFirstPass = false;
            this.Gin_InitOrder();
            this.FindMelds(this.handKnock, this.meldKnock, 3, 0, this.gp_MeldTriesKnock + 2);
        }
        if (!bl) {
            this.FindMelds(this.handKnock, this.meldKnock, 3, 0, this.gp_MeldTriesKnock);
            this.FilterEmoticon(7, 70);
            this.FilterEmoticon(6, 40);
        } else {
            this.FilterEmoticon(1, 50);
        }
        this.engineParent.PushPlayerData(131072, this.meInRef, this.handKnock);
        this.engineParent.PushPlayerData(262144, this.meInRef, this.meldKnock);
    }

    private int Gin_TakeCard_ByMelds() {
        int n;
        int n2;
        int n3;
        int n4;
        this.engineParent.ValidateMelds(this.hand, this.meldPlay, this.gp_MeldGap, this.gp_MinMeld);
        byte by = this.engineParent.pile[0];
        this.cardTakenDiscard = (byte)-1;
        byte by2 = -1;
        this.meldPlay[10] = 0;
        this.SetGinParams(0);
        int n5 = -1;
        int n6 = 0;
        boolean bl = false;
        if (this.gp_OverRideForKnock) {
            this.deadWood = this.engineParent.GinCalcDeadWood(this.handKnock, this.meldKnock, false);
            if (this.deadWood <= 20) {
                n4 = CardUtils.DecodeCard(by) + 1;
                if (n4 > 10) {
                    n4 = 10;
                }
                n3 = 0;
                for (n2 = 0; n2 < 10; ++n2) {
                    if (this.meldKnock[n2] != 0) continue;
                    n = CardUtils.DecodeCard(this.handKnock[n2]) + 1;
                    if (n > 10) {
                        n = 10;
                    }
                    if (n <= n3) continue;
                    n3 = n;
                }
                if (this.deadWood - n3 + n4 <= 10) {
                    ++n6;
                    bl = true;
                }
                if (n4 < n3) {
                    n6 += (n3 - n4) * (10 + this.rankPlayer * 4);
                }
            }
        }
        if ((n5 = this.GinMeldTo(this.hand, this.meldPlay, by, this.gp_MeldToTries, this.gp_MeldGap, this.gp_MinMeldMatchDiscard, this.gp_MeldLowest, this.gp_SrchConistent)) >= 0) {
            n6 += 100;
        }
        if (n5 < 0 && this.gp_CrossCheckTake) {
            if (this.engineParent.GetFitToGroupGin(by, this.hand, -1) >= 0) {
                n6 += 40;
            }
            if (this.engineParent.GetFitToRunGin(by, this.hand, this.gp_MeldGap, -1) >= 0) {
                n6 += 40;
            }
        }
        if (n6 <= 0) {
            return 0;
        }
        if (n5 >= 0) {
            by2 = this.hand[n5];
        }
        for (n2 = 0; n2 < 11; ++n2) {
            this.meldKnock[n2] = this.meldPlay[n2];
            this.handKnock[n2] = this.hand[n2];
        }
        this.hand[10] = by;
        if (n5 >= 0) {
            this.meldPlay[10] = this.meldPlay[n5];
        }
        if (this.hand[n4 = this.Gin_DiscardCard2(false)] == by || this.hand[n4] == by2) {
            n6 = 0;
        }
        if (bl) {
            this.FilterEmoticon(7, 80);
            this.FilterEmoticon(6, 60);
            this.FilterEmoticon(3, 40);
            this.cardTakenDiscard = by;
            this.meldPlay[10] = 0;
            return 1;
        }
        n4 = CardUtils.FindInCards(by, this.hand, 11);
        if (this.gp_RejectUnmeldedDiscards && this.meldPlay[n4] == 0) {
            n6 = 0;
        }
        if (this.gp_PickCaution > 0 && n6 > 0 && (n = CardUtils.GetNumMatches(this.meldPlay[n4], this.meldPlay, 11)) < 3) {
            n6 += this.GetGinWeights()[15] - 100;
            n6 += 1000 - this.score[n4] >> 2;
            if (this.meldPlay[n4] == 0) {
                n6 >>= 3;
            }
            n6 = n6 * 5 / (5 + this.gp_PickCaution);
            n3 = 300;
            if (this.RandX(n3) > n6) {
                n6 = 0;
            }
        }
        for (n2 = 0; n2 < 11; ++n2) {
            this.meldPlay[n2] = this.meldKnock[n2];
            this.hand[n2] = this.handKnock[n2];
        }
        if (n6 > 0) {
            this.FilterEmoticon(3, 20);
            this.FilterEmoticon(6, 50);
        } else {
            this.FilterEmoticon(4, 50);
        }
        if (n6 > 0) {
            this.cardTakenDiscard = by;
            this.meldPlay[10] = 0;
            if (n5 >= 0) {
                this.meldPlay[10] = this.meldPlay[n5];
            }
            return 1;
        }
        return 0;
    }

    private void Gin_Discard_ByMelds(short[] sArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = 10;
        if (this.cardTakenDiscard != -1) {
            n4 = CardUtils.FindInCards(this.cardTakenDiscard, this.hand, 11);
        }
        if (n4 < 0) {
            n4 = 10;
        }
        byte by = this.hand[n4];
        for (n3 = 0; n3 < 11; ++n3) {
            if (n3 == n4) {
                this.ginTemp2[n3] = -1;
                this.ginTemp3[n3] = 0;
                continue;
            }
            this.ginTemp2[n3] = this.hand[n3];
            this.ginTemp3[n3] = this.meldPlay[n3];
        }
        this.SetGinParams(1);
        if (n4 == 10) {
            n2 = 0;
            if (this.meldPlay[10] == 0 && (n2 = this.GinMeldTo(this.hand, this.meldPlay, this.hand[10], this.gp_MeldToTries, this.gp_MeldGap, this.gp_MinMeld, this.gp_MeldLowest, false)) >= 0 && this.meldPlay[n2] > 0) {
                this.meldPlay[10] = this.meldPlay[n2];
            }
            if (n2 >= 0) {
                this.FindMelds(this.hand, this.meldPlay, this.gp_MinMeld, this.gp_MeldGap, this.gp_FindMeldTries);
            }
        }
        this.SetGinParams(5);
        for (n = 0; n < 11; ++n) {
            this.ginTemp[n] = this.meldPlay[n];
        }
        for (n3 = 0; n3 < 11; ++n3) {
            n2 = this.hand[n3];
            this.hand[n3] = -1;
            this.meldPlay[n3] = 0;
            this.score[n3] = this.engineParent.GinHandScore(this.hand, this.meldPlay, this.ginTemp2, this.ginTemp3, sArray, this.gp_MinMeld, this.gp_MeldGap, false, this);
            int n5 = n3;
            this.score[n5] = this.score[n5] + this.RandX(5 + (10 - this.rankPlayer) * 3);
            this.hand[n3] = n2;
            for (n = 0; n < 11; ++n) {
                this.meldPlay[n] = this.ginTemp[n];
            }
            if (this.hand[n3] == this.cardTakenDiscard) {
                int n6 = n3;
                this.score[n6] = this.score[n6] - (20 + this.RandX(100));
                continue;
            }
            if (this.hand[n3] != by || this.meldPlay[n3] != 0) continue;
            int n7 = n3;
            this.score[n7] = this.score[n7] + this.RandX(8);
        }
        this.NormScore(900, -900);
        if (bl || this.gp_OverRideForKnock && this.rankPlayer > 8) {
            int n8 = 59 + this.rankPlayer * 4;
            if (this.gp_OverRideForKnock) {
                n8 = 700 + n8 >> 3;
            }
            if (this.RandX(100) < n8) {
                int n9;
                for (n3 = 0; n3 < 11; ++n3) {
                    this.meldKnock[n3] = this.meldPlay[n3];
                    this.handKnock[n3] = this.hand[n3];
                }
                if (this.gp_TakeKnockFullTest) {
                    n9 = 2 * this.gp_MeldTriesKnock / 4;
                    n9 = n9 * (3 + this.rankPlayer) / 13;
                    this.SetGinParams(6);
                    this.FindMelds(this.handKnock, this.meldKnock, 3, 0, n9);
                } else {
                    this.engineParent.ValidateMelds(this.handKnock, this.meldKnock, 0, 3);
                }
                this.deadWood = this.engineParent.GinCalcDeadWood(this.handKnock, this.meldKnock, false);
                if (this.deadWood <= 20) {
                    n9 = 100;
                    int n10 = -1;
                    for (n3 = 0; n3 < 10; ++n3) {
                        if (this.meldPlay[n3] != 0) continue;
                        n = CardUtils.DecodeCard(this.hand[n3]) + 1;
                        if (n > 10) {
                            n = 10;
                        }
                        if ((n = this.deadWood - n) > 10 || n >= n9) continue;
                        n9 = n;
                        n10 = n3;
                    }
                    if (n10 >= 0) {
                        this.NormScore(0, -1000);
                        this.UpdateScore(n3, 1000, 900);
                    }
                }
            }
        }
    }

    private boolean Gin_KnockOption_ByMelds() {
        this.SetGinParams(6);
        for (int i = 0; i < 11; ++i) {
            this.handKnock[i] = this.hand[i];
            this.meldKnock[i] = this.meldPlay[i];
        }
        this.FindMelds(this.handKnock, this.meldKnock, 3, 0, this.gp_MeldTriesKnock);
        this.deadWood = this.engineParent.GinCalcDeadWood(this.handKnock, this.meldKnock, false);
        if (this.deadWood <= this.gp_KnockDeadWood) {
            this.FilterEmoticon(7, 50);
            this.FilterEmoticon(2, 50);
            return true;
        }
        if (this.deadWood < 16) {
            this.FilterEmoticon(8, 50);
        }
        return false;
    }

    private int GinMeldTo(byte[] byArray, byte[] byArray2, byte by, int n, int n2, int n3, int n4, boolean bl) {
        int n5 = -1;
        int n6 = 0;
        if (n < 2) {
            n = 2;
        }
        int n7 = this.RandX(2);
        int n8 = -1;
        int n9 = -1;
        do {
            if (n6 % 2 == n7) {
                n5 = this.engineParent.GetFitToGroupGin(by, byArray, n8);
                if (bl) {
                    n8 = n5;
                }
                if (n5 >= 0 && this.engineParent.IsMeldRun(byArray2[n5], byArray, byArray2)) {
                    n5 = -1;
                }
            } else {
                n5 = this.engineParent.GetFitToRunGin(by, byArray, n2, n9);
                if (bl) {
                    n9 = n5;
                }
                if (n5 >= 0 && this.engineParent.IsMeldGroup(byArray2[n5], byArray, byArray2)) {
                    n5 = -1;
                }
            }
            if (n5 > -1 && byArray[n5] == by) {
                n5 = -1;
            }
            if (n5 > -1 && byArray2[n5] < n4) {
                n5 = -1;
            }
            if (n5 > -1 && CardUtils.GetNumMatches(byArray2[n5], byArray2, 11) < n3) {
                n5 = -1;
            }
            if (n5 < 0) continue;
            return n5;
        } while (n6++ < n);
        return -1;
    }

    boolean Gin_GoForGin(int n, boolean bl) {
        if (!bl) {
            return bl;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 10; ++i) {
            byte by;
            if (i == 0 || this.meldKnock[i - 1] != this.meldKnock[i]) {
                ++n5;
            }
            if (this.meldKnock[i] == 0) {
                ++n3;
                if (this.engineParent.GetFitToGroupGin(this.handKnock[i], this.handKnock, -1) >= 0) {
                    n2 += 5;
                }
                if (this.engineParent.GetFitToRunGin(this.handKnock[i], this.handKnock, 0, -1) < 0) continue;
                n2 += 5;
                continue;
            }
            int n6 = CardUtils.GetNumMatches(this.meldKnock[i], this.meldKnock, 11);
            if (this.engineParent.IsMeldGroup(this.meldKnock[i], this.handKnock, this.meldKnock)) {
                if (i != 0 && this.meldKnock[i - 1] == this.meldKnock[i]) continue;
                if (n6 == 4) {
                    n4 += 3;
                    continue;
                }
                by = CardUtils.DecodeCard(this.handKnock[i]);
                n4 += this.engineParent.GetNumCardPlayed(by, this);
                continue;
            }
            by = CardUtils.DecodeCard(this.handKnock[i]);
            byte by2 = CardUtils.DecodeSuit(this.handKnock[i]);
            if (!(i != 0 && this.meldKnock[i - 1] == this.meldKnock[i] || by != 0 && !this.engineParent.GetCardPlayed(CardUtils.EncodePack(by2, (byte)(by - 1)), this))) {
                n4 += 2;
            }
            if (!(i != 10 && this.meldKnock[i + 1] == this.meldKnock[i] || by != 12 && !this.engineParent.GetCardPlayed(CardUtils.EncodePack(by2, (byte)(by + 1)), this))) {
                n4 += 2;
            }
            if (i != 0 && this.meldKnock[i - 1] == this.meldKnock[i] || n6 <= 4) continue;
            ++n4;
        }
        n2 += 50 + n * 12;
        if (this.bKnockSuppress) {
            n2 += 40;
        }
        n2 -= this.deadWood * 4;
        n2 += n5 * 7;
        n2 -= (n3 - 1) * n3 * 4;
        if ((n2 = n2 * 2 / (2 + n4)) < 10) {
            n2 = 10;
        }
        if (n2 > 190) {
            n2 = 190;
        }
        this.bKnockSuppress = false;
        if (this.RandX(200) < n2) {
            bl = false;
            this.bKnockSuppress = true;
            this.FilterEmoticon(5, 50);
        }
        return bl;
    }

    void Gin_SafeDiscard(int n, byte[] byArray, byte[] byArray2) {
        int n2 = this.meInRef == 0 ? 1 : 0;
        for (int i = 0; i < 11; ++i) {
            byte by;
            byte by2 = CardUtils.DecodeSuit(byArray[i]);
            int n3 = CardUtils.DecodeCard(byArray[i]);
            int n4 = 80 + n * 15;
            int n5 = 50 + n * 20;
            int n6 = 0;
            int n7 = 0;
            if (n > 4) {
                if (n3 > 1 && this.engineParent.GetWasCardPickedBy(n2, by = CardUtils.EncodePack(by2, (byte)(n3 - 2)), this)) {
                    n6 -= n4 >> 3;
                    ++n7;
                }
                if (n3 < 11 && this.engineParent.GetWasCardPickedBy(n2, by = CardUtils.EncodePack(by2, (byte)(n3 + 2)), this)) {
                    n6 -= n4 >> 3;
                    ++n7;
                }
            }
            if (n3 > 0) {
                by = CardUtils.EncodePack(by2, (byte)(n3 - 1));
                if (this.engineParent.GetWasCardPlayedBy(n2, by, this)) {
                    n6 += n5 / (1 + n7);
                } else if (this.engineParent.GetWasCardPickedBy(n2, by, this)) {
                    n6 -= n4 * (1 + n7);
                } else if (this.engineParent.GetCardPlayed(by, this)) {
                    n6 += n5 >> 1;
                }
            }
            if (n3 < 12) {
                by = CardUtils.EncodePack(by2, (byte)(n3 + 1));
                if (this.engineParent.GetWasCardPlayedBy(n2, by, this)) {
                    n6 += n5 / (1 + n7);
                } else if (this.engineParent.GetWasCardPickedBy(n2, by, this)) {
                    n6 -= n4 * (1 + n7);
                } else if (this.engineParent.GetCardPlayed(by, this)) {
                    n6 += n5 >> 1;
                }
            }
            for (byte by3 = 0; by3 < 4; by3 = (byte)(by3 + 1)) {
                if (by3 == by2) continue;
                by = CardUtils.EncodePack(by3, (byte)n3);
                if (this.engineParent.GetWasCardPlayedBy(n2, by, this)) {
                    n6 += n5;
                    continue;
                }
                if (this.engineParent.GetWasCardPickedBy(n2, by, this)) {
                    n6 -= n4;
                    continue;
                }
                if (!this.engineParent.GetCardPlayed(by, this)) continue;
                n6 += n5 >> 1;
            }
            if (n > 5 && byArray2[i] > 0 && n6 > 0) {
                n7 = CardUtils.GetNumMatches(byArray2[i], byArray2, 11);
                n6 = n7 >= 3 ? n6 * 10 / (10 + n7 * n) : n6 * 40 / (40 + n);
            }
            if (n6 > 0) {
                if (n > 7) {
                    if ((n3 = (byte)(n3 + 1)) > 10) {
                        n3 = 10;
                    }
                    n6 = n6 * 100 / (100 + n3 * 3);
                }
                this.UpdateScore(i, 1000, n6);
                continue;
            }
            this.UpdateScore(i, -1000, -n6);
        }
    }

    public int CheckEmoticon(int n, int n2) {
        int n3;
        int n4;
        if (this.playerType <= 0 || this.playerType > 12) {
            return -1;
        }
        for (n4 = 0; n4 < 8; ++n4) {
            this.score[n4] = n2 == this.meInRef ? emoteMeDid[n][n4] : emoteOppDid[n][n4];
        }
        int n5 = 50;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n5 = 25;
                if (this.gameType != 3 || this.RandX(10) >= 4) break;
                int n6 = this.GinMeldTo(this.hand, this.meldPlay, this.engineParent.pile[0], this.gp_MeldToTries >> 1, this.gp_MeldGap, this.gp_MinMeld, this.gp_MeldLowest, this.gp_SrchConistent);
                if (n6 >= 0) {
                    this.score[8] = this.score[8] + 20;
                    this.score[7] = this.score[7] + 30;
                    break;
                }
                this.score[6] = this.score[6] + 10;
                this.score[4] = this.score[4] + 10;
                this.score[5] = this.score[5] + 5;
                break;
            }
            case 2: {
                if (this.gameType != 3 || this.RandX(10) >= 4) break;
                int n7 = this.GinMeldTo(this.hand, this.meldPlay, this.engineParent.cardDrawnDiscard, this.gp_MeldToTries >> 1, this.gp_MeldGap, this.gp_MinMeld, this.gp_MeldLowest, this.gp_SrchConistent);
                if (n7 >= 0) {
                    this.score[4] = this.score[4] + 30;
                    this.score[3] = this.score[3] + 10;
                    this.score[1] = this.score[1] + 20;
                    this.score[8] = this.score[8] + 20;
                    break;
                }
                this.score[7] = this.score[7] + 20;
                this.score[6] = this.score[6] + 10;
                break;
            }
            case 3: {
                n5 = 35;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                n5 = 90;
                break;
            }
            case 7: {
                n5 = 90;
                break;
            }
            case 8: {
                n5 = 70;
                break;
            }
            case 9: {
                n5 = 90;
                break;
            }
            case 10: {
                n5 = 100;
                break;
            }
            case 11: {
                n5 = 100;
                break;
            }
            case 12: {
                n5 = 100;
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                n5 = 40;
                byte[] byArray = new byte[3];
                for (n4 = 0; n4 < 3; ++n4) {
                    byArray[n4] = this.handRef[12 - n4];
                }
                if (CardUtils.FindInCards(CafeCardsDefs.QUEEN_SPADES, byArray, 3) >= 0) {
                    this.score[6] = this.score[6] + 10;
                    this.score[4] = this.score[4] + 30;
                    this.score[3] = this.score[3] + 10;
                    this.score[1] = this.score[1] + 20;
                }
                n3 = 0;
                for (n4 = 0; n4 < 3; ++n4) {
                    n3 += CardUtils.DecodeCardAH(byArray[n4]);
                }
                if (n3 < 20) {
                    this.score[6] = this.score[6] + 20;
                    this.score[2] = this.score[2] + 20;
                    this.score[8] = this.score[8] + 30;
                    break;
                }
                if (n3 <= 30) break;
                this.score[4] = this.score[4] + 30;
                this.score[5] = this.score[5] + 20;
                this.score[1] = this.score[1] + 20;
                break;
            }
            case 15: {
                n5 = 30;
                if (this.gameType == 1) {
                    this.gotQueenSpades = CardUtils.FindInCards(CafeCardsDefs.QUEEN_SPADES, this.hand, 13) >= 0;
                    CardUtils.CountCardsNSuits(this.hand, 13, this.countCards, this.countSuits);
                    if (this.gotQueenSpades) {
                        this.score[4] = this.score[4] + 30;
                        this.score[3] = this.score[3] + 10;
                        this.score[1] = this.score[1] + 20;
                    }
                    if (this.countSuits[3] > 3) {
                        this.score[4] = this.score[4] + 10;
                        this.score[1] = this.score[1] + 20;
                    }
                    if (this.countSuits[3] < 2) {
                        this.score[4] = this.score[4] - 10;
                        this.score[1] = this.score[1] - 20;
                        this.score[7] = this.score[7] + 20;
                        this.score[6] = this.score[6] + 10;
                    }
                    if (this.gotQueenSpades && this.countSuits[3] > 2 && this.countCards[13] + this.countCards[12] > 2) {
                        this.score[6] = this.score[6] + 40;
                        this.score[2] = this.score[2] + 30;
                        this.score[8] = this.score[8] + 30;
                    }
                    for (n4 = 0; n4 < 4; ++n4) {
                        if (this.GetHighestOfSuit((byte)n4, false) < 9) {
                            this.score[7] = this.score[7] + 6;
                        }
                        if (this.countSuits[n4] != 0) continue;
                        this.score[7] = this.score[7] + 6;
                    }
                    break;
                }
                if (this.gameType == 2) {
                    CardUtils.CountCardsNSuits(this.hand, 13, this.countCards, this.countSuits);
                    if (this.countSuits[0] > 3) {
                        this.score[7] = this.score[7] + 20;
                        this.score[2] = this.score[2] + 20;
                    }
                    if (this.countCards[13] > 2) {
                        this.score[7] = this.score[7] + 20;
                        this.score[8] = this.score[8] + 20;
                    }
                    if (this.countCards[12] > 2) {
                        this.score[7] = this.score[7] + 10;
                        this.score[8] = this.score[8] + 5;
                    }
                    n3 = 0;
                    for (n4 = 0; n4 < 4; ++n4) {
                        if (this.GetHighestOfSuit((byte)n4, false) >= 10) continue;
                        ++n3;
                    }
                    if (n3 <= 2) break;
                    this.score[7] = this.score[7] + 10;
                    this.score[6] = this.score[6] + 30;
                    break;
                }
                if (this.gameType != 3) break;
                CardUtils.CountCardsNSuits(this.hand, 11, this.countCards, this.countSuits);
                n3 = 0;
                for (n4 = 0; n4 <= 12; ++n4) {
                    if (this.countCards[n4] > 1) {
                        ++n3;
                    }
                    if (this.countCards[n4] != 4) continue;
                    this.score[7] = this.score[7] + 20;
                    this.score[2] = this.score[2] + 50;
                }
                for (n4 = 0; n4 < 4; ++n4) {
                    if (this.countSuits[n4] <= 3) continue;
                    ++n3;
                }
                if (n3 == 0) {
                    this.score[4] = this.score[4] + 30;
                    this.score[3] = this.score[3] + 5;
                    this.score[1] = this.score[1] + 20;
                    this.score[8] = this.score[8] + 10;
                }
                if (n3 <= 2) break;
                this.score[7] = this.score[7] + 30;
                this.score[8] = this.score[8] + 10;
                break;
            }
            case 16: {
                n5 = 30;
                if (n2 == this.meInRef) {
                    if (this.engineParent.trickBid[this.meInRef] == 0) {
                        this.score[7] = this.score[7] + 20;
                        this.score[5] = this.score[5] + 20;
                        this.score[6] = this.score[6] + 30;
                    }
                    if (this.engineParent.trickBid[this.meInRef] <= 5) break;
                    this.score[7] = this.score[7] + 20;
                    this.score[6] = this.score[6] + 20;
                    this.score[1] = this.score[1] + 20;
                    break;
                }
                if (this.engineParent.trickBid[this.meInRef] == 0) {
                    this.score[1] = this.score[1] + 20;
                    this.score[5] = this.score[5] + 20;
                    this.score[6] = this.score[6] + 20;
                    this.score[2] = this.score[2] + 20;
                }
                if (this.engineParent.trickBid[this.meInRef] <= 5) break;
                this.score[8] = this.score[8] + 20;
                this.score[6] = this.score[6] + 20;
                this.score[1] = this.score[1] + 20;
                this.score[2] = this.score[2] + 20;
                break;
            }
            case 17: {
                n5 = 70;
            }
        }
        if (this.gameType == 3) {
            n5 = n5 + 100 >> 1;
        }
        if (this.RandX(100) > n5) {
            return -1;
        }
        for (n4 = 0; n4 < 8; ++n4) {
            n3 = emotePlayerFac[this.playerType - 1][n4];
            if (this.score[n4] == 0) continue;
            if (n3 < 0) {
                n3 = 100 + n3;
                this.score[n4] = n3 * this.score[n4] / 100;
                continue;
            }
            if (n3 > 90) {
                n3 = 90;
            }
            this.score[n4] = (n3 * 100 + (100 - n3) * this.score[n4]) / 100;
        }
        int n8 = 0;
        int n9 = this.RandX(20);
        n5 = 200;
        if (this.gameType == 3) {
            n5 = 150;
        }
        for (n4 = 0; n4 < 8; ++n4) {
            int n10;
            if (this.RandX(n5) >= this.score[n4] || (n10 = this.score[n4] + this.RandX(150)) <= n9) continue;
            n9 = n10;
            n8 = n4;
        }
        return n8;
    }

    private void FilterEmoticon(int n, int n2) {
        if (this.playerType <= 0 || this.playerType > 12) {
            return;
        }
        if (this.RandX(300) < (n2 += emotePlayerFac[this.playerType - 1][n - 1])) {
            this.engineParent.PushEmoticon(n, this.meInRef);
        }
    }

    String StringGinHandPlay(boolean bl) {
        if (bl) {
            return CafeCardsEngine.StringGinHand(this.handKnock, this.meldKnock, 11);
        }
        return CafeCardsEngine.StringGinHand(this.hand, this.meldPlay, 11);
    }
}

