/*
 * Decompiled with CFR 0.152.
 */
public class CafeCardsEngine
extends CafeCardsAIUtils
implements CC_BuildConfig {
    static int engInstance = 0;
    int thisInstance = -1;
    static final int CC_CONFIG_NORMAL = 0;
    static final int CC_CONFIG_COPYSTORE = 1;
    protected int configuration = 0;
    public int localPlayer = 0;
    public String strEngineName = "ENGINE";
    boolean bBOTmode = false;
    protected int ginPointsMatch = 100;
    protected int ginGinBonus = 25;
    protected int ginUnderCutBonus = 25;
    protected int ginMaxHands = 9999;
    protected int heartsPointsMatch = 100;
    protected int heartsShootBonus = 26;
    protected int heartsMaxHands = 9999;
    protected int heartsQSPenalty = 13;
    protected int spadesPointsMatch = 500;
    protected int spadesNilBonus = 100;
    protected int spadesOverBidPenalty = 100;
    protected int spadesBagsFactor = 1;
    protected int spadesBagsToPenalise = 10;
    protected int spadesMaxHands = 9999;
    static String strCheatCode = " ";
    protected int gameType = 0;
    protected int gameDifficulty = 5;
    public int numPlayers;
    public int numPlayersCreated;
    int numCardsHand;
    public int currentGameState;
    int playerFocus;
    int dealButton;
    int currentRound;
    int nextGameState;
    int trickButton;
    byte[] pile;
    int numInPile;
    boolean trumpBroken;
    int numHands = 0;
    int numPlaysDemo = 0;
    int lastGameState;
    protected CafeCardsEngine engLastState = null;
    CafeCardsPlayer[] player = null;
    int[] playerType = null;
    protected byte[][] playerHand = null;
    byte[][] changeHand = null;
    int[] pointsGame = null;
    int[] pointsMatch = null;
    int[] playerData = null;
    int[] pdContext = null;
    protected byte[][] meldData = null;
    int[] trickBid = null;
    int[] teamPoints = null;
    int[] teamBags = null;
    int[] teamGameScore = null;
    protected byte[] tmpHand = null;
    protected byte[] tmpInfo = null;
    int numShootMoon = 0;
    CafeCardsPlayer proxyHuman = null;
    protected int command = 0;
    protected int cmdValue = 0;
    protected boolean bCommandRdy = false;
    protected boolean bClientAct = false;
    static final int EVENT_QUEUE_SIZE = 24;
    protected int[] eventQ = null;
    protected int[] data1Q = null;
    protected int[] data2Q = null;
    protected int eventQueueTop = 0;
    int numEmotes = 0;
    static final String[] cheatCodes = new String[]{"7701991", "7702992", "7703993", "7704994", "5522901", "5522902", "8081771", "8082772", "8083773", "8084774", "1844405", "2844405", "1836403", "2836403"};
    static final byte[][] cheatSet = new byte[][]{{0, 13, 26, 39, 1, 14, 27, 40, 2, 15, 28, 41, 3, 16, 29, 42, 4, 17, 30, 43, 5, 18, 31, 44, 6, 19, 32, 45, 7, 20, 33, 46, 8, 21, 34, 47, 9, 22, 35, 48, 10, 23, 36, 49, 11, 24, 37, 50, 12, 25, 38, 51}, {0, 13, 26, 39, 1, 14, 27, 11, 2, 15, 28, 41, 3, 16, 29, 42, 4, 17, 30, 43, 5, 18, 31, 44, 6, 19, 32, 45, 7, 20, 33, 46, 8, 21, 34, 47, 9, 22, 35, 48, 10, 23, 36, 49, 40, 24, 37, 50, 12, 25, 38, 51}, {13, 0, 26, 14, 39, 1, 51, 40, 50, 48, 2, 41, 38, 47, 49, 42, 35, 46, 44, 31, 5, 45, 43, 30, 6, 19, 32, 18, 21, 20, 33, 17, 22, 7, 34, 16, 9, 8, 4, 15, 10, 23, 36, 29, 11, 24, 37, 28, 25, 23, 3, 27}, {38, 13, 36, 39, 37, 14, 27, 40, 12, 10, 34, 41, 3, 16, 29, 42, 4, 17, 30, 43, 9, 18, 31, 44, 6, 19, 32, 45, 7, 20, 33, 46, 8, 21, 28, 47, 5, 22, 35, 48, 15, 23, 26, 49, 11, 24, 1, 50, 2, 25, 0, 51}, {38, 37, 8, 35, 34, 46, 33, 36, 2, 15, 28, 4, 12, 11, 10, 9, 4, 17, 30, 43, 5, 18, 31, 44, 6, 19, 32, 45, 41, 40, 27, 14, 20, 21, 1, 47, 42, 22, 39, 48, 29, 23, 26, 49, 16, 24, 13, 50, 3, 25, 0, 51}};
    static final int CHEAT_SET_ALLSUIT = 3;
    static final int CHEAT_SET_SHOOTSET = 5;
    static final int CHEAT_SET_SPADESNIL = 9;
    static final int CHEAT_SET_GINGIN = 11;
    static final int CHEAT_SET_GINUNDERCUT = 13;
    long showSeed = 0L;
    int numNilBonus = 0;
    int numBagPenalty = 0;
    boolean bGameDeadlocked;
    int numSubmissions = 0;
    byte cardDrawnDiscard = (byte)-1;
    int numGinScored = 0;
    int numUndercut = 0;
    static final int GIN_MELD_INVALID = 9999;
    public int controlFlags = 0;
    public static final int CFLAG_NONE = 0;
    public static final int CFLAG_VERBOSE_BRIEF = 1;
    public static final int CFLAG_VERBOSE = 3;
    public static final int CFLAG_AITEST = 4;
    public static final int CFLAG_AITEST_FIXDEALER = 8;
    public static final int CFLAG_AITEST_CHKCONSISTENT = 16;
    private static final String[] strHeartsState = new String[]{"GAMESTATE_NONE", "GAMESTATE_HEARTS_DEAL", "GAMESTATE_HEARTS_CARDCHANGE_SELECT", "GAMESTATE_HEARTS_CARDCHANGE_EXECUTE", "GAMESTATE_HEARTS_OPENWITH_2CLUBS", "GAMESTATE_HEARTS_CARDPLAY", "GAMESTATE_HEARTS_ENDTRICK", "GAMESTATE_HEARTS_REVEAL", "GAMESTATE_HEARTS_CONSOLIDATE", "GAMESTATE_HEARTS_GAMEDONE", "GAMESTATE_HEARTS_MATCHDONE"};
    private static final String[] strGinState = new String[]{"GAMESTATE_NONE", "GAMESTATE_GIN_DEAL", "GAMESTATE_GIN_FIRSTDISCARD", "GAMESTATE_GIN_TAKECARD", "GAMESTATE_GIN_DISCARD_KNOCK", "GAMESTATE_GIN_MELD_IDENTIFY", "GAMESTATE_GIN_LAYOFF", "GAMESTATE_GIN_REVEAL", "GAMESTATE_GIN_CONSOLIDATE", "GAMESTATE_GIN_GAMEDONE", "GAMESTATE_GIN_MATCHDONE"};
    private static final String[] strSpadesState = new String[]{"GAMESTATE_NONE", "GAMESTATE_SPDS_DEAL", "GAMESTATE_SPDS_BIDDING", "GAMESTATE_SPDS_CARDPLAY", "GAMESTATE_SPDS_ENDTRICK", "GAMESTATE_SPDS_REVEAL", "GAMESTATE_SPDS_CONSOLIDATE", "GAMESTATE_SPDS_GAMEDONE", "GAMESTATE_SPDS_MATCHDONE"};
    private static final String[] strEventNames = new String[]{"EVENT_NONE", "EVENT_DEAL", "EVENT_RESULTS", "EVENT_GAMEDONE", "EVENT_MATCHDONE", "EVENT_PAUSE_UNTIL_RDY", "EVENT_HINT", "EVENT_CARDPLAYED", "EVENT_ENDTRICK", "EVENT_TRUMPBROKEN", "EVENT_MELDSUBMITILLEGAL", "EVENT_MELDSUBMITFAIL", "EVENT_MELDSUBMITFAIL_ALLDEAD", "EVENT_DEADLOCKED", "EVENT_GINTAKECARD", "EVENT_GINDISCARD", "EVENT_KNOCK", "EVENT_SHOWMELDS", "EVENT_MELDSUBMITOK", "EVENT_UNDERCUT", "EVENT_GINRUMMY", "EVENT_FORCETAKESTOCK", "EVENT_HRTSRDYSWAP", "EVENT_HRTSSWAPSEL", "EVENT_HRTSSWAP", "EVENT_SHOOTMOON", "EVENT_BIDMADE", "EVENT_NILBIDFAIL", "EVENT_NILBIDMADE", "EVENT_BAGGINGPENALTY", "EVENT_EMOTICON", "EVENT_MP_SEND", "EVENT_PLAYER_LEAVE", "EVENT_PLAYER_JOIN ", "EVENT_MATCHDONE_QUITCONNECT"};
    private static final int[] strEventCodes = new int[]{0, 1, 2, 3, 4, 5, 6, 50, 51, 52, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 200, 201, 202, 205, 300, 301, 302, 303, 998};
    private static final String[] strCCMsgSvr = new String[]{"CC_GAMEMSG_UNKNOWN", "CC_GAMEMSG_SVR_INIT_MATCH", "CC_GAMEMSG_SVR_GIN_STATECHANGE", "CC_GAMEMSG_SVR_HEARTS_STATECHANGE", "CC_GAMEMSG_SVR_SPADES_STATECHANGE", "CC_GAMEMSG_CL_PLAYERREADY", "CC_GAMEMSG_CL_GIN_PLAYER_MOVE", "CC_GAMEMSG_CL_GIN_SUBMITMELDS", "CC_GAMEMSG_CL_HEARTS_PLAYER_MOVE", "CC_GAMEMSG_CL_SPADES_PLAYER_MOVE", "CC_SYSMSG_SVR_AVATAR", "CC_SYSMSG_SVR_ERR", "CC_SYSMSG_SVR_AVATARLIST", "CC_SYSMSG_SVR_STATSDATA", "CC_SYSMSG_SVR_BOTSWAP", "CC_SYSMSG_CL_GETAVATARIMGS", "CC_SYSMSG_CL_REQAVATAR", "CC_SYSMSG_CL_REQAVATARLIST", "CC_SYSMSG_CL_AVATARCONFIRM", "CC_SYSMSG_CL_REQSTATS", "CC_SYSMSG_CL_GAMETYPES", "CC_SYSMSG_CL_REQNEWS"};
    private static final int[] typeCCMsgClt = new int[]{0, 1, 3, 4, 5, 100, 102, 103, 104, 105, 1000, 1001, 1002, 1003, 1004, 1100, 1101, 1102, 1103, 1104, 1105, 1106};

    public byte GetPlayerHand(int n, int n2) {
        return this.playerHand[n][n2];
    }

    public byte GetPlayerMeld(int n, int n2) {
        return this.meldData[n][n2];
    }

    public byte[] GetPlayerHand(int n) {
        return this.playerHand[n];
    }

    public byte[] GetPlayerMeld(int n) {
        return this.meldData[n];
    }

    protected CafeCardsEngine() {
    }

    public CafeCardsEngine(int n, int n2) {
        this.Debug_Message(this, "CLASS_ID=CafeCardsEngine instantiating");
        this.InitEngine(n, 0, n2);
        this.thisInstance = engInstance++;
    }

    protected CafeCardsEngine(int n, int n2, int n3) {
        this.Debug_Message(this, "CLASS_ID=CafeCardsEngine instantiating using config");
        this.InitEngine(n, n2, n3);
        this.thisInstance = engInstance++;
    }

    protected void InitEngine(int n, int n2, int n3) {
        this.gameType = n;
        this.gameDifficulty = n3;
        this.configuration = n2;
        this.InitUtils(this);
        this.InitObject();
        this.ResetMatch();
    }

    public void InitEngine(int n, int n2) {
        this.InitEngine(n, this.configuration, n2);
    }

    public int getGameDifficulty() {
        return this.gameDifficulty;
    }

    public boolean Tick() {
        if (ShellyCanvas.pShelly.demoModeOn() && this.numPlaysDemo >= 7) {
            this.PushMessage(7, -1, -1);
            return true;
        }
        switch (this.gameType) {
            case 1: {
                return this.TickHearts();
            }
            case 2: {
                return this.TickSpades();
            }
            case 3: {
                return this.TickGin();
            }
        }
        return false;
    }

    public boolean IsMatchDone() {
        switch (this.gameType) {
            case 1: {
                return this.currentGameState == 10;
            }
            case 2: {
                return this.currentGameState == 8;
            }
            case 3: {
                return this.currentGameState == 10;
            }
        }
        return false;
    }

    public boolean IsGameDone() {
        switch (this.gameType) {
            case 1: {
                return this.currentGameState == 9;
            }
            case 2: {
                return this.currentGameState == 7;
            }
            case 3: {
                return this.currentGameState == 9;
            }
        }
        return false;
    }

    public void NewGame() {
        this.NewGameGeneric();
        switch (this.gameType) {
            case 1: {
                this.NewGameHearts();
                this.ClearBlackBoard(CafeCardsAIUtils.BB_HEARTS_RESET);
                break;
            }
            case 2: {
                this.NewGameSpades();
                this.ClearBlackBoard(CafeCardsAIUtils.BB_SPADES_RESET);
                break;
            }
            case 3: {
                this.NewGameGin();
                this.ClearBlackBoard(CafeCardsAIUtils.BB_GIN_RESET);
            }
        }
    }

    public void CreatePlayer(int n, int n2) {
        if (n2 == 0) {
            n2 = this.GetPlayerTypeRand();
        }
        if (n2 > 0) {
            this.player[n] = new CafeCardsPlayer(this, this.gameType, n);
            this.player[n].SetPlayerType(n2, this.gameDifficulty);
        } else if (n2 < 0) {
            this.player[n] = null;
        }
        this.playerType[n] = n2;
        ++this.numPlayersCreated;
    }

    public int GetPlayerTypeRand() {
        boolean bl;
        if (this.gameDifficulty > 10) {
            this.gameDifficulty = 10;
        }
        if (this.gameDifficulty < 0) {
            this.gameDifficulty = 0;
        }
        int n = 0;
        do {
            n = this.RandX(12);
            int n2 = this.RandX(10 + (10 - this.gameDifficulty) * 6);
            int n3 = this.RandX(10 + this.gameDifficulty * 6);
            n = (n * 3 + n2 * 0 + n3 * 12) / (3 + n2 + n3);
            if (++n < 0) {
                n = 0;
            }
            if (n > 12) {
                n = 12;
            }
            bl = true;
            for (n2 = 0; n2 < this.numPlayers; ++n2) {
                bl &= this.playerType[n2] != n;
            }
        } while (!bl);
        return n;
    }

    public void ResetMatch() {
        if (this.gameType == 0) {
            return;
        }
        for (int i = 0; i < this.numPlayers; ++i) {
            this.pointsMatch[i] = 0;
            this.pointsGame[i] = 0;
        }
        this.lastGameState = this.currentGameState;
        this.currentGameState = 0;
        this.numHands = 0;
        this.eventQueueTop = 0;
        this.dealButton = 0;
        if (this.gameType == 3) {
            this.dealButton = 1;
        }
        if (this.gameType == 2) {
            this.teamPoints[1] = 0;
            this.teamPoints[0] = 0;
            this.teamBags[1] = 0;
            this.teamBags[0] = 0;
        }
        this.Serialise();
    }

    public boolean IsLegalCard(int n, int n2) {
        switch (this.gameType) {
            case 1: {
                if (this.currentGameState != 5) {
                    return true;
                }
                return this.IsLegalWhistCard(n2, this.playerHand[n], 13, this.trumpBroken ? -1 : 3);
            }
            case 2: {
                if (this.currentGameState != 3) {
                    return true;
                }
                return this.IsLegalWhistCard(n2, this.playerHand[n], 13, this.trumpBroken ? -1 : 0);
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public int GetGameType() {
        return this.gameType;
    }

    public boolean PushHumanCommand(int n, int n2) {
        this.command = n;
        this.cmdValue = n2;
        this.bCommandRdy = false;
        if (!this.IsHumanPlayersTurn()) {
            this.UsedHumanCmd();
            return false;
        }
        return true;
    }

    protected void UsedHumanCmd() {
        this.command = 0;
        this.cmdValue = 0;
        this.bCommandRdy = true;
    }

    int GetHumanSeat() {
        for (int i = 0; i < this.numPlayers; ++i) {
            if (this.playerType[i] != -1) continue;
            return i;
        }
        return -1;
    }

    public boolean IsHumanPlayersTurn() {
        return this.IsActionState() && this.playerType[this.playerFocus] == -1;
    }

    public boolean IsActionState() {
        boolean bl = false;
        switch (this.gameType) {
            case 1: {
                bl = this.currentGameState == 2;
                bl |= this.currentGameState == 5;
                break;
            }
            case 2: {
                bl = this.currentGameState == 2;
                bl |= this.currentGameState == 3;
                break;
            }
            case 3: {
                bl |= this.currentGameState == 2;
                bl |= this.currentGameState == 3;
                bl |= this.currentGameState == 4;
                bl |= this.currentGameState == 5;
            }
        }
        return bl;
    }

    public boolean PushPlayerData(int n, int n2, byte[] byArray) {
        if (this.gameType == 3) {
            if ((n & this.GinCommandLegal()) == 0) {
                return false;
            }
            if (n == 131072) {
                return this.GinArrangeHand(n2, byArray);
            }
            if (n == 262144 || n == 524288) {
                if (!this.GinSubmitMeld(n2, byArray)) {
                    return false;
                }
                if (n == 262144) {
                    this.command = n;
                    this.cmdValue = 0;
                    this.bCommandRdy = false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean IsPlayerWinner(int n) {
        if (this.pdContext[n] == 4) {
            return true;
        }
        if (this.pdContext[n] == 14) {
            return true;
        }
        return this.pdContext[n] == 10;
    }

    public final int GetGinPointsMatch() {
        return this.ginPointsMatch;
    }

    public final int GetGinGinBonus() {
        return this.ginGinBonus;
    }

    public final int GetGinUnderCutBonus() {
        return this.ginUnderCutBonus;
    }

    public final int GetGinMaxHands() {
        return this.ginMaxHands;
    }

    public final int GetHeartsPointsMatch() {
        return this.heartsPointsMatch;
    }

    public final int GetHeartsShootBonus() {
        return this.heartsShootBonus;
    }

    public final int GetHeartsMaxHands() {
        return this.heartsMaxHands;
    }

    public final int GetHeartsQueenSpades() {
        return this.heartsQSPenalty;
    }

    public final int GetSpadesPointsMatch() {
        return this.spadesPointsMatch;
    }

    public final int GetSpadesNilBonus() {
        return this.spadesNilBonus;
    }

    public final int GetSpadesOverBidPenalty() {
        return this.spadesOverBidPenalty;
    }

    public final int GetSpadesBagsFactor() {
        return this.spadesBagsFactor;
    }

    public final int GetSpadesBagsToPenalise() {
        return this.spadesBagsToPenalise;
    }

    public final int GetSpadesMaxHands() {
        return this.spadesMaxHands;
    }

    public final void SetGinPointsMatch(int n) {
        this.ginPointsMatch = n;
    }

    public final void SetGinGinBonus(int n) {
        this.ginGinBonus = n;
    }

    public final void SetGinUnderCutBonus(int n) {
        this.ginUnderCutBonus = n;
    }

    public final void SetGinMaxHands(int n) {
        this.ginMaxHands = n;
    }

    public final void SetHeartsPointsMatch(int n) {
        this.heartsPointsMatch = n;
    }

    public final void SetHeartsShootBonus(int n) {
        this.heartsShootBonus = n;
    }

    public final void SetQueenSpadesPenalty(int n) {
        this.heartsQSPenalty = n;
    }

    public final void SetHeartsMaxHands(int n) {
        this.heartsMaxHands = n;
    }

    public final void SetSpadesPointsMatch(int n) {
        this.spadesPointsMatch = n;
    }

    public final void SetSpadesNilBonus(int n) {
        this.spadesNilBonus = n;
    }

    public final void SetSpadesOverBidPenalty(int n) {
        this.spadesOverBidPenalty = n;
    }

    public final void SetSpadesBagsFactor(int n) {
        this.spadesBagsFactor = n;
    }

    public final void SetSpadesBagsToPenalise(int n) {
        this.spadesBagsToPenalise = n;
    }

    public final void SetSpadesMaxHands(int n) {
        this.spadesMaxHands = n;
    }

    public CafeCardsEngine GetLastState() {
        return null;
    }

    protected void Serialise() {
    }

    private void SerialiseGeneric(CafeCardsEngine cafeCardsEngine) {
        cafeCardsEngine.currentGameState = this.currentGameState;
        cafeCardsEngine.lastGameState = this.lastGameState;
        cafeCardsEngine.playerFocus = this.playerFocus;
        cafeCardsEngine.dealButton = this.dealButton;
        cafeCardsEngine.trickButton = this.trickButton;
        cafeCardsEngine.currentRound = this.currentRound;
        cafeCardsEngine.numHands = this.numHands;
        cafeCardsEngine.numPlayers = this.numPlayers;
        for (int i = 0; i < this.numPlayers; ++i) {
            cafeCardsEngine.playerType[i] = this.playerType[i];
        }
    }

    private void SerialiseWhist(CafeCardsEngine cafeCardsEngine) {
        for (int i = 0; i < 4; ++i) {
            cafeCardsEngine.pile[i] = this.pile[i];
            cafeCardsEngine.pointsGame[i] = this.pointsGame[i];
            cafeCardsEngine.pointsMatch[i] = this.pointsMatch[i];
            cafeCardsEngine.playerData[i] = this.playerData[i];
            cafeCardsEngine.pdContext[i] = this.pdContext[i];
            for (int j = 0; j < 13; ++j) {
                cafeCardsEngine.playerHand[i][j] = this.playerHand[i][j];
            }
        }
    }

    private void SerialiseGin(CafeCardsEngine cafeCardsEngine) {
        cafeCardsEngine.pile[0] = this.pile[0];
        cafeCardsEngine.pile[1] = this.pile[1];
        for (int i = 0; i < 2; ++i) {
            cafeCardsEngine.pointsGame[i] = this.pointsGame[i];
            cafeCardsEngine.pointsMatch[i] = this.pointsMatch[i];
            cafeCardsEngine.playerData[i] = this.playerData[i];
            cafeCardsEngine.pdContext[i] = this.pdContext[i];
            for (int j = 0; j < 11; ++j) {
                cafeCardsEngine.playerHand[i][j] = this.playerHand[i][j];
                cafeCardsEngine.meldData[i][j] = this.meldData[i][j];
            }
        }
    }

    private void SerialiseSpades(CafeCardsEngine cafeCardsEngine) {
        for (int i = 0; i < 4; ++i) {
            cafeCardsEngine.trickBid[i] = this.trickBid[i];
        }
        cafeCardsEngine.teamPoints[0] = this.teamPoints[0];
        cafeCardsEngine.teamPoints[1] = this.teamPoints[1];
        cafeCardsEngine.teamBags[0] = this.teamBags[0];
        cafeCardsEngine.teamBags[1] = this.teamBags[1];
    }

    private void SerialiseHearts(CafeCardsEngine cafeCardsEngine) {
    }

    public void ResetEventQueue() {
        this.eventQueueTop = 0;
    }

    public int GetEventNum() {
        return this.eventQueueTop;
    }

    public boolean GetNextEvent(int[] nArray) {
        if (this.eventQueueTop == 0 || this.eventQ == null) {
            return false;
        }
        nArray[0] = this.eventQ[0];
        nArray[1] = this.data1Q[0];
        nArray[2] = this.data2Q[0];
        for (int i = 1; i < this.eventQueueTop; ++i) {
            this.eventQ[i - 1] = this.eventQ[i];
            this.data1Q[i - 1] = this.data1Q[i];
            this.data2Q[i - 1] = this.data2Q[i];
        }
        --this.eventQueueTop;
        return true;
    }

    public void PushMessage(int n, int n2, int n3) {
        this.Debug_Message(this, "PUSH MESSAGE type , data1 , data2 " + n + ":" + n2 + ":" + n3);
        if (this.eventQueueTop == 24) {
            this.Debug_Error(this, "PushMessage: queue full");
            for (int i = 0; i < 24; ++i) {
                this.Debug_Message(this, "type , data1 , data2 " + this.eventQ[i] + ":" + this.data1Q[i] + ":" + this.data2Q[i]);
            }
            return;
        }
        if (n == 5) {
            return;
        }
        this.eventQ[this.eventQueueTop] = n;
        this.data1Q[this.eventQueueTop] = n2;
        this.data2Q[this.eventQueueTop] = n3;
        ++this.eventQueueTop;
    }

    public boolean PeekMsg(int n) {
        for (int i = 0; i < this.eventQueueTop; ++i) {
            if (this.eventQ[i] != n) continue;
            return true;
        }
        return false;
    }

    protected int PeekMsg(int n, int n2, int n3) {
        for (int i = 0; i < this.eventQueueTop; ++i) {
            if (this.eventQ[i] != n || n2 >= 0 && n2 != this.data1Q[i] || n3 >= 0 && n3 != this.data2Q[i]) continue;
            return i;
        }
        return -1;
    }

    protected void RemoveMsg(int n) {
        for (int i = n + 1; i < this.eventQueueTop; ++i) {
            this.eventQ[i - 1] = this.eventQ[i];
            this.data1Q[i - 1] = this.data1Q[i];
            this.data2Q[i - 1] = this.data2Q[i];
        }
        --this.eventQueueTop;
        this.eventQ[this.eventQueueTop] = 0;
    }

    public void PurgeMessages(int n) {
        for (int i = 0; i < this.eventQueueTop; ++i) {
            if (this.eventQ[i] != n) continue;
            this.RemoveMsg(i);
            --i;
        }
    }

    protected void InitObject() {
        switch (this.gameType) {
            case 1: {
                if (this.configuration != 1) {
                    this.InitPack(1, 0);
                }
                this.pile = new byte[4];
                this.numPlayers = 4;
                this.numCardsHand = 13;
                if (this.configuration == 1) break;
                this.changeHand = new byte[4][3];
                break;
            }
            case 2: {
                if (this.configuration != 1) {
                    this.InitPack(1, 0);
                }
                this.pile = new byte[4];
                this.numPlayers = 4;
                this.numCardsHand = 13;
                this.trickBid = new int[4];
                this.teamPoints = new int[2];
                this.teamBags = new int[2];
                this.teamGameScore = new int[2];
                break;
            }
            case 3: {
                if (this.configuration != 1) {
                    this.InitPack(1, 0);
                }
                this.pile = new byte[2];
                this.numPlayers = 2;
                this.numCardsHand = 11;
                this.meldData = new byte[2][11];
                if (this.configuration == 1) break;
                this.tmpHand = new byte[11];
                this.tmpInfo = new byte[11];
                break;
            }
            case 0: {
                return;
            }
        }
        this.pointsGame = new int[this.numPlayers];
        this.pointsMatch = new int[this.numPlayers];
        this.playerData = new int[this.numPlayers];
        this.pdContext = new int[this.numPlayers];
        this.playerHand = new byte[this.numPlayers][this.numCardsHand];
        this.numPlayersCreated = 0;
        this.playerType = new int[this.numPlayers];
        if (this.configuration != 1) {
            this.player = new CafeCardsPlayer[this.numPlayers];
            for (int i = 0; i < this.numPlayers; ++i) {
                this.playerType[i] = 0;
            }
            this.eventQ = new int[24];
            this.data1Q = new int[24];
            this.data2Q = new int[24];
            this.InitAIStore();
        }
    }

    protected void ShufflePack(int n) {
        this.Shuffle(1, n / 2, n);
        this.ShuffleFlip(n);
        this.Shuffle(100, 13, n);
        this.Shuffle(1, n / 2, n);
    }

    protected boolean DealCheat(int n) {
        int n2;
        int n3 = CafeCardsEngine.GetCheatNumber(strCheatCode);
        strCheatCode = "";
        if (n3 < 0) {
            return false;
        }
        int n4 = 0;
        int n5 = 0;
        if (n3 <= 3) {
            n4 = n3 % 4;
            n5 = 0;
        } else if (n3 <= 5) {
            n4 = n3 % 4;
            n5 = 1;
        } else if (n3 <= 9) {
            n4 = n3 - 5 - 1;
            n5 = 2;
        } else if (n3 <= 11) {
            n4 = n3 - 9 - 1;
            n5 = 3;
        } else if (n3 <= 13) {
            n4 = n3 - 11 - 1;
            n5 = 4;
        }
        for (n2 = 0; n2 < this.packSize; ++n2) {
            this.pack[n2] = cheatSet[n5][n2];
        }
        this.topPack = this.packSize - 1;
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < this.numPlayers; ++i) {
                int n6 = i + n4;
                if (n6 >= this.numPlayers) {
                    n6 -= this.numPlayers;
                }
                this.playerHand[n6][n2] = this.DealCard();
            }
        }
        return true;
    }

    public static boolean IsValidCheat(String string) {
        if (CafeCardsEngine.GetCheatNumber(string) >= 0) {
            strCheatCode = string;
            return true;
        }
        return false;
    }

    protected static int GetCheatNumber(String string) {
        for (int i = 0; i < cheatCodes.length; ++i) {
            if (string.compareTo(cheatCodes[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    protected void Deal(int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.numCardsHand; ++n3) {
            for (n2 = 0; n2 < this.numPlayers; ++n2) {
                this.playerHand[n2][n3] = -1;
            }
        }
        if (ShellyCanvas.pShelly.demoModeOn()) {
            if (this.gameType == 1) {
                this.SetSeed(1182164513318L);
            } else if (this.gameType == 2) {
                this.SetSeed(1182164607193L);
            } else {
                this.SetSeed(1182164366302L);
            }
        }
        this.StartPack();
        this.ShufflePack(this.packSize);
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < this.numPlayers; ++n2) {
                this.playerHand[n2][n3] = this.DealCard();
            }
        }
        this.PushMessage(1, this.gameType, n);
    }

    protected boolean NextPlayer() {
        ++this.playerFocus;
        if (this.playerFocus == this.numPlayers) {
            this.playerFocus = 0;
        }
        return this.playerFocus != this.trickButton;
    }

    private void NewGameGeneric() {
        int n;
        this.currentRound = 0;
        this.numInPile = 0;
        if (this.numHands > 0) {
            ++this.dealButton;
        }
        if (this.dealButton == this.numPlayers) {
            this.dealButton = 0;
        }
        this.currentGameState = 1;
        for (n = 0; n < this.numPlayers; ++n) {
            this.pointsGame[n] = 0;
            if (this.player[n] == null) continue;
            this.player[n].ReadyNewGame();
        }
        for (n = 0; n < this.pile.length; ++n) {
            this.pile[n] = -1;
        }
        this.ResetAIStore();
    }

    protected void SortHandWhist() {
        for (int i = 0; i < this.numPlayers; ++i) {
            CardUtils.SortHandSuit(this.playerHand[i], 13, false);
        }
    }

    protected boolean IsLegalWhistCard(int n, byte[] byArray, int n2, int n3) {
        byte by = byArray[n];
        if (by == -1) {
            return false;
        }
        byte by2 = this.GetLeadSuitWhist();
        if (by2 == -1) {
            if (n3 >= 0 && CardUtils.DecodeSuit(by) == n3) {
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    if (byArray[i] <= -1) continue;
                    bl |= CardUtils.DecodeSuit(byArray[i]) != n3;
                }
                return !bl;
            }
            return true;
        }
        if (CardUtils.DecodeSuit(by) == by2) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            bl |= CardUtils.DecodeSuit(byArray[i]) == by2;
        }
        return !bl;
    }

    public int GetLeadPositionWhist() {
        return this.trickButton;
    }

    public byte GetLeadSuitWhist() {
        byte by = this.pile[this.trickButton];
        return CardUtils.DecodeSuit(by);
    }

    public byte GetLeadCardWhist() {
        byte by = this.pile[this.trickButton];
        return CardUtils.DecodeCardAH(by);
    }

    protected int TrickWinnerWhist(int n) {
        byte by = this.GetLeadSuitWhist();
        byte by2 = this.GetLeadCardWhist();
        if (by == -1) {
            return -1;
        }
        int n2 = this.trickButton;
        for (int i = 0; i < this.numPlayers; ++i) {
            if (i == this.trickButton || this.pile[i] == -1) continue;
            byte by3 = CardUtils.DecodeCardAH(this.pile[i]);
            byte by4 = CardUtils.DecodeSuit(this.pile[i]);
            if ((by4 != by || by3 <= by2) && (by4 != n || by == n)) continue;
            n2 = i;
            by2 = by3;
            by = by4;
        }
        return n2;
    }

    public int GetNumInHand(int n) {
        int n2 = 0;
        for (int i = 0; i < 13; ++i) {
            if (this.playerHand[n][i] == -1) continue;
            ++n2;
        }
        return n2;
    }

    public boolean LastToPlayWhist(int n) {
        if (++n == 4) {
            n = 0;
        }
        return this.trickButton == n;
    }

    public boolean FirstToPlayWhist(int n) {
        return this.trickButton == n;
    }

    protected void NewGameHearts() {
        if (this.currentGameState != 10) {
            this.currentGameState = 1;
        }
        this.trumpBroken = false;
    }

    protected boolean TickHearts() {
        boolean bl = true;
        this.lastGameState = this.currentGameState;
        switch (this.currentGameState) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                this.Deal(this.numCardsHand);
                this.SortHandWhist();
                this.InitWhistChange();
                this.TransferCardsToPlayers(-1);
                this.PollEmoticons(15, -1);
                break;
            }
            case 2: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (!this.ProcHuman_Hearts_Change()) {
                        bl = false;
                    }
                } else {
                    this.playerData[this.playerFocus] = this.player[this.playerFocus].Hearts_ChangeCard();
                    this.pdContext[this.playerFocus] = 1;
                    this.bCommandRdy = true;
                }
                if (!bl) break;
                this.PushMessage(201, -1, -1);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (!this.ProcHuman_Whist_Play()) {
                        bl = false;
                    }
                } else {
                    this.playerData[this.playerFocus] = this.player[this.playerFocus].Hearts_PlayCard();
                    this.pdContext[this.playerFocus] = 3;
                    this.bCommandRdy = true;
                }
                if (!bl) break;
                this.ProcessWhistPlayCard(this.playerData[this.playerFocus]);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                bl = false;
            }
        }
        if (bl) {
            this.Serialise();
            this.AdvanceStateHearts();
        }
        return true;
    }

    protected void AdvanceStateHearts() {
        switch (this.currentGameState) {
            case 1: {
                if (this.dealButton == 3) {
                    this.InitWhistRound();
                    this.ProcessOpenWith2C();
                    this.NextPlayer();
                    if (this.currentRound == 0 && this.playerFocus == 0) {
                        this.PushMessage(6, 1, -1);
                    }
                    this.currentGameState = 4;
                    break;
                }
                ++this.currentGameState;
                this.PushMessage(200, -1, -1);
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 5, -1);
                break;
            }
            case 2: {
                if (!this.NextPlayer()) {
                    ++this.currentGameState;
                    this.InitWhistRound();
                    this.ProcessHeartsChange();
                    this.TransferCardsToPlayers(-1);
                    this.PushMessage(202, -1, -1);
                    this.PushMessage(5, 5, -1);
                    this.PushMessage(6, 6, -1);
                    break;
                }
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 5, -1);
                break;
            }
            case 3: {
                ++this.currentGameState;
                this.ProcessOpenWith2C();
                this.NextPlayer();
                if (this.currentRound != 0 || this.playerFocus != 0) break;
                this.PushMessage(6, 1, -1);
                break;
            }
            case 4: {
                ++this.currentGameState;
                break;
            }
            case 5: {
                if (!this.NextPlayer()) {
                    ++this.currentGameState;
                    this.ProcessHeartsEndRound();
                    this.PushMessage(51, this.trickButton, -1);
                    this.PushMessage(5, 6, -1);
                    break;
                }
                if (this.currentRound != 0 || this.playerFocus != 0) break;
                if (this.numInPile == 0) {
                    this.PushMessage(6, 3, -1);
                    break;
                }
                this.PushMessage(6, 1, -1);
                break;
            }
            case 6: {
                ++this.currentRound;
                if (this.currentRound >= 13) {
                    this.currentGameState = 7;
                    this.ProcessHeartsReveal();
                    this.PushMessage(2, -1, -1);
                    this.PushMessage(5, 4, -1);
                    break;
                }
                this.InitWhistRound();
                this.currentGameState = 5;
                break;
            }
            case 7: {
                ++this.currentGameState;
                if (this.ProcessHeartsConsolidate()) {
                    this.nextGameState = 10;
                    this.PushMessage(4, -1, -1);
                } else {
                    this.PushMessage(3, -1, -1);
                    this.nextGameState = this.currentGameState + 1;
                }
                this.PushMessage(5, 4, -1);
                break;
            }
            case 8: {
                this.currentGameState = this.nextGameState;
                break;
            }
        }
    }

    protected void InitWhistChange() {
        this.trickButton = this.dealButton + 1;
        if (this.trickButton == this.numPlayers) {
            this.trickButton = 0;
        }
        this.playerFocus = this.trickButton;
    }

    protected void TransferCardsToPlayers(int n) {
        for (int i = 0; i < this.numPlayers; ++i) {
            if (this.player[i] == null || n >= 0 && n != i) continue;
            this.player[i].SetHand(this.playerHand[i], this.numCardsHand);
        }
    }

    protected void ProcessHeartsChange() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < 4; ++n4) {
            n3 = 0;
            for (n2 = 0; n2 < 13 && n3 < 3; ++n2) {
                n = 1 << n2;
                if ((n & this.playerData[n4]) <= 0) continue;
                this.changeHand[n4][n3++] = this.playerHand[n4][n2];
                this.playerHand[n4][n2] = -1;
            }
        }
        this.SortHandWhist();
        for (n4 = 0; n4 < 4; ++n4) {
            n = this.GetChangeSeatHearts(n4);
            this.SetBlackBoard(4 + n4, n);
            n3 = 12;
            for (n2 = 0; n2 < 3; ++n2) {
                this.playerHand[n][n3--] = this.changeHand[n4][n2];
            }
        }
        this.PollEmoticons(14, -1);
        this.SortHandWhist();
        for (n4 = 0; n4 < 4; ++n4) {
            n = this.GetChangeSeatHearts(n4);
            this.playerData[n] = 0;
            this.pdContext[n] = 2;
            for (n2 = 0; n2 < 3; ++n2) {
                n3 = CardUtils.FindInCards(this.changeHand[n4][n2], this.playerHand[n], 13);
                int n5 = n;
                this.playerData[n5] = this.playerData[n5] | 1 << n3;
            }
        }
    }

    public int GetChangeSeatHearts(int n) {
        int n2 = n;
        switch (this.dealButton) {
            case 0: {
                ++n2;
                break;
            }
            case 1: {
                --n2;
                break;
            }
            case 2: {
                n2 += 2;
                break;
            }
        }
        if (n2 >= this.numPlayers) {
            n2 -= 4;
        }
        if (n2 < 0) {
            n2 += 4;
        }
        return n2;
    }

    protected void ProcessOpenWith2C() {
        byte by = CardUtils.EncodePack((byte)2, (byte)1);
        for (int i = 0; i < 4; ++i) {
            int n = CardUtils.FindInCards(by, this.playerHand[i], 13);
            if (n < 0) continue;
            this.playerFocus = this.trickButton = i;
            this.playerData[this.playerFocus] = n;
            this.pdContext[this.playerFocus] = 3;
            this.ProcessWhistPlayCard(n);
            if (this.playerFocus == 0) {
                this.PushMessage(6, 7, -1);
            }
            return;
        }
    }

    protected void ProcessWhistPlayCard(int n) {
        int n2;
        byte by = this.playerHand[this.playerFocus][n];
        this.PushMessage(50, by, this.playerFocus);
        if (this.gameType == 1 && CardUtils.DecodeSuit(by) == 3 || this.gameType == 2 && CardUtils.DecodeSuit(by) == 0) {
            if (!this.trumpBroken) {
                this.PushMessage(52, this.playerFocus, -1);
                this.PollEmoticons(13, this.playerFocus);
            }
            this.trumpBroken = true;
        }
        if (this.gameType == 1) {
            if (by == CafeCardsDefs.QUEEN_SPADES) {
                this.PollEmoticons(6, this.playerFocus);
            } else {
                this.PollEmoticons(1, this.playerFocus);
            }
        } else if (this.gameType == 2) {
            n2 = this.TrickWinnerWhist(0);
            if (this.trickBid[this.playerFocus] == 0 && n2 == this.playerFocus && this.pointsGame[this.playerFocus] == 0 && this.RandX(10) < 5) {
                this.PollEmoticons(7, this.playerFocus);
            } else {
                this.PollEmoticons(1, this.playerFocus);
            }
        }
        this.pile[this.playerFocus] = by;
        ++this.numInPile;
        this.playerHand[this.playerFocus][n] = -1;
        CardUtils.SortHandSuit(this.playerHand[this.playerFocus], 13, false);
        if (this.player[this.playerFocus] != null) {
            this.player[this.playerFocus].CardHasPlayed(by);
        }
        n2 = this.GetLeadSuitWhist();
        if (this.numInPile > 1 && CardUtils.DecodeSuit(by) != n2) {
            n2 = 1 << n2;
            this.SetBlackBoard(0 + this.playerFocus, n2);
        }
        this.AIinfo_WhistProc(this.playerFocus, this.pile[this.playerFocus]);
        ++this.numPlaysDemo;
    }

    protected void AIinfo_WhistProc(int n, byte by) {
        this.CountCardPlayed(n, by);
    }

    protected void ProcessHeartsEndRound() {
        int n;
        int n2 = this.TrickWinnerWhist(-1);
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < 4; ++n) {
            if (CardUtils.DecodeSuit(this.pile[n]) == 3) {
                int n3 = n2;
                this.pointsGame[n3] = this.pointsGame[n3] + 1;
            }
            if (this.pile[n] == CardUtils.EncodePack((byte)0, (byte)11)) {
                int n4 = n2;
                this.pointsGame[n4] = this.pointsGame[n4] + this.heartsQSPenalty;
                bl = true;
                this.PushMessage(206, n2, -1);
            }
            bl2 |= CardUtils.DecodeSuit(this.pile[n]) == 3;
        }
        this.trickButton = n2;
        if (bl) {
            this.PollEmoticons(6, n2);
        } else if (CardUtils.DecodeCardAH(this.pile[n2]) < 8) {
            this.PollEmoticons(12, n2);
        } else {
            this.PollEmoticons(3, n2);
        }
        if (this.currentRound < 12) {
            int n5 = 0;
            int n6 = 0;
            int n7 = -1;
            for (n = 0; n < 4; ++n) {
                if (this.pointsGame[n] == 0) {
                    ++n5;
                    continue;
                }
                if (this.pointsGame[n] <= n6) continue;
                n6 = this.pointsGame[n];
                n7 = n;
            }
            if (n5 == 3 && (n6 > 7 && n6 < 13 || n6 > 17)) {
                if (n7 == 0) {
                    this.PushMessage(6, 10, -1);
                } else {
                    this.PushMessage(6, 11, -1);
                }
            } else if (n2 == 0) {
                if (bl) {
                    this.PushMessage(6, 9, -1);
                } else if (bl2) {
                    this.PushMessage(6, 8, -1);
                } else {
                    this.PushMessage(6, 4, -1);
                }
            }
        }
    }

    protected void InitWhistRound() {
        this.playerFocus = this.trickButton;
        this.numInPile = 0;
        for (int i = 0; i < this.numPlayers; ++i) {
            this.pile[i] = -1;
        }
    }

    protected void ProcessHeartsReveal() {
        int n;
        int n2 = -1;
        for (n = 0; n < 4; ++n) {
            if (this.pointsGame[n] != 13 + this.heartsQSPenalty || this.heartsShootBonus <= 0) continue;
            n2 = n;
            this.PushMessage(205, n2, -1);
        }
        if (n2 < 0) {
            for (n = 0; n < 4; ++n) {
                int n3 = n;
                this.pointsMatch[n3] = this.pointsMatch[n3] + this.pointsGame[n];
            }
        } else {
            for (n = 0; n < 4; ++n) {
                if (n == n2) {
                    this.pointsGame[n] = 0;
                    continue;
                }
                this.pointsGame[n] = this.heartsShootBonus;
                int n4 = n;
                this.pointsMatch[n4] = this.pointsMatch[n4] + this.pointsGame[n];
            }
        }
        if (n2 >= 0) {
            this.PollEmoticons(10, n2);
        } else {
            int n5 = -1;
            int n6 = 30;
            boolean bl = false;
            for (n = 0; n < 4; ++n) {
                if (this.pointsGame[n] > 20) {
                    this.PollEmoticons(11, n);
                    bl = true;
                } else if (this.pointsGame[n] < 2) {
                    this.PollEmoticons(10, n);
                    bl = true;
                }
                if (this.pointsGame[n] >= n6) continue;
                n6 = this.pointsGame[n];
                n5 = n;
            }
            if (!bl && n5 >= 0) {
                this.PollEmoticons(4, n5);
            }
        }
    }

    protected boolean ProcessHeartsConsolidate() {
        int n;
        ++this.numHands;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        for (n = 0; n < 4; ++n) {
            if (this.pointsMatch[n] >= this.heartsPointsMatch) {
                n3 = n;
            }
            if (this.pointsMatch[n] <= n4) continue;
            n4 = this.pointsMatch[n];
            n2 = n;
        }
        if (n3 < 0 && this.numHands >= this.heartsMaxHands) {
            n3 = n2;
        }
        if (n3 >= 0) {
            int n5 = 99999;
            for (n = 0; n < 4; ++n) {
                if (this.pointsMatch[n] == n5) {
                    n3 = -1;
                    return false;
                }
                if (this.pointsMatch[n] >= n5) continue;
                n3 = n;
                n5 = this.pointsMatch[n];
            }
        }
        if (n3 >= 0) {
            for (n = 0; n < 4; ++n) {
                this.pdContext[n] = n == n3 ? 4 : 5;
            }
            this.PollEmoticons(5, n3);
            return true;
        }
        return false;
    }

    protected void NewGameSpades() {
        if (this.currentGameState != 8) {
            this.currentGameState = 1;
        }
        this.trumpBroken = false;
        for (int i = 0; i < 4; ++i) {
            this.trickBid[i] = -999;
        }
    }

    protected boolean TickSpades() {
        boolean bl = true;
        this.lastGameState = this.currentGameState;
        switch (this.currentGameState) {
            case 0: {
                break;
            }
            case 1: {
                this.Deal(this.numCardsHand);
                this.SortHandWhist();
                this.InitWhistChange();
                this.TransferCardsToPlayers(-1);
                this.PollEmoticons(15, -1);
                break;
            }
            case 2: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (!this.ProcHuman_Whist_Play()) {
                        bl = false;
                    }
                } else {
                    this.playerData[this.playerFocus] = this.player[this.playerFocus].Spades_MakeBid();
                    this.pdContext[this.playerFocus] = 13;
                    this.bCommandRdy = true;
                }
                if (!bl) break;
                this.trickBid[this.playerFocus] = this.playerData[this.playerFocus];
                this.PushMessage(300, this.playerFocus, this.trickBid[this.playerFocus]);
                this.PollEmoticons(16, -1);
                break;
            }
            case 3: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (!this.ProcHuman_Whist_Play()) {
                        bl = false;
                    }
                } else {
                    this.playerData[this.playerFocus] = this.player[this.playerFocus].Spades_PlayCard();
                    this.pdContext[this.playerFocus] = 3;
                    this.bCommandRdy = true;
                }
                if (!bl) break;
                this.ProcessWhistPlayCard(this.playerData[this.playerFocus]);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                bl = false;
            }
        }
        if (bl) {
            this.Serialise();
            this.AdvanceStateSpades();
        }
        return true;
    }

    protected void AdvanceStateSpades() {
        switch (this.currentGameState) {
            case 1: {
                ++this.currentGameState;
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 5, -1);
                break;
            }
            case 2: {
                if (!this.NextPlayer()) {
                    ++this.currentGameState;
                    this.InitWhistRound();
                    if (this.currentRound != 0 || this.playerFocus != 0) break;
                    this.PushMessage(6, 1, -1);
                    break;
                }
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 5, -1);
                break;
            }
            case 3: {
                if (!this.NextPlayer()) {
                    ++this.currentGameState;
                    this.ProcessSpadesEndRound();
                    this.PushMessage(51, this.trickButton, -1);
                    this.PushMessage(5, 6, -1);
                    break;
                }
                if (this.numInPile == 0) {
                    this.PushMessage(6, 3, -1);
                    break;
                }
                this.PushMessage(6, 1, -1);
                break;
            }
            case 4: {
                ++this.currentRound;
                if (this.currentRound >= 13) {
                    this.currentGameState = 5;
                    this.ProcessSpadesReveal();
                    this.PushMessage(2, -1, -1);
                    this.PushMessage(5, 4, -1);
                    break;
                }
                this.InitWhistRound();
                this.currentGameState = 3;
                break;
            }
            case 5: {
                ++this.currentGameState;
                if (this.ProcessSpadesConsolidate()) {
                    this.nextGameState = 8;
                    this.PushMessage(4, -1, -1);
                } else {
                    this.PushMessage(3, -1, -1);
                    this.nextGameState = this.currentGameState + 1;
                }
                this.PushMessage(5, 4, -1);
                break;
            }
            case 6: {
                this.currentGameState = this.nextGameState;
                break;
            }
        }
    }

    protected void ProcessSpadesEndRound() {
        int n = this.TrickWinnerWhist(0);
        int n2 = this.pointsGame[n];
        int n3 = n;
        this.pointsGame[n3] = this.pointsGame[n3] + 1;
        this.trickButton = n;
        if (this.trickBid[n] == 0 && this.pointsGame[n] == 1) {
            this.PollEmoticons(7, this.playerFocus);
        } else if (this.pointsGame[n] > this.trickBid[n] + 1) {
            this.PollEmoticons(8, n);
        } else if (CardUtils.DecodeCardAH(this.pile[n]) < 8 && CardUtils.DecodeSuit(this.pile[n]) != 0) {
            this.PollEmoticons(12, n);
        } else {
            this.PollEmoticons(3, n);
        }
        if (this.currentRound < 12) {
            int n4 = this.trickBid[0] + this.trickBid[2] - this.pointsGame[0] - this.pointsGame[2];
            int n5 = this.trickBid[1] + this.trickBid[3] - this.pointsGame[1] - this.pointsGame[3];
            if (n2 == 0 && this.trickBid[n] == 0) {
                this.PushMessage(6, 8, -1);
            } else if ((n == 0 || n == 2) && n4 == -1) {
                this.PushMessage(6, 6, -1);
            } else if ((n == 1 || n == 3) && n5 == -1) {
                this.PushMessage(6, 9, -1);
            } else if (n5 > 12 - this.currentRound) {
                this.PushMessage(6, 10, -1);
            } else if (n == 0) {
                this.PushMessage(6, 4, -1);
            } else if (this.currentRound > 5 && (this.trickBid[1] == 0 && this.pointsGame[1] == 0 || this.trickBid[3] == 0 && this.pointsGame[3] == 0)) {
                this.PushMessage(6, 7, -1);
            }
        }
    }

    protected void ProcessSpadesReveal() {
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < 2; ++n2) {
                n = CafeCardsDefs.SPADES_MEMBERS[i][n2];
                n5 += this.trickBid[n];
                if (this.trickBid[n] == 0) {
                    if (this.pointsGame[n] == 0) {
                        n4 += this.spadesNilBonus;
                        this.PushMessage(302, n, -1);
                        continue;
                    }
                    n3 += this.pointsGame[n] * this.spadesBagsFactor;
                    n4 -= this.spadesNilBonus;
                    this.PushMessage(301, n, -1);
                    continue;
                }
                n6 += this.pointsGame[n];
                n3 += (this.pointsGame[n] - this.trickBid[n]) * this.spadesBagsFactor;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            n = CafeCardsDefs.SPADES_MEMBERS[i][0];
            if (n6 >= n5) {
                n6 = n5 * 10 + n3;
                n3 += this.teamBags[i];
                while (n3 >= this.spadesBagsToPenalise) {
                    n3 -= this.spadesBagsToPenalise;
                    n4 -= this.spadesOverBidPenalty;
                    this.PushMessage(303, i, -1);
                }
            } else {
                n6 = -10 * n5;
            }
            n6 += n4;
            for (n2 = 0; n2 < 2; ++n2) {
                int n7 = n = CafeCardsDefs.SPADES_MEMBERS[i][n2];
                this.pointsMatch[n7] = this.pointsMatch[n7] + n6;
                this.teamGameScore[i] = n6;
                this.teamPoints[i] = this.pointsMatch[n];
            }
            this.teamBags[i] = n3;
            n = this.RandX(10) > 5 ? CafeCardsDefs.SPADES_MEMBERS[i][0] : CafeCardsDefs.SPADES_MEMBERS[i][1];
            if (n4 > 0) {
                this.PollEmoticons(10, n);
                bl = true;
                continue;
            }
            if (n4 < 0) {
                this.PollEmoticons(11, n);
                bl = true;
                continue;
            }
            if (n6 < 0) {
                this.PollEmoticons(17, n);
                continue;
            }
            if (n6 <= 30) continue;
            this.PollEmoticons(4, n);
        }
    }

    protected boolean ProcessSpadesConsolidate() {
        int n;
        ++this.numHands;
        if (this.teamPoints[0] == this.teamPoints[1]) {
            return false;
        }
        int n2 = -1;
        for (n = 0; n < 2; ++n) {
            if (this.teamPoints[n] >= this.spadesPointsMatch && this.teamPoints[n] > this.teamPoints[n == 0 ? 1 : 0]) {
                n2 = n;
                continue;
            }
            if (this.teamPoints[n] > -this.spadesPointsMatch || this.teamPoints[n] >= this.teamPoints[n == 0 ? 1 : 0]) continue;
            n2 = n == 0 ? 1 : 0;
        }
        if (n2 < 0 && this.numHands >= this.spadesMaxHands) {
            n2 = this.teamPoints[0] > this.teamPoints[1] ? 0 : 1;
        }
        if (n2 >= 0) {
            for (n = 0; n < 2; ++n) {
                for (int i = 0; i < 2; ++i) {
                    int n3 = CafeCardsDefs.SPADES_MEMBERS[n][i];
                    this.pdContext[n3] = n == n2 ? 14 : 15;
                }
            }
            this.PollEmoticons(5, n2);
            return true;
        }
        return false;
    }

    protected void NewGameGin() {
        if (this.currentGameState != 10) {
            this.currentGameState = 1;
        }
        this.bGameDeadlocked = false;
    }

    public int GinCommandLegal() {
        int n = 0;
        switch (this.currentGameState) {
            case 2: 
            case 3: {
                n = 655361;
                break;
            }
            case 4: {
                n = 655366;
                break;
            }
            case 5: {
                n = 917504;
                break;
            }
            case 0: 
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        return n;
    }

    protected boolean TickGin() {
        boolean bl = true;
        this.lastGameState = this.currentGameState;
        switch (this.currentGameState) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                this.Deal(this.numCardsHand - 1);
                this.SortHandGinInit();
                this.ResetMeld(this.meldData[0]);
                this.ResetMeld(this.meldData[1]);
                this.TransferCardsToPlayers(-1);
                this.GinInitStock();
                this.PollEmoticons(15, -1);
                for (int i = 0; i < this.numPlayers; ++i) {
                    if (this.player[i] == null || this.playerType[i] <= 0) continue;
                    this.player[i].Gin_InitOrder();
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (!this.ProcHuman_Gin_Play()) {
                        bl = false;
                    }
                } else {
                    this.playerData[this.playerFocus] = this.player[this.playerFocus].Gin_TakeCard();
                    this.pdContext[this.playerFocus] = 6;
                    this.bCommandRdy = true;
                }
                if (!bl) break;
                byte by = this.ProcessGinTakeCard(this.playerData[this.playerFocus] > 0, this.currentGameState != 2);
                if (this.bGameDeadlocked) break;
                this.TransferCardsToPlayers(this.playerFocus);
                if (this.playerData[this.playerFocus] > 0) {
                    this.PushMessage(104, this.playerFocus + 128, by);
                    break;
                }
                this.PushMessage(104, this.playerFocus, by);
                break;
            }
            case 4: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (!this.ProcHuman_Gin_Play()) {
                        bl = false;
                    }
                } else {
                    this.playerData[this.playerFocus] = this.player[this.playerFocus].Gin_DiscardCard();
                    this.pdContext[this.playerFocus] = this.player[this.playerFocus].Gin_KnockOption() ? 8 : 7;
                    this.bCommandRdy = true;
                }
                if (!bl) break;
                if (this.pdContext[this.playerFocus] == 8) {
                    this.trickButton = this.playerFocus;
                }
                this.ProcessGinDiscard((byte)this.playerData[this.playerFocus]);
                this.TransferCardsToPlayers(this.playerFocus);
                this.PushMessage(105, (byte)this.playerData[this.playerFocus], this.playerFocus);
                break;
            }
            case 5: {
                if (this.playerType[this.playerFocus] == -1) {
                    if (this.ProcHuman_Gin_Play()) break;
                    bl = false;
                    break;
                }
                this.player[this.playerFocus].Gin_MeldDefine(this.playerFocus == this.trickButton);
                this.pdContext[this.playerFocus] = 9;
                this.bCommandRdy = true;
                break;
            }
            case 6: {
                this.GinMeldToOpp_Auto(this.playerFocus);
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 13, -1);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                bl = false;
            }
        }
        if (bl) {
            this.Serialise();
            this.AdvanceStateGin();
        }
        return true;
    }

    void AdvanceStateGin() {
        switch (this.currentGameState) {
            case 0: {
                break;
            }
            case 1: {
                this.playerFocus = this.playerType[0] == -1 ? 0 : 1;
                ++this.currentGameState;
                this.playerFocus = this.dealButton;
                this.NextPlayer();
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 1, -1);
                break;
            }
            case 2: {
                if (this.pile[0] <= -1) {
                    this.currentGameState = 4;
                    if (!ShellyCanvas.isTouchEnabled) break;
                    this.PushMessage(6, 5, -1);
                    break;
                }
                if (this.playerFocus == this.dealButton) {
                    ++this.currentGameState;
                    this.playerFocus = this.dealButton;
                    this.NextPlayer();
                    byte by = this.ProcessGinTakeCard(false, true);
                    this.TransferCardsToPlayers(this.playerFocus);
                    this.PushMessage(111, this.playerFocus, -1);
                    this.PushMessage(104, this.playerFocus, by);
                    ++this.currentGameState;
                    if (this.playerFocus != 0) break;
                    this.PushMessage(6, 3, -1);
                    break;
                }
                this.NextPlayer();
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 2, -1);
                break;
            }
            case 3: {
                if (this.bGameDeadlocked) {
                    this.PushMessage(103, -1, -1);
                    this.currentGameState = 9;
                    break;
                }
                ++this.currentGameState;
                if (this.playerFocus != 0) break;
                this.PushMessage(6, 5, -1);
                break;
            }
            case 4: {
                ++this.currentRound;
                if (this.pdContext[this.playerFocus] == 8) {
                    this.currentGameState = 5;
                    this.trickButton = this.playerFocus;
                    this.numSubmissions = 0;
                    this.PushMessage(106, this.trickButton, -1);
                    if (this.playerType[this.playerFocus] < 0) {
                        this.ReadMeld(this.meldData[this.playerFocus], this.playerHand[this.playerFocus], 3, 0);
                    }
                    if (this.playerFocus == 0) {
                        int n = this.GinCalcDeadWood(this.playerHand[0], this.meldData[0], false);
                        if (n <= 10) {
                            this.PushMessage(6, 9, -1);
                            break;
                        }
                        this.PushMessage(6, 10, -1);
                        break;
                    }
                    this.PushMessage(6, 11, -1);
                    break;
                }
                this.NextPlayer();
                this.currentGameState = 3;
                if (this.playerFocus == 0) {
                    this.PushMessage(6, 4, -1);
                    break;
                }
                this.PushMessage(6, 8, -1);
                break;
            }
            case 5: {
                if (this.playerFocus == this.trickButton) {
                    int n = 10;
                    if (this.GinMeldLegal(n)) {
                        this.PushMessage(108, this.playerFocus, -1);
                        this.NextPlayer();
                        this.numSubmissions = 0;
                        if (this.playerType[this.playerFocus] >= 0) break;
                        this.ReadMeld(this.meldData[this.playerFocus], this.playerHand[this.playerFocus], 3, 0);
                        break;
                    }
                    if (this.playerFocus == 0) {
                        this.PushMessage(6, 12, -1);
                    }
                    ++this.numSubmissions;
                    if (this.numSubmissions >= 1) {
                        this.PushMessage(101, this.playerFocus, -1);
                        this.NextPlayer();
                        this.currentGameState = 3;
                        this.numSubmissions = 0;
                        break;
                    }
                    this.PushMessage(100, this.playerFocus, -1);
                    this.currentGameState = 5;
                    break;
                }
                if (this.GinMeldLegal(-1)) {
                    this.PushMessage(108, this.playerFocus, -1);
                    ++this.currentGameState;
                    break;
                }
                ++this.numSubmissions;
                if (this.numSubmissions >= 1) {
                    this.PushMessage(102, this.playerFocus, -1);
                    this.currentGameState = 7;
                    this.ResetMeld(this.meldData[this.playerFocus]);
                    this.numSubmissions = 0;
                    this.ProcessGinReveal();
                    this.PushMessage(2, -1, -1);
                    this.PushMessage(5, 4, -1);
                    break;
                }
                this.PushMessage(100, this.playerFocus, -1);
                this.currentGameState = 5;
                break;
            }
            case 6: {
                ++this.currentGameState;
                this.PushMessage(107, -1, -1);
                this.ProcessGinReveal();
                this.PushMessage(2, -1, -1);
                this.PushMessage(5, 4, -1);
                break;
            }
            case 7: {
                this.PushMessage(2, -1, -1);
                ++this.currentGameState;
                if (this.ProcessGinConsolidate()) {
                    this.nextGameState = 10;
                    this.PushMessage(4, -1, -1);
                } else {
                    this.PushMessage(3, -1, -1);
                    this.nextGameState = this.currentGameState + 1;
                }
                this.PushMessage(5, 4, -1);
                break;
            }
            case 8: {
                this.currentGameState = this.nextGameState;
                break;
            }
        }
    }

    protected void SortHandGin(int n) {
        int n2;
        for (n2 = 0; n2 < 11; ++n2) {
            this.tmpHand[n2] = this.playerHand[n][n2];
            this.tmpInfo[n2] = this.meldData[n][n2];
        }
        CardUtils.SortHandCard(this.playerHand[n], 11, true, true);
        for (n2 = 0; n2 < 11; ++n2) {
            int n3 = CardUtils.FindInCards(this.playerHand[n][n2], this.tmpHand, 11);
            this.meldData[n][n3] = this.tmpInfo[n2];
        }
    }

    protected void SortHandGinInit() {
        for (int i = 0; i < this.numPlayers; ++i) {
            CardUtils.SortHandCard(this.playerHand[i], 11, false, true);
        }
    }

    protected void GinInitStock() {
        this.pile[0] = this.DealCard();
    }

    protected byte ProcessGinTakeCard(boolean bl, boolean bl2) {
        byte by = -1;
        this.cardDrawnDiscard = (byte)-1;
        if (bl) {
            this.playerHand[this.playerFocus][10] = this.pile[0];
            this.CountCardPicked(this.playerFocus, this.pile[0]);
            this.cardDrawnDiscard = this.pile[0];
            by = this.pile[0];
            this.pile[0] = this.pile[1];
            this.pile[1] = -1;
            this.PollEmoticons(2, this.playerFocus);
        } else if (bl2) {
            this.playerHand[this.playerFocus][10] = this.DealCard();
            by = this.playerHand[this.playerFocus][10];
        } else {
            return -1;
        }
        if (this.topPack < 3) {
            this.bGameDeadlocked = true;
        }
        return by;
    }

    protected void ProcessGinDiscard(byte by) {
        int n = CardUtils.FindInCards(by, this.playerHand[this.playerFocus], 11);
        this.pile[1] = this.pile[0];
        this.pile[0] = this.playerHand[this.playerFocus][n];
        for (int i = n + 1; i < 11; ++i) {
            this.playerHand[this.playerFocus][i - 1] = this.playerHand[this.playerFocus][i];
        }
        this.playerHand[this.playerFocus][10] = -1;
        this.AIInfo_GinDiscard(this.playerFocus, this.pile[0]);
        this.PollEmoticons(1, this.playerFocus);
        ++this.numPlaysDemo;
    }

    protected void AIInfo_GinDiscard(int n, byte by) {
        this.CountCardPlayed(n, by);
    }

    protected void ProcessGinReveal() {
        int n = this.trickButton == 0 ? 1 : 0;
        int n2 = this.GinCalcDeadWood(this.playerHand[this.trickButton], this.meldData[this.trickButton], false);
        int n3 = this.GinCalcDeadWood(this.playerHand[n], this.meldData[n], true);
        this.pointsGame[1] = 0;
        this.pointsGame[0] = 0;
        if (n2 == 0 && n3 > 0) {
            this.pointsGame[this.trickButton] = n3 + this.ginGinBonus;
            this.PushMessage(110, this.trickButton, -1);
            if (n3 == 0) {
                this.pointsGame[n] = this.ginGinBonus;
                this.PushMessage(110, n, -1);
            } else {
                this.PollEmoticons(10, this.trickButton);
            }
        } else if (n3 < n2) {
            this.pointsGame[n] = n2 - n3 + this.ginUnderCutBonus;
            this.PushMessage(109, n, -1);
            this.PollEmoticons(9, n);
        } else {
            this.pointsGame[this.trickButton] = n3 - n2;
            if (this.currentRound < 12) {
                this.PollEmoticons(12, this.trickButton);
            } else if (n2 > 30) {
                this.PollEmoticons(11, this.trickButton);
            } else {
                this.PollEmoticons(4, this.trickButton);
            }
        }
        this.pointsMatch[0] = this.pointsMatch[0] + this.pointsGame[0];
        this.pointsMatch[1] = this.pointsMatch[1] + this.pointsGame[1];
        if ((this.controlFlags & 3) != 0) {
            this.Debug_Message(null, "_______________________________________________________");
            this.Debug_Message(this, " ProcessGinReveal ... ");
            for (int i = 0; i < this.numPlayers; ++i) {
                this.Debug_Message(this, " Player " + i + " Game Points = " + this.pointsGame[i] + " Match Points = " + this.pointsMatch[i]);
            }
            this.Debug_Message(null, " ");
        }
    }

    protected boolean ProcessGinConsolidate() {
        ++this.numHands;
        if (this.pointsMatch[0] == this.pointsMatch[1]) {
            return false;
        }
        int n = -1;
        if (this.pointsMatch[0] >= this.ginPointsMatch) {
            n = 0;
        }
        if (this.pointsMatch[1] >= this.ginPointsMatch) {
            n = 1;
        }
        if (this.numHands >= this.ginMaxHands) {
            n = this.pointsMatch[0] > this.pointsMatch[1] ? 0 : 1;
        }
        if (n > -1) {
            this.pdContext[n] = 10;
            this.pdContext[n == 1 ? 0 : 1] = 11;
            this.PollEmoticons(5, this.trickButton);
            return true;
        }
        return false;
    }

    protected boolean GinArrangeHand(int n, byte[] byArray) {
        int n2;
        if (n < 0 || n >= 2) {
            return false;
        }
        if (byArray.length < 11) {
            return false;
        }
        boolean bl = true;
        for (n2 = 0; n2 < 11; ++n2) {
            bl &= CardUtils.FindInCards(byArray[n2], this.playerHand[n], 11) >= 0;
        }
        if (bl) {
            for (n2 = 0; n2 < 11; ++n2) {
                this.playerHand[n][n2] = byArray[n2];
            }
        }
        return bl;
    }

    protected boolean GinSubmitMeld(int n, byte[] byArray) {
        int n2;
        if (n < 0 || n >= 2) {
            return false;
        }
        if (byArray.length < 11) {
            return false;
        }
        boolean bl = true;
        for (n2 = 0; n2 < 11; ++n2) {
            bl &= byArray[n2] >= 0;
        }
        if (bl) {
            for (n2 = 0; n2 < 11; ++n2) {
                this.meldData[n][n2] = byArray[n2];
            }
        }
        return bl;
    }

    public static boolean IsGinMeldLegal(byte[] byArray, int n) {
        int n2;
        if (n < 3) {
            return false;
        }
        CardUtils.SortHandSuit(byArray, n, true);
        boolean bl = true;
        for (n2 = 1; n2 < n; ++n2) {
            bl &= CardUtils.DecodeCard(byArray[0]) == CardUtils.DecodeCard(byArray[n2]);
        }
        if (!bl) {
            bl = true;
            for (n2 = 1; n2 < n; ++n2) {
                bl &= CardUtils.DecodeCard(byArray[n2]) + 1 == CardUtils.DecodeCard(byArray[n2 - 1]);
                bl &= CardUtils.DecodeSuit(byArray[0]) == CardUtils.DecodeSuit(byArray[n2]);
            }
        }
        return bl;
    }

    public int GinCalcDeadWood(byte[] byArray, byte[] byArray2, boolean bl) {
        int n;
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < 11; ++n2) {
            this.tmpInfo[n2] = 0;
            if (byArray2[n2] >= 0) continue;
            if (!bl) {
                return 9999;
            }
            this.tmpInfo[n2] = 1;
        }
        do {
            boolean bl2;
            n = 0;
            for (n2 = 0; n2 < 11; ++n2) {
                if (byArray2[n2] != n3) continue;
                this.tmpHand[n++] = byArray[n2];
                this.tmpInfo[n2] = 1;
            }
            if (n > 0 && n < 3) {
                return 9999;
            }
            if (n > 0 && !(bl2 = CafeCardsEngine.IsGinMeldLegal(this.tmpHand, n))) {
                return 9999;
            }
            ++n3;
        } while (n != 0);
        for (n2 = 0; n2 < 11; ++n2) {
            if (byArray2[n2] < n3) continue;
            return 9999;
        }
        int n4 = 0;
        for (n2 = 0; n2 < 11; ++n2) {
            if (byArray[n2] <= -1 || this.tmpInfo[n2] != 0) continue;
            n = CardUtils.DecodeCard(byArray[n2]) + 1;
            if (n > 10) {
                n = 10;
            }
            n4 += n;
        }
        return n4;
    }

    protected boolean GinMeldLegal(int n) {
        int n2 = this.GinCalcDeadWood(this.playerHand[this.playerFocus], this.meldData[this.playerFocus], false);
        if (n2 == 9999) {
            return false;
        }
        return n2 <= n || n <= 0;
    }

    private void GinMeldToOpp_Auto(int n) {
        int n2 = n == 0 ? 1 : 0;
        byte[] byArray = new byte[11];
        byte[] byArray2 = new byte[11];
        for (int i = 0; i < 11; ++i) {
            byArray2[i] = this.playerHand[n2][i];
            byArray[i] = this.meldData[n2][i];
        }
        this.GinMeldToOpp(this.playerHand[n], this.meldData[n], byArray2, byArray);
    }

    private boolean ProcHuman_Hearts_Change() {
        if (this.command == 1) {
            this.playerData[this.playerFocus] = this.cmdValue;
            this.pdContext[this.playerFocus] = 1;
            this.UsedHumanCmd();
            return true;
        }
        return false;
    }

    private boolean ProcHuman_Gin_Play() {
        int n = 0;
        if ((this.command & this.GinCommandLegal()) == 0) {
            this.UsedHumanCmd();
            return false;
        }
        if (this.command == 1) {
            n = 6;
        }
        if (this.command == 2) {
            n = 7;
        }
        if (this.command == 4) {
            n = 8;
        }
        if (this.command == 262144) {
            n = 9;
        }
        if (n != 0) {
            this.pdContext[this.playerFocus] = n;
            this.playerData[this.playerFocus] = this.cmdValue;
            this.UsedHumanCmd();
            return true;
        }
        this.UsedHumanCmd();
        return false;
    }

    private boolean ProcHuman_Whist_Play() {
        boolean bl = false;
        if (this.command == 1) {
            this.playerData[this.playerFocus] = this.cmdValue;
            this.pdContext[this.playerFocus] = 13;
            bl = true;
        } else if (this.command == 2 || this.command == 2) {
            this.playerData[this.playerFocus] = this.cmdValue;
            this.pdContext[this.playerFocus] = 3;
            bl = true;
        }
        this.UsedHumanCmd();
        return bl;
    }

    private void PollEmoticons(int n, int n2) {
        for (int i = 0; i < this.numPlayers; ++i) {
            int n3 = this.PeekMsg(998, -1, i);
            if (n3 >= 0 && this.RandX(100) < 50) {
                this.RemoveMsg(n3);
                n3 = -1;
            }
            if (n3 >= 0 || this.player[i] == null || this.playerType[i] <= 0 || this.eventQueueTop >= 16 || (n3 = this.player[i].CheckEmoticon(n, n2)) <= 0) continue;
            this.PushMessage(998, n3, i);
        }
    }

    public void PushEmoticon(int n, int n2) {
        if (this.player[n2] != null && this.eventQueueTop < 16) {
            int n3;
            while ((n3 = this.PeekMsg(998, -1, n2)) >= 0) {
                this.RemoveMsg(n3);
            }
            this.PushMessage(998, n, n2);
        }
    }

    public static long CalcRating(long l, boolean bl, int n) {
        int n2;
        if (n > 10) {
            n = 10;
        }
        long l2 = l * 8L;
        int n3 = n2 = bl ? 8000 : 0;
        if (n >= 0) {
            n2 = n2 * (n + 1) / 10;
        }
        if (n2 > 1000) {
            n2 = 1000;
        }
        l2 = (l2 * 20L + (long)n2) / 21L;
        l2 = (l2 + 4L) / 8L;
        return l2;
    }

    protected boolean IsMPClient() {
        return false;
    }

    protected boolean IsMPServer() {
        return false;
    }

    protected boolean MPClientAdvToSend() {
        return false;
    }

    protected boolean MPServerCheckAdvance(boolean bl, int n) {
        return bl;
    }

    static String PrintHeartsState(int n) {
        return " " + strHeartsState[n] + " ";
    }

    static String PrintGinState(int n) {
        return " " + strGinState[n] + " ";
    }

    static String PrintSpadesState(int n) {
        return " " + strSpadesState[n] + " ";
    }

    static String PrintEvents(int n) {
        String string = "EVENT CODE NOT FOUND";
        for (int i = 0; i < strEventCodes.length; ++i) {
            if (n != strEventCodes[i]) continue;
            string = strEventNames[i];
            break;
        }
        return " " + string + " ";
    }

    void PrintPlayerHands(int n) {
        if ((this.controlFlags & 3) != 0) {
            this.Debug_Message(null, "_______________________________________________________");
            for (int i = 0; i < this.numPlayers; ++i) {
                this.Debug_Message(this, "Player " + i + ": " + CardUtils.StringHand(this.playerHand[i], n));
            }
        }
    }

    void PrintPlayerHandsGin(int n) {
        if ((this.controlFlags & 3) != 0) {
            this.Debug_Message(null, "_______________________________________________________");
            for (int i = 0; i < this.numPlayers; ++i) {
                if ((this.controlFlags & 0x10) != 0) {
                    this.Debug_Message(this, "Eng. Player " + i + ": " + CafeCardsEngine.StringGinHand(this.playerHand[i], this.meldData[i], n));
                }
                if (this.player[i] != null) {
                    this.Debug_Message(this, "AI   Player " + i + ": " + this.player[i].StringGinHandPlay(false));
                    this.Debug_Message(this, "    => " + this.player[i].StringGinHandPlay(true));
                    continue;
                }
                this.Debug_Message(this, "Player " + i + ": " + CardUtils.StringHand(this.playerHand[i], n));
            }
        }
    }

    void PrintCardPile() {
        if ((this.controlFlags & 3) != 0) {
            this.Debug_Message(null, "_______________________________________________________");
            this.Debug_Message(this, " Card Pile: " + CardUtils.StringHand(this.pile, this.pile.length));
        }
    }

    static String StringGinHand(byte[] byArray, byte[] byArray2, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + CardUtils.DecodeString(byArray[i]);
            if (byArray2[i] == 0) {
                string = string + "~";
            }
            string = i + 1 < n && byArray2[i + 1] != byArray2[i] ? string + "; " : string + " ";
        }
        return string;
    }

    static String PrintCCMsg(int n) {
        for (int i = 0; i < typeCCMsgClt.length; ++i) {
            if (typeCCMsgClt[i] != n) continue;
            return " " + strCCMsgSvr[i] + " ";
        }
        return " MESSAGE_NOT_FOUND ";
    }

    boolean Verbose() {
        return (this.controlFlags & 3) != 0;
    }
}

