/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class TrackShortcut {
    private Track mTrack;
    public int numBasePoints;
    public int numInterpolationSteps;
    public float roadSideWidth;
    private float roadSideWallHeight;
    public int startPoint;
    public int endPoint;
    public int numIPoints;
    public int[] startPoints = new int[4];
    public int[] endPoints = new int[4];
    public int startSide;
    public int endSide;
    public Vector3D[] iPoints;
    public float[] iPointsWidth;
    public float[] iPointsAngle;
    public short[] roadVertices;
    public short[] leftSideVertices;
    public short[] rightSideVertices;
    public short[] leftWallVertices;
    public short[] rightWallVertices;
    public float[] xPoints;
    public float[] yPoints;
    public float[] zPoints;
    public float[] wPoints;
    public float[] aPoints;
    public Mesh[] meshTrackSegments;
    public Mesh[] meshLeftSideSegments;
    public Mesh[] meshRightSideSegments;
    public Mesh[] meshLeftWallSegments;
    public Mesh[] meshRightWallSegments;
    public int[] mainRoadTextureNr;
    public int[] leftSideTextureNr;
    public int[] rightSideTextureNr;
    public int[] leftWallTextureNr;
    public int[] rightWallTextureNr;

    public TrackShortcut(Track track, int sp, int ep, int n, int steps, int rw) {
        this.mTrack = track;
        this.startPoint = sp;
        this.endPoint = ep;
        this.numBasePoints = n;
        this.numInterpolationSteps = steps;
        this.roadSideWidth = rw;
        this.roadSideWallHeight = 100.0f;
        this.xPoints = new float[n];
        this.yPoints = new float[n];
        this.zPoints = new float[n];
        this.wPoints = new float[n];
        this.aPoints = new float[n];
    }

    public void createGeometry() {
        Spline[] xSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.xPoints);
        Spline[] ySpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.yPoints);
        Spline[] zSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.zPoints);
        Spline[] wSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.wPoints);
        Spline[] aSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.aPoints);
        int size = this.numInterpolationSteps * (this.numBasePoints - 1) + 1;
        this.iPoints = new Vector3D[size];
        this.iPointsWidth = new float[size];
        this.iPointsAngle = new float[size];
        int iPointNr = 0;
        this.iPoints[iPointNr] = new Vector3D(xSpline[0].eval(0.0f), zSpline[0].eval(0.0f), ySpline[0].eval(0.0f));
        this.iPointsWidth[iPointNr] = wSpline[0].eval(0.0f);
        this.iPointsAngle[iPointNr] = aSpline[0].eval(0.0f);
        ++iPointNr;
        for (int i = 0; i < this.numBasePoints - 1; ++i) {
            for (int j = 1; j <= this.numInterpolationSteps; ++j) {
                float u = (float)j / (float)this.numInterpolationSteps;
                this.iPoints[iPointNr] = new Vector3D(xSpline[i].eval(u), zSpline[i].eval(u), ySpline[i].eval(u));
                this.iPointsWidth[iPointNr] = wSpline[i].eval(u);
                this.iPointsAngle[iPointNr] = aSpline[i].eval(u);
                ++iPointNr;
            }
        }
        this.roadVertices = new short[this.iPoints.length * 2 * 3];
        this.leftSideVertices = new short[this.iPoints.length * 2 * 3];
        this.rightSideVertices = new short[this.iPoints.length * 2 * 3];
        this.leftWallVertices = new short[this.iPoints.length * 2 * 3];
        this.rightWallVertices = new short[this.iPoints.length * 2 * 3];
        int vCount = 0;
        for (int i = 0; i < this.iPoints.length; ++i) {
            Vector3D vTmp = i < this.iPoints.length - 1 ? Vector3D.sub(this.iPoints[i + 1], this.iPoints[i]) : Vector3D.sub(this.iPoints[i], this.iPoints[i - 1]);
            vTmp.normalize();
            Vector3D vUp = new Vector3D(0.0f, 1.0f, 0.0f);
            float angle = (float)((double)this.iPointsAngle[i] * Math.PI / 180.0);
            if (angle != 0.0f) {
                float nx = (float)((double)vUp.getx() * mMath.cos(angle) - (double)vUp.gety() * mMath.sin(angle));
                float ny = (float)((double)vUp.getx() * mMath.sin(angle) + (double)vUp.gety() * mMath.cos(angle));
                float nz = vUp.getz();
                vUp.set(nx, ny, nz);
            }
            Vector3D vC = Vector3D.crossProduct(vTmp, vUp);
            Vector3D vD = new Vector3D(vC);
            vC.scalarMul(this.iPointsWidth[i]);
            vD.scalarMul(this.iPointsWidth[i] + this.roadSideWidth * (float)Track.mScale);
            Vector3D v1 = Vector3D.sub(this.iPoints[i], vC);
            Vector3D v2 = Vector3D.add(this.iPoints[i], vC);
            Vector3D v3 = Vector3D.sub(this.iPoints[i], vD);
            Vector3D v4 = Vector3D.add(this.iPoints[i], vD);
            this.roadVertices[vCount + 0] = (short)v1.getx();
            this.roadVertices[vCount + 1] = (short)v1.gety();
            this.roadVertices[vCount + 2] = (short)v1.getz();
            this.leftSideVertices[vCount + 0] = (short)v3.getx();
            this.leftSideVertices[vCount + 1] = (short)v3.gety();
            this.leftSideVertices[vCount + 2] = (short)v3.getz();
            this.rightSideVertices[vCount + 0] = (short)v2.getx();
            this.rightSideVertices[vCount + 1] = (short)v2.gety();
            this.rightSideVertices[vCount + 2] = (short)v2.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)(v3.gety() + this.roadSideWallHeight * (float)Track.mScale);
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)(v4.gety() + this.roadSideWallHeight * (float)Track.mScale);
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            this.roadVertices[(vCount += 3) + 0] = (short)v2.getx();
            this.roadVertices[vCount + 1] = (short)v2.gety();
            this.roadVertices[vCount + 2] = (short)v2.getz();
            this.leftSideVertices[vCount + 0] = (short)v1.getx();
            this.leftSideVertices[vCount + 1] = (short)v1.gety();
            this.leftSideVertices[vCount + 2] = (short)v1.getz();
            this.rightSideVertices[vCount + 0] = (short)v4.getx();
            this.rightSideVertices[vCount + 1] = (short)v4.gety();
            this.rightSideVertices[vCount + 2] = (short)v4.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)v3.gety();
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)v4.gety();
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            vCount += 3;
        }
    }

    public void createMeshes() {
        TriangleStripArray ts;
        VertexArray vaCoordinates;
        VertexArray vaPositions;
        VertexBuffer vb;
        int[] ttIndices;
        int i;
        this.meshTrackSegments = new Mesh[this.numBasePoints - 1];
        this.meshLeftSideSegments = new Mesh[this.numBasePoints - 1];
        this.meshRightSideSegments = new Mesh[this.numBasePoints - 1];
        this.meshLeftWallSegments = new Mesh[this.numBasePoints - 1];
        this.meshRightWallSegments = new Mesh[this.numBasePoints - 1];
        short[] segVertex = new short[this.numInterpolationSteps * 4 * 3];
        short[] segCoords = new short[this.numInterpolationSteps * 4 * 2];
        int[] segIndices = new int[this.numInterpolationSteps * 4];
        int vIndex = 0;
        int cIndex = 0;
        int iIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            int j;
            int j2;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.roadVertices.length - 1) {
                        vIndex = -j2;
                    }
                    segVertex[k * 12 + j2] = this.roadVertices[vIndex + j2];
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                int inr = i * this.numInterpolationSteps + j;
                for (int m = 0; m < 8; ++m) {
                    segCoords[j * 8 + m] = (short)Track.TXT_TILES_COORDINATES[this.mainRoadTextureNr[inr]][m];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (j2 = 0; j2 < ttIndices.length; ++j2) {
                ttIndices[j2] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshTrackSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.mTrack.roadAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (int j3 = 0; j3 < 12; ++j3) {
                    if (vIndex + j3 > this.leftSideVertices.length - 1) {
                        vIndex = -j3;
                    }
                    segVertex[k * 12 + j3] = this.leftSideVertices[vIndex + j3];
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                int inr = i * this.numInterpolationSteps + j;
                for (int m = 0; m < 8; ++m) {
                    segCoords[j * 8 + m] = (short)Track.TXT_TILES_COORDINATES[this.leftSideTextureNr[inr]][m];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j4 = 0; j4 < ttIndices.length; ++j4) {
                ttIndices[j4] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshLeftSideSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.mTrack.roadAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (int j5 = 0; j5 < 12; ++j5) {
                    if (vIndex + j5 > this.rightSideVertices.length - 1) {
                        vIndex = -j5;
                    }
                    segVertex[k * 12 + j5] = this.rightSideVertices[vIndex + j5];
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                int inr = i * this.numInterpolationSteps + j;
                for (int m = 0; m < 8; ++m) {
                    segCoords[j * 8 + m] = (short)Track.TXT_TILES_COORDINATES[this.rightSideTextureNr[inr]][m];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j6 = 0; j6 < ttIndices.length; ++j6) {
                ttIndices[j6] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshRightSideSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.mTrack.roadAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (int j7 = 0; j7 < 12; ++j7) {
                    if (vIndex + j7 > this.leftWallVertices.length - 1) {
                        vIndex = -j7;
                    }
                    segVertex[k * 12 + j7] = this.leftWallVertices[vIndex + j7];
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                for (int m = 0; m < 8; ++m) {
                    segCoords[j * 8 + m] = (short)Track.TXT_TILES_COORDINATES[7][m];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j8 = 0; j8 < ttIndices.length; ++j8) {
                ttIndices[j8] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshLeftWallSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.mTrack.wallAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (int j9 = 0; j9 < 12; ++j9) {
                    if (vIndex + j9 > this.rightWallVertices.length - 1) {
                        vIndex = -j9;
                    }
                    segVertex[k * 12 + j9] = this.rightWallVertices[vIndex + j9];
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                for (int m = 0; m < 8; ++m) {
                    segCoords[j * 8 + m] = (short)Track.TXT_TILES_COORDINATES[7][m];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j10 = 0; j10 < ttIndices.length; ++j10) {
                ttIndices[j10] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshRightWallSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.mTrack.wallAp);
        }
    }

    public void updateFitPoints() {
        int index;
        if (this.startSide == 0) {
            index = this.startPoints[0];
            this.leftWallVertices[0] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[1] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[2] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[4] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[5] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[0] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[1];
            this.leftSideVertices[3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[1];
            this.roadVertices[0] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[2];
            this.roadVertices[3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[2];
            this.rightSideVertices[0] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[3];
            this.rightSideVertices[3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[0] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[1] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[2] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[4] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[5] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
        } else {
            index = this.startPoints[3];
            this.leftWallVertices[0] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[1] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[2] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[4] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[5] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[0] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[2];
            this.leftSideVertices[3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[2];
            this.roadVertices[0] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[1];
            this.roadVertices[3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[1];
            this.rightSideVertices[0] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[0];
            this.rightSideVertices[3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            this.rightWallVertices[0] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[1] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[2] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[4] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[5] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
        }
        if (this.endSide == 0) {
            index = this.endPoints[3];
            this.leftWallVertices[this.leftWallVertices.length - 6] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 5] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 4] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[this.leftWallVertices.length - 3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 2] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 1] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[this.leftSideVertices.length - 6] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[2];
            this.leftSideVertices[this.leftSideVertices.length - 3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[2];
            this.roadVertices[this.roadVertices.length - 6] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[this.roadVertices.length - 5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[this.roadVertices.length - 4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[1];
            this.roadVertices[this.roadVertices.length - 3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[this.roadVertices.length - 2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[this.roadVertices.length - 1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[1];
            this.rightSideVertices[this.rightSideVertices.length - 6] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[0];
            this.rightSideVertices[this.rightSideVertices.length - 3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 6] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 5] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 4] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 2] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 1] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
        } else {
            index = this.endPoints[0];
            this.leftWallVertices[this.leftWallVertices.length - 6] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 5] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 4] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[this.leftWallVertices.length - 3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 2] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 1] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[this.leftSideVertices.length - 6] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[1];
            this.leftSideVertices[this.leftSideVertices.length - 3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[1];
            this.roadVertices[this.roadVertices.length - 6] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[this.roadVertices.length - 5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[this.roadVertices.length - 4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[2];
            this.roadVertices[this.roadVertices.length - 3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[this.roadVertices.length - 2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[this.roadVertices.length - 1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[2];
            this.rightSideVertices[this.rightSideVertices.length - 6] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[3];
            this.rightSideVertices[this.rightSideVertices.length - 3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 6] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 5] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 4] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 2] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 1] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
        }
    }
}

