/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class AI {
    private static final int NONE = 0;
    private static final int RUN_AWAY = 1;
    private static final int GO = 2;
    private static final int AVOID = 3;
    private static final int COLLECT = 4;
    private static final int ATTACK = 5;
    private static Random random = new Random();
    public int state;
    private Kart kart;
    private float accuracy;
    private float aggressivity;
    private float itemity;
    private float insurance;
    private float drifting;
    public boolean sleeping;
    private static RaceManager m_Race;
    private Vector3D kartPos;
    private Vector3D kartDir;
    private Vector3D trackDir;
    private Vector3D dist;
    private Vector3D target;
    private Vector3D v;
    private Vector3D potentialTarget;
    private float dir;
    private float attackRange;
    private float itemRange;
    private float insuranceRange;
    private int IPOINT_RANGE;
    private boolean[] shortcutFound;
    private boolean ghost;

    public void setSleep() {
        this.sleeping = true;
    }

    public void setAwake() {
        this.state = 0;
        this.sleeping = false;
    }

    public void init(Kart _kart, RaceManager _race, float _accuracy, float _aggressivity, float _itemity, float _insurance, float _drifting) {
        this.kart = _kart;
        this.accuracy = _accuracy;
        this.aggressivity = _aggressivity;
        this.itemity = _itemity;
        this.insurance = _insurance;
        this.drifting = _drifting;
        this.attackRange = 100.0f * (float)Track.mScale;
        this.itemRange = 65.0f * (float)Track.mScale;
        this.insuranceRange = 30.0f * (float)Track.mScale;
        this.IPOINT_RANGE = 10;
        this.state = 0;
        m_Race = _race;
        this.kartPos = new Vector3D();
        this.kartDir = new Vector3D();
        this.trackDir = new Vector3D();
        this.dist = new Vector3D();
        this.target = new Vector3D();
        this.potentialTarget = new Vector3D();
        this.v = new Vector3D();
        this.shortcutFound = new boolean[AI.m_Race.m_Track.mShortcutsArray.size()];
        this.ghost = false;
        if (GameLogic.gameMode == 3 && !this.kart.isPlayer) {
            this.ghost = true;
        }
    }

    private void use() {
        switch (this.kart.getItem()) {
            case -2: 
            case -1: {
                break;
            }
            case 3: {
                if (!this.kart.isTrap) {
                    this.kart.useItem();
                    break;
                }
                for (int i = 0; i < AI.m_Race.m_Karts.length; ++i) {
                    if (AI.m_Race.m_Karts[i] == this.kart) continue;
                    this.dist.set(AI.m_Race.m_Karts[i].getPosition());
                    this.dist.sub(this.kartPos);
                    if (!(this.dist.quaterLength() < this.attackRange * this.attackRange) || !(this.kartDir.FBdir(this.dist) < -this.accuracy)) continue;
                    this.kart.useItem();
                    return;
                }
                break;
            }
            case 6: {
                if (this.kart.isAutopilot) break;
                this.kart.useItem();
                break;
            }
            case 1: {
                if (this.kart.isBoosted) break;
                this.kart.useItem();
                break;
            }
            case 4: {
                if (this.kart.isFatality) break;
                this.kart.useItem();
                break;
            }
            case 5: {
                if (this.kart.isInvincible) break;
                this.kart.useItem();
                break;
            }
            case 2: {
                if (!this.kart.isKatamari) {
                    this.kart.useItem();
                    break;
                }
                for (int i = 0; i < AI.m_Race.m_Karts.length; ++i) {
                    if (AI.m_Race.m_Karts[i] == this.kart) continue;
                    this.dist.set(AI.m_Race.m_Karts[i].getPosition());
                    this.dist.sub(this.kartPos);
                    if (!(this.dist.quaterLength() < this.attackRange * this.attackRange) || !(this.kartDir.FBdir(this.dist) > this.accuracy)) continue;
                    this.kart.useItem();
                    return;
                }
                break;
            }
        }
    }

    private void avoid() {
        float len;
        boolean check;
        int i;
        if (this.kart.isInvincible) {
            return;
        }
        float minLen = this.insuranceRange * this.insuranceRange;
        boolean found = false;
        for (i = 0; i < AI.m_Race.trackHelpersType[0].length; ++i) {
            check = false;
            if (AI.m_Race.trackHelpersType[0][i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                if (AI.m_Race.trackHelpersType[0][i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                    if (AI.m_Race.trackHelpersType[0][i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                        check = true;
                    }
                } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.trackHelpersType[0][i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                    check = true;
                }
            }
            if (!check) continue;
            this.dist.set(AI.m_Race.trackHelpersType[0][i].getPosition());
            this.dist.sub(this.kartPos);
            len = this.dist.quaterLength();
            if (!(len < AI.m_Race.trackHelpersType[0][i].getCollisionRadius() + 400.0f)) continue;
            this.dir = this.kartDir.FBdir(this.dist);
            if (!(this.dir > 0.0f) || !(1.0f - AI.m_Race.trackHelpersType[0][i].getCollisionRadius() / len < (this.dir + this.insurance) * (this.dir + this.insurance))) continue;
            this.kart.handbrakePush();
            this.kart.handbrakeRelease();
        }
        for (i = 0; i < AI.m_Race.m_StaticElements.length; ++i) {
            check = false;
            if (AI.m_Race.m_StaticElements[i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                if (AI.m_Race.m_StaticElements[i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                    if (AI.m_Race.m_StaticElements[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                        check = true;
                    }
                } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.m_StaticElements[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                    check = true;
                }
            }
            if (!check) continue;
            this.dist.set(AI.m_Race.m_StaticElements[i].getPosition());
            this.dist.sub(this.kartPos);
            len = this.dist.quaterLength();
            if (!(len < minLen)) continue;
            this.dir = this.kartDir.FBdir(this.dist);
            if (!(this.dir > 0.0f) || !(1.0f - AI.m_Race.m_StaticElements[i].getCollisionQuaterDist() / len < (this.dir + this.insurance) * (this.dir + this.insurance))) continue;
            found = true;
            minLen = len;
            this.potentialTarget = AI.m_Race.m_StaticElements[i].getPosition();
        }
        if (GameLogic.gameMode != 2 && GameLogic.gameItems) {
            for (i = 0; i < AI.m_Race.m_DynamicItems.length; ++i) {
                check = false;
                if (AI.m_Race.m_DynamicItems[i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                    if (AI.m_Race.m_DynamicItems[i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                        if (AI.m_Race.m_DynamicItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                            check = true;
                        }
                    } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.m_DynamicItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                        check = true;
                    }
                }
                if (!check || !AI.m_Race.m_DynamicItems[i].getActive()) continue;
                this.dist.set(AI.m_Race.m_DynamicItems[i].getPosition());
                this.dist.sub(this.kartPos);
                len = this.dist.quaterLength();
                if (!(len < minLen)) continue;
                this.dir = this.kartDir.FBdir(this.dist);
                if (!(this.dir > 0.0f) || !(1.0f - AI.m_Race.m_DynamicItems[i].getCollisionQuaterDist() / len < (this.dir + this.insurance) * (this.dir + this.insurance))) continue;
                found = true;
                minLen = len;
                this.potentialTarget = AI.m_Race.m_DynamicItems[i].getPosition();
            }
            if (GameLogic.gameItems) {
                for (i = 0; i < AI.m_Race.m_SpawnableItems.length; ++i) {
                    check = false;
                    if (AI.m_Race.m_SpawnableItems[i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                        if (AI.m_Race.m_SpawnableItems[i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                            if (AI.m_Race.m_SpawnableItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                                check = true;
                            }
                        } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.m_SpawnableItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                            check = true;
                        }
                    }
                    if (!check || !AI.m_Race.m_SpawnableItems[i].getActive()) continue;
                    this.dist.set(AI.m_Race.m_SpawnableItems[i].getPosition());
                    this.dist.sub(this.kartPos);
                    len = this.dist.quaterLength();
                    if (!(len < minLen)) continue;
                    this.dir = this.kartDir.FBdir(this.dist);
                    if (!(this.dir > 0.0f) || !(1.0f - AI.m_Race.m_SpawnableItems[i].getCollisionQuaterDist() / len < (this.dir + this.insurance) * (this.dir + this.insurance))) continue;
                    found = true;
                    minLen = len;
                    this.potentialTarget = AI.m_Race.m_SpawnableItems[i].getPosition();
                }
            }
        }
        if (found) {
            this.state = 3;
            this.target = this.potentialTarget;
        }
    }

    private void collect() {
        float len;
        boolean check;
        int i;
        if (this.kart.isScarred) {
            return;
        }
        float minLen = this.itemRange * this.itemRange;
        boolean found = false;
        if (GameLogic.gameMode != 2) {
            if (this.kart.collectibleCounter < Kart.MAX_COLLECTIBLES) {
                for (i = 0; i < AI.m_Race.m_StaticItems.length; ++i) {
                    check = false;
                    if (AI.m_Race.m_StaticItems[i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                        if (AI.m_Race.m_StaticItems[i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                            if (AI.m_Race.m_StaticItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                                check = true;
                            }
                        } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.m_StaticItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                            check = true;
                        }
                    }
                    if (!check || !AI.m_Race.m_StaticItems[i].getActive()) continue;
                    this.dist.set(AI.m_Race.m_StaticItems[i].getPosition());
                    this.dist.sub(this.kartPos);
                    len = this.dist.quaterLength();
                    if (!(len < minLen) || !this.ghost && !this.trackDir.isFdir(this.dist) || !(this.kartDir.FBdir(this.dist) > 1.0f - this.itemity)) continue;
                    found = true;
                    minLen = len;
                    this.potentialTarget = AI.m_Race.m_StaticItems[i].getPosition();
                }
            }
            if (GameLogic.gameItems) {
                for (i = 0; i < AI.m_Race.m_RespawnableItems.length; ++i) {
                    check = false;
                    if (AI.m_Race.m_RespawnableItems[i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                        if (AI.m_Race.m_RespawnableItems[i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                            if (AI.m_Race.m_RespawnableItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                                check = true;
                            }
                        } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.m_RespawnableItems[i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                            check = true;
                        }
                    }
                    if (!check || !AI.m_Race.m_RespawnableItems[i].getActive()) continue;
                    this.dist.set(AI.m_Race.m_RespawnableItems[i].getPosition());
                    this.dist.sub(this.kartPos);
                    len = this.dist.quaterLength();
                    if (!(len < minLen) || !this.ghost && !this.trackDir.isFdir(this.dist) || !(this.kartDir.FBdir(this.dist) > 1.0f - this.itemity)) continue;
                    found = true;
                    minLen = len;
                    this.potentialTarget = AI.m_Race.m_RespawnableItems[i].getPosition();
                }
            }
        }
        for (i = 0; i < AI.m_Race.trackHelpersType[1].length; ++i) {
            check = false;
            if (AI.m_Race.trackHelpersType[1][i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                if (AI.m_Race.trackHelpersType[1][i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                    if (AI.m_Race.trackHelpersType[1][i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                        check = true;
                    }
                } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.trackHelpersType[1][i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                    check = true;
                }
            }
            if (!check) continue;
            this.dist.set(AI.m_Race.trackHelpersType[1][i].getPosition());
            this.dist.sub(this.kartPos);
            len = this.dist.quaterLength();
            if (!(len < minLen) || !this.ghost && !this.trackDir.isFdir(this.dist) || !(this.kartDir.FBdir(this.dist) > 1.0f - this.itemity)) continue;
            found = true;
            minLen = len;
            this.potentialTarget = AI.m_Race.trackHelpersType[1][i].getPosition();
        }
        for (i = 0; i < AI.m_Race.trackHelpersType[2].length; ++i) {
            check = false;
            if (AI.m_Race.trackHelpersType[2][i].nearestPoint[1] == this.kart.nearestPoint[1]) {
                if (AI.m_Race.trackHelpersType[2][i].nearestPoint[0] >= this.kart.nearestPoint[0]) {
                    if (AI.m_Race.trackHelpersType[2][i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                        check = true;
                    }
                } else if (this.kart.nearestPoint[1] == 0 && AI.m_Race.m_Track.iPoints.length + AI.m_Race.trackHelpersType[2][i].nearestPoint[0] <= this.kart.nearestPoint[0] + this.IPOINT_RANGE) {
                    check = true;
                }
            }
            if (!check) continue;
            this.dist.set(AI.m_Race.trackHelpersType[2][i].getPosition());
            this.dist.sub(this.kartPos);
            len = this.dist.quaterLength();
            if (!(len < minLen) || !this.ghost && !this.trackDir.isFdir(this.dist) || !(this.kartDir.FBdir(this.dist) > 1.0f - this.itemity)) continue;
            found = true;
            minLen = len;
            this.potentialTarget = AI.m_Race.trackHelpersType[2][i].getPosition();
        }
        if (found) {
            this.state = 4;
            this.target = this.potentialTarget;
        }
    }

    private void attack() {
        if (this.kart.isScarred) {
            return;
        }
        int to = -1;
        float tod = -1.0f;
        for (int i = 0; i < AI.m_Race.m_Karts.length; ++i) {
            if (AI.m_Race.m_Karts[i] == this.kart || !this.kart.isInvincible && (AI.m_Race.m_Karts[i].isInvincible || AI.m_Race.m_Karts[i].isKatamari || AI.m_Race.m_Karts[i].isAutopilot && !this.kart.isKatamari && !this.kart.isAutopilot)) continue;
            this.dist.set(AI.m_Race.m_Karts[i].getPosition());
            this.dist.sub(this.kartPos);
            if (!(this.dist.quaterLength() < this.attackRange * this.attackRange) || !this.trackDir.isFdir(this.dist)) continue;
            this.dir = this.kartDir.FBdir(this.dist);
            if (!(this.dir > 1.0f - this.aggressivity) || !(this.dir > tod)) continue;
            tod = this.dir;
            to = i;
        }
        if (to >= 0) {
            this.state = 5;
            this.target = AI.m_Race.m_Karts[to].getPosition();
        }
    }

    private void go() {
        this.state = 2;
        int nextIp = this.kart.nearestPoint[0];
        boolean visible = true;
        if (this.kart.nearestPoint[1] == 0) {
            int i;
            for (int s = 0; s < AI.m_Race.m_Track.mShortcutsArray.size(); ++s) {
                TrackShortcut sc = (TrackShortcut)AI.m_Race.m_Track.mShortcutsArray.elementAt(s);
                if (nextIp >= sc.startPoints[3] || nextIp <= sc.startPoints[0] - 4) continue;
                if (this.shortcutFound[s]) {
                    this.target = sc.iPoints[4];
                    return;
                }
                if (random.nextFloat() * 100.0f < 0.1f) {
                    this.shortcutFound[s] = true;
                    this.target = sc.iPoints[4];
                    return;
                }
                for (i = 0; i < AI.m_Race.m_Karts.length; ++i) {
                    if (AI.m_Race.m_Karts[i].nearestPoint[1] != s + 1) continue;
                    this.shortcutFound[s] = true;
                    this.target = sc.iPoints[4];
                    return;
                }
            }
            int nextIpr = nextIp;
            do {
                ++nextIpr;
                if (++nextIp > AI.m_Race.m_Track.iPoints.length - 1) {
                    nextIp -= AI.m_Race.m_Track.iPoints.length - 1;
                }
                this.dist.set(AI.m_Race.m_Track.iPoints[nextIp]);
                this.dist.sub(this.kartPos);
                for (i = this.kart.nearestPoint[0] + 1; i < nextIpr && visible; ++i) {
                    if (i > AI.m_Race.m_Track.iPoints.length - 1) {
                        i -= AI.m_Race.m_Track.iPoints.length - 1;
                    }
                    this.v.setx(AI.m_Race.m_Track.roadVertices[6 * i + 0]);
                    this.v.setz(AI.m_Race.m_Track.roadVertices[6 * i + 2]);
                    if (this.dist.LRdirSign(this.v) < 0) {
                        visible = false;
                    }
                    this.v.setx(AI.m_Race.m_Track.roadVertices[6 * i + 3]);
                    this.v.setz(AI.m_Race.m_Track.roadVertices[6 * i + 5]);
                    if (this.dist.LRdirSign(this.v) <= 0) continue;
                    visible = false;
                }
            } while (visible);
            this.target = AI.m_Race.m_Track.iPoints[nextIp];
        } else {
            this.shortcutFound[this.kart.nearestPoint[1] - 1] = true;
            TrackShortcut sc = (TrackShortcut)AI.m_Race.m_Track.mShortcutsArray.elementAt(this.kart.nearestPoint[1] - 1);
            do {
                if (++nextIp > sc.iPoints.length - 1) {
                    this.target = AI.m_Race.m_Track.iPoints[sc.endPoints[3]];
                    return;
                }
                this.dist.set(sc.iPoints[nextIp]);
                this.dist.sub(this.kartPos);
                for (int i = this.kart.nearestPoint[0] + 1; i < nextIp && visible; ++i) {
                    this.v.setx(sc.roadVertices[6 * i + 0]);
                    this.v.setz(sc.roadVertices[6 * i + 2]);
                    if (this.dist.LRdirSign(this.v) < 0) {
                        visible = false;
                    }
                    this.v.setx(sc.roadVertices[6 * i + 3]);
                    this.v.setz(sc.roadVertices[6 * i + 5]);
                    if (this.dist.LRdirSign(this.v) <= 0) continue;
                    visible = false;
                }
            } while (visible);
            this.target = sc.iPoints[nextIp];
        }
    }

    private void drive() {
        this.dist.set(this.target);
        this.dist.sub(this.kartPos);
        float centerEnd = 0.15f * (float)AI.m_Race.m_Track.iPoints.length;
        if ((float)(this.kart.actPos - AI.m_Race.m_Track.iPoints.length) < centerEnd) {
            this.v.set(this.kart.posOffset);
            this.v.scalarMul(1.0f - (float)(this.kart.actPos - AI.m_Race.m_Track.iPoints.length) / centerEnd);
            this.dist.add(this.v);
        }
        float LRdir = this.kartDir.LRdir(this.dist);
        this.dir = this.kartDir.FBdir(this.dist);
        float prec = 1.0f - this.accuracy;
        this.kart.accelerateRelease();
        this.kart.brakeRelease();
        if (this.state == 3) {
            this.kart.handbrakeRelease();
            this.kart.acceleratePush();
            if (LRdir > prec) {
                this.kart.turnPush((byte)1);
            } else if (LRdir < -prec) {
                this.kart.turnPush((byte)-1);
            } else {
                this.kart.turnRelease();
            }
        } else if (this.state == 1) {
            this.kart.acceleratePush();
            if (this.dir > -this.drifting) {
                this.kart.handbrakePush();
            } else {
                this.kart.handbrakeRelease();
            }
            if (LRdir > prec) {
                this.kart.turnPush((byte)1);
            } else if (LRdir < -prec) {
                this.kart.turnPush((byte)-1);
            } else {
                this.kart.turnRelease();
            }
        } else {
            this.kart.acceleratePush();
            if (this.dir < this.drifting) {
                this.kart.handbrakePush();
            } else {
                this.kart.handbrakeRelease();
            }
            if (LRdir > prec) {
                this.kart.turnPush((byte)-1);
            } else if (LRdir < -prec) {
                this.kart.turnPush((byte)1);
            } else {
                this.kart.turnRelease();
            }
        }
    }

    private int ghostCheckDirection() {
        TrackShortcut sc;
        int hunterNearestPoint = this.kart.nearestPoint[0];
        int victimNearestPoint = AI.m_Race.m_Karts[0].nearestPoint[0];
        if (this.kart.nearestPoint[1] != 0) {
            sc = (TrackShortcut)AI.m_Race.m_Track.mShortcutsArray.elementAt(this.kart.nearestPoint[1] - 1);
            hunterNearestPoint = sc.startPoints[0] + hunterNearestPoint / sc.iPoints.length * (sc.endPoints[0] - sc.startPoints[0]);
        }
        if (AI.m_Race.m_Karts[0].nearestPoint[1] != 0) {
            sc = (TrackShortcut)AI.m_Race.m_Track.mShortcutsArray.elementAt(AI.m_Race.m_Karts[0].nearestPoint[1] - 1);
            victimNearestPoint = sc.startPoints[0] + victimNearestPoint / sc.iPoints.length * (sc.endPoints[0] - sc.startPoints[0]);
        }
        if (victimNearestPoint - hunterNearestPoint >= 0) {
            if (victimNearestPoint - hunterNearestPoint <= AI.m_Race.m_Track.iPoints.length >> 1) {
                return 1;
            }
            return -1;
        }
        if (victimNearestPoint - hunterNearestPoint <= -(AI.m_Race.m_Track.iPoints.length >> 1)) {
            return 1;
        }
        return -1;
    }

    private void ghostAttack() {
        this.dist.set(AI.m_Race.m_Karts[0].getPosition());
        this.dist.sub(this.kartPos);
        if (this.kart.isScarred) {
            if (this.dist.quaterLength() < 10000.0f) {
                this.target = AI.m_Race.m_Karts[0].getPosition();
                this.state = 1;
            }
        } else if (this.dist.quaterLength() < 250000.0f) {
            this.target = AI.m_Race.m_Karts[0].getPosition();
            this.state = 5;
        }
    }

    private void ghostGo() {
        int victDir = this.ghostCheckDirection();
        if (this.kart.isScarred) {
            victDir = -victDir;
        }
        this.state = 2;
        int nextIp = this.kart.nearestPoint[0];
        boolean visible = true;
        if (this.kart.nearestPoint[1] == 0) {
            for (int s = 0; s < AI.m_Race.m_Track.mShortcutsArray.size(); ++s) {
                TrackShortcut sc = (TrackShortcut)AI.m_Race.m_Track.mShortcutsArray.elementAt(s);
                if (nextIp >= sc.startPoints[3] || nextIp <= sc.startPoints[0] - 4 || victDir != 1) continue;
                this.target = sc.iPoints[4];
                return;
            }
            int nextIpr = nextIp;
            do {
                nextIpr += victDir;
                if ((nextIp += victDir) > AI.m_Race.m_Track.iPoints.length - 1) {
                    nextIp -= AI.m_Race.m_Track.iPoints.length - 1;
                }
                if (nextIp < 0) {
                    nextIp += AI.m_Race.m_Track.iPoints.length - 1;
                }
                this.dist.set(AI.m_Race.m_Track.iPoints[nextIp]);
                this.dist.sub(this.kartPos);
                int i = this.kart.nearestPoint[0] + victDir;
                while ((nextIpr - i) * victDir > 0 && visible) {
                    if (i > AI.m_Race.m_Track.iPoints.length - 1) {
                        i -= AI.m_Race.m_Track.iPoints.length - 1;
                    }
                    if (i < 0) {
                        i += AI.m_Race.m_Track.iPoints.length - 1;
                    }
                    this.v.setx(AI.m_Race.m_Track.roadVertices[6 * i + 0]);
                    this.v.setz(AI.m_Race.m_Track.roadVertices[6 * i + 2]);
                    if (this.dist.LRdirSign(this.v) < 0) {
                        visible = false;
                    }
                    this.v.setx(AI.m_Race.m_Track.roadVertices[6 * i + 3]);
                    this.v.setz(AI.m_Race.m_Track.roadVertices[6 * i + 5]);
                    if (this.dist.LRdirSign(this.v) > 0) {
                        visible = false;
                    }
                    i += victDir;
                }
            } while (visible);
            this.target = AI.m_Race.m_Track.iPoints[nextIp];
        } else {
            TrackShortcut sc = (TrackShortcut)AI.m_Race.m_Track.mShortcutsArray.elementAt(this.kart.nearestPoint[1] - 1);
            do {
                if (++nextIp > sc.iPoints.length - 1) {
                    this.target = AI.m_Race.m_Track.iPoints[sc.endPoints[3]];
                    return;
                }
                this.dist.set(sc.iPoints[nextIp]);
                this.dist.sub(this.kartPos);
                for (int i = this.kart.nearestPoint[0] + 1; i < nextIp && visible; ++i) {
                    this.v.setx(sc.roadVertices[6 * i + 0]);
                    this.v.setz(sc.roadVertices[6 * i + 2]);
                    if (this.dist.LRdirSign(this.v) < 0) {
                        visible = false;
                    }
                    this.v.setx(sc.roadVertices[6 * i + 3]);
                    this.v.setz(sc.roadVertices[6 * i + 5]);
                    if (this.dist.LRdirSign(this.v) <= 0) continue;
                    visible = false;
                }
            } while (visible);
            this.target = sc.iPoints[nextIp];
        }
    }

    private void ghostThink() {
        this.ghostAttack();
        if (this.state == 0) {
            this.avoid();
        }
        if (this.state == 0) {
            this.collect();
        }
        if (this.state == 0) {
            this.ghostGo();
        }
        this.drive();
    }

    public void think() {
        if (this.sleeping) {
            return;
        }
        this.kartPos.set(this.kart.getPosition());
        this.kartDir.set(this.kart.getBoundingBox()[6]);
        this.kartDir.sub(this.kart.getBoundingBox()[5]);
        this.state = 0;
        if (this.ghost) {
            this.ghostThink();
            return;
        }
        int ap = this.kart.nearestPoint[0];
        int np = ap + 1;
        if (np == AI.m_Race.m_Track.iPoints.length) {
            np = 0;
        }
        this.trackDir.set(AI.m_Race.m_Track.iPoints[np]);
        this.trackDir.sub(AI.m_Race.m_Track.iPoints[ap]);
        this.use();
        this.avoid();
        if (this.state == 0) {
            this.collect();
        }
        if (this.state == 0) {
            this.attack();
        }
        if (this.state == 0) {
            this.go();
        }
        this.drive();
    }

    public void checkStartBoost() {
        if (this.insurance < random.nextFloat()) {
            float prec = this.accuracy - random.nextFloat();
            if (prec >= 0.0f) {
                this.kart.startBoost(prec * 60.0f);
            } else {
                this.kart.startSlowdown(20.0f, true);
            }
        }
        this.think();
    }
}

