/*
 * Decompiled with CFR 0.152.
 */
package mcloud.sik.common;

import mcloud.sik.common.SIK;

public class Timer
implements Runnable {
    private volatile long estimatedTime;
    private int ownerModule;
    private volatile boolean isRunning;
    private volatile boolean isPaused = false;
    private Thread thread = null;

    public void start(int ownerModule, long time) {
        this.estimatedTime = time;
        this.ownerModule = ownerModule;
        if (this.thread == null) {
            this.thread = new Thread(this);
        }
        this.thread.start();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void setPaused(boolean pause) {
        if (this.isRunning) {
            this.isPaused = pause;
        }
    }

    public long getEstimatedTime() {
        return this.estimatedTime;
    }

    public void run() {
        this.isRunning = true;
        try {
            Thread.sleep(100L);
            long lastTime = System.currentTimeMillis();
            while (this.isRunning) {
                if (this.estimatedTime <= 0L) {
                    this.estimatedTime = 0L;
                    SIK.instance.getModule(this.ownerModule).timerCallback();
                    this.stop();
                    this.thread = null;
                    this.ownerModule = -1;
                }
                if (!this.isPaused && this.estimatedTime > 0L) {
                    this.estimatedTime -= System.currentTimeMillis() - lastTime;
                }
                lastTime = System.currentTimeMillis();
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

