/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class SoundManager {
    private static final String[] type = new String[]{".mid", ".wav", ".amr"};
    private static final String[] type2 = new String[]{"audio/midi", "audio/x-wav", "audio/amr"};
    public static Player[] m_sound;
    public static Player music;
    public static Player sfx;
    private static boolean playMusic;
    private static boolean playSound;
    private static boolean vibrate;
    private static int numberOfSounds;
    private static MIDlet midlet;
    private static boolean isPaused;
    private static int prevSfx;
    private static VolumeControl vcMusic;
    private static VolumeControl vcSfx;
    private static int volMusic;
    private static int volSfx;
    private static final long CONF_DURATION = 1000L;
    private static long confZero;
    private static boolean confStarted;

    public static boolean isPlayMusic() {
        return playMusic;
    }

    public static void setPlayMusic(boolean playMusic) {
        SoundManager.playMusic = playMusic;
    }

    public static boolean isPlaySound() {
        return playSound;
    }

    public static void setPlaySound(boolean playSound) {
        SoundManager.playSound = playSound;
    }

    public static boolean isVibrate() {
        return vibrate;
    }

    public static void setVibrate(boolean vibrate) {
        SoundManager.vibrate = vibrate;
    }

    public static void init(MIDlet app) {
        midlet = app;
    }

    public static void loadAll() {
        try {
            int j = 2;
            numberOfSounds = Constant.sfxName.length;
            m_sound = new Player[numberOfSounds];
            for (int i = 0; i < numberOfSounds; ++i) {
                Object obj = new Object();
                SoundManager.m_sound[i] = Manager.createPlayer((InputStream)obj.getClass().getResourceAsStream("/Audio/" + Constant.sfxName[i] + (i == 2 ? type[0] : type[j])), (String)(i == 2 ? type2[0] : type2[j]));
                m_sound[i].realize();
                m_sound[i].prefetch();
                Thread.yield();
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("sound1" + e);
                }
            }
        }
        catch (Exception e) {
            System.out.println("sound2" + e);
        }
    }

    public static void playMusic(int musicToPlay) {
        if (music != null) {
            try {
                music.stop();
                music.deallocate();
                music = null;
                Thread.sleep(50L);
            }
            catch (Exception e) {
                System.out.println("PlayMusic exception while removing current playe.!");
            }
        }
        if (playMusic && musicToPlay != -1) {
            try {
                String path = "";
                path = musicToPlay == 0 ? "/Audio/PacManMenuTheme" + type[0] : "/Audio/PacManCupTheme_" + Stats.worldName[GameLogic.gameWorld] + type[0];
                Object obj = new Object();
                InputStream is = obj.getClass().getResourceAsStream(path);
                music = Manager.createPlayer((InputStream)is, (String)type2[0]);
                music.setLoopCount(-1);
                music.realize();
                music.prefetch();
                vcMusic = (VolumeControl)music.getControl("VolumeControl");
                vcMusic.setLevel(volMusic);
                music.start();
            }
            catch (Exception e) {
                System.out.println("playmusic error");
                System.out.println(e);
            }
        }
    }

    public static void pauseMusic() {
        if (music != null) {
            try {
                music.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            isPaused = true;
        }
    }

    public static void resumeMusic() {
        if (music != null) {
            try {
                if (music.getState() != 400) {
                    music.start();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            isPaused = false;
        }
    }

    public static void playSfx(int sfxToPlay) {
        if (sfxToPlay > Constant.sfxName.length) {
            return;
        }
        if (playSound) {
            try {
                sfx = m_sound[sfxToPlay];
                vcSfx = (VolumeControl)sfx.getControl("VolumeControl");
                vcSfx.setLevel(volSfx);
                if (m_sound[2].getState() == 400) {
                    return;
                }
                sfx.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void stopAllSfx() {
        if (playSound && m_sound != null) {
            for (int i = 0; i < m_sound.length; ++i) {
                try {
                    if (m_sound[i].getState() != 400) continue;
                    m_sound[i].stop();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void vibration(int duration) {
        if (vibrate) {
            Display.getDisplay((MIDlet)midlet).vibrate(duration);
        }
    }

    public static void checkMusic() {
        if (isPaused) {
            return;
        }
        if (music != null && music.getState() != 400) {
            try {
                vcMusic = (VolumeControl)music.getControl("VolumeControl");
                vcMusic.setLevel(volMusic);
                music.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void startConfirmation() {
        if (confStarted) {
            return;
        }
        SoundManager.playMusic(-1);
        SoundManager.playMusic(1);
        confZero = System.currentTimeMillis();
        confStarted = true;
    }

    public static void checkConfirmation() {
        if (!confStarted) {
            return;
        }
        if (System.currentTimeMillis() - confZero >= 1000L) {
            SoundManager.playMusic(-1);
            confStarted = false;
        }
    }

    public static void stopConfirmation() {
        if (confStarted) {
            confStarted = false;
        }
    }

    static {
        playMusic = false;
        playSound = false;
        vibrate = false;
        isPaused = false;
        prevSfx = -1;
        volMusic = 80;
        volSfx = 100;
        confStarted = false;
    }
}

