/*
 * Decompiled with CFR 0.152.
 */
package mcloud.sik.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class NetProtocol {
    public static final byte PROTOCOL_TYPE = 2;
    public static final byte TYPE_STRING = 0;
    public static final byte TYPE_RAW = 2;
    public static final byte TYPE_ARRAY = 3;
    public static final byte TYPE_INT = 4;

    public static NetPacket[] readPackets(InputStream is, int count, String encoding) {
        NetPacket[] packetsList = new NetPacket[count];
        for (int i = 0; i < count; ++i) {
            NetPacket packet = NetProtocol.readPacket(is, encoding);
            if (packet == null) continue;
            packetsList[i] = packet;
        }
        return packetsList;
    }

    public static NetPacket readPacket(InputStream is, String encoding) {
        NetPacket packet = new NetPacket();
        byte[] buffer = new byte[1];
        try {
            is.read(buffer, 0, 1);
            byte protocolType = buffer[0];
            is.read(buffer, 0, 1);
            packet.type = buffer[0];
            int packetLength = NetProtocol.readInt(is);
            if (packet.type == 4) {
                Vector<Object> v = new Vector<Object>();
                while (is.read(buffer, 0, 1) > 0) {
                    Object o = NetProtocol.readObject(is, encoding, buffer[0]);
                    v.addElement(o);
                }
                packet.data = new Object[v.size()];
                v.copyInto(packet.data);
                return packet;
            }
            int num = 0;
            switch (packet.type) {
                case 0: {
                    num = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    num = 1;
                }
            }
            if (num > 0) {
                packet.data = new Object[num];
                for (int i = 0; i < num; ++i) {
                    packet.data[i] = NetProtocol.readObject(is, encoding);
                }
            }
            return packet;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void writeObject(OutputStream os, String encoding, Object object) throws IOException {
        if (object instanceof String) {
            byte[] data = ((String)object).getBytes(encoding);
            os.write(0);
            NetProtocol.writeInt(os, data.length);
            os.write(data);
        } else if (object instanceof byte[]) {
            byte[] data = (byte[])object;
            os.write(2);
            NetProtocol.writeInt(os, data.length);
            os.write(data);
        } else if (object instanceof Object[]) {
            Object[] list = (Object[])object;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            NetProtocol.writeInt(bos, list.length);
            for (int i = 0; i < list.length; ++i) {
                NetProtocol.writeObject(bos, encoding, list[i]);
            }
            byte[] data = bos.toByteArray();
            os.write(3);
            NetProtocol.writeInt(os, data.length);
            os.write(data);
        } else if (object instanceof Integer) {
            os.write(4);
            NetProtocol.writeInt(os, (Integer)object);
        }
    }

    public static void writePacket(OutputStream os, NetPacket packet, String encoding) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < packet.data.length; ++i) {
            NetProtocol.writeObject(bos, encoding, packet.data[i]);
        }
        byte[] data = bos.toByteArray();
        os.write(2);
        os.write(packet.type);
        NetProtocol.writeInt(os, data.length);
        os.write(data);
    }

    static void writeInt(OutputStream os, int i) throws IOException {
        os.write(i & 0xFF);
        os.write(i >> 8 & 0xFF);
        os.write(i >> 16 & 0xFF);
        os.write(i >> 24 & 0xFF);
    }

    static int readInt(InputStream dis) throws IOException {
        byte[] buffer = new byte[1];
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dis.read(buffer, 0, 1);
            data[i] = buffer[0];
        }
        int result = (data[3] & 0xFF) << 24;
        result |= (data[2] & 0xFF) << 16;
        result |= (data[1] & 0xFF) << 8;
        return result |= data[0] & 0xFF;
    }

    private static Object readObject(InputStream dis, String encoding, byte type) throws IOException {
        int length = 0;
        byte[] buffer = new byte[1];
        if (type != 4) {
            length = NetProtocol.readInt(dis);
        }
        if (type == 0 || type == 2) {
            byte[] data = new byte[length];
            for (int i = 0; i < data.length; ++i) {
                dis.read(buffer, 0, 1);
                data[i] = buffer[0];
            }
            if (type == 0) {
                return new String(data, 0, length, encoding);
            }
            return data;
        }
        if (type == 3) {
            int arraySize = NetProtocol.readInt(dis);
            Object[] array = new Object[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                array[i] = NetProtocol.readObject(dis, encoding);
            }
            return array;
        }
        if (type == 4) {
            return new Integer(NetProtocol.readInt(dis));
        }
        return null;
    }

    private static Object readObject(InputStream dis, String encoding) throws IOException {
        byte[] buffer = new byte[1];
        try {
            dis.read(buffer, 0, 1);
            byte type = buffer[0];
            return NetProtocol.readObject(dis, encoding, type);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static class NetPacket {
        public static final byte PTYPE_GAME_ID_REQUEST = 0;
        public static final byte PTYPE_SEND_SCORES_REQUEST = 1;
        public static final byte PTYPE_REQUEST_SCORES_REQUEST = 2;
        public static final byte PTYPE_USER_POSITION_REQUEST = 3;
        public static final byte PTYPE_PING_REQUEST = 4;
        public static final byte PTYPE_REQUEST_FACEBOOK_REQUEST = 5;
        public static final byte PTYPE_CUSTOM_REQUEST = 6;
        public static final byte PTYPE_GAME_ID_RESPONSE = 0;
        public static final byte PTYPE_SCORES_LIST_RESPONSE = 1;
        public static final byte PTYPE_UID_RESPONSE = 2;
        public static final byte PTYPE_NOTIFICATION_RESPONSE = 3;
        public static final byte PTYPE_CUSTOM_RESPONSE = 4;
        public static final byte PTYPE_INCORRECT_USERNAME_RESPONSE = 5;
        public static final byte PTYPE_NULL_RESPONSE = -1;
        public static final byte VIEW_SCORES_DESC = 0;
        public static final byte VIEW_SCORES_ASC = 1;
        public static final byte VIEW_NEIGHBOURS = 2;
        public static final byte VIEW_WEEKLY_DESC = 3;
        public static final byte VIEW_WEEKLY_ASC = 4;
        public static final byte VIEW_MONTHLY_DESC = 5;
        public static final byte VIEW_MONTHLY_ASC = 6;
        public static final byte VIEW_FB_DESC = 7;
        public static final byte VIEW_FB_ASC = 8;
        public byte type;
        public Object[] data;

        public NetPacket() {
        }

        public NetPacket(byte type, Object[] data) {
            this.type = type;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NetPacket)) {
                return false;
            }
            NetPacket p = (NetPacket)o;
            if (this.type != p.type) {
                return false;
            }
            if (this.data == null && p.data == null) {
                return true;
            }
            if (this.data == null || p.data == null) {
                return false;
            }
            if (this.data.length != p.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                Object o1 = this.data[i];
                Object o2 = p.data[i];
                if (o1.equals(o2)) continue;
                return false;
            }
            return true;
        }
    }
}

