/*
 * Decompiled with CFR 0.152.
 */
public class mMath {
    public static final double log10 = 2.302585092994046;
    public static final double ln05 = -0.6931471805599453;
    public static final double e = Math.E;
    public static final double sq2p1 = 2.414213562373095;
    public static final double sq2m1 = 0.41421356237309503;
    public static final double p4 = 16.15364129822302;
    public static final double p3 = 268.42548195503974;
    public static final double p2 = 1153.029351540485;
    public static final double p1 = 1780.406316433197;
    public static final double p0 = 896.7859740366387;
    public static final double q4 = 58.95697050844462;
    public static final double q3 = 536.2653740312153;
    public static final double q2 = 1666.7838148816338;
    public static final double q1 = 2079.33497444541;
    public static final double q0 = 896.7859740366387;
    public static final double PIO2 = 1.5707963267948966;
    public static final double nan = Double.NaN;

    private static float sqr(float x) {
        return x * x;
    }

    private static double sqr(double x) {
        return x * x;
    }

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        if (arg < 0.41421356237309503) {
            return mMath.mxatan(arg);
        }
        if (arg > 2.414213562373095) {
            return 1.5707963267948966 - mMath.mxatan(1.0 / arg);
        }
        return 0.7853981633974483 + mMath.mxatan((arg - 1.0) / (arg + 1.0));
    }

    public static double atan(double arg) {
        if (arg > 0.0) {
            return mMath.msatan(arg);
        }
        return -mMath.msatan(-arg);
    }

    public static double atan2(double arg1, double arg2) {
        if (arg1 + arg2 == arg1) {
            if (arg1 >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        arg1 = mMath.atan(arg1 / arg2);
        if (arg2 < 0.0) {
            if (arg1 <= 0.0) {
                return arg1 + Math.PI;
            }
            return arg1 - Math.PI;
        }
        return arg1;
    }

    public static double asin(double arg) {
        int sign = 0;
        if (arg < 0.0) {
            arg = -arg;
            ++sign;
        }
        if (arg > 1.0) {
            return Double.NaN;
        }
        double temp = Math.sqrt(1.0 - arg * arg);
        temp = arg > 0.7 ? 1.5707963267948966 - mMath.atan(temp / arg) : mMath.atan(arg / temp);
        if (sign > 0) {
            temp = -temp;
        }
        return temp;
    }

    public static double acos(double arg) {
        if (arg > 1.0 || arg < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - mMath.asin(arg);
    }

    public static double exp(double x) {
        boolean neg;
        if (x == 0.0) {
            return 1.0;
        }
        boolean bl = neg = x < 0.0;
        if (neg) {
            x = -x;
        }
        double d1 = 1.0;
        double d2 = x;
        for (int i = 2; i < 50; ++i) {
            d1 += d2;
            d2 = d2 * x / (double)i;
        }
        if (neg) {
            return 1.0 / d1;
        }
        return d1;
    }

    private static double mlog(double x) {
        double y;
        if (x <= 0.0) {
            return Double.NaN;
        }
        double val = 0.0;
        int add = 0;
        while (x > 0.0 && x <= 1.0) {
            x *= 2.0;
            ++add;
        }
        --add;
        double y1 = (x /= 2.0) - 1.0;
        double y2 = x + 1.0;
        double k = y = y1 / y2;
        y2 = k * y;
        for (long i = 1L; i < 50L; i += 2L) {
            val += k / (double)i;
            k *= y2;
        }
        val *= 2.0;
        for (int i = 0; i < add; ++i) {
            val += -0.6931471805599453;
        }
        return val;
    }

    public static double ln(double x) {
        if (x <= 0.0) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x > 1.0) {
            return -mMath.mlog(1.0 / x);
        }
        return mMath.mlog(x);
    }

    public static double log(double x) {
        return mMath.ln(x) / 2.302585092994046;
    }

    public static double pow(double x, double y) {
        if (y == 0.0) {
            return 1.0;
        }
        if (y == 1.0) {
            return x;
        }
        if (x == 0.0) {
            return 0.0;
        }
        if (x == 1.0) {
            return 1.0;
        }
        long l = (long)Math.floor(y);
        if (y == (double)l) {
            boolean neg = false;
            if (y < 0.0) {
                neg = true;
            }
            double result = x;
            for (long i = 1L; i < (neg ? -l : l); ++i) {
                result *= x;
            }
            if (neg) {
                return 1.0 / result;
            }
            return result;
        }
        if (x > 0.0) {
            return mMath.exp(y * mMath.ln(x));
        }
        return Double.NaN;
    }

    public static final double sin(double a) {
        return Math.sin(a);
    }

    public static final double cos(double a) {
        return Math.cos(a);
    }

    public static double invSqrt(double x) {
        return 1.0 / Math.sqrt(x);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static final double toDegrees(double a) {
        return Math.toDegrees(a);
    }

    public static final double toRadians(double a) {
        return Math.toRadians(a);
    }
}

